/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.java.awt.geom.Point2DDouble;
import salvo.jesus.graph.visual.AbstractVisualGraphComponent;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.layout.GraphLayoutManager;

public class VisualEdge
extends AbstractVisualGraphComponent {
    private VisualVertex visualVertexA;
    private VisualVertex visualVertexB;
    int linetype = 1;
    static final int STRAIGHT_LINE = 1;
    static final int ORTHOGONAL_LINE = 2;
    private Point2DDouble fromPortAssignment = new Point2DDouble(-1.0, -1.0);
    private Point2DDouble toPortAssignment = new Point2DDouble(-1.0, -1.0);

    public VisualEdge(Edge edge, VisualGraph vGraph) {
        this.component = edge;
        this.painter = vGraph.getVisualEdgePainterFactory().getPainter(this);
        this.visualVertexA = vGraph.getVisualVertex(edge.getVertexA());
        this.visualVertexB = vGraph.getVisualVertex(edge.getVertexB());
        this.drawpath = new GeneralPath();
        this.setOutlinecolor(Color.blue);
        this.setFillcolor(Color.blue);
        this.visualGraph = vGraph;
    }

    public Edge getEdge() {
        return (Edge)this.component;
    }

    public VisualVertex getVisualVertexA() {
        return this.visualVertexA;
    }

    public VisualVertex getVisualVertexB() {
        return this.visualVertexB;
    }

    protected void setLinetype(int linetype) {
        this.linetype = linetype;
    }

    public void setOrthogonalLine() {
        this.setLinetype(2);
    }

    public void setStraightLine() {
        this.setLinetype(1);
    }

    public void setFromPortAssignment(Point2D newport) {
        this.fromPortAssignment.setLocation(newport);
    }

    public void setToPortAssignment(Point2D newport) {
        this.toPortAssignment.setLocation(newport);
    }

    public Point2D.Double getFromPortAssignment() {
        return this.fromPortAssignment;
    }

    public Point2D.Double getToPortAssignment() {
        return this.toPortAssignment;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public double ptSegDist(int x, int y) {
        double[] edgesegment = new double[6];
        double[] previouspoint = new double[2];
        double[] currentpoint = new double[2];
        double distance = 0.0;
        boolean firstSegment = true;
        PathIterator edgepathiterator = this.drawpath.getPathIterator(null);
        while (!edgepathiterator.isDone()) {
            double currdistance;
            previouspoint[0] = currentpoint[0];
            previouspoint[1] = currentpoint[1];
            int segmenttype = edgepathiterator.currentSegment(edgesegment);
            switch (segmenttype) {
                case 0: 
                case 1: {
                    currentpoint[0] = edgesegment[0];
                    currentpoint[1] = edgesegment[1];
                    break;
                }
                case 2: {
                    currentpoint[0] = edgesegment[2];
                    currentpoint[1] = edgesegment[3];
                    break;
                }
                case 3: {
                    currentpoint[0] = edgesegment[4];
                    currentpoint[1] = edgesegment[5];
                }
            }
            if ((segmenttype == 1 || segmenttype == 2 || segmenttype == 3) && ((currdistance = Line2D.ptSegDist(previouspoint[0], previouspoint[1], currentpoint[0], currentpoint[1], x, y)) < distance || firstSegment)) {
                firstSegment = false;
                distance = currdistance;
            }
            edgepathiterator.next();
        }
        return distance;
    }

    public void paint(Graphics2D g2d, GraphLayoutManager layoutmanager) {
        this.painter.paint(this, g2d);
    }

    @Override
    public void rescale() {
    }

    public float getEdgeLength(VisualEdge vEdge, Point fromPoint, Point toPoint) {
        GeneralPath gPath = vEdge.getGeneralPath();
        PathIterator iterator = gPath.getPathIterator(null);
        float[] edgeSegment = new float[6];
        float edgeLength = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        boolean firstPointInitialized = false;
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(edgeSegment);
            switch (segmentType) {
                case 0: 
                case 1: {
                    x2 = edgeSegment[0];
                    y2 = edgeSegment[1];
                    break;
                }
                case 2: {
                    x2 = edgeSegment[2];
                    y2 = edgeSegment[3];
                    break;
                }
                case 3: {
                    x2 = edgeSegment[4];
                    y2 = edgeSegment[5];
                }
            }
            if (firstPointInitialized) {
                edgeLength = (float)((double)edgeLength + Point2D.distance(x1, y1, x2, y2));
            }
            iterator.next();
            x1 = x2;
            y1 = y2;
            if (firstPointInitialized) continue;
            firstPointInitialized = true;
            fromPoint.setLocation(x1, y1);
        }
        toPoint.setLocation(x2, y2);
        return edgeLength;
    }
}

