/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.drawing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraphComponent;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.drawing.VisualEdgePainter;
import salvo.jesus.graph.visual.layout.GraphLayoutManager;

public class VisualEdgePainterImpl
implements VisualEdgePainter {
    @Override
    public void paint(VisualGraphComponent component, Graphics2D g2d) {
        VisualEdge vEdge = (VisualEdge)component;
        VisualVertex visualVertexA = vEdge.getVisualVertexA();
        VisualVertex visualVertexB = vEdge.getVisualVertexB();
        GraphLayoutManager layoutmanager = vEdge.getVisualGraph().getGraphLayoutManager();
        GeneralPath drawPath = vEdge.getGeneralPath();
        if (layoutmanager == null || layoutmanager != null && !layoutmanager.isInitialized()) {
            Rectangle fromvertexBounds = visualVertexA.getBounds();
            Rectangle tovertexBounds = visualVertexB.getBounds();
            drawPath.reset();
            drawPath.moveTo((float)fromvertexBounds.getCenterX(), (float)fromvertexBounds.getCenterY());
            drawPath.lineTo((float)tovertexBounds.getCenterX(), (float)tovertexBounds.getCenterY());
        } else {
            layoutmanager.routeEdge(g2d, vEdge);
        }
        g2d.setColor(vEdge.getOutlinecolor());
        g2d.draw(drawPath);
        this.paintText(vEdge, g2d);
    }

    private void paintText(VisualEdge vEdge, Graphics2D g2d) {
        Point fromPoint = new Point();
        Point toPoint = new Point();
        GeneralPath gPath = vEdge.getGeneralPath();
        PathIterator iterator = gPath.getPathIterator(null);
        float[] edgeSegment = new float[6];
        double currentLength = 0.0;
        float cumulativeLength = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        boolean firstPointInitialized = false;
        float edgeLength = vEdge.getEdgeLength(vEdge, fromPoint, toPoint);
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(edgeSegment);
            switch (segmentType) {
                case 0: 
                case 1: {
                    x2 = edgeSegment[0];
                    y2 = edgeSegment[1];
                    break;
                }
                case 2: {
                    x2 = edgeSegment[2];
                    y2 = edgeSegment[3];
                    break;
                }
                case 3: {
                    x2 = edgeSegment[4];
                    y2 = edgeSegment[5];
                }
            }
            if (firstPointInitialized) {
                currentLength = Point2D.distance(x1, y1, x2, y2);
                cumulativeLength = (float)((double)cumulativeLength + currentLength);
            }
            iterator.next();
            if (cumulativeLength >= edgeLength / 2.0f || cumulativeLength >= edgeLength) {
                double ratio = ((double)(edgeLength / 2.0f) - ((double)cumulativeLength - currentLength)) / currentLength;
                FontMetrics fontMetrics = vEdge.getFontMetrics();
                this.paintText(g2d, vEdge.getFont(), vEdge.getFontcolor(), vEdge.getLabel(), (float)(fromPoint.getX() < toPoint.getX() ? (double)x1 + (double)Math.abs(x2 - x1) * ratio : (double)x1 - (double)Math.abs(x2 - x1) * ratio) - (float)(fontMetrics.stringWidth(vEdge.getLabel()) / 2), (float)(fromPoint.getY() < toPoint.getY() ? (double)y1 + (double)Math.abs(y2 - y1) * ratio : (double)y1 - (double)Math.abs(y2 - y1) * ratio));
                break;
            }
            x1 = x2;
            y1 = y2;
            if (firstPointInitialized) continue;
            firstPointInitialized = true;
        }
    }

    @Override
    public void paintText(Graphics2D g2d, Font font, Color fontColor, String text, float x, float y) {
        g2d.setFont(font);
        g2d.setColor(fontColor);
        g2d.drawString(text, x, y);
    }
}

