/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.drawing;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import salvo.jesus.graph.visual.VisualGraphComponent;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.drawing.VisualVertexPainter;

public class VisualVertexPainterImpl
implements VisualVertexPainter {
    private double topBottomMargin = 5.0;
    private double leftRightMargin = 5.0;
    private static final String newLine = "\n";

    @Override
    public void paint(VisualGraphComponent vg, Graphics2D g2d) {
        this.paintFill(vg, g2d);
        this.paintOutline(vg, g2d);
        this.paintText(vg, g2d);
    }

    @Override
    public void paintOutline(VisualGraphComponent component, Graphics2D g2d) {
        VisualVertex vv = (VisualVertex)component;
        g2d.setColor(vv.getOutlinecolor());
        g2d.draw(vv.getGeneralPath());
    }

    @Override
    public void paintFill(VisualGraphComponent component, Graphics2D g2d) {
        VisualVertex vv = (VisualVertex)component;
        g2d.setColor(vv.getFillcolor());
        g2d.fill(vv.getGeneralPath());
    }

    @Override
    public void paintText(VisualGraphComponent component, Graphics2D g2d) {
        FontMetrics fontMetrics = component.getFontMetrics();
        VisualVertex vv = (VisualVertex)component;
        int line = 1;
        int lineHeight = fontMetrics.getHeight();
        Rectangle2D.Float bounds = (Rectangle2D.Float)vv.getGeneralPath().getBounds2D();
        g2d.setFont(vv.getFont());
        g2d.setColor(vv.getFontcolor());
        StringTokenizer strTokenizer = new StringTokenizer(vv.getLabel(), newLine);
        while (strTokenizer.hasMoreTokens()) {
            g2d.drawString(strTokenizer.nextToken(), (float)((double)bounds.x + this.leftRightMargin + 1.0), (float)((double)bounds.y + this.topBottomMargin + (double)(lineHeight * line) - 2.0));
            ++line;
        }
    }

    @Override
    public void rescale(VisualVertex vv) {
        FontMetrics fontMetrics = vv.getFontMetrics();
        GeneralPath drawPath = vv.getGeneralPath();
        AffineTransform transform = new AffineTransform();
        int height = 0;
        int maxWidth = 0;
        int lineHeight = fontMetrics.getHeight();
        Rectangle2D originalLocation = drawPath.getBounds2D();
        StringTokenizer strTokenizer = new StringTokenizer(vv.getLabel(), newLine);
        while (strTokenizer.hasMoreTokens()) {
            height += lineHeight;
            int width = fontMetrics.stringWidth(strTokenizer.nextToken());
            maxWidth = width > maxWidth ? width : maxWidth;
        }
        double scalex = ((double)maxWidth + this.leftRightMargin * 2.0) / drawPath.getBounds2D().getWidth();
        double scaley = ((double)height + this.topBottomMargin * 2.0) / drawPath.getBounds2D().getHeight();
        transform.scale(scalex, scaley);
        drawPath.transform(transform);
        transform.setToTranslation(originalLocation.getMinX() - drawPath.getBounds2D().getMinX(), originalLocation.getMinY() - drawPath.getBounds2D().getMinY());
        drawPath.transform(transform);
    }
}

