/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.xml;

import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import salvo.jesus.graph.DirectedAcyclicGraph;
import salvo.jesus.graph.DirectedEdge;
import salvo.jesus.graph.DirectedEdgeImpl;
import salvo.jesus.graph.DirectedGraph;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.WeightedEdge;
import salvo.jesus.graph.WeightedEdgeImpl;
import salvo.jesus.graph.WeightedGraph;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.xml.GraphToXMLEventGenerator;
import salvo.jesus.graph.xml.GraphToXMLHandler;
import salvo.jesus.graph.xml.VertexComparator;

public class GraphToXGMMLDOMHandler
implements GraphToXMLHandler {
    protected XMLSerializer serializer;
    private GraphToXMLEventGenerator eventGenerator;
    private GraphToXGMMLDOMHandler delegate;

    public GraphToXGMMLDOMHandler(GraphToXMLEventGenerator eventGenerator, XMLSerializer serializer) {
        this.eventGenerator = eventGenerator;
        this.serializer = serializer;
    }

    @Override
    public void startSerialize(Graph graph) throws IOException {
        this.delegate = new GraphHandler(this.eventGenerator, this.serializer, new CommonHandler(this.eventGenerator, this.serializer));
        this.delegate.startSerialize(graph);
    }

    @Override
    public void startSerialize(VisualGraph vGraph) throws Exception {
        this.delegate = new VisualGraphHandler(this.eventGenerator, this.serializer, new CommonHandler(this.eventGenerator, this.serializer));
        this.delegate.startSerialize(vGraph);
    }

    @Override
    public void serializeVertex(Vertex vertex) {
        this.delegate.serializeVertex(vertex);
    }

    @Override
    public void endSerializeVertex(Vertex vertex) {
        this.delegate.endSerializeVertex(vertex);
    }

    @Override
    public void serializeEdge(Edge edge) {
        this.delegate.serializeEdge(edge);
    }

    @Override
    public void endSerializeEdge(Edge edge) {
        this.delegate.endSerializeEdge(edge);
    }

    @Override
    public void endSerialize() throws IOException {
        this.delegate.endSerialize();
    }

    @Override
    public GraphToXMLEventGenerator getEventGenerator() {
        return this.eventGenerator;
    }

    class VisualGraphHandler
    extends GraphToXGMMLDOMHandler {
        private VisualGraph vGraph;
        private GraphHandler graphHandler;
        private CommonHandler commonHandler;

        public VisualGraphHandler(GraphToXMLEventGenerator eventGenerator, XMLSerializer serializer, CommonHandler commonHandler) {
            super(eventGenerator, serializer);
            this.commonHandler = commonHandler;
            this.graphHandler = new GraphHandler(eventGenerator, serializer, this.commonHandler);
        }

        @Override
        public void startSerialize(VisualGraph vGraph) throws Exception {
            Element attElement;
            this.vGraph = vGraph;
            this.commonHandler.startSerialize(vGraph);
            Element rootElement = this.commonHandler.getRootElement();
            rootElement.setAttribute("Graphic", "1");
            if (vGraph.getVisualVertexPainterFactory() != null) {
                attElement = this.commonHandler.getDocument().createElement("att");
                attElement.setAttribute("name", "vertexPainterFactory");
                attElement.setAttribute("type", "string");
                attElement.setAttribute("value", vGraph.getVisualVertexPainterFactory().getClass().getName());
                rootElement.appendChild(attElement);
            }
            if (vGraph.getVisualEdgePainterFactory() != null) {
                attElement = this.commonHandler.getDocument().createElement("att");
                attElement.setAttribute("name", "edgePainterFactory");
                attElement.setAttribute("type", "string");
                attElement.setAttribute("value", vGraph.getVisualEdgePainterFactory().getClass().getName());
                rootElement.appendChild(attElement);
            }
            if (vGraph.getVisualGraphComponentEditorFactory() != null) {
                attElement = this.commonHandler.getDocument().createElement("att");
                attElement.setAttribute("name", "componentEditorFactory");
                attElement.setAttribute("type", "string");
                attElement.setAttribute("value", vGraph.getVisualGraphComponentEditorFactory().getClass().getName());
                rootElement.appendChild(attElement);
            }
            if (vGraph.getGraphLayoutManager() != null) {
                attElement = this.commonHandler.getDocument().createElement("att");
                attElement.setAttribute("name", "layoutManager");
                attElement.setAttribute("type", "string");
                attElement.setAttribute("value", vGraph.getGraphLayoutManager().getClass().getName());
                rootElement.appendChild(attElement);
            }
        }

        @Override
        public void serializeVertex(Vertex vertex) {
            Document doc = this.commonHandler.getDocument();
            Element rootElement = this.commonHandler.getRootElement();
            TreeMap vertexIDMap = this.commonHandler.getVertexIDMap();
            this.graphHandler.serializeVertex(vertex);
            VisualVertex vVertex = this.vGraph.getVisualVertex(vertex);
            Rectangle2D bounds = vVertex.getBounds2D();
            Element graphicElement = doc.createElement("graphics");
            graphicElement.setAttribute("w", Double.toString(bounds.getWidth()));
            graphicElement.setAttribute("h", Double.toString(bounds.getHeight()));
            graphicElement.setAttribute("font", vVertex.getFont().getName());
            graphicElement.setAttribute("visible", "true");
            graphicElement.setAttribute("fill", Integer.toHexString(vVertex.getFillcolor().getRGB()));
            graphicElement.setAttribute("outline", Integer.toHexString(vVertex.getOutlinecolor().getRGB()));
            Element centerElement = doc.createElement("center");
            centerElement.setAttribute("x", Double.toString(bounds.getCenterX()));
            centerElement.setAttribute("y", Double.toString(bounds.getCenterY()));
            graphicElement.appendChild(centerElement);
            Element attElement = doc.createElement("att");
            attElement.setAttribute("name", "className");
            attElement.setAttribute("type", "string");
            attElement.setAttribute("value", vVertex.getClass().getName());
            graphicElement.appendChild(attElement);
            attElement = doc.createElement("att");
            attElement.setAttribute("name", "painter");
            attElement.setAttribute("type", "string");
            attElement.setAttribute("value", vVertex.getPainter().getClass().getName());
            graphicElement.appendChild(attElement);
            Node vertexNode = rootElement.getLastChild();
            vertexNode.appendChild(graphicElement);
        }

        @Override
        public void endSerializeVertex(Vertex vertex) {
            this.commonHandler.endSerializeVertex(vertex);
        }

        @Override
        public void serializeEdge(Edge edge) {
            Document doc = this.commonHandler.getDocument();
            Element rootElement = this.commonHandler.getRootElement();
            this.graphHandler.serializeEdge(edge);
            VisualEdge vEdge = this.vGraph.getVisualEdge(edge);
            Element graphicElement = doc.createElement("graphics");
            graphicElement.setAttribute("font", vEdge.getFont().getFontName());
            graphicElement.setAttribute("visible", "true");
            graphicElement.setAttribute("fill", Integer.toHexString(vEdge.getFillcolor().getRGB()));
            graphicElement.setAttribute("outline", Integer.toHexString(vEdge.getOutlinecolor().getRGB()));
            Element lineElement = doc.createElement("Line");
            double[] edgeSegment = new double[6];
            PathIterator pathIterator = vEdge.getGeneralPath().getPathIterator(null);
            while (!pathIterator.isDone()) {
                int segmentType = pathIterator.currentSegment(edgeSegment);
                if (segmentType != 4) {
                    Element pointElement = doc.createElement("point");
                    pointElement.setAttribute("x", Double.toString(edgeSegment[0]));
                    pointElement.setAttribute("y", Double.toString(edgeSegment[1]));
                    lineElement.appendChild(pointElement);
                }
                pathIterator.next();
            }
            graphicElement.appendChild(lineElement);
            Element attElement = doc.createElement("att");
            attElement.setAttribute("name", "className");
            attElement.setAttribute("type", "string");
            attElement.setAttribute("value", vEdge.getClass().getName());
            graphicElement.appendChild(attElement);
            attElement = doc.createElement("att");
            attElement.setAttribute("name", "painter");
            attElement.setAttribute("type", "string");
            attElement.setAttribute("value", vEdge.getPainter().getClass().getName());
            graphicElement.appendChild(attElement);
            Node edgeNode = rootElement.getLastChild();
            edgeNode.appendChild(graphicElement);
        }

        @Override
        public void endSerializeEdge(Edge edge) {
            this.commonHandler.endSerializeEdge(edge);
        }

        @Override
        public void endSerialize() throws IOException {
            this.commonHandler.endSerialize();
        }
    }

    class GraphHandler
    extends GraphToXGMMLDOMHandler {
        private CommonHandler commonHandler;

        public GraphHandler(GraphToXMLEventGenerator eventGenerator, XMLSerializer serializer, CommonHandler commonHandler) {
            super(eventGenerator, serializer);
            this.commonHandler = commonHandler;
        }

        @Override
        public void startSerialize(Graph graph) throws IOException {
            this.commonHandler.startSerialize(graph);
            Element rootElement = this.commonHandler.getRootElement();
            rootElement.setAttribute("Graphic", "0");
        }

        @Override
        public void serializeVertex(Vertex vertex) {
            Document doc = this.commonHandler.getDocument();
            Element rootElement = this.commonHandler.getRootElement();
            TreeMap vertexIDMap = this.commonHandler.getVertexIDMap();
            Element vertexElement = doc.createElement("node");
            vertexElement.setAttribute("label", vertex.toString());
            vertexElement.setAttribute("id", Long.toString(this.commonHandler.getCurrentIDAttribute()));
            Element attElement = doc.createElement("att");
            attElement.setAttribute("name", "className");
            attElement.setAttribute("value", vertex.getClass().getName());
            attElement.setAttribute("type", "string");
            vertexElement.appendChild(attElement);
            rootElement.appendChild(vertexElement);
        }

        @Override
        public void endSerializeVertex(Vertex vertex) {
            this.commonHandler.endSerializeVertex(vertex);
        }

        @Override
        public void serializeEdge(Edge edge) {
            Document doc = this.commonHandler.getDocument();
            Element rootElement = this.commonHandler.getRootElement();
            TreeMap vertexIDMap = this.commonHandler.getVertexIDMap();
            Element edgeElement = doc.createElement("edge");
            if (edge instanceof DirectedEdgeImpl) {
                DirectedEdge dEdge = (DirectedEdge)edge;
                edgeElement.setAttribute("source", ((Long)vertexIDMap.get(dEdge.getSource())).toString());
                edgeElement.setAttribute("target", ((Long)vertexIDMap.get(dEdge.getSink())).toString());
            } else {
                edgeElement.setAttribute("source", ((Long)vertexIDMap.get(edge.getVertexA())).toString());
                edgeElement.setAttribute("target", ((Long)vertexIDMap.get(edge.getVertexB())).toString());
            }
            edgeElement.setAttribute("label", edge.toString());
            if (edge instanceof WeightedEdgeImpl) {
                edgeElement.setAttribute("weight", Double.toString(((WeightedEdge)edge).getWeight()));
            }
            Element attElement = doc.createElement("att");
            attElement.setAttribute("name", "className");
            attElement.setAttribute("value", edge.getClass().getName());
            attElement.setAttribute("type", "string");
            edgeElement.appendChild(attElement);
            rootElement.appendChild(edgeElement);
        }

        @Override
        public void endSerializeEdge(Edge edge) {
            this.commonHandler.endSerializeEdge(edge);
        }

        @Override
        public void endSerialize() throws IOException {
            this.commonHandler.endSerialize();
        }
    }

    class CommonHandler
    extends GraphToXGMMLDOMHandler {
        private Graph graph;
        private Document doc;
        private Element rootElement;
        private TreeMap vertexIDMap;
        private long idAttribute;

        public CommonHandler(GraphToXMLEventGenerator eventGenerator, XMLSerializer serializer) {
            super(eventGenerator, serializer);
        }

        private Document createDocument(Graph graph) {
            Element attDAGElement;
            DocumentImpl doc = new DocumentImpl();
            this.rootElement = doc.createElement("graph");
            this.rootElement.setAttribute("Vendor", "OpenJGraph");
            this.rootElement.setAttribute("directed", graph instanceof DirectedGraph ? "1" : "0");
            if (graph instanceof DirectedAcyclicGraph) {
                attDAGElement = doc.createElement("att");
                attDAGElement.setAttribute("type", "integer");
                attDAGElement.setAttribute("name", "dag");
                attDAGElement.setAttribute("value", "1");
                this.rootElement.appendChild(attDAGElement);
            }
            if (graph instanceof WeightedGraph) {
                attDAGElement = doc.createElement("att");
                attDAGElement.setAttribute("type", "integer");
                attDAGElement.setAttribute("name", "weighted");
                attDAGElement.setAttribute("value", "1");
                this.rootElement.appendChild(attDAGElement);
            }
            doc.appendChild(this.rootElement);
            Element attElement = doc.createElement("att");
            attElement.setAttribute("name", "graphFactory");
            attElement.setAttribute("value", graph.getGraphFactory().getClass().getName());
            attElement.setAttribute("type", "string");
            this.rootElement.appendChild(attElement);
            attElement = doc.createElement("att");
            attElement.setAttribute("name", "traversal");
            attElement.setAttribute("value", graph.getTraversal().getClass().getName());
            attElement.setAttribute("type", "string");
            this.rootElement.appendChild(attElement);
            return doc;
        }

        @Override
        public void startSerialize(Graph graph) {
            this.doc = this.createDocument(graph);
            this.vertexIDMap = new TreeMap(new VertexComparator());
            this.idAttribute = 1L;
        }

        @Override
        public void startSerialize(VisualGraph vGraph) {
            this.doc = this.createDocument(vGraph.getGraph());
            this.vertexIDMap = new TreeMap(new VertexComparator());
            this.idAttribute = 1L;
        }

        @Override
        public void endSerialize() throws IOException {
            OutputFormat format = new OutputFormat();
            format.setOmitXMLDeclaration(false);
            format.setEncoding("UTF-8");
            format.setIndenting(true);
            format.setDoctype("-//John Punin//DTD graph description//EN", "http://www.cs.rpi.edu/~puninj/XGMML/xgmml.dtd");
            this.serializer.setOutputFormat(format);
            this.serializer.serialize(this.doc);
        }

        @Override
        public void serializeVertex(Vertex vertex) {
        }

        @Override
        public void endSerializeVertex(Vertex vertex) {
            this.vertexIDMap.put(vertex, new Long(this.idAttribute));
            ++this.idAttribute;
        }

        @Override
        public void serializeEdge(Edge edge) {
        }

        @Override
        public void endSerializeEdge(Edge edge) {
        }

        protected Document getDocument() {
            return this.doc;
        }

        protected Element getRootElement() {
            return this.rootElement;
        }

        protected TreeMap getVertexIDMap() {
            return this.vertexIDMap;
        }

        protected long getCurrentIDAttribute() {
            return this.idAttribute;
        }

        protected void incremenetIDAttribute() {
            ++this.idAttribute;
        }
    }
}

