/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.xml.EdgeComparator;
import salvo.jesus.graph.xml.GraphToXMLEventGenerator;
import salvo.jesus.graph.xml.GraphToXMLHandler;

public class GraphToXMLEventGeneratorImpl
implements GraphToXMLEventGenerator {
    ArrayList handlers = new ArrayList();

    @Override
    public void addHandler(GraphToXMLHandler handlerToAdd) {
        this.handlers.add(handlerToAdd);
    }

    @Override
    public void removeHandler(GraphToXMLHandler handlerToRemove) {
        this.handlers.remove(handlerToRemove);
    }

    @Override
    public void serialize(Graph graph) throws Exception {
        TreeSet edgeSet = new TreeSet(new EdgeComparator());
        Iterator vertexIterator = graph.getVerticesIterator();
        this.notifyStartSerialize(graph);
        while (vertexIterator.hasNext()) {
            Vertex vertex = (Vertex)vertexIterator.next();
            this.notifySerializeVertex(vertex);
            edgeSet.addAll(graph.getEdges(vertex));
        }
        for (Edge edge : edgeSet) {
            this.notifySerializeEdge(edge);
        }
        this.notifyEndSerialize();
    }

    @Override
    public void serialize(VisualGraph vGraph) throws Exception {
        Graph graph = vGraph.getGraph();
        TreeSet edgeSet = new TreeSet(new EdgeComparator());
        Iterator vertexIterator = graph.getVerticesIterator();
        this.notifyStartSerialize(vGraph);
        while (vertexIterator.hasNext()) {
            Vertex vertex = (Vertex)vertexIterator.next();
            this.notifySerializeVertex(vertex);
            edgeSet.addAll(graph.getEdges(vertex));
        }
        for (Edge edge : edgeSet) {
            this.notifySerializeEdge(edge);
        }
        this.notifyEndSerialize();
    }

    @Override
    public void notifyStartSerialize(Graph graph) throws Exception {
        for (GraphToXMLHandler handler : this.handlers) {
            handler.startSerialize(graph);
        }
    }

    @Override
    public void notifyStartSerialize(VisualGraph vGraph) throws Exception {
        for (GraphToXMLHandler handler : this.handlers) {
            handler.startSerialize(vGraph);
        }
    }

    @Override
    public void notifySerializeVertex(Vertex vertex) throws Exception {
        for (GraphToXMLHandler handler : this.handlers) {
            handler.serializeVertex(vertex);
            handler.endSerializeVertex(vertex);
        }
    }

    @Override
    public void notifySerializeEdge(Edge edge) throws Exception {
        for (GraphToXMLHandler handler : this.handlers) {
            handler.serializeEdge(edge);
            handler.endSerializeEdge(edge);
        }
    }

    @Override
    public void notifyEndSerialize() throws Exception {
        for (GraphToXMLHandler handler : this.handlers) {
            handler.endSerialize();
        }
    }
}

