/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.xml;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.GeneralPath;
import java.lang.reflect.Constructor;
import org.xml.sax.Attributes;
import salvo.jesus.graph.DirectedAcyclicGraphImpl;
import salvo.jesus.graph.DirectedEdgeImpl;
import salvo.jesus.graph.DirectedGraphImpl;
import salvo.jesus.graph.DirectedWeightedEdgeImpl;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.EdgeImpl;
import salvo.jesus.graph.GraphFactory;
import salvo.jesus.graph.GraphImpl;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.VertexImpl;
import salvo.jesus.graph.WeightedEdgeImpl;
import salvo.jesus.graph.WeightedGraphImpl;
import salvo.jesus.graph.algorithm.GraphTraversal;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.drawing.Painter;
import salvo.jesus.graph.visual.layout.GraphLayoutManager;
import salvo.jesus.graph.xml.StackEntry;
import salvo.jesus.graph.xml.XMLToGraphHandler;

public class XGMMLContentHandler
extends XMLToGraphHandler {
    Vertex vertex;
    Edge edge;
    Vertex vertexA;
    Vertex vertexB;
    boolean graphic = false;
    boolean directed = false;
    boolean directedAcyclic = false;
    boolean weighted = false;
    String graphFactoryClassName;
    String traversalClassName;
    public String className;
    String graphicsClassName;
    String painterClassName;
    String layoutManagerClassName;
    double width;
    double height;
    String fontName;
    Color fillColor;
    Color outlineColor;
    double centerX;
    double centerY;
    GeneralPath path;
    boolean firstPoint;

    @Override
    public void instantiateGraph() throws Exception {
        Object[] constructorArgs;
        Class[] argTypes;
        this.graph = this.directedAcyclic ? new DirectedAcyclicGraphImpl() : (this.weighted ? new WeightedGraphImpl() : (this.directed ? new DirectedGraphImpl() : new GraphImpl()));
        if (this.graphFactoryClassName != null) {
            GraphFactory factory = (GraphFactory)Class.forName(this.graphFactoryClassName).newInstance();
            this.graph.setGraphFactory(factory);
        }
        if (this.traversalClassName != null) {
            Class<?> graphClass = this.directed ? Class.forName("salvo.jesus.graph.DirectedGraph") : Class.forName("salvo.jesus.graph.Graph");
            Class<?> traversalClass = Class.forName(this.traversalClassName);
            argTypes = new Class[]{graphClass};
            Constructor<?> traversalConstructor = traversalClass.getConstructor(argTypes);
            constructorArgs = new Object[]{this.graph};
            GraphTraversal traversal = (GraphTraversal)traversalConstructor.newInstance(constructorArgs);
            this.graph.setTraversal(traversal);
        }
        this.vGraph = new VisualGraph();
        this.vGraph.setGraph(this.graph);
        if (this.graphic) {
            Class<?> layoutClass = Class.forName(this.layoutManagerClassName);
            Class<?> visualGraphClass = Class.forName("salvo.jesus.graph.visual.VisualGraph");
            argTypes = new Class[]{visualGraphClass};
            Constructor<?> layoutConstructor = layoutClass.getConstructor(argTypes);
            constructorArgs = new Object[]{this.vGraph};
            GraphLayoutManager layoutManager = (GraphLayoutManager)layoutConstructor.newInstance(constructorArgs);
            this.vGraph.setGraphLayoutManager(layoutManager);
        }
    }

    @Override
    public void instantiateVertex() throws Exception {
        StackEntry entry = (StackEntry)this.elementStack.peek();
        Attributes attribs = entry.getElementAttributes();
        String label = attribs.getValue("label");
        this.vertex = new VertexImpl(label);
        this.graph.add(this.vertex);
        if (this.graphic) {
            VisualVertex vVertex = new VisualVertex(this.vertex, this.vGraph);
            vVertex.setLocation(this.centerX, this.centerY);
            vVertex.setOutlinecolor(this.outlineColor);
            vVertex.setFillcolor(this.fillColor);
            vVertex.setFont(new Font(this.fontName, 0, 10));
            Class<?> painterClass = Class.forName(this.painterClassName);
            vVertex.setPainter((Painter)painterClass.newInstance());
            this.vGraph.setVisualVertex(this.vertex, vVertex);
        }
        this.mapIDToVertex(attribs.getValue("id"), this.vertex);
    }

    public void startGraphElement(Attributes attribs) {
        String graphic;
        String directed = attribs.getValue("directed");
        if (directed != null && directed.equals("1")) {
            this.directed = true;
        }
        if ((graphic = attribs.getValue("Graphic")) != null && graphic.equals("1")) {
            this.graphic = true;
        }
    }

    public void startAttElement(Attributes attribs) {
        StackEntry entry = (StackEntry)this.elementStack.peek();
        if (entry.getElementName().equals("graph")) {
            if (attribs.getValue("name").equals("weighted") && attribs.getValue("value").equals("1")) {
                this.weighted = true;
            }
            if (attribs.getValue("name").equals("dag") && attribs.getValue("value").equals("1")) {
                this.directedAcyclic = true;
            }
            if (attribs.getValue("name").equals("graphFactory")) {
                this.graphFactoryClassName = attribs.getValue("value");
            }
            if (attribs.getValue("name").equals("traversal")) {
                this.traversalClassName = attribs.getValue("value");
            }
            if (attribs.getValue("name").equals("layoutManager")) {
                this.layoutManagerClassName = attribs.getValue("value");
            }
        }
        if (entry.getElementName().equals("node")) {
            this.processNodeAttElement(attribs);
        }
        if (entry.getElementName().equals("edge")) {
            this.processEdgeAttElement(attribs);
        }
        if (entry.getElementName().equals("graphics")) {
            this.processGraphicsAttElement(attribs);
        }
    }

    public void startNodeElement(Attributes attribs) {
        this.className = null;
    }

    public void endNodeElement() throws Exception {
    }

    public void startEdgeElement(Attributes attribs) {
        this.className = null;
    }

    public void endEdgeElement() throws Exception {
        StackEntry entry = (StackEntry)this.elementStack.peek();
        Attributes attribs = entry.getElementAttributes();
        String source = attribs.getValue("source");
        String target = attribs.getValue("target");
        this.vertexA = (Vertex)this.vertexIDMap.get(source);
        this.vertexB = (Vertex)this.vertexIDMap.get(target);
    }

    public void startGraphicsElement(Attributes attribs) throws Exception {
        if (attribs.getValue("w") != null) {
            this.width = Double.parseDouble(attribs.getValue("w"));
        }
        if (attribs.getValue("h") != null) {
            this.height = Double.parseDouble(attribs.getValue("h"));
        }
        this.fontName = attribs.getValue("font");
        this.fillColor = new Color(Long.valueOf(attribs.getValue("fill"), 16).intValue(), true);
        this.outlineColor = new Color(Long.valueOf(attribs.getValue("outline"), 16).intValue(), true);
    }

    public void startCenterElement(Attributes attribs) throws Exception {
        this.centerX = Double.parseDouble(attribs.getValue("x"));
        this.centerY = Double.parseDouble(attribs.getValue("y"));
    }

    public void startLineElement(Attributes attribs) throws Exception {
        this.path = new GeneralPath();
        this.firstPoint = true;
    }

    public void startPointElement(Attributes attribs) throws Exception {
        if (this.firstPoint) {
            this.path.moveTo(Float.parseFloat(attribs.getValue("x")), Float.parseFloat(attribs.getValue("y")));
            this.firstPoint = false;
        } else {
            this.path.lineTo(Float.parseFloat(attribs.getValue("x")), Float.parseFloat(attribs.getValue("y")));
        }
    }

    @Override
    public void instantiateEdge() throws Exception {
        Attributes attribs;
        StackEntry entry;
        if ((this.directed || this.directedAcyclic) && !this.weighted) {
            this.edge = new DirectedEdgeImpl(this.vertexA, this.vertexB);
        } else if (this.weighted && !this.directed && !this.directedAcyclic) {
            entry = (StackEntry)this.elementStack.peek();
            attribs = entry.getElementAttributes();
            String weight = attribs.getValue("weight");
            this.edge = new WeightedEdgeImpl(this.vertexA, this.vertexB, new Double(weight));
        } else if ((this.directed || this.directedAcyclic) && this.weighted) {
            entry = (StackEntry)this.elementStack.peek();
            attribs = entry.getElementAttributes();
            String weight = attribs.getValue("weight");
            this.edge = new DirectedWeightedEdgeImpl(this.vertexA, this.vertexB, new Double(weight));
        } else {
            this.edge = new EdgeImpl(this.vertexA, this.vertexB);
        }
        this.graph.addEdge(this.edge);
        if (this.graphic) {
            VisualEdge vEdge = new VisualEdge(this.edge, this.vGraph);
            vEdge.setFillcolor(this.fillColor);
            vEdge.setOutlinecolor(this.outlineColor);
            vEdge.setFont(new Font(this.fontName, 0, 10));
            vEdge.setGeneralPath(this.path);
            Class<?> painterClass = Class.forName(this.painterClassName);
            vEdge.setPainter((Painter)painterClass.newInstance());
            this.vGraph.setVisualEdge(this.edge, vEdge);
        }
    }

    public void processNodeAttElement(Attributes attribs) {
        if (attribs.getValue("name").equals("className")) {
            this.className = attribs.getValue("value");
        }
    }

    public void processEdgeAttElement(Attributes attribs) {
        if (attribs.getValue("name").equals("className")) {
            this.className = attribs.getValue("value");
        }
    }

    public void processGraphicsAttElement(Attributes attribs) {
        if (attribs.getValue("name").equals("className")) {
            this.graphicsClassName = attribs.getValue("value");
        }
        if (attribs.getValue("name").equals("painter")) {
            this.painterClassName = attribs.getValue("value");
        }
    }

    @Override
    public String getVertexElementName() {
        return "node";
    }

    @Override
    public String getEdgeElementName() {
        return "edge";
    }
}

