/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.plugins.hibernate;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;

class SimpleConnectionProvider
implements ConnectionProvider {
    private final Log log;
    private Connection connection;

    SimpleConnectionProvider(Log log) {
        this.log = log;
    }

    void open(ClassLoaderService classLoaderService, Properties properties) throws MojoFailureException {
        String driver = properties.getProperty("hibernate.connection.driver_class");
        String url = properties.getProperty("hibernate.connection.url");
        String user = properties.getProperty("hibernate.connection.username");
        String password = properties.getProperty("hibernate.connection.password");
        if (driver == null || url == null) {
            this.log.info((CharSequence)"No connection opened, because connection information is incomplete");
            this.log.info((CharSequence)("Driver-Class: " + driver));
            this.log.info((CharSequence)("URL: " + url));
            return;
        }
        try {
            Class driverClass = classLoaderService.classForName(driver);
            this.log.debug((CharSequence)("Registering JDBC-driver " + driverClass.getName()));
            DriverManager.registerDriver(new DriverProxy((Driver)driverClass.newInstance()));
            this.log.debug((CharSequence)("Opening JDBC-connection to " + url + " as " + user + " with password " + password));
            this.connection = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            this.log.info((CharSequence)("Could not open the JDBC-connection: " + e.getMessage()));
        }
    }

    void close() {
        if (this.connection == null) {
            return;
        }
        this.log.debug((CharSequence)"Closing the JDBC-connection.");
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.log.error((CharSequence)("Error while closing the JDBC-connection: " + e.getMessage()));
        }
    }

    public Connection getConnection() throws SQLException {
        this.log.debug((CharSequence)"Connection aquired.");
        if (this.connection == null) {
            throw new SQLException("No connection available, because of insufficient connection information!");
        }
        return this.connection;
    }

    public void closeConnection(Connection conn) throws SQLException {
        this.log.debug((CharSequence)"Connection released");
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return false;
    }

    public <T> T unwrap(Class<T> unwrapType) {
        throw new UnsupportedOperationException("Not supported.");
    }

    static final class DriverProxy
    implements Driver {
        private final Driver target;

        DriverProxy(Driver target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
        }

        public Driver getTarget() {
            return this.target;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.target.acceptsURL(url);
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.target.connect(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.target.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.target.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.target.getPropertyInfo(url, info);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.target.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not supported, for backward-compatibility with Java 1.6");
        }

        public String toString() {
            return "Proxy: " + this.target;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DriverProxy)) {
                return false;
            }
            DriverProxy other = (DriverProxy)obj;
            return this.target.equals(other.target);
        }
    }
}

