/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

public class DynamicalTime {
    private static final double[] delta_t = new double[]{124.0, 115.0, 106.0, 98.0, 91.0, 85.0, 79.0, 74.0, 70.0, 65.0, 62.0, 58.0, 55.0, 53.0, 50.0, 48.0, 46.0, 44.0, 42.0, 40.0, 37.0, 35.0, 33.0, 31.0, 28.0, 26.0, 24.0, 22.0, 20.0, 18.0, 16.0, 14.0, 13.0, 12.0, 11.0, 10.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 10.0, 10.0, 10.0, 10.0, 10.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 13.0, 13.0, 13.0, 13.0, 14.0, 14.0, 14.0, 15.0, 15.0, 15.0, 15.0, 16.0, 16.0, 16.0, 16.0, 16.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 16.0, 16.0, 15.0, 14.0, 13.7, 13.1, 12.7, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.3, 12.0, 11.4, 10.6, 9.6, 8.6, 7.5, 6.6, 6.0, 5.7, 5.6, 5.7, 5.9, 6.2, 6.5, 6.8, 7.1, 7.3, 7.5, 7.7, 7.8, 7.9, 7.5, 6.4, 5.4, 2.9, 1.6, -1.0, -2.7, -3.6, -4.7, -5.4, -5.2, -5.5, -5.6, -5.8, -5.9, -6.2, -6.4, -6.1, -4.7, -2.7, 0.0, 2.6, 5.4, 7.7, 10.5, 13.4, 16.0, 18.2, 20.2, 21.2, 22.4, 23.5, 23.9, 24.3, 24.0, 23.9, 23.9, 23.7, 24.0, 24.3, 25.3, 26.2, 27.3, 28.2, 29.1, 30.0, 30.7, 31.4, 32.2, 33.1, 34.0, 35.0, 36.5, 38.3, 40.2, 42.2, 44.5, 46.5, 48.5, 50.5, 52.2, 53.8, 54.9, 55.8, 56.9, 58.3};

    public static double get_dynamical_diff_sh1(double JD) {
        double E = (JD - 2067314.5) / 36525.0;
        double TD = 1830.0 - 405.0 * E + 46.5 * E * E;
        return TD;
    }

    public static double get_dynamical_diff_sh2(double JD) {
        double t = (JD - 2396758.5) / 36525.0;
        double TD = 22.5 * t * t;
        return TD;
    }

    public static double get_dynamical_diff_table(double JD) {
        double TD = 0.0;
        int i = (int)((JD - 2312752.5) / 730.5);
        if (i > delta_t.length - 2) {
            i = delta_t.length - 2;
        }
        double a = delta_t[i + 1] - delta_t[i];
        double b = delta_t[i + 2] - delta_t[i + 1];
        double c = a - b;
        double n = (JD - (2312752.5 + 730.5 * (double)i)) / 730.5;
        TD = delta_t[i + 1] + n / 2.0 * (a + b + n * c);
        return TD;
    }

    public static double get_dynamical_diff_near(double JD) {
        double TD = 0.0;
        double[] delta_T = new double[]{56.86, 63.83, 70.0};
        double a = delta_T[1] - delta_T[0];
        double b = delta_T[2] - delta_T[1];
        double c = b - a;
        double n = (JD - 2451544.5) / 3652.5;
        TD = delta_T[1] + n / 2.0 * (a + b + n * c);
        return TD;
    }

    public static double get_dynamical_diff_other(double JD) {
        double a = JD - 2382148.0;
        a *= a;
        double TD = -15.0 + a / 4.104848E7;
        return TD;
    }

    public static double ln_get_dynamical_time_diff(double JD) {
        double TD = JD < 2067314.5 ? DynamicalTime.get_dynamical_diff_sh1(JD) : (JD >= 2067314.5 && JD < 2305447.5 ? DynamicalTime.get_dynamical_diff_sh2(JD) : (JD >= 2312752.5 && JD < 2448622.5 ? DynamicalTime.get_dynamical_diff_table(JD) : (JD >= 2448622.5 && JD <= 2455197.5 ? DynamicalTime.get_dynamical_diff_near(JD) : DynamicalTime.get_dynamical_diff_other(JD))));
        return TD;
    }

    public static double ln_get_jde(double JD) {
        double secs_in_day = 86400.0;
        double JDE = JD + DynamicalTime.ln_get_dynamical_time_diff(JD) / secs_in_day;
        return JDE;
    }

    public static class year_TD {
        int year;
        double TD;
    }
}

