/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.Constants;
import de.kah2.zodiac.nova4jmt.api.LnEllOrbit;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetMotionBodyCoords;

public class EllipticMotion {
    static final double KEPLER_STEPS = 53.0;

    public static double sgn(double x) {
        if (x == 0.0) {
            return x;
        }
        if (x < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static double ln_solve_kepler(double e, double M) {
        double Eo = Constants.M_PI_2.doubleValue();
        double D = Constants.M_PI_4.doubleValue();
        M = Utility.ln_deg_to_rad(M);
        double F = EllipticMotion.sgn(M);
        M = Math.abs(M) / (Math.PI * 2);
        if ((M = (M - (double)((int)M)) * 2.0 * Math.PI * F) < 0.0) {
            M += Math.PI * 2;
        }
        F = 1.0;
        if (M > Math.PI) {
            F = -1.0;
        }
        if (M > Math.PI) {
            M = Math.PI * 2 - M;
        }
        int i = 0;
        while ((double)i < 53.0) {
            double M1 = Eo - e * Math.sin(Eo);
            Eo += D * EllipticMotion.sgn(M - M1);
            D /= 2.0;
            ++i;
        }
        Eo *= F;
        Eo = Utility.ln_rad_to_deg(Eo);
        return Eo;
    }

    public static double ln_get_ell_mean_anomaly(double n, double delta_JD) {
        return delta_JD * n;
    }

    public static double ln_get_ell_true_anomaly(double e, double E) {
        E = Utility.ln_deg_to_rad(E);
        double v = Math.sqrt((1.0 + e) / (1.0 - e)) * Math.tan(E / 2.0);
        v = 2.0 * Math.atan(v);
        v = Utility.ln_range_degrees(Utility.ln_rad_to_deg(v));
        return v;
    }

    public static double ln_get_ell_radius_vector(double a, double e, double E) {
        return a * (1.0 - e * Math.cos(Utility.ln_deg_to_rad(E)));
    }

    public static double ln_get_ell_smajor_diam(double e, double q) {
        return q / (1.0 - e);
    }

    public static double ln_get_ell_sminor_diam(double e, double a) {
        return a * Math.sqrt(1.0 - e * e);
    }

    public static double ln_get_ell_mean_motion(double a) {
        double q = 0.9856076686;
        return q / (a * Math.sqrt(a));
    }

    public static void ln_get_ell_helio_rect_posn(LnEllOrbit orbit, double JD, LnRectPosn posn) {
        double sin_e = 0.397777156;
        double cos_e = 0.917482062;
        double sin_omega = Math.sin(Utility.ln_deg_to_rad(orbit.omega));
        double cos_omega = Math.cos(Utility.ln_deg_to_rad(orbit.omega));
        double sin_i = Math.sin(Utility.ln_deg_to_rad(orbit.i));
        double cos_i = Math.cos(Utility.ln_deg_to_rad(orbit.i));
        double F = cos_omega;
        double G = sin_omega * cos_e;
        double H = sin_omega * sin_e;
        double P = -sin_omega * cos_i;
        double Q = cos_omega * cos_i * cos_e - sin_i * sin_e;
        double R = cos_omega * cos_i * sin_e + sin_i * cos_e;
        double A = Math.atan2(F, P);
        double B = Math.atan2(G, Q);
        double C = Math.atan2(H, R);
        double a = Math.sqrt(F * F + P * P);
        double b = Math.sqrt(G * G + Q * Q);
        double c = Math.sqrt(H * H + R * R);
        if (orbit.n == 0.0) {
            orbit.n = EllipticMotion.ln_get_ell_mean_motion(orbit.a);
        }
        double M = EllipticMotion.ln_get_ell_mean_anomaly(orbit.n, JD - orbit.JD);
        double E = EllipticMotion.ln_solve_kepler(orbit.e, M);
        double v = EllipticMotion.ln_get_ell_true_anomaly(orbit.e, E);
        double r = EllipticMotion.ln_get_ell_radius_vector(orbit.a, orbit.e, E);
        posn.X = r * a * Math.sin(A + Utility.ln_deg_to_rad(orbit.w + v));
        posn.Y = r * b * Math.sin(B + Utility.ln_deg_to_rad(orbit.w + v));
        posn.Z = r * c * Math.sin(C + Utility.ln_deg_to_rad(orbit.w + v));
    }

    public static void ln_get_ell_geo_rect_posn(LnEllOrbit orbit, double JD, LnRectPosn posn) {
        LnRectPosn p_posn = new LnRectPosn();
        LnRectPosn e_posn = new LnRectPosn();
        LnHelioPosn earth = new LnHelioPosn();
        EllipticMotion.ln_get_ell_helio_rect_posn(orbit, JD, p_posn);
        Earth.ln_get_earth_helio_coords(JD, earth);
        Transform.ln_get_rect_from_helio(earth, e_posn);
        posn.X = e_posn.X - p_posn.X;
        posn.Y = e_posn.Y - p_posn.Y;
        posn.Z = e_posn.Z - p_posn.Z;
    }

    public static void ln_get_ell_body_equ_coords(double JD, LnEllOrbit orbit, LnEquPosn posn) {
        LnRectPosn body_rect_posn = new LnRectPosn();
        LnRectPosn sol_rect_posn = new LnRectPosn();
        EllipticMotion.ln_get_ell_helio_rect_posn(orbit, JD, body_rect_posn);
        Solar.ln_get_solar_geo_coords(JD, sol_rect_posn);
        double dist = Utility.ln_get_rect_distance(body_rect_posn, sol_rect_posn);
        double t = Utility.ln_get_light_time(dist);
        EllipticMotion.ln_get_ell_helio_rect_posn(orbit, JD - t, body_rect_posn);
        double x = sol_rect_posn.X + body_rect_posn.X;
        double y = sol_rect_posn.Y + body_rect_posn.Y;
        double z = sol_rect_posn.Z + body_rect_posn.Z;
        posn.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(Math.atan2(y, x)));
        posn.dec = Utility.ln_rad_to_deg(Math.asin(z / Math.sqrt(x * x + y * y + z * z)));
    }

    public static double ln_get_ell_orbit_len(LnEllOrbit orbit) {
        double b = EllipticMotion.ln_get_ell_sminor_diam(orbit.e, orbit.a);
        double A = (orbit.a + b) / 2.0;
        double G = Math.sqrt(orbit.a * b);
        double H = 2.0 * orbit.a * b / (orbit.a + b);
        return Math.PI * ((21.0 * A - 2.0 * G - 3.0 * H) / 8.0);
    }

    public static double ln_get_ell_orbit_vel(double JD, LnEllOrbit orbit) {
        double r = EllipticMotion.ln_get_ell_body_solar_dist(JD, orbit);
        double V = 1.0 / r - 1.0 / (2.0 * orbit.a);
        V = 42.1219 * Math.sqrt(V);
        return V;
    }

    public static double ln_get_ell_orbit_pvel(LnEllOrbit orbit) {
        double V = 29.7847 / Math.sqrt(orbit.a);
        return V *= Math.sqrt((1.0 + orbit.e) / (1.0 - orbit.e));
    }

    public static double ln_get_ell_orbit_avel(LnEllOrbit orbit) {
        double V = 29.7847 / Math.sqrt(orbit.a);
        return V *= Math.sqrt((1.0 - orbit.e) / (1.0 + orbit.e));
    }

    public static double ln_get_ell_body_solar_dist(double JD, LnEllOrbit orbit) {
        LnRectPosn body_rect_posn = new LnRectPosn();
        LnRectPosn sol_rect_posn = new LnRectPosn();
        EllipticMotion.ln_get_ell_helio_rect_posn(orbit, JD, body_rect_posn);
        sol_rect_posn.X = 0.0;
        sol_rect_posn.Y = 0.0;
        sol_rect_posn.Z = 0.0;
        return Utility.ln_get_rect_distance(body_rect_posn, sol_rect_posn);
    }

    public static double ln_get_ell_body_earth_dist(double JD, LnEllOrbit orbit) {
        LnRectPosn body_rect_posn = new LnRectPosn();
        LnRectPosn earth_rect_posn = new LnRectPosn();
        EllipticMotion.ln_get_ell_geo_rect_posn(orbit, JD, body_rect_posn);
        earth_rect_posn.X = 0.0;
        earth_rect_posn.Y = 0.0;
        earth_rect_posn.Z = 0.0;
        return Utility.ln_get_rect_distance(body_rect_posn, earth_rect_posn);
    }

    public static double ln_get_ell_body_phase_angle(double JD, LnEllOrbit orbit) {
        if (orbit.n == 0.0) {
            orbit.n = EllipticMotion.ln_get_ell_mean_motion(orbit.a);
        }
        double M = EllipticMotion.ln_get_ell_mean_anomaly(orbit.n, JD - orbit.JD);
        double E = EllipticMotion.ln_solve_kepler(orbit.e, M);
        double r = EllipticMotion.ln_get_ell_radius_vector(orbit.a, orbit.e, E);
        double R = EllipticMotion.ln_get_ell_body_earth_dist(JD, orbit);
        double d = EllipticMotion.ln_get_ell_body_solar_dist(JD, orbit);
        double phase = (r * r + d * d - R * R) / (2.0 * r * d);
        return Utility.ln_range_degrees(Math.acos(Utility.ln_deg_to_rad(phase)));
    }

    public static double ln_get_ell_body_elong(double JD, LnEllOrbit orbit) {
        double t = JD - orbit.JD;
        if (orbit.n == 0.0) {
            orbit.n = EllipticMotion.ln_get_ell_mean_motion(orbit.a);
        }
        double M = EllipticMotion.ln_get_ell_mean_anomaly(orbit.n, t);
        double E = EllipticMotion.ln_solve_kepler(orbit.e, M);
        double r = EllipticMotion.ln_get_ell_radius_vector(orbit.a, orbit.e, E);
        double R = Earth.ln_get_earth_solar_dist(JD);
        double d = EllipticMotion.ln_get_ell_body_solar_dist(JD, orbit);
        double elong = (R * R + d * d - r * r) / (2.0 * R * d);
        return Utility.ln_range_degrees(Utility.ln_rad_to_deg(Math.acos(elong)));
    }

    public static int ln_get_ell_body_rst(double JD, LnLnlatPosn observer, LnEllOrbit orbit, LnRstTime rst) {
        return EllipticMotion.ln_get_ell_body_rst_horizon(JD, observer, orbit, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static int ln_get_ell_body_rst_horizon(double JD, LnLnlatPosn observer, LnEllOrbit orbit, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_motion_body_rst_horizon(JD, observer, new IGetMotionBodyCoords<LnEllOrbit>(){

            @Override
            public void get_motion_body_coords(double JD, LnEllOrbit orbit, LnEquPosn posn) {
                EllipticMotion.ln_get_ell_body_equ_coords(JD, orbit, posn);
            }
        }, orbit, horizon, rst);
    }

    public static int ln_get_ell_body_next_rst(double JD, LnLnlatPosn observer, LnEllOrbit orbit, LnRstTime rst) {
        return EllipticMotion.ln_get_ell_body_next_rst_horizon(JD, observer, orbit, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static int ln_get_ell_body_next_rst_horizon(double JD, LnLnlatPosn observer, LnEllOrbit orbit, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_motion_body_next_rst_horizon(JD, observer, new IGetMotionBodyCoords<LnEllOrbit>(){

            @Override
            public void get_motion_body_coords(double JD, LnEllOrbit orbit, LnEquPosn posn) {
                EllipticMotion.ln_get_ell_body_equ_coords(JD, orbit, posn);
            }
        }, orbit, horizon, rst);
    }

    public static int ln_get_ell_body_next_rst_horizon_future(double JD, LnLnlatPosn observer, LnEllOrbit orbit, double horizon, int day_limit, LnRstTime rst) {
        return RiseSet.ln_get_motion_body_next_rst_horizon_future(JD, observer, new IGetMotionBodyCoords<LnEllOrbit>(){

            @Override
            public void get_motion_body_coords(double JD, LnEllOrbit orbit, LnEquPosn posn) {
                EllipticMotion.ln_get_ell_body_equ_coords(JD, orbit, posn);
            }
        }, orbit, horizon, day_limit, rst);
    }

    public static double ln_get_ell_last_perihelion(double epoch_JD, double M, double n) {
        return epoch_JD - M / n;
    }
}

