/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.api.LnDate;
import de.kah2.zodiac.nova4jmt.api.LnZoneDate;
import java.util.Calendar;
import java.util.TimeZone;

public class JulianDay {
    public static double ln_get_julian_day(LnDate date) {
        LnDate local_date = date.copy();
        if (local_date.months < 3) {
            --local_date.years;
            local_date.months += 12;
        }
        int a = local_date.years / 100;
        int b = local_date.years > 1582 || local_date.years == 1582 && (local_date.months > 10 || local_date.months == 10 && local_date.days >= 4) ? 2 - a + a / 4 : 0;
        double days = (double)local_date.days + (double)local_date.hours / 24.0 + (double)local_date.minutes / 1440.0 + local_date.seconds / 86400.0;
        double JD = (double)((int)(365.25 * (double)(local_date.years + 4716)) + (int)(30.6001 * (double)(local_date.months + 1))) + days + (double)b - 1524.5;
        return JD;
    }

    public static int ln_get_day_of_week(LnDate date) {
        double JD = JulianDay.ln_get_julian_day(date);
        int day = (int)(JD += 1.5) % 7;
        return day;
    }

    public static void ln_get_date(double JD, LnDate date) {
        int A;
        double Z = (int)(JD += 0.5);
        double F = JD - Z;
        if (Z < 2299161.0) {
            A = (int)Z;
        } else {
            int a = (int)((Z - 1867216.25) / 36524.25);
            A = (int)(Z + 1.0 + (double)a - (double)(a / 4));
        }
        int B = A + 1524;
        int C = (int)(((double)B - 122.1) / 365.25);
        int D = (int)(365.25 * (double)C);
        int E = (int)((double)(B - D) / 30.6001);
        date.hours = (int)(F * 24.0);
        date.minutes = (int)((F -= (double)date.hours / 24.0) * 1440.0);
        date.seconds = (F -= (double)date.minutes / 1440.0) * 86400.0;
        date.days = B - D - (int)(30.6001 * (double)E);
        date.months = E < 14 ? E - 1 : E - 13;
        date.years = date.months > 2 ? C - 4716 : C - 4715;
    }

    public static void ln_get_date_from_sys(LnDate date) {
        long now = System.currentTimeMillis();
        JulianDay.ln_get_date_from_UTC_milliseconds(date, now);
    }

    public static void ln_get_date_from_cal(LnDate date, Calendar calendar) {
        JulianDay.ln_get_date_from_UTC_milliseconds(date, calendar.getTimeInMillis());
    }

    public static void ln_get_date_from_UTC_milliseconds(LnDate date, long now) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.setTimeInMillis(now);
        c.getTimeInMillis();
        date.seconds = (double)c.get(13) + (double)c.get(14) / 1000.0;
        date.minutes = c.get(12);
        date.hours = c.get(11);
        date.days = c.get(5);
        date.months = c.get(2) + 1;
        date.years = c.get(1);
    }

    public static double ln_get_julian_from_sys() {
        LnDate date = new LnDate();
        JulianDay.ln_get_date_from_sys(date);
        double JD = JulianDay.ln_get_julian_day(date);
        return JD;
    }

    public static int ln_get_date_from_mpc(LnDate date, String mpc_date) {
        if (mpc_date.length() != 5) {
            return -1;
        }
        switch (mpc_date.charAt(0)) {
            case 'I': {
                date.years = 1800;
                break;
            }
            case 'J': {
                date.years = 1900;
                break;
            }
            case 'K': {
                date.years = 2000;
                break;
            }
            default: {
                return -1;
            }
        }
        date.years += Integer.parseInt(mpc_date.substring(1, 3));
        date.months = Integer.parseInt(mpc_date.substring(3, 4), 16);
        date.days = date.months = Integer.parseInt(mpc_date.substring(4, 5), 31);
        date.hours = 0;
        date.minutes = 0;
        date.seconds = 0.0;
        return 0;
    }

    public static double ln_get_julian_from_mpc(String mpc_date) {
        LnDate date = new LnDate();
        JulianDay.ln_get_date_from_mpc(date, mpc_date);
        double JD = JulianDay.ln_get_julian_day(date);
        return JD;
    }

    public static void ln_date_to_zonedate(LnDate date, LnZoneDate zonedate, long gmtoff) {
        LnDate dat = new LnDate();
        double jd = JulianDay.ln_get_julian_day(date);
        JulianDay.ln_get_date(jd += (double)gmtoff / 86400.0, dat);
        zonedate.years = dat.years;
        zonedate.months = dat.months;
        zonedate.days = dat.days;
        zonedate.hours = dat.hours;
        zonedate.minutes = dat.minutes;
        zonedate.seconds = dat.seconds;
        zonedate.gmtoff = gmtoff;
    }

    public static void ln_zonedate_to_date(LnZoneDate zonedate, LnDate date) {
        LnDate dat = new LnDate();
        dat.years = zonedate.years;
        dat.months = zonedate.months;
        dat.days = zonedate.days;
        dat.hours = zonedate.hours;
        dat.minutes = zonedate.minutes;
        dat.seconds = zonedate.seconds;
        double jd = JulianDay.ln_get_julian_day(dat);
        JulianDay.ln_get_date(jd -= (double)zonedate.gmtoff / 86400.0, date);
    }
}

