/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;

public class Precession {
    public static void ln_get_equ_prec(LnEquPosn mean_position, double JD, LnEquPosn position) {
        double dec;
        double mean_ra = Utility.ln_deg_to_rad(mean_position.ra);
        double mean_dec = Utility.ln_deg_to_rad(mean_position.dec);
        double t = (JD - 2451545.0) / 36525.0;
        double t2 = (t *= 2.777777777777778E-4) * t;
        double t3 = t2 * t;
        double zeta = 2306.2181 * t + 0.30188 * t2 + 0.017998 * t3;
        double eta = 2306.2181 * t + 1.09468 * t2 + 0.041833 * t3;
        double theta = 2004.3109 * t - 0.42665 * t2 - 0.041833 * t3;
        zeta = Utility.ln_deg_to_rad(zeta);
        eta = Utility.ln_deg_to_rad(eta);
        theta = Utility.ln_deg_to_rad(theta);
        double A = Math.cos(mean_dec) * Math.sin(mean_ra + zeta);
        double B = Math.cos(theta) * Math.cos(mean_dec) * Math.cos(mean_ra + zeta) - Math.sin(theta) * Math.sin(mean_dec);
        double C = Math.sin(theta) * Math.cos(mean_dec) * Math.cos(mean_ra + zeta) + Math.cos(theta) * Math.sin(mean_dec);
        double ra = Math.atan2(A, B) + eta;
        if (mean_dec > 1.2566370614359172 || mean_dec < -1.2566370614359172) {
            dec = Math.acos(Math.sqrt(A * A + B * B));
            if (mean_dec < 0.0) {
                dec *= -1.0;
            }
        } else {
            dec = Math.asin(C);
        }
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_equ_prec2(LnEquPosn mean_position, double fromJD, double toJD, LnEquPosn position) {
        double dec;
        double mean_ra = Utility.ln_deg_to_rad(mean_position.ra);
        double mean_dec = Utility.ln_deg_to_rad(mean_position.dec);
        double T = (fromJD - 2451545.0) / 36525.0;
        double t = (toJD - fromJD) / 36525.0;
        double T2 = (T *= 2.777777777777778E-4) * T;
        double t2 = (t *= 2.777777777777778E-4) * t;
        double t3 = t2 * t;
        double zeta = (2306.2181 + 1.39656 * T - 1.39E-4 * T2) * t + (0.30188 - 3.44E-4 * T) * t2 + 0.017998 * t3;
        double eta = (2306.2181 + 1.39656 * T - 1.39E-4 * T2) * t + (1.09468 + 6.6E-5 * T) * t2 + 0.018203 * t3;
        double theta = (2004.3109 - 0.8533 * T - 2.17E-4 * T2) * t - (0.42665 + 2.17E-4 * T) * t2 - 0.041833 * t3;
        zeta = Utility.ln_deg_to_rad(zeta);
        eta = Utility.ln_deg_to_rad(eta);
        theta = Utility.ln_deg_to_rad(theta);
        double A = Math.cos(mean_dec) * Math.sin(mean_ra + zeta);
        double B = Math.cos(theta) * Math.cos(mean_dec) * Math.cos(mean_ra + zeta) - Math.sin(theta) * Math.sin(mean_dec);
        double C = Math.sin(theta) * Math.cos(mean_dec) * Math.cos(mean_ra + zeta) + Math.cos(theta) * Math.sin(mean_dec);
        double ra = Math.atan2(A, B) + eta;
        if (mean_dec > 1.2566370614359172 || mean_dec < -1.2566370614359172) {
            dec = Math.acos(Math.sqrt(A * A + B * B));
            if (mean_dec < 0.0) {
                dec *= -1.0;
            }
        } else {
            dec = Math.asin(C);
        }
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_ecl_prec(LnLnlatPosn mean_position, double JD, LnLnlatPosn position) {
    }
}

