/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.Nutation;
import de.kah2.zodiac.nova4jmt.Precession;
import de.kah2.zodiac.nova4jmt.SiderealTime;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnGalPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnHrzPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnNutation;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;

public class Transform {
    public static void ln_get_rect_from_helio(LnHelioPosn object, LnRectPosn position) {
        double sin_e = 0.397777156;
        double cos_e = 0.917482062;
        double cos_B = Math.cos(Utility.ln_deg_to_rad(object.B));
        double cos_L = Math.cos(Utility.ln_deg_to_rad(object.L));
        double sin_B = Math.sin(Utility.ln_deg_to_rad(object.B));
        double sin_L = Math.sin(Utility.ln_deg_to_rad(object.L));
        position.X = object.R * cos_L * cos_B;
        position.Y = object.R * (sin_L * cos_B * cos_e - sin_B * sin_e);
        position.Z = object.R * (sin_L * cos_B * sin_e + sin_B * cos_e);
    }

    public static void ln_get_hrz_from_equ(LnEquPosn object, LnLnlatPosn observer, double JD, LnHrzPosn position) {
        double sidereal = SiderealTime.ln_get_mean_sidereal_time(JD);
        Transform.ln_get_hrz_from_equ_sidereal_time(object, observer, sidereal, position);
    }

    public static void ln_get_hrz_from_equ_sidereal_time(LnEquPosn object, LnLnlatPosn observer, double sidereal, LnHrzPosn position) {
        double ra = Utility.ln_deg_to_rad(object.ra);
        double H = (sidereal *= 0.2617993877991494) + Utility.ln_deg_to_rad(observer.lng) - ra;
        double latitude = Utility.ln_deg_to_rad(observer.lat);
        double declination = Utility.ln_deg_to_rad(object.dec);
        double A = Math.sin(latitude) * Math.sin(declination) + Math.cos(latitude) * Math.cos(declination) * Math.cos(H);
        double h = Math.asin(A);
        position.alt = Utility.ln_rad_to_deg(h);
        double Z = Math.acos(A);
        double Zs = Math.sin(Z);
        if (Math.abs(Zs) < 1.0E-5) {
            position.az = object.dec > 0.0 ? 180.0 : 0.0;
            position.alt = object.dec > 0.0 && observer.lat > 0.0 || object.dec < 0.0 && observer.lat < 0.0 ? 90.0 : -90.0;
            return;
        }
        double As = Math.cos(declination) * Math.sin(H) / Zs;
        double Ac = (Math.sin(latitude) * Math.cos(declination) * Math.cos(H) - Math.cos(latitude) * Math.sin(declination)) / Zs;
        if (Ac == 0.0 && As == 0.0) {
            position.az = object.dec > 0.0 ? 180.0 : 0.0;
            return;
        }
        A = Math.atan2(As, Ac);
        position.az = Utility.ln_range_degrees(Utility.ln_rad_to_deg(A));
    }

    public static void ln_get_equ_from_hrz(LnHrzPosn object, LnLnlatPosn observer, double JD, LnEquPosn position) {
        double A = Utility.ln_deg_to_rad(object.az);
        double h = Utility.ln_deg_to_rad(object.alt);
        double longitude = Utility.ln_deg_to_rad(observer.lng);
        double latitude = Utility.ln_deg_to_rad(observer.lat);
        double H = Math.atan2(Math.sin(A), Math.cos(A) * Math.sin(latitude) + Math.tan(h) * Math.cos(latitude));
        double declination = Math.sin(latitude) * Math.sin(h) - Math.cos(latitude) * Math.cos(h) * Math.cos(A);
        declination = Math.asin(declination);
        double sidereal = SiderealTime.ln_get_apparent_sidereal_time(JD);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg((sidereal *= 0.2617993877991494) - H + longitude));
        position.dec = Utility.ln_rad_to_deg(declination);
    }

    public static void ln_get_equ_from_ecl(LnLnlatPosn object, double JD, LnEquPosn position) {
        LnNutation nutation = new LnNutation();
        new Nutation().ln_get_nutation(JD, nutation);
        nutation.ecliptic = Utility.ln_deg_to_rad(nutation.ecliptic);
        double longitude = Utility.ln_deg_to_rad(object.lng);
        double latitude = Utility.ln_deg_to_rad(object.lat);
        double ra = Math.atan2(Math.sin(longitude) * Math.cos(nutation.ecliptic) - Math.tan(latitude) * Math.sin(nutation.ecliptic), Math.cos(longitude));
        double declination = Math.sin(latitude) * Math.cos(nutation.ecliptic) + Math.cos(latitude) * Math.sin(nutation.ecliptic) * Math.sin(longitude);
        declination = Math.asin(declination);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(declination);
    }

    public static void ln_get_ecl_from_equ(LnEquPosn object, double JD, LnLnlatPosn position) {
        LnNutation nutation = new LnNutation();
        double ra = Utility.ln_deg_to_rad(object.ra);
        double declination = Utility.ln_deg_to_rad(object.dec);
        new Nutation().ln_get_nutation(JD, nutation);
        nutation.ecliptic = Utility.ln_deg_to_rad(nutation.ecliptic);
        double longitude = Math.atan2(Math.sin(ra) * Math.cos(nutation.ecliptic) + Math.tan(declination) * Math.sin(nutation.ecliptic), Math.cos(ra));
        double latitude = Math.sin(declination) * Math.cos(nutation.ecliptic) - Math.cos(declination) * Math.sin(nutation.ecliptic) * Math.sin(ra);
        latitude = Math.asin(latitude);
        position.lat = Utility.ln_rad_to_deg(latitude);
        position.lng = Utility.ln_range_degrees(Utility.ln_rad_to_deg(longitude));
    }

    public static void ln_get_ecl_from_rect(LnRectPosn rect, LnLnlatPosn posn) {
        double t = Math.sqrt(rect.X * rect.X + rect.Y * rect.Y);
        posn.lng = Utility.ln_range_degrees(Utility.ln_rad_to_deg(Math.atan2(rect.X, rect.Y)));
        posn.lat = Utility.ln_rad_to_deg(Math.atan2(t, rect.Z));
    }

    public static void ln_get_equ_from_gal(LnGalPosn gal, LnEquPosn equ) {
        double RAD_27_4 = Utility.ln_deg_to_rad(27.4);
        double SIN_27_4 = Math.sin(RAD_27_4);
        double COS_27_4 = Math.cos(RAD_27_4);
        double l_123 = Utility.ln_deg_to_rad(gal.l - 123.0);
        double cos_l_123 = Math.cos(l_123);
        double rad_gal_b = Utility.ln_deg_to_rad(gal.b);
        double sin_b = Math.sin(rad_gal_b);
        double cos_b = Math.cos(rad_gal_b);
        double y = Math.atan2(Math.sin(l_123), cos_l_123 * SIN_27_4 - sin_b / cos_b * COS_27_4);
        equ.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(y) + 12.25);
        equ.dec = Utility.ln_rad_to_deg(Math.asin(sin_b * SIN_27_4 + cos_b * COS_27_4 * cos_l_123));
    }

    public static void ln_get_equ2000_from_gal(LnGalPosn gal, LnEquPosn equ) {
        Transform.ln_get_equ_from_gal(gal, equ);
        Precession.ln_get_equ_prec2(equ, 2433282.4235, 2451545.0, equ);
    }

    public static void ln_get_gal_from_equ(LnEquPosn equ, LnGalPosn gal) {
        double RAD_27_4 = Utility.ln_deg_to_rad(27.4);
        double SIN_27_4 = Math.sin(RAD_27_4);
        double COS_27_4 = Math.cos(RAD_27_4);
        double ra_192_25 = Utility.ln_deg_to_rad(192.25 - equ.ra);
        double cos_ra_192_25 = Math.cos(ra_192_25);
        double rad_equ_dec = Utility.ln_deg_to_rad(equ.dec);
        double sin_dec = Math.sin(rad_equ_dec);
        double cos_dec = Math.cos(rad_equ_dec);
        double x = Math.atan2(Math.sin(ra_192_25), cos_ra_192_25 * SIN_27_4 - sin_dec / cos_dec * COS_27_4);
        gal.l = Utility.ln_range_degrees(303.0 - Utility.ln_rad_to_deg(x));
        gal.b = Utility.ln_rad_to_deg(Math.asin(sin_dec * SIN_27_4 + cos_dec * COS_27_4 * cos_ra_192_25));
    }

    public static void ln_get_gal_from_equ2000(LnEquPosn equ, LnGalPosn gal) {
        LnEquPosn equ_1950 = new LnEquPosn();
        Precession.ln_get_equ_prec2(equ, 2451545.0, 2433282.4235, equ_1950);
        Transform.ln_get_gal_from_equ(equ_1950, gal);
    }
}

