/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;

public class Vsop87 {
    public static double ln_calc_series(LnVsop[] data, double t) {
        double value = 0.0;
        for (int i = 0; i < data.length; ++i) {
            value += data[i].A * Math.cos(data[i].B + data[i].C * t);
        }
        return value;
    }

    public static void ln_vsop87_to_fk5(LnHelioPosn position, double JD) {
        double T = (JD - 2451545.0) / 36525.0;
        double LL = position.L + (-1.397 - 3.1E-4 * T) * T;
        LL = Utility.ln_deg_to_rad(LL);
        double cos_LL = Math.cos(LL);
        double sin_LL = Math.sin(LL);
        double B = Utility.ln_deg_to_rad(position.B);
        double delta_L = -2.5091666666666666E-5 + 1.0877777777777778E-5 * (cos_LL + sin_LL) * Math.tan(B);
        double delta_B = 1.0877777777777778E-5 * (cos_LL - sin_LL);
        position.L += delta_L;
        position.B += delta_B;
    }

    public static class LnVsop {
        public double A;
        public double B;
        public double C;

        public LnVsop(double a, double b, double c) {
            this.A = a;
            this.B = b;
            this.C = c;
        }
    }
}

