/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.EllipticMotion;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEllOrbit;

public class Asteroid {
    public static double ln_get_asteroid_mag(double JD, LnEllOrbit orbit, double H, double G) {
        double b = EllipticMotion.ln_get_ell_body_phase_angle(JD, orbit);
        b = Utility.ln_deg_to_rad(b);
        if (orbit.n == 0.0) {
            orbit.n = EllipticMotion.ln_get_ell_mean_motion(orbit.a);
        }
        double M = EllipticMotion.ln_get_ell_mean_anomaly(orbit.n, JD - orbit.JD);
        double E = EllipticMotion.ln_solve_kepler(orbit.e, M);
        double r = EllipticMotion.ln_get_ell_radius_vector(orbit.a, orbit.e, E);
        double d = EllipticMotion.ln_get_ell_body_solar_dist(JD, orbit);
        double t1 = Math.exp(-3.33 * Math.pow(Math.tan(b / 2.0), 0.63));
        double t2 = Math.exp(-0.187 * Math.pow(Math.tan(b / 2.0), 1.22));
        return H + 5.0 * Math.log10(r * d) - 2.5 * Math.log10((1.0 - G) * t1 + G * t2);
    }

    public static double ln_get_asteroid_sdiam_km(double H, double A) {
        return 3.13 - 0.2 * H - 0.5 * Math.log10(A);
    }

    public static double ln_get_asteroid_sdiam_arc(double JD, LnEllOrbit orbit, double H, double A) {
        double dist = EllipticMotion.ln_get_ell_body_earth_dist(JD, orbit);
        double d = 3.13 - 0.2 * H - 0.5 * Math.log10(A);
        return 0.0013788 * d / dist;
    }
}

