/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.EllipticMotion;
import de.kah2.zodiac.nova4jmt.ParabolicMotion;
import de.kah2.zodiac.nova4jmt.api.LnEllOrbit;
import de.kah2.zodiac.nova4jmt.api.LnParOrbit;

public class Comet {
    public static double ln_get_ell_comet_mag(double JD, LnEllOrbit orbit, double g, double k) {
        if (orbit.n == 0.0) {
            orbit.n = EllipticMotion.ln_get_ell_mean_motion(orbit.a);
        }
        double M = EllipticMotion.ln_get_ell_mean_anomaly(orbit.n, JD - orbit.JD);
        double E = EllipticMotion.ln_solve_kepler(orbit.e, M);
        double r = EllipticMotion.ln_get_ell_radius_vector(orbit.a, orbit.e, E);
        double d = EllipticMotion.ln_get_ell_body_solar_dist(JD, orbit);
        return g + 5.0 * Math.log10(d) + k * Math.log10(r);
    }

    public static double ln_get_par_comet_mag(double JD, LnParOrbit orbit, double g, double k) {
        double t = JD - orbit.JD;
        double r = ParabolicMotion.ln_get_par_radius_vector(orbit.q, t);
        double d = ParabolicMotion.ln_get_par_body_solar_dist(JD, orbit);
        return g + 5.0 * Math.log10(d) + k * Math.log10(r);
    }
}

