/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.DataReader;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Lunar {
    public static double LN_LUNAR_STANDART_HORIZON = 0.125;
    public static long AU = 0x8EAAEAEL;
    static final double RAD = 206264.80624709636;
    static final double DEG = Math.PI / 180;
    static final double M_PI_2 = 1.5707963267948966;
    static final double PIS2 = 1.5707963267948966;
    static final double ATH = 384747.9806743165;
    static final double A0 = 384747.9806448954;
    static final double AM = 0.074801329518;
    static final double ALPHA = 0.002571881335;
    static final double DTASM = 0.02292188611773368;
    static final double W12 = 8399.684731773914;
    static final double PRECES = 0.024381748353014515;
    static final double C1 = 60.0;
    static final double C2 = 3600.0;
    static final double DELNU = 3.209356158623529E-10;
    static final double DELE = 8.673316755049599E-8;
    static final double DELG = -3.910507151829517E-7;
    static final double DELNP = -3.707809503452549E-11;
    static final double DELEP = -6.243915399009713E-7;
    static final double P1 = 1.0180391E-5;
    static final double P2 = 4.7020439E-7;
    static final double P3 = -5.417367E-10;
    static final double P4 = -2.507948E-12;
    static final double P5 = 4.63486E-15;
    static final double Q1 = -1.13469002E-4;
    static final double Q2 = 1.2372674E-7;
    static final double Q3 = 1.265417E-9;
    static final double Q4 = -1.371808E-12;
    static final double Q5 = -3.20334E-15;
    static double c_JD = 0.0;
    static double c_X = 0.0;
    static double c_Y = 0.0;
    static double c_Z = 0.0;
    static double c_precision = 1.0;
    static double[] W1 = new double[]{3.810344430588308, 8399.684731773914, -2.8547283984772807E-5, 3.201709550047375E-8, -1.5363745554361197E-10};
    static double[] W2 = new double[]{1.4547885323225087, 70.99330481835962, -1.8557504160038375E-4, -2.1839401892941265E-7, 1.0327016221314225E-9};
    static double[] W3 = new double[]{2.1824391972168398, -33.78142635662592, 3.084481601955089E-5, 3.6967043184602116E-8, -1.738541860458796E-10};
    static double[] earth = new double[]{1.753470343150658, 628.3075849621554, -9.793236358412627E-8, 4.363323129985824E-11, 7.272205216643039E-13};
    static double[] peri = new double[]{1.796595523358783, 0.0056297936673156855, 2.5826024792704977E-6, -6.690428799311597E-10, 0.0};
    static double[][] del = new double[][]{{5.198466741027443, 7771.377146811758, -2.8449351621E-5, 3.1973462E-8, -1.54365E-10}, {-0.043125180208125, 628.301955168488, -2.680534843E-6, 7.12676E-10, 7.27E-13}, {2.355555898265799, 8328.691426955555, 1.57027757616E-4, 2.50411114E-7, -1.186339E-9}, {1.627905233371468, 8433.466158130539, -5.9392100004E-5, -4.949948E-9, 2.0217E-11}};
    static double[] zeta = new double[]{3.810344430588308, 8399.709113522267};
    static double[][] p = new double[][]{{4.4026088424029615, 2608.7903141574106}, {3.1761466969075944, 1021.3285546211089}, {1.753470343150658, 628.3075849621554}, {6.203480913399945, 334.06124314922965}, {0.5995464973886735, 52.96909650947205}, {0.8740167565184808, 21.329909543800007}, {5.481293871604991, 7.4781598567143535}, {5.311886286783467, 3.813303563758456}};
    static double[] pre = new double[3];
    private static final MainProblem[] main_elp1;
    private static final MainProblem[] main_elp2;
    private static final MainProblem[] main_elp3;
    private static final EarthPert[] earth_pert_elp4;
    private static final EarthPert[] earth_pert_elp5;
    private static final EarthPert[] earth_pert_elp6;
    private static final EarthPert[] earth_pert_elp7;
    private static final EarthPert[] earth_pert_elp8;
    private static final EarthPert[] earth_pert_elp9;
    private static final PlanetPert[] plan_pert_elp10;
    private static final PlanetPert[] plan_pert_elp11;
    private static final PlanetPert[] plan_pert_elp12;
    private static final PlanetPert[] plan_pert_elp13;
    private static final PlanetPert[] plan_pert_elp14;
    private static final PlanetPert[] plan_pert_elp15;
    private static final PlanetPert[] plan_pert_elp16;
    private static final PlanetPert[] plan_pert_elp17;
    private static final PlanetPert[] plan_pert_elp18;
    private static final PlanetPert[] plan_pert_elp19;
    private static final PlanetPert[] plan_pert_elp20;
    private static final PlanetPert[] plan_pert_elp21;
    private static final TidalEffects[] tidal_effects_elp22;
    private static final TidalEffects[] tidal_effects_elp23;
    private static final TidalEffects[] tidal_effects_elp24;
    private static final TidalEffects[] tidal_effects_elp25;
    private static final TidalEffects[] tidal_effects_elp26;
    private static final TidalEffects[] tidal_effects_elp27;
    private static final MoonPert[] moon_pert_elp28;
    private static final MoonPert[] moon_pert_elp29;
    private static final MoonPert[] moon_pert_elp30;
    private static final RelPert[] rel_pert_elp31;
    private static final RelPert[] rel_pert_elp32;
    private static final RelPert[] rel_pert_elp33;
    private static final PlanSolPert[] plan_sol_pert_elp34;
    private static final PlanSolPert[] plan_sol_pert_elp35;
    private static final PlanSolPert[] plan_sol_pert_elp36;

    public static double sum_series_elp1(double[] t) {
        double result = 0.0;
        for (int j = 0; j < main_elp1.length; ++j) {
            if (!(Math.abs(Lunar.main_elp1[j].A) > pre[0])) continue;
            double tgv = Lunar.main_elp1[j].B[0] + 0.02292188611773368 * Lunar.main_elp1[j].B[4];
            double x = Lunar.main_elp1[j].A + tgv * -6.108450579070763E-11 + Lunar.main_elp1[j].B[1] * -3.910507151829517E-7 + Lunar.main_elp1[j].B[2] * 8.673316755049599E-8 + Lunar.main_elp1[j].B[3] * -6.243915399009713E-7;
            double y = 0.0;
            for (int k = 0; k < 5; ++k) {
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.main_elp1[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp2(double[] t) {
        double result = 0.0;
        for (int j = 0; j < main_elp2.length; ++j) {
            if (!(Math.abs(Lunar.main_elp2[j].A) > pre[1])) continue;
            double tgv = Lunar.main_elp2[j].B[0] + 0.02292188611773368 * Lunar.main_elp2[j].B[4];
            double x = Lunar.main_elp2[j].A + tgv * -6.108450579070763E-11 + Lunar.main_elp2[j].B[1] * -3.910507151829517E-7 + Lunar.main_elp2[j].B[2] * 8.673316755049599E-8 + Lunar.main_elp2[j].B[3] * -6.243915399009713E-7;
            double y = 0.0;
            for (int k = 0; k < 5; ++k) {
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.main_elp2[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp3(double[] t) {
        double result = 0.0;
        for (int j = 0; j < main_elp3.length; ++j) {
            if (!(Math.abs(Lunar.main_elp3[j].A) > pre[2])) continue;
            double tgv = Lunar.main_elp3[j].B[0] + 0.02292188611773368 * Lunar.main_elp3[j].B[4];
            double x = Lunar.main_elp3[j].A + tgv * -6.108450579070763E-11 + Lunar.main_elp3[j].B[1] * -3.910507151829517E-7 + Lunar.main_elp3[j].B[2] * 8.673316755049599E-8 + Lunar.main_elp3[j].B[3] * -6.243915399009713E-7;
            double y = 0.0;
            for (int k = 0; k < 5; ++k) {
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.main_elp3[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y += 1.5707963267948966;
            y = Utility.ln_range_radians2(y);
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp4(double[] t) {
        double result = 0.0;
        for (int j = 0; j < earth_pert_elp4.length; ++j) {
            if (!(Math.abs(Lunar.earth_pert_elp4[j].A) > pre[0])) continue;
            double y = Lunar.earth_pert_elp4[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.earth_pert_elp4[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.earth_pert_elp4[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.earth_pert_elp4[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp5(double[] t) {
        double result = 0.0;
        for (int j = 0; j < earth_pert_elp5.length; ++j) {
            if (!(Math.abs(Lunar.earth_pert_elp5[j].A) > pre[1])) continue;
            double y = Lunar.earth_pert_elp5[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.earth_pert_elp5[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.earth_pert_elp5[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.earth_pert_elp5[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp6(double[] t) {
        double result = 0.0;
        for (int j = 0; j < earth_pert_elp6.length; ++j) {
            if (!(Math.abs(Lunar.earth_pert_elp6[j].A) > pre[2])) continue;
            double y = Lunar.earth_pert_elp6[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.earth_pert_elp6[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.earth_pert_elp6[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.earth_pert_elp6[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp7(double[] t) {
        double result = 0.0;
        for (int j = 0; j < earth_pert_elp7.length; ++j) {
            if (!(Math.abs(Lunar.earth_pert_elp7[j].A) > pre[0])) continue;
            double A = Lunar.earth_pert_elp7[j].A * t[1];
            double y = Lunar.earth_pert_elp7[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.earth_pert_elp7[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.earth_pert_elp7[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp8(double[] t) {
        double result = 0.0;
        for (int j = 0; j < earth_pert_elp8.length; ++j) {
            if (!(Math.abs(Lunar.earth_pert_elp8[j].A) > pre[1])) continue;
            double y = Lunar.earth_pert_elp8[j].O * (Math.PI / 180);
            double A = Lunar.earth_pert_elp8[j].A * t[1];
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.earth_pert_elp8[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.earth_pert_elp8[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp9(double[] t) {
        double result = 0.0;
        for (int j = 0; j < earth_pert_elp9.length; ++j) {
            if (!(Math.abs(Lunar.earth_pert_elp9[j].A) > pre[2])) continue;
            double A = Lunar.earth_pert_elp9[j].A * t[1];
            double y = Lunar.earth_pert_elp9[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.earth_pert_elp9[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.earth_pert_elp9[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp10(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp10.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp10[j].O) > pre[0])) continue;
            double y = Lunar.plan_pert_elp10[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += ((double)Lunar.plan_pert_elp10[j].ipla[8] * del[0][k] + (double)Lunar.plan_pert_elp10[j].ipla[9] * del[2][k] + (double)Lunar.plan_pert_elp10[j].ipla[10] * del[3][k]) * t[k];
                for (int i = 0; i < 8; ++i) {
                    y += (double)Lunar.plan_pert_elp10[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.plan_pert_elp10[j].O * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp11(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp11.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp11[j].O) > pre[1])) continue;
            double y = Lunar.plan_pert_elp11[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += ((double)Lunar.plan_pert_elp11[j].ipla[8] * del[0][k] + (double)Lunar.plan_pert_elp11[j].ipla[9] * del[2][k] + (double)Lunar.plan_pert_elp11[j].ipla[10] * del[3][k]) * t[k];
                for (int i = 0; i < 8; ++i) {
                    y += (double)Lunar.plan_pert_elp11[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.plan_pert_elp11[j].O * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp12(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp12.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp12[j].O) > pre[2])) continue;
            double y = Lunar.plan_pert_elp12[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += ((double)Lunar.plan_pert_elp12[j].ipla[8] * del[0][k] + (double)Lunar.plan_pert_elp12[j].ipla[9] * del[2][k] + (double)Lunar.plan_pert_elp12[j].ipla[10] * del[3][k]) * t[k];
                for (int i = 0; i < 8; ++i) {
                    y += (double)Lunar.plan_pert_elp12[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.plan_pert_elp12[j].O * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp13(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp13.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp13[j].O) > pre[0])) continue;
            double y = Lunar.plan_pert_elp13[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += ((double)Lunar.plan_pert_elp13[j].ipla[8] * del[0][k] + (double)Lunar.plan_pert_elp13[j].ipla[9] * del[2][k] + (double)Lunar.plan_pert_elp13[j].ipla[10] * del[3][k]) * t[k];
                for (int i = 0; i < 8; ++i) {
                    y += (double)Lunar.plan_pert_elp13[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            double x = Lunar.plan_pert_elp13[j].O * t[1];
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp14(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp14.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp14[j].O) > pre[1])) continue;
            double y = Lunar.plan_pert_elp14[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += ((double)Lunar.plan_pert_elp14[j].ipla[8] * del[0][k] + (double)Lunar.plan_pert_elp14[j].ipla[9] * del[2][k] + (double)Lunar.plan_pert_elp14[j].ipla[10] * del[3][k]) * t[k];
                for (int i = 0; i < 8; ++i) {
                    y += (double)Lunar.plan_pert_elp14[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            double x = Lunar.plan_pert_elp14[j].O * t[1];
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp15(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp15.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp15[j].O) > pre[2])) continue;
            double y = Lunar.plan_pert_elp15[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += ((double)Lunar.plan_pert_elp15[j].ipla[8] * del[0][k] + (double)Lunar.plan_pert_elp15[j].ipla[9] * del[2][k] + (double)Lunar.plan_pert_elp15[j].ipla[10] * del[3][k]) * t[k];
                for (int i = 0; i < 8; ++i) {
                    y += (double)Lunar.plan_pert_elp15[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            double x = Lunar.plan_pert_elp15[j].O * t[1];
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp16(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp16.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp16[j].O) > pre[0])) continue;
            double y = Lunar.plan_pert_elp16[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                int i;
                for (i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_pert_elp16[j].ipla[i + 7] * del[i][k] * t[k];
                }
                for (i = 0; i < 7; ++i) {
                    y += (double)Lunar.plan_pert_elp16[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.plan_pert_elp16[j].O * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp17(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp17.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp17[j].O) > pre[1])) continue;
            double y = Lunar.plan_pert_elp17[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                int i;
                for (i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_pert_elp17[j].ipla[i + 7] * del[i][k] * t[k];
                }
                for (i = 0; i < 7; ++i) {
                    y += (double)Lunar.plan_pert_elp17[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.plan_pert_elp17[j].O * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp18(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp18.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp18[j].O) > pre[2])) continue;
            double y = Lunar.plan_pert_elp18[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                int i;
                for (i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_pert_elp18[j].ipla[i + 7] * del[i][k] * t[k];
                }
                for (i = 0; i < 7; ++i) {
                    y += (double)Lunar.plan_pert_elp18[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.plan_pert_elp18[j].O * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp19(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp19.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp19[j].O) > pre[0])) continue;
            double y = Lunar.plan_pert_elp19[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                int i;
                for (i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_pert_elp19[j].ipla[i + 7] * del[i][k] * t[k];
                }
                for (i = 0; i < 7; ++i) {
                    y += (double)Lunar.plan_pert_elp19[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            double x = Lunar.plan_pert_elp19[j].O * t[1];
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp20(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp20.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp20[j].O) > pre[1])) continue;
            double y = Lunar.plan_pert_elp20[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                int i;
                for (i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_pert_elp20[j].ipla[i + 7] * del[i][k] * t[k];
                }
                for (i = 0; i < 7; ++i) {
                    y += (double)Lunar.plan_pert_elp20[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            double x = Lunar.plan_pert_elp20[j].O * t[1];
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp21(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_pert_elp21.length; ++j) {
            if (!(Math.abs(Lunar.plan_pert_elp21[j].O) > pre[2])) continue;
            double y = Lunar.plan_pert_elp21[j].theta * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                int i;
                for (i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_pert_elp21[j].ipla[i + 7] * del[i][k] * t[k];
                }
                for (i = 0; i < 7; ++i) {
                    y += (double)Lunar.plan_pert_elp21[j].ipla[i] * p[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            double x = Lunar.plan_pert_elp21[j].O * t[1];
            result += x * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp22(double[] t) {
        double result = 0.0;
        for (int j = 0; j < tidal_effects_elp22.length; ++j) {
            if (!(Math.abs(Lunar.tidal_effects_elp22[j].A) > pre[0])) continue;
            double y = Lunar.tidal_effects_elp22[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.tidal_effects_elp22[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.tidal_effects_elp22[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.tidal_effects_elp22[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp23(double[] t) {
        double result = 0.0;
        for (int j = 0; j < tidal_effects_elp23.length; ++j) {
            if (!(Math.abs(Lunar.tidal_effects_elp23[j].A) > pre[1])) continue;
            double y = Lunar.tidal_effects_elp23[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.tidal_effects_elp23[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.tidal_effects_elp23[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.tidal_effects_elp23[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp24(double[] t) {
        double result = 0.0;
        for (int j = 0; j < tidal_effects_elp24.length; ++j) {
            if (!(Math.abs(Lunar.tidal_effects_elp24[j].A) > pre[2])) continue;
            double y = Lunar.tidal_effects_elp24[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.tidal_effects_elp24[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.tidal_effects_elp24[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.tidal_effects_elp24[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp25(double[] t) {
        double result = 0.0;
        for (int j = 0; j < tidal_effects_elp25.length; ++j) {
            if (!(Math.abs(Lunar.tidal_effects_elp25[j].A) > pre[0])) continue;
            double A = Lunar.tidal_effects_elp25[j].A * t[1];
            double y = Lunar.tidal_effects_elp25[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.tidal_effects_elp25[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.tidal_effects_elp25[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp26(double[] t) {
        double result = 0.0;
        for (int j = 0; j < tidal_effects_elp26.length; ++j) {
            if (!(Math.abs(Lunar.tidal_effects_elp26[j].A) > pre[1])) continue;
            double A = Lunar.tidal_effects_elp26[j].A * t[1];
            double y = Lunar.tidal_effects_elp26[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.tidal_effects_elp26[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.tidal_effects_elp26[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp27(double[] t) {
        double result = 0.0;
        for (int j = 0; j < tidal_effects_elp27.length; ++j) {
            if (!(Math.abs(Lunar.tidal_effects_elp27[j].A) > pre[2])) continue;
            double A = Lunar.tidal_effects_elp27[j].A * t[1];
            double y = Lunar.tidal_effects_elp27[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.tidal_effects_elp27[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.tidal_effects_elp27[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp28(double[] t) {
        double result = 0.0;
        for (int j = 0; j < moon_pert_elp28.length; ++j) {
            if (!(Math.abs(Lunar.moon_pert_elp28[j].A) > pre[0])) continue;
            double y = Lunar.moon_pert_elp28[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.moon_pert_elp28[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.moon_pert_elp28[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.moon_pert_elp28[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp29(double[] t) {
        double result = 0.0;
        for (int j = 0; j < moon_pert_elp29.length; ++j) {
            if (!(Math.abs(Lunar.moon_pert_elp29[j].A) > pre[1])) continue;
            double y = Lunar.moon_pert_elp29[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.moon_pert_elp29[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.moon_pert_elp29[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.moon_pert_elp29[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp30(double[] t) {
        double result = 0.0;
        for (int j = 0; j < moon_pert_elp30.length; ++j) {
            if (!(Math.abs(Lunar.moon_pert_elp30[j].A) > pre[2])) continue;
            double y = Lunar.moon_pert_elp30[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.moon_pert_elp30[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.moon_pert_elp30[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.moon_pert_elp30[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp31(double[] t) {
        double result = 0.0;
        for (int j = 0; j < rel_pert_elp31.length; ++j) {
            if (!(Math.abs(Lunar.rel_pert_elp31[j].A) > pre[0])) continue;
            double y = Lunar.rel_pert_elp31[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.rel_pert_elp31[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.rel_pert_elp31[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.rel_pert_elp31[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp32(double[] t) {
        double result = 0.0;
        for (int j = 0; j < rel_pert_elp32.length; ++j) {
            if (!(Math.abs(Lunar.rel_pert_elp32[j].A) > pre[1])) continue;
            double y = Lunar.rel_pert_elp32[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.rel_pert_elp32[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.rel_pert_elp32[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.rel_pert_elp32[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp33(double[] t) {
        double result = 0.0;
        for (int j = 0; j < rel_pert_elp33.length; ++j) {
            if (!(Math.abs(Lunar.rel_pert_elp33[j].A) > pre[2])) continue;
            double y = Lunar.rel_pert_elp33[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.rel_pert_elp33[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.rel_pert_elp33[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += Lunar.rel_pert_elp33[j].A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp34(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_sol_pert_elp34.length; ++j) {
            if (!(Math.abs(Lunar.plan_sol_pert_elp34[j].A) > pre[0])) continue;
            double A = Lunar.plan_sol_pert_elp34[j].A * t[2];
            double y = Lunar.plan_sol_pert_elp34[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.plan_sol_pert_elp34[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_sol_pert_elp34[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp35(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_sol_pert_elp35.length; ++j) {
            if (!(Math.abs(Lunar.plan_sol_pert_elp35[j].A) > pre[1])) continue;
            double A = Lunar.plan_sol_pert_elp35[j].A * t[2];
            double y = Lunar.plan_sol_pert_elp35[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.plan_sol_pert_elp35[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_sol_pert_elp35[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static double sum_series_elp36(double[] t) {
        double result = 0.0;
        for (int j = 0; j < plan_sol_pert_elp36.length; ++j) {
            if (!(Math.abs(Lunar.plan_sol_pert_elp36[j].A) > pre[2])) continue;
            double A = Lunar.plan_sol_pert_elp36[j].A * t[2];
            double y = Lunar.plan_sol_pert_elp36[j].O * (Math.PI / 180);
            for (int k = 0; k < 2; ++k) {
                y += (double)Lunar.plan_sol_pert_elp36[j].iz * zeta[k] * t[k];
                for (int i = 0; i < 4; ++i) {
                    y += (double)Lunar.plan_sol_pert_elp36[j].ilu[i] * del[i][k] * t[k];
                }
            }
            y = Utility.ln_range_radians2(y);
            result += A * Math.sin(y);
        }
        return result;
    }

    public static void ln_get_lunar_geo_posn(double JD, LnRectPosn moon, double precision) {
        double[] t = new double[5];
        double[] elp = new double[36];
        if (precision > 0.01) {
            precision = 0.01;
        }
        if (JD == c_JD && precision >= c_precision) {
            moon.X = c_X;
            moon.Y = c_Y;
            moon.Z = c_Z;
            return;
        }
        t[0] = 1.0;
        t[1] = (JD - 2451545.0) / 36525.0;
        t[2] = t[1] * t[1];
        t[3] = t[2] * t[1];
        t[4] = t[3] * t[1];
        Lunar.pre[0] = precision * 206264.80624709636;
        Lunar.pre[1] = precision * 206264.80624709636;
        Lunar.pre[2] = precision * 384747.9806743165;
        elp[0] = Lunar.sum_series_elp1(t);
        elp[1] = Lunar.sum_series_elp2(t);
        elp[2] = Lunar.sum_series_elp3(t);
        elp[3] = Lunar.sum_series_elp4(t);
        elp[4] = Lunar.sum_series_elp5(t);
        elp[5] = Lunar.sum_series_elp6(t);
        elp[6] = Lunar.sum_series_elp7(t);
        elp[7] = Lunar.sum_series_elp8(t);
        elp[8] = Lunar.sum_series_elp9(t);
        elp[9] = Lunar.sum_series_elp10(t);
        elp[10] = Lunar.sum_series_elp11(t);
        elp[11] = Lunar.sum_series_elp12(t);
        elp[12] = Lunar.sum_series_elp13(t);
        elp[13] = Lunar.sum_series_elp14(t);
        elp[14] = Lunar.sum_series_elp15(t);
        elp[15] = Lunar.sum_series_elp16(t);
        elp[16] = Lunar.sum_series_elp17(t);
        elp[17] = Lunar.sum_series_elp18(t);
        elp[18] = Lunar.sum_series_elp19(t);
        elp[19] = Lunar.sum_series_elp20(t);
        elp[20] = Lunar.sum_series_elp21(t);
        elp[21] = Lunar.sum_series_elp22(t);
        elp[22] = Lunar.sum_series_elp23(t);
        elp[23] = Lunar.sum_series_elp24(t);
        elp[24] = Lunar.sum_series_elp25(t);
        elp[25] = Lunar.sum_series_elp26(t);
        elp[26] = Lunar.sum_series_elp27(t);
        elp[27] = Lunar.sum_series_elp28(t);
        elp[28] = Lunar.sum_series_elp29(t);
        elp[29] = Lunar.sum_series_elp30(t);
        elp[30] = Lunar.sum_series_elp31(t);
        elp[31] = Lunar.sum_series_elp32(t);
        elp[32] = Lunar.sum_series_elp33(t);
        elp[33] = Lunar.sum_series_elp34(t);
        elp[34] = Lunar.sum_series_elp35(t);
        elp[35] = Lunar.sum_series_elp36(t);
        double a = elp[0] + elp[3] + elp[6] + elp[9] + elp[12] + elp[15] + elp[18] + elp[21] + elp[24] + elp[27] + elp[30] + elp[33];
        double b = elp[1] + elp[4] + elp[7] + elp[10] + elp[13] + elp[16] + elp[19] + elp[22] + elp[25] + elp[28] + elp[31] + elp[34];
        double c = elp[2] + elp[5] + elp[8] + elp[11] + elp[14] + elp[17] + elp[20] + elp[23] + elp[26] + elp[29] + elp[32] + elp[35];
        a = a / 206264.80624709636 + W1[0] + W1[1] * t[1] + W1[2] * t[2] + W1[3] * t[3] + W1[4] * t[4];
        c = c * 384747.9806448954 / 384747.9806743165;
        double x = c * Math.cos(b /= 206264.80624709636);
        double y = x * Math.sin(a);
        x *= Math.cos(a);
        double z = c * Math.sin(b);
        double pw = (1.0180391E-5 + 4.7020439E-7 * t[1] + -5.417367E-10 * t[2] + -2.507948E-12 * t[3] + 4.63486E-15 * t[4]) * t[1];
        double qw = (-1.13469002E-4 + 1.2372674E-7 * t[1] + 1.265417E-9 * t[2] + -1.371808E-12 * t[3] + -3.20334E-15 * t[4]) * t[1];
        double ra = 2.0 * Math.sqrt(1.0 - pw * pw - qw * qw);
        double pwqw = 2.0 * pw * qw;
        double pw2 = 1.0 - 2.0 * pw * pw;
        double qw2 = 1.0 - 2.0 * qw * qw;
        a = pw2 * x + pwqw * y + (pw *= ra) * z;
        b = pwqw * x + qw2 * y - (qw *= ra) * z;
        c = -pw * x + qw * y + (pw2 + qw2 - 1.0) * z;
        c_JD = JD;
        c_X = moon.X = a;
        c_Y = moon.Y = b;
        c_Z = moon.Z = c;
    }

    public static void ln_get_lunar_equ_coords_prec(double JD, LnEquPosn position, double precision) {
        LnLnlatPosn ecl = new LnLnlatPosn();
        Lunar.ln_get_lunar_ecl_coords(JD, ecl, precision);
        Transform.ln_get_equ_from_ecl(ecl, JD, position);
    }

    public static void ln_get_lunar_equ_coords(double JD, LnEquPosn position) {
        Lunar.ln_get_lunar_equ_coords_prec(JD, position, 0.0);
    }

    public static void ln_get_lunar_ecl_coords(double JD, LnLnlatPosn position, double precision) {
        LnRectPosn moon = new LnRectPosn();
        Lunar.ln_get_lunar_geo_posn(JD, moon, precision);
        position.lng = Math.atan2(moon.Y, moon.X);
        position.lat = Math.atan2(moon.Z, Math.sqrt(moon.X * moon.X + moon.Y * moon.Y));
        position.lng = Utility.ln_range_degrees(Utility.ln_rad_to_deg(position.lng));
        position.lat = Utility.ln_rad_to_deg(position.lat);
    }

    public static double ln_get_lunar_earth_dist(double JD) {
        LnRectPosn moon = new LnRectPosn();
        Lunar.ln_get_lunar_geo_posn(JD, moon, 1.0E-5);
        return Math.sqrt(moon.X * moon.X + moon.Y * moon.Y + moon.Z * moon.Z);
    }

    public static double ln_get_lunar_phase(double JD) {
        double phase = 0.0;
        LnLnlatPosn moon = new LnLnlatPosn();
        LnLnlatPosn sunlp = new LnLnlatPosn();
        Lunar.ln_get_lunar_ecl_coords(JD, moon, 1.0E-4);
        Solar.ln_get_solar_ecl_coords(JD, sunlp);
        double lunar_elong = Math.acos(Math.cos(Utility.ln_deg_to_rad(moon.lat)) * Math.cos(Utility.ln_deg_to_rad(sunlp.lng - moon.lng)));
        double R = Earth.ln_get_earth_solar_dist(JD);
        double delta = Lunar.ln_get_lunar_earth_dist(JD);
        phase = Math.atan2((R *= (double)AU) * Math.sin(lunar_elong), delta - R * Math.cos(lunar_elong));
        return Utility.ln_rad_to_deg(phase);
    }

    public static double ln_get_lunar_disk(double JD) {
        double i = Utility.ln_deg_to_rad(Lunar.ln_get_lunar_phase(JD));
        return (1.0 + Math.cos(i)) / 2.0;
    }

    public static double ln_get_lunar_bright_limb(double JD) {
        LnEquPosn moon = new LnEquPosn();
        LnEquPosn sunlp = new LnEquPosn();
        Lunar.ln_get_lunar_equ_coords(JD, moon);
        Solar.ln_get_solar_equ_coords(JD, sunlp);
        double x = Math.cos(Utility.ln_deg_to_rad(sunlp.dec)) * Math.sin(Utility.ln_deg_to_rad(sunlp.ra - moon.ra));
        double y = Math.sin(Utility.ln_deg_to_rad(sunlp.dec) * Math.cos(Utility.ln_deg_to_rad(moon.dec))) - Math.cos(Utility.ln_deg_to_rad(sunlp.dec)) * Math.sin(Utility.ln_deg_to_rad(moon.dec)) * Math.cos(Utility.ln_deg_to_rad(sunlp.ra - moon.ra));
        double angle = Math.atan2(x, y);
        angle = Utility.ln_range_radians(angle);
        return Utility.ln_rad_to_deg(angle);
    }

    public static int ln_get_lunar_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Lunar.ln_get_lunar_equ_coords(JD, position);
            }
        }, LN_LUNAR_STANDART_HORIZON, rst);
    }

    public static double ln_get_lunar_sdiam(double JD) {
        double So = 3.584734E8;
        double dist = Lunar.ln_get_lunar_earth_dist(JD);
        return So / dist;
    }

    public static double ln_get_lunar_long_asc_node(double JD) {
        double T = (JD - 2451545.0) / 36525.0;
        double omega = 125.0445479;
        double T2 = T * T;
        double T3 = T2 * T;
        double T4 = T3 * T;
        return omega -= 1934.1362891 * T + 0.0020754 * T2 + T3 / 467441.0 - T4 / 6.0616E7;
    }

    public static double ln_get_lunar_long_perigee(double JD) {
        double T = (JD - 2451545.0) / 36525.0;
        double per = 83.3532465;
        double T2 = T * T;
        double T3 = T2 * T;
        double T4 = T3 * T;
        return per += 4069.0137287 * T - 0.01032 * T2 - T3 / 80053.0 + T4 / 1.8999E7;
    }

    static {
        try {
            String line;
            InputStream in = Lunar.class.getResourceAsStream("lunar.data");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String varName = null;
            boolean readingMainProblem = false;
            boolean readingEarthPert = false;
            boolean readingPlanpert = false;
            boolean readingTidalEffects = false;
            boolean readingMoonPert = false;
            boolean readingRelPert = false;
            boolean readingPlanSolPert = false;
            ArrayList<MainProblem> mainProblems = new ArrayList<MainProblem>();
            ArrayList<EarthPert> earthPerts = new ArrayList<EarthPert>();
            ArrayList<PlanetPert> planPerts = new ArrayList<PlanetPert>();
            ArrayList<TidalEffects> tidalEffects = new ArrayList<TidalEffects>();
            ArrayList<MoonPert> moonPerts = new ArrayList<MoonPert>();
            ArrayList<RelPert> relPerts = new ArrayList<RelPert>();
            ArrayList<PlanSolPert> planSolPerts = new ArrayList<PlanSolPert>();
            HashMap<String, Object[]> objectLists = new HashMap<String, Object[]>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                if (line.charAt(0) == '{') {
                    if (readingMainProblem) {
                        mainProblems.add(new MainProblem(line));
                        continue;
                    }
                    if (readingEarthPert) {
                        earthPerts.add(new EarthPert(line));
                        continue;
                    }
                    if (readingPlanpert) {
                        planPerts.add(new PlanetPert(line));
                        continue;
                    }
                    if (readingTidalEffects) {
                        tidalEffects.add(new TidalEffects(line));
                        continue;
                    }
                    if (readingMoonPert) {
                        moonPerts.add(new MoonPert(line));
                        continue;
                    }
                    if (readingRelPert) {
                        relPerts.add(new RelPert(line));
                        continue;
                    }
                    if (!readingPlanSolPert) continue;
                    planSolPerts.add(new PlanSolPert(line));
                    continue;
                }
                if (readingMainProblem) {
                    objectLists.put(varName, mainProblems.toArray(new MainProblem[mainProblems.size()]));
                } else if (readingEarthPert) {
                    objectLists.put(varName, earthPerts.toArray(new EarthPert[earthPerts.size()]));
                } else if (readingPlanpert) {
                    objectLists.put(varName, planPerts.toArray(new PlanetPert[planPerts.size()]));
                } else if (readingTidalEffects) {
                    objectLists.put(varName, tidalEffects.toArray(new TidalEffects[tidalEffects.size()]));
                } else if (readingMoonPert) {
                    objectLists.put(varName, moonPerts.toArray(new MoonPert[moonPerts.size()]));
                } else if (readingRelPert) {
                    objectLists.put(varName, relPerts.toArray(new RelPert[relPerts.size()]));
                } else if (readingPlanSolPert) {
                    objectLists.put(varName, planSolPerts.toArray(new PlanSolPert[planSolPerts.size()]));
                }
                readingMainProblem = false;
                readingEarthPert = false;
                readingPlanpert = false;
                readingTidalEffects = false;
                readingMoonPert = false;
                readingRelPert = false;
                readingPlanSolPert = false;
                varName = line.substring(line.lastIndexOf(32) + 1);
                if (line.startsWith("main_problem")) {
                    readingMainProblem = true;
                    mainProblems.clear();
                    continue;
                }
                if (line.startsWith("earth_pert")) {
                    readingEarthPert = true;
                    earthPerts.clear();
                    continue;
                }
                if (line.startsWith("planet_pert")) {
                    readingPlanpert = true;
                    planPerts.clear();
                    continue;
                }
                if (line.startsWith("tidal_effects")) {
                    readingTidalEffects = true;
                    tidalEffects.clear();
                    continue;
                }
                if (line.startsWith("moon_pert")) {
                    readingMoonPert = true;
                    moonPerts.clear();
                    continue;
                }
                if (line.startsWith("rel_pert")) {
                    readingRelPert = true;
                    relPerts.clear();
                    continue;
                }
                if (line.startsWith("plan_sol_pert")) {
                    readingPlanSolPert = true;
                    planSolPerts.clear();
                    continue;
                }
                throw new RuntimeException("unknown data");
            }
            objectLists.put(varName, planSolPerts.toArray(new PlanSolPert[planSolPerts.size()]));
            main_elp1 = (MainProblem[])objectLists.get("main_elp1");
            main_elp2 = (MainProblem[])objectLists.get("main_elp2");
            main_elp3 = (MainProblem[])objectLists.get("main_elp3");
            earth_pert_elp4 = (EarthPert[])objectLists.get("earth_pert_elp4");
            earth_pert_elp5 = (EarthPert[])objectLists.get("earth_pert_elp5");
            earth_pert_elp6 = (EarthPert[])objectLists.get("earth_pert_elp6");
            earth_pert_elp7 = (EarthPert[])objectLists.get("earth_pert_elp7");
            earth_pert_elp8 = (EarthPert[])objectLists.get("earth_pert_elp8");
            earth_pert_elp9 = (EarthPert[])objectLists.get("earth_pert_elp9");
            plan_pert_elp10 = (PlanetPert[])objectLists.get("plan_pert_elp10");
            plan_pert_elp11 = (PlanetPert[])objectLists.get("plan_pert_elp11");
            plan_pert_elp12 = (PlanetPert[])objectLists.get("plan_pert_elp12");
            plan_pert_elp13 = (PlanetPert[])objectLists.get("plan_pert_elp13");
            plan_pert_elp14 = (PlanetPert[])objectLists.get("plan_pert_elp14");
            plan_pert_elp15 = (PlanetPert[])objectLists.get("plan_pert_elp15");
            plan_pert_elp16 = (PlanetPert[])objectLists.get("plan_pert_elp16");
            plan_pert_elp17 = (PlanetPert[])objectLists.get("plan_pert_elp17");
            plan_pert_elp18 = (PlanetPert[])objectLists.get("plan_pert_elp18");
            plan_pert_elp19 = (PlanetPert[])objectLists.get("plan_pert_elp19");
            plan_pert_elp20 = (PlanetPert[])objectLists.get("plan_pert_elp20");
            plan_pert_elp21 = (PlanetPert[])objectLists.get("plan_pert_elp21");
            tidal_effects_elp22 = (TidalEffects[])objectLists.get("tidal_effects_elp22");
            tidal_effects_elp23 = (TidalEffects[])objectLists.get("tidal_effects_elp23");
            tidal_effects_elp24 = (TidalEffects[])objectLists.get("tidal_effects_elp24");
            tidal_effects_elp25 = (TidalEffects[])objectLists.get("tidal_effects_elp25");
            tidal_effects_elp26 = (TidalEffects[])objectLists.get("tidal_effects_elp26");
            tidal_effects_elp27 = (TidalEffects[])objectLists.get("tidal_effects_elp27");
            moon_pert_elp28 = (MoonPert[])objectLists.get("moon_pert_elp28");
            moon_pert_elp29 = (MoonPert[])objectLists.get("moon_pert_elp29");
            moon_pert_elp30 = (MoonPert[])objectLists.get("moon_pert_elp30");
            rel_pert_elp31 = (RelPert[])objectLists.get("rel_pert_elp31");
            rel_pert_elp32 = (RelPert[])objectLists.get("rel_pert_elp32");
            rel_pert_elp33 = (RelPert[])objectLists.get("rel_pert_elp33");
            plan_sol_pert_elp34 = (PlanSolPert[])objectLists.get("plan_sol_pert_elp34");
            plan_sol_pert_elp35 = (PlanSolPert[])objectLists.get("plan_sol_pert_elp35");
            plan_sol_pert_elp36 = (PlanSolPert[])objectLists.get("plan_sol_pert_elp36");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class PlanSolPert
    extends EarthPert {
        public PlanSolPert(int iz, int[] ilu, double o, double a, double p) {
            super(iz, ilu, o, a, p);
        }

        public PlanSolPert(String line) {
            super(line);
        }
    }

    public static class RelPert
    extends EarthPert {
        public RelPert(int iz, int[] ilu, double o, double a, double p) {
            super(iz, ilu, o, a, p);
        }

        public RelPert(String line) {
            super(line);
        }
    }

    public static class MoonPert
    extends EarthPert {
        public MoonPert(int iz, int[] ilu, double o, double a, double p) {
            super(iz, ilu, o, a, p);
        }

        public MoonPert(String line) {
            super(line);
        }
    }

    public static class TidalEffects
    extends EarthPert {
        public TidalEffects(int iz, int[] ilu, double o, double a, double p) {
            super(iz, ilu, o, a, p);
        }

        public TidalEffects(String line) {
            super(line);
        }
    }

    public static class PlanetPert {
        int[] ipla;
        double theta;
        double O;
        double P;

        public PlanetPert(int[] ipla, double theta, double o, double p) {
            this.ipla = ipla;
            this.theta = theta;
            this.O = o;
            this.P = p;
        }

        public PlanetPert(String line) {
            ParsePosition pos = new ParsePosition(1);
            this.ipla = DataReader.readIntArray(line, pos, 11);
            DataReader.skipOverChar(line, pos, ',');
            DataReader.skipBlanks(line, pos);
            this.theta = DataReader.format.parse(line, pos).doubleValue();
            DataReader.skipOverChar(line, pos, ',');
            DataReader.skipBlanks(line, pos);
            this.O = DataReader.format.parse(line, pos).doubleValue();
            DataReader.skipOverChar(line, pos, ',');
            DataReader.skipBlanks(line, pos);
            this.P = DataReader.format.parse(line, pos).doubleValue();
        }
    }

    public static class EarthPert {
        int iz;
        int[] ilu;
        double O;
        double A;
        double P;

        public EarthPert(int iz, int[] ilu, double o, double a, double p) {
            this.iz = iz;
            this.ilu = ilu;
            this.O = o;
            this.A = a;
            this.P = p;
        }

        public EarthPert(String line) {
            ParsePosition pos = new ParsePosition(1);
            DataReader.skipBlanks(line, pos);
            this.iz = DataReader.format.parse(line, pos).intValue();
            DataReader.skipOverChar(line, pos, ',');
            this.ilu = DataReader.readIntArray(line, pos, 4);
            DataReader.skipOverChar(line, pos, ',');
            DataReader.skipBlanks(line, pos);
            this.O = DataReader.format.parse(line, pos).doubleValue();
            DataReader.skipOverChar(line, pos, ',');
            DataReader.skipBlanks(line, pos);
            this.A = DataReader.format.parse(line, pos).doubleValue();
            DataReader.skipOverChar(line, pos, ',');
            DataReader.skipBlanks(line, pos);
            this.P = DataReader.format.parse(line, pos).doubleValue();
        }
    }

    public static class MainProblem {
        int[] ilu;
        double A;
        double[] B;

        public MainProblem(int[] ilu, double a, double[] b) {
            this.ilu = ilu;
            this.A = a;
            this.B = b;
        }

        public MainProblem(String line) {
            ParsePosition pos = new ParsePosition(1);
            this.ilu = DataReader.readIntArray(line, pos, 4);
            DataReader.skipOverChar(line, pos, ',');
            DataReader.skipBlanks(line, pos);
            this.A = DataReader.format.parse(line, pos).doubleValue();
            DataReader.skipOverChar(line, pos, ',');
            this.B = DataReader.readDoubleArray(line, pos, 5);
        }

        public String toString() {
            return "{" + Arrays.toString(this.ilu) + "," + this.A + "," + Arrays.toString(this.B) + "}";
        }
    }
}

