/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.Vsop87;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Mars {
    static double cJD = 0.0;
    static double cL = 0.0;
    static double cB = 0.0;
    static double cR = 0.0;

    public static void ln_get_mars_equ_coords(double JD, LnEquPosn position) {
        double c;
        double b;
        double a;
        double last;
        double delta;
        double diff;
        LnHelioPosn h_sol = new LnHelioPosn();
        LnHelioPosn h_mars = new LnHelioPosn();
        LnRectPosn g_sol = new LnRectPosn();
        LnRectPosn g_mars = new LnRectPosn();
        double t = 0.0;
        Solar.ln_get_solar_geom_coords(JD, h_sol);
        Transform.ln_get_rect_from_helio(h_sol, g_sol);
        do {
            last = t;
            Mars.ln_get_mars_helio_coords(JD - t, h_mars);
            Transform.ln_get_rect_from_helio(h_mars, g_mars);
            a = g_sol.X + g_mars.X;
            b = g_sol.Y + g_mars.Y;
            c = g_sol.Z + g_mars.Z;
            delta = a * a + b * b + c * c;
        } while ((diff = (t = (delta = Math.sqrt(delta)) * 0.0057755183) - last) > 1.0E-4 || diff < -1.0E-4);
        double ra = Math.atan2(b, a);
        double dec = c / delta;
        dec = Math.asin(dec);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_mars_helio_coords(double JD, LnHelioPosn position) {
        if (JD == cJD) {
            position.L = cL;
            position.B = cB;
            position.R = cR;
            return;
        }
        double t = (JD - 2451545.0) / 365250.0;
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double t5 = t4 * t;
        double L0 = Vsop87.ln_calc_series(Lontitude0.mars_longitude_l0, t);
        double L1 = Vsop87.ln_calc_series(Lontitude1.mars_longitude_l1, t);
        double L2 = Vsop87.ln_calc_series(Lontitude1.mars_longitude_l2, t);
        double L3 = Vsop87.ln_calc_series(Lontitude1.mars_longitude_l3, t);
        double L4 = Vsop87.ln_calc_series(Lontitude1.mars_longitude_l4, t);
        double L5 = Vsop87.ln_calc_series(Lontitude1.mars_longitude_l5, t);
        position.L = L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5;
        double B0 = Vsop87.ln_calc_series(Latitude.mars_latitude_b0, t);
        double B1 = Vsop87.ln_calc_series(Latitude.mars_latitude_b1, t);
        double B2 = Vsop87.ln_calc_series(Latitude.mars_latitude_b2, t);
        double B3 = Vsop87.ln_calc_series(Latitude.mars_latitude_b3, t);
        double B4 = Vsop87.ln_calc_series(Latitude.mars_latitude_b4, t);
        double B5 = Vsop87.ln_calc_series(Latitude.mars_latitude_b5, t);
        position.B = B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5;
        double R0 = Vsop87.ln_calc_series(Radius.mars_radius_r0, t);
        double R1 = Vsop87.ln_calc_series(Radius.mars_radius_r1, t);
        double R2 = Vsop87.ln_calc_series(Radius.mars_radius_r2, t);
        double R3 = Vsop87.ln_calc_series(Radius.mars_radius_r3, t);
        double R4 = Vsop87.ln_calc_series(Radius.mars_radius_r4, t);
        double R5 = Vsop87.ln_calc_series(Radius.mars_radius_r5, t);
        position.R = R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5;
        position.L = Utility.ln_rad_to_deg(position.L);
        position.B = Utility.ln_rad_to_deg(position.B);
        position.L = Utility.ln_range_degrees(position.L);
        Vsop87.ln_vsop87_to_fk5(position, JD);
        cJD = JD;
        cL = position.L;
        cB = position.B;
        cR = position.R;
    }

    public static double ln_get_mars_earth_dist(double JD) {
        LnHelioPosn h_mars = new LnHelioPosn();
        LnHelioPosn h_earth = new LnHelioPosn();
        LnRectPosn g_mars = new LnRectPosn();
        LnRectPosn g_earth = new LnRectPosn();
        Mars.ln_get_mars_helio_coords(JD, h_mars);
        Earth.ln_get_earth_helio_coords(JD, h_earth);
        Transform.ln_get_rect_from_helio(h_mars, g_mars);
        Transform.ln_get_rect_from_helio(h_earth, g_earth);
        double x = g_mars.X - g_earth.X;
        double y = g_mars.Y - g_earth.Y;
        double z = g_mars.Z - g_earth.Z;
        x *= x;
        y *= y;
        z *= z;
        return Math.sqrt(x + y + z);
    }

    public static double ln_get_mars_solar_dist(double JD) {
        LnHelioPosn h_mars = new LnHelioPosn();
        Mars.ln_get_mars_helio_coords(JD, h_mars);
        return h_mars.R;
    }

    public static double ln_get_mars_magnitude(double JD) {
        double r = Mars.ln_get_mars_solar_dist(JD);
        double delta = Mars.ln_get_mars_earth_dist(JD);
        double i = Mars.ln_get_mars_phase(JD);
        return -1.52 + 5.0 * Math.log10(r * delta) + 0.016 * i;
    }

    public static double ln_get_mars_disk(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Mars.ln_get_mars_solar_dist(JD);
        double delta = Mars.ln_get_mars_earth_dist(JD);
        return ((r + delta) * (r + delta) - R * R) / (4.0 * r * delta);
    }

    public static double ln_get_mars_phase(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Mars.ln_get_mars_solar_dist(JD);
        double delta = Mars.ln_get_mars_earth_dist(JD);
        double i = (r * r + delta * delta - R * R) / (2.0 * r * delta);
        i = Math.acos(i);
        return Utility.ln_rad_to_deg(i);
    }

    public static int ln_get_mars_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Mars.ln_get_mars_equ_coords(JD, position);
            }
        }, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static double ln_get_mars_sdiam(double JD) {
        double So = 4.68;
        double dist = Mars.ln_get_mars_earth_dist(JD);
        return So / dist;
    }

    public static void ln_get_mars_rect_helio(double JD, LnRectPosn position) {
        LnHelioPosn mars = new LnHelioPosn();
        Mars.ln_get_mars_helio_coords(JD, mars);
        Transform.ln_get_rect_from_helio(mars, position);
    }

    static class Radius {
        static Vsop87.LnVsop[] mars_radius_r0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.53033488271, 0.0, 0.0), new Vsop87.LnVsop(0.1418495316, 3.47971283528, 3340.6124266998), new Vsop87.LnVsop(0.00660776362, 3.81783443019, 6681.2248533996), new Vsop87.LnVsop(4.6179117E-4, 4.15595316782, 10021.8372800994), new Vsop87.LnVsop(8.109733E-5, 5.55958416318, 2810.9214616052), new Vsop87.LnVsop(7.485318E-5, 1.77239078402, 5621.8429232104), new Vsop87.LnVsop(5.523191E-5, 1.3643630377, 2281.2304965106), new Vsop87.LnVsop(3.82516E-5, 4.49407183687, 13362.4497067992), new Vsop87.LnVsop(2.306537E-5, 0.09081579001, 2544.3144198834), new Vsop87.LnVsop(1.999396E-5, 5.36059617709, 3337.0893083508), new Vsop87.LnVsop(2.484394E-5, 4.9254563992, 2942.4634232916), new Vsop87.LnVsop(1.960195E-5, 4.74249437639, 3344.1355450488), new Vsop87.LnVsop(1.167119E-5, 2.11260868341, 5092.1519581158), new Vsop87.LnVsop(1.102816E-5, 5.00908403998, 398.1490034082), new Vsop87.LnVsop(8.99066E-6, 4.40791133207, 529.6909650946), new Vsop87.LnVsop(9.92252E-6, 5.83861961952, 6151.533888305), new Vsop87.LnVsop(8.07354E-6, 2.10217065501, 1059.3819301892), new Vsop87.LnVsop(7.97915E-6, 3.44839203899, 796.2980068164), new Vsop87.LnVsop(7.40975E-6, 1.49906336885, 2146.1654164752), new Vsop87.LnVsop(6.92339E-6, 2.13378874689, 8962.4553499102), new Vsop87.LnVsop(6.33144E-6, 0.89353283242, 3340.5951730476), new Vsop87.LnVsop(7.25583E-6, 1.24516810723, 8432.7643848156), new Vsop87.LnVsop(6.3314E-6, 2.92430446399, 3340.629680352), new Vsop87.LnVsop(5.74355E-6, 0.82896244455, 2914.0142358238), new Vsop87.LnVsop(5.26166E-6, 5.38292991236, 3738.761430108), new Vsop87.LnVsop(6.29978E-6, 1.28737486495, 1751.539531416), new Vsop87.LnVsop(4.72775E-6, 5.19850522346, 3127.3133312618), new Vsop87.LnVsop(3.48095E-6, 4.83219199976, 16703.062133499), new Vsop87.LnVsop(2.83713E-6, 2.90692064724, 3532.0606928114), new Vsop87.LnVsop(2.79543E-6, 5.2574968538, 6283.0758499914), new Vsop87.LnVsop(2.33857E-6, 5.10545987572, 5486.777843175), new Vsop87.LnVsop(2.19427E-6, 5.58340231744, 191.4482661116), new Vsop87.LnVsop(2.69896E-6, 3.76393625127, 5884.9268465832), new Vsop87.LnVsop(2.08335E-6, 5.25476078693, 3340.545116397), new Vsop87.LnVsop(2.75217E-6, 2.90817482492, 1748.016413067), new Vsop87.LnVsop(2.75506E-6, 1.21767950614, 6254.6266625236), new Vsop87.LnVsop(2.39119E-6, 2.03669934656, 1194.4470102246), new Vsop87.LnVsop(2.23189E-6, 4.19861535147, 3149.1641605882), new Vsop87.LnVsop(1.82689E-6, 5.08062725665, 6684.7479717486), new Vsop87.LnVsop(1.86207E-6, 5.6987157241, 6677.7017350506), new Vsop87.LnVsop(1.76E-6, 5.95341919657, 3870.3033917944), new Vsop87.LnVsop(1.78617E-6, 4.18423004741, 3333.498879699), new Vsop87.LnVsop(2.0833E-6, 4.84626439637, 3340.6797370026), new Vsop87.LnVsop(2.28126E-6, 3.25526555588, 6872.6731195112), new Vsop87.LnVsop(1.44312E-6, 0.2130621946, 5088.6288397668), new Vsop87.LnVsop(1.63527E-6, 3.79888811958, 4136.9104335162), new Vsop87.LnVsop(1.33126E-6, 1.53906679361, 7903.073419721), new Vsop87.LnVsop(1.41755E-6, 2.47792380112, 4562.4609930212), new Vsop87.LnVsop(1.14927E-6, 4.31748869065, 1349.8674096588), new Vsop87.LnVsop(1.18789E-6, 2.12168482244, 1589.0728952838), new Vsop87.LnVsop(1.02094E-6, 6.18145185708, 9492.1463150048), new Vsop87.LnVsop(1.2857E-6, 5.49884728795, 8827.3902698748), new Vsop87.LnVsop(1.11546E-6, 0.55346108403, 11243.6858464208), new Vsop87.LnVsop(8.2498E-7, 1.62220096558, 11773.3768115154), new Vsop87.LnVsop(8.3204E-7, 0.61551135046, 8429.2412664666), new Vsop87.LnVsop(8.4463E-7, 0.62274409931, 1592.5960136328), new Vsop87.LnVsop(8.6666E-7, 1.74984525176, 2700.7151403858), new Vsop87.LnVsop(7.1813E-7, 2.4749406548, 12303.06777661), new Vsop87.LnVsop(8.5321E-7, 1.61634750496, 4690.4798363586), new Vsop87.LnVsop(6.3641E-7, 2.67334163937, 426.598190876), new Vsop87.LnVsop(6.8601E-7, 2.40188234283, 4399.994356889), new Vsop87.LnVsop(5.8559E-7, 4.7205283999, 213.299095438), new Vsop87.LnVsop(6.2009E-7, 1.10068565926, 1221.8485663214), new Vsop87.LnVsop(6.6499E-7, 2.21296335919, 6041.3275670856), new Vsop87.LnVsop(5.581E-7, 1.2328806632, 3185.1920272656), new Vsop87.LnVsop(5.4969E-7, 5.72695354791, 951.7184062506), new Vsop87.LnVsop(5.243E-7, 3.0236809553, 4292.3308329504), new Vsop87.LnVsop(5.5688E-7, 5.44688671707, 3723.508958923), new Vsop87.LnVsop(5.8959E-7, 3.26242460622, 6681.2421070518), new Vsop87.LnVsop(4.4638E-7, 2.01459444131, 8031.0922630584), new Vsop87.LnVsop(5.8959E-7, 1.2316529679, 6681.2075997474), new Vsop87.LnVsop(4.2439E-7, 2.26554261514, 155.4203994342), new Vsop87.LnVsop(3.8955E-7, 2.57760417339, 3341.592747768), new Vsop87.LnVsop(5.155E-7, 5.72324451485, 7079.3738568078), new Vsop87.LnVsop(4.894E-7, 5.61613493545, 3553.9115221378), new Vsop87.LnVsop(4.5406E-7, 5.43303278149, 6467.9257579616), new Vsop87.LnVsop(3.6438E-7, 4.43922435395, 3894.1818295422), new Vsop87.LnVsop(3.598E-7, 1.15972378713, 2288.3440435114), new Vsop87.LnVsop(3.5268E-7, 5.49032233898, 1990.745017041), new Vsop87.LnVsop(4.2192E-7, 1.63254827838, 5628.9564702112), new Vsop87.LnVsop(4.4292E-7, 5.00344221303, 5614.7293762096), new Vsop87.LnVsop(3.3616E-7, 5.17029030468, 20043.6745601988), new Vsop87.LnVsop(4.3256E-7, 1.03722397198, 11769.8536931664), new Vsop87.LnVsop(3.9237E-7, 1.24237030858, 3339.6321056316), new Vsop87.LnVsop(3.1949E-7, 4.59259676953, 2274.1169495098), new Vsop87.LnVsop(3.0352E-7, 2.44163963455, 11371.7046897582), new Vsop87.LnVsop(3.2269E-7, 2.38222363233, 4535.0594369244), new Vsop87.LnVsop(3.1855E-7, 4.37536980289, 3.523118349), new Vsop87.LnVsop(2.9342E-7, 4.06035002188, 3097.88382272579), new Vsop87.LnVsop(3.1967E-7, 1.93969979134, 382.8965322232), new Vsop87.LnVsop(2.6164E-7, 5.58463559826, 9623.6882766912), new Vsop87.LnVsop(2.7903E-7, 4.25809486053, 3191.0492295652), new Vsop87.LnVsop(3.3044E-7, 0.85475620169, 553.5694028424), new Vsop87.LnVsop(2.7544E-7, 1.5766864517, 9595.2390892234), new Vsop87.LnVsop(2.5163E-7, 0.81337734264, 10713.9948813262), new Vsop87.LnVsop(2.2045E-7, 0.85711201558, 3319.8370312074), new Vsop87.LnVsop(2.4759E-7, 5.38993953923, 2818.035008606), new Vsop87.LnVsop(2.3352E-7, 6.0145897459, 3496.032826134), new Vsop87.LnVsop(2.4723E-7, 2.58025225634, 2803.8079146044), new Vsop87.LnVsop(1.9361E-7, 5.18528881954, 6681.2921637024), new Vsop87.LnVsop(1.9118E-7, 5.419693554, 10025.3603984484), new Vsop87.LnVsop(1.9361E-7, 5.59378511334, 6681.1575430968), new Vsop87.LnVsop(1.8331E-7, 5.7956572331, 7064.1213856228), new Vsop87.LnVsop(1.8188E-7, 5.61299105522, 7.1135470008), new Vsop87.LnVsop(2.0393E-7, 4.53615443964, 6489.776587288), new Vsop87.LnVsop(2.1258E-7, 6.19174428363, 14054.607308026), new Vsop87.LnVsop(1.7094E-7, 1.54988538094, 2957.7158944766), new Vsop87.LnVsop(2.2794E-7, 3.41719468533, 7632.9432596502), new Vsop87.LnVsop(2.0561E-7, 2.98654120324, 3361.3878221922), new Vsop87.LnVsop(1.705E-7, 6.15529583629, 10404.7338123226), new Vsop87.LnVsop(1.8007E-7, 2.81505100996, 4032.7700279266), new Vsop87.LnVsop(1.6487E-7, 3.84534133372, 10973.55568635), new Vsop87.LnVsop(1.6056E-7, 0.92819026247, 14584.2982731206), new Vsop87.LnVsop(2.1008E-7, 2.38506850221, 4989.0591838972), new Vsop87.LnVsop(1.6291E-7, 1.92190075688, 7373.3824546264), new Vsop87.LnVsop(1.6286E-7, 6.28252184173, 7210.9158184942), new Vsop87.LnVsop(1.8575E-7, 4.07319565284, 2388.8940204492), new Vsop87.LnVsop(1.5976E-7, 4.58379703739, 3264.3463554242), new Vsop87.LnVsop(1.9909E-7, 2.73523951203, 5099.2655051166), new Vsop87.LnVsop(1.9667E-7, 1.86294734899, 3443.7052009184), new Vsop87.LnVsop(1.65E-7, 4.1406165717, 7477.522860216), new Vsop87.LnVsop(1.9492E-7, 6.03778625701, 10018.3141617504), new Vsop87.LnVsop(1.5097E-7, 2.65433832872, 2787.0430238574), new Vsop87.LnVsop(1.9099E-7, 0.22623513076, 13745.3462390224), new Vsop87.LnVsop(1.7164E-7, 3.1882629935, 3347.7259737006), new Vsop87.LnVsop(1.3407E-7, 2.12775612449, 3344.2028553516), new Vsop87.LnVsop(1.5407E-7, 2.20766468871, 2118.7638603784), new Vsop87.LnVsop(1.7246E-7, 3.67064642858, 3205.5473466644), new Vsop87.LnVsop(1.3091E-7, 4.27475419816, 14314.1681130498), new Vsop87.LnVsop(1.6437E-7, 2.86612474805, 14712.317116458), new Vsop87.LnVsop(1.6648E-7, 4.521351492, 6674.1113063988), new Vsop87.LnVsop(1.3718E-7, 1.68586111426, 3337.021998048), new Vsop87.LnVsop(1.1824E-7, 0.19675650045, 3475.6775067352), new Vsop87.LnVsop(1.1757E-7, 3.23020638064, 5828.0284716476), new Vsop87.LnVsop(1.1884E-7, 4.82075035433, 7234.794256242), new Vsop87.LnVsop(1.0608E-7, 1.73995972784, 639.897286314), new Vsop87.LnVsop(1.1143E-7, 0.23833349966, 12832.7587417046), new Vsop87.LnVsop(1.1028E-7, 0.4455568729, 10213.285546211), new Vsop87.LnVsop(1.0238E-7, 5.74731032428, 242.728603974), new Vsop87.LnVsop(1.0052E-7, 2.45096419672, 4929.6853219836), new Vsop87.LnVsop(1.0061E-7, 0.78904152333, 9381.9399937854), new Vsop87.LnVsop(1.0065E-7, 5.37509927353, 5085.038411115), new Vsop87.LnVsop(1.1897E-7, 0.79890074455, 3265.8308281325), new Vsop87.LnVsop(8.983E-8, 0.96474320941, 4933.2084403326), new Vsop87.LnVsop(8.976E-8, 4.18310051894, 9225.539273283), new Vsop87.LnVsop(8.982E-8, 1.98499607259, 15113.9892382152), new Vsop87.LnVsop(8.325E-8, 1.93706224943, 1648.4467571974), new Vsop87.LnVsop(7.832E-8, 2.04997038646, 1758.6530784168), new Vsop87.LnVsop(7.964E-8, 3.92258783522, 2921.1277828246), new Vsop87.LnVsop(1.0223E-7, 2.66509814753, 2487.4160449478), new Vsop87.LnVsop(8.277E-8, 0.94860765545, 2906.900688823), new Vsop87.LnVsop(7.371E-8, 0.84436508721, 692.1576012268), new Vsop87.LnVsop(7.529E-8, 5.68043313811, 13916.0191096416), new Vsop87.LnVsop(7.907E-8, 2.81314645975, 15643.6802033098), new Vsop87.LnVsop(6.956E-8, 3.32212696002, 3230.4061054804), new Vsop87.LnVsop(7.426E-8, 6.09654676653, 3583.3410306738), new Vsop87.LnVsop(6.402E-8, 4.19806999276, 5202.3582793352), new Vsop87.LnVsop(6.523E-8, 6.11927838278, 135.0650800354), new Vsop87.LnVsop(6.127E-8, 0.00122595969, 6836.6452528338), new Vsop87.LnVsop(6.223E-8, 6.1065313699, 17256.6315363414), new Vsop87.LnVsop(8.161E-8, 5.24822786208, 10575.4066829418), new Vsop87.LnVsop(6.163E-8, 3.60026818309, 10021.8545337516), new Vsop87.LnVsop(6.163E-8, 1.56949585888, 10021.8200264472), new Vsop87.LnVsop(5.673E-8, 0.13638905291, 13524.9163429314), new Vsop87.LnVsop(6.257E-8, 4.50450316951, 8425.6508378148), new Vsop87.LnVsop(5.249E-8, 2.70116504868, 4459.3682188026), new Vsop87.LnVsop(6.47E-8, 2.74232480124, 7740.6067835888), new Vsop87.LnVsop(5.523E-8, 6.06378363783, 10419.9862835076), new Vsop87.LnVsop(5.548E-8, 5.75002125481, 12168.0026965746), new Vsop87.LnVsop(6.827E-8, 4.69340338938, 17654.7805397496), new Vsop87.LnVsop(4.993E-8, 4.68464837021, 522.5774180938), new Vsop87.LnVsop(6.32E-8, 3.3193809127, 3767.2106175758), new Vsop87.LnVsop(4.735E-8, 0.00770324607, 3325.3599555148), new Vsop87.LnVsop(5.025E-8, 2.33675441772, 1052.2683831884), new Vsop87.LnVsop(4.656E-8, 5.15033151106, 1066.49547719), new Vsop87.LnVsop(4.728E-8, 5.77993082374, 9808.5381846614), new Vsop87.LnVsop(5.128E-8, 1.57178942294, 6525.8044539654), new Vsop87.LnVsop(4.523E-8, 1.44233177206, 3369.0616141676), new Vsop87.LnVsop(6.205E-8, 4.48163731718, 22747.2907148744), new Vsop87.LnVsop(6.169E-8, 4.59085555242, 6531.661656265), new Vsop87.LnVsop(5.329E-8, 4.55141789349, 1744.4259844152), new Vsop87.LnVsop(4.514E-8, 5.94508421612, 6894.5239488376), new Vsop87.LnVsop(4.33E-8, 3.10899106071, 4569.574540022), new Vsop87.LnVsop(5.367E-8, 5.08071026709, 2707.8286873866), new Vsop87.LnVsop(5.138E-8, 1.28584065229, 8439.8779318164), new Vsop87.LnVsop(4.12E-8, 5.48544036931, 2699.7348193176), new Vsop87.LnVsop(5.398E-8, 5.21710209952, 5305.4510535538), new Vsop87.LnVsop(4.45E-8, 5.56771154217, 16865.5287696312), new Vsop87.LnVsop(3.898E-8, 1.48753002285, 9168.6408983474), new Vsop87.LnVsop(3.858E-8, 1.23056079731, 16858.4825329332), new Vsop87.LnVsop(3.764E-8, 0.27080818668, 17395.2197347258), new Vsop87.LnVsop(4.687E-8, 3.0570907584, 5518.7501489918), new Vsop87.LnVsop(4.264E-8, 2.79046663043, 3503.079062832), new Vsop87.LnVsop(3.864E-8, 0.37957786186, 10177.2576795336), new Vsop87.LnVsop(3.992E-8, 1.84425142473, 3134.4268782626), new Vsop87.LnVsop(3.658E-8, 2.95544843123, 6144.4203413042), new Vsop87.LnVsop(3.65E-8, 1.58041651396, 6680.2445323314), new Vsop87.LnVsop(3.945E-8, 1.98631850445, 8969.568896911), new Vsop87.LnVsop(3.357E-8, 2.72642619106, 7875.6718636242), new Vsop87.LnVsop(3.612E-8, 2.91545290475, 6682.2051744678), new Vsop87.LnVsop(4.391E-8, 0.81942455331, 3302.479391062), new Vsop87.LnVsop(4.062E-8, 5.46935163229, 3120.199784261), new Vsop87.LnVsop(3.319E-8, 1.77193665114, 3116.2676309979), new Vsop87.LnVsop(3.501E-8, 1.17933995367, 10184.3039162316), new Vsop87.LnVsop(4.008E-8, 1.33675583877, 6247.5131155228), new Vsop87.LnVsop(3.603E-8, 0.15462927995, 2178.137722292), new Vsop87.LnVsop(3.31E-8, 3.12882757204, 17277.4069318338), new Vsop87.LnVsop(4.133E-8, 4.39583076998, 3074.005384978), new Vsop87.LnVsop(3.203E-8, 3.36608406402, 2384.3232707292), new Vsop87.LnVsop(3.991E-8, 3.82886107874, 3355.8648978848), new Vsop87.LnVsop(4.209E-8, 1.90551053001, 263.0839233728), new Vsop87.LnVsop(3.751E-8, 4.25459322896, 6261.7402095244), new Vsop87.LnVsop(3.111E-8, 1.65372563906, 20199.094959633), new Vsop87.LnVsop(3.627E-8, 5.55043389753, 632.7837393132), new Vsop87.LnVsop(2.9E-8, 1.9153698583, 12935.8515159232), new Vsop87.LnVsop(3.373E-8, 5.5081240917, 23384.2869868986), new Vsop87.LnVsop(3.13E-8, 5.44035193127, 6048.4411140864), new Vsop87.LnVsop(3.314E-8, 5.83281937056, 5331.3574437408), new Vsop87.LnVsop(3.813E-8, 0.80274300018, 13517.8701062334), new Vsop87.LnVsop(3.618E-8, 3.68174019476, 5724.935697429), new Vsop87.LnVsop(2.813E-8, 1.68598843421, 2391.43681773), new Vsop87.LnVsop(2.902E-8, 5.30668266703, 8955.3418029094), new Vsop87.LnVsop(3.225E-8, 2.29849058942, 3312.163239232), new Vsop87.LnVsop(2.744E-8, 5.50347742867, 149.5631971346), new Vsop87.LnVsop(3.86E-8, 3.48197884682, 20618.0193585336), new Vsop87.LnVsop(2.81E-8, 4.77172972854, 1964.838626854), new Vsop87.LnVsop(2.711E-8, 2.69239976396, 3178.1457905676), new Vsop87.LnVsop(2.711E-8, 2.38313180043, 2648.454825473), new Vsop87.LnVsop(2.831E-8, 5.9193429513, 12964.300703391), new Vsop87.LnVsop(2.739E-8, 1.09522334227, 536.8045120954), new Vsop87.LnVsop(2.71E-8, 6.10385329581, 3973.396166013), new Vsop87.LnVsop(2.488E-8, 3.8770380883, 1861.7458526354), new Vsop87.LnVsop(2.623E-8, 2.6552954278, 8329.671610597), new Vsop87.LnVsop(2.94E-8, 5.68286095012, 6158.6474353058), new Vsop87.LnVsop(2.336E-8, 3.2484700711, 4672.6673142406), new Vsop87.LnVsop(2.318E-8, 1.69208910196, 3914.9572250346), new Vsop87.LnVsop(2.367E-8, 4.75070694678, 103.0927742186), new Vsop87.LnVsop(2.963E-8, 0.23379260146, 20597.2439630412), new Vsop87.LnVsop(2.182E-8, 6.18341760619, 3346.1353510072), new Vsop87.LnVsop(2.451E-8, 1.92510991367, 7799.9806455024), new Vsop87.LnVsop(2.549E-8, 5.39464168921, 3863.1898447936), new Vsop87.LnVsop(2.121E-8, 4.87506277174, 9830.3890139878), new Vsop87.LnVsop(2.181E-8, 0.58531113635, 162.4666361322), new Vsop87.LnVsop(2.101E-8, 2.84309144308, 3415.3940252671), new Vsop87.LnVsop(2.103E-8, 3.06103660745, 19800.9459562248), new Vsop87.LnVsop(2.339E-8, 3.907942211, 3335.0895023924), new Vsop87.LnVsop(2.143E-8, 5.40843887525, 266.6070417218), new Vsop87.LnVsop(2.026E-8, 5.52082289678, 10021.9045904022), new Vsop87.LnVsop(1.997E-8, 2.77245698491, 13936.794505134), new Vsop87.LnVsop(2.143E-8, 0.09046579554, 13358.9265884502), new Vsop87.LnVsop(1.995E-8, 2.62507525502, 20.7753954924), new Vsop87.LnVsop(1.959E-8, 4.8816227314, 3237.5196524812), new Vsop87.LnVsop(2.219E-8, 1.06826905532, 3320.257107301), new Vsop87.LnVsop(2.126E-8, 3.0211022688, 5625.3660415594), new Vsop87.LnVsop(2.124E-8, 3.68619137826, 5618.3198048614), new Vsop87.LnVsop(1.94E-8, 1.2899004241, 17924.9106998204), new Vsop87.LnVsop(2.563E-8, 2.09964366436, 7910.1869667218), new Vsop87.LnVsop(2.541E-8, 4.92484934029, 6604.958782124), new Vsop87.LnVsop(1.816E-8, 5.57505731597, 3351.2490920496), new Vsop87.LnVsop(1.776E-8, 5.77337176841, 3607.2194684216), new Vsop87.LnVsop(1.779E-8, 4.48010754608, 10818.1352869158), new Vsop87.LnVsop(1.991E-8, 2.60731155414, 3546.797975137), new Vsop87.LnVsop(1.735E-8, 1.51574912984, 1692.1656695024), new Vsop87.LnVsop(2.099E-8, 5.75659410227, 13365.9728251482), new Vsop87.LnVsop(1.801E-8, 2.73190366523, 3360.96774609859), new Vsop87.LnVsop(1.76E-8, 2.21274514293, 13119.72110282519), new Vsop87.LnVsop(1.907E-8, 3.32232991929, 6702.000248892), new Vsop87.LnVsop(1.732E-8, 1.43627324542, 4885.9664096786), new Vsop87.LnVsop(2.043E-8, 1.19294433795, 6660.4494579072), new Vsop87.LnVsop(1.774E-8, 2.18409046663, 6784.3176276182), new Vsop87.LnVsop(1.721E-8, 4.86030510926, 10014.7237330986), new Vsop87.LnVsop(1.766E-8, 2.0940047403, 3603.6963500726), new Vsop87.LnVsop(1.599E-8, 3.48163351273, 23141.5583829246), new Vsop87.LnVsop(1.596E-8, 3.5284425175, 6688.3384004004), new Vsop87.LnVsop(1.625E-8, 3.24396520223, 3657.0042963564), new Vsop87.LnVsop(1.58E-8, 1.88559955946, 6298.3283211764), new Vsop87.LnVsop(1.614E-8, 5.73885935004, 4555.3474460204), new Vsop87.LnVsop(1.534E-8, 5.178564458, 76.2660712756), new Vsop87.LnVsop(2.034E-8, 2.63611090015, 16460.33352952499), new Vsop87.LnVsop(2.025E-8, 5.92932421118, 10021.7699697966), new Vsop87.LnVsop(1.69E-8, 4.41092763741, 5729.506447149), new Vsop87.LnVsop(1.88E-8, 4.53291066339, 3329.97576135), new Vsop87.LnVsop(1.529E-8, 4.75820072827, 7895.9598727202), new Vsop87.LnVsop(1.529E-8, 1.35292688408, 1581.959348283), new Vsop87.LnVsop(1.807E-8, 1.86211947929, 2693.601593385), new Vsop87.LnVsop(1.871E-8, 2.38027840271, 6843.6914895318), new Vsop87.LnVsop(1.525E-8, 3.98478982422, 6546.1597733642), new Vsop87.LnVsop(1.391E-8, 5.54907950578, 4775.7600884592), new Vsop87.LnVsop(1.447E-8, 2.35649936426, 6034.2140200848), new Vsop87.LnVsop(1.425E-8, 4.46726861881, 574.3447983348), new Vsop87.LnVsop(1.372E-8, 1.07223935556, 12722.5524204852), new Vsop87.LnVsop(1.374E-8, 1.81967687782, 9779.1086761254), new Vsop87.LnVsop(1.426E-8, 2.56937630608, 3399.9862886134), new Vsop87.LnVsop(1.38E-8, 5.7616106395, 16335.8378045366), new Vsop87.LnVsop(1.337E-8, 2.97604378007, 6127.6554505572), new Vsop87.LnVsop(1.478E-8, 4.74293012446, 12566.1516999828), new Vsop87.LnVsop(1.359E-8, 0.80090329608, 853.196381752), new Vsop87.LnVsop(1.716E-8, 0.30679442592, 10551.528245194), new Vsop87.LnVsop(1.544E-8, 4.33406034501, 640.8776073822), new Vsop87.LnVsop(1.28E-8, 2.00262938648, 6677.6344247478), new Vsop87.LnVsop(1.233E-8, 1.02381163524, 3024.2205570432), new Vsop87.LnVsop(1.279E-8, 1.92685858897, 3347.6586633978), new Vsop87.LnVsop(1.243E-8, 2.4419475391, 6684.8152820514), new Vsop87.LnVsop(1.459E-8, 1.74092527479, 3333.5661900018), new Vsop87.LnVsop(1.675E-8, 1.79700655545, 1118.7557921028), new Vsop87.LnVsop(1.49E-8, 2.59383061313, 2494.5295919486), new Vsop87.LnVsop(1.293E-8, 3.31710472549, 3407.0998356142), new Vsop87.LnVsop(1.187E-8, 4.9295829011, 22743.4093795164), new Vsop87.LnVsop(1.374E-8, 2.53380484533, 5459.3762870782), new Vsop87.LnVsop(1.329E-8, 1.9942560616, 1228.9621133222), new Vsop87.LnVsop(1.183E-8, 4.25338096713, 3344.4937620578), new Vsop87.LnVsop(1.231E-8, 2.50206387861, 4356.275444584), new Vsop87.LnVsop(1.243E-8, 2.65173439875, 74.7815985673), new Vsop87.LnVsop(1.285E-8, 4.34087881585, 3326.3853326982), new Vsop87.LnVsop(1.119E-8, 1.91321733325, 3281.2385647862), new Vsop87.LnVsop(1.265E-8, 3.77353981627, 11236.57229942), new Vsop87.LnVsop(1.089E-8, 5.51229221434, 3017.1070100424), new Vsop87.LnVsop(1.286E-8, 1.3839346186, 3077.528503327), new Vsop87.LnVsop(1.1E-8, 1.17127664716, 6606.4432548323), new Vsop87.LnVsop(1.256E-8, 3.35491080997, 4039.8835749274), new Vsop87.LnVsop(1.381E-8, 5.69970569949, 2807.3983432562), new Vsop87.LnVsop(1.106E-8, 5.8187819496, 2675.8563815698), new Vsop87.LnVsop(1.187E-8, 2.41348978779, 10596.1820784342), new Vsop87.LnVsop(1.052E-8, 3.33521939538, 3304.5845600224), new Vsop87.LnVsop(1.184E-8, 5.84735789822, 3336.7310913418), new Vsop87.LnVsop(1.071E-8, 2.78692349783, 8270.2977486834), new Vsop87.LnVsop(1.106E-8, 3.03323928564, 3929.677253708), new Vsop87.LnVsop(1.013E-8, 3.51980287593, 8013.2797409404), new Vsop87.LnVsop(1.079E-8, 0.51857998748, 2814.4445799542), new Vsop87.LnVsop(9.97E-9, 4.72549938173, 533.2140834436), new Vsop87.LnVsop(1.126E-8, 0.52511404239, 6816.289933435), new Vsop87.LnVsop(1.313E-8, 2.07279662119, 23539.7073863328), new Vsop87.LnVsop(9.97E-9, 4.03571286988, 16062.1845261168), new Vsop87.LnVsop(1.18E-8, 0.60882533212, 2301.58581590939), new Vsop87.LnVsop(9.54E-9, 5.90344184081, 20206.141196331), new Vsop87.LnVsop(9.93E-9, 0.07173946166, 24150.080051345), new Vsop87.LnVsop(1.088E-8, 1.25542347811, 5938.234792867), new Vsop87.LnVsop(1.046E-8, 2.22216816006, 3980.5097130138), new Vsop87.LnVsop(9.12E-9, 2.54221161157, 433.7117378768), new Vsop87.LnVsop(1.248E-8, 0.59994750055, 16173.3711684044), new Vsop87.LnVsop(1.027E-8, 4.95981994495, 19676.4502312364), new Vsop87.LnVsop(1.108E-8, 4.3420944816, 3339.1279539915), new Vsop87.LnVsop(1.188E-8, 6.21563718642, 2679.3794999188), new Vsop87.LnVsop(1.143E-8, 4.48026291181, 19402.7969528166), new Vsop87.LnVsop(9.47E-9, 1.30292113731, 8273.8208670324), new Vsop87.LnVsop(8.41E-9, 0.83266239461, 2597.6223661672), new Vsop87.LnVsop(1.017E-8, 5.14490946009, 1596.1864422846), new Vsop87.LnVsop(8.32E-9, 5.6062365203, 3340.19235060619), new Vsop87.LnVsop(1.035E-8, 4.71834396549, 419.4846438752), new Vsop87.LnVsop(8.43E-9, 5.30135428959, 26084.0218062162), new Vsop87.LnVsop(9.04E-9, 0.45707711274, 12995.2253778368), new Vsop87.LnVsop(1.089E-8, 0.51279391816, 11250.7993934216), new Vsop87.LnVsop(9.9E-9, 2.06776071698, 7255.5696517344), new Vsop87.LnVsop(8.06E-9, 3.09007612136, 5415.6573747732), new Vsop87.LnVsop(7.86E-9, 4.62520938233, 2547.8375382324), new Vsop87.LnVsop(7.84E-9, 6.24013860877, 15508.6151232744), new Vsop87.LnVsop(9.63E-9, 2.10680539918, 6456.8800576977), new Vsop87.LnVsop(9.83E-9, 2.34198517787, 18454.601664915), new Vsop87.LnVsop(7.78E-9, 3.56577545397, 12721.572099417), new Vsop87.LnVsop(8.73E-9, 5.09097165091, 2540.7913015344), new Vsop87.LnVsop(7.67E-9, 3.08340332968, 11081.2192102886), new Vsop87.LnVsop(8.59E-9, 4.14805102195, 6438.4962494256), new Vsop87.LnVsop(1.012E-8, 4.4500092944, 3316.733988952), new Vsop87.LnVsop(9.06E-9, 4.29336078401, 3344.5445799629), new Vsop87.LnVsop(7.4E-9, 2.61398721165, 2284.7536148596), new Vsop87.LnVsop(7.9E-9, 6.0343680762, 12509.2533250472), new Vsop87.LnVsop(7.42E-9, 4.11069563225, 3760.097070575), new Vsop87.LnVsop(7.39E-9, 0.52114868719, 18052.9295431578), new Vsop87.LnVsop(7.31E-9, 3.28129610605, 3510.1926098328), new Vsop87.LnVsop(9.23E-9, 2.78717980606, 1332.0548875408), new Vsop87.LnVsop(7.57E-9, 0.86911170494, 1545.3539829788), new Vsop87.LnVsop(9.1E-9, 2.74957179518, 316.3918696566), new Vsop87.LnVsop(7.76E-9, 3.72496049906, 6571.0185321802), new Vsop87.LnVsop(9.96E-9, 0.45947604134, 27490.6924780448), new Vsop87.LnVsop(7.04E-9, 1.89599510634, 13362.432453147), new Vsop87.LnVsop(7.02E-9, 5.53839511728, 3364.4908644476), new Vsop87.LnVsop(6.98E-9, 2.20800707948, 20995.3929664494), new Vsop87.LnVsop(7.01E-9, 3.92671746155, 13362.4669604514), new Vsop87.LnVsop(7.64E-9, 1.88253040974, 5732.0492444298), new Vsop87.LnVsop(6.99E-9, 1.79149358545, 206.1855484372), new Vsop87.LnVsop(6.87E-9, 0.34919720925, 5835.1420186484), new Vsop87.LnVsop(6.86E-9, 0.12318958493, 13760.5987102074), new Vsop87.LnVsop(8.27E-9, 0.4976694517, 3376.6402933772), new Vsop87.LnVsop(6.84E-9, 0.23959365533, 2409.249339848), new Vsop87.LnVsop(6.71E-9, 0.51079989451, 25685.872802808), new Vsop87.LnVsop(6.99E-9, 5.90166576392, 19004.6479494084), new Vsop87.LnVsop(6.49E-9, 4.88357273177, 11766.2632645146), new Vsop87.LnVsop(6.47E-9, 3.01092562913, 5223.6939198022), new Vsop87.LnVsop(7.25E-9, 3.28015382608, 4142.976349146), new Vsop87.LnVsop(6.76E-9, 0.48866539717, 5408.5438277724), new Vsop87.LnVsop(8.11E-9, 3.13587175379, 18984.2926300096), new Vsop87.LnVsop(6.53E-9, 4.27065316348, 1214.7350193206), new Vsop87.LnVsop(6.47E-9, 3.62972991197, 7107.8230442756), new Vsop87.LnVsop(8.24E-9, 4.49442636948, 3341.0325027934), new Vsop87.LnVsop(6.71E-9, 0.17020701482, 110.2063212194), new Vsop87.LnVsop(6.26E-9, 4.93471822146, 9872.2740829648), new Vsop87.LnVsop(5.83E-9, 6.03261379086, 20809.4676246452), new Vsop87.LnVsop(5.86E-9, 4.02402847599, 664.75604513), new Vsop87.LnVsop(5.92E-9, 4.01141532759, 19406.6782881746), new Vsop87.LnVsop(6.92E-9, 1.45478322504, 3377.217792004), new Vsop87.LnVsop(5.71E-9, 1.20823617855, 5621.8601768626), new Vsop87.LnVsop(5.71E-9, 5.46064992297, 5621.8256695582), new Vsop87.LnVsop(7.37E-9, 3.19744761356, 9380.9596727172), new Vsop87.LnVsop(5.98E-9, 3.05986754375, 3341.0423098265), new Vsop87.LnVsop(6.77E-9, 4.72311533943, 8116.372515159), new Vsop87.LnVsop(6.96E-9, 0.14131183251, 6923.9534573736), new Vsop87.LnVsop(5.95E-9, 2.17622352088, 7270.2896804078), new Vsop87.LnVsop(5.73E-9, 0.40143379609, 15110.4661198662), new Vsop87.LnVsop(6.55E-9, 1.08706089359, 3169.9395560806), new Vsop87.LnVsop(5.82E-9, 1.68224967196, 26087.9031415742), new Vsop87.LnVsop(5.49E-9, 1.67151859507, 11780.4903585162), new Vsop87.LnVsop(5.43E-9, 2.42716241057, 170.6728706192), new Vsop87.LnVsop(5.33E-9, 2.63968766595, 2277.7073781616), new Vsop87.LnVsop(5.84E-9, 5.99680812069, 2149.6885348242), new Vsop87.LnVsop(5.76E-9, 1.69042028754, 3384.3313390048), new Vsop87.LnVsop(5.46E-9, 2.53920837226, 7380.4960016272), new Vsop87.LnVsop(5.98E-9, 0.75754342787, 3340.1825435731), new Vsop87.LnVsop(5.75E-9, 1.33793171924, 3296.8935143948), new Vsop87.LnVsop(5.26E-9, 5.02709350225, 1375.7737998458), new Vsop87.LnVsop(5.41E-9, 6.17208296381, 13149.1506113612), new Vsop87.LnVsop(6.89E-9, 0.02979541784, 22345.2603761082), new Vsop87.LnVsop(5.4E-9, 5.54146803424, 8646.0634802536), new Vsop87.LnVsop(5.28E-9, 2.74122616237, 3826.5844794894), new Vsop87.LnVsop(5.05E-9, 6.27740886099, 10235.1363755374), new Vsop87.LnVsop(6.89E-9, 6.28209877521, 12295.9542296092), new Vsop87.LnVsop(4.99E-9, 0.25663630799, 2142.6422981262), new Vsop87.LnVsop(4.98E-9, 5.91370528027, 6460.8122109608), new Vsop87.LnVsop(5.08E-9, 0.62111966418, 20735.83216142559), new Vsop87.LnVsop(5.22E-9, 2.5652628527, 3877.4169387952), new Vsop87.LnVsop(5.88E-9, 3.39977690249, 3329.5667264359), new Vsop87.LnVsop(4.86E-9, 4.01080943956, 23937.856389741), new Vsop87.LnVsop(5.73E-9, 3.88912359036, 9065.5481241288), new Vsop87.LnVsop(5.35E-9, 1.55491053821, 2221.856634597), new Vsop87.LnVsop(5.23E-9, 2.88572080247, 6040.3472460174), new Vsop87.LnVsop(4.73E-9, 4.1450388688, 3113.1362939108), new Vsop87.LnVsop(4.59E-9, 4.05994683743, 1162.4747044078), new Vsop87.LnVsop(4.94E-9, 2.98928486614, 1039.0266107904), new Vsop87.LnVsop(4.87E-9, 4.8859632497, 5511.636601991), new Vsop87.LnVsop(5.37E-9, 1.24870344441, 48835.19385644859), new Vsop87.LnVsop(4.62E-9, 5.38999453893, 15664.03552270859), new Vsop87.LnVsop(5.8E-9, 5.5256014793, 4981.9456368964), new Vsop87.LnVsop(5.24E-9, 1.21845283197, 10721.108428327), new Vsop87.LnVsop(5.83E-9, 5.13992428384, 3873.8265101434), new Vsop87.LnVsop(4.4E-9, 4.69966061314, 799.8211251654), new Vsop87.LnVsop(4.65E-9, 5.49231586238, 3342.0968994081), new Vsop87.LnVsop(4.41E-9, 2.28374512416, 12310.1813236108), new Vsop87.LnVsop(4.36E-9, 0.12517834889, 956.2891559706), new Vsop87.LnVsop(4.4E-9, 3.74259902142, 5195.2447323344), new Vsop87.LnVsop(5.37E-9, 5.91841782585, 1478.8665740644), new Vsop87.LnVsop(4.29E-9, 1.2054441075, 28.4491874678), new Vsop87.LnVsop(5.66E-9, 3.86528084538, 26482.1708096244), new Vsop87.LnVsop(5.55E-9, 5.30320900441, 2766.267628365), new Vsop87.LnVsop(4.57E-9, 1.45547501374, 5636.070017212), new Vsop87.LnVsop(4.94E-9, 0.63303483918, 3274.1250177854), new Vsop87.LnVsop(4.51E-9, 0.35861793151, 6665.9723822146), new Vsop87.LnVsop(5.41E-9, 1.89116221008, 9866.4168806652), new Vsop87.LnVsop(4.41E-9, 5.47800914687, 4407.1079038898), new Vsop87.LnVsop(4.1E-9, 1.94403991211, 10020.8569590312), new Vsop87.LnVsop(5.44E-9, 3.15066022776, 8535.8571590342), new Vsop87.LnVsop(4.02E-9, 3.25745210946, 5820.9149246468), new Vsop87.LnVsop(4.05E-9, 0.9374765745, 2295.4575905122), new Vsop87.LnVsop(4.16E-9, 1.42792982324, 21947.1113727), new Vsop87.LnVsop(4.15E-9, 3.32867165254, 8859.3625756916), new Vsop87.LnVsop(4.07E-9, 0.86210907189, 29026.48522950779), new Vsop87.LnVsop(3.99E-9, 4.6547635645, 4825.544916394), new Vsop87.LnVsop(4.16E-9, 2.62133861173, 38.1330356378), new Vsop87.LnVsop(4.03E-9, 1.68400791647, 9588.1255422226), new Vsop87.LnVsop(4.13E-9, 5.34053015386, 3189.5647568569), new Vsop87.LnVsop(4.31E-9, 3.10172506449, 11216.284290324), new Vsop87.LnVsop(4.94E-9, 4.57792960212, 8542.970706035), new Vsop87.LnVsop(3.83E-9, 4.90093906321, 19146.7592661418), new Vsop87.LnVsop(4.56E-9, 1.17955496121, 10610.9021071076), new Vsop87.LnVsop(4.2E-9, 0.03239467048, 3192.5337022735), new Vsop87.LnVsop(3.78E-9, 0.19461410317, 2067.9314010726), new Vsop87.LnVsop(4.25E-9, 4.33864174857, 220.4126424388), new Vsop87.LnVsop(4.14E-9, 1.15478222156, 6643.0918177618), new Vsop87.LnVsop(3.9E-9, 4.75915594442, 6414.6178116778), new Vsop87.LnVsop(3.85E-9, 2.74383378093, 1854.6323056346), new Vsop87.LnVsop(3.82E-9, 3.26274102234, 31022.7531708562), new Vsop87.LnVsop(3.99E-9, 1.37709427447, 9654.612951137), new Vsop87.LnVsop(3.81E-9, 4.18323991778, 6696.4773245846), new Vsop87.LnVsop(3.78E-9, 5.87644939998, 6357.7194367422), new Vsop87.LnVsop(3.74E-9, 4.16579540067, 13553.8979729108), new Vsop87.LnVsop(4.04E-9, 3.12419888471, 3723.4917052708), new Vsop87.LnVsop(3.93E-9, 5.81756122718, 3490.1756238344), new Vsop87.LnVsop(3.57E-9, 3.99005864695, 8958.9322315612), new Vsop87.LnVsop(3.73E-9, 1.27017379563, 2111.6503133776), new Vsop87.LnVsop(4.94E-9, 4.66290046895, 1435.1476617594), new Vsop87.LnVsop(3.9E-9, 2.02097473321, 1903.4368125012), new Vsop87.LnVsop(3.79E-9, 4.08720452061, 10706.8813343254), new Vsop87.LnVsop(3.65E-9, 2.26917834367, 28628.3362260996), new Vsop87.LnVsop(4.61E-9, 1.90079945086, 25287.7237993998), new Vsop87.LnVsop(3.83E-9, 2.18698994244, 16276.463942623), new Vsop87.LnVsop(3.64E-9, 3.25068295862, 5095.6750764648), new Vsop87.LnVsop(4.31E-9, 1.79617275249, 6709.6740408674), new Vsop87.LnVsop(3.83E-9, 4.73047210613, 3981.490034082), new Vsop87.LnVsop(3.83E-9, 2.72628596393, 3472.1543883862), new Vsop87.LnVsop(3.38E-9, 1.71242732923, 224.3447957019), new Vsop87.LnVsop(3.36E-9, 5.78510056191, 26880.3198130326), new Vsop87.LnVsop(3.58E-9, 3.45328915967, 15.252471185), new Vsop87.LnVsop(3.86E-9, 6.2007281038, 8671.9698704406), new Vsop87.LnVsop(3.35E-9, 1.10573866929, 59.3738619136), new Vsop87.LnVsop(3.94E-9, 4.02046774112, 2075.0449480734), new Vsop87.LnVsop(4.04E-9, 3.27554084958, 931.3630868518), new Vsop87.LnVsop(3.32E-9, 4.57985270157, 8982.810669309), new Vsop87.LnVsop(3.18E-9, 3.29010380724, 9485.032768004), new Vsop87.LnVsop(3.41E-9, 6.08550074779, 17085.9586657222), new Vsop87.LnVsop(3.17E-9, 4.05379693363, 3450.8187479192), new Vsop87.LnVsop(3.08E-9, 1.01972298903, 18606.4989460002), new Vsop87.LnVsop(3.69E-9, 2.84012437948, 4392.8808098882), new Vsop87.LnVsop(4.19E-9, 2.79753443827, 5106.3790521174), new Vsop87.LnVsop(3.01E-9, 5.54688241213, 3041.4860324306), new Vsop87.LnVsop(2.99E-9, 5.01812614127, 2810.9387152574), new Vsop87.LnVsop(3.57E-9, 1.1586695802, 4076.4889402316), new Vsop87.LnVsop(2.99E-9, 2.98735462676, 2810.904207953), new Vsop87.LnVsop(3.6E-9, 5.83226121443, 26724.8994135984), new Vsop87.LnVsop(3.64E-9, 0.71456222108, 3209.0704650134), new Vsop87.LnVsop(3.88E-9, 5.01180713189, 12323.4230960088), new Vsop87.LnVsop(3.36E-9, 4.60072831728, 9602.3526362242), new Vsop87.LnVsop(3.71E-9, 2.23508025241, 4996.172730898), new Vsop87.LnVsop(3.38E-9, 5.83235701604, 4246.0691233646), new Vsop87.LnVsop(3.09E-9, 5.2476940431, 13171.0014406876), new Vsop87.LnVsop(2.94E-9, 2.20962875276, 11140.5930722022), new Vsop87.LnVsop(2.92E-9, 3.0717230294, 11670.2840372968), new Vsop87.LnVsop(2.9E-9, 0.39535768288, 2412.772458197), new Vsop87.LnVsop(3.46E-9, 1.74151420484, 5617.9107699473), new Vsop87.LnVsop(2.96E-9, 6.04933382807, 9499.2598620056), new Vsop87.LnVsop(3.02E-9, 3.01024090578, 7483.5887758458), new Vsop87.LnVsop(3.94E-9, 2.12229107241, 6475.0393049624), new Vsop87.LnVsop(2.83E-9, 0.52912721426, 16699.53901514999), new Vsop87.LnVsop(3.38E-9, 4.94606216822, 5625.7750764735), new Vsop87.LnVsop(2.99E-9, 5.26277094099, 9945.5712088238), new Vsop87.LnVsop(2.79E-9, 0.54063870001, 3226.2133197864), new Vsop87.LnVsop(3.09E-9, 3.17514941942, 14047.4937610252), new Vsop87.LnVsop(3.83E-9, 3.23919312949, 10022.8176011676), new Vsop87.LnVsop(3.12E-9, 2.74287650032, 6652.7756659318), new Vsop87.LnVsop(3.66E-9, 5.48470145487, 3561.0250691386), new Vsop87.LnVsop(2.72E-9, 0.11219838826, 7314.0085927128), new Vsop87.LnVsop(2.81E-9, 5.15132055967, 2825.1485556068), new Vsop87.LnVsop(3.25E-9, 2.45554148062, 8436.2875031646), new Vsop87.LnVsop(2.92E-9, 3.3372052863, 9468.267877257), new Vsop87.LnVsop(2.66E-9, 1.64531471079, 4253.1826703654), new Vsop87.LnVsop(2.66E-9, 1.6968937023, 647.0108333148), new Vsop87.LnVsop(2.6E-9, 2.54461537647, 20.3553193988), new Vsop87.LnVsop(2.75E-9, 2.78381954796, 2970.9126107594), new Vsop87.LnVsop(2.95E-9, 5.96367554546, 4025.6564809258), new Vsop87.LnVsop(2.65E-9, 4.00664363477, 2171.0241752912), new Vsop87.LnVsop(3.1E-9, 1.40846068056, 589.0648270082), new Vsop87.LnVsop(2.67E-9, 3.01024875581, 6518.7582172674), new Vsop87.LnVsop(2.59E-9, 5.20888482694, 7366.2689076256), new Vsop87.LnVsop(2.74E-9, 0.75900688956, 3735.238311759), new Vsop87.LnVsop(3.05E-9, 6.19137588974, 6677.3435180416), new Vsop87.LnVsop(2.65E-9, 3.25039598109, 24889.5747959916), new Vsop87.LnVsop(2.6E-9, 1.36534128911, 846.0828347512), new Vsop87.LnVsop(2.79E-9, 6.19278334118, 16706.585251848), new Vsop87.LnVsop(2.53E-9, 4.14762846559, 5642.1982426092), new Vsop87.LnVsop(2.57E-9, 0.08460483453, 13362.3823964964), new Vsop87.LnVsop(3.31E-9, 6.27239577743, 16304.9131300908), new Vsop87.LnVsop(2.59E-9, 2.03595864791, 2089.782230399), new Vsop87.LnVsop(2.43E-9, 1.92565816384, 6418.1409300268), new Vsop87.LnVsop(2.44E-9, 1.3732511941, 2277.2983432475), new Vsop87.LnVsop(3.03E-9, 3.78453746314, 28230.18722269139), new Vsop87.LnVsop(2.59E-9, 4.79543939498, 6657.3464156518), new Vsop87.LnVsop(2.38E-9, 1.18977479528, 3171.0322435668), new Vsop87.LnVsop(2.56E-9, 1.01427800277, 568.8218740274), new Vsop87.LnVsop(2.36E-9, 5.56425829083, 14.2270940016), new Vsop87.LnVsop(2.37E-9, 2.97284129671, 27682.1407441564), new Vsop87.LnVsop(2.38E-9, 2.47584234436, 5430.3946570988), new Vsop87.LnVsop(2.34E-9, 4.3495679315, 6675.7019290922), new Vsop87.LnVsop(2.38E-9, 0.13886525152, 3742.284548457), new Vsop87.LnVsop(3.05E-9, 4.59739079661, 6685.1061887576), new Vsop87.LnVsop(3.0E-9, 3.81293221774, 1190.9238918756), new Vsop87.LnVsop(3.23E-9, 1.67391005108, 4922.5717749828), new Vsop87.LnVsop(2.32E-9, 4.82574695052, 9070.1188738488), new Vsop87.LnVsop(2.36E-9, 2.40662610715, 3620.3989310522), new Vsop87.LnVsop(2.51E-9, 5.04374120897, 1905.4647649404), new Vsop87.LnVsop(2.6E-9, 4.54521365935, 2285.1626497737), new Vsop87.LnVsop(2.63E-9, 0.63920765354, 2008.557539159), new Vsop87.LnVsop(3.01E-9, 3.78342344549, 34363.365597556), new Vsop87.LnVsop(2.82E-9, 5.00900221145, 5607.6158292088), new Vsop87.LnVsop(2.52E-9, 5.7254086168, 17468.8551979454), new Vsop87.LnVsop(2.88E-9, 2.26316945289, 6621.850991486), new Vsop87.LnVsop(2.24E-9, 3.76343722525, 10042.6126755918), new Vsop87.LnVsop(2.51E-9, 5.51643360482, 3416.8784979754), new Vsop87.LnVsop(2.25E-9, 5.50723076933, 4936.7988689844), new Vsop87.LnVsop(2.37E-9, 4.8608696298, 14158.7477136156), new Vsop87.LnVsop(2.49E-9, 1.06089727346, 3313.210870603), new Vsop87.LnVsop(2.25E-9, 2.16307488317, 3936.7908007088), new Vsop87.LnVsop(2.19E-9, 1.70468184895, 18451.07854656599), new Vsop87.LnVsop(2.87E-9, 5.70519621324, 792.7748884674), new Vsop87.LnVsop(2.44E-9, 1.94639665939, 3.5904286518), new Vsop87.LnVsop(2.64E-9, 1.49529049866, 6364.832983743), new Vsop87.LnVsop(2.54E-9, 5.34446995415, 5401.4302807716), new Vsop87.LnVsop(2.22E-9, 1.30177724842, 29822.7832363242), new Vsop87.LnVsop(2.23E-9, 2.66657203577, 31968.9486527994), new Vsop87.LnVsop(3.06E-9, 6.06259585249, 14061.7208550268), new Vsop87.LnVsop(2.18E-9, 5.18889136792, 23017.0626579362), new Vsop87.LnVsop(2.36E-9, 3.3073866803, 1197.9701285736), new Vsop87.LnVsop(2.14E-9, 2.72627704766, 6740.5987153132), new Vsop87.LnVsop(2.33E-9, 1.62260863687, 10001.061884607), new Vsop87.LnVsop(2.7E-9, 0.90714933652, 6155.057006654), new Vsop87.LnVsop(2.14E-9, 2.4862401943, 5355.2358814886), new Vsop87.LnVsop(2.21E-9, 2.98361193277, 131.5419616864), new Vsop87.LnVsop(2.1E-9, 2.62093674086, 10124.930054318), new Vsop87.LnVsop(2.11E-9, 5.27490544059, 13355.3361597984), new Vsop87.LnVsop(2.59E-9, 1.25267305827, 2641.3412784722), new Vsop87.LnVsop(2.13E-9, 4.1264282168, 31570.7996493912), new Vsop87.LnVsop(2.85E-9, 0.85763558421, 8749.1562544722), new Vsop87.LnVsop(2.43E-9, 2.44748800604, 3311.18291816379), new Vsop87.LnVsop(2.26E-9, 5.48392576152, 7203.8022714934), new Vsop87.LnVsop(2.51E-9, 4.67012983731, 6666.997759398), new Vsop87.LnVsop(2.64E-9, 3.72622435629, 6747.712262314), new Vsop87.LnVsop(2.6E-9, 3.67749190897, 6645.1969867222), new Vsop87.LnVsop(2.09E-9, 4.31928920378, 3337.8609160888), new Vsop87.LnVsop(2.07E-9, 4.73304189825, 6679.7403806913), new Vsop87.LnVsop(2.06E-9, 1.11183726079, 5888.4499649322), new Vsop87.LnVsop(2.15E-9, 4.11048880636, 3378.7454623376), new Vsop87.LnVsop(2.13E-9, 0.34186471358, 6686.747777707), new Vsop87.LnVsop(2.14E-9, 2.95860972924, 10824.2012025456), new Vsop87.LnVsop(2.04E-9, 0.73237459786, 3.9321532631), new Vsop87.LnVsop(2.19E-9, 0.88578298306, 19513.9835951042), new Vsop87.LnVsop(2.49E-9, 0.99691404829, 5753.3848848968), new Vsop87.LnVsop(2.05E-9, 2.60851826933, 2771.7905526724), new Vsop87.LnVsop(2.44E-9, 2.73638895956, 5989.0672521728), new Vsop87.LnVsop(2.01E-9, 3.3179100789, 6850.8050365326), new Vsop87.LnVsop(2.58E-9, 2.77004595067, 2480.302497947), new Vsop87.LnVsop(2.46E-9, 3.34468800742, 3333.9287628257), new Vsop87.LnVsop(2.57E-9, 5.95927379256, 13362.517017102), new Vsop87.LnVsop(2.14E-9, 4.83852070028, 6681.6449294932), new Vsop87.LnVsop(1.97E-9, 0.55202541351, 735.8765135318), new Vsop87.LnVsop(2.16E-9, 4.02521804874, 3133.9116894032), new Vsop87.LnVsop(2.55E-9, 2.66015039822, 1062.9050485382), new Vsop87.LnVsop(2.09E-9, 0.67381599651, 13892.1406718938), new Vsop87.LnVsop(1.93E-9, 1.52645682131, 949.1756089698), new Vsop87.LnVsop(1.95E-9, 2.87576501755, 21548.9623692918), new Vsop87.LnVsop(2.23E-9, 1.0931548313, 6148.010769956), new Vsop87.LnVsop(2.19E-9, 1.52537634511, 6660.8695340008), new Vsop87.LnVsop(2.44E-9, 4.10741249432, 22487.3716928416), new Vsop87.LnVsop(1.92E-9, 2.90573573946, 8799.988713778), new Vsop87.LnVsop(2.06E-9, 5.111758054, 4140.4335518652), new Vsop87.LnVsop(2.15E-9, 0.2052395808, 4782.87363546), new Vsop87.LnVsop(1.93E-9, 3.19008521837, 6756.0064519669), new Vsop87.LnVsop(1.88E-9, 1.03828263764, 9374.8264467846), new Vsop87.LnVsop(1.88E-9, 2.50123675826, 6944.3087767724), new Vsop87.LnVsop(2.6E-9, 1.61746038838, 2011.1003364398), new Vsop87.LnVsop(2.18E-9, 0.84212090762, 6717.252720077), new Vsop87.LnVsop(2.0E-9, 2.4309058287, 10018.2468514476), new Vsop87.LnVsop(1.99E-9, 5.81238461808, 4289.7880356696), new Vsop87.LnVsop(1.95E-9, 3.02792862154, 32765.2466596158), new Vsop87.LnVsop(2.14E-9, 5.95026024981, 6680.804777306), new Vsop87.LnVsop(2.48E-9, 5.77658456809, 15806.146839442), new Vsop87.LnVsop(1.85E-9, 3.13072183492, 3253.30422216), new Vsop87.LnVsop(2.46E-9, 2.58153533312, 1795.258443721), new Vsop87.LnVsop(1.88E-9, 4.02461769542, 14577.1847261198), new Vsop87.LnVsop(2.34E-9, 3.36641746142, 8965.9784682592), new Vsop87.LnVsop(1.85E-9, 0.96707446746, 2604.735913168), new Vsop87.LnVsop(1.84E-9, 1.46821995395, 1437.1756141986), new Vsop87.LnVsop(2.32E-9, 5.61892824149, 227.476132789), new Vsop87.LnVsop(2.11E-9, 4.23517070569, 16703.07938715119), new Vsop87.LnVsop(1.96E-9, 2.80582160764, 2796.6943676036), new Vsop87.LnVsop(1.98E-9, 5.9237380141, 4133.3873151672), new Vsop87.LnVsop(2.23E-9, 1.81801741599, 3184.2117061974), new Vsop87.LnVsop(1.84E-9, 4.92796517214, 8166.1573430938), new Vsop87.LnVsop(2.44E-9, 5.81091817596, 29424.634232916), new Vsop87.LnVsop(1.85E-9, 2.03013271464, 6674.1786167016), new Vsop87.LnVsop(1.81E-9, 2.71503450485, 4186.695261451), new Vsop87.LnVsop(2.25E-9, 3.1230244425, 3613.2853840514), new Vsop87.LnVsop(1.97E-9, 3.6587975511, 4271.9755135516), new Vsop87.LnVsop(2.41E-9, 0.75274729025, 3232.9489027612), new Vsop87.LnVsop(2.22E-9, 1.69212877746, 11614.4332937322), new Vsop87.LnVsop(1.82E-9, 1.54430188037, 9947.0556815321), new Vsop87.LnVsop(1.81E-9, 1.8004497198, 6717.8302187038), new Vsop87.LnVsop(1.78E-9, 4.39527633207, 9886.772200064), new Vsop87.LnVsop(1.95E-9, 5.90931353628, 6705.1032911474), new Vsop87.LnVsop(1.82E-9, 2.77245257008, 6887.4104018368), new Vsop87.LnVsop(2.03E-9, 5.23403035771, 7586.6815500644), new Vsop87.LnVsop(1.81E-9, 4.6138108133, 3361.9480671668), new Vsop87.LnVsop(1.83E-9, 5.23652106144, 6578.132079181), new Vsop87.LnVsop(2.07E-9, 0.88261302661, 10156.9023601348), new Vsop87.LnVsop(1.83E-9, 4.98729652435, 6670.5881880498), new Vsop87.LnVsop(1.73E-9, 3.89701254344, 6019.9919266186), new Vsop87.LnVsop(1.76E-9, 0.17686337588, 401.6721217572), new Vsop87.LnVsop(2.17E-9, 1.94931402901, 8226.5788363784), new Vsop87.LnVsop(2.25E-9, 2.30388003779, 1879.5583747534), new Vsop87.LnVsop(1.9E-9, 2.71370120496, 742.9900605326), new Vsop87.LnVsop(1.83E-9, 5.82189577442, 8962.438096258), new Vsop87.LnVsop(1.72E-9, 3.87119927472, 10028.9508271002), new Vsop87.LnVsop(1.97E-9, 1.88682060252, 5032.7780962022), new Vsop87.LnVsop(1.72E-9, 2.55622468142, 3188.7151456146), new Vsop87.LnVsop(2.17E-9, 1.64882877306, 21265.5231265202), new Vsop87.LnVsop(2.09E-9, 5.78130707501, 3343.3639373108), new Vsop87.LnVsop(1.87E-9, 5.23125369896, 2125.8774073792), new Vsop87.LnVsop(1.97E-9, 6.17705206967, 6947.8318951214), new Vsop87.LnVsop(1.67E-9, 6.26759251026, 15849.865751747), new Vsop87.LnVsop(1.8E-9, 5.16028069861, 27832.0382192832), new Vsop87.LnVsop(1.89E-9, 2.38894304278, 3212.5935833624), new Vsop87.LnVsop(1.76E-9, 0.82131139167, 14591.4118201214), new Vsop87.LnVsop(1.81E-9, 2.19749893549, 16703.0448798468), new Vsop87.LnVsop(1.72E-9, 4.65456846579, 9175.7544453482), new Vsop87.LnVsop(1.64E-9, 2.10466608169, 6688.2710900976), new Vsop87.LnVsop(2.14E-9, 1.83336768044, 1596.1191319818), new Vsop87.LnVsop(1.64E-9, 1.68898542913, 3468.6312700372), new Vsop87.LnVsop(1.83E-9, 1.56948205762, 8962.4726035624), new Vsop87.LnVsop(1.67E-9, 1.08651405162, 20426.571092422), new Vsop87.LnVsop(1.91E-9, 5.54553650068, 2806.9893083421), new Vsop87.LnVsop(1.67E-9, 0.91858800204, 4001.8453534808), new Vsop87.LnVsop(1.65E-9, 3.44053809432, 14421.8316369884), new Vsop87.LnVsop(1.66E-9, 5.87188270355, 4452.2546718018), new Vsop87.LnVsop(2.0E-9, 5.63217439694, 31172.650645983), new Vsop87.LnVsop(1.71E-9, 2.84145855585, 5490.300961524), new Vsop87.LnVsop(1.89E-9, 0.57701168949, 2973.3880977374), new Vsop87.LnVsop(1.63E-9, 2.42147685134, 6314.0005244372), new Vsop87.LnVsop(2.22E-9, 3.1479057545, 11610.9101753832), new Vsop87.LnVsop(2.24E-9, 2.35840793377, 9638.9407478762), new Vsop87.LnVsop(2.06E-9, 3.13951282157, 3336.6802734367), new Vsop87.LnVsop(1.62E-9, 6.16561793774, 3547.3131639964), new Vsop87.LnVsop(1.63E-9, 5.40393445608, 23.8784377478), new Vsop87.LnVsop(1.58E-9, 5.87599422933, 4606.1799053262), new Vsop87.LnVsop(1.57E-9, 5.56903233932, 4503.0871311076), new Vsop87.LnVsop(1.56E-9, 3.08339691033, 3448.2759506384), new Vsop87.LnVsop(1.57E-9, 4.06627173793, 5209.471826336), new Vsop87.LnVsop(2.01E-9, 2.56498664777, 7321.1221397136), new Vsop87.LnVsop(2.11E-9, 1.66624816725, 3304.0070613956), new Vsop87.LnVsop(1.58E-9, 3.66262944909, 6997.6167230562), new Vsop87.LnVsop(1.62E-9, 0.0529498106, 11925.2740926006), new Vsop87.LnVsop(1.59E-9, 5.73384451548, 1265.5674786264), new Vsop87.LnVsop(1.65E-9, 1.72702001722, 1744.493294718), new Vsop87.LnVsop(1.69E-9, 0.46442541075, 17101.2111369072), new Vsop87.LnVsop(1.57E-9, 5.95120005632, 8584.6616659008), new Vsop87.LnVsop(1.81E-9, 5.48699984659, 3319.2767862328), new Vsop87.LnVsop(1.58E-9, 3.38811845461, 8742.0427074714), new Vsop87.LnVsop(1.99E-9, 2.86360029577, 10025.4277087512), new Vsop87.LnVsop(1.74E-9, 4.73514708467, 9389.0535407862), new Vsop87.LnVsop(2.03E-9, 1.71629299124, 699.2711482276), new Vsop87.LnVsop(1.62E-9, 1.85939646363, 1329.51209026), new Vsop87.LnVsop(1.86E-9, 2.44573687199, 2814.8536148683), new Vsop87.LnVsop(1.52E-9, 5.0861661053, 3322.7999045818), new Vsop87.LnVsop(1.8E-9, 2.71480297259, 2910.4911174748), new Vsop87.LnVsop(1.91E-9, 4.12947825174, 9911.63095888), new Vsop87.LnVsop(1.78E-9, 4.58774508036, 6685.1570066627), new Vsop87.LnVsop(1.68E-9, 3.13703791538, 5621.9102335132), new Vsop87.LnVsop(1.85E-9, 4.32212013296, 323.5054166574), new Vsop87.LnVsop(1.56E-9, 1.10107924002, 3710.3122426402), new Vsop87.LnVsop(1.5E-9, 1.23635082247, 4193.8088084518), new Vsop87.LnVsop(1.99E-9, 1.83524172935, 3436.5916539176), new Vsop87.LnVsop(1.65E-9, 3.32970937124, 1272.6810256272), new Vsop87.LnVsop(1.49E-9, 0.13370088787, 36.0278666774), new Vsop87.LnVsop(1.95E-9, 0.55473364753, 15265.8865193004), new Vsop87.LnVsop(1.53E-9, 3.46485402109, 22324.9050567094), new Vsop87.LnVsop(1.68E-9, 3.54553456767, 5621.7756129076), new Vsop87.LnVsop(1.56E-9, 4.16889740894, 16894.5103996106), new Vsop87.LnVsop(1.46E-9, 1.24102730441, 3372.5847325166), new Vsop87.LnVsop(1.63E-9, 0.44791234897, 37895.4262903674), new Vsop87.LnVsop(1.54E-9, 5.63537863362, 3185.2593375684), new Vsop87.LnVsop(1.97E-9, 3.23364188387, 3774.3241645766), new Vsop87.LnVsop(1.79E-9, 3.47455924555, 8564.306346502), new Vsop87.LnVsop(1.85E-9, 2.18250548132, 802.3639224462), new Vsop87.LnVsop(1.55E-9, 2.58725745796, 1883.0814931024), new Vsop87.LnVsop(1.45E-9, 2.62035460481, 3368.0139827966), new Vsop87.LnVsop(1.48E-9, 2.5171017883, 3262.8618827159), new Vsop87.LnVsop(1.85E-9, 3.03939668358, 3354.8395207014), new Vsop87.LnVsop(1.9E-9, 6.00165436525, 4427.3959129858), new Vsop87.LnVsop(1.79E-9, 6.01012688855, 6691.8615187494), new Vsop87.LnVsop(1.49E-9, 5.3910689199, 2945.9865416406), new Vsop87.LnVsop(1.43E-9, 3.37267915445, 3468.5639597344), new Vsop87.LnVsop(1.6E-9, 2.16704681601, 0.9803210682), new Vsop87.LnVsop(1.88E-9, 0.65797619362, 369.6998159404), new Vsop87.LnVsop(1.9E-9, 1.63240538928, 2324.9494088156), new Vsop87.LnVsop(1.86E-9, 1.44849264285, 1015.6630178842), new Vsop87.LnVsop(1.39E-9, 1.27677785334, 6549.6828917132), new Vsop87.LnVsop(1.62E-9, 4.35256558989, 4005.3684718298), new Vsop87.LnVsop(1.37E-9, 2.20364649213, 1765.7666254176), new Vsop87.LnVsop(1.36E-9, 0.45455359025, 3193.8007401762), new Vsop87.LnVsop(1.48E-9, 5.14035003664, 1641.3332101966), new Vsop87.LnVsop(1.53E-9, 5.97404356743, 3568.0885594888), new Vsop87.LnVsop(1.42E-9, 3.30600789729, 6151.5166346528), new Vsop87.LnVsop(1.88E-9, 0.98977442881, 2538.2485042536), new Vsop87.LnVsop(1.43E-9, 3.0640341245, 1612.9513330316), new Vsop87.LnVsop(1.64E-9, 1.67483546459, 2751.5475996916), new Vsop87.LnVsop(1.39E-9, 4.12207666842, 5813.291189322), new Vsop87.LnVsop(1.44E-9, 1.9699039998, 2014.6234547888), new Vsop87.LnVsop(1.45E-9, 5.54086212771, 3152.68727893721), new Vsop87.LnVsop(1.32E-9, 0.96753793729, 3487.4241132234), new Vsop87.LnVsop(1.48E-9, 1.54957786715, 7696.8878712838), new Vsop87.LnVsop(1.76E-9, 2.35644988345, 11346.7786206394), new Vsop87.LnVsop(1.33E-9, 6.01160718148, 34513.2630726828), new Vsop87.LnVsop(1.31E-9, 2.48606821423, 1353.3905280078), new Vsop87.LnVsop(1.33E-9, 3.0130058204, 3283.7140517642), new Vsop87.LnVsop(1.42E-9, 5.33677852971, 6151.5511419572), new Vsop87.LnVsop(1.3E-9, 5.25558990337, 13212.8865096646), new Vsop87.LnVsop(1.65E-9, 1.32559153829, 6510.5519827804), new Vsop87.LnVsop(1.28E-9, 6.07261046225, 3362.4632560262), new Vsop87.LnVsop(1.43E-9, 1.04060603784, 3351.6581269637), new Vsop87.LnVsop(1.42E-9, 0.29094317859, 3212.6608936652), new Vsop87.LnVsop(1.75E-9, 3.17574071112, 6701.5801727984), new Vsop87.LnVsop(1.29E-9, 2.90662663637, 6812.766815086), new Vsop87.LnVsop(1.4E-9, 5.87139171391, 6382.0984591304), new Vsop87.LnVsop(1.25E-9, 1.62548810323, 10191.4174632324), new Vsop87.LnVsop(1.28E-9, 3.55358985291, 3223.2925584796), new Vsop87.LnVsop(1.28E-9, 0.49984480965, 10264.5658840734), new Vsop87.LnVsop(1.44E-9, 4.44112984395, 7100.7094972748), new Vsop87.LnVsop(1.24E-9, 2.02283056333, 6724.9437657046), new Vsop87.LnVsop(1.34E-9, 0.19295362623, 3130.8364496108), new Vsop87.LnVsop(1.26E-9, 4.30028787044, 1971.9521738548), new Vsop87.LnVsop(1.33E-9, 5.00404182206, 11883.5831327348), new Vsop87.LnVsop(1.24E-9, 0.73963594764, 1485.9801210652), new Vsop87.LnVsop(1.36E-9, 0.79050065403, 2281.2477501628), new Vsop87.LnVsop(1.43E-9, 3.34238727539, 3181.6689089166), new Vsop87.LnVsop(1.23E-9, 0.47283015475, 3347.2960905739), new Vsop87.LnVsop(1.52E-9, 5.0146445546, 3358.4249488178), new Vsop87.LnVsop(1.37E-9, 5.73257098528, 5244.049239201), new Vsop87.LnVsop(1.22E-9, 1.37003015612, 3370.0419352358), new Vsop87.LnVsop(1.3E-9, 0.90844304292, 3427.9206312396), new Vsop87.LnVsop(1.35E-9, 3.56996218538, 3229.4257844122), new Vsop87.LnVsop(1.21E-9, 3.19494013546, 4576.6880870228), new Vsop87.LnVsop(1.18E-9, 2.08835676181, 2917.5373541728), new Vsop87.LnVsop(1.22E-9, 3.91901660011, 4957.0868780804), new Vsop87.LnVsop(1.19E-9, 4.05658830695, 10448.4354709754), new Vsop87.LnVsop(1.5E-9, 5.89116199733, 966.9708774356), new Vsop87.LnVsop(1.36E-9, 5.05814390558, 2281.2132428584), new Vsop87.LnVsop(1.23E-9, 3.58787674774, 3318.7615973734), new Vsop87.LnVsop(1.27E-9, 1.19117739028, 1461.0540519464), new Vsop87.LnVsop(1.53E-9, 0.37313768413, 6533.1461289733), new Vsop87.LnVsop(1.41E-9, 0.57680802743, 13532.0298899322), new Vsop87.LnVsop(1.45E-9, 1.73326841662, 6637.5059410946), new Vsop87.LnVsop(1.39E-9, 5.30202800327, 14128.2427712456), new Vsop87.LnVsop(1.33E-9, 3.27057351136, 11876.469585734), new Vsop87.LnVsop(1.38E-9, 1.9429102272, 2921.6880277992), new Vsop87.LnVsop(1.15E-9, 5.9954235348, 11986.6759069534), new Vsop87.LnVsop(1.19E-9, 5.14629852269, 15636.566656309), new Vsop87.LnVsop(1.52E-9, 5.66773813508, 6530.1771835567), new Vsop87.LnVsop(1.34E-9, 2.42024775707, 7167.1969061892), new Vsop87.LnVsop(1.23E-9, 0.05231448695, 9801.4246376606), new Vsop87.LnVsop(1.17E-9, 4.588208417, 24491.4257925834), new Vsop87.LnVsop(1.26E-9, 1.38941012006, 169.580183133), new Vsop87.LnVsop(1.15E-9, 3.75330944008, 3343.1552239806), new Vsop87.LnVsop(1.22E-9, 1.21803689218, 3067.9394693482), new Vsop87.LnVsop(1.28E-9, 1.42747405914, 16063.164847185), new Vsop87.LnVsop(1.32E-9, 4.73582902892, 2267.003402509), new Vsop87.LnVsop(1.24E-9, 0.77046518514, 12465.5344127422), new Vsop87.LnVsop(1.22E-9, 3.66231014051, 8756.269801473), new Vsop87.LnVsop(1.34E-9, 0.81836719868, 3123.7902129128), new Vsop87.LnVsop(1.18E-9, 0.15011057158, 18849.2275499742), new Vsop87.LnVsop(1.2E-9, 4.1142231902, 604.8497407048), new Vsop87.LnVsop(1.25E-9, 6.00462398457, 1442.2612087602), new Vsop87.LnVsop(1.09E-9, 1.4639407844, 2854.6403739102), new Vsop87.LnVsop(1.08E-9, 2.11691804266, 43.718912305), new Vsop87.LnVsop(1.3E-9, 1.4318591196, 3370.1042450032), new Vsop87.LnVsop(1.33E-9, 2.31239626195, 9072.6616711296), new Vsop87.LnVsop(1.09E-9, 1.33718905917, 10081.211142013), new Vsop87.LnVsop(1.07E-9, 1.71826183287, 1655.5603041982), new Vsop87.LnVsop(1.14E-9, 3.89822123904, 2963.238818784), new Vsop87.LnVsop(1.06E-9, 1.99989592271, 3497.0131472022), new Vsop87.LnVsop(1.13E-9, 2.53877396935, 5525.8636959926), new Vsop87.LnVsop(1.06E-9, 5.79020088314, 1.4844727083), new Vsop87.LnVsop(1.3E-9, 0.80396347034, 3397.5108016354), new Vsop87.LnVsop(1.3E-9, 0.05444365195, 2185.2512692928), new Vsop87.LnVsop(1.06E-9, 5.61886924411, 4878.8528626778), new Vsop87.LnVsop(1.04E-9, 5.03145022037, 1751.5222777638), new Vsop87.LnVsop(1.46E-9, 2.57659804831, 3308.640120883), new Vsop87.LnVsop(1.03E-9, 3.2958939473, 4379.6390374902), new Vsop87.LnVsop(1.04E-9, 0.77903634693, 1751.5567850682), new Vsop87.LnVsop(1.18E-9, 4.11883909157, 10927.2939767642), new Vsop87.LnVsop(1.04E-9, 3.67398692909, 21393.5419698576), new Vsop87.LnVsop(1.06E-9, 2.2569870467, 13207.029307365), new Vsop87.LnVsop(1.26E-9, 1.10289326964, 6680.7949702729), new Vsop87.LnVsop(1.06E-9, 5.20738400843, 10.6366653498), new Vsop87.LnVsop(1.02E-9, 3.81767069896, 6670.1791531357), new Vsop87.LnVsop(1.01E-9, 5.96290213118, 5220.1708014532), new Vsop87.LnVsop(1.15E-9, 0.57440366245, 13421.8235687128), new Vsop87.LnVsop(1.01E-9, 1.87446179149, 9161.5273513466), new Vsop87.LnVsop(1.06E-9, 6.20183341619, 3717.9860346156), new Vsop87.LnVsop(1.1E-9, 5.45855327266, 7214.4389368432), new Vsop87.LnVsop(1.3E-9, 0.47831160164, 13575.7488022372), new Vsop87.LnVsop(1.12E-9, 6.25562428346, 3338.069629419), new Vsop87.LnVsop(1.22E-9, 0.14768895879, 16489.763038061), new Vsop87.LnVsop(1.01E-9, 0.55693458655, 3337.1566186536), new Vsop87.LnVsop(1.07E-9, 3.90976860359, 11904.9187732018), new Vsop87.LnVsop(1.01E-9, 1.70023673577, 3002.3697277168), new Vsop87.LnVsop(9.7E-10, 1.94103649254, 5562.4690612968), new Vsop87.LnVsop(1.0E-9, 2.35767934317, 3337.0720546986), new Vsop87.LnVsop(1.0E-9, 3.76317527562, 3344.152798701), new Vsop87.LnVsop(9.7E-10, 5.19321707062, 5085.1057214178), new Vsop87.LnVsop(9.7E-10, 1.69499718348, 3517.3061568336), new Vsop87.LnVsop(1.09E-9, 4.2570546103, 8823.8671515258), new Vsop87.LnVsop(9.6E-10, 3.51646478006, 1505.28780909299), new Vsop87.LnVsop(1.0E-9, 4.38845221965, 3337.106562003), new Vsop87.LnVsop(1.0E-9, 1.73240240188, 3344.11829139661), new Vsop87.LnVsop(1.29E-9, 4.96782688332, 15906.7641266826), new Vsop87.LnVsop(9.7E-10, 0.55962169503, 30774.5016425748), new Vsop87.LnVsop(9.6E-10, 3.16956558419, 12825.6451947038), new Vsop87.LnVsop(9.9E-10, 1.12288651151, 4029.2469095776), new Vsop87.LnVsop(9.7E-10, 4.42524428441, 21957.680727747), new Vsop87.LnVsop(1.2E-9, 6.18521207978, 9698.331863442), new Vsop87.LnVsop(1.26E-9, 3.40521738552, 6681.6547365263), new Vsop87.LnVsop(9.9E-10, 5.29085847404, 5096.0841113789), new Vsop87.LnVsop(1.02E-9, 2.46824311953, 1755.062649765), new Vsop87.LnVsop(1.15E-9, 6.10031030713, 3145.6410422392), new Vsop87.LnVsop(1.3E-9, 2.24417329092, 1954.7171503636), new Vsop87.LnVsop(9.2E-10, 0.97154538929, 927.8399685028), new Vsop87.LnVsop(9.7E-10, 1.11670836674, 3341.7930693519), new Vsop87.LnVsop(1.1E-9, 2.51719415565, 1045.1548361876), new Vsop87.LnVsop(1.07E-9, 5.62562598823, 8425.7181481176), new Vsop87.LnVsop(9.9E-10, 2.5686855505, 16858.41522263039), new Vsop87.LnVsop(9.5E-10, 1.42994211615, 37455.7264959744), new Vsop87.LnVsop(1.04E-9, 5.58969627803, 39048.3225096072), new Vsop87.LnVsop(1.03E-9, 2.13529097914, 10050.2864675672), new Vsop87.LnVsop(9.4E-10, 1.2081104965, 9495.6694333538), new Vsop87.LnVsop(1.18E-9, 2.39940540526, 18208.349942592), new Vsop87.LnVsop(9.7E-10, 1.14141607148, 12089.768681172), new Vsop87.LnVsop(1.0E-9, 1.15512326078, 1385.8952763362), new Vsop87.LnVsop(9.0E-10, 6.18770216893, 34554.8138636676), new Vsop87.LnVsop(9.0E-10, 4.17568982529, 0.0673103028), new Vsop87.LnVsop(9.0E-10, 3.7990042873, 685.044054226), new Vsop87.LnVsop(9.0E-10, 4.51840546059, 10037.0897512844), new Vsop87.LnVsop(9.8E-10, 3.89390262306, 2373.6415492642), new Vsop87.LnVsop(9.5E-10, 5.33609249023, 7636.4663779992), new Vsop87.LnVsop(8.8E-10, 1.47691975375, 9488.6231966558), new Vsop87.LnVsop(9.8E-10, 0.65689906709, 2810.988771908), new Vsop87.LnVsop(9.2E-10, 3.11888534564, 5298.337506553), new Vsop87.LnVsop(8.8E-10, 2.95228544051, 7218.029365495), new Vsop87.LnVsop(9.6E-10, 1.03219628412, 4591.4426230006), new Vsop87.LnVsop(1.23E-9, 5.58913256956, 2735.762685995), new Vsop87.LnVsop(9.5E-10, 6.25308672334, 2942.5307335944), new Vsop87.LnVsop(8.7E-10, 1.50371643513, 9983.7042444616), new Vsop87.LnVsop(9.2E-10, 0.04735290682, 23546.7536230308), new Vsop87.LnVsop(9.0E-10, 2.79573736864, 47477.5637760738), new Vsop87.LnVsop(9.4E-10, 5.68827536044, 6106.8800550648), new Vsop87.LnVsop(8.7E-10, 0.74049208991, 41990.7859328988), new Vsop87.LnVsop(1.01E-9, 0.99308133444, 6614.7374444852), new Vsop87.LnVsop(1.15E-9, 3.49732055752, 4.5034394172), new Vsop87.LnVsop(1.03E-9, 1.06471408085, 2899.7871418222), new Vsop87.LnVsop(8.6E-10, 0.18628425275, 216.822213787), new Vsop87.LnVsop(8.6E-10, 3.29796334238, 4061.751657906), new Vsop87.LnVsop(9.9E-10, 1.06539589813, 2810.8541513024), new Vsop87.LnVsop(1.14E-9, 0.98391969927, 34115.1140692746), new Vsop87.LnVsop(8.8E-10, 1.88203358965, 14867.73751589219), new Vsop87.LnVsop(9.4E-10, 5.0882911537, 7792.8670985016), new Vsop87.LnVsop(8.4E-10, 4.58521734382, 1699.2792165032), new Vsop87.LnVsop(8.9E-10, 3.88606108572, 12199.9750023914), new Vsop87.LnVsop(1.05E-9, 6.11980600515, 4819.4790007642), new Vsop87.LnVsop(9.7E-10, 2.70091698598, 3339.4317840477), new Vsop87.LnVsop(1.13E-9, 2.87005870648, 394.6258850592), new Vsop87.LnVsop(9.1E-10, 3.46457148291, 4694.0029547076), new Vsop87.LnVsop(8.6E-10, 1.91214909013, 55516.4187098482), new Vsop87.LnVsop(8.4E-10, 4.30909434949, 4150.0898961468), new Vsop87.LnVsop(8.4E-10, 3.05613772819, 9993.3880926316), new Vsop87.LnVsop(8.5E-10, 4.49096869215, 6453.7487206106), new Vsop87.LnVsop(8.3E-10, 5.66199608314, 1169.5882514086), new Vsop87.LnVsop(9.4E-10, 0.76661204154, 4845.9002357928), new Vsop87.LnVsop(8.3E-10, 2.57570774331, 4466.4817658034), new Vsop87.LnVsop(8.3E-10, 5.8257049621, 6682.7093261079), new Vsop87.LnVsop(8.9E-10, 4.76553691828, 35707.7100829074), new Vsop87.LnVsop(1.01E-9, 1.5157029904, 7807.0941925032), new Vsop87.LnVsop(8.6E-10, 0.6674384679, 2957.7331481288), new Vsop87.LnVsop(8.6E-10, 3.60273523563, 13363.4300278674), new Vsop87.LnVsop(9.4E-10, 0.5797580838, 3090.7079659576), new Vsop87.LnVsop(9.5E-10, 3.35380642653, 661.232926781), new Vsop87.LnVsop(9.2E-10, 2.66589901893, 24341.5283174566), new Vsop87.LnVsop(8.8E-10, 1.00573166083, 1059.3991838414), new Vsop87.LnVsop(8.3E-10, 1.46681225258, 11527.1250891924), new Vsop87.LnVsop(8.1E-10, 1.27062968985, 4893.0799566794), new Vsop87.LnVsop(8.0E-10, 3.44636389322, 148.0787244263), new Vsop87.LnVsop(1.05E-9, 3.4784203613, 3413.9095525588), new Vsop87.LnVsop(8.4E-10, 4.33209852801, 51449.3242632782), new Vsop87.LnVsop(7.9E-10, 4.42171441227, 151.0476698429), new Vsop87.LnVsop(8.2E-10, 2.85230384631, 14164.8136292454), new Vsop87.LnVsop(1.06E-9, 4.19479352477, 9090.4741932476), new Vsop87.LnVsop(7.8E-10, 4.29426802519, 187.9251477626), new Vsop87.LnVsop(7.8E-10, 5.38566529072, 2655.5683724738), new Vsop87.LnVsop(8.4E-10, 2.15121245434, 3311.1206083964), new Vsop87.LnVsop(8.3E-10, 4.28280129037, 74923.09699802278), new Vsop87.LnVsop(7.7E-10, 1.45903147715, 2544.3817301862), new Vsop87.LnVsop(7.8E-10, 3.92028514294, 16762.4359954126), new Vsop87.LnVsop(9.8E-10, 3.78877505378, 3198.4337996636), new Vsop87.LnVsop(9.2E-10, 2.80228448795, 3707.8367556622), new Vsop87.LnVsop(8.2E-10, 2.45812896343, 9815.6517316622), new Vsop87.LnVsop(7.6E-10, 3.92674885488, 2910.0820825607), new Vsop87.LnVsop(1.03E-9, 2.90157610001, 12032.9376165392), new Vsop87.LnVsop(7.6E-10, 3.20012751409, 7733.493236588), new Vsop87.LnVsop(9.8E-10, 3.28574616663, 3289.33208883739), new Vsop87.LnVsop(8.6E-10, 0.4495458967, 2942.3961129888), new Vsop87.LnVsop(7.7E-10, 2.05948930109, 12928.7379689224), new Vsop87.LnVsop(7.5E-10, 0.85784191736, 28638.9055811466), new Vsop87.LnVsop(1.01E-9, 0.72388999452, 48827.4311857326), new Vsop87.LnVsop(9.3E-10, 0.96205455167, 151.8972810852), new Vsop87.LnVsop(8.3E-10, 4.42677043697, 2060.8178540718), new Vsop87.LnVsop(8.5E-10, 5.1943801013, 2146.148162823), new Vsop87.LnVsop(7.8E-10, 0.05738144523, 10507.809332889), new Vsop87.LnVsop(9.6E-10, 6.24132708355, 11.0457002639), new Vsop87.LnVsop(8.8E-10, 2.2751469485, 13361.469385731), new Vsop87.LnVsop(7.4E-10, 5.19118661748, 1055.4497769261), new Vsop87.LnVsop(9.5E-10, 1.32630130009, 9278.8472195668), new Vsop87.LnVsop(9.1E-10, 5.56686260659, 27873.589010268), new Vsop87.LnVsop(8.4E-10, 0.41519041956, 4296.9015826704), new Vsop87.LnVsop(7.4E-10, 5.0977361057, 9755.2302383776), new Vsop87.LnVsop(1.02E-9, 0.99471814765, 8186.5126624926), new Vsop87.LnVsop(7.3E-10, 4.78565969143, 10787.6303445458), new Vsop87.LnVsop(9.0E-10, 1.23322132624, 9093.9973115966), new Vsop87.LnVsop(8.9E-10, 1.52171318808, 5088.2198048527), new Vsop87.LnVsop(7.5E-10, 3.17716258197, 4403.517475238), new Vsop87.LnVsop(7.6E-10, 2.66623960187, 12725.453434775), new Vsop87.LnVsop(7.2E-10, 2.57646391241, 10817.0876555448), new Vsop87.LnVsop(7.8E-10, 0.17721609024, 3391.89276456221), new Vsop87.LnVsop(7.3E-10, 1.65072523242, 5452.2627400774), new Vsop87.LnVsop(7.2E-10, 2.24247662338, 272.6729573516), new Vsop87.LnVsop(8.4E-10, 5.31880055844, 4716.3862265456), new Vsop87.LnVsop(8.1E-10, 5.4634074205, 3856.0762977928), new Vsop87.LnVsop(9.1E-10, 2.82213463878, 367.2243289624), new Vsop87.LnVsop(7.6E-10, 5.54629636453, 4349.1618975832), new Vsop87.LnVsop(7.3E-10, 4.61913155968, 3288.352111787), new Vsop87.LnVsop(9.7E-10, 0.68615321372, 10006.5848089144), new Vsop87.LnVsop(7.1E-10, 0.29424294238, 1324.94134054), new Vsop87.LnVsop(7.4E-10, 1.74142938655, 78263.70942472259), new Vsop87.LnVsop(7.6E-10, 0.00928867044, 6534.413166876), new Vsop87.LnVsop(8.4E-10, 2.33518173212, 3738.7441764558), new Vsop87.LnVsop(7.5E-10, 3.61437779765, 12306.590894959), new Vsop87.LnVsop(8.5E-10, 0.94196641948, 2146.1826701274), new Vsop87.LnVsop(7.1E-10, 2.07200856102, 9124.9219860424), new Vsop87.LnVsop(7.1E-10, 4.48060598672, 9153.9036160218), new Vsop87.LnVsop(7.3E-10, 0.28701671181, 10654.6210194126), new Vsop87.LnVsop(7.2E-10, 0.84342376295, 3334.54651107), new Vsop87.LnVsop(9.4E-10, 5.72469267962, 206.7007372966), new Vsop87.LnVsop(9.1E-10, 5.12701600437, 3392.8727416126), new Vsop87.LnVsop(7.6E-10, 5.96038992872, 3482.791053736), new Vsop87.LnVsop(7.1E-10, 1.16745785331, 1574.8458012822), new Vsop87.LnVsop(7.1E-10, 1.08624489534, 3866.7802734454), new Vsop87.LnVsop(7.1E-10, 3.83802267632, 25298.2931544468), new Vsop87.LnVsop(7.5E-10, 4.30016984862, 10177.1903692308), new Vsop87.LnVsop(8.1E-10, 5.71063897801, 14687.3910473392), new Vsop87.LnVsop(7.0E-10, 0.07475004834, 12839.8722887054), new Vsop87.LnVsop(8.0E-10, 5.87829926376, 3495.9655158312), new Vsop87.LnVsop(6.9E-10, 0.30282686836, 12012.5822971404), new Vsop87.LnVsop(7.1E-10, 2.07966257785, 1063.3140834523), new Vsop87.LnVsop(7.1E-10, 0.1208095231, 27433.88921587499), new Vsop87.LnVsop(7.2E-10, 1.77506111582, 3564.9572224017), new Vsop87.LnVsop(6.9E-10, 0.33478558217, 5.5229243074), new Vsop87.LnVsop(6.8E-10, 1.56404561711, 2398.5503647308), new Vsop87.LnVsop(9.0E-10, 2.61953849393, 3346.6783423296), new Vsop87.LnVsop(6.8E-10, 1.06108185791, 191.3809558088), new Vsop87.LnVsop(9.3E-10, 3.72700623766, 2472.6787626222), new Vsop87.LnVsop(7.7E-10, 0.87794040199, 2917.9463890869), new Vsop87.LnVsop(6.7E-10, 3.29797798194, 8006.1661939396), new Vsop87.LnVsop(8.2E-10, 4.33799969295, 9360.6043533184), new Vsop87.LnVsop(6.8E-10, 4.84097033274, 12942.965062924), new Vsop87.LnVsop(8.3E-10, 5.35554906977, 2125.8100970764), new Vsop87.LnVsop(8.3E-10, 1.82578570378, 3511.285297319), new Vsop87.LnVsop(6.8E-10, 2.68247854175, 20213.25474333179), new Vsop87.LnVsop(8.6E-10, 0.81171860574, 209.775977089), new Vsop87.LnVsop(8.4E-10, 4.36595418339, 3738.7786837602), new Vsop87.LnVsop(7.1E-10, 2.76447756531, 15650.7937503106), new Vsop87.LnVsop(6.6E-10, 3.31414998734, 8830.9133882238), new Vsop87.LnVsop(9.0E-10, 0.71593793107, 3451.7990689874), new Vsop87.LnVsop(6.7E-10, 4.04202356962, 3930.2096962196), new Vsop87.LnVsop(6.8E-10, 4.35822797929, 12299.544658261), new Vsop87.LnVsop(7.3E-10, 3.66802441649, 194.9713844606), new Vsop87.LnVsop(7.7E-10, 5.89874180574, 4307.5833041354), new Vsop87.LnVsop(8.9E-10, 2.09613892664, 5312.5646005546), new Vsop87.LnVsop(6.8E-10, 1.05513114246, 1987.221898692), new Vsop87.LnVsop(8.2E-10, 5.86597589657, 7747.7203305896), new Vsop87.LnVsop(7.1E-10, 0.65820952553, 860.3099287528), new Vsop87.LnVsop(6.4E-10, 0.98960038205, 3376.1751611684), new Vsop87.LnVsop(6.7E-10, 5.22683619088, 24606.13555322), new Vsop87.LnVsop(7.0E-10, 0.96227192685, 8428.8322315525), new Vsop87.LnVsop(6.4E-10, 5.15148312244, 8966.3875031733), new Vsop87.LnVsop(6.2E-10, 6.1827616636, 3966.2826190122), new Vsop87.LnVsop(6.1E-10, 1.47350010728, 1685.0521225016), new Vsop87.LnVsop(6.9E-10, 4.32901678608, 8436.6965380787), new Vsop87.LnVsop(6.4E-10, 2.11869877898, 3305.0496922312), new Vsop87.LnVsop(7.9E-10, 5.29501968122, 8322.5580635962), new Vsop87.LnVsop(6.0E-10, 1.17940250396, 97670.38771289718), new Vsop87.LnVsop(6.0E-10, 5.15547946009, 4665.5537672398), new Vsop87.LnVsop(6.1E-10, 4.0400802103, 2942.4806769438), new Vsop87.LnVsop(6.1E-10, 0.44282820959, 4686.95671800959), new Vsop87.LnVsop(7.9E-10, 2.10625649179, 7917.3005137226), new Vsop87.LnVsop(7.5E-10, 4.81216780547, 27299.2442119332), new Vsop87.LnVsop(5.8E-10, 1.6974716894, 12082.6551341712), new Vsop87.LnVsop(7.5E-10, 1.8561801142, 52566.19261584059), new Vsop87.LnVsop(5.7E-10, 5.11652903646, 1898.3339642874), new Vsop87.LnVsop(7.5E-10, 5.1583065968, 45884.967762441), new Vsop87.LnVsop(6.0E-10, 2.68566185208, 6283.0585963392), new Vsop87.LnVsop(5.6E-10, 3.77198339507, 299.1263942692), new Vsop87.LnVsop(7.2E-10, 0.0552515851, 6286.5989683404), new Vsop87.LnVsop(7.5E-10, 5.79419108898, 1059.364676537), new Vsop87.LnVsop(5.6E-10, 0.47178586543, 1727.6610936682), new Vsop87.LnVsop(6.1E-10, 2.00931045169, 2942.4461696394), new Vsop87.LnVsop(6.0E-10, 2.60462801513, 30376.3526391666), new Vsop87.LnVsop(5.7E-10, 4.18603648623, 4531.5363185754), new Vsop87.LnVsop(5.9E-10, 1.95998946118, 7593.7950970652), new Vsop87.LnVsop(5.9E-10, 0.11151543852, 5960.0856221934), new Vsop87.LnVsop(6.8E-10, 3.50707258885, 7064.1041319706), new Vsop87.LnVsop(5.6E-10, 2.43554289279, 11567.1912630782), new Vsop87.LnVsop(6.0E-10, 0.23404709116, 2619.4731954936), new Vsop87.LnVsop(6.6E-10, 2.94716590333, 8446.9914788172), new Vsop87.LnVsop(5.9E-10, 5.49704665474, 7322.1024607818), new Vsop87.LnVsop(6.4E-10, 3.9599211222, 3050.1269472302), new Vsop87.LnVsop(5.5E-10, 2.19506741266, 7.046236698), new Vsop87.LnVsop(5.8E-10, 0.32431074295, 19645.5255567906), new Vsop87.LnVsop(7.5E-10, 4.12415692769, 21150.8133658836), new Vsop87.LnVsop(7.5E-10, 3.99896297048, 5483.254724826), new Vsop87.LnVsop(5.7E-10, 0.21772333641, 17402.3332817266), new Vsop87.LnVsop(6.9E-10, 3.2020955552, 16066.0658614748), new Vsop87.LnVsop(5.6E-10, 2.00267092675, 17660.303464057), new Vsop87.LnVsop(6.0E-10, 4.71643347424, 6283.0931036436), new Vsop87.LnVsop(5.4E-10, 0.38782719267, 360.1107819616), new Vsop87.LnVsop(7.3E-10, 3.41087754271, 14556.8967170238), new Vsop87.LnVsop(6.8E-10, 5.74655335863, 987.746272928)};
        static Vsop87.LnVsop[] mars_radius_r1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.01107433345, 2.03250524857, 3340.6124266998), new Vsop87.LnVsop(0.00103175887, 2.37071847807, 6681.2248533996), new Vsop87.LnVsop(1.28772E-4, 0.0, 0.0), new Vsop87.LnVsop(1.081588E-4, 2.70888095665, 10021.8372800994), new Vsop87.LnVsop(1.19455E-5, 3.04702256206, 13362.4497067992), new Vsop87.LnVsop(4.38582E-6, 2.88835054603, 2281.2304965106), new Vsop87.LnVsop(3.957E-6, 3.42323670971, 3344.1355450488), new Vsop87.LnVsop(1.82576E-6, 1.58427562964, 2544.3144198834), new Vsop87.LnVsop(1.35851E-6, 3.38507063082, 16703.062133499), new Vsop87.LnVsop(1.28199E-6, 0.62991771813, 1059.3819301892), new Vsop87.LnVsop(1.27059E-6, 1.95391155885, 796.2980068164), new Vsop87.LnVsop(1.18443E-6, 2.99762091382, 2146.1654164752), new Vsop87.LnVsop(1.28362E-6, 6.04343227063, 3337.0893083508), new Vsop87.LnVsop(8.7534E-7, 3.42053385867, 398.1490034082), new Vsop87.LnVsop(8.3021E-7, 3.85575072018, 3738.761430108), new Vsop87.LnVsop(7.5604E-7, 4.45097659377, 6151.533888305), new Vsop87.LnVsop(7.2002E-7, 2.76443992447, 529.6909650946), new Vsop87.LnVsop(6.6545E-7, 2.5487838147, 1751.539531416), new Vsop87.LnVsop(5.4305E-7, 0.67754203387, 8962.4553499102), new Vsop87.LnVsop(5.1043E-7, 3.72584855417, 6684.7479717486), new Vsop87.LnVsop(6.6413E-7, 4.40596377334, 1748.016413067), new Vsop87.LnVsop(4.786E-7, 2.28524521788, 2914.0142358238), new Vsop87.LnVsop(4.942E-7, 5.72961379219, 3340.5951730476), new Vsop87.LnVsop(4.942E-7, 1.47720011103, 3340.629680352), new Vsop87.LnVsop(5.7519E-7, 0.5435613312, 1194.4470102246), new Vsop87.LnVsop(4.832E-7, 2.58061402348, 3149.1641605882), new Vsop87.LnVsop(3.6383E-7, 6.02729341698, 3185.1920272656), new Vsop87.LnVsop(3.7161E-7, 5.81436290851, 1349.8674096588), new Vsop87.LnVsop(3.6035E-7, 5.89515829011, 3333.498879699), new Vsop87.LnVsop(3.1111E-7, 0.97820401887, 191.4482661116), new Vsop87.LnVsop(3.8957E-7, 2.31902442004, 4136.9104335162), new Vsop87.LnVsop(2.7256E-7, 5.41369838171, 1592.5960136328), new Vsop87.LnVsop(2.4302E-7, 3.75838444077, 155.4203994342), new Vsop87.LnVsop(2.2808E-7, 1.74818178182, 5088.6288397668), new Vsop87.LnVsop(2.2322E-7, 0.93941901193, 951.7184062506), new Vsop87.LnVsop(2.1712E-7, 3.83569490817, 6283.0758499914), new Vsop87.LnVsop(2.1302E-7, 0.78030571909, 1589.0728952838), new Vsop87.LnVsop(2.1631E-7, 4.56903942095, 3532.0606928114), new Vsop87.LnVsop(1.7957E-7, 4.21923537063, 3870.3033917944), new Vsop87.LnVsop(1.8241E-7, 0.41334220202, 5486.777843175), new Vsop87.LnVsop(1.625E-7, 3.80772429678, 3340.545116397), new Vsop87.LnVsop(1.6803E-7, 5.54855432911, 3097.88382272579), new Vsop87.LnVsop(1.6852E-7, 4.53696884484, 4292.3308329504), new Vsop87.LnVsop(1.5749E-7, 4.75766175289, 9492.1463150048), new Vsop87.LnVsop(1.5747E-7, 3.72356261757, 20043.6745601988), new Vsop87.LnVsop(2.0429E-7, 3.13541604634, 4690.4798363586), new Vsop87.LnVsop(1.4699E-7, 5.95340513928, 3894.1818295422), new Vsop87.LnVsop(1.6251E-7, 3.39910570757, 3340.6797370026), new Vsop87.LnVsop(1.4256E-7, 3.99914527335, 1990.745017041), new Vsop87.LnVsop(1.6529E-7, 0.96740368703, 4399.994356889), new Vsop87.LnVsop(1.3011E-7, 5.14215010082, 6677.7017350506), new Vsop87.LnVsop(1.2482E-7, 1.03238555854, 3341.592747768), new Vsop87.LnVsop(1.6454E-7, 3.53827765951, 2700.7151403858), new Vsop87.LnVsop(1.6167E-7, 2.3489111087, 553.5694028424), new Vsop87.LnVsop(1.3169E-7, 0.41462220221, 5614.7293762096), new Vsop87.LnVsop(1.127E-7, 1.02387117266, 12303.06777661), new Vsop87.LnVsop(1.241E-7, 6.23139144626, 5628.9564702112), new Vsop87.LnVsop(1.2747E-7, 0.69046237163, 3723.508958923), new Vsop87.LnVsop(1.1828E-7, 6.25270937134, 2274.1169495098), new Vsop87.LnVsop(1.0382E-7, 1.23229650709, 426.598190876), new Vsop87.LnVsop(1.1207E-7, 1.31732435116, 3496.032826134), new Vsop87.LnVsop(1.0345E-7, 0.90062869301, 4535.0594369244), new Vsop87.LnVsop(1.2214E-7, 4.22347837212, 7079.3738568078), new Vsop87.LnVsop(9.764E-8, 3.45310129694, 382.8965322232), new Vsop87.LnVsop(8.583E-8, 1.1647889051, 2787.0430238574), new Vsop87.LnVsop(7.879E-8, 5.73808303461, 2288.3440435114), new Vsop87.LnVsop(9.192E-8, 1.81719352796, 6681.2421070518), new Vsop87.LnVsop(7.752E-8, 4.15038634174, 6041.3275670856), new Vsop87.LnVsop(9.192E-8, 6.06960723129, 6681.2075997474), new Vsop87.LnVsop(9.008E-8, 2.58179552398, 2388.8940204492), new Vsop87.LnVsop(6.77E-8, 0.240118807, 11773.3768115154), new Vsop87.LnVsop(7.088E-8, 3.51428380287, 8031.0922630584), new Vsop87.LnVsop(9.159E-8, 3.90203365989, 3553.9115221378), new Vsop87.LnVsop(7.233E-8, 3.70260535699, 2818.035008606), new Vsop87.LnVsop(6.701E-8, 4.25537421062, 242.728603974), new Vsop87.LnVsop(6.534E-8, 0.04317593308, 2957.7158944766), new Vsop87.LnVsop(8.783E-8, 2.19764346848, 1221.8485663214), new Vsop87.LnVsop(6.54E-8, 2.11811131682, 8429.2412664666), new Vsop87.LnVsop(6.835E-8, 4.04527289029, 10025.3603984484), new Vsop87.LnVsop(7.279E-8, 4.26969778292, 2803.8079146044), new Vsop87.LnVsop(7.679E-8, 1.00816125095, 8432.7643848156), new Vsop87.LnVsop(5.736E-8, 3.13988802339, 213.299095438), new Vsop87.LnVsop(5.343E-8, 3.7818416468, 5092.1519581158), new Vsop87.LnVsop(5.985E-8, 2.96429619989, 6489.776587288), new Vsop87.LnVsop(5.132E-8, 3.98288020531, 7.1135470008), new Vsop87.LnVsop(6.264E-8, 1.90345600186, 5621.8429232104), new Vsop87.LnVsop(5.238E-8, 2.67050910776, 7477.522860216), new Vsop87.LnVsop(6.264E-8, 1.60046198142, 3347.7259737006), new Vsop87.LnVsop(6.527E-8, 2.76220386403, 3339.6321056316), new Vsop87.LnVsop(4.594E-8, 1.82031785094, 2810.9214616052), new Vsop87.LnVsop(5.46E-8, 4.60869963415, 3583.3410306738), new Vsop87.LnVsop(4.73E-8, 0.90611934427, 5099.2655051166), new Vsop87.LnVsop(5.484E-8, 4.91405753832, 7632.9432596502), new Vsop87.LnVsop(4.002E-8, 4.1410000521, 9623.6882766912), new Vsop87.LnVsop(3.836E-8, 0.03411499404, 7234.794256242), new Vsop87.LnVsop(3.618E-8, 5.76553319747, 4933.2084403326), new Vsop87.LnVsop(3.747E-8, 0.08776717073, 6525.8044539654), new Vsop87.LnVsop(3.016E-8, 3.73804058695, 6681.2921637024), new Vsop87.LnVsop(3.975E-8, 4.91286826343, 2942.4634232916), new Vsop87.LnVsop(3.911E-8, 0.67457174687, 3127.3133312618), new Vsop87.LnVsop(3.923E-8, 3.07698893109, 3.523118349), new Vsop87.LnVsop(3.943E-8, 0.53936955267, 5884.9268465832), new Vsop87.LnVsop(2.902E-8, 4.66228680082, 7210.9158184942), new Vsop87.LnVsop(2.803E-8, 1.00505054832, 7064.1213856228), new Vsop87.LnVsop(3.152E-8, 4.54611126545, 2487.4160449478), new Vsop87.LnVsop(2.797E-8, 0.05226680768, 639.897286314), new Vsop87.LnVsop(2.758E-8, 5.17057629399, 5828.0284716476), new Vsop87.LnVsop(3.02E-8, 4.14658810846, 6681.1575430968), new Vsop87.LnVsop(3.0E-8, 0.82762095066, 5085.038411115), new Vsop87.LnVsop(3.022E-8, 2.59437829291, 2906.900688823), new Vsop87.LnVsop(2.673E-8, 0.69433657973, 2699.7348193176), new Vsop87.LnVsop(2.593E-8, 1.08691889359, 4929.6853219836), new Vsop87.LnVsop(3.127E-8, 0.99947199034, 2118.7638603784), new Vsop87.LnVsop(2.597E-8, 5.01157388627, 10018.3141617504), new Vsop87.LnVsop(2.606E-8, 5.34395258978, 10973.55568635), new Vsop87.LnVsop(2.779E-8, 3.98360727591, 6467.9257579616), new Vsop87.LnVsop(2.457E-8, 1.52659064342, 6836.6452528338), new Vsop87.LnVsop(2.381E-8, 3.93615187831, 11371.7046897582), new Vsop87.LnVsop(2.584E-8, 5.08907827632, 12832.7587417046), new Vsop87.LnVsop(2.204E-8, 0.18721790349, 9595.2390892234), new Vsop87.LnVsop(2.127E-8, 5.69525267283, 3191.0492295652), new Vsop87.LnVsop(2.065E-8, 3.54230184958, 1066.49547719), new Vsop87.LnVsop(1.862E-8, 5.01664572032, 3475.6775067352), new Vsop87.LnVsop(2.077E-8, 1.30210079493, 7740.6067835888), new Vsop87.LnVsop(1.834E-8, 5.68364410455, 3319.8370312074), new Vsop87.LnVsop(2.026E-8, 6.16037765302, 1744.4259844152), new Vsop87.LnVsop(1.705E-8, 2.21753874961, 2921.1277828246), new Vsop87.LnVsop(1.836E-8, 6.16475140098, 8425.6508378148), new Vsop87.LnVsop(2.06E-8, 6.24256627641, 6674.1113063988), new Vsop87.LnVsop(1.735E-8, 4.5825241318, 10419.9862835076), new Vsop87.LnVsop(1.853E-8, 1.36791191191, 15643.6802033098), new Vsop87.LnVsop(1.683E-8, 1.92963115929, 3767.2106175758), new Vsop87.LnVsop(1.955E-8, 0.46151752408, 10575.4066829418), new Vsop87.LnVsop(1.8E-8, 2.30912443204, 3355.8648978848), new Vsop87.LnVsop(1.761E-8, 5.87259776407, 3320.257107301), new Vsop87.LnVsop(1.44E-8, 2.15100457092, 10021.8545337516), new Vsop87.LnVsop(1.845E-8, 4.06143234617, 23384.2869868986), new Vsop87.LnVsop(1.419E-8, 4.64964683208, 4562.4609930212), new Vsop87.LnVsop(1.41E-8, 1.50439659549, 3325.3599555148), new Vsop87.LnVsop(1.435E-8, 0.12022404881, 10021.8200264472), new Vsop87.LnVsop(1.446E-8, 0.55888114207, 15113.9892382152), new Vsop87.LnVsop(1.334E-8, 1.25480751834, 7875.6718636242), new Vsop87.LnVsop(1.442E-8, 1.38958372017, 6682.2051744678), new Vsop87.LnVsop(1.601E-8, 4.34240972038, 5331.3574437408), new Vsop87.LnVsop(1.377E-8, 0.14567625356, 1758.6530784168), new Vsop87.LnVsop(1.283E-8, 5.7838849892, 14584.2982731206), new Vsop87.LnVsop(1.281E-8, 1.3515871533, 10404.7338123226), new Vsop87.LnVsop(1.255E-8, 6.02547192213, 3264.3463554242), new Vsop87.LnVsop(1.471E-8, 0.34647878204, 8969.568896911), new Vsop87.LnVsop(1.237E-8, 1.88316546445, 10177.2576795336), new Vsop87.LnVsop(1.554E-8, 5.93165013851, 8439.8779318164), new Vsop87.LnVsop(1.185E-8, 4.18096920842, 3360.96774609859), new Vsop87.LnVsop(1.192E-8, 0.89923984424, 13916.0191096416), new Vsop87.LnVsop(1.331E-8, 1.86674667785, 692.1576012268), new Vsop87.LnVsop(1.19E-8, 4.29364281529, 6894.5239488376), new Vsop87.LnVsop(1.303E-8, 1.4466627109, 6254.6266625236), new Vsop87.LnVsop(1.141E-8, 0.15138021311, 3134.4268782626), new Vsop87.LnVsop(1.498E-8, 1.54298726882, 3361.3878221922), new Vsop87.LnVsop(1.061E-8, 0.67393132017, 3344.2028553516), new Vsop87.LnVsop(1.21E-8, 0.85308958022, 3120.199784261), new Vsop87.LnVsop(1.003E-8, 1.28017736997, 4569.574540022), new Vsop87.LnVsop(1.056E-8, 0.13188094879, 522.5774180938), new Vsop87.LnVsop(1.011E-8, 5.77318421567, 14314.1681130498), new Vsop87.LnVsop(1.172E-8, 2.99768268266, 6247.5131155228), new Vsop87.LnVsop(1.071E-8, 0.24747292047, 3337.021998048), new Vsop87.LnVsop(1.088E-8, 2.57510503125, 6261.7402095244), new Vsop87.LnVsop(1.033E-8, 5.698390168, 536.8045120954), new Vsop87.LnVsop(8.7E-9, 1.50282095865, 6127.6554505572), new Vsop87.LnVsop(9.52E-9, 2.92551885687, 5729.506447149), new Vsop87.LnVsop(1.113E-8, 2.84407720846, 640.8776073822), new Vsop87.LnVsop(8.61E-9, 3.21490378166, 3914.9572250346), new Vsop87.LnVsop(8.73E-9, 5.26929669197, 10213.285546211), new Vsop87.LnVsop(1.068E-8, 0.49291392496, 11243.6858464208), new Vsop87.LnVsop(8.02E-9, 3.33123564567, 9830.3890139878), new Vsop87.LnVsop(8.0E-9, 4.6416368116, 6144.4203413042), new Vsop87.LnVsop(1.047E-8, 4.05904372261, 6158.6474353058), new Vsop87.LnVsop(7.39E-9, 4.9337401431, 3230.4061054804), new Vsop87.LnVsop(7.36E-9, 3.01566811571, 10818.1352869158), new Vsop87.LnVsop(7.16E-9, 2.52258068421, 5202.3582793352), new Vsop87.LnVsop(7.08E-9, 4.39529316737, 9808.5381846614), new Vsop87.LnVsop(7.89E-9, 1.72502040817, 3178.1457905676), new Vsop87.LnVsop(7.21E-9, 6.2393728211, 3369.0616141676), new Vsop87.LnVsop(7.11E-9, 1.96395412586, 6688.3384004004), new Vsop87.LnVsop(7.2E-9, 0.38908319399, 6298.3283211764), new Vsop87.LnVsop(8.79E-9, 2.11099461733, 2301.58581590939), new Vsop87.LnVsop(9.11E-9, 2.30898309496, 13517.8701062334), new Vsop87.LnVsop(9.2E-9, 4.36440466625, 13365.9728251482), new Vsop87.LnVsop(6.6E-9, 3.41324530637, 1648.4467571974), new Vsop87.LnVsop(8.22E-9, 2.14217300701, 7903.073419721), new Vsop87.LnVsop(6.55E-9, 5.97028443361, 574.3447983348), new Vsop87.LnVsop(7.09E-9, 2.24666710788, 9225.539273283), new Vsop87.LnVsop(6.84E-9, 4.02188175404, 1052.2683831884), new Vsop87.LnVsop(7.89E-9, 3.58669777772, 2693.601593385), new Vsop87.LnVsop(5.9E-9, 0.67864102888, 8955.3418029094), new Vsop87.LnVsop(6.04E-9, 2.73534347693, 16858.4825329332), new Vsop87.LnVsop(5.74E-9, 4.1112919353, 6034.2140200848), new Vsop87.LnVsop(6.26E-9, 4.45275856522, 12964.300703391), new Vsop87.LnVsop(5.63E-9, 3.72669761947, 13119.72110282519), new Vsop87.LnVsop(5.47E-9, 3.035597949, 2707.8286873866), new Vsop87.LnVsop(6.82E-9, 3.625366383, 6048.4411140864), new Vsop87.LnVsop(5.34E-9, 4.65553794211, 135.0650800354), new Vsop87.LnVsop(5.37E-9, 3.32526208431, 9779.1086761254), new Vsop87.LnVsop(6.21E-9, 0.31692147043, 7910.1869667218), new Vsop87.LnVsop(5.08E-9, 1.2378289696, 4555.3474460204), new Vsop87.LnVsop(6.36E-9, 1.31861189187, 2648.454825473), new Vsop87.LnVsop(6.74E-9, 2.88169508451, 3316.733988952), new Vsop87.LnVsop(5.66E-9, 4.94059125257, 6923.9534573736), new Vsop87.LnVsop(4.92E-9, 0.48544563054, 12935.8515159232), new Vsop87.LnVsop(4.94E-9, 1.58242260326, 162.4666361322), new Vsop87.LnVsop(4.94E-9, 4.0590821271, 10021.9045904022), new Vsop87.LnVsop(4.76E-9, 4.50803141082, 2384.3232707292), new Vsop87.LnVsop(4.63E-9, 1.30989375876, 17256.6315363414), new Vsop87.LnVsop(4.36E-9, 5.18941467679, 13358.9265884502), new Vsop87.LnVsop(5.1E-9, 5.29711079669, 853.196381752), new Vsop87.LnVsop(4.57E-9, 5.52250921497, 6438.4962494256), new Vsop87.LnVsop(4.44E-9, 4.37462471228, 12168.0026965746), new Vsop87.LnVsop(4.26E-9, 4.06251388975, 149.5631971346), new Vsop87.LnVsop(5.01E-9, 6.12177016731, 8273.8208670324), new Vsop87.LnVsop(4.19E-9, 3.51950671003, 9168.6408983474), new Vsop87.LnVsop(4.49E-9, 0.15703403836, 7895.9598727202), new Vsop87.LnVsop(4.0E-9, 0.93203728344, 433.7117378768), new Vsop87.LnVsop(3.9E-9, 1.26783113077, 5459.3762870782), new Vsop87.LnVsop(4.58E-9, 3.57016754913, 1596.1864422846), new Vsop87.LnVsop(4.94E-9, 4.46695057001, 10021.7699697966), new Vsop87.LnVsop(5.14E-9, 4.14599732838, 16460.33352952499), new Vsop87.LnVsop(5.12E-9, 2.12376964366, 3335.0895023924), new Vsop87.LnVsop(3.69E-9, 0.85046311178, 3364.4908644476), new Vsop87.LnVsop(4.47E-9, 0.42171107066, 9866.4168806652), new Vsop87.LnVsop(3.83E-9, 2.74377480867, 3344.4937620578), new Vsop87.LnVsop(3.59E-9, 2.19508793723, 5518.7501489918), new Vsop87.LnVsop(3.88E-9, 0.58874025278, 3980.5097130138), new Vsop87.LnVsop(3.74E-9, 0.93936421015, 3863.1898447936), new Vsop87.LnVsop(4.63E-9, 4.99368680534, 10551.528245194), new Vsop87.LnVsop(3.63E-9, 5.57806007125, 16062.1845261168), new Vsop87.LnVsop(3.67E-9, 1.45560460881, 1039.0266107904), new Vsop87.LnVsop(3.66E-9, 5.42971242456, 11236.57229942), new Vsop87.LnVsop(3.23E-9, 3.25474887566, 3116.2676309979), new Vsop87.LnVsop(3.95E-9, 5.43639546793, 16173.3711684044), new Vsop87.LnVsop(3.16E-9, 5.10881664095, 17395.2197347258), new Vsop87.LnVsop(3.15E-9, 1.63649866499, 11081.2192102886), new Vsop87.LnVsop(3.28E-9, 4.5781317545, 19800.9459562248), new Vsop87.LnVsop(3.13E-9, 4.76509182263, 3304.5845600224), new Vsop87.LnVsop(3.18E-9, 0.10125354955, 1692.1656695024), new Vsop87.LnVsop(3.8E-9, 1.11418824718, 3503.079062832), new Vsop87.LnVsop(3.59E-9, 1.40924904562, 8270.2977486834), new Vsop87.LnVsop(3.25E-9, 3.5215979874, 1903.4368125012), new Vsop87.LnVsop(3.04E-9, 6.27804875103, 2391.43681773), new Vsop87.LnVsop(3.03E-9, 4.26667073131, 13936.794505134), new Vsop87.LnVsop(3.14E-9, 5.05418964097, 12721.572099417), new Vsop87.LnVsop(3.13E-9, 6.10446893161, 17924.9106998204), new Vsop87.LnVsop(2.99E-9, 0.48751113813, 3347.6586633978), new Vsop87.LnVsop(3.27E-9, 3.19964410433, 3981.490034082), new Vsop87.LnVsop(3.33E-9, 2.95583825569, 6680.2445323314), new Vsop87.LnVsop(2.9E-9, 4.52908707678, 5724.935697429), new Vsop87.LnVsop(2.78E-9, 4.30130850558, 3607.2194684216), new Vsop87.LnVsop(3.75E-9, 5.37102625037, 3376.6402933772), new Vsop87.LnVsop(2.7E-9, 5.61134597717, 4032.7700279266), new Vsop87.LnVsop(2.68E-9, 4.93749874461, 13760.5987102074), new Vsop87.LnVsop(2.88E-9, 1.85605347821, 6702.000248892), new Vsop87.LnVsop(2.85E-9, 4.36928341258, 6040.3472460174), new Vsop87.LnVsop(3.61E-9, 4.69076903889, 9380.9596727172), new Vsop87.LnVsop(2.66E-9, 5.81522234941, 1214.7350193206), new Vsop87.LnVsop(3.02E-9, 3.60805252615, 7255.5696517344), new Vsop87.LnVsop(2.49E-9, 3.48983298099, 3237.5196524812), new Vsop87.LnVsop(3.29E-9, 5.11789854678, 11250.7993934216), new Vsop87.LnVsop(3.35E-9, 6.05389905145, 6660.4494579072), new Vsop87.LnVsop(2.43E-9, 0.48285973973, 13362.432453147), new Vsop87.LnVsop(2.46E-9, 4.41923388458, 3546.797975137), new Vsop87.LnVsop(2.39E-9, 3.73063112648, 76.2660712756), new Vsop87.LnVsop(2.39E-9, 6.27698012526, 1964.838626854), new Vsop87.LnVsop(2.43E-9, 2.51395431898, 13362.4669604514), new Vsop87.LnVsop(2.38E-9, 4.61731653137, 17277.4069318338), new Vsop87.LnVsop(2.32E-9, 3.12136758982, 20199.094959633), new Vsop87.LnVsop(2.78E-9, 3.88609085933, 10596.1820784342), new Vsop87.LnVsop(2.81E-9, 6.14213490828, 19402.7969528166), new Vsop87.LnVsop(2.4E-9, 3.88518850785, 4407.1079038898), new Vsop87.LnVsop(2.37E-9, 3.07960027546, 12566.1516999828), new Vsop87.LnVsop(2.21E-9, 2.20298576445, 7107.8230442756), new Vsop87.LnVsop(2.4E-9, 4.4143509793, 26724.8994135984), new Vsop87.LnVsop(2.97E-9, 3.78413749616, 2766.267628365), new Vsop87.LnVsop(2.17E-9, 1.3780721038, 3415.3940252671), new Vsop87.LnVsop(2.19E-9, 1.12519699838, 19004.6479494084), new Vsop87.LnVsop(2.64E-9, 5.35368881837, 6816.289933435), new Vsop87.LnVsop(2.13E-9, 4.60102337184, 3973.396166013), new Vsop87.LnVsop(2.07E-9, 0.02823735894, 11780.4903585162), new Vsop87.LnVsop(2.69E-9, 5.04544647217, 9381.9399937854), new Vsop87.LnVsop(1.99E-9, 0.56008805316, 6677.6344247478), new Vsop87.LnVsop(1.98E-9, 5.08122652297, 5820.9149246468), new Vsop87.LnVsop(2.02E-9, 0.66026194818, 15664.03552270859), new Vsop87.LnVsop(1.99E-9, 2.66232840511, 6696.4773245846), new Vsop87.LnVsop(1.95E-9, 1.32702139505, 8329.671610597), new Vsop87.LnVsop(2.17E-9, 4.71573630875, 8671.9698704406), new Vsop87.LnVsop(2.0E-9, 6.08006112918, 8982.810669309), new Vsop87.LnVsop(1.99E-9, 0.64418678665, 3017.1070100424), new Vsop87.LnVsop(2.42E-9, 0.76562027191, 3281.2385647862), new Vsop87.LnVsop(1.98E-9, 3.90737735547, 266.6070417218), new Vsop87.LnVsop(2.55E-9, 6.06895152008, 14054.607308026), new Vsop87.LnVsop(1.98E-9, 1.08773858955, 6684.8152820514), new Vsop87.LnVsop(1.84E-9, 5.6869230835, 5642.1982426092), new Vsop87.LnVsop(2.11E-9, 0.41936979363, 5732.0492444298), new Vsop87.LnVsop(1.79E-9, 4.60064915956, 10235.1363755374), new Vsop87.LnVsop(1.98E-9, 1.01742381306, 3336.7310913418), new Vsop87.LnVsop(2.07E-9, 0.80705657101, 3877.4169387952), new Vsop87.LnVsop(1.83E-9, 0.18403294603, 22743.4093795164), new Vsop87.LnVsop(2.13E-9, 1.66556553404, 18984.2926300096), new Vsop87.LnVsop(2.01E-9, 1.61667781335, 11216.284290324), new Vsop87.LnVsop(2.34E-9, 0.91473007796, 18454.601664915), new Vsop87.LnVsop(1.82E-9, 6.15499981293, 4885.9664096786), new Vsop87.LnVsop(2.12E-9, 4.84465364468, 5618.3198048614), new Vsop87.LnVsop(1.65E-9, 4.67153799461, 3253.30422216), new Vsop87.LnVsop(1.87E-9, 6.2312077327, 6660.8695340008), new Vsop87.LnVsop(1.85E-9, 2.77104254836, 220.4126424388), new Vsop87.LnVsop(2.06E-9, 3.5891623448, 3205.5473466644), new Vsop87.LnVsop(2.25E-9, 1.77219878817, 5625.3660415594), new Vsop87.LnVsop(1.61E-9, 6.26906099125, 1437.1756141986), new Vsop87.LnVsop(2.11E-9, 1.50617882193, 4039.8835749274), new Vsop87.LnVsop(1.62E-9, 3.95593670469, 20.3553193988), new Vsop87.LnVsop(1.63E-9, 0.67965511211, 12310.1813236108), new Vsop87.LnVsop(1.77E-9, 2.14779710666, 3346.1353510072), new Vsop87.LnVsop(1.56E-9, 3.33869391672, 9070.1188738488), new Vsop87.LnVsop(1.57E-9, 6.0990945679, 103.0927742186), new Vsop87.LnVsop(1.6E-9, 3.55342782572, 7373.3824546264), new Vsop87.LnVsop(1.77E-9, 1.65819873579, 10713.9948813262), new Vsop87.LnVsop(1.8E-9, 3.51640761022, 533.2140834436), new Vsop87.LnVsop(1.57E-9, 4.9158126027, 15508.6151232744), new Vsop87.LnVsop(1.91E-9, 1.74466477182, 10022.8176011676), new Vsop87.LnVsop(1.54E-9, 2.64640687885, 3333.5661900018), new Vsop87.LnVsop(1.62E-9, 1.2723539268, 5415.6573747732), new Vsop87.LnVsop(1.73E-9, 3.76300416846, 3561.0250691386), new Vsop87.LnVsop(1.43E-9, 1.32201387342, 6460.8122109608), new Vsop87.LnVsop(1.44E-9, 0.86610432289, 7380.4960016272), new Vsop87.LnVsop(1.5E-9, 0.2352865791, 1228.9621133222), new Vsop87.LnVsop(1.49E-9, 4.75865756164, 16706.585251848), new Vsop87.LnVsop(1.42E-9, 0.12641372157, 647.0108333148), new Vsop87.LnVsop(1.44E-9, 1.7525031694, 3657.0042963564), new Vsop87.LnVsop(1.9E-9, 2.9747414335, 2178.137722292), new Vsop87.LnVsop(1.8E-9, 1.62979022238, 22345.2603761082), new Vsop87.LnVsop(1.37E-9, 0.86380989573, 3603.6963500726), new Vsop87.LnVsop(1.71E-9, 5.55954917189, 3265.8308281325), new Vsop87.LnVsop(1.57E-9, 0.21333168528, 11614.4332937322), new Vsop87.LnVsop(1.39E-9, 4.121712917, 3351.2490920496), new Vsop87.LnVsop(1.52E-9, 4.88531923989, 110.2063212194), new Vsop87.LnVsop(1.4E-9, 0.73627264345, 6784.3176276182), new Vsop87.LnVsop(1.64E-9, 2.74481179645, 4672.6673142406), new Vsop87.LnVsop(1.37E-9, 3.68919280446, 13171.0014406876), new Vsop87.LnVsop(1.29E-9, 0.9261675717, 419.4846438752), new Vsop87.LnVsop(1.68E-9, 3.42400489879, 1581.959348283), new Vsop87.LnVsop(1.31E-9, 4.47058088889, 9499.2598620056), new Vsop87.LnVsop(1.78E-9, 0.23826290032, 12323.4230960088), new Vsop87.LnVsop(1.29E-9, 2.67549491276, 6546.1597733642), new Vsop87.LnVsop(1.51E-9, 3.49362947695, 14158.7477136156), new Vsop87.LnVsop(1.45E-9, 1.88394518039, 9468.267877257), new Vsop87.LnVsop(1.38E-9, 1.92770959202, 15.252471185), new Vsop87.LnVsop(1.56E-9, 0.69181715595, 6475.0393049624), new Vsop87.LnVsop(1.25E-9, 2.87440336541, 21947.1113727), new Vsop87.LnVsop(1.2E-9, 6.04082590555, 6606.4432548323), new Vsop87.LnVsop(1.19E-9, 0.22502589672, 11766.2632645146), new Vsop87.LnVsop(1.38E-9, 4.50665834944, 2480.302497947), new Vsop87.LnVsop(1.22E-9, 5.75861465034, 19513.9835951042), new Vsop87.LnVsop(1.18E-9, 5.77539819462, 12722.5524204852), new Vsop87.LnVsop(1.53E-9, 4.38474958775, 13362.517017102), new Vsop87.LnVsop(1.47E-9, 5.86793324184, 3169.9395560806), new Vsop87.LnVsop(1.23E-9, 4.65915578752, 13149.1506113612), new Vsop87.LnVsop(1.18E-9, 3.89507779037, 4936.7988689844), new Vsop87.LnVsop(1.15E-9, 1.78200876468, 4379.6390374902), new Vsop87.LnVsop(1.26E-9, 4.43971496486, 3568.0885594888), new Vsop87.LnVsop(1.25E-9, 5.79244198156, 10721.108428327), new Vsop87.LnVsop(1.14E-9, 0.36704570747, 3384.3313390048), new Vsop87.LnVsop(1.12E-9, 0.26706304724, 3077.528503327), new Vsop87.LnVsop(1.15E-9, 0.23672592064, 224.3447957019), new Vsop87.LnVsop(1.13E-9, 2.4910381184, 18606.4989460002), new Vsop87.LnVsop(1.12E-9, 3.5099986076, 1375.7737998458), new Vsop87.LnVsop(1.11E-9, 2.05577813769, 25685.872802808), new Vsop87.LnVsop(1.08E-9, 0.41427720679, 10014.7237330986), new Vsop87.LnVsop(1.07E-9, 5.88054875426, 4193.8088084518), new Vsop87.LnVsop(1.44E-9, 2.37737192511, 4989.0591838972), new Vsop87.LnVsop(1.06E-9, 5.26328794163, 10264.5658840734), new Vsop87.LnVsop(1.23E-9, 1.1540518776, 2807.3983432562), new Vsop87.LnVsop(1.08E-9, 0.69362164321, 13207.029307365), new Vsop87.LnVsop(1.09E-9, 4.8175438825, 13362.3823964964), new Vsop87.LnVsop(1.05E-9, 1.20865142997, 8584.6616659008), new Vsop87.LnVsop(1.12E-9, 3.04107822201, 1118.7557921028), new Vsop87.LnVsop(1.4E-9, 3.0746123348, 3329.97576135), new Vsop87.LnVsop(1.04E-9, 5.07342540664, 23141.5583829246), new Vsop87.LnVsop(1.0E-9, 4.08698733114, 3511.285297319), new Vsop87.LnVsop(1.0E-9, 2.21629137011, 10042.6126755918), new Vsop87.LnVsop(1.3E-9, 3.04769575195, 3341.0325027934), new Vsop87.LnVsop(1.17E-9, 2.96906061501, 9602.3526362242), new Vsop87.LnVsop(1.33E-9, 0.92660324186, 5401.4302807716), new Vsop87.LnVsop(9.8E-10, 4.54292546461, 3362.4632560262), new Vsop87.LnVsop(1.03E-9, 1.15607014363, 1162.4747044078), new Vsop87.LnVsop(1.0E-9, 5.4553824062, 3024.2205570432), new Vsop87.LnVsop(1.06E-9, 0.04672320679, 10001.061884607), new Vsop87.LnVsop(1.02E-9, 5.43051265314, 13892.1406718938), new Vsop87.LnVsop(1.0E-9, 1.80839732608, 6665.9723822146), new Vsop87.LnVsop(1.06E-9, 5.15137987333, 956.2891559706), new Vsop87.LnVsop(1.2E-9, 4.93427545375, 3443.7052009184), new Vsop87.LnVsop(9.6E-10, 2.50517646103, 664.75604513), new Vsop87.LnVsop(9.5E-10, 1.54460105726, 8799.988713778), new Vsop87.LnVsop(9.6E-10, 2.32476267442, 10028.9508271002), new Vsop87.LnVsop(1.13E-9, 1.7441037834, 11610.9101753832), new Vsop87.LnVsop(9.6E-10, 1.63061364111, 11925.2740926006), new Vsop87.LnVsop(1.08E-9, 4.35937497672, 6531.661656265), new Vsop87.LnVsop(1.05E-9, 4.33268432166, 3490.1756238344), new Vsop87.LnVsop(1.04E-9, 1.94703327593, 8965.9784682592), new Vsop87.LnVsop(9.1E-10, 2.0157069907, 22324.9050567094), new Vsop87.LnVsop(1.21E-9, 0.83420201993, 9638.9407478762), new Vsop87.LnVsop(9.0E-10, 4.3270459303, 2277.7073781616), new Vsop87.LnVsop(1.2E-9, 3.6874941129, 3873.8265101434), new Vsop87.LnVsop(9.2E-10, 0.67037378438, 23.8784377478), new Vsop87.LnVsop(9.4E-10, 4.85202869277, 14047.4937610252), new Vsop87.LnVsop(9.8E-10, 1.49843517093, 1062.9050485382), new Vsop87.LnVsop(1.11E-9, 3.91313035726, 3311.18291816379), new Vsop87.LnVsop(9.0E-10, 1.1390996061, 20809.4676246452), new Vsop87.LnVsop(1.22E-9, 3.09764437623, 6685.1061887576), new Vsop87.LnVsop(8.9E-10, 1.35955728945, 74.7815985673), new Vsop87.LnVsop(8.7E-10, 0.40525161626, 2221.856634597), new Vsop87.LnVsop(9.1E-10, 1.65719601329, 24150.080051345), new Vsop87.LnVsop(8.7E-10, 4.95577178269, 7314.0085927128), new Vsop87.LnVsop(1.19E-9, 2.52666872323, 3312.163239232), new Vsop87.LnVsop(8.6E-10, 4.91140297195, 1505.28780909299), new Vsop87.LnVsop(9.0E-10, 5.47684323652, 16699.53901514999), new Vsop87.LnVsop(9.3E-10, 1.61394240489, 3341.0423098265), new Vsop87.LnVsop(8.4E-10, 1.19467014431, 3450.8187479192), new Vsop87.LnVsop(9.3E-10, 5.65496964075, 6717.252720077), new Vsop87.LnVsop(8.8E-10, 2.07197299634, 8013.2797409404), new Vsop87.LnVsop(9.1E-10, 3.19274526675, 6657.3464156518), new Vsop87.LnVsop(1.16E-9, 5.59201102649, 2814.4445799542), new Vsop87.LnVsop(1.08E-9, 1.61835726703, 3774.3241645766), new Vsop87.LnVsop(1.0E-9, 3.20917035158, 25287.7237993998), new Vsop87.LnVsop(8.1E-10, 3.97528452038, 170.6728706192), new Vsop87.LnVsop(9.6E-10, 6.24177147506, 5511.636601991), new Vsop87.LnVsop(8.2E-10, 2.54795664637, 6675.7019290922), new Vsop87.LnVsop(1.09E-9, 0.33310112429, 6709.6740408674), new Vsop87.LnVsop(7.8E-10, 2.39251862859, 13553.8979729108), new Vsop87.LnVsop(8.7E-10, 1.23871371074, 6705.1032911474), new Vsop87.LnVsop(8.9E-10, 5.11656374881, 3451.7990689874), new Vsop87.LnVsop(8.4E-10, 5.98544635153, 3760.097070575), new Vsop87.LnVsop(9.7E-10, 4.60643770505, 6701.5801727984), new Vsop87.LnVsop(9.0E-10, 1.49936448326, 4271.9755135516), new Vsop87.LnVsop(9.7E-10, 2.05363004056, 6518.7582172674), new Vsop87.LnVsop(9.1E-10, 5.44752826195, 3427.9206312396), new Vsop87.LnVsop(9.1E-10, 3.80708729431, 2125.8774073792), new Vsop87.LnVsop(1.05E-9, 2.99053884594, 3326.3853326982), new Vsop87.LnVsop(9.3E-10, 5.59480359619, 3340.1825435731), new Vsop87.LnVsop(1.0E-9, 6.02550501045, 3313.210870603), new Vsop87.LnVsop(7.6E-10, 1.47971015405, 5408.5438277724), new Vsop87.LnVsop(7.5E-10, 6.1609589009, 3370.0419352358), new Vsop87.LnVsop(7.8E-10, 4.97425495725, 3229.4257844122), new Vsop87.LnVsop(7.9E-10, 5.9438837387, 6155.057006654), new Vsop87.LnVsop(7.3E-10, 4.44787843599, 20206.141196331), new Vsop87.LnVsop(7.4E-10, 4.70229419011, 24889.5747959916), new Vsop87.LnVsop(7.8E-10, 1.74679623517, 6756.0064519669), new Vsop87.LnVsop(7.3E-10, 3.32559034423, 9588.1255422226), new Vsop87.LnVsop(7.4E-10, 1.02108709897, 12295.9542296092), new Vsop87.LnVsop(7.6E-10, 1.96280508181, 14421.8316369884), new Vsop87.LnVsop(7.3E-10, 3.01125622032, 206.1855484372), new Vsop87.LnVsop(7.3E-10, 0.91136148207, 2675.8563815698), new Vsop87.LnVsop(7.8E-10, 1.71095661489, 3399.9862886134), new Vsop87.LnVsop(7.2E-10, 3.22896783419, 52175.8062831484), new Vsop87.LnVsop(8.6E-10, 4.69272071417, 14061.7208550268), new Vsop87.LnVsop(7.7E-10, 5.64501410813, 3209.0704650134), new Vsop87.LnVsop(8.0E-10, 5.70275817485, 10156.9023601348), new Vsop87.LnVsop(7.5E-10, 3.83222347813, 39048.3225096072), new Vsop87.LnVsop(7.1E-10, 0.76956199701, 7366.2689076256), new Vsop87.LnVsop(8.4E-10, 0.79243785412, 16276.463942623), new Vsop87.LnVsop(9.8E-10, 2.04888453127, 15265.8865193004), new Vsop87.LnVsop(8.4E-10, 4.65013165954, 6947.8318951214), new Vsop87.LnVsop(7.3E-10, 4.30089715672, 21548.9623692918), new Vsop87.LnVsop(8.6E-10, 1.50050122351, 5989.0672521728), new Vsop87.LnVsop(7.0E-10, 2.69225539304, 3296.8935143948), new Vsop87.LnVsop(9.4E-10, 0.7440975662, 5244.049239201), new Vsop87.LnVsop(7.4E-10, 2.27409026869, 4845.9002357928), new Vsop87.LnVsop(7.1E-10, 3.75623870844, 28628.3362260996), new Vsop87.LnVsop(6.7E-10, 3.31991953846, 6414.6178116778), new Vsop87.LnVsop(6.7E-10, 1.32197410604, 23546.7536230308), new Vsop87.LnVsop(6.5E-10, 2.68548224676, 4186.695261451), new Vsop87.LnVsop(6.4E-10, 3.98415414793, 3368.0139827966), new Vsop87.LnVsop(6.5E-10, 4.15810281695, 3340.19235060619), new Vsop87.LnVsop(7.3E-10, 2.84956464399, 8542.970706035), new Vsop87.LnVsop(6.4E-10, 1.07959823787, 6944.3087767724), new Vsop87.LnVsop(6.4E-10, 1.20206773863, 38.1330356378), new Vsop87.LnVsop(7.9E-10, 1.01784404862, 7321.1221397136), new Vsop87.LnVsop(7.0E-10, 3.81533325092, 6578.132079181), new Vsop87.LnVsop(6.3E-10, 0.67886798875, 6688.2710900976), new Vsop87.LnVsop(8.6E-10, 2.24834434956, 3232.9489027612), new Vsop87.LnVsop(7.4E-10, 3.63312603513, 15906.7641266826), new Vsop87.LnVsop(6.1E-10, 5.69343218974, 4459.3682188026), new Vsop87.LnVsop(6.8E-10, 5.10830400193, 9485.032768004), new Vsop87.LnVsop(6.1E-10, 1.95896237186, 12199.9750023914), new Vsop87.LnVsop(7.6E-10, 0.43724958811, 5032.7780962022), new Vsop87.LnVsop(6.2E-10, 3.22645996942, 2540.7913015344), new Vsop87.LnVsop(6.1E-10, 4.22937427795, 1854.6323056346), new Vsop87.LnVsop(7.0E-10, 1.02515278218, 6621.850991486), new Vsop87.LnVsop(6.0E-10, 1.09184289831, 10124.930054318), new Vsop87.LnVsop(6.0E-10, 4.72802697102, 16865.5287696312), new Vsop87.LnVsop(5.9E-10, 2.92995535821, 9886.772200064), new Vsop87.LnVsop(5.8E-10, 4.87086894257, 48300.16010269), new Vsop87.LnVsop(5.8E-10, 0.43992500862, 6418.1409300268), new Vsop87.LnVsop(5.8E-10, 5.73619727103, 2008.557539159), new Vsop87.LnVsop(7.2E-10, 4.5240636326, 16304.9131300908), new Vsop87.LnVsop(6.7E-10, 0.75347219892, 16703.0448798468), new Vsop87.LnVsop(7.0E-10, 4.09500525151, 3416.8784979754), new Vsop87.LnVsop(8.0E-10, 1.80777950075, 931.3630868518), new Vsop87.LnVsop(6.0E-10, 4.92798256747, 3391.89276456221), new Vsop87.LnVsop(5.8E-10, 2.45928697672, 4005.3684718298), new Vsop87.LnVsop(7.5E-10, 4.81816499658, 3289.33208883739), new Vsop87.LnVsop(5.8E-10, 1.73479637157, 2409.249339848), new Vsop87.LnVsop(6.2E-10, 5.24555453429, 17101.2111369072), new Vsop87.LnVsop(5.5E-10, 3.59862329711, 7322.1024607818), new Vsop87.LnVsop(6.0E-10, 0.91598691483, 10018.2468514476), new Vsop87.LnVsop(5.4E-10, 5.5431093749, 2604.735913168), new Vsop87.LnVsop(5.7E-10, 0.39808125859, 18451.07854656599), new Vsop87.LnVsop(5.9E-10, 2.0292225638, 45486.81875903279), new Vsop87.LnVsop(6.8E-10, 2.78497806929, 16703.07938715119), new Vsop87.LnVsop(5.4E-10, 1.76917054114, 3510.1926098328), new Vsop87.LnVsop(6.3E-10, 2.80264902488, 16894.5103996106), new Vsop87.LnVsop(7.4E-10, 1.36214292325, 10025.4277087512), new Vsop87.LnVsop(6.3E-10, 2.41547192168, 59.3738619136), new Vsop87.LnVsop(5.4E-10, 1.06826755543, 8948.2282559086), new Vsop87.LnVsop(5.1E-10, 1.64684042106, 3472.1543883862), new Vsop87.LnVsop(5.2E-10, 3.43538989813, 14867.73751589219), new Vsop87.LnVsop(6.2E-10, 0.8668040861, 17468.8551979454), new Vsop87.LnVsop(5.1E-10, 2.12159286185, 2412.772458197), new Vsop87.LnVsop(5.6E-10, 6.11996315499, 17085.9586657222), new Vsop87.LnVsop(5.3E-10, 2.94662143572, 11527.1250891924), new Vsop87.LnVsop(5.0E-10, 3.17196717347, 2111.6503133776), new Vsop87.LnVsop(5.5E-10, 5.7260754556, 10706.8813343254), new Vsop87.LnVsop(6.2E-10, 0.57333106196, 3171.0322435668), new Vsop87.LnVsop(5.3E-10, 1.29021847041, 6652.7756659318), new Vsop87.LnVsop(5.2E-10, 4.17299292219, 6106.8800550648), new Vsop87.LnVsop(6.5E-10, 3.82721710324, 18208.349942592), new Vsop87.LnVsop(6.5E-10, 5.11165617529, 3113.1362939108), new Vsop87.LnVsop(4.8E-10, 3.04479041123, 4140.4335518652), new Vsop87.LnVsop(4.8E-10, 5.15462485717, 12012.5822971404), new Vsop87.LnVsop(4.9E-10, 2.53202412418, 10448.4354709754), new Vsop87.LnVsop(5.5E-10, 0.78890011077, 11769.8536931664), new Vsop87.LnVsop(4.7E-10, 3.65081479882, 9872.2740829648), new Vsop87.LnVsop(4.7E-10, 2.74355062408, 14577.1847261198), new Vsop87.LnVsop(5.1E-10, 4.86147404192, 1485.9801210652), new Vsop87.LnVsop(5.9E-10, 2.96261275062, 14071.43950907579), new Vsop87.LnVsop(6.0E-10, 1.59668057901, 4025.6564809258), new Vsop87.LnVsop(4.5E-10, 1.38985168616, 1272.6810256272), new Vsop87.LnVsop(4.6E-10, 4.84193245992, 32124.36905223359), new Vsop87.LnVsop(4.8E-10, 4.20779723621, 43340.6533425576), new Vsop87.LnVsop(4.7E-10, 1.4350238292, 2938.9403049426), new Vsop87.LnVsop(5.8E-10, 4.41305155897, 1478.8665740644), new Vsop87.LnVsop(4.5E-10, 5.07966377852, 3318.7615973734), new Vsop87.LnVsop(5.8E-10, 5.5812143318, 6643.0918177618), new Vsop87.LnVsop(4.7E-10, 1.08172284939, 3448.2759506384), new Vsop87.LnVsop(4.8E-10, 5.02446939402, 6645.1969867222), new Vsop87.LnVsop(4.4E-10, 4.02177323039, 9389.0535407862), new Vsop87.LnVsop(4.2E-10, 0.75715065967, 6357.7194367422), new Vsop87.LnVsop(4.2E-10, 0.28202781151, 10001.48196070061), new Vsop87.LnVsop(4.2E-10, 5.05676915852, 3397.5108016354), new Vsop87.LnVsop(4.3E-10, 4.94357970653, 18052.9295431578), new Vsop87.LnVsop(5.0E-10, 4.04580413243, 5835.1420186484), new Vsop87.LnVsop(4.6E-10, 0.42891568037, 14128.2427712456), new Vsop87.LnVsop(4.3E-10, 4.15051754642, 8535.8571590342), new Vsop87.LnVsop(5.3E-10, 6.08293348275, 3377.217792004), new Vsop87.LnVsop(4.1E-10, 1.24482327948, 3212.5935833624), new Vsop87.LnVsop(4.1E-10, 5.60183242162, 685.044054226), new Vsop87.LnVsop(5.5E-10, 2.49939849707, 8186.5126624926), new Vsop87.LnVsop(4.1E-10, 5.04767355904, 6571.0185321802), new Vsop87.LnVsop(4.2E-10, 3.00593850304, 10037.0897512844), new Vsop87.LnVsop(4.2E-10, 2.0890755071, 13363.4300278674), new Vsop87.LnVsop(4.1E-10, 0.56957277734, 20995.3929664494), new Vsop87.LnVsop(4.5E-10, 1.33351374757, 632.7837393132), new Vsop87.LnVsop(4.6E-10, 0.81640935106, 45884.967762441), new Vsop87.LnVsop(4.0E-10, 5.83979846235, 846.0828347512), new Vsop87.LnVsop(4.1E-10, 0.05913112284, 21150.8133658836), new Vsop87.LnVsop(4.4E-10, 2.89985709529, 6872.6731195112), new Vsop87.LnVsop(4.6E-10, 4.79599204822, 1835.3246176068), new Vsop87.LnVsop(4.5E-10, 1.98433687681, 1861.7458526354), new Vsop87.LnVsop(4.0E-10, 4.76232751326, 4392.8808098882), new Vsop87.LnVsop(4.4E-10, 4.30367510983, 21000.9158907568), new Vsop87.LnVsop(4.0E-10, 6.09284885194, 7483.5887758458), new Vsop87.LnVsop(4.0E-10, 2.33956668789, 12729.665967486), new Vsop87.LnVsop(4.6E-10, 2.86512929328, 38650.173506199), new Vsop87.LnVsop(3.8E-10, 3.65846461938, 29698.2875113358), new Vsop87.LnVsop(3.8E-10, 2.26400097984, 38407.44490222499), new Vsop87.LnVsop(3.8E-10, 4.62487442464, 13532.0298899322), new Vsop87.LnVsop(4.5E-10, 0.05726736439, 8226.5788363784), new Vsop87.LnVsop(4.3E-10, 5.28854105201, 3274.1250177854), new Vsop87.LnVsop(3.7E-10, 4.75280838392, 30065.5118402982), new Vsop87.LnVsop(4.7E-10, 6.25707790441, 24606.13555322), new Vsop87.LnVsop(3.7E-10, 5.02115296017, 11128.9760857842), new Vsop87.LnVsop(3.9E-10, 1.71554278762, 7696.8878712838), new Vsop87.LnVsop(3.7E-10, 4.3465298512, 3283.7140517642), new Vsop87.LnVsop(3.7E-10, 3.91795548862, 9945.5712088238), new Vsop87.LnVsop(3.8E-10, 1.54872687701, 6740.5987153132), new Vsop87.LnVsop(3.6E-10, 6.1167195256, 9947.0556815321), new Vsop87.LnVsop(3.6E-10, 4.61440005357, 6901.6374958384), new Vsop87.LnVsop(3.8E-10, 0.44080908793, 24491.4257925834), new Vsop87.LnVsop(3.6E-10, 1.73681874925, 3468.6312700372), new Vsop87.LnVsop(4.1E-10, 5.6929490057, 26087.9031415742), new Vsop87.LnVsop(4.6E-10, 4.24370266362, 3074.005384978), new Vsop87.LnVsop(3.8E-10, 0.72727556007, 26084.0218062162), new Vsop87.LnVsop(3.5E-10, 0.09307361585, 8742.0427074714), new Vsop87.LnVsop(3.5E-10, 1.35173564664, 7218.029365495), new Vsop87.LnVsop(3.8E-10, 5.04852696556, 16066.0658614748), new Vsop87.LnVsop(3.9E-10, 4.09330106885, 28783.75662553379), new Vsop87.LnVsop(3.5E-10, 2.18607267347, 8859.3625756916), new Vsop87.LnVsop(3.4E-10, 3.37294996504, 48429.2821823244), new Vsop87.LnVsop(3.7E-10, 3.20773047278, 41748.0573289248), new Vsop87.LnVsop(3.6E-10, 1.1444953641, 15650.7937503106), new Vsop87.LnVsop(4.3E-10, 2.47145616667, 10020.8569590312), new Vsop87.LnVsop(4.0E-10, 6.03176945066, 17810.2009391838), new Vsop87.LnVsop(3.4E-10, 0.51621135764, 1107.1388056848), new Vsop87.LnVsop(3.8E-10, 5.52686444444, 3742.284548457), new Vsop87.LnVsop(3.5E-10, 4.07971812965, 8646.0634802536), new Vsop87.LnVsop(3.7E-10, 0.76802632064, 35464.9814789334), new Vsop87.LnVsop(3.4E-10, 0.48466144733, 38805.59390563319), new Vsop87.LnVsop(4.4E-10, 4.85886492681, 6604.958782124), new Vsop87.LnVsop(3.3E-10, 0.15905665569, 10787.6303445458), new Vsop87.LnVsop(3.3E-10, 6.26077209051, 4106.4054911462), new Vsop87.LnVsop(3.2E-10, 4.72374245003, 8827.3902698748), new Vsop87.LnVsop(3.4E-10, 1.67384584037, 40398.189919266), new Vsop87.LnVsop(3.8E-10, 3.42695313525, 37703.9780242558), new Vsop87.LnVsop(3.7E-10, 5.01873798104, 13575.7488022372), new Vsop87.LnVsop(4.3E-10, 4.79904796675, 5195.2447323344), new Vsop87.LnVsop(3.8E-10, 2.54832320063, 10184.3039162316), new Vsop87.LnVsop(3.2E-10, 0.2646534173, 3029.7716278314), new Vsop87.LnVsop(3.2E-10, 6.21574097484, 15110.4661198662), new Vsop87.LnVsop(3.1E-10, 3.63433062848, 45088.6697556246), new Vsop87.LnVsop(4.2E-10, 0.55440675602, 32920.66705904999), new Vsop87.LnVsop(3.5E-10, 3.96268115235, 3185.2593375684), new Vsop87.LnVsop(3.3E-10, 5.88039450059, 19403.7772738848), new Vsop87.LnVsop(4.1E-10, 4.27695289187, 7747.7203305896), new Vsop87.LnVsop(3.3E-10, 5.41476981924, 20735.83216142559), new Vsop87.LnVsop(4.1E-10, 4.1396402151, 12516.366872048), new Vsop87.LnVsop(3.6E-10, 6.22368196486, 4356.275444584), new Vsop87.LnVsop(3.1E-10, 1.81900571208, 24093.2767891752), new Vsop87.LnVsop(4.1E-10, 2.61892942249, 24076.4445881254), new Vsop87.LnVsop(3.0E-10, 1.2575033157, 34363.365597556), new Vsop87.LnVsop(3.5E-10, 4.30790850908, 4447.7512323846), new Vsop87.LnVsop(3.4E-10, 2.15402582261, 12502.1397780464), new Vsop87.LnVsop(3.0E-10, 1.74402934752, 10177.1903692308), new Vsop87.LnVsop(3.4E-10, 4.98491983613, 20199.02764933019), new Vsop87.LnVsop(2.9E-10, 0.38968519354, 35707.7100829074), new Vsop87.LnVsop(3.5E-10, 1.98847450868, 14556.8967170238), new Vsop87.LnVsop(3.2E-10, 0.36447448811, 5466.4225237762), new Vsop87.LnVsop(2.9E-10, 2.84335822989, 3651.4532255682), new Vsop87.LnVsop(2.9E-10, 1.70561861073, 42146.20633233299), new Vsop87.LnVsop(2.9E-10, 6.27427740112, 31022.7531708562), new Vsop87.LnVsop(2.9E-10, 4.85775467825, 36.0278666774), new Vsop87.LnVsop(2.9E-10, 0.65663514164, 3344.11829139661), new Vsop87.LnVsop(3.9E-10, 2.60584004585, 6679.7403806913), new Vsop87.LnVsop(3.1E-10, 4.96068967529, 15423.267560871), new Vsop87.LnVsop(3.2E-10, 4.3074704156, 30376.3526391666), new Vsop87.LnVsop(3.1E-10, 4.97488131714, 48031.1331789162), new Vsop87.LnVsop(3.6E-10, 5.21102353378, 860.3099287528), new Vsop87.LnVsop(2.9E-10, 2.6874071272, 3344.152798701), new Vsop87.LnVsop(2.9E-10, 4.89226176414, 14469.588512484), new Vsop87.LnVsop(3.5E-10, 0.63682098833, 23553.8671700316), new Vsop87.LnVsop(2.8E-10, 3.93317215375, 2655.5683724738), new Vsop87.LnVsop(2.8E-10, 4.95417710116, 792.7748884674), new Vsop87.LnVsop(3.1E-10, 1.20412048035, 16328.72425753579), new Vsop87.LnVsop(3.3E-10, 2.23175098152, 44768.0994098786), new Vsop87.LnVsop(3.3E-10, 5.53387746412, 38086.874556479), new Vsop87.LnVsop(2.8E-10, 5.3944831815, 1250.8301963008), new Vsop87.LnVsop(3.4E-10, 0.46215642912, 2751.5475996916), new Vsop87.LnVsop(3.1E-10, 6.25053987025, 17388.10618772499), new Vsop87.LnVsop(2.8E-10, 1.84806130514, 2075.0449480734), new Vsop87.LnVsop(2.9E-10, 4.7534479961, 28230.18722269139), new Vsop87.LnVsop(2.8E-10, 4.36162258057, 39203.74290904139), new Vsop87.LnVsop(3.2E-10, 5.19762814944, 1214.8023296234), new Vsop87.LnVsop(2.7E-10, 1.83675735374, 45494.58142974879), new Vsop87.LnVsop(2.8E-10, 4.99070749177, 6593.9166488598), new Vsop87.LnVsop(2.7E-10, 3.31433250805, 12942.965062924), new Vsop87.LnVsop(2.9E-10, 4.94569969969, 87.30820453981), new Vsop87.LnVsop(2.7E-10, 1.32843166459, 7203.8022714934)};
        static Vsop87.LnVsop[] mars_radius_r2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(4.4242249E-4, 0.47930604954, 3340.6124266998), new Vsop87.LnVsop(8.138042E-5, 0.86998389204, 6681.2248533996), new Vsop87.LnVsop(1.274915E-5, 1.22593985222, 10021.8372800994), new Vsop87.LnVsop(1.87388E-6, 1.57298976045, 13362.4497067992), new Vsop87.LnVsop(4.0745E-7, 1.97082077028, 3344.1355450488), new Vsop87.LnVsop(5.2395E-7, 3.14159265359, 0.0), new Vsop87.LnVsop(2.6617E-7, 1.91665337822, 16703.062133499), new Vsop87.LnVsop(1.7828E-7, 4.43491476419, 2281.2304965106), new Vsop87.LnVsop(1.1713E-7, 4.52509926559, 3185.1920272656), new Vsop87.LnVsop(1.021E-7, 5.3914732206, 1059.3819301892), new Vsop87.LnVsop(9.95E-8, 0.41865678448, 796.2980068164), new Vsop87.LnVsop(9.236E-8, 4.53559625376, 2146.1654164752), new Vsop87.LnVsop(7.299E-8, 3.1421451312, 2544.3144198834), new Vsop87.LnVsop(7.214E-8, 2.29302335628, 6684.7479717486), new Vsop87.LnVsop(6.81E-8, 5.26707245601, 155.4203994342), new Vsop87.LnVsop(6.526E-8, 2.307724561, 3738.761430108), new Vsop87.LnVsop(7.783E-8, 5.93373461009, 1748.016413067), new Vsop87.LnVsop(5.84E-8, 1.0519182029, 1349.8674096588), new Vsop87.LnVsop(6.75E-8, 5.30191763402, 1194.4470102246), new Vsop87.LnVsop(4.695E-8, 0.76881032874, 3097.88382272579), new Vsop87.LnVsop(5.39E-8, 1.0020006836, 3149.1641605882), new Vsop87.LnVsop(4.406E-8, 2.45557331437, 951.7184062506), new Vsop87.LnVsop(4.286E-8, 3.89642578846, 1592.5960136328), new Vsop87.LnVsop(3.516E-8, 1.84991934524, 398.1490034082), new Vsop87.LnVsop(3.699E-8, 2.26016989021, 20043.6745601988), new Vsop87.LnVsop(3.378E-8, 3.81703201748, 1751.539531416), new Vsop87.LnVsop(4.585E-8, 0.80785643853, 4136.9104335162), new Vsop87.LnVsop(3.201E-8, 2.11661594157, 5614.7293762096), new Vsop87.LnVsop(3.62E-8, 1.32428600053, 3333.498879699), new Vsop87.LnVsop(2.915E-8, 1.19342490174, 529.6909650946), new Vsop87.LnVsop(2.979E-8, 2.86468474914, 6151.533888305), new Vsop87.LnVsop(3.057E-8, 4.55288594507, 5628.9564702112), new Vsop87.LnVsop(2.906E-8, 1.20300479533, 3894.1818295422), new Vsop87.LnVsop(3.848E-8, 3.86071515455, 553.5694028424), new Vsop87.LnVsop(2.819E-8, 2.48714583532, 1990.745017041), new Vsop87.LnVsop(2.657E-8, 6.07409846258, 4292.3308329504), new Vsop87.LnVsop(2.698E-8, 2.92100135189, 3496.032826134), new Vsop87.LnVsop(2.396E-8, 5.94193484091, 2787.0430238574), new Vsop87.LnVsop(2.263E-8, 2.56188049651, 191.4482661116), new Vsop87.LnVsop(2.169E-8, 5.36834559071, 8962.4553499102), new Vsop87.LnVsop(2.149E-8, 2.74919289456, 242.728603974), new Vsop87.LnVsop(2.218E-8, 1.85260509629, 3337.0893083508), new Vsop87.LnVsop(1.998E-8, 5.76396921426, 3341.592747768), new Vsop87.LnVsop(1.999E-8, 3.82347205028, 2914.0142358238), new Vsop87.LnVsop(1.835E-8, 5.68648448195, 1589.0728952838), new Vsop87.LnVsop(1.81E-8, 3.32122811143, 5088.6288397668), new Vsop87.LnVsop(1.968E-8, 4.17404480033, 3340.5951730476), new Vsop87.LnVsop(2.411E-8, 4.68376177281, 4690.4798363586), new Vsop87.LnVsop(1.967E-8, 6.2057036343, 3340.629680352), new Vsop87.LnVsop(1.626E-8, 5.67648778513, 4535.0594369244), new Vsop87.LnVsop(2.161E-8, 1.07446445419, 2388.8940204492), new Vsop87.LnVsop(1.965E-8, 3.10811453974, 3583.3410306738), new Vsop87.LnVsop(1.985E-8, 5.75867975763, 4399.994356889), new Vsop87.LnVsop(1.504E-8, 4.95929390466, 382.8965322232), new Vsop87.LnVsop(1.276E-8, 4.82147500391, 2957.7158944766), new Vsop87.LnVsop(1.475E-8, 2.22614544794, 3723.508958923), new Vsop87.LnVsop(1.196E-8, 3.26743061042, 9492.1463150048), new Vsop87.LnVsop(1.349E-8, 4.87558985925, 6525.8044539654), new Vsop87.LnVsop(1.436E-8, 2.6975402327, 7079.3738568078), new Vsop87.LnVsop(1.223E-8, 2.61880227353, 10025.3603984484), new Vsop87.LnVsop(1.402E-8, 5.19177439326, 2700.7151403858), new Vsop87.LnVsop(1.202E-8, 0.93436294282, 2810.9214616052), new Vsop87.LnVsop(8.7E-9, 5.81258009514, 12303.06777661), new Vsop87.LnVsop(8.67E-9, 2.20048756217, 2699.7348193176), new Vsop87.LnVsop(8.31E-9, 2.01782919511, 5092.1519581158), new Vsop87.LnVsop(8.56E-9, 5.96129932558, 426.598190876), new Vsop87.LnVsop(8.47E-9, 2.26415579047, 6283.0758499914), new Vsop87.LnVsop(9.17E-9, 1.4025908126, 6489.776587288), new Vsop87.LnVsop(8.33E-9, 1.17376008822, 7477.522860216), new Vsop87.LnVsop(1.041E-8, 6.27097603149, 3347.7259737006), new Vsop87.LnVsop(9.65E-9, 3.40293030184, 5621.8429232104), new Vsop87.LnVsop(7.23E-9, 4.26276570887, 4933.2084403326), new Vsop87.LnVsop(7.7E-9, 2.06490049164, 5486.777843175), new Vsop87.LnVsop(7.06E-9, 2.34080074294, 7.1135470008), new Vsop87.LnVsop(9.54E-9, 2.11093711712, 3870.3033917944), new Vsop87.LnVsop(8.44E-9, 2.2379157639, 3553.9115221378), new Vsop87.LnVsop(6.47E-9, 2.24565892529, 3340.545116397), new Vsop87.LnVsop(6.53E-9, 3.98464883505, 6677.7017350506), new Vsop87.LnVsop(7.17E-9, 0.29523050971, 6681.2421070518), new Vsop87.LnVsop(8.28E-9, 0.22887694811, 3532.0606928114), new Vsop87.LnVsop(6.12E-9, 1.56040446304, 7234.794256242), new Vsop87.LnVsop(7.17E-9, 4.54583138124, 6681.2075997474), new Vsop87.LnVsop(5.85E-9, 3.29614213819, 1221.8485663214), new Vsop87.LnVsop(6.46E-9, 1.8361516834, 3340.6797370026), new Vsop87.LnVsop(5.6E-9, 5.05995427063, 8031.0922630584), new Vsop87.LnVsop(6.51E-9, 0.16211451692, 7632.9432596502), new Vsop87.LnVsop(4.88E-9, 3.0783351604, 6836.6452528338), new Vsop87.LnVsop(5.34E-9, 4.25727954634, 3339.6321056316), new Vsop87.LnVsop(5.07E-9, 2.59915154873, 23384.2869868986), new Vsop87.LnVsop(3.76E-9, 6.27013206389, 2487.4160449478), new Vsop87.LnVsop(3.42E-9, 4.71066540976, 639.897286314), new Vsop87.LnVsop(4.49E-9, 1.34119375784, 640.8776073822), new Vsop87.LnVsop(3.32E-9, 2.66137676648, 9623.6882766912), new Vsop87.LnVsop(3.41E-9, 5.96083550282, 4929.6853219836), new Vsop87.LnVsop(3.47E-9, 6.09473597335, 7740.6067835888), new Vsop87.LnVsop(3.24E-9, 6.05446352414, 2118.7638603784), new Vsop87.LnVsop(4.06E-9, 4.95790035333, 8969.568896911), new Vsop87.LnVsop(3.1E-9, 0.0205132596, 6127.6554505572), new Vsop87.LnVsop(4.02E-9, 2.84641476266, 5331.3574437408), new Vsop87.LnVsop(3.19E-9, 1.44556053767, 5729.506447149), new Vsop87.LnVsop(2.98E-9, 5.73923165875, 6041.3275670856), new Vsop87.LnVsop(2.94E-9, 3.06922916435, 10419.9862835076), new Vsop87.LnVsop(2.82E-9, 6.04219786503, 7875.6718636242), new Vsop87.LnVsop(2.76E-9, 5.11697230915, 11773.3768115154), new Vsop87.LnVsop(2.61E-9, 2.89861311314, 7210.9158184942), new Vsop87.LnVsop(2.57E-9, 1.08764384198, 2288.3440435114), new Vsop87.LnVsop(2.73E-9, 3.83429606896, 8429.2412664666), new Vsop87.LnVsop(2.88E-9, 6.1358786916, 6682.2051744678), new Vsop87.LnVsop(3.02E-9, 3.61511244935, 12832.7587417046), new Vsop87.LnVsop(2.35E-9, 2.2141930833, 6681.2921637024), new Vsop87.LnVsop(3.17E-9, 3.60614958531, 2301.58581590939), new Vsop87.LnVsop(2.88E-9, 5.08466449059, 2274.1169495098), new Vsop87.LnVsop(2.54E-9, 0.3659486969, 3767.2106175758), new Vsop87.LnVsop(2.35E-9, 2.6246389476, 6681.1575430968), new Vsop87.LnVsop(2.23E-9, 3.46012483249, 6923.9534573736), new Vsop87.LnVsop(2.07E-9, 3.44496733465, 10177.2576795336), new Vsop87.LnVsop(2.15E-9, 0.57778871417, 10973.55568635), new Vsop87.LnVsop(2.03E-9, 3.89606611321, 10018.3141617504), new Vsop87.LnVsop(1.91E-9, 2.41041363946, 8955.3418029094), new Vsop87.LnVsop(1.91E-9, 1.58000924939, 10818.1352869158), new Vsop87.LnVsop(1.94E-9, 2.45866911623, 7064.1213856228), new Vsop87.LnVsop(1.83E-9, 1.67726083027, 213.299095438), new Vsop87.LnVsop(1.91E-9, 0.58807580019, 5828.0284716476), new Vsop87.LnVsop(2.38E-9, 1.99795553508, 10575.4066829418), new Vsop87.LnVsop(2.46E-9, 2.17522479887, 4562.4609930212), new Vsop87.LnVsop(1.77E-9, 0.66443060538, 10021.8545337516), new Vsop87.LnVsop(1.76E-9, 4.9164692303, 10021.8200264472), new Vsop87.LnVsop(2.17E-9, 2.93960990684, 13365.9728251482), new Vsop87.LnVsop(2.13E-9, 0.15664432335, 2942.4634232916), new Vsop87.LnVsop(1.66E-9, 4.75384735897, 3914.9572250346), new Vsop87.LnVsop(1.55E-9, 1.78567177351, 9830.3890139878), new Vsop87.LnVsop(1.64E-9, 5.17682847411, 6298.3283211764), new Vsop87.LnVsop(1.76E-9, 5.21146444811, 9866.4168806652), new Vsop87.LnVsop(1.57E-9, 2.69801327811, 6894.5239488376), new Vsop87.LnVsop(1.48E-9, 6.26338410775, 1039.0266107904), new Vsop87.LnVsop(1.48E-9, 0.36640929573, 6688.3384004004), new Vsop87.LnVsop(1.5E-9, 1.22257750814, 574.3447983348), new Vsop87.LnVsop(1.38E-9, 2.09458777391, 1066.49547719), new Vsop87.LnVsop(1.65E-9, 6.15932460183, 15643.6802033098), new Vsop87.LnVsop(1.61E-9, 4.66659171956, 8273.8208670324), new Vsop87.LnVsop(1.26E-9, 0.68196579031, 6438.4962494256), new Vsop87.LnVsop(1.27E-9, 1.69257165301, 3981.490034082), new Vsop87.LnVsop(1.18E-9, 2.78189840631, 3360.96774609859), new Vsop87.LnVsop(1.3E-9, 0.84499223832, 3355.8648978848), new Vsop87.LnVsop(1.2E-9, 0.30079432657, 3127.3133312618), new Vsop87.LnVsop(1.23E-9, 1.6352982479, 6674.1113063988), new Vsop87.LnVsop(1.29E-9, 2.26711428102, 6467.9257579616), new Vsop87.LnVsop(1.04E-9, 0.07355376701, 3325.3599555148), new Vsop87.LnVsop(1.3E-9, 4.4177719083, 3320.257107301), new Vsop87.LnVsop(9.5E-10, 1.32397695499, 7903.073419721), new Vsop87.LnVsop(1.13E-9, 0.65843018903, 3178.1457905676), new Vsop87.LnVsop(9.2E-10, 4.98212090453, 9779.1086761254), new Vsop87.LnVsop(1.0E-9, 4.11210877353, 536.8045120954), new Vsop87.LnVsop(9.6E-10, 3.52474152096, 3475.6775067352), new Vsop87.LnVsop(1.06E-9, 5.41425307049, 15113.9892382152), new Vsop87.LnVsop(1.0E-9, 2.91165340473, 692.1576012268), new Vsop87.LnVsop(1.07E-9, 3.76142120324, 13517.8701062334), new Vsop87.LnVsop(9.4E-10, 3.21490077835, 8671.9698704406), new Vsop87.LnVsop(8.6E-10, 5.24456061569, 13119.72110282519), new Vsop87.LnVsop(8.9E-10, 5.73824161119, 11371.7046897582), new Vsop87.LnVsop(1.06E-9, 5.90729095013, 8432.7643848156), new Vsop87.LnVsop(9.8E-10, 3.61325552038, 853.196381752), new Vsop87.LnVsop(8.0E-10, 2.97911637785, 26724.8994135984), new Vsop87.LnVsop(7.8E-10, 0.95802015551, 3191.0492295652), new Vsop87.LnVsop(8.0E-10, 5.90881737672, 6040.3472460174), new Vsop87.LnVsop(8.7E-10, 2.51076876054, 1052.2683831884), new Vsop87.LnVsop(9.1E-10, 3.00950021946, 12964.300703391), new Vsop87.LnVsop(7.5E-10, 1.32761316297, 17924.9106998204), new Vsop87.LnVsop(7.3E-10, 5.00315639405, 1903.4368125012), new Vsop87.LnVsop(7.3E-10, 4.09954161905, 3319.8370312074), new Vsop87.LnVsop(7.4E-10, 2.58079983162, 10021.9045904022), new Vsop87.LnVsop(7.0E-10, 5.37592930185, 12310.1813236108), new Vsop87.LnVsop(7.2E-10, 2.54228814803, 5884.9268465832), new Vsop87.LnVsop(6.9E-10, 3.48131994134, 13760.5987102074), new Vsop87.LnVsop(6.8E-10, 3.24176355205, 16706.585251848), new Vsop87.LnVsop(6.7E-10, 4.69007678444, 522.5774180938), new Vsop87.LnVsop(7.0E-10, 1.00588846894, 13362.4669604514), new Vsop87.LnVsop(7.0E-10, 2.38386517904, 13916.0191096416), new Vsop87.LnVsop(6.9E-10, 5.27194307948, 3980.5097130138), new Vsop87.LnVsop(7.4E-10, 3.946509825, 16173.3711684044), new Vsop87.LnVsop(7.7E-10, 0.12291238953, 11216.284290324), new Vsop87.LnVsop(6.2E-10, 0.15391383953, 11081.2192102886), new Vsop87.LnVsop(6.5E-10, 3.97651716363, 13358.9265884502), new Vsop87.LnVsop(7.4E-10, 2.99585183104, 10021.7699697966), new Vsop87.LnVsop(8.0E-10, 6.17370752997, 9380.9596727172), new Vsop87.LnVsop(6.1E-10, 2.56972324319, 149.5631971346), new Vsop87.LnVsop(5.9E-10, 3.80951935336, 10264.5658840734), new Vsop87.LnVsop(6.0E-10, 4.79893452692, 1437.1756141986), new Vsop87.LnVsop(6.4E-10, 0.24188540623, 18984.2926300096), new Vsop87.LnVsop(5.9E-10, 6.09929610915, 5459.3762870782), new Vsop87.LnVsop(6.0E-10, 2.26503107747, 28628.3362260996), new Vsop87.LnVsop(6.7E-10, 2.07568987702, 1596.1864422846), new Vsop87.LnVsop(5.8E-10, 5.26082962947, 13362.432453147), new Vsop87.LnVsop(5.6E-10, 1.88732579172, 9070.1188738488), new Vsop87.LnVsop(5.8E-10, 0.87844749732, 5642.1982426092), new Vsop87.LnVsop(5.6E-10, 1.18238857561, 6696.4773245846), new Vsop87.LnVsop(6.2E-10, 3.98214740104, 3427.9206312396), new Vsop87.LnVsop(5.5E-10, 5.7246233437, 433.7117378768), new Vsop87.LnVsop(5.6E-10, 2.35545469122, 33716.9650658664), new Vsop87.LnVsop(5.5E-10, 3.77399580108, 10213.285546211), new Vsop87.LnVsop(5.5E-10, 1.33171417253, 8982.810669309), new Vsop87.LnVsop(5.6E-10, 5.49808236951, 24093.2767891752), new Vsop87.LnVsop(5.3E-10, 5.34430579198, 5099.2655051166), new Vsop87.LnVsop(6.3E-10, 3.53402427573, 3205.5473466644), new Vsop87.LnVsop(6.6E-10, 6.22551943489, 8270.2977486834), new Vsop87.LnVsop(5.5E-10, 4.74960633412, 6660.8695340008), new Vsop87.LnVsop(5.4E-10, 0.30483383119, 12721.572099417), new Vsop87.LnVsop(6.7E-10, 0.5859281308, 3335.0895023924), new Vsop87.LnVsop(5.4E-10, 2.12825168465, 13171.0014406876), new Vsop87.LnVsop(5.5E-10, 5.03409432626, 7255.5696517344), new Vsop87.LnVsop(5.1E-10, 2.91157155859, 10404.7338123226), new Vsop87.LnVsop(6.8E-10, 2.44228862715, 6158.6474353058), new Vsop87.LnVsop(4.9E-10, 0.23351885884, 4379.6390374902), new Vsop87.LnVsop(6.8E-10, 2.26299130022, 2766.267628365), new Vsop87.LnVsop(5.0E-10, 6.1011945035, 3253.30422216), new Vsop87.LnVsop(4.8E-10, 2.36328912422, 4032.7700279266), new Vsop87.LnVsop(6.0E-10, 0.30397974651, 9225.539273283), new Vsop87.LnVsop(4.9E-10, 5.45150193687, 13207.029307365), new Vsop87.LnVsop(4.8E-10, 0.72695221239, 10028.9508271002), new Vsop87.LnVsop(6.1E-10, 3.40242612458, 10551.528245194), new Vsop87.LnVsop(4.9E-10, 3.40240207389, 3304.5845600224), new Vsop87.LnVsop(4.7E-10, 2.83602015531, 9808.5381846614), new Vsop87.LnVsop(4.7E-10, 0.50228092595, 17395.2197347258), new Vsop87.LnVsop(4.7E-10, 3.03745055781, 6144.4203413042), new Vsop87.LnVsop(5.1E-10, 1.2741258685, 3344.4937620578), new Vsop87.LnVsop(5.0E-10, 1.83471955356, 30376.3526391666), new Vsop87.LnVsop(4.6E-10, 0.75336415193, 16062.1845261168), new Vsop87.LnVsop(4.8E-10, 0.33255135928, 6702.000248892), new Vsop87.LnVsop(5.6E-10, 0.21744516383, 10022.8176011676), new Vsop87.LnVsop(4.6E-10, 5.8313809816, 3364.4908644476), new Vsop87.LnVsop(4.4E-10, 0.79889168525, 7107.8230442756), new Vsop87.LnVsop(5.1E-10, 0.35982632787, 9468.267877257), new Vsop87.LnVsop(4.4E-10, 3.10598653755, 10235.1363755374), new Vsop87.LnVsop(4.9E-10, 0.14978113272, 2648.454825473), new Vsop87.LnVsop(5.8E-10, 4.51787450922, 6660.4494579072), new Vsop87.LnVsop(4.2E-10, 5.40417232308, 3344.2028553516), new Vsop87.LnVsop(4.8E-10, 2.42299327989, 4407.1079038898), new Vsop87.LnVsop(5.7E-10, 3.8435413622, 6816.289933435), new Vsop87.LnVsop(4.7E-10, 1.49030680647, 6247.5131155228), new Vsop87.LnVsop(4.3E-10, 5.14318704546, 7373.3824546264), new Vsop87.LnVsop(5.3E-10, 5.94275298258, 8439.8779318164), new Vsop87.LnVsop(4.2E-10, 0.14486089509, 1505.28780909299), new Vsop87.LnVsop(4.9E-10, 5.57153056447, 17468.8551979454), new Vsop87.LnVsop(5.5E-10, 6.26098836404, 3361.3878221922), new Vsop87.LnVsop(4.6E-10, 3.07675286071, 12722.5524204852), new Vsop87.LnVsop(4.2E-10, 4.74455545491, 3369.0616141676), new Vsop87.LnVsop(4.3E-10, 4.97295184315, 3337.021998048), new Vsop87.LnVsop(5.5E-10, 3.8021563852, 3376.6402933772), new Vsop87.LnVsop(4.9E-10, 4.43316054873, 9595.2390892234), new Vsop87.LnVsop(4.7E-10, 1.97344701193, 1581.959348283), new Vsop87.LnVsop(4.3E-10, 0.38914582059, 6665.9723822146), new Vsop87.LnVsop(4.0E-10, 1.06953099245, 23695.127785767), new Vsop87.LnVsop(3.9E-10, 1.54137978685, 2818.035008606), new Vsop87.LnVsop(3.9E-10, 3.79055778605, 33318.8160624582), new Vsop87.LnVsop(3.7E-10, 5.27208151144, 20752.6643624754), new Vsop87.LnVsop(4.1E-10, 1.82257882538, 14158.7477136156), new Vsop87.LnVsop(3.9E-10, 3.15412760412, 14469.588512484), new Vsop87.LnVsop(4.1E-10, 0.55705920174, 3346.1353510072), new Vsop87.LnVsop(4.0E-10, 5.57723811162, 3863.1898447936), new Vsop87.LnVsop(3.8E-10, 2.7152520939, 8584.6616659008), new Vsop87.LnVsop(4.9E-10, 5.44994428603, 9638.9407478762), new Vsop87.LnVsop(3.6E-10, 4.85483701684, 23141.5583829246), new Vsop87.LnVsop(3.8E-10, 2.11687208088, 15664.03552270859), new Vsop87.LnVsop(3.5E-10, 5.30700692772, 6677.6344247478), new Vsop87.LnVsop(4.7E-10, 2.5684518185, 162.4666361322), new Vsop87.LnVsop(3.4E-10, 0.5254248731, 10713.9948813262), new Vsop87.LnVsop(4.7E-10, 1.37540278055, 3316.733988952), new Vsop87.LnVsop(4.5E-10, 3.09384709364, 6701.5801727984), new Vsop87.LnVsop(3.6E-10, 5.41035019142, 20597.2439630412), new Vsop87.LnVsop(3.5E-10, 0.84359386197, 6518.7582172674), new Vsop87.LnVsop(3.8E-10, 2.22559377525, 3503.079062832), new Vsop87.LnVsop(4.3E-10, 1.70231864194, 12323.4230960088), new Vsop87.LnVsop(4.6E-10, 4.97118367286, 9381.9399937854), new Vsop87.LnVsop(4.3E-10, 0.95148893985, 34115.1140692746), new Vsop87.LnVsop(3.5E-10, 5.73672778427, 6684.8152820514), new Vsop87.LnVsop(4.3E-10, 2.34641544095, 5244.049239201), new Vsop87.LnVsop(4.0E-10, 5.92298266112, 3336.7310913418), new Vsop87.LnVsop(3.2E-10, 2.93166446867, 9499.2598620056), new Vsop87.LnVsop(3.2E-10, 5.16999042304, 5085.038411115), new Vsop87.LnVsop(3.3E-10, 4.25349328071, 36659.428489158), new Vsop87.LnVsop(4.3E-10, 1.50296327105, 27035.7402124668), new Vsop87.LnVsop(4.0E-10, 5.84317493907, 16460.33352952499), new Vsop87.LnVsop(3.2E-10, 4.13881058425, 31570.7996493912), new Vsop87.LnVsop(3.5E-10, 5.50392428699, 8425.6508378148), new Vsop87.LnVsop(3.4E-10, 1.60980125001, 12566.1516999828), new Vsop87.LnVsop(3.4E-10, 3.6849408587, 8827.3902698748), new Vsop87.LnVsop(3.1E-10, 3.75179356135, 4845.9002357928), new Vsop87.LnVsop(3.0E-10, 4.87421522701, 1692.1656695024), new Vsop87.LnVsop(3.7E-10, 1.12999386856, 18052.9295431578), new Vsop87.LnVsop(3.1E-10, 2.73132541218, 12295.9542296092), new Vsop87.LnVsop(3.0E-10, 0.60227284998, 20354.5153590672), new Vsop87.LnVsop(3.0E-10, 3.5647450343, 16304.9131300908), new Vsop87.LnVsop(3.0E-10, 0.00488152861, 11243.6858464208), new Vsop87.LnVsop(3.9E-10, 3.34380105325, 29978.2036357584), new Vsop87.LnVsop(2.8E-10, 3.12073820291, 11925.2740926006), new Vsop87.LnVsop(2.7E-10, 2.53950067771, 19004.6479494084), new Vsop87.LnVsop(2.8E-10, 2.80254457895, 3607.2194684216), new Vsop87.LnVsop(3.2E-10, 4.0441273119, 6680.2445323314), new Vsop87.LnVsop(2.8E-10, 5.05697601811, 17412.0519357756), new Vsop87.LnVsop(2.9E-10, 5.85207825749, 31172.650645983), new Vsop87.LnVsop(3.3E-10, 5.16379108102, 10596.1820784342), new Vsop87.LnVsop(2.7E-10, 1.49309168626, 8186.5126624926), new Vsop87.LnVsop(2.7E-10, 2.25111298175, 76.2660712756), new Vsop87.LnVsop(2.9E-10, 1.82581479324, 3333.5661900018), new Vsop87.LnVsop(2.6E-10, 5.61633953268, 14054.607308026), new Vsop87.LnVsop(2.5E-10, 4.87224086763, 3077.528503327), new Vsop87.LnVsop(2.5E-10, 4.33552142677, 17085.9586657222), new Vsop87.LnVsop(2.7E-10, 0.80699664558, 20735.83216142559), new Vsop87.LnVsop(2.5E-10, 5.15192817935, 11766.2632645146), new Vsop87.LnVsop(2.4E-10, 4.12825907026, 4193.8088084518), new Vsop87.LnVsop(2.4E-10, 4.31275606947, 14584.2982731206), new Vsop87.LnVsop(2.4E-10, 2.19374141743, 3.523118349), new Vsop87.LnVsop(2.4E-10, 4.96463811748, 26087.9031415742), new Vsop87.LnVsop(2.7E-10, 4.99613391588, 3877.4169387952), new Vsop87.LnVsop(2.9E-10, 2.40082338888, 3312.163239232), new Vsop87.LnVsop(2.4E-10, 3.11953483056, 13149.1506113612), new Vsop87.LnVsop(3.0E-10, 5.66813524124, 3281.2385647862), new Vsop87.LnVsop(2.6E-10, 6.15978676797, 419.4846438752), new Vsop87.LnVsop(2.2E-10, 2.11310905377, 20995.3929664494), new Vsop87.LnVsop(2.2E-10, 5.24071820165, 12935.8515159232), new Vsop87.LnVsop(2.1E-10, 1.72081702579, 2803.8079146044), new Vsop87.LnVsop(2.1E-10, 4.18626331979, 187.9251477626), new Vsop87.LnVsop(2.2E-10, 2.34227094593, 7322.1024607818), new Vsop87.LnVsop(2.1E-10, 2.91971393449, 12168.0026965746), new Vsop87.LnVsop(2.3E-10, 0.93103820963, 6261.7402095244), new Vsop87.LnVsop(2.2E-10, 6.06510562418, 15110.4661198662), new Vsop87.LnVsop(2.0E-10, 5.98993383835, 24150.080051345), new Vsop87.LnVsop(2.2E-10, 2.68877932276, 3546.797975137), new Vsop87.LnVsop(2.3E-10, 0.86323712599, 30774.5016425748), new Vsop87.LnVsop(2.0E-10, 0.72774754977, 13553.8979729108), new Vsop87.LnVsop(2.2E-10, 3.09244912137, 13362.3823964964), new Vsop87.LnVsop(2.0E-10, 0.33937394936, 5989.0672521728), new Vsop87.LnVsop(2.5E-10, 4.69237538534, 3347.6586633978), new Vsop87.LnVsop(2.5E-10, 3.51209525616, 15265.8865193004), new Vsop87.LnVsop(2.6E-10, 3.36529647088, 21265.5231265202), new Vsop87.LnVsop(2.1E-10, 3.15458479593, 26637.59120905859), new Vsop87.LnVsop(1.9E-10, 5.0210492549, 3029.7716278314), new Vsop87.LnVsop(1.9E-10, 6.15294842048, 18208.349942592), new Vsop87.LnVsop(2.3E-10, 2.63078161726, 24491.4257925834), new Vsop87.LnVsop(2.5E-10, 2.94366934698, 13362.517017102), new Vsop87.LnVsop(2.0E-10, 0.86927302126, 3399.9862886134), new Vsop87.LnVsop(1.8E-10, 4.37088769243, 3651.4532255682), new Vsop87.LnVsop(2.2E-10, 4.79007467235, 11614.4332937322), new Vsop87.LnVsop(1.9E-10, 5.80539564686, 21795.21409161479), new Vsop87.LnVsop(1.7E-10, 2.62698055094, 6872.6731195112), new Vsop87.LnVsop(2.0E-10, 4.13854946023, 16699.53901514999), new Vsop87.LnVsop(1.8E-10, 2.69537794731, 27682.1407441564), new Vsop87.LnVsop(1.7E-10, 2.35800085725, 7788.3636590844), new Vsop87.LnVsop(1.6E-10, 5.1297925698, 1744.4259844152), new Vsop87.LnVsop(1.9E-10, 4.36117042303, 11780.4903585162), new Vsop87.LnVsop(1.7E-10, 3.98180845854, 18606.4989460002), new Vsop87.LnVsop(2.0E-10, 5.29535152048, 13936.794505134), new Vsop87.LnVsop(1.8E-10, 0.90866227881, 27433.88921587499), new Vsop87.LnVsop(1.8E-10, 1.15898054343, 220.4126424388), new Vsop87.LnVsop(2.1E-10, 1.07415905494, 11769.8536931664), new Vsop87.LnVsop(1.8E-10, 3.6105415674, 9485.032768004), new Vsop87.LnVsop(2.0E-10, 5.54806425258, 14128.2427712456), new Vsop87.LnVsop(1.5E-10, 4.19346479448, 23937.856389741), new Vsop87.LnVsop(1.9E-10, 2.49025671313, 24341.5283174566), new Vsop87.LnVsop(1.5E-10, 6.22588872744, 8799.988713778), new Vsop87.LnVsop(1.4E-10, 2.27829337274, 4447.7512323846), new Vsop87.LnVsop(1.5E-10, 1.86263855445, 2921.1277828246), new Vsop87.LnVsop(1.4E-10, 3.59449757262, 3074.005384978), new Vsop87.LnVsop(1.6E-10, 4.04109191506, 3134.4268782626), new Vsop87.LnVsop(1.8E-10, 1.50064662425, 19406.6782881746), new Vsop87.LnVsop(1.4E-10, 4.63902518517, 11527.1250891924), new Vsop87.LnVsop(1.9E-10, 5.20657856071, 32920.66705904999), new Vsop87.LnVsop(1.8E-10, 5.05191310629, 3603.6963500726)};
        static Vsop87.LnVsop[] mars_radius_r3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.113108E-5, 5.14987305093, 3340.6124266998), new Vsop87.LnVsop(4.24447E-6, 5.61343952053, 6681.2248533996), new Vsop87.LnVsop(1.00044E-6, 5.99727457548, 10021.8372800994), new Vsop87.LnVsop(1.9606E-7, 0.07631453783, 13362.4497067992), new Vsop87.LnVsop(3.478E-8, 0.42912010211, 16703.062133499), new Vsop87.LnVsop(4.693E-8, 3.14159265359, 0.0), new Vsop87.LnVsop(2.87E-8, 0.44692002393, 3344.1355450488), new Vsop87.LnVsop(2.428E-8, 3.02114808809, 3185.1920272656), new Vsop87.LnVsop(6.87E-9, 0.80560442666, 6684.7479717486), new Vsop87.LnVsop(5.78E-9, 0.77849309402, 20043.6745601988), new Vsop87.LnVsop(5.4E-9, 3.86818792995, 1059.3819301892), new Vsop87.LnVsop(4.68E-9, 4.52509679627, 3496.032826134), new Vsop87.LnVsop(4.87E-9, 1.60861075208, 3583.3410306738), new Vsop87.LnVsop(3.62E-9, 4.42325508671, 2787.0430238574), new Vsop87.LnVsop(3.97E-9, 5.7200847988, 3149.1641605882), new Vsop87.LnVsop(2.99E-9, 0.75708428385, 3738.761430108), new Vsop87.LnVsop(3.52E-9, 5.55622002342, 4136.9104335162), new Vsop87.LnVsop(3.16E-9, 3.37609906858, 6525.8044539654), new Vsop87.LnVsop(2.34E-9, 2.1392329263, 3097.88382272579), new Vsop87.LnVsop(2.14E-9, 4.20457486315, 3341.592747768), new Vsop87.LnVsop(2.14E-9, 0.56472270648, 155.4203994342), new Vsop87.LnVsop(2.01E-9, 2.35183535764, 1592.5960136328), new Vsop87.LnVsop(2.06E-9, 0.96951658721, 1990.745017041), new Vsop87.LnVsop(2.31E-9, 5.82604761072, 2388.8940204492), new Vsop87.LnVsop(1.63E-9, 4.15852184076, 4535.0594369244), new Vsop87.LnVsop(1.48E-9, 3.28924896754, 2957.7158944766), new Vsop87.LnVsop(1.55E-9, 5.12396546072, 796.2980068164), new Vsop87.LnVsop(1.54E-9, 1.13809634337, 10025.3603984484), new Vsop87.LnVsop(1.58E-9, 3.76267616455, 1194.4470102246), new Vsop87.LnVsop(1.34E-9, 5.57743966517, 3894.1818295422), new Vsop87.LnVsop(1.45E-9, 3.02382693331, 3337.0893083508), new Vsop87.LnVsop(1.47E-9, 4.25259909424, 4399.994356889), new Vsop87.LnVsop(1.0E-9, 4.26399779787, 1589.0728952838), new Vsop87.LnVsop(9.1E-10, 6.12313839857, 6489.776587288), new Vsop87.LnVsop(1.0E-9, 1.12570940535, 23384.2869868986), new Vsop87.LnVsop(1.0E-9, 1.17079212321, 7079.3738568078), new Vsop87.LnVsop(7.6E-10, 6.00434755125, 529.6909650946), new Vsop87.LnVsop(7.6E-10, 5.93213294948, 7477.522860216), new Vsop87.LnVsop(6.9E-10, 1.70323063297, 9492.1463150048), new Vsop87.LnVsop(6.9E-10, 3.69074496365, 8962.4553499102), new Vsop87.LnVsop(6.8E-10, 0.15861692654, 3870.3033917944), new Vsop87.LnVsop(6.1E-10, 4.14189658327, 4292.3308329504), new Vsop87.LnVsop(6.3E-10, 1.94108069224, 6923.9534573736), new Vsop87.LnVsop(6.0E-10, 4.28936601254, 12303.06777661), new Vsop87.LnVsop(6.5E-10, 1.11375145336, 6151.533888305), new Vsop87.LnVsop(7.5E-10, 4.71644556135, 3347.7259737006), new Vsop87.LnVsop(5.6E-10, 2.74147961496, 4933.2084403326), new Vsop87.LnVsop(5.3E-10, 4.77467577413, 6127.6554505572), new Vsop87.LnVsop(5.0E-10, 2.57807944338, 3340.5951730476), new Vsop87.LnVsop(4.9E-10, 3.72534850744, 9866.4168806652), new Vsop87.LnVsop(5.0E-10, 4.60885064189, 3340.629680352), new Vsop87.LnVsop(4.2E-10, 6.14743017903, 7234.794256242), new Vsop87.LnVsop(4.2E-10, 3.43563949713, 5486.777843175), new Vsop87.LnVsop(4.4E-10, 4.47908248027, 426.598190876), new Vsop87.LnVsop(4.0E-10, 0.79167327114, 7.1135470008), new Vsop87.LnVsop(4.5E-10, 6.24183361898, 2274.1169495098), new Vsop87.LnVsop(3.8E-10, 1.09272124839, 9623.6882766912), new Vsop87.LnVsop(4.2E-10, 4.60964038446, 6682.2051744678), new Vsop87.LnVsop(3.8E-10, 6.18558685622, 5729.506447149), new Vsop87.LnVsop(3.8E-10, 4.61315601536, 7740.6067835888), new Vsop87.LnVsop(3.6E-10, 3.149965058, 639.897286314), new Vsop87.LnVsop(4.0E-10, 1.47221984696, 13365.9728251482), new Vsop87.LnVsop(3.4E-10, 2.44888174358, 2288.3440435114), new Vsop87.LnVsop(3.3E-10, 4.07561553526, 3532.0606928114), new Vsop87.LnVsop(3.3E-10, 4.00337366796, 191.4482661116), new Vsop87.LnVsop(3.4E-10, 2.61360044785, 4690.4798363586), new Vsop87.LnVsop(4.2E-10, 2.12093492483, 12832.7587417046), new Vsop87.LnVsop(3.2E-10, 4.50887364887, 7875.6718636242), new Vsop87.LnVsop(3.2E-10, 1.5745865437, 10419.9862835076), new Vsop87.LnVsop(4.2E-10, 4.64340929626, 15643.6802033098), new Vsop87.LnVsop(3.4E-10, 5.06656541832, 6681.2421070518), new Vsop87.LnVsop(3.6E-10, 0.28987292152, 3723.508958923), new Vsop87.LnVsop(3.3E-10, 4.52563219188, 4929.6853219836), new Vsop87.LnVsop(3.4E-10, 2.74382990905, 6677.7017350506), new Vsop87.LnVsop(2.9E-10, 4.82292532787, 6836.6452528338), new Vsop87.LnVsop(3.1E-10, 1.25306031255, 242.728603974), new Vsop87.LnVsop(4.0E-10, 1.33261257095, 5331.3574437408), new Vsop87.LnVsop(3.4E-10, 3.03578748114, 6681.2075997474), new Vsop87.LnVsop(2.8E-10, 5.44161669691, 10021.8545337516), new Vsop87.LnVsop(2.8E-10, 3.41041355991, 10021.8200264472), new Vsop87.LnVsop(2.9E-10, 1.44701292203, 26724.8994135984), new Vsop87.LnVsop(2.7E-10, 0.23446626513, 9830.3890139878), new Vsop87.LnVsop(3.1E-10, 3.55930404825, 8969.568896911), new Vsop87.LnVsop(2.7E-10, 0.62554177429, 6681.2921637024), new Vsop87.LnVsop(2.8E-10, 0.66108605606, 6283.0758499914), new Vsop87.LnVsop(2.6E-10, 2.93963456706, 2544.3144198834), new Vsop87.LnVsop(2.8E-10, 3.02947324104, 2281.2304965106), new Vsop87.LnVsop(2.6E-10, 0.06758130889, 10818.1352869158), new Vsop87.LnVsop(3.3E-10, 5.38463358374, 553.5694028424), new Vsop87.LnVsop(2.6E-10, 1.18522107539, 8955.3418029094), new Vsop87.LnVsop(3.0E-10, 5.72396134501, 3339.6321056316), new Vsop87.LnVsop(3.2E-10, 2.01050754787, 5884.9268465832), new Vsop87.LnVsop(2.7E-10, 3.74433763737, 6298.3283211764), new Vsop87.LnVsop(2.6E-10, 1.03437538808, 6681.1575430968), new Vsop87.LnVsop(2.4E-10, 0.07873299732, 382.8965322232), new Vsop87.LnVsop(2.7E-10, 0.62459992026, 3553.9115221378), new Vsop87.LnVsop(2.4E-10, 3.46652790647, 8031.0922630584), new Vsop87.LnVsop(2.7E-10, 4.97242136909, 3767.2106175758), new Vsop87.LnVsop(2.1E-10, 0.34500515713, 398.1490034082), new Vsop87.LnVsop(2.2E-10, 0.16000431895, 6674.1113063988), new Vsop87.LnVsop(2.5E-10, 4.80981908946, 7632.9432596502), new Vsop87.LnVsop(2.0E-10, 1.03308861369, 7210.9158184942), new Vsop87.LnVsop(1.9E-10, 1.00795666182, 7064.1213856228), new Vsop87.LnVsop(2.0E-10, 5.08085454093, 6688.3384004004), new Vsop87.LnVsop(2.4E-10, 4.53131373076, 1748.016413067), new Vsop87.LnVsop(2.1E-10, 1.0006776287, 6894.5239488376), new Vsop87.LnVsop(2.1E-10, 2.68399619671, 10018.3141617504), new Vsop87.LnVsop(1.8E-10, 0.24311256346, 3981.490034082), new Vsop87.LnVsop(2.3E-10, 3.25718834734, 5621.8429232104), new Vsop87.LnVsop(1.8E-10, 5.22850479583, 3333.498879699), new Vsop87.LnVsop(1.7E-10, 0.65399461894, 3340.545116397), new Vsop87.LnVsop(1.6E-10, 2.23166601637, 10264.5658840734), new Vsop87.LnVsop(1.6E-10, 3.99319122882, 951.7184062506), new Vsop87.LnVsop(1.7E-10, 0.24322966235, 3340.6797370026), new Vsop87.LnVsop(1.5E-10, 0.68756621158, 2699.7348193176), new Vsop87.LnVsop(1.5E-10, 0.79676193982, 6438.4962494256), new Vsop87.LnVsop(1.9E-10, 3.09984967041, 8273.8208670324), new Vsop87.LnVsop(1.8E-10, 5.49826928276, 2146.1654164752), new Vsop87.LnVsop(1.4E-10, 4.64772091449, 2118.7638603784), new Vsop87.LnVsop(1.5E-10, 2.35470306373, 5092.1519581158), new Vsop87.LnVsop(1.4E-10, 4.97209858575, 11081.2192102886), new Vsop87.LnVsop(1.7E-10, 0.37871098191, 10575.4066829418), new Vsop87.LnVsop(1.4E-10, 0.53224061765, 1066.49547719), new Vsop87.LnVsop(1.4E-10, 1.08680225227, 6040.3472460174), new Vsop87.LnVsop(1.5E-10, 4.55907710983, 8270.2977486834), new Vsop87.LnVsop(1.6E-10, 5.13375747116, 9468.267877257), new Vsop87.LnVsop(1.3E-10, 0.53705768941, 5088.6288397668), new Vsop87.LnVsop(1.3E-10, 0.11088343011, 213.299095438), new Vsop87.LnVsop(1.3E-10, 1.73016080294, 8671.9698704406), new Vsop87.LnVsop(1.2E-10, 3.99880295457, 13207.029307365), new Vsop87.LnVsop(1.2E-10, 4.09699657905, 6041.3275670856), new Vsop87.LnVsop(1.3E-10, 5.6322599386, 3178.1457905676), new Vsop87.LnVsop(1.1E-10, 3.61924209254, 11773.3768115154), new Vsop87.LnVsop(1.3E-10, 4.97777304006, 10022.8176011676), new Vsop87.LnVsop(1.1E-10, 2.29245339567, 2914.0142358238), new Vsop87.LnVsop(1.1E-10, 0.1799469706, 9070.1188738488), new Vsop87.LnVsop(1.2E-10, 5.15200495439, 10973.55568635), new Vsop87.LnVsop(1.4E-10, 6.05434498977, 640.8776073822), new Vsop87.LnVsop(1.1E-10, 1.7577939746, 4562.4609930212), new Vsop87.LnVsop(1.2E-10, 1.46467398653, 12964.300703391), new Vsop87.LnVsop(1.0E-10, 3.56966848964, 15113.9892382152), new Vsop87.LnVsop(9.0E-11, 4.80839551981, 3325.3599555148), new Vsop87.LnVsop(1.0E-10, 1.23311080707, 3360.96774609859), new Vsop87.LnVsop(9.0E-11, 1.93544907019, 13760.5987102074), new Vsop87.LnVsop(1.0E-10, 0.49076916855, 2810.9214616052), new Vsop87.LnVsop(1.0E-10, 2.49016534434, 16173.3711684044), new Vsop87.LnVsop(9.0E-11, 3.62373278148, 5614.7293762096), new Vsop87.LnVsop(9.0E-11, 2.29700488106, 8429.2412664666), new Vsop87.LnVsop(9.0E-11, 2.52785501283, 3427.9206312396), new Vsop87.LnVsop(9.0E-11, 5.57605456632, 3355.8648978848), new Vsop87.LnVsop(8.0E-11, 3.38386554244, 8827.3902698748), new Vsop87.LnVsop(8.0E-11, 1.67431441943, 16706.585251848), new Vsop87.LnVsop(8.0E-11, 3.62389227844, 12310.1813236108), new Vsop87.LnVsop(8.0E-11, 2.25791643317, 151.8972810852), new Vsop87.LnVsop(8.0E-11, 3.0802949894, 6254.6266625236), new Vsop87.LnVsop(1.0E-10, 2.86769411066, 3320.257107301), new Vsop87.LnVsop(8.0E-11, 3.03420706487, 1751.539531416), new Vsop87.LnVsop(7.0E-11, 0.11237624686, 3127.3133312618), new Vsop87.LnVsop(9.0E-11, 4.92065236724, 11216.284290324), new Vsop87.LnVsop(7.0E-11, 3.67458682256, 3980.5097130138)};
        static Vsop87.LnVsop[] mars_radius_r4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.9551E-7, 3.58210746512, 3340.6124266998), new Vsop87.LnVsop(1.6322E-7, 4.05115851142, 6681.2248533996), new Vsop87.LnVsop(5.848E-8, 4.4638164658, 10021.8372800994), new Vsop87.LnVsop(1.533E-8, 4.84332951095, 13362.4497067992), new Vsop87.LnVsop(3.75E-9, 1.50951652931, 3185.1920272656), new Vsop87.LnVsop(3.4E-9, 5.20519444932, 16703.062133499), new Vsop87.LnVsop(1.52E-9, 5.1637614117, 3344.1355450488), new Vsop87.LnVsop(1.26E-9, 2.19183723061, 3496.032826134), new Vsop87.LnVsop(1.48E-9, 0.0, 0.0), new Vsop87.LnVsop(8.8E-10, 0.10430359862, 3583.3410306738), new Vsop87.LnVsop(7.1E-10, 5.5606098087, 20043.6745601988), new Vsop87.LnVsop(5.0E-10, 5.56346631885, 6684.7479717486), new Vsop87.LnVsop(4.8E-10, 2.91926298132, 2787.0430238574), new Vsop87.LnVsop(5.7E-10, 1.86870004051, 6525.8044539654), new Vsop87.LnVsop(3.4E-10, 3.63370917313, 3097.88382272579), new Vsop87.LnVsop(2.1E-10, 2.30993179224, 1059.3819301892), new Vsop87.LnVsop(2.0E-10, 4.04278354592, 4136.9104335162), new Vsop87.LnVsop(1.8E-10, 4.1743875589, 3149.1641605882), new Vsop87.LnVsop(1.7E-10, 5.90833786763, 23384.2869868986), new Vsop87.LnVsop(1.4E-10, 1.98185426243, 155.4203994342), new Vsop87.LnVsop(1.3E-10, 4.43167860883, 7477.522860216), new Vsop87.LnVsop(1.7E-10, 5.93839376025, 10025.3603984484), new Vsop87.LnVsop(1.5E-10, 4.58867012625, 6489.776587288), new Vsop87.LnVsop(1.4E-10, 2.22119368504, 9866.4168806652), new Vsop87.LnVsop(1.3E-10, 3.24667481494, 6127.6554505572), new Vsop87.LnVsop(1.3E-10, 0.48623714297, 6923.9534573736), new Vsop87.LnVsop(1.2E-10, 5.44223670746, 3738.761430108), new Vsop87.LnVsop(1.6E-10, 2.67418088918, 4399.994356889), new Vsop87.LnVsop(1.4E-10, 0.78383138857, 3894.1818295422), new Vsop87.LnVsop(1.1E-10, 2.64507772215, 3341.592747768), new Vsop87.LnVsop(1.2E-10, 4.34268478367, 2388.8940204492), new Vsop87.LnVsop(1.2E-10, 2.52802901788, 6836.6452528338), new Vsop87.LnVsop(9.0E-11, 2.81895333303, 4292.3308329504), new Vsop87.LnVsop(1.2E-10, 5.83109172622, 7079.3738568078), new Vsop87.LnVsop(9.0E-11, 0.76993290644, 1592.5960136328), new Vsop87.LnVsop(8.0E-11, 3.56780948809, 796.2980068164), new Vsop87.LnVsop(8.0E-11, 2.59620253825, 4535.0594369244), new Vsop87.LnVsop(8.0E-11, 3.91827119997, 6438.4962494256), new Vsop87.LnVsop(9.0E-11, 2.21473599227, 1194.4470102246), new Vsop87.LnVsop(8.0E-11, 1.21128945285, 4690.4798363586), new Vsop87.LnVsop(7.0E-11, 3.08488687971, 2544.3144198834), new Vsop87.LnVsop(8.0E-11, 5.7238855439, 1990.745017041), new Vsop87.LnVsop(8.0E-11, 3.00192257768, 3532.0606928114), new Vsop87.LnVsop(8.0E-11, 4.44918099254, 3339.6321056316), new Vsop87.LnVsop(8.0E-11, 3.21999751217, 3347.7259737006), new Vsop87.LnVsop(7.0E-11, 1.16933312219, 4933.2084403326), new Vsop87.LnVsop(8.0E-11, 5.12244052839, 3723.508958923), new Vsop87.LnVsop(6.0E-11, 4.60069136817, 5729.506447149), new Vsop87.LnVsop(6.0E-11, 1.82718202907, 2957.7158944766), new Vsop87.LnVsop(6.0E-11, 3.00923601434, 6682.2051744678), new Vsop87.LnVsop(5.0E-11, 2.74887623421, 1589.0728952838), new Vsop87.LnVsop(5.0E-11, 2.01586492272, 5486.777843175), new Vsop87.LnVsop(5.0E-11, 6.17623487651, 13365.9728251482), new Vsop87.LnVsop(6.0E-11, 3.96856230146, 2146.1654164752), new Vsop87.LnVsop(5.0E-11, 2.80833888276, 3337.0893083508), new Vsop87.LnVsop(4.0E-11, 2.9272046294, 7875.6718636242), new Vsop87.LnVsop(4.0E-11, 4.02001405595, 3333.498879699)};
        static Vsop87.LnVsop[] mars_radius_r5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(4.75E-9, 2.47621038205, 6681.2248533996), new Vsop87.LnVsop(2.7E-9, 2.90961348988, 10021.8372800994), new Vsop87.LnVsop(1.16E-9, 1.76766655427, 3340.6124266998), new Vsop87.LnVsop(9.7E-10, 3.31315004582, 13362.4497067992), new Vsop87.LnVsop(4.9E-10, 6.28284800757, 3185.1920272656), new Vsop87.LnVsop(2.7E-10, 3.69297278191, 16703.062133499), new Vsop87.LnVsop(1.3E-10, 3.67011956659, 3496.032826134), new Vsop87.LnVsop(1.2E-10, 4.88179002689, 3583.3410306738), new Vsop87.LnVsop(1.2E-10, 3.14159265359, 0.0), new Vsop87.LnVsop(9.0E-11, 4.05335755845, 20043.6745601988), new Vsop87.LnVsop(9.0E-11, 0.35575801457, 6525.8044539654), new Vsop87.LnVsop(6.0E-11, 3.95186839136, 6684.7479717486), new Vsop87.LnVsop(5.0E-11, 1.40424074649, 2787.0430238574), new Vsop87.LnVsop(5.0E-11, 3.60327227648, 3344.1355450488), new Vsop87.LnVsop(4.0E-11, 5.11981331029, 3097.88382272579), new Vsop87.LnVsop(4.0E-11, 5.2460306859, 6923.9534573736), new Vsop87.LnVsop(2.0E-11, 0.40954426011, 9866.4168806652)};

        Radius() {
        }
    }

    static class Latitude {
        static Vsop87.LnVsop[] mars_latitude_b0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.03197134986, 3.76832042431, 3340.6124266998), new Vsop87.LnVsop(0.00298033234, 4.10616996305, 6681.2248533996), new Vsop87.LnVsop(0.00289104742, 0.0, 0.0), new Vsop87.LnVsop(3.1365539E-4, 4.4465105309, 10021.8372800994), new Vsop87.LnVsop(3.4841E-5, 4.7881254926, 13362.4497067992), new Vsop87.LnVsop(4.42999E-6, 5.65233014206, 3337.0893083508), new Vsop87.LnVsop(4.43401E-6, 5.02642622964, 3344.1355450488), new Vsop87.LnVsop(3.99109E-6, 5.13056816928, 16703.062133499), new Vsop87.LnVsop(2.92506E-6, 3.79290674178, 2281.2304965106), new Vsop87.LnVsop(1.81982E-6, 6.13648041445, 6151.533888305), new Vsop87.LnVsop(1.63159E-6, 4.26399640691, 529.6909650946), new Vsop87.LnVsop(1.59678E-6, 2.23194572851, 1059.3819301892), new Vsop87.LnVsop(1.39323E-6, 2.41796458896, 8962.4553499102), new Vsop87.LnVsop(1.49297E-6, 2.16501221175, 5621.8429232104), new Vsop87.LnVsop(1.42686E-6, 1.18215016908, 3340.5951730476), new Vsop87.LnVsop(1.42685E-6, 3.21292181638, 3340.629680352), new Vsop87.LnVsop(8.2544E-7, 5.36667920373, 6684.7479717486), new Vsop87.LnVsop(7.3639E-7, 5.0918769577, 398.1490034082), new Vsop87.LnVsop(7.266E-7, 5.53775735826, 6283.0758499914), new Vsop87.LnVsop(8.6377E-7, 5.74429749104, 3738.761430108), new Vsop87.LnVsop(8.3276E-7, 5.98866355811, 6677.7017350506), new Vsop87.LnVsop(6.0116E-7, 3.67960801961, 796.2980068164), new Vsop87.LnVsop(6.3111E-7, 0.73049101791, 5884.9268465832), new Vsop87.LnVsop(6.2338E-7, 4.8507212869, 2942.4634232916), new Vsop87.LnVsop(4.6951E-7, 5.54339769619, 3340.545116397), new Vsop87.LnVsop(4.6953E-7, 5.13486674212, 3340.6797370026), new Vsop87.LnVsop(4.663E-7, 5.47361589877, 20043.6745601988), new Vsop87.LnVsop(4.5588E-7, 2.1326234084, 2810.9214616052), new Vsop87.LnVsop(4.1269E-7, 0.20003146001, 9492.1463150048), new Vsop87.LnVsop(4.7199E-7, 4.52184637077, 3149.1641605882), new Vsop87.LnVsop(3.854E-7, 4.08008471951, 4136.9104335162), new Vsop87.LnVsop(3.3069E-7, 4.06582536024, 1751.539531416), new Vsop87.LnVsop(2.9694E-7, 5.92218475216, 3532.0606928114), new Vsop87.LnVsop(3.2736E-7, 2.62070842911, 2914.0142358238), new Vsop87.LnVsop(2.9521E-7, 2.75342613814, 12303.06777661), new Vsop87.LnVsop(2.8169E-7, 2.06282641876, 5486.777843175), new Vsop87.LnVsop(2.8618E-7, 4.94710659219, 3870.3033917944), new Vsop87.LnVsop(2.6603E-7, 3.55085867185, 6681.2421070518), new Vsop87.LnVsop(2.6603E-7, 1.52008697887, 6681.2075997474), new Vsop87.LnVsop(2.3336E-7, 2.27624326713, 1589.0728952838), new Vsop87.LnVsop(2.6052E-7, 2.60064406111, 4399.994356889), new Vsop87.LnVsop(2.2637E-7, 2.27507286962, 1194.4470102246), new Vsop87.LnVsop(1.8887E-7, 6.04416592185, 7079.3738568078), new Vsop87.LnVsop(1.4846E-7, 3.41358397277, 5088.6288397668), new Vsop87.LnVsop(1.9947E-7, 2.6736490118, 8432.7643848156), new Vsop87.LnVsop(1.4682E-7, 5.89211770913, 9623.6882766912), new Vsop87.LnVsop(1.4152E-7, 2.42511982523, 3333.498879699), new Vsop87.LnVsop(1.331E-7, 2.62839885122, 426.598190876), new Vsop87.LnVsop(1.4008E-7, 1.67425471692, 6254.6266625236), new Vsop87.LnVsop(1.5104E-7, 2.81013512447, 3496.032826134), new Vsop87.LnVsop(1.3011E-7, 5.70759990125, 10025.3603984484), new Vsop87.LnVsop(1.208E-7, 1.51805176385, 3185.1920272656), new Vsop87.LnVsop(1.3183E-7, 0.04521300408, 10018.3141617504), new Vsop87.LnVsop(1.1553E-7, 5.5741919554, 191.4482661116), new Vsop87.LnVsop(1.1196E-7, 0.55829476182, 5092.1519581158), new Vsop87.LnVsop(1.153E-7, 2.13314729185, 11773.3768115154), new Vsop87.LnVsop(1.0435E-7, 5.72413969529, 6467.9257579616), new Vsop87.LnVsop(9.846E-8, 0.86942034707, 1592.5960136328), new Vsop87.LnVsop(9.761E-8, 1.0934331993, 2544.3144198834), new Vsop87.LnVsop(8.754E-8, 5.47281526854, 6681.2921637024), new Vsop87.LnVsop(8.937E-8, 4.83790383087, 6489.776587288), new Vsop87.LnVsop(8.652E-8, 4.72119070324, 213.299095438), new Vsop87.LnVsop(8.797E-8, 2.86598300684, 3341.592747768), new Vsop87.LnVsop(8.384E-8, 2.65895188994, 4535.0594369244), new Vsop87.LnVsop(8.213E-8, 4.8260847138, 3553.9115221378), new Vsop87.LnVsop(8.799E-8, 1.52911067895, 3339.6321056316), new Vsop87.LnVsop(8.103E-8, 1.0099422368, 9225.539273283), new Vsop87.LnVsop(8.754E-8, 5.88131156904, 6681.1575430968), new Vsop87.LnVsop(7.209E-8, 4.41679451115, 7477.522860216), new Vsop87.LnVsop(8.559E-8, 4.79005521282, 4690.4798363586), new Vsop87.LnVsop(6.087E-8, 1.89070780881, 9595.2390892234), new Vsop87.LnVsop(6.974E-8, 0.53247180771, 12832.7587417046), new Vsop87.LnVsop(5.584E-8, 6.18908858151, 4292.3308329504), new Vsop87.LnVsop(5.038E-8, 6.06394187474, 7210.9158184942), new Vsop87.LnVsop(5.127E-8, 0.11856223993, 4562.4609930212), new Vsop87.LnVsop(4.863E-8, 1.33050477323, 3894.1818295422), new Vsop87.LnVsop(5.592E-8, 3.97792233579, 3127.3133312618), new Vsop87.LnVsop(4.965E-8, 5.74590187611, 1990.745017041), new Vsop87.LnVsop(5.531E-8, 5.81704574177, 23384.2869868986), new Vsop87.LnVsop(4.184E-8, 3.88899448118, 10021.8545337516), new Vsop87.LnVsop(4.184E-8, 1.8582188675, 10021.8200264472), new Vsop87.LnVsop(4.685E-8, 1.11750605341, 3319.8370312074), new Vsop87.LnVsop(3.954E-8, 2.65571428448, 4929.6853219836), new Vsop87.LnVsop(5.174E-8, 3.62345890346, 2700.7151403858), new Vsop87.LnVsop(4.639E-8, 6.14089828121, 7.1135470008), new Vsop87.LnVsop(4.686E-8, 3.2773203064, 3361.3878221922), new Vsop87.LnVsop(4.999E-8, 3.09122275925, 15643.6802033098), new Vsop87.LnVsop(3.919E-8, 2.96551660306, 7740.6067835888), new Vsop87.LnVsop(3.361E-8, 1.8501569173, 2957.7158944766), new Vsop87.LnVsop(4.247E-8, 4.19639326313, 2146.1654164752), new Vsop87.LnVsop(4.101E-8, 6.22534362774, 10213.285546211), new Vsop87.LnVsop(3.124E-8, 0.08537434136, 10419.9862835076), new Vsop87.LnVsop(3.079E-8, 2.41163576579, 3344.2028553516), new Vsop87.LnVsop(3.093E-8, 1.98041916263, 3337.021998048), new Vsop87.LnVsop(3.044E-8, 4.38894724131, 1221.8485663214), new Vsop87.LnVsop(2.879E-8, 2.93292958734, 2787.0430238574), new Vsop87.LnVsop(3.372E-8, 4.45558231622, 6674.1113063988), new Vsop87.LnVsop(2.51E-8, 4.06246201858, 6872.6731195112), new Vsop87.LnVsop(2.616E-8, 1.23659105217, 4933.2084403326), new Vsop87.LnVsop(3.011E-8, 4.33966319613, 2388.8940204492), new Vsop87.LnVsop(3.094E-8, 2.40386312988, 2118.7638603784), new Vsop87.LnVsop(2.516E-8, 2.30275461207, 3723.508958923), new Vsop87.LnVsop(2.192E-8, 1.68875393217, 639.897286314), new Vsop87.LnVsop(2.157E-8, 6.07606060132, 9808.5381846614), new Vsop87.LnVsop(2.686E-8, 2.38168997181, 15113.9892382152), new Vsop87.LnVsop(2.156E-8, 2.87768495226, 6041.3275670856), new Vsop87.LnVsop(2.495E-8, 3.87397844397, 7903.073419721), new Vsop87.LnVsop(2.253E-8, 0.47470647524, 3475.6775067352), new Vsop87.LnVsop(2.443E-8, 3.02632472426, 3767.2106175758), new Vsop87.LnVsop(1.937E-8, 0.3800093955, 13358.9265884502), new Vsop87.LnVsop(2.213E-8, 3.91980714687, 3205.5473466644), new Vsop87.LnVsop(2.386E-8, 6.2386673011, 12964.300703391), new Vsop87.LnVsop(1.806E-8, 2.38402930496, 11243.6858464208), new Vsop87.LnVsop(2.265E-8, 1.85773978984, 6525.8044539654), new Vsop87.LnVsop(1.642E-8, 1.8681281992, 6680.2445323314), new Vsop87.LnVsop(1.616E-8, 3.39939680231, 8429.2412664666), new Vsop87.LnVsop(1.646E-8, 0.73259423152, 2274.1169495098), new Vsop87.LnVsop(1.91E-8, 6.04319826335, 13365.9728251482), new Vsop87.LnVsop(1.493E-8, 2.9936244474, 7875.6718636242), new Vsop87.LnVsop(1.567E-8, 1.76858041654, 382.8965322232), new Vsop87.LnVsop(1.46E-8, 1.4056977273, 14584.2982731206), new Vsop87.LnVsop(1.527E-8, 5.79343223934, 6894.5239488376), new Vsop87.LnVsop(1.41E-8, 5.17096392928, 9830.3890139878), new Vsop87.LnVsop(1.665E-8, 3.60179345882, 2288.3440435114), new Vsop87.LnVsop(1.616E-8, 2.19443242366, 8827.3902698748), new Vsop87.LnVsop(1.746E-8, 0.10485638099, 3583.3410306738), new Vsop87.LnVsop(1.637E-8, 3.20413465522, 6682.2051744678), new Vsop87.LnVsop(1.269E-8, 2.02253887032, 155.4203994342), new Vsop87.LnVsop(1.508E-8, 5.80804000686, 1748.016413067), new Vsop87.LnVsop(1.296E-8, 2.92894055497, 9381.9399937854), new Vsop87.LnVsop(1.291E-8, 2.98932388263, 6836.6452528338), new Vsop87.LnVsop(1.357E-8, 0.32863385589, 4032.7700279266), new Vsop87.LnVsop(1.377E-8, 5.80980822627, 10021.9045904022), new Vsop87.LnVsop(1.377E-8, 6.21830452626, 10021.7699697966), new Vsop87.LnVsop(1.227E-8, 2.204210578, 12935.8515159232), new Vsop87.LnVsop(1.08E-8, 4.75504944444, 10818.1352869158), new Vsop87.LnVsop(1.016E-8, 1.33950070697, 12566.1516999828), new Vsop87.LnVsop(1.083E-8, 0.8762009687, 16173.3711684044), new Vsop87.LnVsop(9.58E-9, 5.29506217215, 1066.49547719), new Vsop87.LnVsop(1.035E-8, 2.44289154523, 1052.2683831884), new Vsop87.LnVsop(1.153E-8, 4.73776302778, 8031.0922630584), new Vsop87.LnVsop(1.042E-8, 1.7354190204, 3369.0616141676), new Vsop87.LnVsop(8.99E-9, 1.87266868844, 3077.528503327), new Vsop87.LnVsop(8.92E-9, 2.51349496317, 3603.6963500726), new Vsop87.LnVsop(9.05E-9, 0.27366092731, 3325.3599555148), new Vsop87.LnVsop(8.83E-9, 5.46536272796, 5614.7293762096), new Vsop87.LnVsop(9.49E-9, 0.045957466, 7064.1213856228), new Vsop87.LnVsop(8.72E-9, 3.61194636597, 6702.000248892), new Vsop87.LnVsop(8.42E-9, 5.61715087411, 8955.3418029094), new Vsop87.LnVsop(8.43E-9, 0.57535652957, 3191.0492295652), new Vsop87.LnVsop(9.04E-9, 4.11836615587, 3355.8648978848), new Vsop87.LnVsop(1.044E-8, 2.65886181159, 3312.163239232), new Vsop87.LnVsop(8.07E-9, 2.26443699939, 8969.568896911), new Vsop87.LnVsop(1.047E-8, 6.11318138367, 5331.3574437408), new Vsop87.LnVsop(9.33E-9, 0.8255751336, 3503.079062832), new Vsop87.LnVsop(9.46E-9, 1.92369895048, 5628.9564702112), new Vsop87.LnVsop(9.79E-9, 4.55692896386, 3097.88382272579), new Vsop87.LnVsop(8.46E-9, 4.65092182656, 6438.4962494256), new Vsop87.LnVsop(9.01E-9, 1.46779952141, 6660.4494579072), new Vsop87.LnVsop(7.38E-9, 4.9771458603, 10014.7237330986), new Vsop87.LnVsop(7.62E-9, 3.42578095887, 18984.2926300096), new Vsop87.LnVsop(9.34E-9, 0.35012375677, 3264.3463554242), new Vsop87.LnVsop(8.94E-9, 0.3499227946, 10551.528245194), new Vsop87.LnVsop(6.65E-9, 6.05549298647, 7632.9432596502), new Vsop87.LnVsop(6.05E-9, 4.68477765315, 5729.506447149), new Vsop87.LnVsop(5.93E-9, 2.97202650027, 3178.1457905676), new Vsop87.LnVsop(6.17E-9, 2.19525025122, 13362.432453147), new Vsop87.LnVsop(5.79E-9, 3.32297295321, 11081.2192102886), new Vsop87.LnVsop(5.79E-9, 2.31207212499, 6677.6344247478), new Vsop87.LnVsop(5.85E-9, 4.51639269767, 1648.4467571974), new Vsop87.LnVsop(5.72E-9, 4.27986611626, 6546.1597733642), new Vsop87.LnVsop(6.26E-9, 4.60732704004, 2487.4160449478), new Vsop87.LnVsop(6.49E-9, 2.17890116209, 6298.3283211764), new Vsop87.LnVsop(6.17E-9, 4.22631246059, 13362.4669604514), new Vsop87.LnVsop(5.5E-9, 3.11154437229, 6144.4203413042), new Vsop87.LnVsop(5.51E-9, 3.27082309354, 6127.6554505572), new Vsop87.LnVsop(5.36E-9, 0.18974410122, 3346.1353510072), new Vsop87.LnVsop(5.57E-9, 6.13684755137, 26724.8994135984), new Vsop87.LnVsop(5.71E-9, 5.65326695555, 2921.1277828246), new Vsop87.LnVsop(5.52E-9, 5.75733423477, 149.5631971346), new Vsop87.LnVsop(6.38E-9, 4.49650387971, 3.523118349), new Vsop87.LnVsop(5.52E-9, 1.07796467941, 536.8045120954), new Vsop87.LnVsop(5.37E-9, 4.19208253387, 3335.0895023924), new Vsop87.LnVsop(5.67E-9, 2.62819919565, 2648.454825473), new Vsop87.LnVsop(6.42E-9, 3.24529035363, 3347.7259737006), new Vsop87.LnVsop(5.46E-9, 2.76742592341, 5459.3762870782), new Vsop87.LnVsop(5.56E-9, 4.98614620994, 6531.661656265), new Vsop87.LnVsop(5.77E-9, 2.74434323174, 6684.8152820514), new Vsop87.LnVsop(6.13E-9, 3.01716269698, 8270.2977486834), new Vsop87.LnVsop(5.58E-9, 5.89252214546, 6158.6474353058), new Vsop87.LnVsop(4.9E-9, 4.59097788726, 522.5774180938), new Vsop87.LnVsop(4.45E-9, 3.64218817161, 10713.9948813262), new Vsop87.LnVsop(5.39E-9, 0.59290478457, 553.5694028424), new Vsop87.LnVsop(4.34E-9, 1.99641894213, 26087.9031415742), new Vsop87.LnVsop(4.59E-9, 4.84219649882, 1758.6530784168), new Vsop87.LnVsop(4.23E-9, 3.77854426573, 6688.3384004004), new Vsop87.LnVsop(4.21E-9, 3.10278288287, 8329.671610597), new Vsop87.LnVsop(4.21E-9, 4.43525950372, 103.0927742186), new Vsop87.LnVsop(5.02E-9, 3.03141260243, 3360.96774609859), new Vsop87.LnVsop(4.22E-9, 5.99160108582, 242.728603974), new Vsop87.LnVsop(4.01E-9, 2.06009473972, 3980.5097130138), new Vsop87.LnVsop(4.1E-9, 5.85255892892, 3351.2490920496), new Vsop87.LnVsop(3.75E-9, 2.50807799168, 6784.3176276182), new Vsop87.LnVsop(4.07E-9, 0.30120685897, 16304.9131300908), new Vsop87.LnVsop(5.07E-9, 1.3501594205, 3320.257107301), new Vsop87.LnVsop(3.85E-9, 1.06261944181, 7234.794256242), new Vsop87.LnVsop(5.19E-9, 4.61721845726, 7373.3824546264), new Vsop87.LnVsop(4.01E-9, 0.511677658, 17085.9586657222), new Vsop87.LnVsop(3.71E-9, 0.4170041102, 13760.5987102074), new Vsop87.LnVsop(4.76E-9, 0.81140579083, 6816.289933435), new Vsop87.LnVsop(3.48E-9, 3.36504090075, 8439.8779318164), new Vsop87.LnVsop(3.66E-9, 6.05204080393, 3607.2194684216), new Vsop87.LnVsop(4.02E-9, 2.67373540504, 18454.601664915), new Vsop87.LnVsop(4.39E-9, 0.41120720711, 10404.7338123226), new Vsop87.LnVsop(4.12E-9, 4.81050886146, 3329.97576135), new Vsop87.LnVsop(4.14E-9, 0.21020717323, 13149.1506113612), new Vsop87.LnVsop(3.63E-9, 2.19005207108, 9866.4168806652), new Vsop87.LnVsop(3.37E-9, 5.46408092858, 6604.958782124), new Vsop87.LnVsop(3.4E-9, 1.73403450629, 1692.1656695024), new Vsop87.LnVsop(3.44E-9, 3.58323138591, 7107.8230442756), new Vsop87.LnVsop(4.2E-9, 2.77274750272, 2906.900688823), new Vsop87.LnVsop(3.35E-9, 2.0233750434, 3333.5661900018), new Vsop87.LnVsop(3.36E-9, 2.78166289075, 4989.0591838972), new Vsop87.LnVsop(3.54E-9, 5.41259531, 951.7184062506), new Vsop87.LnVsop(3.28E-9, 0.43464679588, 6923.9534573736), new Vsop87.LnVsop(4.22E-9, 1.5760410919, 8273.8208670324), new Vsop87.LnVsop(3.24E-9, 4.99183805155, 11371.7046897582), new Vsop87.LnVsop(3.51E-9, 4.60780128099, 3074.005384978), new Vsop87.LnVsop(3.33E-9, 4.86995546846, 3863.1898447936), new Vsop87.LnVsop(3.19E-9, 1.44518621932, 11769.8536931664), new Vsop87.LnVsop(2.96E-9, 5.25657985927, 76.2660712756), new Vsop87.LnVsop(3.49E-9, 1.624753284, 17924.9106998204), new Vsop87.LnVsop(2.93E-9, 2.20644147241, 3347.6586633978), new Vsop87.LnVsop(3.15E-9, 4.55232705763, 5828.0284716476), new Vsop87.LnVsop(2.8E-9, 1.42130915383, 6606.4432548323), new Vsop87.LnVsop(3.36E-9, 1.56854446698, 1581.959348283), new Vsop87.LnVsop(3.43E-9, 0.27609995271, 10973.55568635), new Vsop87.LnVsop(2.71E-9, 0.08319244114, 10235.1363755374), new Vsop87.LnVsop(2.8E-9, 0.76456352671, 853.196381752), new Vsop87.LnVsop(3.17E-9, 4.91459113397, 3443.7052009184), new Vsop87.LnVsop(2.57E-9, 0.15729388867, 12168.0026965746), new Vsop87.LnVsop(2.37E-9, 3.13372111959, 74.7815985673), new Vsop87.LnVsop(2.71E-9, 1.83005081572, 3399.9862886134), new Vsop87.LnVsop(2.33E-9, 3.20168136662, 10177.2576795336), new Vsop87.LnVsop(3.12E-9, 0.28437379974, 13745.3462390224), new Vsop87.LnVsop(2.73E-9, 4.53535816659, 3344.4937620578), new Vsop87.LnVsop(2.35E-9, 0.68002127731, 17395.2197347258), new Vsop87.LnVsop(2.62E-9, 3.84495676575, 9168.6408983474), new Vsop87.LnVsop(2.71E-9, 4.94468984866, 692.1576012268), new Vsop87.LnVsop(2.54E-9, 2.1949097852, 3281.2385647862), new Vsop87.LnVsop(2.2E-9, 1.65407354495, 3546.797975137), new Vsop87.LnVsop(2.83E-9, 5.57869836989, 3973.396166013), new Vsop87.LnVsop(2.29E-9, 5.93154303656, 3364.4908644476), new Vsop87.LnVsop(2.23E-9, 4.82754649914, 9779.1086761254), new Vsop87.LnVsop(2.22E-9, 0.71802343753, 16699.53901514999), new Vsop87.LnVsop(2.18E-9, 0.09851087609, 16706.585251848), new Vsop87.LnVsop(2.21E-9, 1.66603088558, 10575.4066829418), new Vsop87.LnVsop(2.59E-9, 1.10209197887, 1744.4259844152), new Vsop87.LnVsop(2.43E-9, 1.52418741589, 14054.607308026), new Vsop87.LnVsop(2.73E-9, 6.12933991688, 3336.7310913418), new Vsop87.LnVsop(2.32E-9, 4.73422207994, 3316.733988952), new Vsop87.LnVsop(2.1E-9, 5.9725857815, 419.4846438752), new Vsop87.LnVsop(2.13E-9, 5.35378103304, 1596.1864422846), new Vsop87.LnVsop(1.97E-9, 3.32402522148, 5085.038411115), new Vsop87.LnVsop(1.93E-9, 0.90510860475, 14314.1681130498), new Vsop87.LnVsop(1.92E-9, 2.63243342994, 433.7117378768), new Vsop87.LnVsop(1.88E-9, 1.14982896161, 13892.1406718938), new Vsop87.LnVsop(2.01E-9, 4.79531031801, 6261.7402095244), new Vsop87.LnVsop(2.05E-9, 2.32320320233, 13916.0191096416), new Vsop87.LnVsop(1.91E-9, 5.08395985443, 2178.137722292), new Vsop87.LnVsop(1.91E-9, 5.88821293073, 3340.19235060619), new Vsop87.LnVsop(2.36E-9, 0.97334443524, 3230.4061054804), new Vsop87.LnVsop(2.0E-9, 3.60041329895, 3304.5845600224), new Vsop87.LnVsop(1.65E-9, 2.91702596948, 3415.3940252671), new Vsop87.LnVsop(1.91E-9, 4.7764733812, 3341.0325027934), new Vsop87.LnVsop(1.74E-9, 2.20553353979, 10020.8569590312), new Vsop87.LnVsop(1.61E-9, 2.64795288862, 3304.0070613956), new Vsop87.LnVsop(1.73E-9, 3.54115283211, 10022.8176011676), new Vsop87.LnVsop(1.54E-9, 2.45901648246, 12722.5524204852), new Vsop87.LnVsop(1.6E-9, 1.73968020025, 3377.217792004), new Vsop87.LnVsop(1.96E-9, 0.78013533938, 3376.6402933772), new Vsop87.LnVsop(1.53E-9, 0.27339012265, 13362.3823964964), new Vsop87.LnVsop(1.9E-9, 2.65194874683, 3657.0042963564), new Vsop87.LnVsop(1.72E-9, 5.71074315284, 2384.3232707292), new Vsop87.LnVsop(1.57E-9, 1.00235627417, 3209.0704650134), new Vsop87.LnVsop(1.5E-9, 3.39592858899, 3472.1543883862), new Vsop87.LnVsop(1.65E-9, 5.86531022351, 2803.8079146044), new Vsop87.LnVsop(1.54E-9, 0.32136196843, 6665.9723822146), new Vsop87.LnVsop(1.78E-9, 3.34070883939, 11216.284290324), new Vsop87.LnVsop(1.92E-9, 0.66075807383, 3134.4268782626), new Vsop87.LnVsop(1.61E-9, 2.87906798526, 4392.8808098882), new Vsop87.LnVsop(1.59E-9, 3.7225242267, 13517.8701062334), new Vsop87.LnVsop(1.68E-9, 0.55763311382, 110.2063212194), new Vsop87.LnVsop(1.58E-9, 5.67249624538, 4407.1079038898), new Vsop87.LnVsop(1.61E-9, 1.76807930062, 6709.6740408674), new Vsop87.LnVsop(1.58E-9, 5.50648633058, 13171.0014406876), new Vsop87.LnVsop(1.29E-9, 1.21294002381, 19513.9835951042), new Vsop87.LnVsop(1.73E-9, 0.17007903906, 3024.2205570432), new Vsop87.LnVsop(1.32E-9, 4.254244356, 16858.4825329332), new Vsop87.LnVsop(1.25E-9, 2.88541822571, 17256.6315363414), new Vsop87.LnVsop(1.24E-9, 2.59793302191, 12310.1813236108), new Vsop87.LnVsop(1.7E-9, 4.06010395706, 2818.035008606), new Vsop87.LnVsop(1.42E-9, 3.02798835989, 3511.285297319), new Vsop87.LnVsop(1.21E-9, 5.24069969205, 9872.2740829648), new Vsop87.LnVsop(1.65E-9, 2.5317654076, 16276.463942623), new Vsop87.LnVsop(1.53E-9, 6.14807907741, 13362.517017102), new Vsop87.LnVsop(1.19E-9, 4.15693538268, 3760.097070575), new Vsop87.LnVsop(1.2E-9, 0.64325982889, 4459.3682188026), new Vsop87.LnVsop(1.3E-9, 4.94981293749, 13553.8979729108), new Vsop87.LnVsop(1.2E-9, 0.17129908454, 8671.9698704406), new Vsop87.LnVsop(1.12E-9, 0.16839834843, 135.0650800354), new Vsop87.LnVsop(1.37E-9, 3.34809361979, 3341.0423098265), new Vsop87.LnVsop(1.26E-9, 1.32248977876, 1349.8674096588), new Vsop87.LnVsop(1.11E-9, 3.14219193941, 13524.9163429314), new Vsop87.LnVsop(1.19E-9, 5.95363422696, 12295.9542296092), new Vsop87.LnVsop(1.31E-9, 5.09769592268, 14158.7477136156), new Vsop87.LnVsop(1.41E-9, 1.37128440708, 3169.9395560806), new Vsop87.LnVsop(1.12E-9, 3.35851628879, 5989.0672521728), new Vsop87.LnVsop(1.04E-9, 5.00797771373, 13119.72110282519), new Vsop87.LnVsop(1.1E-9, 5.2338905926, 1375.7737998458), new Vsop87.LnVsop(1.05E-9, 2.72700704697, 1162.4747044078), new Vsop87.LnVsop(1.04E-9, 1.73770183724, 2221.856634597), new Vsop87.LnVsop(1.37E-9, 1.0457695039, 3340.1825435731), new Vsop87.LnVsop(1.06E-9, 6.13491390193, 162.4666361322), new Vsop87.LnVsop(1.19E-9, 2.63313118842, 7321.1221397136), new Vsop87.LnVsop(1.05E-9, 3.09659915297, 20618.0193585336), new Vsop87.LnVsop(1.08E-9, 1.0185456027, 3265.8308281325), new Vsop87.LnVsop(9.8E-10, 4.23346395354, 23539.7073863328), new Vsop87.LnVsop(1.19E-9, 4.07130782746, 10184.3039162316), new Vsop87.LnVsop(9.6E-10, 1.81114730032, 10001.061884607), new Vsop87.LnVsop(9.3E-10, 3.58891064965, 5099.2655051166), new Vsop87.LnVsop(9.5E-10, 4.94769174828, 3981.490034082), new Vsop87.LnVsop(9.4E-10, 5.37501534644, 13355.3361597984), new Vsop87.LnVsop(1.03E-9, 0.43484814704, 1861.7458526354), new Vsop87.LnVsop(9.4E-10, 0.13428933842, 15508.6151232744), new Vsop87.LnVsop(9.0E-10, 3.7639904982, 22324.9050567094), new Vsop87.LnVsop(9.1E-10, 3.9503665826, 10042.6126755918), new Vsop87.LnVsop(1.06E-9, 4.30211754376, 640.8776073822), new Vsop87.LnVsop(1.09E-9, 6.18873803073, 1478.8665740644), new Vsop87.LnVsop(8.8E-10, 1.79608901341, 6247.5131155228), new Vsop87.LnVsop(1.02E-9, 5.58780810365, 2766.267628365), new Vsop87.LnVsop(1.1E-9, 0.94707767481, 3274.1250177854), new Vsop87.LnVsop(8.4E-10, 4.45487801852, 6696.4773245846), new Vsop87.LnVsop(8.5E-10, 2.74791518135, 3407.0998356142), new Vsop87.LnVsop(8.7E-10, 4.51187502918, 220.4126424388), new Vsop87.LnVsop(1.01E-9, 5.94873233824, 8425.6508378148), new Vsop87.LnVsop(8.2E-10, 0.01853826918, 9499.2598620056), new Vsop87.LnVsop(8.0E-10, 0.42610497232, 18052.9295431578), new Vsop87.LnVsop(8.3E-10, 2.96589752222, 6652.7756659318), new Vsop87.LnVsop(8.0E-10, 4.61484797156, 3914.9572250346), new Vsop87.LnVsop(8.9E-10, 3.53078320469, 9485.032768004), new Vsop87.LnVsop(7.9E-10, 1.50228054154, 2111.6503133776), new Vsop87.LnVsop(8.6E-10, 0.42024324898, 956.2891559706), new Vsop87.LnVsop(8.8E-10, 5.46048231018, 16460.33352952499), new Vsop87.LnVsop(9.1E-10, 2.09965252231, 949.1756089698), new Vsop87.LnVsop(1.04E-9, 1.72206104768, 3296.8935143948), new Vsop87.LnVsop(1.03E-9, 1.25691413032, 3384.3313390048), new Vsop87.LnVsop(8.4E-10, 5.78633258361, 5518.7501489918), new Vsop87.LnVsop(7.9E-10, 1.79312483182, 38.1330356378), new Vsop87.LnVsop(7.3E-10, 0.10771411146, 29822.7832363242), new Vsop87.LnVsop(8.7E-10, 2.11653872859, 3450.8187479192), new Vsop87.LnVsop(7.1E-10, 3.89470981165, 9380.9596727172), new Vsop87.LnVsop(7.5E-10, 2.59391377956, 1964.838626854), new Vsop87.LnVsop(9.8E-10, 4.0150080588, 6843.6914895318), new Vsop87.LnVsop(7.9E-10, 2.20331656568, 30220.9322397324), new Vsop87.LnVsop(7.4E-10, 5.32028984035, 11766.2632645146), new Vsop87.LnVsop(6.8E-10, 0.04696396376, 2125.8774073792), new Vsop87.LnVsop(6.9E-10, 6.07535832352, 26482.1708096244), new Vsop87.LnVsop(8.4E-10, 0.16860055001, 263.0839233728), new Vsop87.LnVsop(6.9E-10, 2.05050096393, 29424.634232916), new Vsop87.LnVsop(6.8E-10, 5.03020376497, 9070.1188738488), new Vsop87.LnVsop(7.6E-10, 2.00296092459, 224.3447957019), new Vsop87.LnVsop(6.6E-10, 3.85497672006, 19406.6782881746), new Vsop87.LnVsop(6.6E-10, 5.70059718736, 33561.5446664322), new Vsop87.LnVsop(6.7E-10, 0.16590056505, 22743.4093795164), new Vsop87.LnVsop(6.5E-10, 4.65403865898, 2807.3983432562), new Vsop87.LnVsop(6.9E-10, 3.34398269353, 11670.2840372968), new Vsop87.LnVsop(8.7E-10, 4.97795118361, 1118.7557921028), new Vsop87.LnVsop(6.3E-10, 0.18907107644, 30065.5118402982), new Vsop87.LnVsop(6.4E-10, 4.61910278723, 9886.772200064), new Vsop87.LnVsop(7.3E-10, 0.93704276887, 20735.83216142559), new Vsop87.LnVsop(6.0E-10, 5.83782810193, 8646.0634802536), new Vsop87.LnVsop(6.2E-10, 4.81385996015, 20199.094959633), new Vsop87.LnVsop(5.9E-10, 5.00167022948, 6414.6178116778), new Vsop87.LnVsop(6.8E-10, 3.84295373259, 6571.0185321802), new Vsop87.LnVsop(6.1E-10, 2.81706693695, 6944.3087767724), new Vsop87.LnVsop(6.5E-10, 4.49019257083, 632.7837393132), new Vsop87.LnVsop(5.8E-10, 5.65218977997, 9945.5712088238), new Vsop87.LnVsop(7.1E-10, 2.51550158926, 9638.9407478762), new Vsop87.LnVsop(5.7E-10, 3.2797883147, 206.1855484372), new Vsop87.LnVsop(5.8E-10, 2.97636193658, 21795.21409161479), new Vsop87.LnVsop(5.6E-10, 2.23539566426, 20995.3929664494), new Vsop87.LnVsop(5.7E-10, 1.88470380043, 18451.07854656599), new Vsop87.LnVsop(7.1E-10, 4.8244565433, 8542.970706035), new Vsop87.LnVsop(6.1E-10, 3.65964735564, 14421.8316369884), new Vsop87.LnVsop(5.6E-10, 3.13785930666, 8799.988713778), new Vsop87.LnVsop(5.7E-10, 4.89910616374, 9602.3526362242), new Vsop87.LnVsop(6.5E-10, 3.37158994673, 11610.9101753832), new Vsop87.LnVsop(6.7E-10, 1.92961865108, 21265.5231265202), new Vsop87.LnVsop(5.5E-10, 1.95164531766, 9588.1255422226), new Vsop87.LnVsop(5.7E-10, 2.82246123078, 10124.930054318), new Vsop87.LnVsop(5.7E-10, 6.10387785338, 19800.9459562248), new Vsop87.LnVsop(5.5E-10, 5.20958408712, 3237.5196524812), new Vsop87.LnVsop(5.7E-10, 4.12311973381, 10028.9508271002), new Vsop87.LnVsop(5.4E-10, 1.4169354895, 15906.7641266826), new Vsop87.LnVsop(5.3E-10, 2.16367301961, 6418.1409300268), new Vsop87.LnVsop(6.0E-10, 2.6466463773, 10018.2468514476), new Vsop87.LnVsop(6.8E-10, 5.3654529694, 1228.9621133222), new Vsop87.LnVsop(5.1E-10, 5.73844646896, 6048.4411140864), new Vsop87.LnVsop(5.3E-10, 0.32024828883, 12721.572099417), new Vsop87.LnVsop(5.1E-10, 0.06318823307, 20206.141196331), new Vsop87.LnVsop(4.9E-10, 4.53400634462, 6675.7019290922), new Vsop87.LnVsop(5.1E-10, 1.15453549218, 10156.9023601348), new Vsop87.LnVsop(6.4E-10, 4.56324217308, 16703.07938715119), new Vsop87.LnVsop(6.0E-10, 3.61007876606, 9468.267877257), new Vsop87.LnVsop(5.9E-10, 3.08394474122, 10025.4277087512), new Vsop87.LnVsop(6.4E-10, 2.53221459501, 16703.0448798468), new Vsop87.LnVsop(5.6E-10, 3.31981662811, 6518.7582172674), new Vsop87.LnVsop(4.7E-10, 1.44559124267, 6643.0918177618), new Vsop87.LnVsop(5.0E-10, 1.92346411481, 11614.4332937322), new Vsop87.LnVsop(4.7E-10, 4.03823773711, 23958.6317852334), new Vsop87.LnVsop(4.6E-10, 3.70969689047, 8859.3625756916), new Vsop87.LnVsop(6.0E-10, 2.55451756882, 11780.4903585162), new Vsop87.LnVsop(4.7E-10, 1.69255946598, 6660.8695340008), new Vsop87.LnVsop(4.4E-10, 6.09481156053, 6460.8122109608), new Vsop87.LnVsop(4.4E-10, 2.63075457414, 13936.794505134), new Vsop87.LnVsop(5.3E-10, 0.77837832855, 16865.5287696312), new Vsop87.LnVsop(4.9E-10, 1.83317426993, 17654.7805397496), new Vsop87.LnVsop(4.2E-10, 4.304037944, 9065.5481241288), new Vsop87.LnVsop(4.7E-10, 0.52827244925, 6686.747777707), new Vsop87.LnVsop(4.2E-10, 5.7205368422, 7203.8022714934), new Vsop87.LnVsop(4.1E-10, 0.98430028881, 20426.571092422), new Vsop87.LnVsop(5.1E-10, 3.54371303345, 20597.2439630412), new Vsop87.LnVsop(4.1E-10, 0.21190431801, 7314.0085927128), new Vsop87.LnVsop(3.8E-10, 2.53053802253, 13207.029307365), new Vsop87.LnVsop(3.9E-10, 5.15577529354, 6670.5881880498), new Vsop87.LnVsop(4.5E-10, 0.52366150729, 16489.763038061), new Vsop87.LnVsop(5.1E-10, 3.25181148972, 7799.9806455024), new Vsop87.LnVsop(4.9E-10, 0.7714914545, 17101.2111369072), new Vsop87.LnVsop(3.8E-10, 6.06656444914, 9389.0535407862), new Vsop87.LnVsop(3.6E-10, 0.84094545235, 23937.856389741)};
        static Vsop87.LnVsop[] mars_latitude_b1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.00217310991, 6.04472194776, 3340.6124266998), new Vsop87.LnVsop(2.0976948E-4, 3.14159265359, 0.0), new Vsop87.LnVsop(1.2834709E-4, 1.60810667915, 6681.2248533996), new Vsop87.LnVsop(3.320981E-5, 2.62947004077, 10021.8372800994), new Vsop87.LnVsop(6.272E-6, 3.11898601248, 13362.4497067992), new Vsop87.LnVsop(1.0199E-6, 3.52113557592, 16703.062133499), new Vsop87.LnVsop(7.5107E-7, 0.95983758515, 3337.0893083508), new Vsop87.LnVsop(2.9264E-7, 3.4030768271, 3344.1355450488), new Vsop87.LnVsop(2.3251E-7, 3.69342549027, 5621.8429232104), new Vsop87.LnVsop(2.219E-7, 2.21703408598, 2281.2304965106), new Vsop87.LnVsop(1.5454E-7, 3.89610159362, 20043.6745601988), new Vsop87.LnVsop(1.1867E-7, 3.83861019788, 6684.7479717486), new Vsop87.LnVsop(1.2038E-7, 2.13866775328, 6151.533888305), new Vsop87.LnVsop(9.697E-8, 5.48941186798, 3340.629680352), new Vsop87.LnVsop(9.697E-8, 3.45863925102, 3340.5951730476), new Vsop87.LnVsop(1.1537E-7, 1.90395033905, 3532.0606928114), new Vsop87.LnVsop(9.276E-8, 0.71941312462, 2942.4634232916), new Vsop87.LnVsop(9.24E-8, 2.51747952408, 5884.9268465832), new Vsop87.LnVsop(9.876E-8, 6.13507416822, 1059.3819301892), new Vsop87.LnVsop(9.265E-8, 4.55759125226, 8962.4553499102), new Vsop87.LnVsop(7.822E-8, 6.10932267009, 2810.9214616052), new Vsop87.LnVsop(1.0369E-7, 0.60195347181, 529.6909650946), new Vsop87.LnVsop(8.522E-8, 4.40106741096, 3496.032826134), new Vsop87.LnVsop(7.683E-8, 1.21169696624, 6677.7017350506), new Vsop87.LnVsop(7.134E-8, 1.93610705535, 2544.3144198834), new Vsop87.LnVsop(6.512E-8, 3.11636422105, 3738.761430108), new Vsop87.LnVsop(6.278E-8, 6.23176923902, 3185.1920272656), new Vsop87.LnVsop(5.833E-8, 0.74324094343, 398.1490034082), new Vsop87.LnVsop(5.033E-8, 2.28727456802, 3149.1641605882), new Vsop87.LnVsop(4.958E-8, 1.54200127913, 6283.0758499914), new Vsop87.LnVsop(4.325E-8, 3.90636722132, 5092.1519581158), new Vsop87.LnVsop(4.813E-8, 3.88560399245, 5486.777843175), new Vsop87.LnVsop(4.474E-8, 2.18937641288, 4136.9104335162), new Vsop87.LnVsop(3.023E-8, 5.1987900053, 5088.6288397668), new Vsop87.LnVsop(3.194E-8, 1.12695072198, 3340.6797370026), new Vsop87.LnVsop(3.167E-8, 0.76774265684, 4399.994356889), new Vsop87.LnVsop(3.066E-8, 0.9392378841, 2914.0142358238), new Vsop87.LnVsop(2.84E-8, 2.51888046278, 3870.3033917944), new Vsop87.LnVsop(2.622E-8, 3.25368667606, 3339.6321056316), new Vsop87.LnVsop(3.192E-8, 1.53317813619, 3340.545116397), new Vsop87.LnVsop(2.879E-8, 4.2058811395, 10025.3603984484), new Vsop87.LnVsop(2.435E-8, 2.4924322903, 1751.539531416), new Vsop87.LnVsop(2.066E-8, 2.96021692416, 3894.1818295422), new Vsop87.LnVsop(2.366E-8, 1.08506560814, 796.2980068164), new Vsop87.LnVsop(2.192E-8, 0.22905210418, 4690.4798363586), new Vsop87.LnVsop(2.398E-8, 0.43514026515, 1194.4470102246), new Vsop87.LnVsop(2.238E-8, 4.06454135883, 7079.3738568078), new Vsop87.LnVsop(1.825E-8, 5.4631939038, 1592.5960136328), new Vsop87.LnVsop(1.808E-8, 4.83342714362, 8432.7643848156), new Vsop87.LnVsop(2.251E-8, 4.25857270742, 23384.2869868986), new Vsop87.LnVsop(1.728E-8, 1.06103820676, 3341.592747768), new Vsop87.LnVsop(1.833E-8, 1.57091276737, 4292.3308329504), new Vsop87.LnVsop(1.581E-8, 0.93404031162, 4535.0594369244), new Vsop87.LnVsop(1.722E-8, 2.98790749378, 6254.6266625236), new Vsop87.LnVsop(1.395E-8, 3.43004445438, 2146.1654164752), new Vsop87.LnVsop(1.739E-8, 4.00666290186, 9492.1463150048), new Vsop87.LnVsop(1.535E-8, 2.94481028624, 6489.776587288), new Vsop87.LnVsop(1.394E-8, 2.71952784799, 7477.522860216), new Vsop87.LnVsop(1.257E-8, 1.34371702718, 2787.0430238574), new Vsop87.LnVsop(1.6E-8, 5.41971849753, 3127.3133312618), new Vsop87.LnVsop(1.274E-8, 4.11492658217, 1990.745017041), new Vsop87.LnVsop(1.19E-8, 4.24621398204, 3723.508958923), new Vsop87.LnVsop(1.144E-8, 5.30298760566, 6681.2075997474), new Vsop87.LnVsop(1.376E-8, 0.38090537503, 1589.0728952838), new Vsop87.LnVsop(1.144E-8, 1.05059380873, 6681.2421070518), new Vsop87.LnVsop(1.062E-8, 0.51072898484, 6674.1113063988), new Vsop87.LnVsop(1.355E-8, 0.30172057784, 6525.8044539654), new Vsop87.LnVsop(1.119E-8, 0.28227067739, 12303.06777661), new Vsop87.LnVsop(8.55E-9, 0.15965897606, 2957.7158944766), new Vsop87.LnVsop(1.066E-8, 2.74229978174, 2388.8940204492), new Vsop87.LnVsop(1.056E-8, 4.82485604808, 3583.3410306738), new Vsop87.LnVsop(7.7E-9, 3.92387598679, 7.1135470008), new Vsop87.LnVsop(9.22E-9, 5.97832717399, 3097.88382272579), new Vsop87.LnVsop(7.13E-9, 2.6160160208, 9225.539273283), new Vsop87.LnVsop(6.93E-9, 5.8694579201, 4933.2084403326), new Vsop87.LnVsop(7.38E-9, 5.02837731897, 12832.7587417046), new Vsop87.LnVsop(7.63E-9, 1.29638960572, 7740.6067835888), new Vsop87.LnVsop(6.56E-9, 1.57943668761, 6467.9257579616), new Vsop87.LnVsop(6.63E-9, 0.56970117211, 426.598190876), new Vsop87.LnVsop(6.16E-9, 2.90595542135, 3553.9115221378), new Vsop87.LnVsop(6.09E-9, 4.27586920886, 4562.4609930212), new Vsop87.LnVsop(6.08E-9, 4.6116348842, 10419.9862835076), new Vsop87.LnVsop(5.99E-9, 4.51624214272, 6836.6452528338), new Vsop87.LnVsop(5.65E-9, 3.63229110969, 155.4203994342), new Vsop87.LnVsop(5.62E-9, 0.31418284081, 213.299095438), new Vsop87.LnVsop(5.19E-9, 1.00557611591, 4929.6853219836), new Vsop87.LnVsop(5.04E-9, 4.17532879019, 6041.3275670856), new Vsop87.LnVsop(6.6E-9, 3.62669217851, 7210.9158184942), new Vsop87.LnVsop(5.76E-9, 4.54911948486, 13365.9728251482), new Vsop87.LnVsop(6.25E-9, 1.44798343162, 3333.498879699), new Vsop87.LnVsop(5.2E-9, 1.30331504622, 15643.6802033098), new Vsop87.LnVsop(4.44E-9, 2.0807606946, 10021.8545337516), new Vsop87.LnVsop(5.42E-9, 2.02587783935, 2288.3440435114), new Vsop87.LnVsop(5.09E-9, 1.65323927554, 191.4482661116), new Vsop87.LnVsop(4.44E-9, 0.04999320087, 10021.8200264472), new Vsop87.LnVsop(5.57E-9, 3.31349841992, 9623.6882766912), new Vsop87.LnVsop(4.72E-9, 6.2673112472, 6438.4962494256), new Vsop87.LnVsop(5.59E-9, 4.16781257217, 11773.3768115154), new Vsop87.LnVsop(3.99E-9, 1.32358791559, 7875.6718636242), new Vsop87.LnVsop(4.45E-9, 1.49656750781, 6682.2051744678), new Vsop87.LnVsop(3.85E-9, 0.75203057166, 5614.7293762096), new Vsop87.LnVsop(3.86E-9, 1.92088879703, 3325.3599555148), new Vsop87.LnVsop(3.77E-9, 3.38213849272, 6681.1575430968), new Vsop87.LnVsop(3.6E-9, 3.62049849377, 6680.2445323314), new Vsop87.LnVsop(3.52E-9, 3.40685833182, 9830.3890139878), new Vsop87.LnVsop(3.46E-9, 2.54878403272, 2274.1169495098), new Vsop87.LnVsop(3.36E-9, 5.51924409428, 3361.3878221922), new Vsop87.LnVsop(3.29E-9, 3.58450091417, 1066.49547719), new Vsop87.LnVsop(3.43E-9, 3.80876454378, 9595.2390892234), new Vsop87.LnVsop(3.83E-9, 4.58860426691, 3360.96774609859), new Vsop87.LnVsop(3.67E-9, 4.94614944232, 7903.073419721), new Vsop87.LnVsop(3.18E-9, 3.12211289329, 10818.1352869158), new Vsop87.LnVsop(2.98E-9, 5.16474580641, 1748.016413067), new Vsop87.LnVsop(3.1E-9, 5.77231072116, 3205.5473466644), new Vsop87.LnVsop(3.78E-9, 2.97214989967, 6681.2921637024), new Vsop87.LnVsop(3.03E-9, 3.44801982034, 3319.8370312074), new Vsop87.LnVsop(2.92E-9, 1.69888047283, 6127.6554505572), new Vsop87.LnVsop(2.88E-9, 1.13506530643, 8955.3418029094), new Vsop87.LnVsop(2.81E-9, 0.80027819229, 10018.3141617504), new Vsop87.LnVsop(3.26E-9, 5.9692407692, 639.897286314), new Vsop87.LnVsop(3.09E-9, 1.38061994912, 3767.2106175758), new Vsop87.LnVsop(3.75E-9, 4.48892934736, 5331.3574437408), new Vsop87.LnVsop(2.71E-9, 4.61196466416, 26724.8994135984), new Vsop87.LnVsop(2.66E-9, 3.0892742778, 5729.506447149), new Vsop87.LnVsop(2.9E-9, 2.44792712887, 3355.8648978848), new Vsop87.LnVsop(3.35E-9, 6.08508450491, 3320.257107301), new Vsop87.LnVsop(3.0E-9, 0.25476556615, 2700.7151403858), new Vsop87.LnVsop(2.89E-9, 3.45335160291, 382.8965322232), new Vsop87.LnVsop(2.6E-9, 3.56570589402, 8827.3902698748), new Vsop87.LnVsop(2.46E-9, 0.64772929845, 9866.4168806652), new Vsop87.LnVsop(2.98E-9, 4.38515379625, 1052.2683831884), new Vsop87.LnVsop(2.51E-9, 4.40903417777, 12964.300703391), new Vsop87.LnVsop(2.6E-9, 1.27300653213, 3347.7259737006), new Vsop87.LnVsop(2.8E-9, 1.4918258333, 10213.285546211), new Vsop87.LnVsop(2.25E-9, 2.73440886519, 6872.6731195112), new Vsop87.LnVsop(2.25E-9, 5.1664234392, 6923.9534573736), new Vsop87.LnVsop(2.26E-9, 2.68107364511, 1221.8485663214), new Vsop87.LnVsop(2.22E-9, 4.38874821491, 242.728603974), new Vsop87.LnVsop(2.09E-9, 5.0159170829, 6144.4203413042), new Vsop87.LnVsop(2.68E-9, 2.27786943096, 553.5694028424), new Vsop87.LnVsop(2.18E-9, 0.5329958281, 6298.3283211764), new Vsop87.LnVsop(2.61E-9, 3.89759063291, 6894.5239488376), new Vsop87.LnVsop(2.13E-9, 1.06038488787, 2118.7638603784), new Vsop87.LnVsop(2.1E-9, 4.74220753176, 9381.9399937854), new Vsop87.LnVsop(1.92E-9, 0.18364684632, 522.5774180938), new Vsop87.LnVsop(1.86E-9, 1.48154759746, 7064.1213856228), new Vsop87.LnVsop(1.76E-9, 3.93023367762, 2921.1277828246), new Vsop87.LnVsop(2.08E-9, 4.86366921136, 3344.2028553516), new Vsop87.LnVsop(2.01E-9, 0.36731227894, 8969.568896911), new Vsop87.LnVsop(2.09E-9, 4.43309730358, 3337.021998048), new Vsop87.LnVsop(1.63E-9, 4.54501296893, 11243.6858464208), new Vsop87.LnVsop(1.61E-9, 1.62341728854, 11081.2192102886), new Vsop87.LnVsop(1.52E-9, 3.98251813705, 10021.9045904022), new Vsop87.LnVsop(1.45E-9, 1.06283180181, 951.7184062506), new Vsop87.LnVsop(1.49E-9, 4.55824612447, 10551.528245194), new Vsop87.LnVsop(1.84E-9, 5.37374692745, 16173.3711684044), new Vsop87.LnVsop(1.43E-9, 2.00077774476, 6688.3384004004), new Vsop87.LnVsop(1.45E-9, 4.53139041634, 3312.163239232), new Vsop87.LnVsop(1.56E-9, 6.2607030143, 5628.9564702112), new Vsop87.LnVsop(1.57E-9, 5.56167088817, 536.8045120954), new Vsop87.LnVsop(1.33E-9, 5.43195789258, 13358.9265884502), new Vsop87.LnVsop(1.44E-9, 1.31943624453, 3364.4908644476), new Vsop87.LnVsop(1.56E-9, 4.10544868136, 6158.6474353058), new Vsop87.LnVsop(1.57E-9, 6.23025291402, 8273.8208670324), new Vsop87.LnVsop(1.34E-9, 4.31700501659, 8031.0922630584), new Vsop87.LnVsop(1.24E-9, 1.26816196203, 8270.2977486834), new Vsop87.LnVsop(1.56E-9, 4.39354558071, 10021.7699697966), new Vsop87.LnVsop(1.44E-9, 2.48806691402, 3503.079062832), new Vsop87.LnVsop(1.18E-9, 1.78550823737, 18984.2926300096), new Vsop87.LnVsop(1.1E-9, 6.12714281903, 7632.9432596502), new Vsop87.LnVsop(1.27E-9, 3.05541911618, 3316.733988952), new Vsop87.LnVsop(1.09E-9, 0.91919644775, 10014.7237330986), new Vsop87.LnVsop(1.02E-9, 1.54908471746, 7234.794256242), new Vsop87.LnVsop(1.0E-9, 5.04817125533, 13760.5987102074), new Vsop87.LnVsop(1.32E-9, 2.6659026358, 8429.2412664666), new Vsop87.LnVsop(1.26E-9, 0.13960736597, 1349.8674096588), new Vsop87.LnVsop(1.0E-9, 0.74385347353, 2487.4160449478), new Vsop87.LnVsop(9.1E-10, 0.24627212892, 3980.5097130138), new Vsop87.LnVsop(1.12E-9, 2.304755908, 3346.1353510072), new Vsop87.LnVsop(1.03E-9, 4.23425277305, 3475.6775067352), new Vsop87.LnVsop(1.09E-9, 3.21402242606, 17654.7805397496), new Vsop87.LnVsop(8.2E-10, 0.28323060532, 15113.9892382152), new Vsop87.LnVsop(8.3E-10, 0.53618493739, 13362.432453147), new Vsop87.LnVsop(9.6E-10, 3.66896983898, 12168.0026965746), new Vsop87.LnVsop(8.3E-10, 2.56708795058, 13362.4669604514), new Vsop87.LnVsop(7.7E-10, 4.92321070753, 16706.585251848), new Vsop87.LnVsop(9.7E-10, 2.11149094902, 3178.1457905676), new Vsop87.LnVsop(7.4E-10, 0.95663828948, 2699.7348193176), new Vsop87.LnVsop(8.3E-10, 1.82502676147, 3.523118349), new Vsop87.LnVsop(8.5E-10, 5.22946780555, 3304.5845600224), new Vsop87.LnVsop(8.3E-10, 3.10647417, 1758.6530784168), new Vsop87.LnVsop(7.0E-10, 5.11510436801, 5828.0284716476), new Vsop87.LnVsop(7.7E-10, 1.77323016185, 3335.0895023924), new Vsop87.LnVsop(8.2E-10, 5.25824044848, 853.196381752), new Vsop87.LnVsop(6.7E-10, 0.98915661779, 433.7117378768), new Vsop87.LnVsop(7.8E-10, 3.62913840245, 1596.1864422846), new Vsop87.LnVsop(7.8E-10, 1.56367501585, 3336.7310913418), new Vsop87.LnVsop(8.4E-10, 4.62334317796, 11371.7046897582), new Vsop87.LnVsop(7.2E-10, 3.62008128206, 1581.959348283), new Vsop87.LnVsop(7.2E-10, 4.05769658716, 4407.1079038898), new Vsop87.LnVsop(8.5E-10, 0.75421401009, 5459.3762870782), new Vsop87.LnVsop(7.4E-10, 1.03163916867, 5085.038411115), new Vsop87.LnVsop(5.8E-10, 3.24082931383, 13517.8701062334), new Vsop87.LnVsop(5.6E-10, 3.73441989631, 10713.9948813262), new Vsop87.LnVsop(6.1E-10, 1.52242466354, 18052.9295431578), new Vsop87.LnVsop(5.3E-10, 0.69821482369, 6702.000248892), new Vsop87.LnVsop(5.7E-10, 2.7643910391, 3344.4937620578), new Vsop87.LnVsop(6.9E-10, 1.99074407937, 10575.4066829418), new Vsop87.LnVsop(5.9E-10, 1.90513947603, 10022.8176011676), new Vsop87.LnVsop(5.1E-10, 0.93662679832, 14314.1681130498), new Vsop87.LnVsop(6.9E-10, 5.42699929964, 3376.6402933772), new Vsop87.LnVsop(5.3E-10, 4.87818342068, 8671.9698704406), new Vsop87.LnVsop(6.5E-10, 3.39290651505, 14584.2982731206), new Vsop87.LnVsop(5.7E-10, 1.70570965163, 2648.454825473), new Vsop87.LnVsop(5.4E-10, 5.49765437527, 3369.0616141676), new Vsop87.LnVsop(5.4E-10, 2.28971906454, 12566.1516999828), new Vsop87.LnVsop(6.8E-10, 4.60849144076, 7373.3824546264), new Vsop87.LnVsop(4.9E-10, 2.89959771413, 13916.0191096416), new Vsop87.LnVsop(5.8E-10, 4.18351190862, 10177.2576795336), new Vsop87.LnVsop(5.8E-10, 4.51310742397, 4032.7700279266), new Vsop87.LnVsop(4.8E-10, 3.42793333559, 1744.4259844152), new Vsop87.LnVsop(6.4E-10, 0.45002982477, 3863.1898447936), new Vsop87.LnVsop(4.7E-10, 5.88584556234, 10973.55568635), new Vsop87.LnVsop(5.7E-10, 1.76184909465, 11216.284290324), new Vsop87.LnVsop(5.3E-10, 1.35755250698, 21393.5419698576), new Vsop87.LnVsop(5.9E-10, 2.9119789381, 3981.490034082), new Vsop87.LnVsop(5.3E-10, 4.03461050047, 11769.8536931664), new Vsop87.LnVsop(5.2E-10, 2.05672710904, 10404.7338123226), new Vsop87.LnVsop(6.0E-10, 4.31863902545, 3077.528503327), new Vsop87.LnVsop(6.0E-10, 4.94577585891, 3603.6963500726), new Vsop87.LnVsop(5.2E-10, 3.45056061273, 9808.5381846614), new Vsop87.LnVsop(4.8E-10, 3.83792333621, 13171.0014406876), new Vsop87.LnVsop(5.0E-10, 1.55014152662, 419.4846438752), new Vsop87.LnVsop(4.2E-10, 1.56007012481, 8425.6508378148), new Vsop87.LnVsop(4.0E-10, 4.52149159432, 10235.1363755374), new Vsop87.LnVsop(4.5E-10, 4.94000875201, 16304.9131300908), new Vsop87.LnVsop(4.2E-10, 2.03301048111, 7107.8230442756), new Vsop87.LnVsop(5.5E-10, 2.94325348897, 640.8776073822), new Vsop87.LnVsop(3.9E-10, 0.82091082076, 12310.1813236108), new Vsop87.LnVsop(4.0E-10, 3.2901367269, 6247.5131155228), new Vsop87.LnVsop(4.0E-10, 0.33830589904, 6531.661656265), new Vsop87.LnVsop(4.4E-10, 4.73395183232, 20597.2439630412), new Vsop87.LnVsop(3.7E-10, 0.01359265708, 3914.9572250346), new Vsop87.LnVsop(3.7E-10, 3.04848190227, 2766.267628365), new Vsop87.LnVsop(3.7E-10, 4.13243009725, 17256.6315363414), new Vsop87.LnVsop(4.3E-10, 3.2744266679, 20995.3929664494), new Vsop87.LnVsop(3.5E-10, 0.2985652333, 9779.1086761254), new Vsop87.LnVsop(4.5E-10, 0.96453304167, 18454.601664915), new Vsop87.LnVsop(3.6E-10, 0.18334758502, 6660.8695340008), new Vsop87.LnVsop(4.3E-10, 1.23912278835, 8439.8779318164), new Vsop87.LnVsop(3.4E-10, 2.83078633705, 6696.4773245846), new Vsop87.LnVsop(4.3E-10, 5.80649509131, 9168.6408983474), new Vsop87.LnVsop(3.4E-10, 3.4688411335, 9070.1188738488), new Vsop87.LnVsop(3.7E-10, 5.04438408684, 1692.1656695024), new Vsop87.LnVsop(4.0E-10, 1.15262282119, 14712.317116458), new Vsop87.LnVsop(3.5E-10, 2.33581709312, 76.2660712756), new Vsop87.LnVsop(4.0E-10, 3.54052855946, 14158.7477136156), new Vsop87.LnVsop(3.2E-10, 4.9607870365, 24734.1543965574), new Vsop87.LnVsop(2.9E-10, 2.34589185801, 13745.3462390224), new Vsop87.LnVsop(3.0E-10, 6.17825920695, 12935.8515159232), new Vsop87.LnVsop(3.6E-10, 4.78354946118, 3191.0492295652), new Vsop87.LnVsop(2.8E-10, 4.98887480054, 30065.5118402982), new Vsop87.LnVsop(2.8E-10, 2.51507274088, 692.1576012268), new Vsop87.LnVsop(2.7E-10, 1.02364014288, 13207.029307365), new Vsop87.LnVsop(3.5E-10, 2.06348913435, 9468.267877257), new Vsop87.LnVsop(2.7E-10, 6.07463404086, 20199.094959633), new Vsop87.LnVsop(2.7E-10, 4.9780805768, 13362.3823964964), new Vsop87.LnVsop(3.3E-10, 1.46173724832, 12295.9542296092), new Vsop87.LnVsop(2.5E-10, 4.5478244536, 9499.2598620056), new Vsop87.LnVsop(2.5E-10, 5.21847833578, 5099.2655051166), new Vsop87.LnVsop(2.5E-10, 5.90368432966, 19513.9835951042), new Vsop87.LnVsop(2.5E-10, 5.54544644558, 10264.5658840734), new Vsop87.LnVsop(2.9E-10, 5.69085985167, 16699.53901514999), new Vsop87.LnVsop(3.0E-10, 1.43603228163, 6040.3472460174), new Vsop87.LnVsop(2.8E-10, 5.41811683281, 15110.4661198662), new Vsop87.LnVsop(3.2E-10, 2.25828272513, 6665.9723822146), new Vsop87.LnVsop(2.3E-10, 5.38626329146, 6660.4494579072), new Vsop87.LnVsop(2.3E-10, 3.75194149686, 14054.607308026), new Vsop87.LnVsop(2.8E-10, 4.86716760481, 6701.5801727984), new Vsop87.LnVsop(2.7E-10, 5.26172837256, 6816.289933435), new Vsop87.LnVsop(2.3E-10, 4.66125245752, 13149.1506113612), new Vsop87.LnVsop(2.7E-10, 0.9182178526, 9638.9407478762), new Vsop87.LnVsop(2.3E-10, 0.60587177409, 6604.958782124), new Vsop87.LnVsop(2.5E-10, 0.78041098485, 11766.2632645146), new Vsop87.LnVsop(2.5E-10, 3.94777048397, 10020.8569590312), new Vsop87.LnVsop(2.6E-10, 5.36280311705, 9485.032768004), new Vsop87.LnVsop(2.0E-10, 2.45752476953, 10028.9508271002), new Vsop87.LnVsop(2.0E-10, 0.38029885589, 11614.4332937322), new Vsop87.LnVsop(2.6E-10, 4.53241539149, 13362.517017102), new Vsop87.LnVsop(1.9E-10, 3.71366407424, 9588.1255422226), new Vsop87.LnVsop(2.2E-10, 5.20856925736, 13892.1406718938)};
        static Vsop87.LnVsop[] mars_latitude_b2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(8.888446E-5, 1.06196052751, 3340.6124266998), new Vsop87.LnVsop(2.595393E-5, 3.14159265359, 0.0), new Vsop87.LnVsop(9.18914E-6, 0.1153843119, 6681.2248533996), new Vsop87.LnVsop(2.67883E-6, 0.78837893063, 10021.8372800994), new Vsop87.LnVsop(6.6911E-7, 1.39435595847, 13362.4497067992), new Vsop87.LnVsop(1.4267E-7, 1.87268116087, 16703.062133499), new Vsop87.LnVsop(7.948E-8, 2.58819177832, 3337.0893083508), new Vsop87.LnVsop(2.709E-8, 2.29241371893, 20043.6745601988), new Vsop87.LnVsop(2.911E-8, 1.36634316448, 3344.1355450488), new Vsop87.LnVsop(2.528E-8, 6.00423798411, 3496.032826134), new Vsop87.LnVsop(1.617E-8, 5.72212771018, 5621.8429232104), new Vsop87.LnVsop(1.625E-8, 4.63140305669, 3185.1920272656), new Vsop87.LnVsop(1.173E-8, 2.0487181208, 6684.7479717486), new Vsop87.LnVsop(1.066E-8, 1.15825195582, 2281.2304965106), new Vsop87.LnVsop(1.043E-8, 3.54796199484, 3532.0606928114), new Vsop87.LnVsop(7.24E-9, 4.20458660775, 5884.9268465832), new Vsop87.LnVsop(6.1E-9, 5.22430575829, 2810.9214616052), new Vsop87.LnVsop(5.57E-9, 2.75698163218, 2942.4634232916), new Vsop87.LnVsop(6.55E-9, 2.84033212598, 6677.7017350506), new Vsop87.LnVsop(6.41E-9, 5.44557723446, 5486.777843175), new Vsop87.LnVsop(4.98E-9, 4.59850630546, 3894.1818295422), new Vsop87.LnVsop(5.01E-9, 0.52535712881, 5088.6288397668), new Vsop87.LnVsop(5.21E-9, 4.66308888977, 1059.3819301892), new Vsop87.LnVsop(4.9E-9, 3.99314993252, 2544.3144198834), new Vsop87.LnVsop(4.08E-9, 4.93937427401, 3339.6321056316), new Vsop87.LnVsop(3.96E-9, 0.51430149629, 3340.629680352), new Vsop87.LnVsop(4.7E-9, 2.68379670864, 23384.2869868986), new Vsop87.LnVsop(3.89E-9, 6.00426372731, 8962.4553499102), new Vsop87.LnVsop(4.46E-9, 3.8130704039, 6151.533888305), new Vsop87.LnVsop(3.96E-9, 4.76665218791, 3340.5951730476), new Vsop87.LnVsop(3.6E-9, 0.30420986478, 4136.9104335162), new Vsop87.LnVsop(3.68E-9, 2.55488502496, 10025.3603984484), new Vsop87.LnVsop(4.17E-9, 2.05816647037, 529.6909650946), new Vsop87.LnVsop(3.93E-9, 1.18623350431, 3097.88382272579), new Vsop87.LnVsop(3.18E-9, 4.8908398618, 5092.1519581158), new Vsop87.LnVsop(3.11E-9, 0.52479429819, 3149.1641605882), new Vsop87.LnVsop(3.39E-9, 1.9133065855, 4690.4798363586), new Vsop87.LnVsop(3.51E-9, 3.22939666067, 4292.3308329504), new Vsop87.LnVsop(4.0E-9, 4.99682542425, 6525.8044539654), new Vsop87.LnVsop(2.69E-9, 5.24048656863, 4399.994356889), new Vsop87.LnVsop(2.69E-9, 6.01045237753, 2787.0430238574), new Vsop87.LnVsop(2.42E-9, 5.84228858137, 3723.508958923), new Vsop87.LnVsop(3.0E-9, 3.3378091887, 3583.3410306738), new Vsop87.LnVsop(2.3E-9, 1.39226657786, 3738.761430108), new Vsop87.LnVsop(1.92E-9, 5.54090794612, 3341.592747768), new Vsop87.LnVsop(1.85E-9, 2.67271130688, 6283.0758499914), new Vsop87.LnVsop(1.84E-9, 2.21130914624, 7079.3738568078), new Vsop87.LnVsop(1.7E-9, 5.17306622171, 6254.6266625236), new Vsop87.LnVsop(1.86E-9, 3.6821234893, 1592.5960136328), new Vsop87.LnVsop(1.68E-9, 2.39044142684, 1990.745017041), new Vsop87.LnVsop(2.01E-9, 0.91789291159, 2388.8940204492), new Vsop87.LnVsop(1.71E-9, 4.81773821378, 1194.4470102246), new Vsop87.LnVsop(1.81E-9, 2.501456884, 398.1490034082), new Vsop87.LnVsop(1.77E-9, 5.42788143021, 4535.0594369244), new Vsop87.LnVsop(1.53E-9, 5.20921140136, 2146.1654164752), new Vsop87.LnVsop(1.31E-9, 2.41348963069, 3340.6797370026), new Vsop87.LnVsop(1.5E-9, 1.54231915192, 6438.4962494256), new Vsop87.LnVsop(1.49E-9, 0.96225780576, 7477.522860216), new Vsop87.LnVsop(1.29E-9, 5.26033357561, 155.4203994342), new Vsop87.LnVsop(1.58E-9, 4.47988793489, 3333.498879699), new Vsop87.LnVsop(1.33E-9, 6.05902381899, 6836.6452528338), new Vsop87.LnVsop(1.2E-9, 4.73910738283, 2957.7158944766), new Vsop87.LnVsop(1.17E-9, 2.22260771124, 6674.1113063988), new Vsop87.LnVsop(1.36E-9, 5.83288551607, 796.2980068164), new Vsop87.LnVsop(1.57E-9, 1.15241959296, 6489.776587288), new Vsop87.LnVsop(1.1E-9, 4.19180987487, 4933.2084403326), new Vsop87.LnVsop(1.3E-9, 2.84683198305, 3340.545116397), new Vsop87.LnVsop(1.21E-9, 2.52786285342, 9492.1463150048), new Vsop87.LnVsop(1.08E-9, 0.08979902661, 1748.016413067), new Vsop87.LnVsop(1.17E-9, 5.82410316896, 2914.0142358238), new Vsop87.LnVsop(8.6E-10, 2.0192729784, 7.1135470008), new Vsop87.LnVsop(8.2E-10, 3.80856644509, 6681.2075997474), new Vsop87.LnVsop(8.2E-10, 5.83941329915, 6681.2421070518), new Vsop87.LnVsop(7.6E-10, 0.0826282107, 6127.6554505572), new Vsop87.LnVsop(9.1E-10, 2.96288127149, 13365.9728251482), new Vsop87.LnVsop(8.0E-10, 2.85318684748, 8955.3418029094), new Vsop87.LnVsop(8.3E-10, 5.02941237478, 12303.06777661), new Vsop87.LnVsop(7.4E-10, 3.62624366705, 6923.9534573736), new Vsop87.LnVsop(7.2E-10, 1.17271788888, 3127.3133312618), new Vsop87.LnVsop(9.5E-10, 4.98093994365, 1589.0728952838), new Vsop87.LnVsop(8.7E-10, 5.81716080338, 7740.6067835888), new Vsop87.LnVsop(8.9E-10, 0.48604673074, 3870.3033917944), new Vsop87.LnVsop(6.6E-10, 3.06598137329, 26724.8994135984), new Vsop87.LnVsop(6.7E-10, 6.01736846209, 6682.2051744678), new Vsop87.LnVsop(7.0E-10, 0.64135636261, 2288.3440435114), new Vsop87.LnVsop(6.3E-10, 3.19176567675, 12832.7587417046), new Vsop87.LnVsop(6.3E-10, 2.70869032431, 242.728603974), new Vsop87.LnVsop(6.2E-10, 5.92753482553, 7875.6718636242), new Vsop87.LnVsop(7.4E-10, 5.12213534011, 9866.4168806652), new Vsop87.LnVsop(7.6E-10, 2.80770234482, 5331.3574437408), new Vsop87.LnVsop(6.3E-10, 1.40446619803, 5729.506447149), new Vsop87.LnVsop(6.5E-10, 1.35907629616, 1349.8674096588), new Vsop87.LnVsop(5.6E-10, 2.65764515134, 951.7184062506), new Vsop87.LnVsop(6.7E-10, 4.84212554978, 2274.1169495098), new Vsop87.LnVsop(6.9E-10, 2.48893325965, 10419.9862835076), new Vsop87.LnVsop(5.1E-10, 5.98407977888, 6041.3275670856), new Vsop87.LnVsop(4.9E-10, 4.85570926461, 4562.4609930212), new Vsop87.LnVsop(5.8E-10, 4.99207597345, 8969.568896911), new Vsop87.LnVsop(4.3E-10, 5.63823020899, 4929.6853219836), new Vsop87.LnVsop(5.8E-10, 6.20594898525, 3347.7259737006), new Vsop87.LnVsop(5.7E-10, 2.89730834453, 10018.3141617504), new Vsop87.LnVsop(5.8E-10, 3.89480774042, 553.5694028424), new Vsop87.LnVsop(4.7E-10, 5.12333023108, 426.598190876), new Vsop87.LnVsop(4.2E-10, 1.03283454214, 6681.2921637024), new Vsop87.LnVsop(5.1E-10, 1.17739312127, 1751.539531416), new Vsop87.LnVsop(3.6E-10, 4.7157651459, 6298.3283211764), new Vsop87.LnVsop(4.1E-10, 4.11801359055, 10021.8200264472), new Vsop87.LnVsop(3.6E-10, 2.79629985388, 213.299095438), new Vsop87.LnVsop(3.3E-10, 5.67092277262, 15643.6802033098), new Vsop87.LnVsop(3.3E-10, 1.68550281175, 9830.3890139878), new Vsop87.LnVsop(3.2E-10, 2.78277698783, 7210.9158184942), new Vsop87.LnVsop(4.1E-10, 6.14975635778, 10021.8545337516), new Vsop87.LnVsop(3.1E-10, 1.46914313245, 10818.1352869158), new Vsop87.LnVsop(3.0E-10, 5.11654548214, 11773.3768115154), new Vsop87.LnVsop(3.0E-10, 5.94013525093, 3767.2106175758), new Vsop87.LnVsop(2.8E-10, 1.35093398031, 3553.9115221378), new Vsop87.LnVsop(2.7E-10, 0.84036429724, 7632.9432596502), new Vsop87.LnVsop(2.9E-10, 5.7652910485, 8031.0922630584), new Vsop87.LnVsop(2.6E-10, 0.25856730853, 1066.49547719), new Vsop87.LnVsop(2.4E-10, 0.67405360149, 3360.96774609859), new Vsop87.LnVsop(2.4E-10, 2.34265028137, 3320.257107301), new Vsop87.LnVsop(2.8E-10, 1.8168036866, 9623.6882766912), new Vsop87.LnVsop(2.2E-10, 6.24243881749, 8432.7643848156), new Vsop87.LnVsop(2.1E-10, 5.25722436514, 6680.2445323314), new Vsop87.LnVsop(2.3E-10, 4.24982817116, 3325.3599555148), new Vsop87.LnVsop(2.2E-10, 5.05378057964, 3355.8648978848), new Vsop87.LnVsop(2.6E-10, 5.21495958693, 382.8965322232), new Vsop87.LnVsop(2.3E-10, 2.27453854146, 7234.794256242), new Vsop87.LnVsop(2.5E-10, 1.69816682992, 6872.6731195112), new Vsop87.LnVsop(2.3E-10, 4.13297133971, 639.897286314), new Vsop87.LnVsop(1.9E-10, 4.63736307953, 8429.2412664666), new Vsop87.LnVsop(1.8E-10, 0.29318941103, 640.8776073822), new Vsop87.LnVsop(1.7E-10, 3.12909635955, 6467.9257579616), new Vsop87.LnVsop(1.6E-10, 1.92178558286, 6681.1575430968), new Vsop87.LnVsop(1.6E-10, 0.47472874553, 1052.2683831884), new Vsop87.LnVsop(1.6E-10, 0.09800770199, 11081.2192102886), new Vsop87.LnVsop(1.8E-10, 3.26217306584, 7064.1213856228), new Vsop87.LnVsop(1.6E-10, 5.48746970528, 9595.2390892234), new Vsop87.LnVsop(1.9E-10, 4.63958564261, 8273.8208670324), new Vsop87.LnVsop(1.5E-10, 2.52623641715, 191.4482661116), new Vsop87.LnVsop(1.6E-10, 1.95271387752, 2699.7348193176), new Vsop87.LnVsop(1.5E-10, 4.31015619343, 8827.3902698748), new Vsop87.LnVsop(1.4E-10, 1.08241159656, 10973.55568635), new Vsop87.LnVsop(1.5E-10, 6.00000660183, 11371.7046897582), new Vsop87.LnVsop(1.3E-10, 0.22518942674, 6688.3384004004), new Vsop87.LnVsop(1.3E-10, 2.42192861366, 10575.4066829418), new Vsop87.LnVsop(1.1E-10, 2.53752217003, 12964.300703391), new Vsop87.LnVsop(1.1E-10, 4.80028625279, 11769.8536931664), new Vsop87.LnVsop(1.4E-10, 3.84407896636, 16173.3711684044), new Vsop87.LnVsop(1.1E-10, 1.79883656022, 9779.1086761254), new Vsop87.LnVsop(1.0E-10, 3.38769942924, 16706.585251848), new Vsop87.LnVsop(1.3E-10, 2.15740232885, 6894.5239488376), new Vsop87.LnVsop(1.0E-10, 5.38827104551, 12310.1813236108), new Vsop87.LnVsop(1.2E-10, 3.76810144879, 9225.539273283), new Vsop87.LnVsop(1.1E-10, 3.25290731199, 8671.9698704406), new Vsop87.LnVsop(1.1E-10, 2.9056411882, 6040.3472460174), new Vsop87.LnVsop(1.0E-10, 5.69430086859, 13207.029307365), new Vsop87.LnVsop(9.0E-11, 3.26007781906, 13760.5987102074), new Vsop87.LnVsop(9.0E-11, 2.65306894671, 10551.528245194), new Vsop87.LnVsop(9.0E-11, 1.95264065659, 9070.1188738488), new Vsop87.LnVsop(1.1E-10, 0.42402934223, 9381.9399937854)};
        static Vsop87.LnVsop[] mars_latitude_b3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.30418E-6, 2.04215300484, 3340.6124266998), new Vsop87.LnVsop(9.3057E-7, 0.0, 0.0), new Vsop87.LnVsop(1.4546E-7, 5.38525967237, 10021.8372800994), new Vsop87.LnVsop(8.731E-8, 4.90252313032, 6681.2248533996), new Vsop87.LnVsop(5.215E-8, 5.97441462813, 13362.4497067992), new Vsop87.LnVsop(1.422E-8, 0.21283650226, 16703.062133499), new Vsop87.LnVsop(5.85E-9, 4.14327356645, 3337.0893083508), new Vsop87.LnVsop(4.89E-9, 1.32053432093, 3496.032826134), new Vsop87.LnVsop(3.32E-9, 0.67062028539, 20043.6745601988), new Vsop87.LnVsop(2.81E-9, 3.02888736938, 3185.1920272656), new Vsop87.LnVsop(9.5E-10, 0.68129190368, 5621.8429232104), new Vsop87.LnVsop(1.17E-9, 6.20178829761, 3344.1355450488), new Vsop87.LnVsop(1.0E-9, 2.70816972496, 3097.88382272579), new Vsop87.LnVsop(8.6E-10, 0.38064581922, 6684.7479717486), new Vsop87.LnVsop(7.1E-10, 6.2441226028, 3894.1818295422), new Vsop87.LnVsop(7.9E-10, 5.14539339999, 3532.0606928114), new Vsop87.LnVsop(8.0E-10, 3.42045199039, 6525.8044539654), new Vsop87.LnVsop(6.1E-10, 3.81929342821, 2942.4634232916), new Vsop87.LnVsop(6.6E-10, 0.952649881, 23384.2869868986), new Vsop87.LnVsop(6.2E-10, 1.65751945223, 3583.3410306738), new Vsop87.LnVsop(6.2E-10, 5.30607853843, 2544.3144198834), new Vsop87.LnVsop(4.2E-10, 0.30552815689, 3339.6321056316), new Vsop87.LnVsop(3.7E-10, 4.37754880706, 2787.0430238574), new Vsop87.LnVsop(4.3E-10, 4.9045727918, 4292.3308329504), new Vsop87.LnVsop(3.6E-10, 3.58183533863, 4690.4798363586), new Vsop87.LnVsop(3.4E-10, 0.89018356943, 10025.3603984484), new Vsop87.LnVsop(3.2E-10, 2.34732348899, 5088.6288397668), new Vsop87.LnVsop(2.8E-10, 1.23206084526, 3723.508958923), new Vsop87.LnVsop(2.6E-10, 0.56214389305, 155.4203994342), new Vsop87.LnVsop(2.6E-10, 4.11359839477, 6677.7017350506), new Vsop87.LnVsop(2.6E-10, 0.37391494322, 2146.1654164752), new Vsop87.LnVsop(2.4E-10, 5.7880201351, 5884.9268465832), new Vsop87.LnVsop(2.1E-10, 2.91916849909, 529.6909650946), new Vsop87.LnVsop(1.9E-10, 4.86965145048, 4136.9104335162), new Vsop87.LnVsop(2.3E-10, 1.04314198221, 5486.777843175), new Vsop87.LnVsop(1.8E-10, 4.95637454569, 3149.1641605882), new Vsop87.LnVsop(1.7E-10, 6.2354625897, 7079.3738568078), new Vsop87.LnVsop(1.7E-10, 3.82096761296, 3341.592747768), new Vsop87.LnVsop(1.9E-10, 5.66874348929, 2388.8940204492), new Vsop87.LnVsop(1.5E-10, 5.13426153783, 6489.776587288), new Vsop87.LnVsop(1.4E-10, 0.53723500958, 1990.745017041), new Vsop87.LnVsop(1.4E-10, 3.07166661567, 2957.7158944766), new Vsop87.LnVsop(1.2E-10, 1.0014146476, 3340.629680352), new Vsop87.LnVsop(1.2E-10, 5.24418015401, 3340.5951730476), new Vsop87.LnVsop(1.3E-10, 0.4116283618, 8962.4553499102), new Vsop87.LnVsop(1.2E-10, 3.81140154428, 9866.4168806652), new Vsop87.LnVsop(1.2E-10, 4.25382428399, 6151.533888305), new Vsop87.LnVsop(1.5E-10, 3.63297907536, 4535.0594369244), new Vsop87.LnVsop(1.2E-10, 1.61461268629, 1592.5960136328), new Vsop87.LnVsop(1.0E-10, 5.80958145013, 3333.498879699), new Vsop87.LnVsop(1.0E-10, 1.23772110632, 6836.6452528338), new Vsop87.LnVsop(9.0E-11, 1.44366353557, 26724.8994135984), new Vsop87.LnVsop(8.0E-11, 2.02732749775, 6923.9534573736), new Vsop87.LnVsop(9.0E-11, 3.19116537565, 6438.4962494256), new Vsop87.LnVsop(8.0E-11, 1.85197515729, 1194.4470102246), new Vsop87.LnVsop(8.0E-11, 2.56762648035, 398.1490034082), new Vsop87.LnVsop(7.0E-11, 3.69377532737, 4399.994356889), new Vsop87.LnVsop(5.0E-11, 4.73479766634, 6127.6554505572), new Vsop87.LnVsop(5.0E-11, 0.3910954722, 5092.1519581158), new Vsop87.LnVsop(6.0E-11, 1.41716854423, 13365.9728251482), new Vsop87.LnVsop(5.0E-11, 3.98879770109, 6283.0758499914), new Vsop87.LnVsop(5.0E-11, 1.86523815587, 1059.3819301892), new Vsop87.LnVsop(6.0E-11, 5.52177150128, 7477.522860216), new Vsop87.LnVsop(5.0E-11, 1.92244747457, 2810.9214616052)};
        static Vsop87.LnVsop[] mars_latitude_b4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(6.007E-8, 3.37637101191, 3340.6124266998), new Vsop87.LnVsop(6.625E-8, 0.0, 0.0), new Vsop87.LnVsop(4.64E-9, 3.7720275715, 10021.8372800994), new Vsop87.LnVsop(4.05E-9, 0.63107416776, 6681.2248533996), new Vsop87.LnVsop(2.99E-9, 4.32966790803, 13362.4497067992), new Vsop87.LnVsop(1.09E-9, 4.85358280107, 16703.062133499), new Vsop87.LnVsop(7.7E-10, 2.88080440451, 3496.032826134), new Vsop87.LnVsop(3.9E-10, 1.4319759036, 3185.1920272656), new Vsop87.LnVsop(3.1E-10, 5.67989354532, 3337.0893083508), new Vsop87.LnVsop(3.1E-10, 5.33373014736, 20043.6745601988), new Vsop87.LnVsop(1.7E-10, 4.32019018052, 3097.88382272579), new Vsop87.LnVsop(1.3E-10, 1.77444975035, 6525.8044539654), new Vsop87.LnVsop(1.0E-10, 0.04059602724, 3583.3410306738), new Vsop87.LnVsop(7.0E-11, 4.46709463778, 6684.7479717486), new Vsop87.LnVsop(6.0E-11, 1.85656049405, 2787.0430238574), new Vsop87.LnVsop(6.0E-11, 1.15875671922, 3894.1818295422), new Vsop87.LnVsop(6.0E-11, 5.76437007548, 23384.2869868986), new Vsop87.LnVsop(3.0E-11, 2.91488661915, 6836.6452528338)};
        static Vsop87.LnVsop[] mars_latitude_b5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.68E-9, 4.63460005338, 3340.6124266998), new Vsop87.LnVsop(4.5E-10, 5.14206308865, 6681.2248533996), new Vsop87.LnVsop(3.5E-10, 3.14159265359, 0.0), new Vsop87.LnVsop(1.2E-10, 2.68434578055, 13362.4497067992), new Vsop87.LnVsop(1.0E-10, 4.43919916342, 3496.032826134), new Vsop87.LnVsop(6.0E-11, 1.70177189273, 10021.8372800994), new Vsop87.LnVsop(5.0E-11, 3.2041510462, 16703.062133499), new Vsop87.LnVsop(4.0E-11, 6.15670065734, 3185.1920272656), new Vsop87.LnVsop(1.0E-11, 3.71915090755, 20043.6745601988)};

        Latitude() {
        }
    }

    static class Lontitude1 {
        static Vsop87.LnVsop[] mars_longitude_l1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3340.61242700512, 0.0, 0.0), new Vsop87.LnVsop(0.01457554523, 3.60433733236, 3340.6124266998), new Vsop87.LnVsop(0.00168414711, 3.92318567804, 6681.2248533996), new Vsop87.LnVsop(2.0622975E-4, 4.26108844583, 10021.8372800994), new Vsop87.LnVsop(3.452392E-5, 4.7321039319, 3.523118349), new Vsop87.LnVsop(2.586332E-5, 4.60670058555, 13362.4497067992), new Vsop87.LnVsop(8.41535E-6, 4.45864030426, 2281.2304965106), new Vsop87.LnVsop(5.37567E-6, 5.01581256923, 398.1490034082), new Vsop87.LnVsop(5.20948E-6, 4.99428054039, 3344.1355450488), new Vsop87.LnVsop(4.32635E-6, 2.56070853083, 191.4482661116), new Vsop87.LnVsop(4.29655E-6, 5.31645299471, 155.4203994342), new Vsop87.LnVsop(3.81751E-6, 3.53878166043, 796.2980068164), new Vsop87.LnVsop(3.2853E-6, 4.95632685192, 16703.062133499), new Vsop87.LnVsop(2.82795E-6, 3.15966768785, 2544.3144198834), new Vsop87.LnVsop(2.05657E-6, 4.56889279932, 2146.1654164752), new Vsop87.LnVsop(1.68866E-6, 1.3293655906, 3337.0893083508), new Vsop87.LnVsop(1.57593E-6, 4.18519540728, 1751.539531416), new Vsop87.LnVsop(1.33686E-6, 2.23327245555, 0.9803210682), new Vsop87.LnVsop(1.16965E-6, 2.21414273762, 1059.3819301892), new Vsop87.LnVsop(1.17503E-6, 6.02411290806, 6151.533888305), new Vsop87.LnVsop(1.13718E-6, 5.42753341019, 3738.761430108), new Vsop87.LnVsop(1.33565E-6, 5.97420357518, 1748.016413067), new Vsop87.LnVsop(9.1099E-7, 1.09626613064, 1349.8674096588), new Vsop87.LnVsop(8.4256E-7, 5.29330740437, 6684.7479717486), new Vsop87.LnVsop(1.13886E-6, 2.12863726524, 1194.4470102246), new Vsop87.LnVsop(8.0823E-7, 4.42818326716, 529.6909650946), new Vsop87.LnVsop(7.9847E-7, 2.24822372859, 8962.4553499102), new Vsop87.LnVsop(7.2505E-7, 5.84203374239, 242.728603974), new Vsop87.LnVsop(7.2945E-7, 2.50193599662, 951.7184062506), new Vsop87.LnVsop(7.149E-7, 3.85645759558, 2914.0142358238), new Vsop87.LnVsop(8.534E-7, 3.90856932983, 553.5694028424), new Vsop87.LnVsop(6.758E-7, 5.0233489507, 382.8965322232), new Vsop87.LnVsop(6.506E-7, 1.01810963274, 3340.5951730476), new Vsop87.LnVsop(6.5061E-7, 3.04888114328, 3340.629680352), new Vsop87.LnVsop(6.1478E-7, 4.15185188249, 3149.1641605882), new Vsop87.LnVsop(4.8482E-7, 4.87339233007, 213.299095438), new Vsop87.LnVsop(4.6581E-7, 1.31461442691, 3185.1920272656), new Vsop87.LnVsop(5.6642E-7, 3.88772102421, 4136.9104335162), new Vsop87.LnVsop(4.7615E-7, 1.18228660215, 3333.498879699), new Vsop87.LnVsop(4.2052E-7, 5.30826745759, 20043.6745601988), new Vsop87.LnVsop(4.133E-7, 0.71392238704, 1592.5960136328), new Vsop87.LnVsop(4.028E-7, 2.72571311592, 7.1135470008), new Vsop87.LnVsop(3.304E-7, 5.40823104809, 6283.0758499914), new Vsop87.LnVsop(2.8676E-7, 0.04305323493, 9492.1463150048), new Vsop87.LnVsop(2.2322E-7, 5.86718681699, 3870.3033917944), new Vsop87.LnVsop(2.2432E-7, 5.46596961275, 20.3553193988), new Vsop87.LnVsop(2.2606E-7, 0.83782540818, 3097.88382272579), new Vsop87.LnVsop(2.1416E-7, 5.37936489667, 3340.545116397), new Vsop87.LnVsop(2.3347E-7, 6.167744339, 3532.0606928114), new Vsop87.LnVsop(2.6573E-7, 3.8900063113, 1221.8485663214), new Vsop87.LnVsop(2.28E-7, 1.54501542908, 2274.1169495098), new Vsop87.LnVsop(2.0474E-7, 2.3623686167, 1589.0728952838), new Vsop87.LnVsop(2.0179E-7, 3.36390759347, 5088.6288397668), new Vsop87.LnVsop(2.0013E-7, 2.57546546037, 12303.06777661), new Vsop87.LnVsop(1.992E-7, 0.44761063096, 6677.7017350506), new Vsop87.LnVsop(2.655E-7, 5.11303525089, 2700.7151403858), new Vsop87.LnVsop(2.1104E-7, 3.52541056271, 15.252471185), new Vsop87.LnVsop(2.1424E-7, 4.97083417225, 3340.6797370026), new Vsop87.LnVsop(1.8502E-7, 5.57854926842, 1990.745017041), new Vsop87.LnVsop(1.7805E-7, 6.12513609945, 4292.3308329504), new Vsop87.LnVsop(1.6463E-7, 2.60307709195, 3341.592747768), new Vsop87.LnVsop(1.6592E-7, 1.25515357212, 3894.1818295422), new Vsop87.LnVsop(1.9864E-7, 2.52765519587, 4399.994356889), new Vsop87.LnVsop(1.5002E-7, 1.03518790208, 2288.3440435114), new Vsop87.LnVsop(2.0011E-7, 4.73112374598, 4690.4798363586), new Vsop87.LnVsop(1.5431E-7, 2.46932776517, 4535.0594369244), new Vsop87.LnVsop(2.0193E-7, 5.78561467842, 7079.3738568078), new Vsop87.LnVsop(1.5298E-7, 2.26504738206, 3723.508958923), new Vsop87.LnVsop(1.5019E-7, 3.36690751539, 6681.2421070518), new Vsop87.LnVsop(1.3219E-7, 5.61412860968, 10025.3603984484), new Vsop87.LnVsop(1.3517E-7, 2.12392880454, 5486.777843175), new Vsop87.LnVsop(1.5019E-7, 1.33613594479, 6681.2075997474), new Vsop87.LnVsop(1.2676E-7, 2.95036175206, 3496.032826134), new Vsop87.LnVsop(1.3644E-7, 1.97710249337, 5614.7293762096), new Vsop87.LnVsop(1.3011E-7, 1.51458564766, 5628.9564702112), new Vsop87.LnVsop(1.1353E-7, 6.23411904718, 135.0650800354), new Vsop87.LnVsop(1.3508E-7, 3.42721826602, 5621.8429232104), new Vsop87.LnVsop(1.0866E-7, 5.28165480979, 2818.035008606), new Vsop87.LnVsop(1.188E-7, 3.12847055823, 426.598190876), new Vsop87.LnVsop(1.0467E-7, 2.7359860705, 2787.0430238574), new Vsop87.LnVsop(1.1131E-7, 5.84122566289, 2803.8079146044), new Vsop87.LnVsop(1.177E-7, 2.58277425311, 8432.7643848156), new Vsop87.LnVsop(1.1861E-7, 5.47552055459, 3553.9115221378), new Vsop87.LnVsop(8.54E-8, 1.91739325491, 11773.3768115154), new Vsop87.LnVsop(9.819E-8, 4.52958330672, 6489.776587288), new Vsop87.LnVsop(8.552E-8, 3.16147568714, 162.4666361322), new Vsop87.LnVsop(1.0957E-7, 4.15775327007, 2388.8940204492), new Vsop87.LnVsop(8.948E-8, 4.23164385777, 7477.522860216), new Vsop87.LnVsop(8.131E-8, 1.61308074119, 2957.7158944766), new Vsop87.LnVsop(8.352E-8, 2.18475645206, 23.8784377478), new Vsop87.LnVsop(8.03E-8, 5.69889507906, 6041.3275670856), new Vsop87.LnVsop(7.878E-8, 5.71359767892, 9623.6882766912), new Vsop87.LnVsop(8.713E-8, 4.43300582398, 5092.1519581158), new Vsop87.LnVsop(8.421E-8, 3.1635506725, 3347.7259737006), new Vsop87.LnVsop(6.67E-8, 5.07423317095, 8031.0922630584), new Vsop87.LnVsop(8.656E-8, 4.33239148117, 3339.6321056316), new Vsop87.LnVsop(7.354E-8, 6.17934256606, 3583.3410306738), new Vsop87.LnVsop(5.749E-8, 3.67719823582, 8429.2412664666), new Vsop87.LnVsop(6.235E-8, 3.54003325209, 692.1576012268), new Vsop87.LnVsop(5.458E-8, 1.05139431657, 4933.2084403326), new Vsop87.LnVsop(6.132E-8, 1.66182646558, 6525.8044539654), new Vsop87.LnVsop(5.197E-8, 1.14841109166, 28.4491874678), new Vsop87.LnVsop(4.95E-8, 5.28919125231, 6681.2921637024), new Vsop87.LnVsop(5.516E-8, 6.12492946392, 2487.4160449478), new Vsop87.LnVsop(4.89E-8, 3.10255139433, 5.5229243074), new Vsop87.LnVsop(5.354E-8, 0.37154896863, 12832.7587417046), new Vsop87.LnVsop(4.751E-8, 0.2337468155, 36.0278666774), new Vsop87.LnVsop(6.362E-8, 2.11339432269, 5884.9268465832), new Vsop87.LnVsop(4.996E-8, 2.44835744792, 5099.2655051166), new Vsop87.LnVsop(4.952E-8, 5.69770765577, 6681.1575430968), new Vsop87.LnVsop(4.678E-8, 0.27799012787, 10018.3141617504), new Vsop87.LnVsop(4.746E-8, 0.00950199989, 7210.9158184942), new Vsop87.LnVsop(4.862E-8, 5.60331599025, 6467.9257579616), new Vsop87.LnVsop(5.544E-8, 2.00929051393, 522.5774180938), new Vsop87.LnVsop(4.998E-8, 1.51094959078, 1744.4259844152), new Vsop87.LnVsop(5.397E-8, 0.1884215497, 2942.4634232916), new Vsop87.LnVsop(4.098E-8, 3.95776844736, 3.881335358), new Vsop87.LnVsop(5.414E-8, 5.66147396313, 23384.2869868986), new Vsop87.LnVsop(5.467E-8, 0.19258681316, 7632.9432596502), new Vsop87.LnVsop(4.305E-8, 2.8945229483, 2810.9214616052), new Vsop87.LnVsop(4.118E-8, 1.59475420886, 7234.794256242), new Vsop87.LnVsop(4.489E-8, 4.16951490492, 2906.900688823), new Vsop87.LnVsop(5.277E-8, 2.22681020305, 3127.3133312618), new Vsop87.LnVsop(3.882E-8, 2.26433789475, 2699.7348193176), new Vsop87.LnVsop(3.544E-8, 1.76658498504, 1758.6530784168), new Vsop87.LnVsop(3.408E-8, 2.65743533541, 4929.6853219836), new Vsop87.LnVsop(4.336E-8, 4.43081904792, 640.8776073822), new Vsop87.LnVsop(3.804E-8, 2.91373968131, 15643.6802033098), new Vsop87.LnVsop(3.176E-8, 1.75893480952, 9595.2390892234), new Vsop87.LnVsop(3.309E-8, 6.13831291678, 10419.9862835076), new Vsop87.LnVsop(3.077E-8, 2.56194751001, 7064.1213856228), new Vsop87.LnVsop(3.236E-8, 2.32387839882, 5085.038411115), new Vsop87.LnVsop(3.284E-8, 2.8621647971, 7740.6067835888), new Vsop87.LnVsop(2.958E-8, 1.27767445188, 574.3447983348), new Vsop87.LnVsop(2.805E-8, 0.43144651568, 5828.0284716476), new Vsop87.LnVsop(2.851E-8, 0.98625869565, 3191.0492295652), new Vsop87.LnVsop(3.324E-8, 2.5901098785, 2118.7638603784), new Vsop87.LnVsop(3.039E-8, 1.86739127757, 7.046236698), new Vsop87.LnVsop(2.738E-8, 1.76460911547, 639.897286314), new Vsop87.LnVsop(2.757E-8, 3.70511041849, 10021.8545337516), new Vsop87.LnVsop(3.376E-8, 1.53123149565, 6674.1113063988), new Vsop87.LnVsop(2.757E-8, 1.67433972403, 10021.8200264472), new Vsop87.LnVsop(2.67E-8, 3.11556212899, 6836.6452528338), new Vsop87.LnVsop(2.583E-8, 3.77302627584, 2921.1277828246), new Vsop87.LnVsop(2.51E-8, 0.30461555756, 3475.6775067352), new Vsop87.LnVsop(2.288E-8, 2.81266012379, 7875.6718636242), new Vsop87.LnVsop(2.411E-8, 0.97123911611, 3319.8370312074), new Vsop87.LnVsop(2.41E-8, 2.95969382172, 6682.2051744678), new Vsop87.LnVsop(2.211E-8, 0.61268074323, 10973.55568635), new Vsop87.LnVsop(2.246E-8, 4.12573972297, 59.3738619136), new Vsop87.LnVsop(2.183E-8, 2.17530786579, 15113.9892382152), new Vsop87.LnVsop(2.445E-8, 5.91435376684, 5331.3574437408), new Vsop87.LnVsop(1.944E-8, 5.47623245699, 11371.7046897582), new Vsop87.LnVsop(2.39E-8, 3.87952069289, 3355.8648978848), new Vsop87.LnVsop(1.904E-8, 5.11178589044, 1066.49547719), new Vsop87.LnVsop(2.302E-8, 1.1594003952, 3320.257107301), new Vsop87.LnVsop(1.955E-8, 5.88703346758, 6894.5239488376), new Vsop87.LnVsop(1.837E-8, 3.07635198966, 3325.3599555148), new Vsop87.LnVsop(2.131E-8, 2.9961000751, 6254.6266625236), new Vsop87.LnVsop(1.807E-8, 4.98332871905, 1648.4467571974), new Vsop87.LnVsop(2.133E-8, 1.91321292871, 8969.568896911), new Vsop87.LnVsop(1.936E-8, 3.55090266368, 3767.2106175758), new Vsop87.LnVsop(1.989E-8, 5.37314833955, 206.1855484372), new Vsop87.LnVsop(1.674E-8, 5.49537183178, 266.6070417218), new Vsop87.LnVsop(1.732E-8, 1.81246269542, 536.8045120954), new Vsop87.LnVsop(1.645E-8, 1.32190162152, 3264.3463554242), new Vsop87.LnVsop(1.715E-8, 3.2568261147, 7903.073419721), new Vsop87.LnVsop(1.56E-8, 5.75414697537, 3360.96774609859), new Vsop87.LnVsop(1.581E-8, 1.72981711161, 3134.4268782626), new Vsop87.LnVsop(1.498E-8, 4.89621878281, 9830.3890139878), new Vsop87.LnVsop(1.549E-8, 5.85472144829, 20.7753954924), new Vsop87.LnVsop(1.685E-8, 2.43562432843, 3120.199784261), new Vsop87.LnVsop(1.548E-8, 1.54152974975, 8425.6508378148), new Vsop87.LnVsop(2.012E-8, 5.94532644656, 13365.9728251482), new Vsop87.LnVsop(1.972E-8, 3.1153440651, 3361.3878221922), new Vsop87.LnVsop(1.391E-8, 2.24268252285, 3344.2028553516), new Vsop87.LnVsop(1.369E-8, 3.07997599503, 6127.6554505572), new Vsop87.LnVsop(1.365E-8, 4.5797941981, 10818.1352869158), new Vsop87.LnVsop(1.361E-8, 1.18605362322, 14584.2982731206), new Vsop87.LnVsop(1.376E-8, 5.49004047305, 170.6728706192), new Vsop87.LnVsop(1.739E-8, 2.01930737454, 10575.4066829418), new Vsop87.LnVsop(1.699E-8, 5.6367309708, 6158.6474353058), new Vsop87.LnVsop(1.291E-8, 5.91024520902, 9808.5381846614), new Vsop87.LnVsop(1.399E-8, 1.81907706393, 3337.021998048), new Vsop87.LnVsop(1.413E-8, 4.5028539408, 5729.506447149), new Vsop87.LnVsop(1.481E-8, 6.04716796278, 12964.300703391), new Vsop87.LnVsop(1.218E-8, 0.82624604661, 419.4846438752), new Vsop87.LnVsop(1.406E-8, 1.0508907545, 6438.4962494256), new Vsop87.LnVsop(1.19E-8, 3.52559223977, 6688.3384004004), new Vsop87.LnVsop(1.263E-8, 1.48624507606, 8439.8779318164), new Vsop87.LnVsop(1.145E-8, 4.89771219093, 220.4126424388), new Vsop87.LnVsop(1.131E-8, 6.19294401266, 6144.4203413042), new Vsop87.LnVsop(1.156E-8, 2.23033209084, 8955.3418029094), new Vsop87.LnVsop(1.128E-8, 3.44445874016, 10177.2576795336), new Vsop87.LnVsop(1.144E-8, 5.2992220293, 27.4015560968), new Vsop87.LnVsop(1.098E-8, 2.82106200873, 4569.574540022), new Vsop87.LnVsop(1.271E-8, 4.58458799479, 6247.5131155228), new Vsop87.LnVsop(1.352E-8, 2.14065534125, 11243.6858464208), new Vsop87.LnVsop(1.297E-8, 0.44389550166, 87.30820453981), new Vsop87.LnVsop(1.118E-8, 1.96366629239, 6298.3283211764), new Vsop87.LnVsop(1.065E-8, 2.8985367324, 10404.7338123226), new Vsop87.LnVsop(1.027E-8, 4.79279924388, 3914.9572250346), new Vsop87.LnVsop(1.034E-8, 3.73200738994, 10213.285546211), new Vsop87.LnVsop(1.152E-8, 4.14340380812, 6261.7402095244), new Vsop87.LnVsop(9.93E-9, 0.22568223151, 3230.4061054804), new Vsop87.LnVsop(1.305E-8, 3.67646278246, 2301.58581590939), new Vsop87.LnVsop(1.138E-8, 5.11767079744, 4562.4609930212), new Vsop87.LnVsop(9.22E-9, 0.46241803393, 13358.9265884502), new Vsop87.LnVsop(1.275E-8, 5.14327521504, 2693.601593385), new Vsop87.LnVsop(9.12E-9, 1.2313366516, 103.0927742186), new Vsop87.LnVsop(9.53E-9, 1.52860938585, 3369.0616141676), new Vsop87.LnVsop(1.009E-8, 3.29653387473, 3178.1457905676), new Vsop87.LnVsop(8.93E-9, 1.35062914664, 1214.7350193206), new Vsop87.LnVsop(9.18E-9, 2.45577302887, 13916.0191096416), new Vsop87.LnVsop(9.69E-9, 1.69080418858, 43.718912305), new Vsop87.LnVsop(8.96E-9, 5.62906563965, 10021.9045904022), new Vsop87.LnVsop(8.53E-9, 5.94370893753, 12168.0026965746), new Vsop87.LnVsop(9.31E-9, 0.24120697444, 6923.9534573736), new Vsop87.LnVsop(9.12E-9, 1.10368236991, 29.429508536), new Vsop87.LnVsop(8.16E-9, 4.65205672982, 2707.8286873866), new Vsop87.LnVsop(8.01E-9, 4.81849322003, 533.2140834436), new Vsop87.LnVsop(7.64E-9, 6.08667124637, 2384.3232707292), new Vsop87.LnVsop(7.53E-9, 1.03238937619, 14314.1681130498), new Vsop87.LnVsop(7.57E-9, 2.06149804917, 12935.8515159232), new Vsop87.LnVsop(9.24E-9, 0.69558587744, 16173.3711684044), new Vsop87.LnVsop(7.86E-9, 3.91108639997, 9225.539273283), new Vsop87.LnVsop(6.97E-9, 4.07135509749, 5202.3582793352), new Vsop87.LnVsop(8.94E-9, 6.03747462616, 10021.7699697966), new Vsop87.LnVsop(8.14E-9, 2.01020002407, 9866.4168806652), new Vsop87.LnVsop(8.71E-9, 4.45409720021, 3316.733988952), new Vsop87.LnVsop(6.94E-9, 6.01416161518, 26724.8994135984), new Vsop87.LnVsop(7.44E-9, 1.39400789085, 8273.8208670324), new Vsop87.LnVsop(6.66E-9, 3.02544526662, 1039.0266107904), new Vsop87.LnVsop(7.27E-9, 3.27505135694, 18984.2926300096), new Vsop87.LnVsop(6.54E-9, 2.83655009806, 107.6635239386), new Vsop87.LnVsop(6.8E-9, 1.98065653254, 1228.9621133222), new Vsop87.LnVsop(8.29E-9, 0.36839516637, 10551.528245194), new Vsop87.LnVsop(5.85E-9, 0.10314990118, 111.1866422876), new Vsop87.LnVsop(5.66E-9, 1.59185176054, 2391.43681773), new Vsop87.LnVsop(5.55E-9, 2.70920251256, 4555.3474460204), new Vsop87.LnVsop(6.96E-9, 2.89495274268, 2648.454825473), new Vsop87.LnVsop(5.32E-9, 5.65094737994, 6034.2140200848), new Vsop87.LnVsop(5.57E-9, 5.0872986396, 1903.4368125012), new Vsop87.LnVsop(5.7E-9, 4.5989669704, 6680.2445323314), new Vsop87.LnVsop(5.19E-9, 0.20293365239, 13760.5987102074), new Vsop87.LnVsop(6.97E-9, 3.87262209056, 13517.8701062334), new Vsop87.LnVsop(5.06E-9, 3.20689286673, 11081.2192102886), new Vsop87.LnVsop(5.18E-9, 2.85627321259, 5459.3762870782), new Vsop87.LnVsop(6.42E-9, 5.19540766185, 6048.4411140864), new Vsop87.LnVsop(4.9E-9, 2.42075152031, 3364.4908644476), new Vsop87.LnVsop(6.71E-9, 3.6937965496, 3335.0895023924), new Vsop87.LnVsop(5.26E-9, 0.23465052151, 51.28033786241), new Vsop87.LnVsop(4.83E-9, 1.56485227643, 1964.838626854), new Vsop87.LnVsop(4.96E-9, 4.31353927165, 3344.4937620578), new Vsop87.LnVsop(4.91E-9, 2.51033279488, 3863.1898447936), new Vsop87.LnVsop(4.8E-9, 0.13049600948, 66.4874089144), new Vsop87.LnVsop(4.66E-9, 2.03124918036, 13362.432453147), new Vsop87.LnVsop(5.15E-9, 0.65638901827, 853.196381752), new Vsop87.LnVsop(4.69E-9, 4.06128608413, 13362.4669604514), new Vsop87.LnVsop(5.27E-9, 2.98225968203, 8270.2977486834), new Vsop87.LnVsop(5.21E-9, 2.76200215969, 3503.079062832), new Vsop87.LnVsop(4.44E-9, 5.59711849258, 149.5631971346), new Vsop87.LnVsop(5.33E-9, 4.77159034151, 1118.7557921028), new Vsop87.LnVsop(4.72E-9, 3.43923570864, 6702.000248892), new Vsop87.LnVsop(4.38E-9, 4.83084543348, 3116.2676309979), new Vsop87.LnVsop(5.48E-9, 2.01123370738, 7910.1869667218), new Vsop87.LnVsop(5.56E-9, 5.67119913446, 227.476132789), new Vsop87.LnVsop(4.31E-9, 4.30019479176, 16858.4825329332), new Vsop87.LnVsop(4.19E-9, 2.79762011157, 433.7117378768), new Vsop87.LnVsop(4.01E-9, 0.05451452688, 3304.5845600224), new Vsop87.LnVsop(4.12E-9, 5.3091268685, 13119.72110282519), new Vsop87.LnVsop(4.25E-9, 5.70380839964, 21.8508293264), new Vsop87.LnVsop(5.33E-9, 1.30269896597, 6660.4494579072), new Vsop87.LnVsop(3.88E-9, 2.06108898302, 3347.6586633978), new Vsop87.LnVsop(3.84E-9, 4.98893020891, 9779.1086761254), new Vsop87.LnVsop(4.57E-9, 2.53527558609, 74.7815985673), new Vsop87.LnVsop(3.8E-9, 2.30167509056, 12310.1813236108), new Vsop87.LnVsop(5.14E-9, 5.84621491771, 1052.2683831884), new Vsop87.LnVsop(4.62E-9, 5.12519318874, 1596.1864422846), new Vsop87.LnVsop(4.15E-9, 4.75348299971, 3981.490034082), new Vsop87.LnVsop(3.64E-9, 3.73442995257, 5518.7501489918), new Vsop87.LnVsop(3.63E-9, 0.1326682908, 56.8983749356), new Vsop87.LnVsop(3.9E-9, 1.46647444308, 17924.9106998204), new Vsop87.LnVsop(3.61E-9, 5.86612779191, 3607.2194684216), new Vsop87.LnVsop(4.87E-9, 0.65743461993, 3376.6402933772), new Vsop87.LnVsop(3.51E-9, 2.12025274391, 6677.6344247478), new Vsop87.LnVsop(3.53E-9, 2.90104988988, 17256.6315363414), new Vsop87.LnVsop(3.88E-9, 2.23321423606, 3980.5097130138), new Vsop87.LnVsop(3.98E-9, 1.78984684395, 7895.9598727202), new Vsop87.LnVsop(4.42E-9, 0.18839686258, 9381.9399937854), new Vsop87.LnVsop(4.33E-9, 0.64407497214, 6816.289933435), new Vsop87.LnVsop(3.37E-9, 6.13758619135, 5724.935697429), new Vsop87.LnVsop(3.34E-9, 4.08486685558, 664.75604513), new Vsop87.LnVsop(3.42E-9, 5.95706448244, 3546.797975137), new Vsop87.LnVsop(3.23E-9, 5.05251614034, 3237.5196524812), new Vsop87.LnVsop(4.28E-9, 2.50147052863, 18454.601664915), new Vsop87.LnVsop(3.24E-9, 2.91824505937, 8329.671610597), new Vsop87.LnVsop(3.24E-9, 5.04026639944, 36.6053653042), new Vsop87.LnVsop(3.54E-9, 0.00835534987, 8671.9698704406), new Vsop87.LnVsop(3.12E-9, 6.23345945902, 10235.1363755374), new Vsop87.LnVsop(3.13E-9, 4.22789830697, 6696.4773245846), new Vsop87.LnVsop(3.18E-9, 2.57296798825, 6684.8152820514), new Vsop87.LnVsop(2.92E-9, 3.8655573199, 7107.8230442756), new Vsop87.LnVsop(2.91E-9, 0.5694460923, 17395.2197347258), new Vsop87.LnVsop(3.37E-9, 5.13820375946, 7255.5696517344), new Vsop87.LnVsop(3.02E-9, 0.0124470975, 16706.585251848), new Vsop87.LnVsop(3.21E-9, 3.15062035676, 11216.284290324), new Vsop87.LnVsop(2.82E-9, 2.94441896021, 3415.3940252671), new Vsop87.LnVsop(2.84E-9, 2.67994400271, 3877.4169387952), new Vsop87.LnVsop(2.84E-9, 4.30043162266, 6872.6731195112), new Vsop87.LnVsop(2.94E-9, 0.79614923862, 11236.57229942), new Vsop87.LnVsop(2.83E-9, 6.16331963812, 3973.396166013), new Vsop87.LnVsop(2.71E-9, 1.75726306886, 11780.4903585162), new Vsop87.LnVsop(2.77E-9, 1.66035763583, 1692.1656695024), new Vsop87.LnVsop(3.47E-9, 3.31414555314, 10022.8176011676), new Vsop87.LnVsop(2.66E-9, 4.42395281214, 310.8407988684), new Vsop87.LnVsop(2.75E-9, 2.22690392814, 3017.1070100424), new Vsop87.LnVsop(2.71E-9, 3.58728506623, 128.0188433374), new Vsop87.LnVsop(2.97E-9, 0.72303002154, 155.3530891314), new Vsop87.LnVsop(3.36E-9, 0.16930486161, 5618.3198048614), new Vsop87.LnVsop(3.37E-9, 5.6830024225, 16460.33352952499), new Vsop87.LnVsop(2.91E-9, 1.50442579957, 6660.8695340008), new Vsop87.LnVsop(2.59E-9, 5.95159516658, 9499.2598620056), new Vsop87.LnVsop(3.35E-9, 3.36336210503, 5625.3660415594), new Vsop87.LnVsop(2.54E-9, 0.39614279218, 12721.572099417), new Vsop87.LnVsop(2.88E-9, 5.47663257768, 9168.6408983474), new Vsop87.LnVsop(3.07E-9, 2.33271870436, 3281.2385647862), new Vsop87.LnVsop(2.39E-9, 3.70517047494, 7373.3824546264), new Vsop87.LnVsop(3.21E-9, 4.53899078143, 2178.137722292), new Vsop87.LnVsop(2.61E-9, 2.58831740384, 3336.7310913418), new Vsop87.LnVsop(2.36E-9, 6.23036203287, 15508.6151232744), new Vsop87.LnVsop(2.79E-9, 0.14319124816, 16304.9131300908), new Vsop87.LnVsop(2.36E-9, 0.7917583564, 16062.1845261168), new Vsop87.LnVsop(2.58E-9, 6.10999116266, 2480.302497947), new Vsop87.LnVsop(2.43E-9, 5.45663643819, 4407.1079038898), new Vsop87.LnVsop(2.31E-9, 5.38613602278, 76.2660712756), new Vsop87.LnVsop(2.33E-9, 6.15567163053, 19800.9459562248), new Vsop87.LnVsop(3.03E-9, 5.35509551879, 2766.267628365), new Vsop87.LnVsop(2.33E-9, 5.25492090129, 13171.0014406876), new Vsop87.LnVsop(2.19E-9, 5.84025523264, 13936.794505134), new Vsop87.LnVsop(2.23E-9, 1.46266096304, 15110.4661198662), new Vsop87.LnVsop(2.26E-9, 2.27377580587, 6784.3176276182), new Vsop87.LnVsop(2.47E-9, 2.27156183441, 110.2063212194), new Vsop87.LnVsop(2.13E-9, 0.21404637687, 1505.28780909299), new Vsop87.LnVsop(2.65E-9, 5.18121091844, 3205.5473466644), new Vsop87.LnVsop(2.09E-9, 6.21251768752, 3253.30422216), new Vsop87.LnVsop(2.72E-9, 2.89521727496, 10713.9948813262), new Vsop87.LnVsop(2.31E-9, 3.72569036661, 3346.1353510072), new Vsop87.LnVsop(2.38E-9, 4.55410082039, 9602.3526362242), new Vsop87.LnVsop(2.72E-9, 0.00364811322, 9380.9596727172), new Vsop87.LnVsop(2.24E-9, 3.08775924389, 401.6721217572), new Vsop87.LnVsop(2.01E-9, 3.36695295492, 6.6836638741), new Vsop87.LnVsop(2.63E-9, 1.39193044768, 14054.607308026), new Vsop87.LnVsop(2.06E-9, 6.19734429375, 13149.1506113612), new Vsop87.LnVsop(2.32E-9, 5.50578916585, 10596.1820784342), new Vsop87.LnVsop(1.98E-9, 3.32452831163, 3657.0042963564), new Vsop87.LnVsop(1.95E-9, 0.9941228744, 5642.1982426092), new Vsop87.LnVsop(2.11E-9, 2.85375232515, 5415.6573747732), new Vsop87.LnVsop(1.93E-9, 4.26912883997, 6546.1597733642), new Vsop87.LnVsop(2.26E-9, 5.32794817315, 3561.0250691386), new Vsop87.LnVsop(1.99E-9, 4.59761896582, 12566.1516999828), new Vsop87.LnVsop(1.98E-9, 1.12349271227, 685.044054226), new Vsop87.LnVsop(2.21E-9, 0.64659560722, 11250.7993934216), new Vsop87.LnVsop(1.84E-9, 1.10571356803, 12722.5524204852), new Vsop87.LnVsop(2.53E-9, 2.11492151988, 6475.0393049624), new Vsop87.LnVsop(2.25E-9, 4.49528012077, 589.0648270082), new Vsop87.LnVsop(1.9E-9, 1.45410333749, 4885.9664096786), new Vsop87.LnVsop(1.81E-9, 1.29030762994, 6606.4432548323), new Vsop87.LnVsop(1.77E-9, 2.86991818914, 6460.8122109608), new Vsop87.LnVsop(1.84E-9, 5.69456453371, 3351.2490920496), new Vsop87.LnVsop(2.04E-9, 6.20934241396, 394.6258850592), new Vsop87.LnVsop(1.76E-9, 2.43571632942, 3603.6963500726), new Vsop87.LnVsop(2.25E-9, 0.81972180876, 3265.8308281325), new Vsop87.LnVsop(1.75E-9, 4.65571344916, 20199.094959633), new Vsop87.LnVsop(1.74E-9, 3.67069603032, 735.8765135318), new Vsop87.LnVsop(1.73E-9, 1.93062911477, 11766.2632645146), new Vsop87.LnVsop(1.84E-9, 4.77203925989, 286.9623611206), new Vsop87.LnVsop(1.68E-9, 5.10734096993, 1332.0548875408), new Vsop87.LnVsop(1.66E-9, 1.59679231445, 1437.1756141986), new Vsop87.LnVsop(1.74E-9, 6.26980383875, 17277.4069318338), new Vsop87.LnVsop(1.91E-9, 0.60250751218, 56.8032621698), new Vsop87.LnVsop(1.69E-9, 1.38625780562, 8982.810669309), new Vsop87.LnVsop(1.61E-9, 0.43339852368, 5820.9149246468), new Vsop87.LnVsop(2.1E-9, 3.10717635656, 4039.8835749274), new Vsop87.LnVsop(1.87E-9, 4.52578270109, 8542.970706035), new Vsop87.LnVsop(1.55E-9, 1.41249963094, 22.7684966094), new Vsop87.LnVsop(2.07E-9, 3.41041134401, 931.3630868518), new Vsop87.LnVsop(1.58E-9, 0.58219487339, 158.9435177832), new Vsop87.LnVsop(1.53E-9, 5.14168081601, 156.4007205024), new Vsop87.LnVsop(1.51E-9, 1.93803423293, 3384.3313390048), new Vsop87.LnVsop(1.8E-9, 3.25442053419, 263.0839233728), new Vsop87.LnVsop(1.58E-9, 3.64357924476, 8013.2797409404), new Vsop87.LnVsop(1.62E-9, 4.8931636497, 14158.7477136156), new Vsop87.LnVsop(1.74E-9, 2.72388906334, 2807.3983432562), new Vsop87.LnVsop(1.5E-9, 3.87897267873, 10028.9508271002), new Vsop87.LnVsop(1.86E-9, 1.15738945572, 3169.9395560806), new Vsop87.LnVsop(1.48E-9, 4.90520004562, 9588.1255422226), new Vsop87.LnVsop(1.67E-9, 4.39427844033, 3333.5661900018), new Vsop87.LnVsop(1.93E-9, 5.73713102378, 206.7007372966), new Vsop87.LnVsop(1.65E-9, 1.93680960064, 5732.0492444298), new Vsop87.LnVsop(1.86E-9, 1.22089903563, 19402.7969528166), new Vsop87.LnVsop(1.46E-9, 3.36648330663, 6665.9723822146), new Vsop87.LnVsop(1.42E-9, 4.04273809081, 13553.8979729108), new Vsop87.LnVsop(1.4E-9, 4.81861092474, 9070.1188738488), new Vsop87.LnVsop(1.45E-9, 0.7312898901, 16699.53901514999), new Vsop87.LnVsop(1.38E-9, 5.73205642078, 2277.7073781616), new Vsop87.LnVsop(1.61E-9, 2.92764155222, 5.8572022996), new Vsop87.LnVsop(1.69E-9, 2.41111037995, 16276.463942623), new Vsop87.LnVsop(1.52E-9, 3.41680582541, 9468.267877257), new Vsop87.LnVsop(1.79E-9, 5.27310548931, 3873.8265101434), new Vsop87.LnVsop(1.35E-9, 2.58996373843, 19004.6479494084), new Vsop87.LnVsop(1.82E-9, 4.60114226427, 3329.97576135), new Vsop87.LnVsop(1.44E-9, 3.02314051168, 708.98980227659), new Vsop87.LnVsop(1.37E-9, 2.20453530733, 15664.03552270859), new Vsop87.LnVsop(1.31E-9, 3.48156082643, 367.2243289624), new Vsop87.LnVsop(1.31E-9, 2.00232689987, 10014.7237330986), new Vsop87.LnVsop(1.36E-9, 2.82958453689, 21795.21409161479), new Vsop87.LnVsop(1.45E-9, 0.8507379584, 20735.83216142559), new Vsop87.LnVsop(1.58E-9, 1.48909254724, 29.4918183034), new Vsop87.LnVsop(1.54E-9, 6.13080655647, 6701.5801727984), new Vsop87.LnVsop(1.27E-9, 1.78210744074, 22743.4093795164), new Vsop87.LnVsop(1.35E-9, 0.48019080933, 17085.9586657222), new Vsop87.LnVsop(1.6E-9, 4.24420830253, 4672.6673142406), new Vsop87.LnVsop(1.65E-9, 2.02795177586, 290.4854794696), new Vsop87.LnVsop(1.25E-9, 0.52718806317, 2604.735913168), new Vsop87.LnVsop(1.26E-9, 3.81076672136, 765.7930644464), new Vsop87.LnVsop(1.51E-9, 6.2179374091, 6040.3472460174), new Vsop87.LnVsop(1.52E-9, 0.26011322033, 3443.7052009184), new Vsop87.LnVsop(1.16E-9, 1.79531662513, 647.0108333148), new Vsop87.LnVsop(1.5E-9, 3.38665233039, 1861.7458526354), new Vsop87.LnVsop(1.17E-9, 5.77698467349, 1854.6323056346), new Vsop87.LnVsop(1.51E-9, 1.57283975707, 1107.1388056848), new Vsop87.LnVsop(1.26E-9, 2.00332867825, 699.2711482276), new Vsop87.LnVsop(1.15E-9, 2.46396002289, 7380.4960016272), new Vsop87.LnVsop(1.18E-9, 4.07281676691, 418.504322807), new Vsop87.LnVsop(1.57E-9, 0.85719532138, 2814.4445799542), new Vsop87.LnVsop(1.31E-9, 0.7789848329, 3427.9206312396), new Vsop87.LnVsop(1.55E-9, 1.76656404152, 21265.5231265202), new Vsop87.LnVsop(1.43E-9, 2.39402347563, 5244.049239201), new Vsop87.LnVsop(1.19E-9, 4.81260561532, 6657.3464156518), new Vsop87.LnVsop(1.09E-9, 1.09172723256, 14577.1847261198), new Vsop87.LnVsop(1.11E-9, 1.07296455077, 19513.9835951042), new Vsop87.LnVsop(1.46E-9, 1.88093561859, 6709.6740408674), new Vsop87.LnVsop(1.19E-9, 3.19461525393, 2409.249339848), new Vsop87.LnVsop(1.4E-9, 4.47370193096, 3326.3853326982), new Vsop87.LnVsop(1.1E-9, 0.56397435615, 661.232926781), new Vsop87.LnVsop(1.51E-9, 1.80007988242, 12323.4230960088), new Vsop87.LnVsop(1.11E-9, 4.05380946072, 568.8218740274), new Vsop87.LnVsop(1.45E-9, 3.19579249832, 12295.9542296092), new Vsop87.LnVsop(1.06E-9, 5.69308130144, 14.2270940016), new Vsop87.LnVsop(1.09E-9, 0.08987794346, 13362.3823964964), new Vsop87.LnVsop(1.04E-9, 0.59705862733, 10264.5658840734), new Vsop87.LnVsop(1.08E-9, 0.75325958553, 13892.1406718938), new Vsop87.LnVsop(1.05E-9, 0.76776300263, 3024.2205570432), new Vsop87.LnVsop(1.04E-9, 2.77572446625, 38.1330356378), new Vsop87.LnVsop(1.34E-9, 5.88513782564, 5835.1420186484), new Vsop87.LnVsop(1.04E-9, 6.02722901204, 8827.3902698748), new Vsop87.LnVsop(1.17E-9, 0.45962302033, 9485.032768004), new Vsop87.LnVsop(1.16E-9, 2.37241500836, 11769.8536931664), new Vsop87.LnVsop(1.03E-9, 4.09779389857, 6675.7019290922), new Vsop87.LnVsop(1.0E-9, 3.5942231394, 22324.9050567094), new Vsop87.LnVsop(1.0E-9, 2.78600587468, 8584.6616659008), new Vsop87.LnVsop(9.8E-10, 1.44873204724, 3370.0419352358), new Vsop87.LnVsop(1.31E-9, 1.31335473392, 3313.210870603), new Vsop87.LnVsop(1.11E-9, 3.12463539337, 309.2783226558), new Vsop87.LnVsop(1.25E-9, 1.59601169758, 16063.164847185), new Vsop87.LnVsop(1.06E-9, 3.31839457231, 3399.9862886134), new Vsop87.LnVsop(1.34E-9, 2.91637947295, 57.8786960038), new Vsop87.LnVsop(1.26E-9, 3.59123240877, 6518.7582172674), new Vsop87.LnVsop(1.07E-9, 4.92626332372, 802.3639224462), new Vsop87.LnVsop(9.4E-10, 3.42567049862, 3510.1926098328), new Vsop87.LnVsop(9.3E-10, 0.08710545839, 30065.5118402982), new Vsop87.LnVsop(9.5E-10, 4.48318184985, 21947.1113727), new Vsop87.LnVsop(1.0E-9, 0.94442247285, 3209.0704650134), new Vsop87.LnVsop(9.2E-10, 2.37657622081, 11140.5930722022), new Vsop87.LnVsop(1.02E-9, 0.43593025607, 956.2891559706), new Vsop87.LnVsop(1.13E-9, 3.77204238785, 4989.0591838972), new Vsop87.LnVsop(9.1E-10, 1.83925462893, 2221.856634597), new Vsop87.LnVsop(1.18E-9, 3.04735119564, 22345.2603761082), new Vsop87.LnVsop(1.25E-9, 1.54875495543, 1435.1476617594), new Vsop87.LnVsop(9.2E-10, 3.2193809655, 11670.2840372968), new Vsop87.LnVsop(1.03E-9, 0.11157075549, 11.0457002639), new Vsop87.LnVsop(8.9E-10, 1.89954430876, 15121.102785216), new Vsop87.LnVsop(1.18E-9, 0.293254514, 2945.9865416406), new Vsop87.LnVsop(1.09E-9, 1.23224539875, 10706.8813343254), new Vsop87.LnVsop(9.0E-10, 4.06237471202, 18606.4989460002), new Vsop87.LnVsop(8.6E-10, 3.71580666913, 8859.3625756916), new Vsop87.LnVsop(8.7E-10, 3.39266299009, 6843.6914895318), new Vsop87.LnVsop(1.16E-9, 4.67476277278, 272.6729573516), new Vsop87.LnVsop(8.6E-10, 4.99543708984, 2494.5295919486), new Vsop87.LnVsop(1.14E-9, 3.37332197024, 2938.9403049426), new Vsop87.LnVsop(8.5E-10, 5.55531696679, 3368.0139827966), new Vsop87.LnVsop(1.03E-9, 1.3791144887, 4032.7700279266), new Vsop87.LnVsop(9.2E-10, 2.92389765785, 2067.9314010726), new Vsop87.LnVsop(9.3E-10, 0.34335553468, 13517.8027959306), new Vsop87.LnVsop(1.04E-9, 0.3355173221, 23546.7536230308), new Vsop87.LnVsop(8.5E-10, 5.73127362522, 3340.19235060619), new Vsop87.LnVsop(9.5E-10, 1.14586741202, 10721.108428327), new Vsop87.LnVsop(8.6E-10, 3.17511720396, 11925.2740926006), new Vsop87.LnVsop(1.01E-9, 3.09349019068, 5989.0672521728), new Vsop87.LnVsop(8.4E-10, 2.30320956174, 13207.029307365), new Vsop87.LnVsop(8.6E-10, 5.87459621301, 73.6009559152), new Vsop87.LnVsop(9.7E-10, 2.04984064598, 8226.5788363784), new Vsop87.LnVsop(8.4E-10, 0.78729386249, 146.8116865236), new Vsop87.LnVsop(8.5E-10, 0.06405464192, 24889.5747959916), new Vsop87.LnVsop(8.2E-10, 4.29548487571, 9374.8264467846), new Vsop87.LnVsop(9.0E-10, 0.50928046454, 3274.1250177854), new Vsop87.LnVsop(8.3E-10, 5.16862755373, 6578.132079181), new Vsop87.LnVsop(8.2E-10, 0.45318265916, 16702.9948231962), new Vsop87.LnVsop(8.5E-10, 3.76125083061, 4845.9002357928), new Vsop87.LnVsop(8.8E-10, 2.39227137305, 1062.9050485382), new Vsop87.LnVsop(1.04E-9, 4.9951384245, 1581.959348283), new Vsop87.LnVsop(8.1E-10, 5.89798943131, 16858.41522263039), new Vsop87.LnVsop(8.2E-10, 0.44163602941, 4782.87363546), new Vsop87.LnVsop(1.06E-9, 2.50029020488, 5401.4302807716), new Vsop87.LnVsop(8.6E-10, 3.61631911304, 8965.9784682592), new Vsop87.LnVsop(8.7E-10, 5.68212398189, 1883.0814931024), new Vsop87.LnVsop(9.5E-10, 5.35237938692, 4996.172730898), new Vsop87.LnVsop(7.9E-10, 2.01092788145, 1329.51209026), new Vsop87.LnVsop(7.8E-10, 0.88224980818, 2171.0241752912), new Vsop87.LnVsop(1.05E-9, 2.37775757409, 9638.9407478762), new Vsop87.LnVsop(8.9E-10, 5.33260517891, 2125.8774073792), new Vsop87.LnVsop(7.6E-10, 5.20798256417, 9872.2740829648), new Vsop87.LnVsop(8.3E-10, 0.03796627991, 16703.1294438018), new Vsop87.LnVsop(7.5E-10, 6.26330392154, 27682.1407441564), new Vsop87.LnVsop(9.0E-10, 4.84737761448, 14071.43950907579), new Vsop87.LnVsop(9.4E-10, 4.89545753204, 9389.0535407862), new Vsop87.LnVsop(7.7E-10, 0.0358452151, 20206.141196331), new Vsop87.LnVsop(9.5E-10, 5.93429183368, 13362.517017102), new Vsop87.LnVsop(8.1E-10, 1.00694559686, 16865.5287696312), new Vsop87.LnVsop(7.7E-10, 4.12929175062, 4005.3684718298), new Vsop87.LnVsop(8.2E-10, 1.47379060963, 16.83220104979), new Vsop87.LnVsop(7.3E-10, 4.5913018263, 362.1211367308), new Vsop87.LnVsop(7.4E-10, 3.60955612323, 25685.872802808), new Vsop87.LnVsop(8.4E-10, 2.71424539413, 19617.07636932279), new Vsop87.LnVsop(7.2E-10, 0.01101776823, 3568.0885594888), new Vsop87.LnVsop(7.1E-10, 1.71603072644, 2060.8178540718), new Vsop87.LnVsop(7.2E-10, 1.89061725205, 18451.07854656599), new Vsop87.LnVsop(7.1E-10, 3.22816907346, 3472.1543883862), new Vsop87.LnVsop(7.6E-10, 0.30413402871, 72.0557333548), new Vsop87.LnVsop(7.0E-10, 3.17652165983, 3448.2759506384), new Vsop87.LnVsop(7.7E-10, 3.14666622167, 39601.8919124496), new Vsop87.LnVsop(7.1E-10, 0.33254450188, 23141.5583829246), new Vsop87.LnVsop(7.4E-10, 0.10153043438, 17402.3332817266), new Vsop87.LnVsop(9.0E-10, 0.67485041721, 949.1756089698), new Vsop87.LnVsop(9.6E-10, 1.0230272788, 4106.4054911462), new Vsop87.LnVsop(9.5E-10, 5.15356240747, 1.4844727083), new Vsop87.LnVsop(6.7E-10, 1.00856695957, 17232.7530985936), new Vsop87.LnVsop(6.8E-10, 1.78474324075, 224.3447957019), new Vsop87.LnVsop(7.7E-10, 0.15786375115, 16066.0658614748), new Vsop87.LnVsop(6.6E-10, 1.10881345668, 4459.3682188026), new Vsop87.LnVsop(6.7E-10, 2.14790314493, 6357.7194367422), new Vsop87.LnVsop(9.0E-10, 4.95003467215, 25287.7237993998), new Vsop87.LnVsop(6.4E-10, 6.11245648995, 3362.4632560262), new Vsop87.LnVsop(7.7E-10, 5.57405321128, 16872.642316632), new Vsop87.LnVsop(8.6E-10, 5.95683236658, 37057.5774925662), new Vsop87.LnVsop(6.6E-10, 4.52950779766, 37455.7264959744), new Vsop87.LnVsop(6.3E-10, 0.23107890951, 7314.0085927128), new Vsop87.LnVsop(6.2E-10, 0.01491667995, 41427.4869831788), new Vsop87.LnVsop(6.2E-10, 1.4081900214, 22854.596021804), new Vsop87.LnVsop(6.3E-10, 0.89352294357, 14591.4118201214), new Vsop87.LnVsop(6.1E-10, 4.89984611912, 14867.73751589219), new Vsop87.LnVsop(6.4E-10, 0.16730566121, 14047.4937610252), new Vsop87.LnVsop(6.1E-10, 1.82636377879, 3077.528503327), new Vsop87.LnVsop(6.3E-10, 5.51152998906, 13212.8865096646), new Vsop87.LnVsop(6.2E-10, 4.90444445022, 12082.6551341712), new Vsop87.LnVsop(6.6E-10, 3.88662460547, 45494.58142974879), new Vsop87.LnVsop(6.8E-10, 4.45499690607, 9175.7544453482), new Vsop87.LnVsop(8.2E-10, 3.65822046905, 15265.8865193004), new Vsop87.LnVsop(6.0E-10, 2.78933980763, 20809.4676246452), new Vsop87.LnVsop(6.1E-10, 6.15977712775, 12509.2533250472), new Vsop87.LnVsop(6.8E-10, 5.59792852411, 377.3736079158), new Vsop87.LnVsop(6.9E-10, 3.36380060407, 11610.9101753832), new Vsop87.LnVsop(8.2E-10, 1.06617356055, 24076.4445881254), new Vsop87.LnVsop(6.0E-10, 5.92063607531, 21548.9623692918), new Vsop87.LnVsop(6.2E-10, 5.57785540179, 7214.4389368432), new Vsop87.LnVsop(5.8E-10, 3.3723663401, 4379.6390374902), new Vsop87.LnVsop(7.8E-10, 4.18565643954, 8186.5126624926), new Vsop87.LnVsop(5.9E-10, 1.29208473566, 1214.8023296234), new Vsop87.LnVsop(6.1E-10, 3.57279066469, 14421.8316369884), new Vsop87.LnVsop(5.8E-10, 1.69306371945, 632.7837393132), new Vsop87.LnVsop(5.8E-10, 2.64427715516, 10124.930054318), new Vsop87.LnVsop(5.8E-10, 1.20882508221, 17932.0242468212), new Vsop87.LnVsop(7.2E-10, 3.39739853142, 685.1113645288), new Vsop87.LnVsop(5.8E-10, 0.09532796666, 15849.865751747), new Vsop87.LnVsop(5.7E-10, 2.16099709156, 7366.2689076256), new Vsop87.LnVsop(5.7E-10, 4.31819630987, 95.9792272178), new Vsop87.LnVsop(7.2E-10, 2.28455924531, 9072.6616711296), new Vsop87.LnVsop(5.8E-10, 5.6354043714, 8535.8571590342), new Vsop87.LnVsop(7.8E-10, 1.52916624615, 40000.04091585779), new Vsop87.LnVsop(6.2E-10, 4.14045391856, 604.8497407048), new Vsop87.LnVsop(5.6E-10, 0.36387670928, 20047.1976785478), new Vsop87.LnVsop(5.6E-10, 3.66119573845, 12199.9750023914), new Vsop87.LnVsop(6.2E-10, 3.59357123692, 10184.3039162316), new Vsop87.LnVsop(5.9E-10, 5.91890694566, 6901.6374958384), new Vsop87.LnVsop(5.8E-10, 2.64199428538, 15650.7937503106), new Vsop87.LnVsop(7.5E-10, 0.74459766103, 8742.0427074714), new Vsop87.LnVsop(5.6E-10, 3.4570448797, 38805.59390563319), new Vsop87.LnVsop(5.8E-10, 2.52293214253, 9815.6517316622), new Vsop87.LnVsop(6.9E-10, 6.00335080872, 6531.661656265), new Vsop87.LnVsop(6.0E-10, 5.17254836751, 12410.7313005486), new Vsop87.LnVsop(5.7E-10, 0.16619208391, 40398.189919266), new Vsop87.LnVsop(5.9E-10, 2.26838742711, 10050.2864675672), new Vsop87.LnVsop(6.4E-10, 0.57865576666, 17101.2111369072), new Vsop87.LnVsop(6.6E-10, 6.21390160216, 6947.8318951214), new Vsop87.LnVsop(6.6E-10, 2.37798108787, 16703.0448798468), new Vsop87.LnVsop(6.0E-10, 2.6388671994, 12979.553174576), new Vsop87.LnVsop(5.5E-10, 3.68795284246, 21393.5419698576), new Vsop87.LnVsop(5.7E-10, 5.04754187725, 4140.4335518652), new Vsop87.LnVsop(5.6E-10, 5.01714749908, 485.9720527896), new Vsop87.LnVsop(6.5E-10, 1.51615820934, 5511.636601991), new Vsop87.LnVsop(5.3E-10, 2.87682182133, 7203.8022714934), new Vsop87.LnVsop(5.4E-10, 5.51196184505, 44.6538332402), new Vsop87.LnVsop(6.0E-10, 0.05566921393, 14061.7208550268), new Vsop87.LnVsop(7.4E-10, 3.09019916148, 4025.6564809258), new Vsop87.LnVsop(5.3E-10, 1.21861820918, 4193.8088084518), new Vsop87.LnVsop(5.3E-10, 0.36617711595, 6571.0185321802), new Vsop87.LnVsop(5.6E-10, 0.31114481144, 13532.0298899322), new Vsop87.LnVsop(7.3E-10, 4.66466848719, 6685.1061887576), new Vsop87.LnVsop(6.9E-10, 3.37092084432, 41.5507909848), new Vsop87.LnVsop(5.9E-10, 0.21062650044, 10042.1925994982), new Vsop87.LnVsop(6.3E-10, 4.79535338902, 11883.5831327348), new Vsop87.LnVsop(5.9E-10, 6.14382672737, 8958.9322315612), new Vsop87.LnVsop(5.4E-10, 3.29479602829, 6756.0064519669), new Vsop87.LnVsop(5.3E-10, 6.10868413472, 1612.9513330316), new Vsop87.LnVsop(5.2E-10, 1.96782086064, 1083.260367937), new Vsop87.LnVsop(5.7E-10, 2.10329690885, 27832.0382192832), new Vsop87.LnVsop(6.8E-10, 3.32674804341, 42942.50433914939), new Vsop87.LnVsop(7.1E-10, 6.10818428959, 6691.8615187494), new Vsop87.LnVsop(5.1E-10, 1.61052181458, 3029.7716278314), new Vsop87.LnVsop(5.2E-10, 4.21598878412, 3651.4532255682), new Vsop87.LnVsop(5.0E-10, 3.7565889578, 10042.6126755918), new Vsop87.LnVsop(6.6E-10, 4.4094750559, 16703.07938715119), new Vsop87.LnVsop(5.9E-10, 0.39936411804, 6286.5989683404), new Vsop87.LnVsop(5.9E-10, 5.94433755684, 625.6701923124), new Vsop87.LnVsop(6.4E-10, 3.75824458984, 12808.8803039568), new Vsop87.LnVsop(5.4E-10, 5.28005670295, 28628.3362260996), new Vsop87.LnVsop(5.5E-10, 1.56969289868, 6510.5519827804), new Vsop87.LnVsop(6.9E-10, 4.72581931789, 2011.1003364398), new Vsop87.LnVsop(6.8E-10, 2.6537268604, 816.6533262152), new Vsop87.LnVsop(5.1E-10, 5.11023233159, 9161.5273513466), new Vsop87.LnVsop(6.9E-10, 5.05705760339, 3342.0968994081), new Vsop87.LnVsop(6.2E-10, 0.99909328902, 151.8972810852), new Vsop87.LnVsop(5.3E-10, 2.77399864915, 6705.1032911474), new Vsop87.LnVsop(4.9E-10, 5.16996015474, 4447.7512323846), new Vsop87.LnVsop(4.8E-10, 1.30926541331, 6549.6828917132), new Vsop87.LnVsop(6.6E-10, 4.17738409918, 10020.8569590312), new Vsop87.LnVsop(4.9E-10, 4.86456754827, 12942.965062924), new Vsop87.LnVsop(5.1E-10, 0.55899924741, 1481.4093713452), new Vsop87.LnVsop(5.3E-10, 1.58015179319, 10001.061884607), new Vsop87.LnVsop(4.9E-10, 3.39901522617, 8756.269801473), new Vsop87.LnVsop(4.8E-10, 0.68184984908, 688.6344828778), new Vsop87.LnVsop(4.7E-10, 5.37677881629, 23017.0626579362), new Vsop87.LnVsop(4.8E-10, 3.21020023226, 8799.988713778), new Vsop87.LnVsop(5.5E-10, 0.66677211662, 3318.7615973734), new Vsop87.LnVsop(5.1E-10, 5.74626065807, 1015.6630178842), new Vsop87.LnVsop(4.7E-10, 5.14609845058, 9997.9588423516), new Vsop87.LnVsop(5.0E-10, 3.20917726298, 18052.9295431578), new Vsop87.LnVsop(4.7E-10, 0.74215475102, 422.027441156), new Vsop87.LnVsop(4.7E-10, 3.04095823655, 5408.5438277724), new Vsop87.LnVsop(4.6E-10, 2.71758135355, 10824.2012025456), new Vsop87.LnVsop(5.0E-10, 1.03543551128, 10156.9023601348), new Vsop87.LnVsop(5.0E-10, 0.61655594931, 270.1301600708), new Vsop87.LnVsop(5.1E-10, 2.90067614488, 7799.9806455024), new Vsop87.LnVsop(5.2E-10, 5.31852836645, 21000.9158907568), new Vsop87.LnVsop(5.1E-10, 1.350641911, 3760.097070575), new Vsop87.LnVsop(4.5E-10, 0.31849208255, 14469.588512484), new Vsop87.LnVsop(5.0E-10, 1.65024254407, 4356.275444584), new Vsop87.LnVsop(4.5E-10, 5.58923636699, 4936.7988689844), new Vsop87.LnVsop(4.7E-10, 1.79752124051, 13524.9163429314), new Vsop87.LnVsop(5.8E-10, 1.10099067701, 21150.8133658836), new Vsop87.LnVsop(5.2E-10, 2.49167635685, 17468.8551979454), new Vsop87.LnVsop(4.5E-10, 4.38265710724, 625.6251361972), new Vsop87.LnVsop(4.6E-10, 2.28559740262, 6724.9437657046), new Vsop87.LnVsop(4.5E-10, 4.6164540401, 29.8820436102), new Vsop87.LnVsop(4.4E-10, 4.94032142325, 6414.6178116778), new Vsop87.LnVsop(5.5E-10, 0.07919297482, 6604.958782124), new Vsop87.LnVsop(4.3E-10, 5.65628778837, 16342.9513515374), new Vsop87.LnVsop(4.3E-10, 4.9200827638, 11527.1250891924), new Vsop87.LnVsop(4.3E-10, 3.30986033214, 3468.6312700372), new Vsop87.LnVsop(5.3E-10, 5.43299582587, 9065.5481241288), new Vsop87.LnVsop(4.6E-10, 1.03226923951, 6717.252720077), new Vsop87.LnVsop(4.9E-10, 5.80384883795, 26357.675084636), new Vsop87.LnVsop(4.4E-10, 0.4290357498, 19645.5255567906), new Vsop87.LnVsop(4.5E-10, 3.87298872071, 9859.3706439672), new Vsop87.LnVsop(4.3E-10, 6.05242607837, 382.879278571), new Vsop87.LnVsop(4.5E-10, 0.40077432891, 4133.3873151672), new Vsop87.LnVsop(5.0E-10, 2.59711133278, 6621.850991486), new Vsop87.LnVsop(5.5E-10, 3.37488322634, 4271.9755135516), new Vsop87.LnVsop(4.4E-10, 5.17169605979, 1375.7737998458), new Vsop87.LnVsop(4.7E-10, 5.87192135999, 3490.1756238344), new Vsop87.LnVsop(4.1E-10, 0.46061458225, 12012.5822971404), new Vsop87.LnVsop(4.2E-10, 4.91358277243, 45088.6697556246), new Vsop87.LnVsop(4.4E-10, 5.44858386338, 39048.3225096072), new Vsop87.LnVsop(5.6E-10, 0.32998671067, 16489.763038061), new Vsop87.LnVsop(4.2E-10, 3.68136039137, 13363.4300278674), new Vsop87.LnVsop(4.1E-10, 4.18351878948, 239.205485625), new Vsop87.LnVsop(4.3E-10, 4.97675015615, 6670.5881880498), new Vsop87.LnVsop(4.1E-10, 0.16747184847, 29181.905628942), new Vsop87.LnVsop(5.5E-10, 4.41207846373, 14712.317116458), new Vsop87.LnVsop(4.3E-10, 1.28825253886, 6643.0918177618), new Vsop87.LnVsop(4.7E-10, 4.72697589436, 6666.997759398), new Vsop87.LnVsop(4.1E-10, 1.62359144351, 24491.4257925834), new Vsop87.LnVsop(4.1E-10, 0.08345338645, 12839.8722887054), new Vsop87.LnVsop(4.3E-10, 3.96439822837, 7696.8878712838), new Vsop87.LnVsop(4.4E-10, 0.86899972844, 17388.10618772499), new Vsop87.LnVsop(4.0E-10, 3.10894579374, 34554.8138636676), new Vsop87.LnVsop(5.6E-10, 5.61583520495, 16511.6138673874), new Vsop87.LnVsop(5.2E-10, 3.11577112744, 1162.4747044078), new Vsop87.LnVsop(5.5E-10, 5.48941084697, 18208.349942592), new Vsop87.LnVsop(5.0E-10, 1.65058020951, 11614.4332937322), new Vsop87.LnVsop(3.9E-10, 4.21787836291, 4186.695261451), new Vsop87.LnVsop(3.9E-10, 2.66514604756, 7218.029365495), new Vsop87.LnVsop(4.6E-10, 0.66730374401, 3113.1362939108), new Vsop87.LnVsop(3.9E-10, 0.15854793246, 48300.16010269), new Vsop87.LnVsop(4.1E-10, 5.70248947899, 6106.8800550648), new Vsop87.LnVsop(4.0E-10, 4.05255896019, 19406.6782881746), new Vsop87.LnVsop(4.0E-10, 4.77396367544, 42544.3553357412), new Vsop87.LnVsop(5.3E-10, 3.15301214737, 183.869586902), new Vsop87.LnVsop(3.9E-10, 0.51075209632, 17810.2009391838), new Vsop87.LnVsop(3.9E-10, 1.6265681559, 9947.0556815321), new Vsop87.LnVsop(4.0E-10, 5.62692686678, 26880.3198130326), new Vsop87.LnVsop(3.8E-10, 4.59191939331, 10037.0897512844), new Vsop87.LnVsop(3.8E-10, 3.6657576186, 6997.6167230562), new Vsop87.LnVsop(4.5E-10, 6.15994065455, 3289.33208883739), new Vsop87.LnVsop(4.1E-10, 2.77511547733, 16328.72425753579), new Vsop87.LnVsop(3.8E-10, 1.43009196037, 10787.6303445458), new Vsop87.LnVsop(4.4E-10, 3.57766817797, 14556.8967170238), new Vsop87.LnVsop(4.2E-10, 2.92470448863, 4025.7237912286), new Vsop87.LnVsop(3.6E-10, 5.66533524812, 3511.285297319), new Vsop87.LnVsop(4.6E-10, 5.30655793995, 17499.3601403154), new Vsop87.LnVsop(4.5E-10, 4.15997441733, 36.995590611), new Vsop87.LnVsop(3.7E-10, 3.97235274323, 7.762670716), new Vsop87.LnVsop(4.2E-10, 2.12026198801, 14128.2427712456), new Vsop87.LnVsop(3.6E-10, 2.75306774319, 3450.8187479192), new Vsop87.LnVsop(3.9E-10, 1.63389094852, 1545.3539829788), new Vsop87.LnVsop(4.2E-10, 5.03809379637, 31968.9486527994), new Vsop87.LnVsop(3.7E-10, 1.41975087808, 7447.017917846), new Vsop87.LnVsop(3.9E-10, 5.00412653703, 2540.7913015344), new Vsop87.LnVsop(4.3E-10, 4.22348706116, 13369.5632538), new Vsop87.LnVsop(3.6E-10, 0.53048140495, 176.6937301338), new Vsop87.LnVsop(3.5E-10, 2.25519417749, 19669.33668423559), new Vsop87.LnVsop(4.1E-10, 0.69504492745, 3495.9655158312), new Vsop87.LnVsop(3.6E-10, 5.24607321878, 2679.3794999188), new Vsop87.LnVsop(3.8E-10, 3.14212980126, 30220.9322397324), new Vsop87.LnVsop(3.7E-10, 5.40231426955, 3152.68727893721), new Vsop87.LnVsop(3.6E-10, 1.04457226935, 20426.571092422), new Vsop87.LnVsop(3.5E-10, 0.32478189872, 3499.555944483), new Vsop87.LnVsop(4.8E-10, 2.09368659974, 32920.66705904999), new Vsop87.LnVsop(3.6E-10, 2.63906375223, 8948.2282559086), new Vsop87.LnVsop(3.6E-10, 5.56218018463, 7788.3636590844), new Vsop87.LnVsop(4.1E-10, 0.34392346712, 13575.7488022372), new Vsop87.LnVsop(3.5E-10, 5.1159574911, 7322.1024607818), new Vsop87.LnVsop(3.5E-10, 5.54490491, 9945.5712088238), new Vsop87.LnVsop(4.1E-10, 2.83917412143, 3347.2960905739), new Vsop87.LnVsop(4.1E-10, 4.06132121378, 3929.677253708), new Vsop87.LnVsop(4.3E-10, 4.03006170081, 38086.874556479), new Vsop87.LnVsop(3.5E-10, 3.14536502087, 24150.080051345), new Vsop87.LnVsop(3.6E-10, 3.31106643723, 9329.6796788726), new Vsop87.LnVsop(3.5E-10, 4.64515512748, 9886.772200064), new Vsop87.LnVsop(4.4E-10, 1.03765557298, 20040.15144184979), new Vsop87.LnVsop(4.6E-10, 0.524310649, 28230.18722269139), new Vsop87.LnVsop(4.4E-10, 4.61169478741, 3341.0325027934), new Vsop87.LnVsop(3.4E-10, 2.9501469556, 6652.7756659318), new Vsop87.LnVsop(3.3E-10, 2.51023857323, 2675.8563815698), new Vsop87.LnVsop(3.3E-10, 3.62122540203, 6674.1786167016), new Vsop87.LnVsop(3.3E-10, 3.87873599689, 25665.5174834092), new Vsop87.LnVsop(3.5E-10, 0.31892534784, 6645.1969867222), new Vsop87.LnVsop(3.9E-10, 0.38844155951, 18849.2275499742), new Vsop87.LnVsop(3.1E-10, 3.42450440874, 4403.517475238), new Vsop87.LnVsop(3.2E-10, 1.287278619, 9495.6694333538), new Vsop87.LnVsop(3.7E-10, 2.68901627056, 7321.1221397136), new Vsop87.LnVsop(3.0E-10, 3.11091269619, 9993.3880926316), new Vsop87.LnVsop(3.2E-10, 3.5637890247, 6148.010769956), new Vsop87.LnVsop(3.2E-10, 4.23069713034, 10448.4354709754), new Vsop87.LnVsop(3.8E-10, 4.2135934448, 3312.163239232), new Vsop87.LnVsop(3.6E-10, 0.26736453929, 36659.428489158), new Vsop87.LnVsop(3.1E-10, 1.91001170906, 31172.650645983), new Vsop87.LnVsop(3.0E-10, 1.79692038909, 10001.48196070061), new Vsop87.LnVsop(3.7E-10, 5.48379757539, 3311.18291816379), new Vsop87.LnVsop(3.8E-10, 2.88322299393, 10025.4277087512), new Vsop87.LnVsop(3.5E-10, 5.38142679524, 3185.2593375684), new Vsop87.LnVsop(3.1E-10, 0.35494900654, 10177.1903692308), new Vsop87.LnVsop(2.9E-10, 1.34098342476, 29822.7832363242), new Vsop87.LnVsop(3.0E-10, 1.39448996174, 4825.544916394), new Vsop87.LnVsop(3.1E-10, 2.46180759992, 10018.2468514476), new Vsop87.LnVsop(3.2E-10, 0.41003961929, 3451.7990689874), new Vsop87.LnVsop(2.8E-10, 4.68714611901, 2111.6503133776), new Vsop87.LnVsop(2.9E-10, 3.94252949224, 23958.6317852334), new Vsop87.LnVsop(2.8E-10, 3.38078853114, 32124.36905223359), new Vsop87.LnVsop(3.1E-10, 3.18465833136, 3341.0423098265), new Vsop87.LnVsop(2.9E-10, 2.25225231358, 26084.0218062162), new Vsop87.LnVsop(3.3E-10, 3.49105794187, 3774.3241645766), new Vsop87.LnVsop(3.3E-10, 1.717681926, 34911.412076091), new Vsop87.LnVsop(3.7E-10, 5.42512626922, 31022.7531708562), new Vsop87.LnVsop(2.7E-10, 0.98751632143, 16335.8378045366), new Vsop87.LnVsop(2.7E-10, 5.29268187817, 29698.2875113358), new Vsop87.LnVsop(3.0E-10, 5.4539830997, 8646.0634802536), new Vsop87.LnVsop(2.9E-10, 0.21596596499, 20213.25474333179), new Vsop87.LnVsop(2.7E-10, 2.67440637509, 16547.6417340648), new Vsop87.LnVsop(2.7E-10, 2.31773999101, 6688.2710900976), new Vsop87.LnVsop(2.6E-10, 2.05025380662, 5562.4690612968), new Vsop87.LnVsop(2.6E-10, 3.28284041047, 2075.0449480734), new Vsop87.LnVsop(2.6E-10, 5.0034215393, 48429.2821823244), new Vsop87.LnVsop(2.6E-10, 3.79854522408, 12306.590894959), new Vsop87.LnVsop(2.6E-10, 1.89599447067, 13341.6743113068), new Vsop87.LnVsop(3.5E-10, 1.72244330701, 24606.13555322), new Vsop87.LnVsop(2.6E-10, 4.44769438876, 10016.314355792), new Vsop87.LnVsop(2.7E-10, 0.93597359176, 13605.1783107732), new Vsop87.LnVsop(2.6E-10, 5.00365698783, 13355.3361597984), new Vsop87.LnVsop(3.1E-10, 6.27193804892, 1485.9801210652), new Vsop87.LnVsop(3.5E-10, 0.76911517486, 6155.057006654), new Vsop87.LnVsop(2.7E-10, 1.27122182637, 6364.832983743), new Vsop87.LnVsop(2.6E-10, 5.558976832, 20597.2439630412), new Vsop87.LnVsop(2.5E-10, 6.2223560023, 5223.6939198022), new Vsop87.LnVsop(3.4E-10, 3.38467726966, 2284.7536148596), new Vsop87.LnVsop(3.1E-10, 0.88233421548, 3340.1825435731), new Vsop87.LnVsop(2.5E-10, 0.83746118261, 12725.453434775), new Vsop87.LnVsop(2.7E-10, 5.67024059955, 1478.8665740644), new Vsop87.LnVsop(2.7E-10, 0.42473501075, 33406.124266998), new Vsop87.LnVsop(2.6E-10, 2.15914082099, 3987.6232600146), new Vsop87.LnVsop(2.5E-10, 2.91073064727, 3212.5935833624), new Vsop87.LnVsop(2.7E-10, 4.12996350734, 13383.2251022916), new Vsop87.LnVsop(2.7E-10, 6.05316799952, 13286.1836355236), new Vsop87.LnVsop(2.7E-10, 5.81931319013, 24341.5283174566), new Vsop87.LnVsop(2.9E-10, 4.41519700273, 16894.5103996106), new Vsop87.LnVsop(2.4E-10, 0.20360604382, 3229.4257844122), new Vsop87.LnVsop(2.4E-10, 2.10152754634, 14955.045720432), new Vsop87.LnVsop(3.1E-10, 5.90226054729, 11128.9760857842), new Vsop87.LnVsop(2.3E-10, 3.37817298437, 6850.8050365326), new Vsop87.LnVsop(3.1E-10, 0.35678160238, 31570.7996493912), new Vsop87.LnVsop(2.3E-10, 2.38961518808, 23024.176204937), new Vsop87.LnVsop(2.9E-10, 3.03470840975, 22747.2907148744), new Vsop87.LnVsop(2.6E-10, 0.51379054479, 29978.2036357584), new Vsop87.LnVsop(2.3E-10, 4.26635202793, 3296.8935143948), new Vsop87.LnVsop(2.7E-10, 2.64320191197, 24093.2767891752), new Vsop87.LnVsop(2.3E-10, 4.96777735461, 799.8211251654), new Vsop87.LnVsop(2.4E-10, 3.32945091041, 12140.6011404778), new Vsop87.LnVsop(2.5E-10, 3.30212831704, 6740.5987153132), new Vsop87.LnVsop(2.3E-10, 5.51381740402, 33561.5446664322), new Vsop87.LnVsop(2.3E-10, 0.28172423109, 6593.9166488598), new Vsop87.LnVsop(2.2E-10, 5.48861732897, 30376.3526391666), new Vsop87.LnVsop(2.3E-10, 2.40580065766, 3344.11829139661), new Vsop87.LnVsop(2.8E-10, 5.8750688426, 7747.7203305896), new Vsop87.LnVsop(2.1E-10, 2.40354177453, 3304.0070613956), new Vsop87.LnVsop(2.4E-10, 1.63482389429, 7483.5887758458), new Vsop87.LnVsop(2.8E-10, 1.56312692708, 43340.6533425576), new Vsop87.LnVsop(2.2E-10, 5.32476938106, 12928.7379689224), new Vsop87.LnVsop(2.6E-10, 3.86983068409, 11353.8921676402), new Vsop87.LnVsop(2.3E-10, 4.43657224846, 3344.152798701), new Vsop87.LnVsop(2.1E-10, 3.66824260126, 14951.522602083), new Vsop87.LnVsop(2.2E-10, 0.10813974117, 15423.267560871), new Vsop87.LnVsop(2.5E-10, 5.63091190933, 3416.8784979754), new Vsop87.LnVsop(2.5E-10, 1.57746144847, 11567.1912630782), new Vsop87.LnVsop(2.6E-10, 2.50180659493, 21791.69097326579), new Vsop87.LnVsop(2.2E-10, 4.94823700773, 6681.6449294932), new Vsop87.LnVsop(2.6E-10, 0.84448534014, 3397.5108016354), new Vsop87.LnVsop(2.1E-10, 4.33866377991, 12729.665967486), new Vsop87.LnVsop(2.1E-10, 0.37058306281, 3391.89276456221), new Vsop87.LnVsop(2.2E-10, 1.64362371744, 8852.2490286908), new Vsop87.LnVsop(2.7E-10, 0.10733929729, 5195.2447323344), new Vsop87.LnVsop(2.1E-10, 1.13140972844, 19403.7772738848), new Vsop87.LnVsop(2.6E-10, 2.01526337234, 5032.7780962022), new Vsop87.LnVsop(2.1E-10, 5.55525732543, 41748.0573289248), new Vsop87.LnVsop(2.1E-10, 2.0795993636, 15106.8756912144), new Vsop87.LnVsop(2.4E-10, 3.60866487742, 10006.5848089144), new Vsop87.LnVsop(2.8E-10, 5.64135432549, 12516.366872048), new Vsop87.LnVsop(2.7E-10, 5.93032400892, 3074.005384978), new Vsop87.LnVsop(2.5E-10, 3.74768371499, 3232.9489027612), new Vsop87.LnVsop(2.2E-10, 3.1557835722, 13366.040135451), new Vsop87.LnVsop(2.1E-10, 3.34013182507, 20752.6643624754), new Vsop87.LnVsop(2.6E-10, 1.21869004343, 3377.217792004), new Vsop87.LnVsop(2.4E-10, 2.12604737559, 3171.0322435668), new Vsop87.LnVsop(2.2E-10, 4.02124729955, 30774.5016425748), new Vsop87.LnVsop(2.4E-10, 3.74309736843, 6747.712262314), new Vsop87.LnVsop(2.3E-10, 2.20705996255, 23553.8671700316), new Vsop87.LnVsop(2.1E-10, 3.5707094113, 37895.4262903674), new Vsop87.LnVsop(2.3E-10, 2.565495908, 21192.3641568684), new Vsop87.LnVsop(2.1E-10, 3.34401260695, 15010.8964639966), new Vsop87.LnVsop(1.9E-10, 2.58752283276, 36261.2794857498), new Vsop87.LnVsop(2.1E-10, 5.93180632509, 42146.20633233299), new Vsop87.LnVsop(1.8E-10, 1.24405924793, 6768.5330579394), new Vsop87.LnVsop(1.9E-10, 2.79026853354, 39203.74290904139), new Vsop87.LnVsop(2.4E-10, 2.19710154155, 34513.2630726828), new Vsop87.LnVsop(2.0E-10, 1.69850924464, 49225.5801891408), new Vsop87.LnVsop(1.8E-10, 1.32432984119, 13497.5147868346), new Vsop87.LnVsop(1.8E-10, 2.46520012266, 6944.3087767724), new Vsop87.LnVsop(1.8E-10, 5.07942001013, 3337.0720546986), new Vsop87.LnVsop(1.8E-10, 5.00983720257, 1655.5603041982), new Vsop87.LnVsop(1.8E-10, 0.78739197008, 19676.4502312364), new Vsop87.LnVsop(1.8E-10, 0.05420901908, 2142.6422981262)};
        static Vsop87.LnVsop[] mars_longitude_l2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.8152577E-4, 2.04961712429, 3340.6124266998), new Vsop87.LnVsop(1.3459579E-4, 2.45738706163, 6681.2248533996), new Vsop87.LnVsop(2.432575E-5, 2.79737979284, 10021.8372800994), new Vsop87.LnVsop(4.01065E-6, 3.13581149963, 13362.4497067992), new Vsop87.LnVsop(4.51384E-6, 0.0, 0.0), new Vsop87.LnVsop(2.22025E-6, 3.19437046607, 3.523118349), new Vsop87.LnVsop(1.20954E-6, 0.54327128607, 155.4203994342), new Vsop87.LnVsop(6.2971E-7, 3.47765178989, 16703.062133499), new Vsop87.LnVsop(5.3644E-7, 3.54171478781, 3344.1355450488), new Vsop87.LnVsop(3.4273E-7, 6.00208464365, 2281.2304965106), new Vsop87.LnVsop(3.1659E-7, 4.14001980084, 191.4482661116), new Vsop87.LnVsop(2.9839E-7, 1.9983873938, 796.2980068164), new Vsop87.LnVsop(2.3172E-7, 4.33401932281, 242.728603974), new Vsop87.LnVsop(2.1663E-7, 3.44500841809, 398.1490034082), new Vsop87.LnVsop(1.605E-7, 6.11000263211, 2146.1654164752), new Vsop87.LnVsop(2.0369E-7, 5.42202383442, 553.5694028424), new Vsop87.LnVsop(1.4924E-7, 6.09549588012, 3185.1920272656), new Vsop87.LnVsop(1.6229E-7, 0.65685105422, 0.9803210682), new Vsop87.LnVsop(1.4317E-7, 2.61898820749, 1349.8674096588), new Vsop87.LnVsop(1.4411E-7, 4.01941740099, 951.7184062506), new Vsop87.LnVsop(1.1944E-7, 3.86196758615, 6684.7479717486), new Vsop87.LnVsop(1.5655E-7, 1.22093822826, 1748.016413067), new Vsop87.LnVsop(1.1261E-7, 4.71857181601, 2544.3144198834), new Vsop87.LnVsop(1.336E-7, 0.60151621438, 1194.4470102246), new Vsop87.LnVsop(1.0395E-7, 0.25075540193, 382.8965322232), new Vsop87.LnVsop(9.415E-8, 0.68050215057, 1059.3819301892), new Vsop87.LnVsop(9.58E-8, 3.82256319681, 20043.6745601988), new Vsop87.LnVsop(8.996E-8, 3.88272784458, 3738.761430108), new Vsop87.LnVsop(7.498E-8, 5.46428174266, 1751.539531416), new Vsop87.LnVsop(6.499E-8, 5.47802397833, 1592.5960136328), new Vsop87.LnVsop(6.307E-8, 2.34134269478, 3097.88382272579), new Vsop87.LnVsop(6.864E-8, 2.57523762859, 3149.1641605882), new Vsop87.LnVsop(5.871E-8, 1.1486285578, 7.1135470008), new Vsop87.LnVsop(6.675E-8, 2.37862627319, 4136.9104335162), new Vsop87.LnVsop(4.655E-8, 4.4310225149, 6151.533888305), new Vsop87.LnVsop(4.201E-8, 3.68638044545, 5614.7293762096), new Vsop87.LnVsop(4.796E-8, 2.89378142432, 3333.498879699), new Vsop87.LnVsop(4.074E-8, 6.12610105396, 5628.9564702112), new Vsop87.LnVsop(3.66E-8, 4.06581319964, 1990.745017041), new Vsop87.LnVsop(3.284E-8, 2.79214099721, 3894.1818295422), new Vsop87.LnVsop(3.615E-8, 2.46526861067, 529.6909650946), new Vsop87.LnVsop(3.214E-8, 0.68469193035, 8962.4553499102), new Vsop87.LnVsop(3.087E-8, 4.56932030502, 3496.032826134), new Vsop87.LnVsop(2.918E-8, 5.41494777349, 2914.0142358238), new Vsop87.LnVsop(2.925E-8, 1.23098223044, 2787.0430238574), new Vsop87.LnVsop(2.808E-8, 1.38431632694, 4292.3308329504), new Vsop87.LnVsop(2.652E-8, 1.05282528913, 3341.592747768), new Vsop87.LnVsop(2.92E-8, 3.41297158184, 3337.0893083508), new Vsop87.LnVsop(2.423E-8, 0.9648433024, 4535.0594369244), new Vsop87.LnVsop(2.311E-8, 4.84742235872, 9492.1463150048), new Vsop87.LnVsop(2.597E-8, 5.74792546254, 3340.5951730476), new Vsop87.LnVsop(2.19E-8, 3.26596280325, 213.299095438), new Vsop87.LnVsop(2.598E-8, 1.49506860128, 3340.629680352), new Vsop87.LnVsop(2.365E-8, 4.1830384242, 10025.3603984484), new Vsop87.LnVsop(2.63E-8, 4.67732434694, 3583.3410306738), new Vsop87.LnVsop(2.606E-8, 2.64976204169, 2388.8940204492), new Vsop87.LnVsop(1.822E-8, 0.97105743952, 1589.0728952838), new Vsop87.LnVsop(2.397E-8, 1.04493547179, 4399.994356889), new Vsop87.LnVsop(2.203E-8, 0.16281603659, 6525.8044539654), new Vsop87.LnVsop(2.373E-8, 4.26885534124, 7079.3738568078), new Vsop87.LnVsop(2.366E-8, 0.00564620006, 4690.4798363586), new Vsop87.LnVsop(1.623E-8, 4.95374152644, 5088.6288397668), new Vsop87.LnVsop(2.143E-8, 0.47993241836, 2700.7151403858), new Vsop87.LnVsop(1.646E-8, 4.94105214632, 1221.8485663214), new Vsop87.LnVsop(1.588E-8, 1.11405721408, 12303.06777661), new Vsop87.LnVsop(1.518E-8, 0.11076145171, 2957.7158944766), new Vsop87.LnVsop(1.774E-8, 3.80344931471, 3723.508958923), new Vsop87.LnVsop(1.364E-8, 3.86744855408, 6283.0758499914), new Vsop87.LnVsop(1.764E-8, 2.51992889432, 2810.9214616052), new Vsop87.LnVsop(1.394E-8, 2.7360876673, 7477.522860216), new Vsop87.LnVsop(1.28E-8, 5.47285286548, 6677.7017350506), new Vsop87.LnVsop(1.447E-8, 2.97506973239, 6489.776587288), new Vsop87.LnVsop(1.248E-8, 3.77100223369, 2699.7348193176), new Vsop87.LnVsop(1.527E-8, 2.92629955117, 640.8776073822), new Vsop87.LnVsop(1.197E-8, 1.89205359446, 6681.2421070518), new Vsop87.LnVsop(1.418E-8, 1.54599865534, 3347.7259737006), new Vsop87.LnVsop(1.423E-8, 4.17063094406, 23384.2869868986), new Vsop87.LnVsop(1.042E-8, 5.83283345776, 4933.2084403326), new Vsop87.LnVsop(1.196E-8, 6.14479114175, 6681.2075997474), new Vsop87.LnVsop(1.153E-8, 1.50265359557, 426.598190876), new Vsop87.LnVsop(1.099E-8, 3.80358943061, 3870.3033917944), new Vsop87.LnVsop(9.09E-9, 3.81838122072, 5092.1519581158), new Vsop87.LnVsop(1.071E-8, 5.04949161471, 5621.8429232104), new Vsop87.LnVsop(8.46E-9, 3.82219998207, 3340.545116397), new Vsop87.LnVsop(1.075E-8, 3.81844135104, 3553.9115221378), new Vsop87.LnVsop(8.56E-9, 3.42045045625, 3340.6797370026), new Vsop87.LnVsop(9.16E-9, 1.91472787569, 3532.0606928114), new Vsop87.LnVsop(7.14E-9, 4.26169501052, 9623.6882766912), new Vsop87.LnVsop(9.07E-9, 4.12943952579, 162.4666361322), new Vsop87.LnVsop(6.53E-9, 3.10816357251, 7234.794256242), new Vsop87.LnVsop(7.92E-9, 5.20659969594, 87.30820453981), new Vsop87.LnVsop(6.54E-9, 1.57331630734, 2487.4160449478), new Vsop87.LnVsop(6.49E-9, 2.78892909992, 574.3447983348), new Vsop87.LnVsop(6.48E-9, 5.181110771, 12832.7587417046), new Vsop87.LnVsop(7.07E-9, 5.8319586932, 3339.6321056316), new Vsop87.LnVsop(5.2E-9, 4.64660657418, 6836.6452528338), new Vsop87.LnVsop(6.6E-9, 0.24998045706, 8969.568896911), new Vsop87.LnVsop(6.4E-9, 1.70935421799, 7632.9432596502), new Vsop87.LnVsop(5.28E-9, 0.3110540935, 8031.0922630584), new Vsop87.LnVsop(5.1E-9, 4.63676288319, 10419.9862835076), new Vsop87.LnVsop(6.04E-9, 3.85002715377, 5486.777843175), new Vsop87.LnVsop(5.14E-9, 1.38796992796, 7740.6067835888), new Vsop87.LnVsop(4.62E-9, 1.33678943112, 7875.6718636242), new Vsop87.LnVsop(4.95E-9, 4.50170882091, 692.1576012268), new Vsop87.LnVsop(4.71E-9, 1.42441365252, 6682.2051744678), new Vsop87.LnVsop(5.5E-9, 4.41887772777, 5331.3574437408), new Vsop87.LnVsop(4.39E-9, 1.25554168321, 4929.6853219836), new Vsop87.LnVsop(4.19E-9, 5.44439060471, 10018.3141617504), new Vsop87.LnVsop(5.37E-9, 1.46176527778, 15643.6802033098), new Vsop87.LnVsop(4.05E-9, 1.57332289249, 6127.6554505572), new Vsop87.LnVsop(3.9E-9, 3.81525595562, 6681.2921637024), new Vsop87.LnVsop(3.97E-9, 4.6220971542, 7210.9158184942), new Vsop87.LnVsop(3.67E-9, 1.0011083919, 6041.3275670856), new Vsop87.LnVsop(3.58E-9, 0.15138024092, 639.897286314), new Vsop87.LnVsop(3.69E-9, 0.55699031997, 11773.3768115154), new Vsop87.LnVsop(4.33E-9, 4.50587650409, 13365.9728251482), new Vsop87.LnVsop(4.72E-9, 5.18372269228, 2301.58581590939), new Vsop87.LnVsop(3.89E-9, 4.22520163179, 6681.1575430968), new Vsop87.LnVsop(3.66E-9, 5.02827753161, 6923.9534573736), new Vsop87.LnVsop(3.26E-9, 3.99284456376, 8955.3418029094), new Vsop87.LnVsop(3.2E-9, 2.23597582782, 10021.8545337516), new Vsop87.LnVsop(3.21E-9, 0.2052453743, 10021.8200264472), new Vsop87.LnVsop(3.37E-9, 2.98232216826, 5729.506447149), new Vsop87.LnVsop(3.23E-9, 1.34413812795, 2118.7638603784), new Vsop87.LnVsop(3.38E-9, 2.49683073767, 6438.4962494256), new Vsop87.LnVsop(3.22E-9, 0.51214404564, 9866.4168806652), new Vsop87.LnVsop(2.74E-9, 3.35270419822, 9830.3890139878), new Vsop87.LnVsop(2.71E-9, 1.53180722885, 1039.0266107904), new Vsop87.LnVsop(2.71E-9, 2.23239080465, 5828.0284716476), new Vsop87.LnVsop(2.55E-9, 4.05578912871, 7064.1213856228), new Vsop87.LnVsop(2.45E-9, 5.10524905635, 8429.2412664666), new Vsop87.LnVsop(2.62E-9, 2.03073386216, 3767.2106175758), new Vsop87.LnVsop(2.54E-9, 0.46317479341, 6298.3283211764), new Vsop87.LnVsop(2.49E-9, 4.27544865193, 6894.5239488376), new Vsop87.LnVsop(2.32E-9, 3.06292621291, 10818.1352869158), new Vsop87.LnVsop(2.41E-9, 1.94265839706, 6688.3384004004), new Vsop87.LnVsop(2.04E-9, 0.02615801903, 3914.9572250346), new Vsop87.LnVsop(2.06E-9, 4.52434051121, 26724.8994135984), new Vsop87.LnVsop(2.44E-9, 1.23370429435, 8432.7643848156), new Vsop87.LnVsop(2.46E-9, 3.83080164245, 4562.4609930212), new Vsop87.LnVsop(2.36E-9, 1.69741583748, 2942.4634232916), new Vsop87.LnVsop(1.83E-9, 4.94847733715, 10177.2576795336), new Vsop87.LnVsop(2.0E-9, 3.23521719204, 6674.1113063988), new Vsop87.LnVsop(2.06E-9, 3.5331803786, 10575.4066829418), new Vsop87.LnVsop(2.03E-9, 3.8070308138, 6467.9257579616), new Vsop87.LnVsop(1.73E-9, 3.26078770157, 3981.490034082), new Vsop87.LnVsop(1.6E-9, 5.95148314584, 310.8407988684), new Vsop87.LnVsop(1.67E-9, 2.15287688461, 10973.55568635), new Vsop87.LnVsop(1.91E-9, 0.77503447629, 15113.9892382152), new Vsop87.LnVsop(1.52E-9, 4.35155334509, 3360.96774609859), new Vsop87.LnVsop(1.67E-9, 2.41354473163, 3355.8648978848), new Vsop87.LnVsop(1.79E-9, 4.59684946724, 12964.300703391), new Vsop87.LnVsop(1.65E-9, 1.93485741767, 3127.3133312618), new Vsop87.LnVsop(1.43E-9, 0.30520037218, 1903.4368125012), new Vsop87.LnVsop(1.35E-9, 1.64201243891, 3325.3599555148), new Vsop87.LnVsop(1.68E-9, 5.98672368946, 3320.257107301), new Vsop87.LnVsop(1.26E-9, 0.06628028702, 9595.2390892234), new Vsop87.LnVsop(1.26E-9, 5.09324195826, 3475.6775067352), new Vsop87.LnVsop(1.42E-9, 2.2258438511, 3178.1457905676), new Vsop87.LnVsop(1.37E-9, 5.5264050804, 16173.3711684044), new Vsop87.LnVsop(1.16E-9, 5.5461574468, 13358.9265884502), new Vsop87.LnVsop(1.3E-9, 6.12910259056, 8273.8208670324), new Vsop87.LnVsop(1.06E-9, 5.74124915667, 2288.3440435114), new Vsop87.LnVsop(1.1E-9, 4.00849488333, 13916.0191096416), new Vsop87.LnVsop(1.11E-9, 4.15314444907, 10021.9045904022), new Vsop87.LnVsop(1.24E-9, 1.03360247396, 18454.601664915), new Vsop87.LnVsop(1.11E-9, 1.81233800595, 18984.2926300096), new Vsop87.LnVsop(1.08E-9, 4.017257363, 5884.9268465832), new Vsop87.LnVsop(9.9E-10, 0.69247362673, 12310.1813236108), new Vsop87.LnVsop(9.8E-10, 2.52732520244, 3191.0492295652), new Vsop87.LnVsop(9.5E-10, 6.00085009229, 14584.2982731206), new Vsop87.LnVsop(9.2E-10, 4.38893173686, 9808.5381846614), new Vsop87.LnVsop(9.1E-10, 1.72031299533, 11081.2192102886), new Vsop87.LnVsop(1.14E-9, 4.11263836293, 6158.6474353058), new Vsop87.LnVsop(9.1E-10, 1.71520550367, 1505.28780909299), new Vsop87.LnVsop(9.3E-10, 5.6668096319, 3319.8370312074), new Vsop87.LnVsop(8.9E-10, 4.96845061541, 13760.5987102074), new Vsop87.LnVsop(8.9E-10, 0.44335699327, 11371.7046897582), new Vsop87.LnVsop(8.6E-10, 2.99034396202, 7903.073419721), new Vsop87.LnVsop(8.9E-10, 5.87200048108, 16858.4825329332), new Vsop87.LnVsop(1.02E-9, 4.55812091356, 10021.7699697966), new Vsop87.LnVsop(9.2E-10, 1.59954108842, 24093.2767891752), new Vsop87.LnVsop(8.0E-10, 0.23144257625, 9779.1086761254), new Vsop87.LnVsop(7.9E-10, 4.65340786273, 6144.4203413042), new Vsop87.LnVsop(7.6E-10, 0.49995616312, 13119.72110282519), new Vsop87.LnVsop(8.4E-10, 5.55308493446, 3427.9206312396), new Vsop87.LnVsop(7.6E-10, 4.52961122356, 708.98980227659), new Vsop87.LnVsop(7.2E-10, 1.22310316961, 2274.1169495098), new Vsop87.LnVsop(9.7E-10, 5.46490186895, 13517.8701062334), new Vsop87.LnVsop(7.3E-10, 5.30141060834, 4845.9002357928), new Vsop87.LnVsop(7.0E-10, 0.09877565579, 1437.1756141986), new Vsop87.LnVsop(9.3E-10, 5.11228667278, 10551.528245194), new Vsop87.LnVsop(7.5E-10, 0.67412470168, 16460.33352952499), new Vsop87.LnVsop(6.8E-10, 2.23465524386, 10213.285546211), new Vsop87.LnVsop(7.9E-10, 5.26872987203, 853.196381752), new Vsop87.LnVsop(6.9E-10, 0.59532377543, 12935.8515159232), new Vsop87.LnVsop(8.0E-10, 1.78140455646, 10022.8176011676), new Vsop87.LnVsop(6.5E-10, 1.3890407867, 3253.30422216), new Vsop87.LnVsop(7.5E-10, 6.03732407558, 5085.038411115), new Vsop87.LnVsop(7.8E-10, 2.75071312389, 19402.7969528166), new Vsop87.LnVsop(6.1E-10, 1.49021039778, 5459.3762870782), new Vsop87.LnVsop(6.2E-10, 2.50552301889, 5642.1982426092), new Vsop87.LnVsop(7.9E-10, 1.57382509764, 8270.2977486834), new Vsop87.LnVsop(6.6E-10, 0.35982344278, 7255.5696517344), new Vsop87.LnVsop(6.0E-10, 0.51628343105, 13362.432453147), new Vsop87.LnVsop(7.9E-10, 3.84136206523, 2766.267628365), new Vsop87.LnVsop(6.1E-10, 1.35834394421, 19800.9459562248), new Vsop87.LnVsop(5.7E-10, 2.63537932021, 14314.1681130498), new Vsop87.LnVsop(6.2E-10, 6.23224285432, 9381.9399937854), new Vsop87.LnVsop(5.6E-10, 3.92602466001, 4032.7700279266), new Vsop87.LnVsop(5.8E-10, 4.80541369849, 16706.585251848), new Vsop87.LnVsop(5.6E-10, 1.07495829941, 3364.4908644476), new Vsop87.LnVsop(7.4E-10, 3.11826754597, 1107.1388056848), new Vsop87.LnVsop(5.6E-10, 5.92196461153, 21265.5231265202), new Vsop87.LnVsop(5.5E-10, 0.69133485773, 3344.2028553516), new Vsop87.LnVsop(5.8E-10, 0.03055561004, 3369.0616141676), new Vsop87.LnVsop(6.8E-10, 1.89382886303, 9225.539273283), new Vsop87.LnVsop(6.1E-10, 4.41416512793, 22345.2603761082), new Vsop87.LnVsop(5.4E-10, 5.99826659037, 21947.1113727), new Vsop87.LnVsop(5.6E-10, 1.90889246971, 12721.572099417), new Vsop87.LnVsop(5.8E-10, 0.64076710539, 3980.5097130138), new Vsop87.LnVsop(7.3E-10, 1.53390867765, 9380.9596727172), new Vsop87.LnVsop(7.1E-10, 1.55065593763, 3361.3878221922), new Vsop87.LnVsop(5.2E-10, 4.4577538325, 10404.7338123226), new Vsop87.LnVsop(5.5E-10, 0.25842078226, 3337.021998048), new Vsop87.LnVsop(5.0E-10, 0.62274445643, 7373.3824546264), new Vsop87.LnVsop(6.5E-10, 2.99158486208, 3316.733988952), new Vsop87.LnVsop(5.0E-10, 2.91155201771, 8982.810669309), new Vsop87.LnVsop(5.1E-10, 2.53925124485, 13362.4669604514), new Vsop87.LnVsop(5.3E-10, 1.75963973665, 2648.454825473), new Vsop87.LnVsop(4.7E-10, 3.74205609558, 33716.9650658664), new Vsop87.LnVsop(4.7E-10, 2.3398532312, 16062.1845261168), new Vsop87.LnVsop(5.1E-10, 4.76183443226, 8671.9698704406), new Vsop87.LnVsop(4.7E-10, 3.61238635706, 30376.3526391666), new Vsop87.LnVsop(4.5E-10, 3.17314820387, 2818.035008606), new Vsop87.LnVsop(5.6E-10, 0.85677332683, 17468.8551979454), new Vsop87.LnVsop(5.4E-10, 1.68830003586, 11216.284290324), new Vsop87.LnVsop(5.4E-10, 1.32704907908, 8439.8779318164), new Vsop87.LnVsop(5.9E-10, 3.89706899146, 5244.049239201), new Vsop87.LnVsop(4.3E-10, 1.45207414702, 24889.5747959916), new Vsop87.LnVsop(4.3E-10, 4.9343450053, 14469.588512484), new Vsop87.LnVsop(4.7E-10, 0.63724859746, 15110.4661198662), new Vsop87.LnVsop(4.8E-10, 1.93153003679, 9468.267877257), new Vsop87.LnVsop(4.1E-10, 0.80934461579, 13207.029307365), new Vsop87.LnVsop(4.3E-10, 0.86742732243, 20752.6643624754), new Vsop87.LnVsop(4.1E-10, 3.35182836767, 9588.1255422226), new Vsop87.LnVsop(4.3E-10, 3.19403696329, 22743.4093795164), new Vsop87.LnVsop(4.0E-10, 3.80517212464, 28628.3362260996), new Vsop87.LnVsop(4.5E-10, 3.444464598, 14158.7477136156), new Vsop87.LnVsop(4.1E-10, 5.33088551342, 765.7930644464), new Vsop87.LnVsop(3.8E-10, 2.34719947252, 10028.9508271002), new Vsop87.LnVsop(3.7E-10, 4.87740795169, 30065.5118402982), new Vsop87.LnVsop(4.2E-10, 3.77822295434, 3503.079062832), new Vsop87.LnVsop(3.7E-10, 0.24131392245, 9168.6408983474), new Vsop87.LnVsop(3.7E-10, 2.42831434862, 7107.8230442756), new Vsop87.LnVsop(3.9E-10, 3.67137247569, 13171.0014406876), new Vsop87.LnVsop(3.7E-10, 5.41610716116, 10264.5658840734), new Vsop87.LnVsop(4.7E-10, 0.89637520949, 16703.0448798468), new Vsop87.LnVsop(4.1E-10, 0.6815355581, 11766.2632645146), new Vsop87.LnVsop(4.6E-10, 1.51332559161, 6040.3472460174), new Vsop87.LnVsop(3.7E-10, 1.95319370926, 6702.000248892), new Vsop87.LnVsop(3.6E-10, 0.79575390273, 20597.2439630412), new Vsop87.LnVsop(3.5E-10, 3.79593106555, 1066.49547719), new Vsop87.LnVsop(3.5E-10, 3.48692827125, 9070.1188738488), new Vsop87.LnVsop(3.5E-10, 4.69051318198, 10235.1363755374), new Vsop87.LnVsop(3.4E-10, 1.42262836561, 21795.21409161479), new Vsop87.LnVsop(4.7E-10, 2.9268354977, 16703.07938715119), new Vsop87.LnVsop(4.4E-10, 2.00401073062, 28230.18722269139), new Vsop87.LnVsop(3.3E-10, 5.86775675864, 19513.9835951042), new Vsop87.LnVsop(3.5E-10, 4.22435449199, 8584.6616659008), new Vsop87.LnVsop(4.4E-10, 6.0858186063, 6660.4494579072), new Vsop87.LnVsop(3.3E-10, 2.61681384731, 6696.4773245846), new Vsop87.LnVsop(3.4E-10, 3.70456078721, 15664.03552270859), new Vsop87.LnVsop(4.3E-10, 5.44670688059, 6816.289933435), new Vsop87.LnVsop(3.7E-10, 2.03776406606, 14556.8967170238), new Vsop87.LnVsop(3.7E-10, 5.7143328253, 5099.2655051166), new Vsop87.LnVsop(4.1E-10, 0.17225787246, 25287.7237993998), new Vsop87.LnVsop(3.1E-10, 2.30685466428, 10042.6126755918), new Vsop87.LnVsop(3.4E-10, 0.72658199838, 11780.4903585162), new Vsop87.LnVsop(3.0E-10, 1.28426808967, 11243.6858464208), new Vsop87.LnVsop(3.0E-10, 3.37226860046, 27832.0382192832), new Vsop87.LnVsop(3.0E-10, 4.49208108982, 9499.2598620056), new Vsop87.LnVsop(3.2E-10, 4.74490222844, 17256.6315363414), new Vsop87.LnVsop(3.1E-10, 5.02978229455, 25685.872802808), new Vsop87.LnVsop(2.9E-10, 1.05521949715, 13936.794505134), new Vsop87.LnVsop(2.9E-10, 2.13159143713, 22324.9050567094), new Vsop87.LnVsop(3.4E-10, 0.77946190155, 10596.1820784342), new Vsop87.LnVsop(2.8E-10, 5.13684548975, 12012.5822971404), new Vsop87.LnVsop(2.9E-10, 4.19390076272, 6106.8800550648), new Vsop87.LnVsop(3.0E-10, 5.79496586838, 10156.9023601348), new Vsop87.LnVsop(3.0E-10, 1.9553280009, 6665.9723822146), new Vsop87.LnVsop(3.0E-10, 4.37086181476, 12295.9542296092), new Vsop87.LnVsop(3.7E-10, 3.33119104614, 12323.4230960088), new Vsop87.LnVsop(3.2E-10, 0.0332828902, 17924.9106998204), new Vsop87.LnVsop(3.1E-10, 6.22551067475, 6660.8695340008), new Vsop87.LnVsop(2.7E-10, 6.22583184601, 20199.094959633), new Vsop87.LnVsop(2.7E-10, 4.47604397206, 15508.6151232744), new Vsop87.LnVsop(2.7E-10, 4.18952669137, 19004.6479494084), new Vsop87.LnVsop(2.9E-10, 0.33347322113, 11614.4332937322), new Vsop87.LnVsop(2.7E-10, 2.55492575464, 13553.8979729108), new Vsop87.LnVsop(2.7E-10, 5.17429820364, 20047.1976785478), new Vsop87.LnVsop(2.6E-10, 4.75069348623, 9485.032768004), new Vsop87.LnVsop(2.8E-10, 5.05646024487, 16304.9131300908), new Vsop87.LnVsop(2.6E-10, 0.33571424841, 1758.6530784168), new Vsop87.LnVsop(2.6E-10, 1.88254124807, 4379.6390374902), new Vsop87.LnVsop(2.6E-10, 0.66164680044, 6677.6344247478), new Vsop87.LnVsop(2.7E-10, 0.16359834714, 10001.061884607), new Vsop87.LnVsop(2.6E-10, 1.2724007134, 21548.9623692918), new Vsop87.LnVsop(2.7E-10, 2.42251642195, 6518.7582172674), new Vsop87.LnVsop(2.5E-10, 0.38159855574, 10001.48196070061), new Vsop87.LnVsop(2.5E-10, 5.68892581324, 4193.8088084518), new Vsop87.LnVsop(2.5E-10, 3.41513259489, 6657.3464156518), new Vsop87.LnVsop(3.1E-10, 0.85409497605, 16276.463942623), new Vsop87.LnVsop(2.5E-10, 4.41986609477, 12168.0026965746), new Vsop87.LnVsop(3.0E-10, 4.77047285234, 12722.5524204852), new Vsop87.LnVsop(2.8E-10, 3.0600344259, 6247.5131155228), new Vsop87.LnVsop(2.5E-10, 3.09863827375, 10037.0897512844), new Vsop87.LnVsop(2.5E-10, 1.02575938018, 15650.7937503106), new Vsop87.LnVsop(2.4E-10, 3.9559600726, 4936.7988689844), new Vsop87.LnVsop(2.4E-10, 0.15547683375, 23141.5583829246), new Vsop87.LnVsop(2.4E-10, 2.02621002883, 5989.0672521728), new Vsop87.LnVsop(3.0E-10, 5.7817472045, 16699.53901514999), new Vsop87.LnVsop(2.6E-10, 1.86541912366, 11610.9101753832), new Vsop87.LnVsop(2.6E-10, 1.09364283303, 6684.8152820514), new Vsop87.LnVsop(2.5E-10, 3.89771277869, 1052.2683831884), new Vsop87.LnVsop(2.7E-10, 2.56503603603, 18052.9295431578), new Vsop87.LnVsop(2.3E-10, 1.5179761534, 24491.4257925834), new Vsop87.LnVsop(2.3E-10, 3.00396120711, 12566.1516999828), new Vsop87.LnVsop(2.2E-10, 4.95564076891, 13362.3823964964), new Vsop87.LnVsop(2.6E-10, 5.35396491473, 17101.2111369072), new Vsop87.LnVsop(2.5E-10, 0.7839457642, 3863.1898447936), new Vsop87.LnVsop(2.9E-10, 0.72436044897, 9638.9407478762), new Vsop87.LnVsop(2.3E-10, 4.78936229419, 11925.2740926006), new Vsop87.LnVsop(2.8E-10, 0.45519439131, 6709.6740408674), new Vsop87.LnVsop(2.6E-10, 4.87772426583, 13149.1506113612), new Vsop87.LnVsop(2.3E-10, 5.40586773017, 13892.1406718938), new Vsop87.LnVsop(2.3E-10, 2.35248036676, 30774.5016425748), new Vsop87.LnVsop(2.8E-10, 1.10862278422, 8425.6508378148), new Vsop87.LnVsop(2.3E-10, 3.6171296062, 1581.959348283), new Vsop87.LnVsop(2.6E-10, 0.31100585552, 3603.6963500726), new Vsop87.LnVsop(2.0E-10, 2.43389989577, 19406.6782881746), new Vsop87.LnVsop(2.5E-10, 5.91413646106, 6680.2445323314), new Vsop87.LnVsop(2.0E-10, 5.43460902247, 17395.2197347258), new Vsop87.LnVsop(2.5E-10, 1.00211327228, 7321.1221397136), new Vsop87.LnVsop(2.0E-10, 5.58281555175, 18606.4989460002), new Vsop87.LnVsop(2.5E-10, 3.57752663624, 3873.8265101434), new Vsop87.LnVsop(2.1E-10, 2.14222861506, 14421.8316369884), new Vsop87.LnVsop(2.0E-10, 5.47581404162, 20735.83216142559), new Vsop87.LnVsop(2.1E-10, 5.5380981385, 15265.8865193004), new Vsop87.LnVsop(1.9E-10, 5.69034956533, 17013.9029323674), new Vsop87.LnVsop(1.9E-10, 5.76144586324, 17085.9586657222), new Vsop87.LnVsop(2.2E-10, 2.98924680598, 9602.3526362242), new Vsop87.LnVsop(1.9E-10, 5.73996220529, 3651.4532255682), new Vsop87.LnVsop(1.8E-10, 0.52367856726, 14054.607308026), new Vsop87.LnVsop(2.2E-10, 5.16650472247, 3376.6402933772), new Vsop87.LnVsop(2.0E-10, 2.67348019896, 10448.4354709754), new Vsop87.LnVsop(1.8E-10, 3.70248341637, 37057.5774925662), new Vsop87.LnVsop(1.8E-10, 2.14231646843, 13363.4300278674), new Vsop87.LnVsop(2.0E-10, 6.25669293739, 1744.4259844152), new Vsop87.LnVsop(2.0E-10, 1.60190678685, 23296.97878235879), new Vsop87.LnVsop(2.3E-10, 4.54770256231, 13362.517017102), new Vsop87.LnVsop(2.4E-10, 0.5435601722, 6475.0393049624), new Vsop87.LnVsop(2.3E-10, 2.73656801737, 6261.7402095244), new Vsop87.LnVsop(1.8E-10, 5.45243764566, 40000.04091585779), new Vsop87.LnVsop(1.8E-10, 1.77799263643, 8799.988713778), new Vsop87.LnVsop(1.8E-10, 1.18266196226, 31172.650645983), new Vsop87.LnVsop(1.9E-10, 3.6618146527, 1596.1864422846), new Vsop87.LnVsop(1.8E-10, 3.46673198156, 3546.797975137), new Vsop87.LnVsop(2.2E-10, 2.15272313802, 3335.0895023924), new Vsop87.LnVsop(1.8E-10, 0.13829920233, 3877.4169387952), new Vsop87.LnVsop(2.0E-10, 4.57210028361, 6701.5801727984), new Vsop87.LnVsop(1.9E-10, 5.0929008872, 3205.5473466644), new Vsop87.LnVsop(1.6E-10, 3.67355426368, 20995.3929664494), new Vsop87.LnVsop(1.6E-10, 6.13550943291, 3134.4268782626), new Vsop87.LnVsop(1.6E-10, 6.22620467137, 22854.596021804), new Vsop87.LnVsop(1.6E-10, 1.4413771306, 6460.8122109608), new Vsop87.LnVsop(1.5E-10, 1.18753446282, 7203.8022714934), new Vsop87.LnVsop(1.6E-10, 3.90125903944, 7322.1024607818), new Vsop87.LnVsop(1.5E-10, 4.93156258719, 3304.5845600224), new Vsop87.LnVsop(1.7E-10, 0.49763390696, 18208.349942592), new Vsop87.LnVsop(1.7E-10, 3.3286382364, 3333.5661900018), new Vsop87.LnVsop(1.4E-10, 5.31587329158, 19645.5255567906), new Vsop87.LnVsop(1.7E-10, 3.0119332872, 3344.4937620578), new Vsop87.LnVsop(1.6E-10, 4.54660273048, 4392.8808098882), new Vsop87.LnVsop(1.3E-10, 5.26350209812, 16702.9948231962), new Vsop87.LnVsop(1.6E-10, 6.12947849429, 26087.9031415742), new Vsop87.LnVsop(1.3E-10, 5.84447235851, 536.8045120954), new Vsop87.LnVsop(1.7E-10, 4.09065954177, 16511.6138673874), new Vsop87.LnVsop(1.5E-10, 5.73438221173, 14867.73751589219), new Vsop87.LnVsop(1.3E-10, 2.54721959021, 6675.7019290922), new Vsop87.LnVsop(1.4E-10, 1.31577259278, 21150.8133658836), new Vsop87.LnVsop(1.3E-10, 2.12815796147, 3346.1353510072), new Vsop87.LnVsop(1.3E-10, 3.59360902373, 12410.7313005486), new Vsop87.LnVsop(1.6E-10, 5.67307416663, 11527.1250891924), new Vsop87.LnVsop(1.6E-10, 0.84938642384, 10184.3039162316), new Vsop87.LnVsop(1.3E-10, 6.16919624193, 3077.528503327), new Vsop87.LnVsop(1.4E-10, 3.93053280186, 3312.163239232), new Vsop87.LnVsop(1.4E-10, 2.55072089788, 206.1855484372), new Vsop87.LnVsop(1.3E-10, 4.69830610865, 16703.1294438018), new Vsop87.LnVsop(1.2E-10, 0.92968593112, 10713.9948813262), new Vsop87.LnVsop(1.1E-10, 6.09331837551, 8827.3902698748), new Vsop87.LnVsop(1.4E-10, 3.77650372404, 17499.3601403154), new Vsop87.LnVsop(1.1E-10, 1.09619387864, 16547.6417340648), new Vsop87.LnVsop(1.1E-10, 5.05016560122, 24076.4445881254), new Vsop87.LnVsop(1.5E-10, 6.16612008928, 3347.6586633978), new Vsop87.LnVsop(1.1E-10, 1.92845507292, 11769.8536931664), new Vsop87.LnVsop(1.3E-10, 1.01843193479, 10018.2468514476), new Vsop87.LnVsop(1.5E-10, 0.92188099847, 3281.2385647862), new Vsop87.LnVsop(1.3E-10, 5.19040439871, 16489.763038061), new Vsop87.LnVsop(1.1E-10, 0.29063320387, 2906.900688823), new Vsop87.LnVsop(1.1E-10, 5.65061614555, 13605.1783107732), new Vsop87.LnVsop(1.3E-10, 5.06832582026, 13575.7488022372), new Vsop87.LnVsop(1.1E-10, 5.426485257, 17232.7530985936), new Vsop87.LnVsop(1.4E-10, 2.18442424174, 12808.8803039568), new Vsop87.LnVsop(1.0E-10, 3.12070301287, 2803.8079146044), new Vsop87.LnVsop(1.1E-10, 1.35555533168, 2277.7073781616), new Vsop87.LnVsop(1.0E-10, 5.89715293869, 6768.5330579394), new Vsop87.LnVsop(1.0E-10, 5.93295499002, 23937.856389741), new Vsop87.LnVsop(1.2E-10, 1.20813089438, 3336.7310913418), new Vsop87.LnVsop(1.1E-10, 2.56209057142, 13369.5632538), new Vsop87.LnVsop(1.2E-10, 0.50116227157, 34513.2630726828), new Vsop87.LnVsop(1.0E-10, 4.37163145009, 3607.2194684216), new Vsop87.LnVsop(1.1E-10, 4.03902225289, 4407.1079038898), new Vsop87.LnVsop(1.0E-10, 4.18585556139, 0.0172536522), new Vsop87.LnVsop(1.1E-10, 0.06058557016, 26880.3198130326), new Vsop87.LnVsop(1.1E-10, 5.12397606143, 33406.124266998), new Vsop87.LnVsop(1.1E-10, 1.00077091959, 12979.553174576), new Vsop87.LnVsop(1.0E-10, 0.39595065439, 14955.045720432), new Vsop87.LnVsop(1.1E-10, 3.3613391037, 16894.5103996106), new Vsop87.LnVsop(1.0E-10, 1.63992012008, 220.4126424388), new Vsop87.LnVsop(1.0E-10, 5.76293648428, 31968.9486527994), new Vsop87.LnVsop(1.3E-10, 1.44898528338, 10025.4277087512), new Vsop87.LnVsop(1.1E-10, 4.36692917575, 34115.1140692746), new Vsop87.LnVsop(1.0E-10, 4.84826192777, 12839.8722887054), new Vsop87.LnVsop(1.0E-10, 1.85828895892, 6593.9166488598), new Vsop87.LnVsop(1.0E-10, 5.75866529304, 6717.252720077), new Vsop87.LnVsop(1.2E-10, 4.33022696919, 7747.7203305896), new Vsop87.LnVsop(1.1E-10, 5.96309733546, 20040.15144184979), new Vsop87.LnVsop(1.0E-10, 3.58563293895, 20354.5153590672), new Vsop87.LnVsop(1.0E-10, 4.8883526004, 10042.1925994982), new Vsop87.LnVsop(1.0E-10, 2.48515633128, 25665.5174834092), new Vsop87.LnVsop(9.0E-11, 1.77145376267, 32367.0976562076)};
        static Vsop87.LnVsop[] mars_longitude_l3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.467867E-5, 0.4442983946, 3340.6124266998), new Vsop87.LnVsop(6.92668E-6, 0.88679887123, 6681.2248533996), new Vsop87.LnVsop(1.89478E-6, 1.28336839921, 10021.8372800994), new Vsop87.LnVsop(4.1615E-7, 1.64210455567, 13362.4497067992), new Vsop87.LnVsop(2.266E-7, 2.05278956965, 155.4203994342), new Vsop87.LnVsop(8.126E-8, 1.99049724299, 16703.062133499), new Vsop87.LnVsop(1.0455E-7, 1.57992093693, 3.523118349), new Vsop87.LnVsop(4.902E-8, 2.8251687501, 242.728603974), new Vsop87.LnVsop(5.379E-8, 3.14159265359, 0.0), new Vsop87.LnVsop(3.782E-8, 2.01848153986, 3344.1355450488), new Vsop87.LnVsop(3.181E-8, 4.59108786647, 3185.1920272656), new Vsop87.LnVsop(3.133E-8, 0.65141319517, 553.5694028424), new Vsop87.LnVsop(1.698E-8, 5.53803382831, 951.7184062506), new Vsop87.LnVsop(1.525E-8, 5.71698515888, 191.4482661116), new Vsop87.LnVsop(1.451E-8, 0.4606849022, 796.2980068164), new Vsop87.LnVsop(1.473E-8, 2.33727441522, 20043.6745601988), new Vsop87.LnVsop(1.314E-8, 5.36403056955, 0.9803210682), new Vsop87.LnVsop(1.178E-8, 4.14644990348, 1349.8674096588), new Vsop87.LnVsop(1.138E-8, 2.37914351932, 6684.7479717486), new Vsop87.LnVsop(1.046E-8, 1.76915268602, 382.8965322232), new Vsop87.LnVsop(9.02E-9, 5.35475854699, 1194.4470102246), new Vsop87.LnVsop(8.13E-9, 2.74852234414, 1748.016413067), new Vsop87.LnVsop(6.29E-9, 6.08292992203, 3496.032826134), new Vsop87.LnVsop(5.64E-9, 1.87914711325, 398.1490034082), new Vsop87.LnVsop(5.66E-9, 5.8543921654, 7.1135470008), new Vsop87.LnVsop(6.46E-9, 3.17980126471, 3583.3410306738), new Vsop87.LnVsop(4.61E-9, 5.99300094958, 2787.0430238574), new Vsop87.LnVsop(5.15E-9, 1.00397565149, 3149.1641605882), new Vsop87.LnVsop(5.24E-9, 4.94366714135, 6525.8044539654), new Vsop87.LnVsop(4.05E-9, 1.25868884474, 2281.2304965106), new Vsop87.LnVsop(3.96E-9, 2.33533869272, 3738.761430108), new Vsop87.LnVsop(4.73E-9, 0.85569341494, 4136.9104335162), new Vsop87.LnVsop(3.37E-9, 5.42720231008, 1059.3819301892), new Vsop87.LnVsop(3.12E-9, 3.71767667252, 3097.88382272579), new Vsop87.LnVsop(2.8E-9, 5.77799085447, 3341.592747768), new Vsop87.LnVsop(2.82E-9, 2.713974878, 10025.3603984484), new Vsop87.LnVsop(2.15E-9, 5.72936855193, 4535.0594369244), new Vsop87.LnVsop(2.13E-9, 2.52113312108, 1990.745017041), new Vsop87.LnVsop(2.53E-9, 2.68513749891, 23384.2869868986), new Vsop87.LnVsop(2.71E-9, 1.11020953644, 2388.8940204492), new Vsop87.LnVsop(1.86E-9, 4.87399580961, 2957.7158944766), new Vsop87.LnVsop(1.78E-9, 3.9136125007, 1592.5960136328), new Vsop87.LnVsop(1.75E-9, 0.87350226081, 3894.1818295422), new Vsop87.LnVsop(1.91E-9, 4.57651964364, 3337.0893083508), new Vsop87.LnVsop(1.66E-9, 2.74261580519, 7079.3738568078), new Vsop87.LnVsop(1.32E-9, 1.21969793594, 7477.522860216), new Vsop87.LnVsop(1.76E-9, 5.82269855073, 4399.994356889), new Vsop87.LnVsop(1.44E-9, 1.41866825837, 6489.776587288), new Vsop87.LnVsop(1.16E-9, 3.26440506489, 9492.1463150048), new Vsop87.LnVsop(1.1E-9, 5.25036780309, 8962.4553499102), new Vsop87.LnVsop(1.09E-9, 2.69848602723, 6151.533888305), new Vsop87.LnVsop(9.9E-10, 3.53126616352, 6923.9534573736), new Vsop87.LnVsop(9.4E-10, 5.83398846011, 12303.06777661), new Vsop87.LnVsop(8.2E-10, 5.71976568172, 4292.3308329504), new Vsop87.LnVsop(8.2E-10, 0.07031928087, 6127.6554505572), new Vsop87.LnVsop(7.9E-10, 5.82605787124, 1589.0728952838), new Vsop87.LnVsop(8.6E-10, 5.29348370173, 9866.4168806652), new Vsop87.LnVsop(1.01E-9, 3.3367659E-4, 3347.7259737006), new Vsop87.LnVsop(7.6E-10, 4.3366264457, 4933.2084403326), new Vsop87.LnVsop(6.6E-10, 4.98095301409, 5486.777843175), new Vsop87.LnVsop(6.6E-10, 1.7432652957, 3870.3033917944), new Vsop87.LnVsop(5.9E-10, 1.47406427963, 7234.794256242), new Vsop87.LnVsop(6.5E-10, 4.13790023458, 3340.5951730476), new Vsop87.LnVsop(6.6E-10, 6.17474740457, 6682.2051744678), new Vsop87.LnVsop(6.5E-10, 6.16873733389, 3340.629680352), new Vsop87.LnVsop(6.1E-10, 3.04498621253, 13365.9728251482), new Vsop87.LnVsop(5.7E-10, 0.34435287503, 6681.2421070518), new Vsop87.LnVsop(5.2E-10, 3.10877560472, 10419.9862835076), new Vsop87.LnVsop(5.3E-10, 1.49212635155, 5729.506447149), new Vsop87.LnVsop(5.2E-10, 6.16231097097, 7740.6067835888), new Vsop87.LnVsop(5.7E-10, 4.59725498148, 6681.2075997474), new Vsop87.LnVsop(4.7E-10, 6.08280843167, 7875.6718636242), new Vsop87.LnVsop(4.6E-10, 2.2270061836, 6283.0758499914), new Vsop87.LnVsop(4.2E-10, 4.17552906301, 4690.4798363586), new Vsop87.LnVsop(5.3E-10, 4.86310998799, 5621.8429232104), new Vsop87.LnVsop(3.9E-10, 3.01231289993, 26724.8994135984), new Vsop87.LnVsop(4.4E-10, 1.8380744388, 3723.508958923), new Vsop87.LnVsop(4.5E-10, 3.66313190536, 12832.7587417046), new Vsop87.LnVsop(4.9E-10, 2.9067744955, 5331.3574437408), new Vsop87.LnVsop(4.1E-10, 5.09013551341, 8969.568896911), new Vsop87.LnVsop(3.5E-10, 1.80197655191, 9830.3890139878), new Vsop87.LnVsop(3.6E-10, 6.20064893632, 6836.6452528338), new Vsop87.LnVsop(4.1E-10, 4.73855176222, 6677.7017350506), new Vsop87.LnVsop(4.3E-10, 0.12056288166, 7632.9432596502), new Vsop87.LnVsop(3.6E-10, 3.95211035317, 5092.1519581158), new Vsop87.LnVsop(4.1E-10, 1.02183708699, 3339.6321056316), new Vsop87.LnVsop(3.2E-10, 6.08260895536, 4929.6853219836), new Vsop87.LnVsop(2.9E-10, 1.62918363864, 10818.1352869158), new Vsop87.LnVsop(3.3E-10, 5.28926114198, 6298.3283211764), new Vsop87.LnVsop(3.5E-10, 2.19127331195, 3553.9115221378), new Vsop87.LnVsop(3.1E-10, 1.71403126017, 6674.1113063988), new Vsop87.LnVsop(2.7E-10, 2.59859773299, 9623.6882766912), new Vsop87.LnVsop(3.7E-10, 6.26363818135, 15643.6802033098), new Vsop87.LnVsop(2.6E-10, 0.41795219764, 6688.3384004004), new Vsop87.LnVsop(2.5E-10, 2.61050876047, 8955.3418029094), new Vsop87.LnVsop(2.4E-10, 2.7277067014, 7210.9158184942), new Vsop87.LnVsop(2.2E-10, 0.56923205824, 3333.498879699), new Vsop87.LnVsop(2.4E-10, 1.08927112722, 13362.4669604514), new Vsop87.LnVsop(2.4E-10, 1.27631664508, 2146.1654164752), new Vsop87.LnVsop(2.1E-10, 2.25460322522, 6681.2921637024), new Vsop87.LnVsop(2.1E-10, 1.21340354488, 529.6909650946), new Vsop87.LnVsop(1.9E-10, 2.21770037001, 3340.545116397), new Vsop87.LnVsop(1.9E-10, 0.66923624814, 10021.8545337516), new Vsop87.LnVsop(1.9E-10, 4.96725594495, 10021.8200264472), new Vsop87.LnVsop(2.1E-10, 2.66383165337, 6681.1575430968), new Vsop87.LnVsop(1.9E-10, 5.34528034089, 13362.432453147), new Vsop87.LnVsop(2.0E-10, 4.05200075148, 16173.3711684044), new Vsop87.LnVsop(1.8E-10, 6.12827330419, 2118.7638603784), new Vsop87.LnVsop(1.9E-10, 1.81106961128, 3340.6797370026), new Vsop87.LnVsop(2.3E-10, 3.65530501555, 5884.9268465832), new Vsop87.LnVsop(1.7E-10, 3.49526304116, 13760.5987102074), new Vsop87.LnVsop(1.7E-10, 2.19106157796, 13171.0014406876), new Vsop87.LnVsop(1.8E-10, 2.57298367742, 6894.5239488376), new Vsop87.LnVsop(1.5E-10, 3.38406160245, 16706.585251848), new Vsop87.LnVsop(2.0E-10, 5.66097673948, 11773.3768115154), new Vsop87.LnVsop(1.6E-10, 5.03015729119, 8031.0922630584), new Vsop87.LnVsop(1.8E-10, 5.85813180984, 15113.9892382152), new Vsop87.LnVsop(1.5E-10, 0.77504052248, 10028.9508271002), new Vsop87.LnVsop(1.5E-10, 0.57957141835, 10973.55568635), new Vsop87.LnVsop(1.4E-10, 0.24974244701, 5088.6288397668), new Vsop87.LnVsop(1.8E-10, 3.0792442194, 12964.300703391), new Vsop87.LnVsop(1.5E-10, 2.68623334057, 10021.9045904022), new Vsop87.LnVsop(1.5E-10, 3.09469457587, 10021.7699697966), new Vsop87.LnVsop(1.3E-10, 3.93023649028, 10264.5658840734), new Vsop87.LnVsop(1.3E-10, 5.65831284328, 13207.029307365), new Vsop87.LnVsop(1.3E-10, 1.84300811278, 9070.1188738488), new Vsop87.LnVsop(1.4E-10, 0.29740739896, 18984.2926300096), new Vsop87.LnVsop(1.3E-10, 2.52001940946, 7064.1213856228), new Vsop87.LnVsop(1.3E-10, 3.67191025834, 3320.257107301), new Vsop87.LnVsop(1.3E-10, 0.3818273149, 11081.2192102886), new Vsop87.LnVsop(1.5E-10, 5.65316717493, 9638.9407478762), new Vsop87.LnVsop(1.5E-10, 1.9843132823, 14158.7477136156), new Vsop87.LnVsop(1.2E-10, 5.412176385, 12310.1813236108), new Vsop87.LnVsop(1.3E-10, 2.16005341496, 3503.079062832), new Vsop87.LnVsop(1.3E-10, 2.04039005845, 3360.96774609859), new Vsop87.LnVsop(1.2E-10, 3.10587105006, 10551.528245194), new Vsop87.LnVsop(1.2E-10, 0.10001647761, 3355.8648978848), new Vsop87.LnVsop(1.1E-10, 2.14032736093, 10014.7237330986), new Vsop87.LnVsop(1.1E-10, 1.79726060971, 6438.4962494256), new Vsop87.LnVsop(1.4E-10, 0.17608466993, 11216.284290324), new Vsop87.LnVsop(1.1E-10, 3.38101843423, 30065.5118402982), new Vsop87.LnVsop(1.0E-10, 0.14034808917, 5459.3762870782), new Vsop87.LnVsop(1.2E-10, 1.39972628733, 7322.1024607818), new Vsop87.LnVsop(1.0E-10, 5.01174496801, 8432.7643848156), new Vsop87.LnVsop(1.0E-10, 4.85370121323, 8827.3902698748), new Vsop87.LnVsop(1.2E-10, 1.85790840539, 10575.4066829418), new Vsop87.LnVsop(1.1E-10, 5.68929132609, 2544.3144198834), new Vsop87.LnVsop(1.3E-10, 0.1197367513, 8270.2977486834), new Vsop87.LnVsop(1.0E-10, 3.4536682868, 8671.9698704406), new Vsop87.LnVsop(1.0E-10, 1.63456773166, 6467.9257579616), new Vsop87.LnVsop(1.2E-10, 0.48472196247, 9468.267877257), new Vsop87.LnVsop(1.0E-10, 1.79285582925, 3981.490034082), new Vsop87.LnVsop(1.2E-10, 4.3515715374, 13358.9265884502), new Vsop87.LnVsop(1.2E-10, 4.70754717702, 8273.8208670324), new Vsop87.LnVsop(9.0E-11, 5.67195388102, 6041.3275670856), new Vsop87.LnVsop(1.1E-10, 0.28291831064, 10022.8176011676), new Vsop87.LnVsop(1.2E-10, 0.19598354169, 3767.2106175758), new Vsop87.LnVsop(9.0E-11, 0.798881036, 7107.8230442756), new Vsop87.LnVsop(9.0E-11, 2.6388713382, 6040.3472460174), new Vsop87.LnVsop(1.0E-10, 4.24040970796, 10018.3141617504), new Vsop87.LnVsop(8.0E-11, 4.41344390506, 3532.0606928114), new Vsop87.LnVsop(9.0E-11, 4.61082143531, 6254.6266625236), new Vsop87.LnVsop(1.0E-10, 3.14867092101, 12295.9542296092), new Vsop87.LnVsop(8.0E-11, 4.30808895338, 13517.8701062334), new Vsop87.LnVsop(7.0E-11, 3.72930971887, 20047.1976785478), new Vsop87.LnVsop(7.0E-11, 5.31461308603, 3980.5097130138), new Vsop87.LnVsop(7.0E-11, 4.41228197932, 19513.9835951042), new Vsop87.LnVsop(6.0E-11, 0.70081238478, 22324.9050567094), new Vsop87.LnVsop(7.0E-11, 3.46042125643, 16304.9131300908), new Vsop87.LnVsop(6.0E-11, 4.18130136613, 9225.539273283), new Vsop87.LnVsop(7.0E-11, 2.07260074047, 2274.1169495098), new Vsop87.LnVsop(8.0E-11, 4.84690285943, 5614.7293762096), new Vsop87.LnVsop(7.0E-11, 5.81948406996, 18454.601664915), new Vsop87.LnVsop(6.0E-11, 4.58700022729, 12935.8515159232), new Vsop87.LnVsop(6.0E-11, 3.09847010281, 10235.1363755374), new Vsop87.LnVsop(7.0E-11, 5.65100333611, 3325.3599555148), new Vsop87.LnVsop(6.0E-11, 3.88836191013, 8429.2412664666), new Vsop87.LnVsop(6.0E-11, 6.08444137601, 426.598190876), new Vsop87.LnVsop(7.0E-11, 4.3929023553, 16699.53901514999), new Vsop87.LnVsop(6.0E-11, 4.96952219943, 11614.4332937322), new Vsop87.LnVsop(7.0E-11, 3.86534915027, 17101.2111369072), new Vsop87.LnVsop(5.0E-11, 3.27691563611, 213.299095438), new Vsop87.LnVsop(6.0E-11, 2.22078885531, 13916.0191096416), new Vsop87.LnVsop(5.0E-11, 5.4020084326, 11371.7046897582), new Vsop87.LnVsop(6.0E-11, 3.7336954916, 33406.124266998), new Vsop87.LnVsop(5.0E-11, 1.76068977855, 1066.49547719), new Vsop87.LnVsop(5.0E-11, 3.34460420545, 4562.4609930212), new Vsop87.LnVsop(5.0E-11, 5.87001587166, 16547.6417340648), new Vsop87.LnVsop(5.0E-11, 2.58164780968, 10404.7338123226), new Vsop87.LnVsop(5.0E-11, 0.95143416553, 6872.6731195112), new Vsop87.LnVsop(5.0E-11, 3.29623418943, 13362.3823964964), new Vsop87.LnVsop(5.0E-11, 4.15921606694, 0.0172536522), new Vsop87.LnVsop(5.0E-11, 1.88015249528, 15508.6151232744), new Vsop87.LnVsop(5.0E-11, 4.69029931558, 2700.7151403858)};
        static Vsop87.LnVsop[] mars_longitude_l4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(2.7242E-7, 5.6399774232, 6681.2248533996), new Vsop87.LnVsop(2.5511E-7, 5.13956279086, 3340.6124266998), new Vsop87.LnVsop(1.1147E-7, 6.03556608878, 10021.8372800994), new Vsop87.LnVsop(3.19E-8, 3.56206901204, 155.4203994342), new Vsop87.LnVsop(3.251E-8, 0.1291561646, 13362.4497067992), new Vsop87.LnVsop(7.9E-9, 0.48979114861, 16703.062133499), new Vsop87.LnVsop(7.83E-9, 1.31770747646, 242.728603974), new Vsop87.LnVsop(5.0E-9, 3.082009215, 3185.1920272656), new Vsop87.LnVsop(3.74E-9, 2.15499052115, 553.5694028424), new Vsop87.LnVsop(3.38E-9, 6.23352693699, 3.523118349), new Vsop87.LnVsop(1.99E-9, 0.45348344109, 3344.1355450488), new Vsop87.LnVsop(1.68E-9, 3.76870889622, 3496.032826134), new Vsop87.LnVsop(1.71E-9, 0.84135133604, 20043.6745601988), new Vsop87.LnVsop(1.15E-9, 1.6742527126, 3583.3410306738), new Vsop87.LnVsop(8.0E-10, 0.85706484335, 6684.7479717486), new Vsop87.LnVsop(9.1E-10, 3.4380000389, 6525.8044539654), new Vsop87.LnVsop(6.2E-10, 4.48712111677, 2787.0430238574), new Vsop87.LnVsop(4.3E-10, 5.18700577258, 3097.88382272579), new Vsop87.LnVsop(4.7E-10, 0.0, 0.0), new Vsop87.LnVsop(3.7E-10, 1.18296722277, 23384.2869868986), new Vsop87.LnVsop(2.4E-10, 4.29204464862, 6836.6452528338), new Vsop87.LnVsop(2.6E-10, 1.20348583477, 10025.3603984484), new Vsop87.LnVsop(2.4E-10, 5.60827511165, 4136.9104335162), new Vsop87.LnVsop(2.2E-10, 5.74642710221, 3149.1641605882), new Vsop87.LnVsop(1.8E-10, 2.03318579635, 6923.9534573736), new Vsop87.LnVsop(1.5E-10, 4.26014468247, 3341.592747768), new Vsop87.LnVsop(1.8E-10, 2.33884195894, 3894.1818295422), new Vsop87.LnVsop(1.5E-10, 0.76745028682, 3738.761430108), new Vsop87.LnVsop(1.3E-10, 3.78255342218, 9866.4168806652), new Vsop87.LnVsop(1.3E-10, 4.8466966556, 6127.6554505572), new Vsop87.LnVsop(1.5E-10, 5.9090457737, 2388.8940204492), new Vsop87.LnVsop(1.2E-10, 4.04057703674, 4535.0594369244), new Vsop87.LnVsop(1.1E-10, 3.87847882201, 1059.3819301892), new Vsop87.LnVsop(1.1E-10, 6.15709897926, 6489.776587288), new Vsop87.LnVsop(1.0E-10, 1.72288144187, 9492.1463150048), new Vsop87.LnVsop(1.0E-10, 1.57846217224, 13365.9728251482), new Vsop87.LnVsop(8.0E-11, 2.41269301261, 1592.5960136328), new Vsop87.LnVsop(8.0E-11, 3.38799237939, 2957.7158944766), new Vsop87.LnVsop(8.0E-11, 6.0985851946, 7477.522860216), new Vsop87.LnVsop(1.0E-10, 1.26692397596, 1990.745017041), new Vsop87.LnVsop(1.0E-10, 1.19094173671, 7079.3738568078), new Vsop87.LnVsop(1.1E-10, 4.27677188971, 4399.994356889), new Vsop87.LnVsop(8.0E-11, 4.14850970681, 13207.029307365), new Vsop87.LnVsop(8.0E-11, 1.5429740675, 26724.8994135984), new Vsop87.LnVsop(7.0E-11, 0.26868468775, 9830.3890139878), new Vsop87.LnVsop(7.0E-11, 0.08101546764, 10818.1352869158), new Vsop87.LnVsop(7.0E-11, 2.4250828952, 10264.5658840734), new Vsop87.LnVsop(7.0E-11, 5.57348066316, 6438.4962494256), new Vsop87.LnVsop(7.0E-11, 4.62218969676, 10177.2576795336), new Vsop87.LnVsop(8.0E-11, 0.34286691468, 3723.508958923), new Vsop87.LnVsop(6.0E-11, 1.60196605908, 10419.9862835076), new Vsop87.LnVsop(6.0E-11, 4.33371839115, 4292.3308329504), new Vsop87.LnVsop(7.0E-11, 4.61281837777, 7875.6718636242), new Vsop87.LnVsop(6.0E-11, 4.67857531326, 2544.3144198834), new Vsop87.LnVsop(7.0E-11, 1.51290306715, 5331.3574437408), new Vsop87.LnVsop(6.0E-11, 4.16295898909, 12303.06777661), new Vsop87.LnVsop(6.0E-11, 4.52108494056, 3532.0606928114), new Vsop87.LnVsop(6.0E-11, 4.66651817095, 7740.6067835888), new Vsop87.LnVsop(5.0E-11, 6.26581073985, 5729.506447149), new Vsop87.LnVsop(5.0E-11, 2.75621336253, 4690.4798363586), new Vsop87.LnVsop(5.0E-11, 2.78107610422, 4933.2084403326), new Vsop87.LnVsop(5.0E-11, 4.63812650627, 6682.2051744678), new Vsop87.LnVsop(5.0E-11, 5.81870543856, 2146.1654164752), new Vsop87.LnVsop(4.0E-11, 4.97648147254, 3347.7259737006), new Vsop87.LnVsop(4.0E-11, 1.92818801589, 16706.585251848), new Vsop87.LnVsop(4.0E-11, 3.51723776816, 5486.777843175), new Vsop87.LnVsop(4.0E-11, 4.3762291902, 3337.0893083508), new Vsop87.LnVsop(3.0E-11, 3.74520053012, 6298.3283211764), new Vsop87.LnVsop(3.0E-11, 4.94059407345, 11081.2192102886), new Vsop87.LnVsop(3.0E-11, 5.20767397767, 9468.267877257), new Vsop87.LnVsop(2.0E-11, 5.60261719076, 3333.498879699), new Vsop87.LnVsop(3.0E-11, 6.08152672681, 3339.6321056316), new Vsop87.LnVsop(2.0E-11, 1.90275008409, 30065.5118402982), new Vsop87.LnVsop(3.0E-11, 3.36064341832, 5621.8429232104), new Vsop87.LnVsop(2.0E-11, 0.0114193751, 10551.528245194)};
        static Vsop87.LnVsop[] mars_longitude_l5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(7.62E-9, 4.03556368806, 6681.2248533996), new Vsop87.LnVsop(5.11E-9, 4.4877039364, 10021.8372800994), new Vsop87.LnVsop(3.6E-9, 5.07296615717, 155.4203994342), new Vsop87.LnVsop(2.02E-9, 4.8836132144, 13362.4497067992), new Vsop87.LnVsop(1.65E-9, 3.48592135141, 3340.6124266998), new Vsop87.LnVsop(1.0E-9, 6.09065293613, 242.728603974), new Vsop87.LnVsop(6.2E-10, 5.25625355993, 16703.062133499), new Vsop87.LnVsop(6.4E-10, 1.57192173495, 3185.1920272656), new Vsop87.LnVsop(3.5E-10, 3.68331841812, 553.5694028424), new Vsop87.LnVsop(1.6E-10, 5.23951751422, 3496.032826134), new Vsop87.LnVsop(1.7E-10, 5.60862454832, 20043.6745601988), new Vsop87.LnVsop(1.6E-10, 0.16723854805, 3583.3410306738), new Vsop87.LnVsop(1.1E-10, 1.93419597527, 6525.8044539654), new Vsop87.LnVsop(7.0E-11, 5.17525588419, 3344.1355450488), new Vsop87.LnVsop(7.0E-11, 2.97300501488, 2787.0430238574), new Vsop87.LnVsop(5.0E-11, 0.39000584564, 3097.88382272579), new Vsop87.LnVsop(5.0E-11, 5.60123387975, 6684.7479717486), new Vsop87.LnVsop(4.0E-11, 5.97749583912, 23384.2869868986), new Vsop87.LnVsop(3.0E-11, 2.29064254081, 9866.4168806652), new Vsop87.LnVsop(3.0E-11, 0.52716684104, 6923.9534573736), new Vsop87.LnVsop(3.0E-11, 6.06139189331, 10025.3603984484), new Vsop87.LnVsop(2.0E-11, 0.0, 0.0), new Vsop87.LnVsop(2.0E-11, 0.06588431932, 26724.8994135984), new Vsop87.LnVsop(1.0E-11, 3.33966357719, 6127.6554505572)};

        Lontitude1() {
        }
    }

    static class Lontitude0 {
        static Vsop87.LnVsop[] mars_longitude_l0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(6.20347711581, 0.0, 0.0), new Vsop87.LnVsop(0.18656368093, 5.0503710027, 3340.6124266998), new Vsop87.LnVsop(0.01108216816, 5.40099836344, 6681.2248533996), new Vsop87.LnVsop(9.1798406E-4, 5.75478744667, 10021.8372800994), new Vsop87.LnVsop(2.7744987E-4, 5.97049513147, 3.523118349), new Vsop87.LnVsop(1.0610235E-4, 2.93958560338, 2281.2304965106), new Vsop87.LnVsop(1.2315897E-4, 0.84956094002, 2810.9214616052), new Vsop87.LnVsop(8.926784E-5, 4.15697846427, 0.0172536522), new Vsop87.LnVsop(8.715691E-5, 6.11005153139, 13362.4497067992), new Vsop87.LnVsop(6.797556E-5, 0.36462229657, 398.1490034082), new Vsop87.LnVsop(7.774872E-5, 3.33968761376, 5621.8429232104), new Vsop87.LnVsop(3.575078E-5, 1.6618650571, 2544.3144198834), new Vsop87.LnVsop(4.161108E-5, 0.22814971327, 2942.4634232916), new Vsop87.LnVsop(3.075252E-5, 0.85696614132, 191.4482661116), new Vsop87.LnVsop(2.628117E-5, 0.64806124465, 3337.0893083508), new Vsop87.LnVsop(2.937546E-5, 6.07893711402, 0.0673103028), new Vsop87.LnVsop(2.389414E-5, 5.03896442664, 796.2980068164), new Vsop87.LnVsop(2.579844E-5, 0.02996736156, 3344.1355450488), new Vsop87.LnVsop(1.528141E-5, 1.14979301996, 6151.533888305), new Vsop87.LnVsop(1.798806E-5, 0.65634057445, 529.6909650946), new Vsop87.LnVsop(1.264357E-5, 3.62275122593, 5092.1519581158), new Vsop87.LnVsop(1.286228E-5, 3.06796065034, 2146.1654164752), new Vsop87.LnVsop(1.546404E-5, 2.91579701718, 1751.539531416), new Vsop87.LnVsop(1.024902E-5, 3.69334099279, 8962.4553499102), new Vsop87.LnVsop(8.91566E-6, 0.18293837498, 16703.062133499), new Vsop87.LnVsop(8.58759E-6, 2.4009381194, 2914.0142358238), new Vsop87.LnVsop(8.32715E-6, 2.46418619474, 3340.5951730476), new Vsop87.LnVsop(8.3272E-6, 4.49495782139, 3340.629680352), new Vsop87.LnVsop(7.12902E-6, 3.66335473479, 1059.3819301892), new Vsop87.LnVsop(7.48723E-6, 3.82248614017, 155.4203994342), new Vsop87.LnVsop(7.23861E-6, 0.67497311481, 3738.761430108), new Vsop87.LnVsop(6.35548E-6, 2.92182225127, 8432.7643848156), new Vsop87.LnVsop(6.55162E-6, 0.48864064125, 3127.3133312618), new Vsop87.LnVsop(5.50474E-6, 3.81001042328, 0.9803210682), new Vsop87.LnVsop(5.5275E-6, 4.47479317037, 1748.016413067), new Vsop87.LnVsop(4.25966E-6, 0.55364317304, 6283.0758499914), new Vsop87.LnVsop(4.15131E-6, 0.49662285038, 213.299095438), new Vsop87.LnVsop(4.72167E-6, 3.62547124025, 1194.4470102246), new Vsop87.LnVsop(3.06551E-6, 0.38052848348, 6684.7479717486), new Vsop87.LnVsop(3.12141E-6, 0.99853944405, 6677.7017350506), new Vsop87.LnVsop(2.93198E-6, 4.22131299634, 20.7753954924), new Vsop87.LnVsop(3.02375E-6, 4.48618007156, 3532.0606928114), new Vsop87.LnVsop(2.74027E-6, 0.54222167059, 3340.545116397), new Vsop87.LnVsop(2.81079E-6, 5.88163521788, 1349.8674096588), new Vsop87.LnVsop(2.31183E-6, 1.28242156993, 3870.3033917944), new Vsop87.LnVsop(2.83602E-6, 5.7688543494, 3149.1641605882), new Vsop87.LnVsop(2.36117E-6, 5.75503217933, 3333.498879699), new Vsop87.LnVsop(2.74033E-6, 0.13372524985, 3340.6797370026), new Vsop87.LnVsop(2.99395E-6, 2.78323740866, 6254.6266625236), new Vsop87.LnVsop(2.04162E-6, 2.82133445874, 1221.8485663214), new Vsop87.LnVsop(2.38866E-6, 5.37153646326, 4136.9104335162), new Vsop87.LnVsop(1.88648E-6, 1.4910406604, 9492.1463150048), new Vsop87.LnVsop(2.21228E-6, 3.50466812198, 382.8965322232), new Vsop87.LnVsop(1.79196E-6, 1.00561962003, 951.7184062506), new Vsop87.LnVsop(1.72117E-6, 0.43943649536, 5486.777843175), new Vsop87.LnVsop(1.93118E-6, 3.35716641911, 3.5904286518), new Vsop87.LnVsop(1.44304E-6, 1.41874112114, 135.0650800354), new Vsop87.LnVsop(1.60016E-6, 3.94857092451, 4562.4609930212), new Vsop87.LnVsop(1.74072E-6, 2.41361337725, 553.5694028424), new Vsop87.LnVsop(1.30989E-6, 4.04491134956, 12303.06777661), new Vsop87.LnVsop(1.38243E-6, 4.30145122848, 7.1135470008), new Vsop87.LnVsop(1.28062E-6, 1.8066581622, 5088.6288397668), new Vsop87.LnVsop(1.39898E-6, 3.32595559208, 2700.7151403858), new Vsop87.LnVsop(1.28105E-6, 2.20807538189, 1592.5960136328), new Vsop87.LnVsop(1.16944E-6, 3.12806863456, 7903.073419721), new Vsop87.LnVsop(1.10378E-6, 1.05194545948, 242.728603974), new Vsop87.LnVsop(1.13481E-6, 3.70070432339, 1589.0728952838), new Vsop87.LnVsop(1.00099E-6, 3.24340223714, 11773.3768115154), new Vsop87.LnVsop(9.5594E-7, 0.53950648295, 20043.6745601988), new Vsop87.LnVsop(9.8947E-7, 4.84558326403, 6681.2421070518), new Vsop87.LnVsop(1.04542E-6, 0.78532737699, 8827.3902698748), new Vsop87.LnVsop(8.4186E-7, 3.98971116025, 4399.994356889), new Vsop87.LnVsop(8.6928E-7, 2.20183965407, 11243.6858464208), new Vsop87.LnVsop(7.1438E-7, 2.80307223477, 3185.1920272656), new Vsop87.LnVsop(7.2095E-7, 5.84669532401, 5884.9268465832), new Vsop87.LnVsop(7.3482E-7, 2.18421190324, 8429.2412664666), new Vsop87.LnVsop(9.8946E-7, 2.81481171439, 6681.2075997474), new Vsop87.LnVsop(6.8413E-7, 2.73834597183, 2288.3440435114), new Vsop87.LnVsop(8.6747E-7, 1.02091867465, 7079.3738568078), new Vsop87.LnVsop(6.5316E-7, 2.68114882713, 28.4491874678), new Vsop87.LnVsop(8.3745E-7, 3.20254912006, 4690.4798363586), new Vsop87.LnVsop(7.5031E-7, 0.76647765061, 6467.9257579616), new Vsop87.LnVsop(6.8983E-7, 3.76403440528, 6041.3275670856), new Vsop87.LnVsop(6.6706E-7, 0.73630288873, 3723.508958923), new Vsop87.LnVsop(6.3313E-7, 4.5277185022, 426.598190876), new Vsop87.LnVsop(6.1684E-7, 6.16831461502, 2274.1169495098), new Vsop87.LnVsop(5.226E-7, 0.89938935091, 9623.6882766912), new Vsop87.LnVsop(5.5485E-7, 4.60622447136, 4292.3308329504), new Vsop87.LnVsop(5.1331E-7, 4.14823934301, 3341.592747768), new Vsop87.LnVsop(5.6633E-7, 5.06250402329, 15.252471185), new Vsop87.LnVsop(6.3376E-7, 0.91293637746, 3553.9115221378), new Vsop87.LnVsop(4.5822E-7, 0.78790300125, 1990.745017041), new Vsop87.LnVsop(4.8553E-7, 3.95677994023, 4535.0594369244), new Vsop87.LnVsop(4.1223E-7, 6.02013764154, 3894.1818295422), new Vsop87.LnVsop(4.1941E-7, 3.58309124437, 8031.0922630584), new Vsop87.LnVsop(5.6395E-7, 1.68727941626, 6872.6731195112), new Vsop87.LnVsop(5.5907E-7, 3.46261441099, 263.0839233728), new Vsop87.LnVsop(5.1677E-7, 2.81307639242, 3339.6321056316), new Vsop87.LnVsop(4.0669E-7, 3.13838566327, 9595.2390892234), new Vsop87.LnVsop(3.8111E-7, 0.73396370751, 10025.3603984484), new Vsop87.LnVsop(3.9498E-7, 5.6322574136, 3097.88382272579), new Vsop87.LnVsop(4.4175E-7, 3.19530118759, 5628.9564702112), new Vsop87.LnVsop(3.6718E-7, 2.63750919104, 692.1576012268), new Vsop87.LnVsop(4.5905E-7, 0.28717581576, 5614.7293762096), new Vsop87.LnVsop(3.8351E-7, 5.82880639987, 3191.0492295652), new Vsop87.LnVsop(3.8198E-7, 2.34832438823, 162.4666361322), new Vsop87.LnVsop(3.2561E-7, 0.48401318272, 6681.2921637024), new Vsop87.LnVsop(3.7135E-7, 0.68510839331, 2818.035008606), new Vsop87.LnVsop(3.1169E-7, 3.98160436995, 20.3553193988), new Vsop87.LnVsop(3.2561E-7, 0.89250965753, 6681.1575430968), new Vsop87.LnVsop(3.7749E-7, 4.15481250779, 2803.8079146044), new Vsop87.LnVsop(3.3626E-7, 6.11997987693, 6489.776587288), new Vsop87.LnVsop(2.9007E-7, 2.42707198395, 3319.8370312074), new Vsop87.LnVsop(3.8794E-7, 1.35194224244, 10018.3141617504), new Vsop87.LnVsop(3.3149E-7, 1.140241952, 5.5229243074), new Vsop87.LnVsop(2.7583E-7, 1.59721760699, 7210.9158184942), new Vsop87.LnVsop(2.8699E-7, 5.7204755094, 7477.522860216), new Vsop87.LnVsop(3.4039E-7, 2.59525636978, 11769.8536931664), new Vsop87.LnVsop(2.538E-7, 0.52092092633, 10.6366653498), new Vsop87.LnVsop(2.6355E-7, 1.34519007001, 3496.032826134), new Vsop87.LnVsop(2.4555E-7, 4.00321315879, 11371.7046897582), new Vsop87.LnVsop(2.5637E-7, 0.24963503109, 522.5774180938), new Vsop87.LnVsop(2.7275E-7, 4.55649766071, 3361.3878221922), new Vsop87.LnVsop(2.3766E-7, 1.84063759173, 12832.7587417046), new Vsop87.LnVsop(2.2814E-7, 3.52628452806, 1648.4467571974), new Vsop87.LnVsop(2.2272E-7, 0.72111173236, 266.6070417218), new Vsop87.LnVsop(2.1201E-7, 3.11823578369, 2957.7158944766), new Vsop87.LnVsop(2.0156E-7, 3.6714730871, 1758.6530784168), new Vsop87.LnVsop(2.153E-7, 6.15388673691, 3264.3463554242), new Vsop87.LnVsop(2.009E-7, 1.08241387913, 7064.1213856228), new Vsop87.LnVsop(2.1344E-7, 4.28178434496, 4032.7700279266), new Vsop87.LnVsop(2.7541E-7, 6.08386421472, 6674.1113063988), new Vsop87.LnVsop(1.9842E-7, 2.37674123073, 10713.9948813262), new Vsop87.LnVsop(2.5518E-7, 3.43241978555, 3443.7052009184), new Vsop87.LnVsop(2.2542E-7, 5.64861441506, 2388.8940204492), new Vsop87.LnVsop(2.4376E-7, 0.97006548518, 632.7837393132), new Vsop87.LnVsop(2.3079E-7, 4.74990771219, 3347.7259737006), new Vsop87.LnVsop(1.7708E-7, 3.69743280195, 3344.2028553516), new Vsop87.LnVsop(2.2658E-7, 3.95447568336, 4989.0591838972), new Vsop87.LnVsop(2.26E-7, 5.24085203262, 3205.5473466644), new Vsop87.LnVsop(1.6811E-7, 5.48619684184, 3.881335358), new Vsop87.LnVsop(1.8422E-7, 4.22550249103, 2787.0430238574), new Vsop87.LnVsop(2.2735E-7, 4.98523942294, 7632.9432596502), new Vsop87.LnVsop(1.6638E-7, 2.52822534159, 14584.2982731206), new Vsop87.LnVsop(2.0963E-7, 4.27879531719, 5099.2655051166), new Vsop87.LnVsop(1.6033E-7, 1.76789519365, 3475.6775067352), new Vsop87.LnVsop(1.5814E-7, 3.1324185768, 59.3738619136), new Vsop87.LnVsop(1.8113E-7, 3.25756742113, 3337.021998048), new Vsop87.LnVsop(1.9295E-7, 3.23912725911, 7.046236698), new Vsop87.LnVsop(1.6777E-7, 4.39731653353, 15643.6802033098), new Vsop87.LnVsop(1.7554E-7, 4.09198247074, 74.7815985673), new Vsop87.LnVsop(1.3713E-7, 2.54103541653, 4933.2084403326), new Vsop87.LnVsop(1.6007E-7, 1.54673981973, 14054.607308026), new Vsop87.LnVsop(1.4603E-7, 3.45689862899, 7373.3824546264), new Vsop87.LnVsop(1.3547E-7, 4.04141743525, 4929.6853219836), new Vsop87.LnVsop(1.4222E-7, 0.59967781578, 23.8784377478), new Vsop87.LnVsop(1.3876E-7, 5.40880274251, 10973.55568635), new Vsop87.LnVsop(1.4026E-7, 1.44210504015, 10404.7338123226), new Vsop87.LnVsop(1.6055E-7, 3.79399064336, 2118.7638603784), new Vsop87.LnVsop(1.3717E-7, 3.59037690181, 15113.9892382152), new Vsop87.LnVsop(1.804E-7, 4.25416134565, 2487.4160449478), new Vsop87.LnVsop(1.5846E-7, 0.56902641445, 103.0927742186), new Vsop87.LnVsop(1.3402E-7, 5.16918481175, 10213.285546211), new Vsop87.LnVsop(1.6068E-7, 2.36894092837, 3265.8308281325), new Vsop87.LnVsop(1.2773E-7, 0.1047416194, 7234.794256242), new Vsop87.LnVsop(1.2197E-7, 1.73028863618, 36.0278666774), new Vsop87.LnVsop(1.2283E-7, 5.19941258642, 10021.8545337516), new Vsop87.LnVsop(1.1947E-7, 5.4798057443, 2921.1277828246), new Vsop87.LnVsop(1.189E-7, 4.76587196145, 5828.0284716476), new Vsop87.LnVsop(1.2283E-7, 3.16864076359, 10021.8200264472), new Vsop87.LnVsop(1.3269E-7, 6.17851484916, 1744.4259844152), new Vsop87.LnVsop(1.1749E-7, 5.72731481869, 0.42007609361), new Vsop87.LnVsop(1.234E-7, 2.52148348822, 2906.900688823), new Vsop87.LnVsop(1.4458E-7, 4.38011275876, 316.3918696566), new Vsop87.LnVsop(1.064E-7, 3.44997335322, 639.897286314), new Vsop87.LnVsop(1.0925E-7, 0.60402475795, 5085.038411115), new Vsop87.LnVsop(1.0646E-7, 5.47663096745, 419.4846438752), new Vsop87.LnVsop(1.0795E-7, 1.37204952026, 10419.9862835076), new Vsop87.LnVsop(1.0573E-7, 1.09027262515, 12168.0026965746), new Vsop87.LnVsop(9.578E-8, 4.89483638811, 3230.4061054804), new Vsop87.LnVsop(9.805E-8, 5.83614893022, 14314.1681130498), new Vsop87.LnVsop(9.718E-8, 1.1311901E-4, 9225.539273283), new Vsop87.LnVsop(9.146E-8, 1.1028855904, 9808.5381846614), new Vsop87.LnVsop(9.779E-8, 3.60055224203, 206.1855484372), new Vsop87.LnVsop(1.2732E-7, 1.7988034427, 13745.3462390224), new Vsop87.LnVsop(1.2156E-7, 4.42292535673, 14712.317116458), new Vsop87.LnVsop(8.805E-8, 3.97132756722, 170.6728706192), new Vsop87.LnVsop(1.0682E-7, 4.33907151559, 7740.6067835888), new Vsop87.LnVsop(1.004E-7, 1.38291942087, 3583.3410306738), new Vsop87.LnVsop(9.961E-8, 2.6911659735, 36.6053653042), new Vsop87.LnVsop(8.473E-8, 4.29275471153, 0.4298831267), new Vsop87.LnVsop(1.0584E-7, 0.89643083679, 23384.2869868986), new Vsop87.LnVsop(9.597E-8, 4.33289499954, 131.5419616864), new Vsop87.LnVsop(8.477E-8, 2.86885079661, 9381.9399937854), new Vsop87.LnVsop(8.436E-8, 3.15234316178, 6525.8044539654), new Vsop87.LnVsop(7.518E-8, 1.24474332957, 6894.5239488376), new Vsop87.LnVsop(6.746E-8, 1.58828730801, 6836.6452528338), new Vsop87.LnVsop(6.722E-8, 4.38897665506, 66.4874089144), new Vsop87.LnVsop(6.738E-8, 5.77292945138, 5202.3582793352), new Vsop87.LnVsop(6.243E-8, 1.57847357313, 3325.3599555148), new Vsop87.LnVsop(8.446E-8, 2.90692880268, 43.718912305), new Vsop87.LnVsop(6.482E-8, 6.03333628981, 574.3447983348), new Vsop87.LnVsop(6.348E-8, 0.06986409522, 1964.838626854), new Vsop87.LnVsop(6.193E-8, 5.43709781754, 1861.7458526354), new Vsop87.LnVsop(8.246E-8, 0.44145777409, 2707.8286873866), new Vsop87.LnVsop(5.987E-8, 4.22748552841, 4459.3682188026), new Vsop87.LnVsop(6.53E-8, 1.24945509771, 12964.300703391), new Vsop87.LnVsop(5.949E-8, 0.77228459543, 2699.7348193176), new Vsop87.LnVsop(7.339E-8, 4.95735130126, 3767.2106175758), new Vsop87.LnVsop(6.135E-8, 3.16322568315, 6680.2445323314), new Vsop87.LnVsop(6.027E-8, 3.01298246255, 3369.0616141676), new Vsop87.LnVsop(5.857E-8, 4.30341888951, 7875.6718636242), new Vsop87.LnVsop(6.36E-8, 1.77803516211, 2178.137722292), new Vsop87.LnVsop(5.771E-8, 0.96116030741, 13916.0191096416), new Vsop87.LnVsop(6.1E-8, 4.49881794524, 6682.2051744678), new Vsop87.LnVsop(5.777E-8, 4.9299329035, 2384.3232707292), new Vsop87.LnVsop(7.647E-8, 6.1629159127, 6531.661656265), new Vsop87.LnVsop(7.242E-8, 0.52885257496, 10575.4066829418), new Vsop87.LnVsop(5.311E-8, 4.51564606382, 6144.4203413042), new Vsop87.LnVsop(5.212E-8, 3.49017198482, 12935.8515159232), new Vsop87.LnVsop(6.68E-8, 3.48192412858, 1118.7557921028), new Vsop87.LnVsop(5.226E-8, 3.25464016223, 2391.43681773), new Vsop87.LnVsop(5.215E-8, 0.01031380055, 533.2140834436), new Vsop87.LnVsop(5.534E-8, 3.42311181658, 3134.4268782626), new Vsop87.LnVsop(5.437E-8, 6.18510783147, 8425.6508378148), new Vsop87.LnVsop(5.774E-8, 3.55189251089, 8969.568896911), new Vsop87.LnVsop(5.093E-8, 0.60862188744, 8955.3418029094), new Vsop87.LnVsop(4.84E-8, 4.6323353216, 4569.574540022), new Vsop87.LnVsop(5.828E-8, 5.92311700172, 640.8776073822), new Vsop87.LnVsop(5.686E-8, 0.76212811066, 3120.199784261), new Vsop87.LnVsop(4.912E-8, 1.70752765226, 13358.9265884502), new Vsop87.LnVsop(5.49E-8, 4.29423846802, 3503.079062832), new Vsop87.LnVsop(4.676E-8, 3.34239248969, 3116.2676309979), new Vsop87.LnVsop(5.858E-8, 2.38460385828, 3302.479391062), new Vsop87.LnVsop(5.098E-8, 1.12472834482, 5331.3574437408), new Vsop87.LnVsop(4.412E-8, 1.38574902846, 17256.6315363414), new Vsop87.LnVsop(4.261E-8, 1.69359026235, 13524.9163429314), new Vsop87.LnVsop(4.191E-8, 0.19115182648, 9830.3890139878), new Vsop87.LnVsop(4.164E-8, 0.43810126153, 1066.49547719), new Vsop87.LnVsop(5.192E-8, 3.63498024808, 536.8045120954), new Vsop87.LnVsop(5.664E-8, 0.50444427941, 5305.4510535538), new Vsop87.LnVsop(5.477E-8, 5.96812391483, 3074.005384978), new Vsop87.LnVsop(5.303E-8, 5.40010329848, 3355.8648978848), new Vsop87.LnVsop(4.043E-8, 0.83846792979, 10021.9045904022), new Vsop87.LnVsop(4.153E-8, 3.14489443759, 8439.8779318164), new Vsop87.LnVsop(4.818E-8, 1.08987352671, 13365.9728251482), new Vsop87.LnVsop(4.906E-8, 3.73076098617, 1228.9621133222), new Vsop87.LnVsop(4.577E-8, 0.99356399425, 6158.6474353058), new Vsop87.LnVsop(4.244E-8, 3.87048930395, 3312.163239232), new Vsop87.LnVsop(4.895E-8, 6.24828800623, 17654.7805397496), new Vsop87.LnVsop(3.595E-8, 6.07310183986, 10818.1352869158), new Vsop87.LnVsop(3.756E-8, 1.37897245496, 3973.396166013), new Vsop87.LnVsop(3.55E-8, 1.87497578775, 17395.2197347258), new Vsop87.LnVsop(4.422E-8, 2.89970459985, 6247.5131155228), new Vsop87.LnVsop(3.974E-8, 4.03444710872, 1052.2683831884), new Vsop87.LnVsop(3.488E-8, 4.2735422538, 3178.1457905676), new Vsop87.LnVsop(4.466E-8, 4.59168154738, 5518.7501489918), new Vsop87.LnVsop(3.504E-8, 1.95078768847, 10177.2576795336), new Vsop87.LnVsop(3.545E-8, 4.24640764495, 8329.671610597), new Vsop87.LnVsop(3.3E-8, 0.68858529246, 149.5631971346), new Vsop87.LnVsop(3.991E-8, 5.80869405128, 6261.7402095244), new Vsop87.LnVsop(3.226E-8, 3.90164588465, 27.4015560968), new Vsop87.LnVsop(3.39E-8, 0.14332355443, 10014.7237330986), new Vsop87.LnVsop(3.375E-8, 0.74696081381, 6048.4411140864), new Vsop87.LnVsop(3.093E-8, 3.98501630391, 2648.454825473), new Vsop87.LnVsop(3.822E-8, 5.23989334866, 5724.935697429), new Vsop87.LnVsop(3.026E-8, 0.34307994694, 220.4126424388), new Vsop87.LnVsop(4.049E-8, 1.2469209082, 10021.7699697966), new Vsop87.LnVsop(2.937E-8, 0.73100893561, 2.751510611), new Vsop87.LnVsop(3.084E-8, 3.79912966727, 169.580183133), new Vsop87.LnVsop(4.04E-8, 2.9125820666, 22747.2907148744), new Vsop87.LnVsop(3.225E-8, 0.92584522637, 16865.5287696312), new Vsop87.LnVsop(3.243E-8, 4.90809670862, 6702.000248892), new Vsop87.LnVsop(2.875E-8, 1.47258377214, 3346.1353510072), new Vsop87.LnVsop(3.723E-8, 0.49976277066, 1.4844727083), new Vsop87.LnVsop(2.799E-8, 3.26685863564, 9168.6408983474), new Vsop87.LnVsop(3.345E-8, 0.68842924327, 3863.1898447936), new Vsop87.LnVsop(3.441E-8, 2.77691833127, 6660.4494579072), new Vsop87.LnVsop(2.795E-8, 2.79655682319, 16858.4825329332), new Vsop87.LnVsop(2.706E-8, 0.19204297927, 3237.5196524812), new Vsop87.LnVsop(2.719E-8, 3.26623695003, 3914.9572250346), new Vsop87.LnVsop(2.941E-8, 3.76174799212, 6784.3176276182), new Vsop87.LnVsop(2.703E-8, 4.40716851372, 3415.3940252671), new Vsop87.LnVsop(3.071E-8, 5.48172683108, 3335.0895023924), new Vsop87.LnVsop(2.706E-8, 5.08478774948, 6688.3384004004), new Vsop87.LnVsop(2.606E-8, 4.83038014027, 4672.6673142406), new Vsop87.LnVsop(2.892E-8, 2.64043893512, 3320.257107301), new Vsop87.LnVsop(3.089E-8, 4.39622402117, 1332.0548875408), new Vsop87.LnVsop(3.44E-8, 1.93696278155, 10551.528245194), new Vsop87.LnVsop(2.744E-8, 3.68787946756, 3603.6963500726), new Vsop87.LnVsop(3.424E-8, 0.20932047468, 6604.958782124), new Vsop87.LnVsop(2.507E-8, 2.87961885832, 17924.9106998204), new Vsop87.LnVsop(2.697E-8, 2.6689100439, 10184.3039162316), new Vsop87.LnVsop(2.454E-8, 3.46791398294, 6298.3283211764), new Vsop87.LnVsop(2.379E-8, 1.05700925037, 3607.2194684216), new Vsop87.LnVsop(2.377E-8, 0.86177958347, 3351.2490920496), new Vsop87.LnVsop(2.568E-8, 5.55935655242, 6546.1597733642), new Vsop87.LnVsop(2.303E-8, 6.07222464974, 1214.7350193206), new Vsop87.LnVsop(2.381E-8, 4.30392652519, 3360.96774609859), new Vsop87.LnVsop(2.907E-8, 3.43885474942, 2693.601593385), new Vsop87.LnVsop(3.097E-8, 2.18292873348, 16173.3711684044), new Vsop87.LnVsop(2.547E-8, 4.18352013454, 3546.797975137), new Vsop87.LnVsop(2.99E-8, 2.37498622349, 13517.8701062334), new Vsop87.LnVsop(2.512E-8, 5.9930297015, 5729.506447149), new Vsop87.LnVsop(2.193E-8, 5.58483652772, 664.75604513), new Vsop87.LnVsop(2.469E-8, 2.81007799544, 15110.4661198662), new Vsop87.LnVsop(2.151E-8, 3.59887716883, 6677.6344247478), new Vsop87.LnVsop(2.116E-8, 4.57150032138, 6127.6554505572), new Vsop87.LnVsop(2.156E-8, 3.3598073575, 589.0648270082), new Vsop87.LnVsop(2.26E-8, 3.62776312745, 7799.9806455024), new Vsop87.LnVsop(2.155E-8, 3.21566530565, 20199.094959633), new Vsop87.LnVsop(2.708E-8, 5.89397867482, 6438.4962494256), new Vsop87.LnVsop(2.202E-8, 4.69968998758, 17277.4069318338), new Vsop87.LnVsop(2.13E-8, 2.518195156, 1545.3539829788), new Vsop87.LnVsop(2.103E-8, 4.03662691701, 6684.8152820514), new Vsop87.LnVsop(2.248E-8, 5.26146259988, 5618.3198048614), new Vsop87.LnVsop(2.112E-8, 4.80366454046, 3657.0042963564), new Vsop87.LnVsop(2.265E-8, 3.8740039934, 110.2063212194), new Vsop87.LnVsop(2.521E-8, 4.21232150896, 2494.5295919486), new Vsop87.LnVsop(2.152E-8, 4.59125527293, 5625.3660415594), new Vsop87.LnVsop(2.479E-8, 6.10418212957, 3329.97576135), new Vsop87.LnVsop(1.914E-8, 1.2190558906, 21.8508293264), new Vsop87.LnVsop(2.334E-8, 0.90610189054, 227.476132789), new Vsop87.LnVsop(1.855E-8, 2.03707389061, 56.8983749356), new Vsop87.LnVsop(1.886E-8, 4.1257845639, 3399.9862886134), new Vsop87.LnVsop(2.271E-8, 3.78991888381, 7910.1869667218), new Vsop87.LnVsop(1.868E-8, 3.01921987575, 4885.9664096786), new Vsop87.LnVsop(2.137E-8, 4.75111320702, 18984.2926300096), new Vsop87.LnVsop(2.035E-8, 2.75110313856, 128.0188433374), new Vsop87.LnVsop(1.771E-8, 2.73481849789, 6606.4432548323), new Vsop87.LnVsop(1.726E-8, 1.7057182611, 6.6836638741), new Vsop87.LnVsop(1.723E-8, 1.9818288652, 735.8765135318), new Vsop87.LnVsop(1.814E-8, 0.92396194325, 4555.3474460204), new Vsop87.LnVsop(1.66E-8, 3.07308780443, 1692.1656695024), new Vsop87.LnVsop(2.333E-8, 5.0518569566, 20618.0193585336), new Vsop87.LnVsop(1.652E-8, 3.86410092229, 699.2711482276), new Vsop87.LnVsop(1.891E-8, 4.14097641151, 5459.3762870782), new Vsop87.LnVsop(1.686E-8, 2.22936981446, 17085.9586657222), new Vsop87.LnVsop(1.687E-8, 3.49824840147, 3347.6586633978), new Vsop87.LnVsop(1.91E-8, 2.11485342979, 6816.289933435), new Vsop87.LnVsop(1.921E-8, 3.31155620445, 3333.5661900018), new Vsop87.LnVsop(1.613E-8, 2.11892940835, 661.232926781), new Vsop87.LnVsop(1.694E-8, 4.88311110257, 3407.0998356142), new Vsop87.LnVsop(1.559E-8, 3.51992273792, 13362.432453147), new Vsop87.LnVsop(2.097E-8, 1.7899376339, 20597.2439630412), new Vsop87.LnVsop(1.825E-8, 1.14388611553, 2807.3983432562), new Vsop87.LnVsop(1.561E-8, 0.80245519404, 3017.1070100424), new Vsop87.LnVsop(1.552E-8, 2.66876908822, 3024.2205570432), new Vsop87.LnVsop(2.109E-8, 1.48726552054, 2679.3794999188), new Vsop87.LnVsop(1.663E-8, 4.39270692852, 8270.2977486834), new Vsop87.LnVsop(1.696E-8, 2.09755814323, 2814.4445799542), new Vsop87.LnVsop(1.559E-8, 5.5507167332, 13362.4669604514), new Vsop87.LnVsop(1.754E-8, 5.90484178405, 3326.3853326982), new Vsop87.LnVsop(1.502E-8, 4.34390071395, 13936.794505134), new Vsop87.LnVsop(1.504E-8, 0.83348536217, 4775.7600884592), new Vsop87.LnVsop(1.543E-8, 5.82417981947, 3344.4937620578), new Vsop87.LnVsop(1.478E-8, 2.50126974641, 2597.6223661672), new Vsop87.LnVsop(1.461E-8, 1.42535404773, 15508.6151232744), new Vsop87.LnVsop(1.643E-8, 2.88886926628, 8273.8208670324), new Vsop87.LnVsop(1.8E-8, 5.17128754633, 38.1330356378), new Vsop87.LnVsop(1.526E-8, 1.10269009104, 2675.8563815698), new Vsop87.LnVsop(1.439E-8, 0.48780100962, 76.2660712756), new Vsop87.LnVsop(1.769E-8, 2.18317522727, 2301.58581590939), new Vsop87.LnVsop(1.463E-8, 4.62895146956, 19800.9459562248), new Vsop87.LnVsop(1.705E-8, 2.60291826247, 29.429508536), new Vsop87.LnVsop(1.834E-8, 3.93003054205, 6843.6914895318), new Vsop87.LnVsop(1.444E-8, 3.48342169961, 3281.2385647862), new Vsop87.LnVsop(1.48E-8, 3.88768281039, 6034.2140200848), new Vsop87.LnVsop(1.466E-8, 2.91823533164, 12722.5524204852), new Vsop87.LnVsop(1.822E-8, 3.94166947995, 18454.601664915), new Vsop87.LnVsop(1.353E-8, 4.15009794282, 2284.7536148596), new Vsop87.LnVsop(1.351E-8, 1.72199149037, 13760.5987102074), new Vsop87.LnVsop(1.399E-8, 2.42873799629, 853.196381752), new Vsop87.LnVsop(1.366E-8, 4.69601766792, 11081.2192102886), new Vsop87.LnVsop(1.538E-8, 3.23251536595, 156.4007205024), new Vsop87.LnVsop(1.353E-8, 4.90776327224, 3304.5845600224), new Vsop87.LnVsop(1.5E-8, 4.67389761397, 394.6258850592), new Vsop87.LnVsop(1.543E-8, 1.13497135654, 3336.7310913418), new Vsop87.LnVsop(1.384E-8, 2.90231400362, 1581.959348283), new Vsop87.LnVsop(1.311E-8, 6.21755182412, 2547.8375382324), new Vsop87.LnVsop(1.382E-8, 2.56516714885, 568.8218740274), new Vsop87.LnVsop(1.618E-8, 0.07569084986, 1435.1476617594), new Vsop87.LnVsop(1.369E-8, 0.0902519006, 7895.9598727202), new Vsop87.LnVsop(1.333E-8, 3.80019637725, 13119.72110282519), new Vsop87.LnVsop(1.261E-8, 5.84659079053, 21.335640467), new Vsop87.LnVsop(1.193E-8, 5.90765698297, 187.9251477626), new Vsop87.LnVsop(1.275E-8, 5.30143252989, 6571.0185321802), new Vsop87.LnVsop(1.497E-8, 2.57685971474, 151.8972810852), new Vsop87.LnVsop(1.276E-8, 4.0913539943, 4356.275444584), new Vsop87.LnVsop(1.453E-8, 5.91531419193, 3339.1279539915), new Vsop87.LnVsop(1.162E-8, 0.00487534972, 799.8211251654), new Vsop87.LnVsop(1.349E-8, 0.39390567783, 2540.7913015344), new Vsop87.LnVsop(1.15E-8, 1.81037054423, 158.9435177832), new Vsop87.LnVsop(1.403E-8, 4.89947045977, 4039.8835749274), new Vsop87.LnVsop(1.158E-8, 4.15466681767, 14.2270940016), new Vsop87.LnVsop(1.176E-8, 3.46488514917, 1015.6630178842), new Vsop87.LnVsop(1.134E-8, 5.53830534094, 13553.8979729108), new Vsop87.LnVsop(1.114E-8, 5.66112424924, 3760.097070575), new Vsop87.LnVsop(1.281E-8, 4.52342704978, 3929.677253708), new Vsop87.LnVsop(1.497E-8, 4.20879135724, 16460.33352952499), new Vsop87.LnVsop(1.123E-8, 1.403531528, 13149.1506113612), new Vsop87.LnVsop(1.25E-8, 3.84843607877, 3980.5097130138), new Vsop87.LnVsop(1.077E-8, 0.89381735251, 3340.19235060619), new Vsop87.LnVsop(1.103E-8, 5.0447402411, 23141.5583829246), new Vsop87.LnVsop(1.189E-8, 1.25182126092, 26724.8994135984), new Vsop87.LnVsop(1.248E-8, 5.83629907704, 3344.5445799629), new Vsop87.LnVsop(1.044E-8, 4.34142489533, 2277.7073781616), new Vsop87.LnVsop(1.453E-8, 2.27428225289, 369.6998159404), new Vsop87.LnVsop(1.059E-8, 6.24742453183, 17.812522118), new Vsop87.LnVsop(1.148E-8, 0.42674577851, 949.1756089698), new Vsop87.LnVsop(1.112E-8, 4.31734784819, 107.6635239386), new Vsop87.LnVsop(1.125E-8, 3.46005579971, 5732.0492444298), new Vsop87.LnVsop(1.084E-8, 4.08902342726, 802.3639224462), new Vsop87.LnVsop(1.172E-8, 0.31355227662, 1162.4747044078), new Vsop87.LnVsop(1.058E-8, 1.34066539658, 2149.6885348242), new Vsop87.LnVsop(9.81E-9, 3.44358391452, 9779.1086761254), new Vsop87.LnVsop(1.119E-8, 5.22899579707, 194.9713844606), new Vsop87.LnVsop(1.134E-8, 0.13581107839, 12566.1516999828), new Vsop87.LnVsop(1.173E-8, 1.73082205622, 6923.9534573736), new Vsop87.LnVsop(9.62E-9, 4.84602947327, 3510.1926098328), new Vsop87.LnVsop(9.85E-9, 1.05143904982, 16335.8378045366), new Vsop87.LnVsop(1.181E-8, 3.65780947036, 6456.8800576977), new Vsop87.LnVsop(1.299E-8, 6.02281348454, 3316.733988952), new Vsop87.LnVsop(1.015E-8, 2.47380728164, 31.9723058168), new Vsop87.LnVsop(9.48E-9, 5.10561095893, 8013.2797409404), new Vsop87.LnVsop(9.19E-9, 1.56671162926, 111.1866422876), new Vsop87.LnVsop(1.029E-8, 2.76318185375, 5938.234792867), new Vsop87.LnVsop(9.98E-9, 5.48784840152, 11236.57229942), new Vsop87.LnVsop(9.14E-9, 0.82061678315, 3364.4908644476), new Vsop87.LnVsop(1.106E-8, 2.06839415041, 3376.6402933772), new Vsop87.LnVsop(9.45E-9, 4.41350387633, 433.7117378768), new Vsop87.LnVsop(9.1E-9, 1.70993881458, 2067.9314010726), new Vsop87.LnVsop(9.1E-9, 1.91587519691, 401.6721217572), new Vsop87.LnVsop(1.044E-8, 1.93180343226, 87.30820453981), new Vsop87.LnVsop(9.12E-9, 1.58460936983, 10235.1363755374), new Vsop87.LnVsop(9.26E-9, 4.61111147529, 5415.6573747732), new Vsop87.LnVsop(1.033E-8, 3.9850468042, 10596.1820784342), new Vsop87.LnVsop(9.46E-9, 0.21615391832, 9872.2740829648), new Vsop87.LnVsop(8.99E-9, 5.27959763891, 7107.8230442756), new Vsop87.LnVsop(8.73E-9, 1.86205822992, 2142.6422981262), new Vsop87.LnVsop(8.9E-9, 1.81033031287, 2409.249339848), new Vsop87.LnVsop(1.058E-8, 3.63297698461, 7255.5696517344), new Vsop87.LnVsop(9.09E-9, 4.37280779135, 1854.6323056346), new Vsop87.LnVsop(8.44E-9, 3.82388337842, 272.6729573516), new Vsop87.LnVsop(8.36E-9, 0.20464914442, 11766.2632645146), new Vsop87.LnVsop(8.27E-9, 1.25878772256, 20206.141196331), new Vsop87.LnVsop(8.21E-9, 0.78875420945, 5621.8256695582), new Vsop87.LnVsop(8.19E-9, 2.82232063108, 5621.8601768626), new Vsop87.LnVsop(8.28E-9, 2.42897194573, 11.0457002639), new Vsop87.LnVsop(9.81E-9, 0.44031295515, 1596.1864422846), new Vsop87.LnVsop(8.17E-9, 4.64314240547, 127.9515330346), new Vsop87.LnVsop(1.022E-8, 3.50167625373, 9866.4168806652), new Vsop87.LnVsop(1.074E-8, 2.80026140417, 3077.528503327), new Vsop87.LnVsop(1.08E-8, 6.06529825187, 3341.0325027934), new Vsop87.LnVsop(8.02E-9, 1.17242625138, 6460.8122109608), new Vsop87.LnVsop(7.98E-9, 4.56887810023, 5223.6939198022), new Vsop87.LnVsop(7.91E-9, 5.03144430516, 2.5427972808), new Vsop87.LnVsop(8.84E-9, 1.71001393326, 3.9321532631), new Vsop87.LnVsop(8.17E-9, 0.90060731147, 8646.0634802536), new Vsop87.LnVsop(7.99E-9, 0.17886471821, 22743.4093795164), new Vsop87.LnVsop(8.49E-9, 1.24576847048, 12295.9542296092), new Vsop87.LnVsop(7.73E-9, 2.53367626112, 2295.4575905122), new Vsop87.LnVsop(9.16E-9, 3.02582005756, 3377.217792004), new Vsop87.LnVsop(7.8E-9, 1.97862043128, 5408.5438277724), new Vsop87.LnVsop(9.56E-9, 6.16353911929, 8542.970706035), new Vsop87.LnVsop(7.79E-9, 4.63070288733, 3341.0423098265), new Vsop87.LnVsop(7.38E-9, 3.51171014997, 10020.8569590312), new Vsop87.LnVsop(9.57E-9, 4.86437348833, 931.3630868518), new Vsop87.LnVsop(7.96E-9, 4.54021772912, 1039.0266107904), new Vsop87.LnVsop(7.24E-9, 3.9215747045, 12310.1813236108), new Vsop87.LnVsop(7.18E-9, 3.34736041949, 11780.4903585162), new Vsop87.LnVsop(9.41E-9, 3.58969556791, 23539.7073863328), new Vsop87.LnVsop(7.48E-9, 5.61102387118, 16062.1845261168), new Vsop87.LnVsop(7.67E-9, 3.25531932262, 3384.3313390048), new Vsop87.LnVsop(8.55E-9, 1.12465641537, 206.7007372966), new Vsop87.LnVsop(8.15E-9, 2.65362307845, 3169.9395560806), new Vsop87.LnVsop(7.34E-9, 2.2027921545, 146.8116865236), new Vsop87.LnVsop(7.79E-9, 2.32837877145, 3340.1825435731), new Vsop87.LnVsop(6.86E-9, 1.51086318028, 792.7748884674), new Vsop87.LnVsop(7.4E-9, 2.89753701512, 3296.8935143948), new Vsop87.LnVsop(6.77E-9, 4.34039986096, 3877.4169387952), new Vsop87.LnVsop(6.73E-9, 2.34948834397, 1.1806426521), new Vsop87.LnVsop(7.23E-9, 3.56709112306, 485.9720527896), new Vsop87.LnVsop(6.69E-9, 5.16867827323, 12721.572099417), new Vsop87.LnVsop(7.19E-9, 4.79573724239, 4142.976349146), new Vsop87.LnVsop(6.99E-9, 1.91837645169, 6665.9723822146), new Vsop87.LnVsop(6.84E-9, 3.88501682634, 846.0828347512), new Vsop87.LnVsop(6.41E-9, 2.07794469578, 16699.53901514999), new Vsop87.LnVsop(6.97E-9, 0.3072344231, 19676.4502312364), new Vsop87.LnVsop(8.28E-9, 1.59417806122, 16304.9131300908), new Vsop87.LnVsop(6.89E-9, 4.6482605346, 11216.284290324), new Vsop87.LnVsop(7.09E-9, 5.04539574527, 3329.5667264359), new Vsop87.LnVsop(7.29E-9, 2.24679589436, 11250.7993934216), new Vsop87.LnVsop(6.81E-9, 2.72108869682, 6643.0918177618), new Vsop87.LnVsop(6.82E-9, 1.76706935146, 51.28033786241), new Vsop87.LnVsop(6.35E-9, 0.07420048628, 52.2603149128), new Vsop87.LnVsop(6.45E-9, 4.31172593504, 3826.5844794894), new Vsop87.LnVsop(6.73E-9, 3.60492040158, 1903.4368125012), new Vsop87.LnVsop(6.73E-9, 0.1333738167, 8116.372515159), new Vsop87.LnVsop(6.74E-9, 1.26391848214, 142.1786270362), new Vsop87.LnVsop(8.16E-9, 6.04643402652, 19402.7969528166), new Vsop87.LnVsop(6.25E-9, 3.84990828302, 6.0659156298), new Vsop87.LnVsop(6.24E-9, 1.64078988493, 24150.080051345), new Vsop87.LnVsop(6.13E-9, 5.74440327477, 6696.4773245846), new Vsop87.LnVsop(6.04E-9, 3.24898351527, 9588.1255422226), new Vsop87.LnVsop(6.01E-9, 4.99376091794, 8859.3625756916), new Vsop87.LnVsop(6.78E-9, 1.9478115256, 12995.2253778368), new Vsop87.LnVsop(6.15E-9, 4.95500687617, 9485.032768004), new Vsop87.LnVsop(7.81E-9, 2.8507523173, 29.4918183034), new Vsop87.LnVsop(6.01E-9, 2.24121047241, 20735.83216142559), new Vsop87.LnVsop(5.89E-9, 5.72063241021, 3113.1362939108), new Vsop87.LnVsop(7.59E-9, 0.42525161329, 3873.8265101434), new Vsop87.LnVsop(6.52E-9, 5.53661885979, 9065.5481241288), new Vsop87.LnVsop(6.05E-9, 0.77544347078, 3342.0968994081), new Vsop87.LnVsop(7.03E-9, 3.36009149285, 6709.6740408674), new Vsop87.LnVsop(6.26E-9, 1.46111605834, 16706.585251848), new Vsop87.LnVsop(5.68E-9, 1.08932960976, 6357.7194367422), new Vsop87.LnVsop(5.68E-9, 1.3079889151, 9499.2598620056), new Vsop87.LnVsop(5.82E-9, 5.65932024956, 2171.0241752912), new Vsop87.LnVsop(7.37E-9, 4.84794933747, 10022.8176011676), new Vsop87.LnVsop(5.65E-9, 0.58744605626, 26084.0218062162), new Vsop87.LnVsop(5.49E-9, 4.18021120562, 382.879278571), new Vsop87.LnVsop(5.7E-9, 0.0405104686, 6414.6178116778), new Vsop87.LnVsop(6.18E-9, 3.84921117898, 16276.463942623), new Vsop87.LnVsop(7.67E-9, 1.15181496342, 377.3736079158), new Vsop87.LnVsop(5.62E-9, 2.57704345512, 35.5627344686), new Vsop87.LnVsop(6.76E-9, 5.60413511268, 155.3530891314), new Vsop87.LnVsop(5.54E-9, 0.62822360284, 3189.5647568569), new Vsop87.LnVsop(6.26E-9, 2.21709498761, 3274.1250177854), new Vsop87.LnVsop(6.83E-9, 1.1585146597, 966.9708774356), new Vsop87.LnVsop(5.49E-9, 0.54244199194, 13171.0014406876), new Vsop87.LnVsop(5.65E-9, 1.60353804455, 3192.5337022735), new Vsop87.LnVsop(5.63E-9, 0.10642400254, 5511.636601991), new Vsop87.LnVsop(5.62E-9, 2.66906118595, 19406.6782881746), new Vsop87.LnVsop(5.66E-9, 3.117774555, 2221.856634597), new Vsop87.LnVsop(5.32E-9, 3.77784810168, 7270.2896804078), new Vsop87.LnVsop(5.37E-9, 0.41844932397, 1641.3332101966), new Vsop87.LnVsop(5.75E-9, 5.48957773192, 2075.0449480734), new Vsop87.LnVsop(5.12E-9, 1.6199090767, 13362.3823964964), new Vsop87.LnVsop(5.09E-9, 4.21362121644, 7380.4960016272), new Vsop87.LnVsop(4.94E-9, 2.13716209261, 2604.735913168), new Vsop87.LnVsop(5.29E-9, 1.03105540203, 1478.8665740644), new Vsop87.LnVsop(5.59E-9, 1.47744587005, 8671.9698704406), new Vsop87.LnVsop(4.75E-9, 2.07645966138, 5835.1420186484), new Vsop87.LnVsop(5.07E-9, 3.25453549986, 1744.493294718), new Vsop87.LnVsop(4.75E-9, 1.46221578984, 12509.2533250472), new Vsop87.LnVsop(5.01E-9, 5.92139594122, 685.044054226), new Vsop87.LnVsop(4.63E-9, 4.59237414506, 11670.2840372968), new Vsop87.LnVsop(4.61E-9, 1.95536373356, 2412.772458197), new Vsop87.LnVsop(4.63E-9, 3.80428769716, 11140.5930722022), new Vsop87.LnVsop(5.19E-9, 6.1936211759, 9602.3526362242), new Vsop87.LnVsop(4.61E-9, 2.92759117395, 2277.2983432475), new Vsop87.LnVsop(4.57E-9, 0.83633915073, 3041.4860324306), new Vsop87.LnVsop(4.96E-9, 4.62773695339, 3723.4917052708), new Vsop87.LnVsop(5.21E-9, 6.27578678705, 3981.490034082), new Vsop87.LnVsop(6.31E-9, 3.69227976878, 6475.0393049624), new Vsop87.LnVsop(4.88E-9, 0.17334637032, 14158.7477136156), new Vsop87.LnVsop(4.67E-9, 6.13582230228, 4825.544916394), new Vsop87.LnVsop(5.16E-9, 0.73887961022, 1265.5674786264), new Vsop87.LnVsop(4.84E-9, 0.75989848136, 4407.1079038898), new Vsop87.LnVsop(5.73E-9, 4.77672282988, 9380.9596727172), new Vsop87.LnVsop(4.41E-9, 5.67433891123, 8958.9322315612), new Vsop87.LnVsop(5.03E-9, 4.27904008262, 3472.1543883862), new Vsop87.LnVsop(4.41E-9, 1.95128375492, 3226.2133197864), new Vsop87.LnVsop(5.71E-9, 5.10229499953, 8564.306346502), new Vsop87.LnVsop(5.71E-9, 0.58988272178, 2766.267628365), new Vsop87.LnVsop(4.87E-9, 6.10031395897, 2285.1626497737), new Vsop87.LnVsop(4.46E-9, 1.98916479068, 25685.872802808), new Vsop87.LnVsop(4.3E-9, 4.12851356192, 13.241772398), new Vsop87.LnVsop(5.99E-9, 2.01891079118, 27490.6924780448), new Vsop87.LnVsop(5.45E-9, 0.84640347857, 4981.9456368964), new Vsop87.LnVsop(4.99E-9, 4.26030358053, 6652.7756659318), new Vsop87.LnVsop(4.25E-9, 3.83675473694, 1765.7666254176), new Vsop87.LnVsop(4.59E-9, 3.04380861065, 5636.070017212), new Vsop87.LnVsop(4.38E-9, 0.5551946104, 9945.5712088238), new Vsop87.LnVsop(4.09E-9, 3.25101264756, 18451.07854656599), new Vsop87.LnVsop(4.1E-9, 1.71233327642, 7314.0085927128), new Vsop87.LnVsop(4.17E-9, 1.76252798792, 956.2891559706), new Vsop87.LnVsop(4.26E-9, 1.16443702315, 19004.6479494084), new Vsop87.LnVsop(4.05E-9, 0.29370514941, 2810.9387152574), new Vsop87.LnVsop(4.05E-9, 4.54611874389, 2810.904207953), new Vsop87.LnVsop(5.12E-9, 1.21144751675, 13362.517017102), new Vsop87.LnVsop(4.17E-9, 3.49097054443, 1655.5603041982), new Vsop87.LnVsop(4.06E-9, 0.28183528199, 1375.7737998458), new Vsop87.LnVsop(4.15E-9, 5.67120343816, 99.5696558696), new Vsop87.LnVsop(3.98E-9, 1.32137621034, 20809.4676246452), new Vsop87.LnVsop(3.96E-9, 0.51833007867, 13355.3361597984), new Vsop87.LnVsop(4.05E-9, 5.6320613099, 3450.8187479192), new Vsop87.LnVsop(4.72E-9, 5.94522815549, 48835.19385644859), new Vsop87.LnVsop(4.15E-9, 3.61904227317, 2089.782230399), new Vsop87.LnVsop(4.09E-9, 4.59663901922, 6518.7582172674), new Vsop87.LnVsop(4.9E-9, 4.3831706552, 2480.302497947), new Vsop87.LnVsop(5.06E-9, 4.8903102803, 8965.9784682592), new Vsop87.LnVsop(4.92E-9, 1.6578077963, 22345.2603761082), new Vsop87.LnVsop(4.17E-9, 3.45088938093, 279.7865043524), new Vsop87.LnVsop(3.81E-9, 4.06210739923, 10124.930054318), new Vsop87.LnVsop(4.31E-9, 2.11881719623, 56.8032621698), new Vsop87.LnVsop(3.77E-9, 0.0567923928, 905.4566966648), new Vsop87.LnVsop(3.73E-9, 3.16212047027, 224.3447957019), new Vsop87.LnVsop(4.26E-9, 2.66441427364, 4076.4889402316), new Vsop87.LnVsop(3.99E-9, 5.15292207975, 5195.2447323344), new Vsop87.LnVsop(3.69E-9, 5.28832560053, 10042.6126755918), new Vsop87.LnVsop(3.93E-9, 2.28211201589, 13892.1406718938), new Vsop87.LnVsop(4.4E-9, 0.33473783423, 515.463871093), new Vsop87.LnVsop(4.89E-9, 0.75769248875, 3561.0250691386), new Vsop87.LnVsop(3.89E-9, 0.50283826584, 2825.1485556068), new Vsop87.LnVsop(3.66E-9, 5.86243765418, 6675.7019290922), new Vsop87.LnVsop(4.33E-9, 0.25560773454, 5625.7750764735), new Vsop87.LnVsop(4.55E-9, 3.79309503535, 4996.172730898), new Vsop87.LnVsop(4.37E-9, 3.32741963621, 5617.9107699473), new Vsop87.LnVsop(4.96E-9, 5.02750066477, 73.297125859), new Vsop87.LnVsop(4.24E-9, 3.6050628298, 8226.5788363784), new Vsop87.LnVsop(3.93E-9, 3.15777926177, 10001.061884607), new Vsop87.LnVsop(3.69E-9, 2.84562486856, 2111.6503133776), new Vsop87.LnVsop(3.96E-9, 4.52525609133, 4392.8808098882), new Vsop87.LnVsop(3.49E-9, 5.02184920945, 5820.9149246468), new Vsop87.LnVsop(4.39E-9, 4.2512849848, 18052.9295431578), new Vsop87.LnVsop(3.47E-9, 0.75032574592, 15664.03552270859), new Vsop87.LnVsop(4.59E-9, 3.22461221371, 2011.1003364398), new Vsop87.LnVsop(3.41E-9, 3.22071023671, 4253.1826703654), new Vsop87.LnVsop(3.4E-9, 4.12059603652, 6944.3087767724), new Vsop87.LnVsop(4.1E-9, 4.83846706479, 8535.8571590342), new Vsop87.LnVsop(4.17E-9, 2.58262243077, 5753.3848848968), new Vsop87.LnVsop(3.45E-9, 1.85392358161, 6686.747777707), new Vsop87.LnVsop(3.56E-9, 2.35639379021, 4.57074972), new Vsop87.LnVsop(4.54E-9, 2.90957957919, 418.9243989006), new Vsop87.LnVsop(4.35E-9, 5.42291154764, 26482.1708096244), new Vsop87.LnVsop(3.83E-9, 4.06026489467, 1062.9050485382), new Vsop87.LnVsop(3.3E-9, 4.04831945983, 3.1030422554), new Vsop87.LnVsop(4.58E-9, 4.28564096349, 367.2243289624), new Vsop87.LnVsop(3.25E-9, 3.98178390124, 1353.3905280078), new Vsop87.LnVsop(4.18E-9, 3.22886388747, 21265.5231265202), new Vsop87.LnVsop(4.49E-9, 4.37716659898, 5106.3790521174), new Vsop87.LnVsop(3.75E-9, 1.09226403307, 4246.0691233646), new Vsop87.LnVsop(3.94E-9, 2.27820129074, 3209.0704650134), new Vsop87.LnVsop(3.18E-9, 4.97772911232, 5095.6750764648), new Vsop87.LnVsop(4.1E-9, 2.45431083471, 6155.057006654), new Vsop87.LnVsop(3.19E-9, 4.05707815795, 5430.3946570988), new Vsop87.LnVsop(3.23E-9, 0.90022769547, 7203.8022714934), new Vsop87.LnVsop(3.1E-9, 5.46505496103, 6019.9919266186), new Vsop87.LnVsop(4.09E-9, 6.07568936266, 50.8324593058), new Vsop87.LnVsop(3.37E-9, 2.87052725998, 10610.9021071076), new Vsop87.LnVsop(3.77E-9, 5.42225357427, 1190.9238918756), new Vsop87.LnVsop(3.01E-9, 4.66690363477, 6756.0064519669), new Vsop87.LnVsop(3.43E-9, 2.67442328942, 6148.010769956), new Vsop87.LnVsop(3.09E-9, 4.56269108847, 7483.5887758458), new Vsop87.LnVsop(3.1E-9, 2.84658769828, 9654.612951137), new Vsop87.LnVsop(2.96E-9, 4.27095606776, 6740.5987153132), new Vsop87.LnVsop(3.1E-9, 3.26584547245, 596.178374009), new Vsop87.LnVsop(2.93E-9, 2.76946559406, 3171.0322435668), new Vsop87.LnVsop(3.67E-9, 3.93640995629, 1879.5583747534), new Vsop87.LnVsop(3.3E-9, 3.29725079066, 286.9623611206), new Vsop87.LnVsop(3.05E-9, 2.54608802445, 19513.9835951042), new Vsop87.LnVsop(3.12E-9, 1.05107476595, 3490.1756238344), new Vsop87.LnVsop(2.94E-9, 0.0190673259, 202.2533951741), new Vsop87.LnVsop(3.1E-9, 4.37565854379, 2796.6943676036), new Vsop87.LnVsop(2.85E-9, 3.43575683476, 6418.1409300268), new Vsop87.LnVsop(2.92E-9, 4.39525256758, 6887.4104018368), new Vsop87.LnVsop(2.88E-9, 5.43913988801, 10028.9508271002), new Vsop87.LnVsop(2.86E-9, 5.76540114951, 5642.1982426092), new Vsop87.LnVsop(3.12E-9, 4.12958202119, 1883.0814931024), new Vsop87.LnVsop(2.9E-9, 4.07993947141, 5355.2358814886), new Vsop87.LnVsop(3.93E-9, 3.01257302196, 10721.108428327), new Vsop87.LnVsop(2.87E-9, 2.36631839942, 29026.48522950779), new Vsop87.LnVsop(3.61E-9, 0.54380501625, 290.4854794696), new Vsop87.LnVsop(3.18E-9, 4.93375879729, 1197.9701285736), new Vsop87.LnVsop(2.99E-9, 1.18299169304, 550.0462844934), new Vsop87.LnVsop(2.94E-9, 6.16372005552, 8982.810669309), new Vsop87.LnVsop(3.0E-9, 4.29609104099, 21795.21409161479), new Vsop87.LnVsop(3.15E-9, 2.67347587719, 3313.210870603), new Vsop87.LnVsop(2.81E-9, 0.27497384989, 8166.1573430938), new Vsop87.LnVsop(2.72E-9, 5.94366381829, 9886.772200064), new Vsop87.LnVsop(3.3E-9, 3.11968019451, 41.5507909848), new Vsop87.LnVsop(2.75E-9, 5.89019272375, 3337.8609160888), new Vsop87.LnVsop(2.75E-9, 4.00268079943, 3620.3989310522), new Vsop87.LnVsop(3.29E-9, 4.31857973778, 5989.0672521728), new Vsop87.LnVsop(2.92E-9, 3.06830662617, 4.3620363898), new Vsop87.LnVsop(2.72E-9, 5.11995514837, 22324.9050567094), new Vsop87.LnVsop(3.18E-9, 0.02070112786, 2267.003402509), new Vsop87.LnVsop(2.86E-9, 0.46156470579, 5401.4302807716), new Vsop87.LnVsop(3.03E-9, 0.59188658282, 9389.0535407862), new Vsop87.LnVsop(2.65E-9, 0.63293390575, 23017.0626579362), new Vsop87.LnVsop(2.65E-9, 2.08409828499, 3735.238311759), new Vsop87.LnVsop(2.67E-9, 1.69664388221, 3742.284548457), new Vsop87.LnVsop(3.08E-9, 3.0337992344, 6660.8695340008), new Vsop87.LnVsop(3.12E-9, 3.62016422039, 255.970376372), new Vsop87.LnVsop(2.64E-9, 3.85932054425, 28628.3362260996), new Vsop87.LnVsop(2.78E-9, 5.6203315157, 3378.7454623376), new Vsop87.LnVsop(2.57E-9, 1.23480561014, 95.9792272178), new Vsop87.LnVsop(3.01E-9, 0.83275594655, 2806.9893083421), new Vsop87.LnVsop(2.82E-9, 2.29141606787, 2008.557539159), new Vsop87.LnVsop(2.64E-9, 3.78635346392, 3936.7908007088), new Vsop87.LnVsop(2.65E-9, 0.50417611532, 6578.132079181), new Vsop87.LnVsop(2.5E-9, 5.5849385856, 412.3710968744), new Vsop87.LnVsop(2.84E-9, 4.7106546669, 5621.9102335132), new Vsop87.LnVsop(2.89E-9, 1.43840673306, 6947.8318951214), new Vsop87.LnVsop(2.86E-9, 5.11854342112, 5621.7756129076), new Vsop87.LnVsop(3.11E-9, 2.67810141537, 912.5702436656), new Vsop87.LnVsop(2.52E-9, 4.19548440341, 24.858758816), new Vsop87.LnVsop(2.47E-9, 2.94199704738, 310.8407988684), new Vsop87.LnVsop(2.51E-9, 0.32785126115, 19146.7592661418), new Vsop87.LnVsop(2.51E-9, 5.7699203528, 5813.291189322), new Vsop87.LnVsop(2.68E-9, 0.19876672098, 6670.5881880498), new Vsop87.LnVsop(2.47E-9, 2.28207487665, 246.251722323), new Vsop87.LnVsop(2.83E-9, 1.28593304651, 4025.6564809258), new Vsop87.LnVsop(2.57E-9, 5.64140283929, 10706.8813343254), new Vsop87.LnVsop(2.52E-9, 4.46420322691, 5490.300961524), new Vsop87.LnVsop(2.46E-9, 0.26910281348, 22.7684966094), new Vsop87.LnVsop(2.56E-9, 5.68448606955, 3133.9116894032), new Vsop87.LnVsop(2.72E-9, 1.28516397838, 1442.2612087602), new Vsop87.LnVsop(2.94E-9, 4.02082336381, 2814.8536148683), new Vsop87.LnVsop(2.45E-9, 2.94750517862, 21947.1113727), new Vsop87.LnVsop(2.37E-9, 4.99903725526, 1505.28780909299), new Vsop87.LnVsop(2.36E-9, 6.05766331289, 948.1952879016), new Vsop87.LnVsop(2.38E-9, 1.85846033178, 3193.8007401762), new Vsop87.LnVsop(2.37E-9, 0.90339496046, 8.093868069), new Vsop87.LnVsop(2.49E-9, 6.05356563432, 2060.8178540718), new Vsop87.LnVsop(2.3E-9, 1.40262306909, 23546.7536230308), new Vsop87.LnVsop(2.81E-9, 0.30407184379, 5607.6158292088), new Vsop87.LnVsop(2.99E-9, 2.73533927971, 176.6937301338), new Vsop87.LnVsop(2.37E-9, 4.63093114141, 1612.9513330316), new Vsop87.LnVsop(2.63E-9, 2.15420401346, 2973.3880977374), new Vsop87.LnVsop(2.75E-9, 1.06902528779, 3343.3639373108), new Vsop87.LnVsop(2.77E-9, 0.19619249083, 270.1974703736), new Vsop87.LnVsop(2.41E-9, 4.97677402625, 31022.7531708562), new Vsop87.LnVsop(2.18E-9, 0.03471394521, 9070.1188738488), new Vsop87.LnVsop(2.41E-9, 2.53528698623, 3710.3122426402), new Vsop87.LnVsop(2.18E-9, 5.17762855931, 6997.6167230562), new Vsop87.LnVsop(2.67E-9, 4.64729465561, 1346.3442913098), new Vsop87.LnVsop(2.3E-9, 5.16357138714, 721.1392312062), new Vsop87.LnVsop(2.14E-9, 3.38620394418, 647.0108333148), new Vsop87.LnVsop(2.89E-9, 3.43566105724, 25287.7237993998), new Vsop87.LnVsop(2.48E-9, 3.03186441088, 3304.0070613956), new Vsop87.LnVsop(2.82E-9, 0.29227105071, 12323.4230960088), new Vsop87.LnVsop(2.26E-9, 5.75263123291, 604.8497407048), new Vsop87.LnVsop(2.13E-9, 4.80572776287, 8830.9133882238), new Vsop87.LnVsop(2.59E-9, 1.24817153777, 6691.8615187494), new Vsop87.LnVsop(2.16E-9, 5.85803012117, 1971.9521738548), new Vsop87.LnVsop(2.14E-9, 1.35475765206, 184.8499079702), new Vsop87.LnVsop(2.22E-9, 3.47406655321, 6674.1786167016), new Vsop87.LnVsop(2.5E-9, 4.55620402555, 6040.3472460174), new Vsop87.LnVsop(2.41E-9, 0.94761695794, 17468.8551979454), new Vsop87.LnVsop(2.73E-9, 1.89943168433, 270.1301600708), new Vsop87.LnVsop(2.05E-9, 5.94913715412, 2942.4806769438), new Vsop87.LnVsop(2.14E-9, 0.22905754741, 5.1991911658), new Vsop87.LnVsop(2.05E-9, 3.91836540376, 2942.4461696394), new Vsop87.LnVsop(2.41E-9, 5.92842548896, 4005.3684718298), new Vsop87.LnVsop(2.16E-9, 3.2009868012, 362.1211367308), new Vsop87.LnVsop(2.04E-9, 3.09570712832, 9947.0556815321), new Vsop87.LnVsop(2.19E-9, 1.85183257276, 4782.87363546), new Vsop87.LnVsop(2.1E-9, 0.4586894992, 15106.8756912144), new Vsop87.LnVsop(2.71E-9, 3.49210901141, 3436.5916539176), new Vsop87.LnVsop(2.26E-9, 0.42945734871, 557.0925211914), new Vsop87.LnVsop(1.98E-9, 5.62942060976, 5209.471826336), new Vsop87.LnVsop(2.69E-9, 5.0386582238, 2938.9403049426), new Vsop87.LnVsop(2.08E-9, 6.03373357398, 22487.3716928416), new Vsop87.LnVsop(2.16E-9, 4.28876710821, 2970.9126107594), new Vsop87.LnVsop(2.22E-9, 1.25214260478, 3568.0885594888), new Vsop87.LnVsop(1.97E-9, 4.80962358853, 6850.8050365326), new Vsop87.LnVsop(2.11E-9, 1.05961421058, 6382.0984591304), new Vsop87.LnVsop(1.99E-9, 3.49804400305, 15121.102785216), new Vsop87.LnVsop(2.75E-9, 4.22084628914, 8436.2875031646), new Vsop87.LnVsop(2.02E-9, 0.88670673933, 767.8488193486), new Vsop87.LnVsop(2.45E-9, 3.14677467834, 16063.164847185), new Vsop87.LnVsop(1.92E-9, 0.51567014493, 323.5054166574), new Vsop87.LnVsop(2.09E-9, 4.79733900333, 14047.4937610252), new Vsop87.LnVsop(2.62E-9, 4.69178300342, 6701.5801727984), new Vsop87.LnVsop(2.09E-9, 1.46088434217, 5.8572022996), new Vsop87.LnVsop(1.88E-9, 0.61341221354, 7366.2689076256), new Vsop87.LnVsop(1.92E-9, 2.09213913721, 765.7930644464), new Vsop87.LnVsop(1.96E-9, 4.08789826861, 3262.8618827159), new Vsop87.LnVsop(2.13E-9, 2.31887239509, 2281.2477501628), new Vsop87.LnVsop(2.14E-9, 5.33581887315, 955.2415245996), new Vsop87.LnVsop(2.51E-9, 5.57906426342, 138.5881983844), new Vsop87.LnVsop(2.31E-9, 1.11098737686, 625.6701923124), new Vsop87.LnVsop(2.08E-9, 4.11481366408, 1755.062649765), new Vsop87.LnVsop(2.1E-9, 2.30499661227, 53.3079462838), new Vsop87.LnVsop(2.53E-9, 1.27099771143, 309.2783226558), new Vsop87.LnVsop(1.86E-9, 2.50511660467, 18606.4989460002), new Vsop87.LnVsop(2.42E-9, 3.71426781541, 3212.5935833624), new Vsop87.LnVsop(1.85E-9, 2.86917904253, 9374.8264467846), new Vsop87.LnVsop(1.98E-9, 0.43937087541, 7586.6815500644), new Vsop87.LnVsop(1.78E-9, 3.07093814833, 1437.1756141986), new Vsop87.LnVsop(2.31E-9, 3.34379060819, 6364.832983743), new Vsop87.LnVsop(2.03E-9, 0.28410497046, 582.9989113784), new Vsop87.LnVsop(1.9E-9, 0.10448075233, 26087.9031415742), new Vsop87.LnVsop(1.97E-9, 3.57105788857, 24606.13555322), new Vsop87.LnVsop(2.29E-9, 2.5600628386, 24076.4445881254), new Vsop87.LnVsop(1.87E-9, 3.45251088913, 1329.51209026), new Vsop87.LnVsop(2.12E-9, 0.29488451926, 2281.2132428584), new Vsop87.LnVsop(1.76E-9, 5.81536979652, 12406.1605508286), new Vsop87.LnVsop(1.99E-9, 0.07164714815, 375.7657315702), new Vsop87.LnVsop(1.91E-9, 0.51430468358, 2125.8774073792), new Vsop87.LnVsop(1.84E-9, 3.99855915315, 10018.2468514476), new Vsop87.LnVsop(2.31E-9, 1.28492299616, 4427.3959129858), new Vsop87.LnVsop(1.73E-9, 1.46081396432, 3362.4632560262), new Vsop87.LnVsop(1.74E-9, 4.58412775833, 3283.7140517642), new Vsop87.LnVsop(1.82E-9, 2.57146189845, 418.504322807), new Vsop87.LnVsop(1.84E-9, 4.63917400617, 10824.2012025456), new Vsop87.LnVsop(1.69E-9, 5.12437031125, 3223.2925584796), new Vsop87.LnVsop(1.9E-9, 3.43828283608, 5032.7780962022), new Vsop87.LnVsop(1.65E-9, 1.47527516736, 249.9044607422), new Vsop87.LnVsop(2.02E-9, 6.21085923485, 3909.4343007272), new Vsop87.LnVsop(1.64E-9, 4.47908418685, 8799.988713778), new Vsop87.LnVsop(1.71E-9, 5.86158194602, 625.6251361972), new Vsop87.LnVsop(1.95E-9, 3.22480570158, 2751.5475996916), new Vsop87.LnVsop(1.93E-9, 1.20656620982, 15806.146839442), new Vsop87.LnVsop(1.64E-9, 4.23188531108, 31968.9486527994), new Vsop87.LnVsop(1.63E-9, 2.04373367471, 3347.2960905739), new Vsop87.LnVsop(2.12E-9, 2.32801113866, 3232.9489027612), new Vsop87.LnVsop(2.24E-9, 2.39759251371, 8749.1562544722), new Vsop87.LnVsop(1.61E-9, 2.94093367609, 3370.0419352358), new Vsop87.LnVsop(1.92E-9, 4.62592622822, 3336.6802734367), new Vsop87.LnVsop(1.64E-9, 1.59200641542, 386.4196505722), new Vsop87.LnVsop(1.69E-9, 5.45784867095, 259.5608050238), new Vsop87.LnVsop(1.84E-9, 3.3036034648, 11247.2089647698), new Vsop87.LnVsop(1.63E-9, 1.16581070899, 4289.7880356696), new Vsop87.LnVsop(1.58E-9, 0.91153814636, 4503.0871311076), new Vsop87.LnVsop(1.56E-9, 5.57718582558, 1442.2784624124), new Vsop87.LnVsop(1.55E-9, 2.48395345852, 20426.571092422), new Vsop87.LnVsop(2.15E-9, 3.82353334618, 1954.7171503636), new Vsop87.LnVsop(1.58E-9, 4.12087712262, 11240.1627280718), new Vsop87.LnVsop(1.54E-9, 4.56812026693, 27682.1407441564), new Vsop87.LnVsop(1.82E-9, 1.47936413209, 6677.3435180416), new Vsop87.LnVsop(1.53E-9, 5.85211234828, 23937.856389741), new Vsop87.LnVsop(1.97E-9, 1.43125106161, 14061.7208550268), new Vsop87.LnVsop(1.68E-9, 5.27712266355, 3318.7615973734), new Vsop87.LnVsop(1.7E-9, 4.32431856577, 742.9900605326), new Vsop87.LnVsop(1.56E-9, 3.24340991358, 3002.3697277168), new Vsop87.LnVsop(1.54E-9, 4.76648574446, 24889.5747959916), new Vsop87.LnVsop(1.84E-9, 0.87903035084, 5244.049239201), new Vsop87.LnVsop(1.6E-9, 2.79762777586, 1461.0540519464), new Vsop87.LnVsop(1.57E-9, 1.01090226288, 24336.0053931492), new Vsop87.LnVsop(1.51E-9, 4.23962231229, 3368.0139827966), new Vsop87.LnVsop(1.49E-9, 2.50000320687, 14591.4118201214), new Vsop87.LnVsop(1.49E-9, 5.692128106, 31570.7996493912), new Vsop87.LnVsop(1.54E-9, 5.2850438151, 1481.4093713452), new Vsop87.LnVsop(1.45E-9, 1.49366638853, 2619.4731954936), new Vsop87.LnVsop(1.46E-9, 1.28090193252, 8584.6616659008), new Vsop87.LnVsop(1.45E-9, 3.57053081019, 3497.0131472022), new Vsop87.LnVsop(2.01E-9, 3.91480386992, 9638.9407478762), new Vsop87.LnVsop(1.44E-9, 0.56695947743, 13212.8865096646), new Vsop87.LnVsop(1.56E-9, 0.08293278006, 6657.3464156518), new Vsop87.LnVsop(1.5E-9, 0.82077874373, 11456.9849418588), new Vsop87.LnVsop(1.46E-9, 1.164742246, 526.1678467456), new Vsop87.LnVsop(1.44E-9, 4.19229336491, 2771.7905526724), new Vsop87.LnVsop(1.82E-9, 4.43067332626, 10025.4277087512), new Vsop87.LnVsop(1.69E-9, 3.10771037057, 239.205485625), new Vsop87.LnVsop(1.44E-9, 6.26624990824, 6679.7403806913), new Vsop87.LnVsop(1.74E-9, 2.37509025321, 3397.5108016354), new Vsop87.LnVsop(1.42E-9, 4.00086864568, 14481.205498902), new Vsop87.LnVsop(1.65E-9, 1.70220353716, 2185.2512692928), new Vsop87.LnVsop(1.92E-9, 4.47709998867, 57.8786960038), new Vsop87.LnVsop(1.51E-9, 5.49709199511, 11904.9187732018), new Vsop87.LnVsop(1.82E-9, 6.1685759437, 6685.1061887576), new Vsop87.LnVsop(1.52E-9, 4.9327011035, 9468.267877257), new Vsop87.LnVsop(1.51E-9, 3.06451266512, 838.9692877504), new Vsop87.LnVsop(1.41E-9, 0.91584492689, 15636.566656309), new Vsop87.LnVsop(1.6E-9, 5.66327007211, 10927.2939767642), new Vsop87.LnVsop(1.87E-9, 5.62698863872, 11353.8921676402), new Vsop87.LnVsop(1.59E-9, 0.5362810756, 15906.7641266826), new Vsop87.LnVsop(1.65E-9, 5.8699940981, 16703.07938715119), new Vsop87.LnVsop(1.36E-9, 1.61461175096, 30065.5118402982), new Vsop87.LnVsop(1.57E-9, 0.63167452131, 1538.240435978), new Vsop87.LnVsop(1.73E-9, 3.83431713222, 6621.850991486), new Vsop87.LnVsop(1.69E-9, 2.2740858315, 379.3734138742), new Vsop87.LnVsop(1.36E-9, 2.8009862903, 4193.8088084518), new Vsop87.LnVsop(1.34E-9, 5.7755303891, 14577.1847261198), new Vsop87.LnVsop(1.77E-9, 5.21396471572, 34363.365597556), new Vsop87.LnVsop(1.56E-9, 0.81046067961, 29424.634232916), new Vsop87.LnVsop(1.35E-9, 5.88117502698, 2945.9865416406), new Vsop87.LnVsop(1.42E-9, 1.70782247018, 11925.2740926006), new Vsop87.LnVsop(1.32E-9, 3.74649075697, 6688.2710900976), new Vsop87.LnVsop(1.54E-9, 4.78392600044, 3613.2853840514), new Vsop87.LnVsop(1.81E-9, 3.31978654659, 139.6981395228), new Vsop87.LnVsop(1.33E-9, 3.70318330169, 13635.1226641508), new Vsop87.LnVsop(1.47E-9, 2.08632199273, 17101.2111369072), new Vsop87.LnVsop(1.32E-9, 0.409015061, 1083.260367937), new Vsop87.LnVsop(1.78E-9, 5.18401849357, 28230.18722269139), new Vsop87.LnVsop(1.56E-9, 0.1230414464, 1107.1388056848), new Vsop87.LnVsop(1.58E-9, 6.25020094434, 6666.997759398), new Vsop87.LnVsop(1.48E-9, 0.07274942285, 6283.0931036436), new Vsop87.LnVsop(1.38E-9, 1.09470451313, 8962.438096258), new Vsop87.LnVsop(1.3E-9, 6.03956113045, 1214.8023296234), new Vsop87.LnVsop(1.45E-9, 3.84248010172, 16703.0448798468), new Vsop87.LnVsop(1.29E-9, 4.65674750252, 1957.7250798532), new Vsop87.LnVsop(1.27E-9, 5.03662769208, 28109.214616052), new Vsop87.LnVsop(1.46E-9, 1.54074391924, 8219.4652893776), new Vsop87.LnVsop(1.45E-9, 4.08755206418, 6684.73071809641), new Vsop87.LnVsop(1.37E-9, 3.62229198429, 3511.285297319), new Vsop87.LnVsop(1.26E-9, 3.92743226458, 3.4558080462), new Vsop87.LnVsop(1.25E-9, 3.20445201519, 29.8820436102), new Vsop87.LnVsop(1.25E-9, 3.58832781647, 7696.8878712838), new Vsop87.LnVsop(1.38E-9, 5.317570113, 23958.6317852334), new Vsop87.LnVsop(1.49E-9, 3.29977271138, 11614.4332937322), new Vsop87.LnVsop(1.72E-9, 5.21222240408, 6747.712262314), new Vsop87.LnVsop(1.38E-9, 3.1254761442, 8962.4726035624), new Vsop87.LnVsop(1.27E-9, 3.96217734145, 6314.0005244372), new Vsop87.LnVsop(1.33E-9, 4.32704616146, 6283.0585963392), new Vsop87.LnVsop(1.56E-9, 5.24742627708, 6645.1969867222), new Vsop87.LnVsop(1.37E-9, 4.95496224789, 20995.3929664494), new Vsop87.LnVsop(1.23E-9, 5.41075942033, 688.6344828778), new Vsop87.LnVsop(1.22E-9, 0.61281570628, 5085.1057214178), new Vsop87.LnVsop(1.39E-9, 1.85119959381, 18849.2275499742), new Vsop87.LnVsop(1.55E-9, 5.47145482987, 2.9689454166), new Vsop87.LnVsop(1.61E-9, 2.11502590852, 15265.8865193004), new Vsop87.LnVsop(1.57E-9, 4.61532322282, 3354.8395207014), new Vsop87.LnVsop(1.55E-9, 4.15655698197, 56.3831860762), new Vsop87.LnVsop(1.28E-9, 6.24233081625, 10016.314355792), new Vsop87.LnVsop(1.34E-9, 1.53268827347, 708.98980227659), new Vsop87.LnVsop(1.21E-9, 5.44493287062, 25665.5174834092), new Vsop87.LnVsop(1.2E-9, 3.74478260598, 10294.510237451), new Vsop87.LnVsop(1.44E-9, 5.06033016445, 15010.8964639966), new Vsop87.LnVsop(1.22E-9, 5.07352485901, 14421.8316369884), new Vsop87.LnVsop(1.52E-9, 1.82416311596, 11560.0777160774), new Vsop87.LnVsop(1.18E-9, 1.62305764022, 15849.865751747), new Vsop87.LnVsop(1.45E-9, 6.11832368347, 6684.7652254008), new Vsop87.LnVsop(1.2E-9, 4.83459976273, 4403.517475238), new Vsop87.LnVsop(1.22E-9, 0.1351398509, 8322.5580635962), new Vsop87.LnVsop(1.28E-9, 0.12650369318, 6681.6449294932), new Vsop87.LnVsop(1.42E-9, 0.39408197652, 1111.642245102), new Vsop87.LnVsop(1.19E-9, 1.29925856056, 10544.4146981932), new Vsop87.LnVsop(1.47E-9, 1.8159027965, 685.1113645288), new Vsop87.LnVsop(1.35E-9, 5.17868224908, 8962.522660213), new Vsop87.LnVsop(1.23E-9, 2.42353206298, 6.1332259326), new Vsop87.LnVsop(1.49E-9, 1.47957439553, 9698.331863442), new Vsop87.LnVsop(1.16E-9, 3.40455553212, 10001.48196070061), new Vsop87.LnVsop(1.15E-9, 0.90208741613, 13286.1836355236), new Vsop87.LnVsop(1.19E-9, 4.635012603, 11776.8999298644), new Vsop87.LnVsop(1.37E-9, 1.46004012882, 4819.4790007642), new Vsop87.LnVsop(1.16E-9, 1.43745128638, 3547.3131639964), new Vsop87.LnVsop(1.17E-9, 0.72489390402, 27.4688663996), new Vsop87.LnVsop(1.54E-9, 5.62745874023, 9911.63095888), new Vsop87.LnVsop(1.13E-9, 1.29183528916, 26880.3198130326), new Vsop87.LnVsop(1.57E-9, 0.09791378159, 138.5174968707), new Vsop87.LnVsop(1.13E-9, 5.43102427558, 422.027441156), new Vsop87.LnVsop(1.3E-9, 2.13493506322, 117.812802892), new Vsop87.LnVsop(1.4E-9, 2.5119459163, 28.9816299794), new Vsop87.LnVsop(1.15E-9, 1.17961745351, 4452.2546718018), new Vsop87.LnVsop(1.28E-9, 1.23824324271, 6680.804777306), new Vsop87.LnVsop(1.29E-9, 2.41330294586, 6717.252720077), new Vsop87.LnVsop(1.16E-9, 4.93525830889, 13517.8027959306), new Vsop87.LnVsop(1.21E-9, 2.20434813319, 3334.54651107), new Vsop87.LnVsop(1.1E-9, 0.69968732644, 18977.1790830088), new Vsop87.LnVsop(1.18E-9, 4.93757907461, 12825.6451947038), new Vsop87.LnVsop(1.1E-9, 4.11390197578, 6321.114071438), new Vsop87.LnVsop(1.14E-9, 4.30646265831, 21548.9623692918), new Vsop87.LnVsop(1.17E-9, 0.03006245187, 7.6737919754), new Vsop87.LnVsop(1.32E-9, 1.53814046048, 3391.89276456221), new Vsop87.LnVsop(1.23E-9, 4.70578504377, 9329.6796788726), new Vsop87.LnVsop(1.4E-9, 3.87360904038, 7167.1969061892), new Vsop87.LnVsop(1.1E-9, 4.12727119156, 3188.7151456146), new Vsop87.LnVsop(1.31E-9, 1.04432313302, 3482.791053736), new Vsop87.LnVsop(1.14E-9, 2.45724347193, 3351.6581269637), new Vsop87.LnVsop(1.08E-9, 0.72637519191, 10.569355047), new Vsop87.LnVsop(1.19E-9, 4.19681704458, 12979.553174576), new Vsop87.LnVsop(1.09E-9, 5.22550826337, 21393.5419698576), new Vsop87.LnVsop(1.46E-9, 5.31993935182, 2472.6787626222), new Vsop87.LnVsop(1.11E-9, 3.28808788953, 257.018007743), new Vsop87.LnVsop(1.09E-9, 3.47791497885, 3305.0496922312), new Vsop87.LnVsop(1.34E-9, 1.82746080392, 26887.3660497306), new Vsop87.LnVsop(1.49E-9, 4.91688353237, 277.0349937414), new Vsop87.LnVsop(1.17E-9, 1.20050006732, 6705.1032911474), new Vsop87.LnVsop(1.08E-9, 3.37124346436, 6717.8302187038), new Vsop87.LnVsop(1.13E-9, 4.04247516598, 6953.8978107512), new Vsop87.LnVsop(1.06E-9, 4.69114208822, 25135.8265183146), new Vsop87.LnVsop(1.05E-9, 5.59252457052, 8962.3880396074), new Vsop87.LnVsop(1.06E-9, 0.75378922686, 149.8974751268), new Vsop87.LnVsop(1.36E-9, 1.47344871836, 6830.7880505342), new Vsop87.LnVsop(1.46E-9, 4.99523777859, 9859.3706439672), new Vsop87.LnVsop(1.15E-9, 2.00719238904, 10654.6210194126), new Vsop87.LnVsop(1.08E-9, 5.22204692781, 1556.5681469554), new Vsop87.LnVsop(1.04E-9, 5.49558246627, 3344.152798701), new Vsop87.LnVsop(1.2E-9, 3.90242035384, 9758.7533567266), new Vsop87.LnVsop(1.11E-9, 5.06419066567, 10042.1925994982), new Vsop87.LnVsop(1.33E-9, 1.15811543786, 816.6533262152), new Vsop87.LnVsop(1.03E-9, 0.57055162058, 10011.2006147496), new Vsop87.LnVsop(1.34E-9, 1.69834857217, 183.869586902), new Vsop87.LnVsop(1.04E-9, 3.97743567679, 11567.1912630782), new Vsop87.LnVsop(1.04E-9, 3.46480859433, 3344.11829139661), new Vsop87.LnVsop(1.03E-9, 1.05016194417, 6682.7093261079), new Vsop87.LnVsop(1.22E-9, 2.0878780399, 6533.1461289733), new Vsop87.LnVsop(1.07E-9, 4.42117075795, 7.130800653), new Vsop87.LnVsop(1.37E-9, 4.91348844962, 3413.9095525588), new Vsop87.LnVsop(1.15E-9, 0.02308044664, 13227.3846267638), new Vsop87.LnVsop(1.09E-9, 1.17311653219, 6901.6374958384), new Vsop87.LnVsop(1.02E-9, 1.20680146001, 11986.6759069534), new Vsop87.LnVsop(1.26E-9, 0.03750399181, 16.83220104979), new Vsop87.LnVsop(1.02E-9, 1.47123461557, 34513.2630726828), new Vsop87.LnVsop(1.3E-9, 4.10484632841, 35.6077905838), new Vsop87.LnVsop(1.27E-9, 2.51583917642, 12465.5344127422), new Vsop87.LnVsop(1.13E-9, 3.69200525056, 44.6538332402), new Vsop87.LnVsop(1.11E-9, 5.12900291511, 146.7944328714), new Vsop87.LnVsop(1.16E-9, 5.24145745878, 8742.0427074714), new Vsop87.LnVsop(1.02E-9, 2.41492657376, 3487.4241132234), new Vsop87.LnVsop(1.02E-9, 0.15807862411, 27832.0382192832), new Vsop87.LnVsop(1.22E-9, 6.08232879666, 7100.7094972748), new Vsop87.LnVsop(1.02E-9, 3.19982560601, 5452.2627400774), new Vsop87.LnVsop(1.25E-9, 2.16444546829, 13532.0298899322), new Vsop87.LnVsop(1.05E-9, 2.07688407099, 4686.95671800959), new Vsop87.LnVsop(1.19E-9, 0.56634104835, 31172.650645983), new Vsop87.LnVsop(1.05E-9, 6.16677691518, 9175.7544453482), new Vsop87.LnVsop(1.15E-9, 1.08500262319, 4133.3873151672), new Vsop87.LnVsop(1.12E-9, 0.20425429722, 11883.5831327348), new Vsop87.LnVsop(1.04E-9, 0.51055185396, 7792.8670985016), new Vsop87.LnVsop(9.9E-10, 1.819310262, 20047.1976785478), new Vsop87.LnVsop(1.07E-9, 4.8609991194, 7899.550301372), new Vsop87.LnVsop(1.17E-9, 0.62856768429, 4716.3862265456), new Vsop87.LnVsop(1.3E-9, 2.230457178, 10027.3602044068), new Vsop87.LnVsop(9.9E-10, 0.25622969112, 8432.7471311634), new Vsop87.LnVsop(1.29E-9, 4.77711241452, 11610.9101753832), new Vsop87.LnVsop(1.07E-9, 5.25025570307, 63.7358983034), new Vsop87.LnVsop(1.0E-9, 2.29065214131, 8432.7816384678), new Vsop87.LnVsop(1.14E-9, 2.47914779702, 10156.9023601348), new Vsop87.LnVsop(1.26E-9, 5.50643625731, 5483.254724826), new Vsop87.LnVsop(1.1E-9, 2.77977105247, 16066.0658614748), new Vsop87.LnVsop(1.09E-9, 2.34881658192, 3376.1751611684), new Vsop87.LnVsop(9.7E-10, 4.23431879636, 4186.695261451), new Vsop87.LnVsop(1.12E-9, 1.43537110436, 16232.745030318), new Vsop87.LnVsop(1.17E-9, 3.14652328036, 2921.6880277992), new Vsop87.LnVsop(1.04E-9, 4.09017482677, 3337.0720546986), new Vsop87.LnVsop(1.02E-9, 5.32025350615, 1868.8593996362), new Vsop87.LnVsop(1.05E-9, 2.4302934574, 5888.4499649322), new Vsop87.LnVsop(1.12E-9, 6.19134041529, 6685.1570066627), new Vsop87.LnVsop(9.7E-10, 4.25558254516, 7906.59653807), new Vsop87.LnVsop(1.31E-9, 2.8404679696, 3370.1042450032), new Vsop87.LnVsop(1.04E-9, 2.26093518585, 4845.9002357928), new Vsop87.LnVsop(1.14E-9, 0.0319484617, 12729.665967486), new Vsop87.LnVsop(9.5E-10, 2.57050539743, 12715.4388734844), new Vsop87.LnVsop(9.6E-10, 0.19715808883, 48429.2821823244), new Vsop87.LnVsop(9.5E-10, 0.92069745429, 3338.069629419), new Vsop87.LnVsop(1.05E-9, 0.7887394661, 3416.8784979754), new Vsop87.LnVsop(9.6E-10, 3.08847844722, 3468.6312700372), new Vsop87.LnVsop(9.6E-10, 3.64475101106, 19669.33668423559), new Vsop87.LnVsop(9.9E-10, 1.88513067598, 37895.4262903674), new Vsop87.LnVsop(1.26E-9, 3.93261698226, 11346.7786206394), new Vsop87.LnVsop(9.5E-10, 1.29341559946, 4878.8528626778), new Vsop87.LnVsop(1.22E-9, 4.21983150256, 3308.640120883), new Vsop87.LnVsop(9.9E-10, 4.28251731179, 16328.72425753579), new Vsop87.LnVsop(1.27E-9, 3.00977146208, 1250.8301963008), new Vsop87.LnVsop(1.2E-9, 1.1008147175, 6530.1771835567), new Vsop87.LnVsop(1.17E-9, 2.78340734359, 7075.8507384588), new Vsop87.LnVsop(1.19E-9, 3.82073518708, 9072.6616711296), new Vsop87.LnVsop(9.5E-10, 1.08015473076, 3590.516887442), new Vsop87.LnVsop(1.04E-9, 6.12094869404, 3337.106562003), new Vsop87.LnVsop(9.1E-10, 2.51770714335, 3535.5838111604), new Vsop87.LnVsop(9.5E-10, 4.69142853355, 5298.337506553), new Vsop87.LnVsop(9.5E-10, 1.5122287595, 9801.4246376606), new Vsop87.LnVsop(1.02E-9, 3.11721207691, 1125.8693391036), new Vsop87.LnVsop(1.22E-9, 5.18912588487, 3181.6689089166), new Vsop87.LnVsop(9.9E-10, 1.86991802881, 72.0557333548), new Vsop87.LnVsop(9.3E-10, 1.46980370953, 3966.2826190122), new Vsop87.LnVsop(9.1E-10, 4.93994845429, 8756.269801473), new Vsop87.LnVsop(9.1E-10, 2.11778022918, 6566.8257464862), new Vsop87.LnVsop(1.04E-9, 2.01597245478, 4296.9015826704), new Vsop87.LnVsop(9.0E-10, 4.19650336439, 3031.334104044), new Vsop87.LnVsop(9.0E-10, 5.86117667759, 17917.79715281959), new Vsop87.LnVsop(9.1E-10, 6.19589151073, 24491.4257925834), new Vsop87.LnVsop(9.3E-10, 0.6609244332, 30.9919847486), new Vsop87.LnVsop(9.0E-10, 4.60989668841, 3253.30422216), new Vsop87.LnVsop(1.11E-9, 4.43458709473, 8771.0070837986), new Vsop87.LnVsop(8.8E-10, 1.20181460611, 4606.1799053262), new Vsop87.LnVsop(1.01E-9, 1.61358478291, 10032.4739454492), new Vsop87.LnVsop(9.4E-10, 0.61277732908, 73.6354632196), new Vsop87.LnVsop(9.1E-10, 6.04139177526, 153.9252335244), new Vsop87.LnVsop(9.6E-10, 3.00553509047, 3528.5375744624), new Vsop87.LnVsop(9.3E-10, 2.55257560859, 11663.170490296), new Vsop87.LnVsop(8.7E-10, 3.23609121022, 10191.4174632324), new Vsop87.LnVsop(9.2E-10, 0.40307254912, 12410.7313005486), new Vsop87.LnVsop(9.1E-10, 0.72417545511, 3152.68727893721), new Vsop87.LnVsop(9.0E-10, 5.40526592844, 5749.8617665478), new Vsop87.LnVsop(8.6E-10, 3.07517979536, 9983.7042444616), new Vsop87.LnVsop(1.14E-9, 4.15078942938, 1795.258443721), new Vsop87.LnVsop(9.6E-10, 4.49946425864, 13465.5424810178), new Vsop87.LnVsop(9.5E-10, 4.92419886101, 11876.469585734), new Vsop87.LnVsop(8.6E-10, 3.94463425808, 16.764890747), new Vsop87.LnVsop(8.8E-10, 4.79020600339, 10228.0228285366), new Vsop87.LnVsop(1.17E-9, 3.33978190557, 14157.7000822446), new Vsop87.LnVsop(8.7E-10, 0.65289292644, 44933.2493561904), new Vsop87.LnVsop(1.12E-9, 1.7998603225, 16489.763038061), new Vsop87.LnVsop(1.01E-9, 2.99759769519, 6510.5519827804), new Vsop87.LnVsop(9.8E-10, 2.43903528074, 20040.15144184979), new Vsop87.LnVsop(8.5E-10, 5.85834792405, 4531.5363185754), new Vsop87.LnVsop(1.18E-9, 6.10625309129, 454.9093665273), new Vsop87.LnVsop(8.5E-10, 1.13150581276, 3185.2593375684), new Vsop87.LnVsop(8.4E-10, 3.03267975707, 29822.7832363242), new Vsop87.LnVsop(8.7E-10, 1.94797272973, 19645.5255567906), new Vsop87.LnVsop(8.6E-10, 1.67944270491, 12839.8722887054), new Vsop87.LnVsop(8.7E-10, 0.2917955447, 1008.5494708834), new Vsop87.LnVsop(9.0E-10, 6.12668943416, 4106.4054911462), new Vsop87.LnVsop(9.1E-10, 0.30519839929, 29168.5965462412), new Vsop87.LnVsop(9.8E-10, 4.9660573107, 13738.2154383694), new Vsop87.LnVsop(1.08E-9, 3.24595015647, 8976.6824439118), new Vsop87.LnVsop(8.7E-10, 2.19665405981, 30774.5016425748), new Vsop87.LnVsop(8.3E-10, 0.37254540738, 9755.2302383776), new Vsop87.LnVsop(8.4E-10, 2.79617391142, 17932.0242468212), new Vsop87.LnVsop(8.2E-10, 5.39440314476, 8034.6153814074), new Vsop87.LnVsop(8.7E-10, 4.25461508452, 8.1681365824), new Vsop87.LnVsop(8.3E-10, 3.59056707325, 12928.7379689224), new Vsop87.LnVsop(1.03E-9, 5.10956502639, 10096.6188786667), new Vsop87.LnVsop(8.7E-10, 2.90507350729, 36.995590611), new Vsop87.LnVsop(8.6E-10, 2.46839611271, 113.7294395684), new Vsop87.LnVsop(8.6E-10, 5.94383601123, 12299.544658261), new Vsop87.LnVsop(8.1E-10, 4.34691999939, 7218.029365495), new Vsop87.LnVsop(1.0E-9, 2.70908218218, 8186.5126624926), new Vsop87.LnVsop(8.3E-10, 4.79763505745, 4576.6880870228), new Vsop87.LnVsop(8.7E-10, 3.71852499272, 4466.4817658034), new Vsop87.LnVsop(8.7E-10, 2.2276759311, 7082.8969751568), new Vsop87.LnVsop(9.5E-10, 0.02613500045, 2.9010142898), new Vsop87.LnVsop(9.8E-10, 3.0173164622, 7417.1013669314), new Vsop87.LnVsop(1.03E-9, 2.02932898904, 13575.7488022372), new Vsop87.LnVsop(1.12E-9, 3.51920419851, 10081.211142013), new Vsop87.LnVsop(8.1E-10, 5.27347932531, 12306.590894959), new Vsop87.LnVsop(8.0E-10, 5.30097809145, 12199.9750023914), new Vsop87.LnVsop(8.5E-10, 3.48487631448, 12082.6551341712), new Vsop87.LnVsop(8.1E-10, 3.12811545216, 3517.3061568336), new Vsop87.LnVsop(8.3E-10, 4.04362899636, 9815.6517316622), new Vsop87.LnVsop(1.05E-9, 1.2053742484, 987.746272928), new Vsop87.LnVsop(8.0E-10, 2.75350306236, 4555.4147563232), new Vsop87.LnVsop(8.0E-10, 5.7621414558, 2233.473621015), new Vsop87.LnVsop(8.5E-10, 0.77891047651, 7214.4389368432), new Vsop87.LnVsop(7.8E-10, 5.77285430206, 10397.6030116696), new Vsop87.LnVsop(9.3E-10, 5.04819365736, 4271.9755135516), new Vsop87.LnVsop(8.0E-10, 1.47742659857, 4307.5833041354), new Vsop87.LnVsop(8.8E-10, 3.84681925437, 3738.7441764558), new Vsop87.LnVsop(1.04E-9, 3.22519800674, 4922.5717749828), new Vsop87.LnVsop(7.8E-10, 5.05074461881, 8006.1661939396), new Vsop87.LnVsop(8.0E-10, 4.13191548311, 30376.3526391666), new Vsop87.LnVsop(8.4E-10, 2.20622406791, 13421.8235687128), new Vsop87.LnVsop(8.2E-10, 3.11747431441, 8446.9914788172), new Vsop87.LnVsop(8.0E-10, 0.71562475799, 33561.5446664322), new Vsop87.LnVsop(1.0E-9, 3.58742182292, 45884.967762441), new Vsop87.LnVsop(8.0E-10, 2.55223452516, 3866.7802734454), new Vsop87.LnVsop(7.5E-10, 0.83023725236, 4936.7988689844), new Vsop87.LnVsop(9.2E-10, 5.55183329656, 21150.8133658836), new Vsop87.LnVsop(1.05E-9, 1.74376904536, 36.6485629295), new Vsop87.LnVsop(7.8E-10, 4.23158542581, 16858.41522263039), new Vsop87.LnVsop(9.2E-10, 2.67278833504, 6680.7949702729), new Vsop87.LnVsop(8.4E-10, 4.21345200999, 12032.9376165392), new Vsop87.LnVsop(7.9E-10, 3.55634560374, 14867.73751589219), new Vsop87.LnVsop(7.7E-10, 0.10707484151, 1371.411763456), new Vsop87.LnVsop(9.9E-10, 3.94316594852, 18208.349942592), new Vsop87.LnVsop(7.4E-10, 5.76839140325, 34911.412076091), new Vsop87.LnVsop(7.9E-10, 0.45356515278, 6677.71898870279), new Vsop87.LnVsop(8.6E-10, 0.54257145537, 14128.2427712456), new Vsop87.LnVsop(7.3E-10, 3.43102571889, 11037.5002979836), new Vsop87.LnVsop(7.3E-10, 0.2350856917, 12942.965062924), new Vsop87.LnVsop(8.1E-10, 3.50070907013, 6637.5059410946), new Vsop87.LnVsop(7.3E-10, 5.80611062016, 6791.431174619), new Vsop87.LnVsop(7.9E-10, 3.7866638604, 7.5786792096), new Vsop87.LnVsop(9.6E-10, 0.94977866466, 2735.762685995), new Vsop87.LnVsop(9.2E-10, 5.05270450333, 7064.1041319706), new Vsop87.LnVsop(8.0E-10, 1.94954501782, 19190.4781784468), new Vsop87.LnVsop(9.3E-10, 4.61161625562, 11375.2278081072), new Vsop87.LnVsop(9.1E-10, 0.62128517647, 1859.2030553546), new Vsop87.LnVsop(7.3E-10, 4.42902162523, 14.7372823256), new Vsop87.LnVsop(9.1E-10, 5.90153724443, 3738.7786837602), new Vsop87.LnVsop(8.5E-10, 0.92387511094, 8425.7181481176), new Vsop87.LnVsop(9.4E-10, 3.41238195399, 1596.1191319818), new Vsop87.LnVsop(8.4E-10, 1.35940497722, 1727.6610936682), new Vsop87.LnVsop(7.3E-10, 2.8701985163, 2854.6403739102), new Vsop87.LnVsop(7.8E-10, 4.35635552621, 15650.7937503106), new Vsop87.LnVsop(7.7E-10, 2.7110834036, 12089.768681172), new Vsop87.LnVsop(8.1E-10, 2.92874448709, 9093.9973115966), new Vsop87.LnVsop(7.7E-10, 3.69143222544, 2961.2390128256), new Vsop87.LnVsop(7.9E-10, 4.70597882671, 6677.6844813984), new Vsop87.LnVsop(7.8E-10, 2.2152514873, 2810.988771908), new Vsop87.LnVsop(8.5E-10, 5.81355746707, 13369.5632538), new Vsop87.LnVsop(8.8E-10, 1.38044467337, 3145.6410422392), new Vsop87.LnVsop(7.1E-10, 4.04186021414, 259.493494721), new Vsop87.LnVsop(7.1E-10, 5.32626176411, 6670.1791531357), new Vsop87.LnVsop(7.3E-10, 4.81618807315, 12140.6011404778), new Vsop87.LnVsop(9.0E-10, 5.8416824642, 3492.509707785), new Vsop87.LnVsop(7.2E-10, 1.58795997168, 3738.6941198052), new Vsop87.LnVsop(7.1E-10, 3.73621908569, 35309.5610794992), new Vsop87.LnVsop(8.1E-10, 2.48353174238, 73.6009559152), new Vsop87.LnVsop(7.0E-10, 3.89351336867, 10014.7910434014), new Vsop87.LnVsop(7.5E-10, 6.00708764619, 3288.352111787), new Vsop87.LnVsop(7.8E-10, 4.75144277168, 13366.040135451), new Vsop87.LnVsop(7.0E-10, 1.16428742272, 5220.1708014532), new Vsop87.LnVsop(8.4E-10, 5.8322038791, 22.3782713026), new Vsop87.LnVsop(7.6E-10, 3.6127919871, 21791.69097326579), new Vsop87.LnVsop(7.4E-10, 5.6662633197, 9360.6043533184), new Vsop87.LnVsop(7.0E-10, 4.40324083193, 3890.65871119319), new Vsop87.LnVsop(7.1E-10, 4.00935897397, 5525.8636959926), new Vsop87.LnVsop(6.8E-10, 4.8874602193, 4379.6390374902), new Vsop87.LnVsop(8.0E-10, 4.01817623709, 3311.18291816379), new Vsop87.LnVsop(8.9E-10, 5.76998389711, 1484.9324896942), new Vsop87.LnVsop(6.8E-10, 3.48229080099, 5562.4690612968), new Vsop87.LnVsop(7.1E-10, 2.51223960753, 1747.6073781529), new Vsop87.LnVsop(7.0E-10, 5.68783910757, 10448.4354709754), new Vsop87.LnVsop(9.2E-10, 4.97511245092, 6681.6547365263), new Vsop87.LnVsop(8.2E-10, 1.81441052191, 10288.4443218212), new Vsop87.LnVsop(7.0E-10, 5.21095521076, 13363.4300278674), new Vsop87.LnVsop(7.8E-10, 2.62374787415, 2810.8541513024), new Vsop87.LnVsop(6.8E-10, 2.09958151441, 10264.5658840734), new Vsop87.LnVsop(6.7E-10, 4.76413431634, 6812.766815086), new Vsop87.LnVsop(6.8E-10, 3.88516811058, 13207.029307365), new Vsop87.LnVsop(6.9E-10, 3.25036054417, 3564.9572224017), new Vsop87.LnVsop(6.7E-10, 1.84261705009, 27433.88921587499), new Vsop87.LnVsop(6.6E-10, 0.33678070136, 7322.1024607818), new Vsop87.LnVsop(8.1E-10, 4.91537623846, 3333.9287628257), new Vsop87.LnVsop(7.8E-10, 4.25365984833, 19617.07636932279), new Vsop87.LnVsop(7.3E-10, 5.81831824202, 8823.8671515258), new Vsop87.LnVsop(7.4E-10, 0.8601338758, 16695.94858649819), new Vsop87.LnVsop(8.8E-10, 2.9696162326, 9278.8472195668), new Vsop87.LnVsop(6.5E-10, 3.50464480159, 9161.5273513466), new Vsop87.LnVsop(7.1E-10, 0.93609590112, 6106.8800550648), new Vsop87.LnVsop(6.5E-10, 4.90073827871, 3468.5639597344), new Vsop87.LnVsop(8.7E-10, 3.8226617725, 1236.075660323), new Vsop87.LnVsop(6.5E-10, 6.18524090914, 7447.017917846), new Vsop87.LnVsop(7.5E-10, 2.558785658, 6614.7374444852), new Vsop87.LnVsop(7.4E-10, 5.71066387461, 10177.1903692308), new Vsop87.LnVsop(6.8E-10, 5.87307358517, 25827.9841195414), new Vsop87.LnVsop(6.9E-10, 1.10040460862, 2544.3316735356), new Vsop87.LnVsop(6.3E-10, 6.05841287869, 6453.7487206106), new Vsop87.LnVsop(6.3E-10, 5.33982712678, 21427.9897626524), new Vsop87.LnVsop(6.6E-10, 0.61216028778, 7636.4663779992), new Vsop87.LnVsop(6.2E-10, 2.80917285403, 13497.5147868346), new Vsop87.LnVsop(6.9E-10, 2.67029728661, 2641.3412784722), new Vsop87.LnVsop(6.8E-10, 2.8114993717, 11527.1250891924), new Vsop87.LnVsop(7.3E-10, 3.87202159748, 13361.469385731), new Vsop87.LnVsop(6.1E-10, 4.18998708823, 16547.6417340648), new Vsop87.LnVsop(6.0E-10, 2.68408219587, 5349.1699658588), new Vsop87.LnVsop(7.0E-10, 2.35679546987, 34115.1140692746), new Vsop87.LnVsop(6.2E-10, 5.4900267572, 4957.0868780804), new Vsop87.LnVsop(5.9E-10, 5.80950485486, 104351.61256629678), new Vsop87.LnVsop(6.9E-10, 2.30347059296, 97670.38771289718), new Vsop87.LnVsop(6.9E-10, 6.04860680134, 1755.4716846791), new Vsop87.LnVsop(7.2E-10, 3.38857910365, 3184.2117061974), new Vsop87.LnVsop(7.1E-10, 4.22665032671, 7321.1221397136), new Vsop87.LnVsop(6.8E-10, 5.51088021361, 10338.229149756), new Vsop87.LnVsop(6.9E-10, 5.35281824747, 2544.2971662312), new Vsop87.LnVsop(5.8E-10, 4.61544075896, 9993.3880926316), new Vsop87.LnVsop(6.3E-10, 1.78218487848, 3212.6608936652), new Vsop87.LnVsop(6.2E-10, 1.91794313526, 33406.124266998), new Vsop87.LnVsop(5.9E-10, 2.331045733, 16762.4359954126), new Vsop87.LnVsop(6.0E-10, 6.18449904435, 3361.9480671668), new Vsop87.LnVsop(7.1E-10, 2.67980129538, 37455.7264959744), new Vsop87.LnVsop(5.7E-10, 4.30790872161, 2281.2978068134), new Vsop87.LnVsop(6.1E-10, 4.47177526691, 14164.8136292454), new Vsop87.LnVsop(7.0E-10, 5.09917701225, 14556.8967170238), new Vsop87.LnVsop(5.7E-10, 6.03596769323, 9153.9036160218), new Vsop87.LnVsop(6.8E-10, 3.42411140913, 13287.6681082319), new Vsop87.LnVsop(6.5E-10, 4.21643739347, 24341.5283174566), new Vsop87.LnVsop(6.1E-10, 3.70644708708, 27299.2442119332), new Vsop87.LnVsop(6.4E-10, 3.44679554408, 9705.4454104428), new Vsop87.LnVsop(5.9E-10, 4.29916130935, 6851.8977240188), new Vsop87.LnVsop(7.1E-10, 0.81330027413, 3495.9655158312), new Vsop87.LnVsop(5.5E-10, 2.02448369373, 12012.5822971404), new Vsop87.LnVsop(6.4E-10, 6.21854445626, 20043.69181385099), new Vsop87.LnVsop(5.7E-10, 1.65488419713, 7768.0083396856), new Vsop87.LnVsop(7.1E-10, 0.81484322638, 9918.7445058808), new Vsop87.LnVsop(5.6E-10, 1.69730662572, 6534.413166876), new Vsop87.LnVsop(5.6E-10, 2.10021276669, 16702.9948231962), new Vsop87.LnVsop(5.4E-10, 4.52069302724, 9797.4924843975), new Vsop87.LnVsop(5.4E-10, 3.66018591555, 2917.5373541728), new Vsop87.LnVsop(5.4E-10, 3.6102390844, 6724.9437657046), new Vsop87.LnVsop(6.5E-10, 3.83143101879, 8373.390522902), new Vsop87.LnVsop(5.5E-10, 4.76564251752, 7733.493236588), new Vsop87.LnVsop(6.1E-10, 0.7189403175, 27873.589010268), new Vsop87.LnVsop(6.0E-10, 4.4715138554, 10284.9212034722), new Vsop87.LnVsop(5.9E-10, 5.00684013554, 299.1263942692), new Vsop87.LnVsop(5.5E-10, 4.47014622234, 10661.7345664134), new Vsop87.LnVsop(6.0E-10, 4.79529219015, 8638.9499332528), new Vsop87.LnVsop(5.7E-10, 0.60812343267, 4665.5537672398), new Vsop87.LnVsop(5.5E-10, 4.98558072531, 4061.751657906), new Vsop87.LnVsop(5.3E-10, 3.30259294876, 9683.5945811164), new Vsop87.LnVsop(5.3E-10, 4.65521663752, 3448.2759506384), new Vsop87.LnVsop(5.4E-10, 5.2529237944, 8550.0842530358), new Vsop87.LnVsop(6.2E-10, 2.59467816822, 8852.2490286908), new Vsop87.LnVsop(6.7E-10, 1.52249437123, 16342.9513515374), new Vsop87.LnVsop(5.6E-10, 1.69180472887, 16703.1294438018), new Vsop87.LnVsop(6.8E-10, 3.1599559685, 7807.0941925032), new Vsop87.LnVsop(5.2E-10, 2.92990649723, 9495.6694333538), new Vsop87.LnVsop(6.2E-10, 5.2559836694, 2963.238818784), new Vsop87.LnVsop(5.7E-10, 0.28187782188, 4558.9378746722), new Vsop87.LnVsop(5.9E-10, 0.28351688317, 4565.9841113702), new Vsop87.LnVsop(5.8E-10, 0.47150770624, 4140.4335518652), new Vsop87.LnVsop(5.2E-10, 2.67305259324, 19247.3765533824), new Vsop87.LnVsop(6.1E-10, 4.33806308874, 8695.8483081884), new Vsop87.LnVsop(7.1E-10, 1.0187328087, 7668.9711263276), new Vsop87.LnVsop(5.6E-10, 2.06509121766, 12502.1397780464), new Vsop87.LnVsop(5.1E-10, 6.03668121035, 6719.3578890374), new Vsop87.LnVsop(6.0E-10, 0.77450277046, 3319.2767862328), new Vsop87.LnVsop(5.1E-10, 3.92795812352, 3353.85419909779), new Vsop87.LnVsop(5.1E-10, 2.8987387241, 22854.596021804), new Vsop87.LnVsop(5.1E-10, 2.00779962852, 2957.7331481288), new Vsop87.LnVsop(5.3E-10, 5.07857417426, 14951.522602083), new Vsop87.LnVsop(6.4E-10, 1.36079827459, 23024.176204937), new Vsop87.LnVsop(5.3E-10, 3.57183813569, 6836.577942531), new Vsop87.LnVsop(5.1E-10, 1.95411630686, 3327.3706543018), new Vsop87.LnVsop(5.0E-10, 0.37366902916, 3322.7999045818), new Vsop87.LnVsop(5.3E-10, 0.26142839753, 41990.7859328988), new Vsop87.LnVsop(5.4E-10, 6.27949370995, 35707.7100829074), new Vsop87.LnVsop(4.9E-10, 0.06709673316, 10787.6303445458), new Vsop87.LnVsop(5.1E-10, 2.54863900486, 4001.8453534808), new Vsop87.LnVsop(5.3E-10, 1.18631858606, 34554.8138636676), new Vsop87.LnVsop(4.8E-10, 4.04972593744, 114.3991069134), new Vsop87.LnVsop(4.9E-10, 0.3292093485, 41748.0573289248), new Vsop87.LnVsop(4.8E-10, 2.81171553545, 3372.5847325166), new Vsop87.LnVsop(6.1E-10, 1.00871506195, 16511.6138673874), new Vsop87.LnVsop(5.3E-10, 3.71538403834, 10050.2864675672), new Vsop87.LnVsop(4.7E-10, 4.46160440369, 6151.5166346528), new Vsop87.LnVsop(4.8E-10, 1.63487940392, 20213.25474333179), new Vsop87.LnVsop(5.1E-10, 3.56556636385, 19403.7772738848), new Vsop87.LnVsop(5.4E-10, 0.78070691021, 41194.4879260824), new Vsop87.LnVsop(4.7E-10, 6.10253848179, 10037.0897512844), new Vsop87.LnVsop(5.0E-10, 1.45609883704, 3717.9860346156), new Vsop87.LnVsop(5.0E-10, 5.05658775146, 4694.0029547076), new Vsop87.LnVsop(6.3E-10, 5.78355830951, 9090.4741932476), new Vsop87.LnVsop(5.0E-10, 3.75626474913, 3987.6232600146), new Vsop87.LnVsop(4.7E-10, 2.91658062679, 9488.6231966558), new Vsop87.LnVsop(4.6E-10, 2.69392312363, 17232.7530985936), new Vsop87.LnVsop(5.5E-10, 5.61673764413, 45494.58142974879), new Vsop87.LnVsop(4.6E-10, 3.66390779389, 14955.045720432), new Vsop87.LnVsop(4.6E-10, 4.56516015922, 20199.02764933019), new Vsop87.LnVsop(5.4E-10, 4.71237273616, 2281.1631862078), new Vsop87.LnVsop(4.7E-10, 1.67898138956, 3130.8364496108), new Vsop87.LnVsop(5.4E-10, 4.28556627685, 2910.4911174748), new Vsop87.LnVsop(4.8E-10, 0.7225096474, 18617.0683010472), new Vsop87.LnVsop(4.5E-10, 2.2839393616, 22986.1379834904), new Vsop87.LnVsop(4.9E-10, 2.14605615, 19830.3754647608), new Vsop87.LnVsop(4.7E-10, 4.12536462391, 23009.94911093539), new Vsop87.LnVsop(4.9E-10, 5.16525026592, 3774.3241645766), new Vsop87.LnVsop(4.5E-10, 3.89882558892, 12988.111830836), new Vsop87.LnVsop(4.8E-10, 4.74927850843, 529.6737114424), new Vsop87.LnVsop(5.5E-10, 4.19502260708, 20043.6573065466), new Vsop87.LnVsop(5.7E-10, 1.14903860224, 7747.7203305896), new Vsop87.LnVsop(4.4E-10, 0.79186614799, 26357.675084636), new Vsop87.LnVsop(4.4E-10, 3.13459824792, 13951.5145338074), new Vsop87.LnVsop(4.3E-10, 2.23439626313, 1987.221898692), new Vsop87.LnVsop(5.8E-10, 2.28159262648, 10006.5848089144), new Vsop87.LnVsop(4.6E-10, 0.16036583144, 18763.8799875708), new Vsop87.LnVsop(4.5E-10, 1.7230204627, 17402.3332817266), new Vsop87.LnVsop(4.3E-10, 5.7583185499, 25298.2931544468), new Vsop87.LnVsop(4.7E-10, 5.2743793228, 423.075072527), new Vsop87.LnVsop(6.0E-10, 3.50233382826, 6511.6446702666), new Vsop87.LnVsop(4.3E-10, 1.82217346876, 10017.9559447414), new Vsop87.LnVsop(4.9E-10, 4.64906795465, 6251.1035441746), new Vsop87.LnVsop(4.2E-10, 5.31789294983, 11368.1815714092), new Vsop87.LnVsop(4.8E-10, 0.49685981802, 529.7082187468), new Vsop87.LnVsop(5.1E-10, 0.63985050945, 17499.3601403154), new Vsop87.LnVsop(4.8E-10, 0.19901251387, 1905.4647649404), new Vsop87.LnVsop(5.5E-10, 1.08536866814, 1059.364676537), new Vsop87.LnVsop(5.6E-10, 4.31837960167, 13358.8592781474), new Vsop87.LnVsop(4.6E-10, 3.71161153699, 8958.5231966471), new Vsop87.LnVsop(4.2E-10, 3.41202446638, 7788.3636590844), new Vsop87.LnVsop(5.0E-10, 2.27112469625, 3427.9206312396), new Vsop87.LnVsop(5.5E-10, 5.25814691818, 12808.8803039568), new Vsop87.LnVsop(4.8E-10, 0.28684868478, 11935.8434476476), new Vsop87.LnVsop(5.0E-10, 0.30214747846, 3358.4249488178), new Vsop87.LnVsop(4.3E-10, 5.05297177364, 3229.4257844122), new Vsop87.LnVsop(4.1E-10, 4.11754654123, 6553.2060100622), new Vsop87.LnVsop(4.3E-10, 1.90603004116, 3451.7990689874), new Vsop87.LnVsop(4.6E-10, 4.45432031146, 3707.8367556622), new Vsop87.LnVsop(4.1E-10, 2.8842706423, 927.8399685028), new Vsop87.LnVsop(4.0E-10, 5.10715968924, 14715.840234807), new Vsop87.LnVsop(5.0E-10, 5.23088101452, 2373.6415492642), new Vsop87.LnVsop(3.9E-10, 3.58038785427, 9124.9219860424), new Vsop87.LnVsop(5.2E-10, 4.06208791228, 17660.303464057), new Vsop87.LnVsop(4.3E-10, 0.22819734412, 10025.7186154574), new Vsop87.LnVsop(4.0E-10, 2.65434458508, 3341.7930693519), new Vsop87.LnVsop(4.9E-10, 5.4007809772, 17762.4440636882), new Vsop87.LnVsop(3.9E-10, 0.41453755531, 5096.0841113789), new Vsop87.LnVsop(5.2E-10, 2.59285184666, 2538.2485042536), new Vsop87.LnVsop(4.5E-10, 4.19179574727, 37057.5774925662), new Vsop87.LnVsop(4.3E-10, 4.02858922778, 6258.1497808726), new Vsop87.LnVsop(4.1E-10, 1.71920640714, 10507.809332889), new Vsop87.LnVsop(3.8E-10, 2.11769718484, 8123.4860621598), new Vsop87.LnVsop(4.9E-10, 2.41908302484, 20441.823563607), new Vsop87.LnVsop(4.6E-10, 3.05701386187, 2324.9494088156), new Vsop87.LnVsop(4.5E-10, 5.57751456016, 15423.267560871), new Vsop87.LnVsop(4.0E-10, 2.80315795515, 7520.19414115), new Vsop87.LnVsop(5.0E-10, 3.42753416123, 52566.19261584059), new Vsop87.LnVsop(4.9E-10, 2.1165360514, 22189.839976674), new Vsop87.LnVsop(4.3E-10, 3.04326197275, 41592.6369294906), new Vsop87.LnVsop(3.9E-10, 3.58098532394, 867.9336640776), new Vsop87.LnVsop(4.0E-10, 3.20381465754, 29428.515568274), new Vsop87.LnVsop(3.8E-10, 3.65843764774, 13341.6743113068), new Vsop87.LnVsop(3.7E-10, 3.99759212306, 12725.453434775), new Vsop87.LnVsop(4.2E-10, 4.13817253189, 8336.7851575978), new Vsop87.LnVsop(3.8E-10, 0.5809949958, 8966.3875031733), new Vsop87.LnVsop(4.9E-10, 2.27415271613, 3123.7902129128), new Vsop87.LnVsop(3.7E-10, 3.14802303104, 5466.4225237762), new Vsop87.LnVsop(4.6E-10, 1.23573182695, 11787.603905517), new Vsop87.LnVsop(3.7E-10, 5.60013944614, 8123.503315812), new Vsop87.LnVsop(3.9E-10, 2.12359970883, 23387.8101052476), new Vsop87.LnVsop(3.7E-10, 5.00181395644, 17810.2009391838), new Vsop87.LnVsop(3.8E-10, 6.00950016545, 4295.8539512994), new Vsop87.LnVsop(4.0E-10, 6.05295156557, 6151.5511419572), new Vsop87.LnVsop(3.6E-10, 0.4267490089, 9997.9588423516), new Vsop87.LnVsop(4.4E-10, 4.13342515647, 12192.8614553906), new Vsop87.LnVsop(3.7E-10, 2.57249437155, 9815.1365428028), new Vsop87.LnVsop(3.6E-10, 0.30459710615, 10618.0156541084), new Vsop87.LnVsop(3.9E-10, 1.53352233747, 6683.9763640106), new Vsop87.LnVsop(5.0E-10, 5.87136225569, 4396.47123854), new Vsop87.LnVsop(4.0E-10, 4.58209614492, 8294.1761864312), new Vsop87.LnVsop(3.6E-10, 3.2649738782, 16269.35039562219), new Vsop87.LnVsop(4.0E-10, 4.17543231683, 9962.4634181858), new Vsop87.LnVsop(3.6E-10, 1.9591812397, 360.1107819616), new Vsop87.LnVsop(3.8E-10, 2.38454082948, 24093.2767891752), new Vsop87.LnVsop(3.6E-10, 2.85429847882, 6549.6828917132), new Vsop87.LnVsop(3.8E-10, 3.54096291728, 19683.5637782372), new Vsop87.LnVsop(3.7E-10, 3.74762124247, 1045.1548361876), new Vsop87.LnVsop(4.3E-10, 5.45850357191, 17608.5188301638), new Vsop87.LnVsop(3.9E-10, 5.8800174671, 4709.2726795448), new Vsop87.LnVsop(4.0E-10, 4.23855320433, 3339.4317840477), new Vsop87.LnVsop(4.2E-10, 3.73781410726, 7593.7950970652)};

        Lontitude0() {
        }
    }
}

