/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.Vsop87;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Mercury {
    static double cJD = 0.0;
    static double cL = 0.0;
    static double cB = 0.0;
    static double cR = 0.0;

    public static void ln_get_mercury_equ_coords(double JD, LnEquPosn position) {
        double c;
        double b;
        double a;
        double last;
        double delta;
        double diff;
        LnHelioPosn h_sol = new LnHelioPosn();
        LnHelioPosn h_mercury = new LnHelioPosn();
        LnRectPosn g_sol = new LnRectPosn();
        LnRectPosn g_mercury = new LnRectPosn();
        double t = 0.0;
        Solar.ln_get_solar_geom_coords(JD, h_sol);
        Transform.ln_get_rect_from_helio(h_sol, g_sol);
        do {
            last = t;
            Mercury.ln_get_mercury_helio_coords(JD - t, h_mercury);
            Transform.ln_get_rect_from_helio(h_mercury, g_mercury);
            a = g_sol.X + g_mercury.X;
            b = g_sol.Y + g_mercury.Y;
            c = g_sol.Z + g_mercury.Z;
            delta = a * a + b * b + c * c;
        } while ((diff = (t = (delta = Math.sqrt(delta)) * 0.0057755183) - last) > 1.0E-4 || diff < -1.0E-4);
        double ra = Math.atan2(b, a);
        double dec = c / delta;
        dec = Math.asin(dec);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_mercury_helio_coords(double JD, LnHelioPosn position) {
        if (JD == cJD) {
            position.L = cL;
            position.B = cB;
            position.R = cR;
            return;
        }
        double t = (JD - 2451545.0) / 365250.0;
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double t5 = t4 * t;
        double L0 = Vsop87.ln_calc_series(Longitude0.mercury_longitude_l0, t);
        double L1 = Vsop87.ln_calc_series(Longitude1.mercury_longitude_l1, t);
        double L2 = Vsop87.ln_calc_series(Longitude1.mercury_longitude_l2, t);
        double L3 = Vsop87.ln_calc_series(Longitude1.mercury_longitude_l3, t);
        double L4 = Vsop87.ln_calc_series(Longitude1.mercury_longitude_l4, t);
        double L5 = Vsop87.ln_calc_series(Longitude1.mercury_longitude_l5, t);
        position.L = L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5;
        double B0 = Vsop87.ln_calc_series(Latitude.mercury_latitude_b0, t);
        double B1 = Vsop87.ln_calc_series(Latitude.mercury_latitude_b1, t);
        double B2 = Vsop87.ln_calc_series(Latitude.mercury_latitude_b2, t);
        double B3 = Vsop87.ln_calc_series(Latitude.mercury_latitude_b3, t);
        double B4 = Vsop87.ln_calc_series(Latitude.mercury_latitude_b4, t);
        double B5 = Vsop87.ln_calc_series(Latitude.mercury_latitude_b5, t);
        position.B = B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5;
        double R0 = Vsop87.ln_calc_series(Radius.mercury_radius_r0, t);
        double R1 = Vsop87.ln_calc_series(Radius.mercury_radius_r1, t);
        double R2 = Vsop87.ln_calc_series(Radius.mercury_radius_r2, t);
        double R3 = Vsop87.ln_calc_series(Radius.mercury_radius_r3, t);
        double R4 = Vsop87.ln_calc_series(Radius.mercury_radius_r4, t);
        double R5 = Vsop87.ln_calc_series(Radius.mercury_radius_r5, t);
        position.R = R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5;
        position.L = Utility.ln_rad_to_deg(position.L);
        position.B = Utility.ln_rad_to_deg(position.B);
        position.L = Utility.ln_range_degrees(position.L);
        Vsop87.ln_vsop87_to_fk5(position, JD);
        cJD = JD;
        cL = position.L;
        cB = position.B;
        cR = position.R;
    }

    public static double ln_get_mercury_earth_dist(double JD) {
        LnHelioPosn h_mercury = new LnHelioPosn();
        LnHelioPosn h_earth = new LnHelioPosn();
        LnRectPosn g_mercury = new LnRectPosn();
        LnRectPosn g_earth = new LnRectPosn();
        Mercury.ln_get_mercury_helio_coords(JD, h_mercury);
        Earth.ln_get_earth_helio_coords(JD, h_earth);
        Transform.ln_get_rect_from_helio(h_mercury, g_mercury);
        Transform.ln_get_rect_from_helio(h_earth, g_earth);
        double x = g_mercury.X - g_earth.X;
        double y = g_mercury.Y - g_earth.Y;
        double z = g_mercury.Z - g_earth.Z;
        x *= x;
        y *= y;
        z *= z;
        return Math.sqrt(x + y + z);
    }

    public static double ln_get_mercury_solar_dist(double JD) {
        LnHelioPosn h_mercury = new LnHelioPosn();
        Mercury.ln_get_mercury_helio_coords(JD, h_mercury);
        return h_mercury.R;
    }

    public static double ln_get_mercury_magnitude(double JD) {
        double r = Mercury.ln_get_mercury_solar_dist(JD);
        double delta = Mercury.ln_get_mercury_earth_dist(JD);
        double i = Mercury.ln_get_mercury_phase(JD);
        double i2 = i * i;
        double i3 = i2 * i;
        return -0.42 + 5.0 * Math.log10(r * delta) + 0.038 * i - 2.73E-4 * i2 + 2.0E-6 * i3;
    }

    public static double ln_get_mercury_disk(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Mercury.ln_get_mercury_solar_dist(JD);
        double delta = Mercury.ln_get_mercury_earth_dist(JD);
        return ((r + delta) * (r + delta) - R * R) / (4.0 * r * delta);
    }

    public static double ln_get_mercury_phase(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Mercury.ln_get_mercury_solar_dist(JD);
        double delta = Mercury.ln_get_mercury_earth_dist(JD);
        double i = (r * r + delta * delta - R * R) / (2.0 * r * delta);
        i = Math.acos(i);
        return Utility.ln_rad_to_deg(i);
    }

    public static int ln_get_mercury_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Mercury.ln_get_mercury_equ_coords(JD, position);
            }
        }, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static double ln_get_mercury_sdiam(double JD) {
        double So = 3.36;
        double dist = Mercury.ln_get_mercury_earth_dist(JD);
        return So / dist;
    }

    public static void ln_get_mercury_rect_helio(double JD, LnRectPosn position) {
        LnHelioPosn mercury = new LnHelioPosn();
        Mercury.ln_get_mercury_helio_coords(JD, mercury);
        Transform.ln_get_rect_from_helio(mercury, position);
    }

    static class Radius {
        private static Vsop87.LnVsop[] mercury_radius_r0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.39528271651, 0.0, 0.0), new Vsop87.LnVsop(0.07834131818, 6.19233722598, 26087.9031415742), new Vsop87.LnVsop(0.00795525558, 2.95989690104, 52175.8062831484), new Vsop87.LnVsop(0.00121281764, 6.01064153797, 78263.70942472259), new Vsop87.LnVsop(2.1921969E-4, 2.77820093972, 104351.61256629678), new Vsop87.LnVsop(4.354065E-5, 5.82894543774, 130439.51570787099), new Vsop87.LnVsop(9.18228E-6, 2.59650562845, 156527.41884944518), new Vsop87.LnVsop(2.60033E-6, 3.02817753901, 27197.2816936676), new Vsop87.LnVsop(2.89955E-6, 1.42441937278, 25028.521211385), new Vsop87.LnVsop(2.01855E-6, 5.64725040577, 182615.3219910194), new Vsop87.LnVsop(2.01498E-6, 5.59227727403, 31749.2351907264), new Vsop87.LnVsop(1.4198E-6, 6.25264206514, 24978.5245894808), new Vsop87.LnVsop(1.00144E-6, 3.73435615066, 21535.9496445154), new Vsop87.LnVsop(7.7561E-7, 3.66972523786, 20426.571092422), new Vsop87.LnVsop(6.3277E-7, 4.29905566028, 25558.2121764796), new Vsop87.LnVsop(6.2951E-7, 4.76588960835, 1059.3819301892), new Vsop87.LnVsop(6.6753E-7, 2.52520325806, 5661.3320491522), new Vsop87.LnVsop(7.55E-7, 4.47428643135, 51116.4243529592), new Vsop87.LnVsop(4.8265E-7, 6.06824353565, 53285.1848352418), new Vsop87.LnVsop(4.5748E-7, 2.41480951848, 208703.2251325936), new Vsop87.LnVsop(3.5224E-7, 1.05917819542, 27043.5028831828), new Vsop87.LnVsop(4.0815E-7, 2.35882025197, 57837.1383323006), new Vsop87.LnVsop(4.4235E-7, 1.21957279824, 15874.6175953632), new Vsop87.LnVsop(3.3873E-7, 0.86381554218, 25661.3049506982), new Vsop87.LnVsop(3.7203E-7, 0.51733923686, 47623.8527860896), new Vsop87.LnVsop(3.0092E-7, 1.79500457353, 37410.5672398786), new Vsop87.LnVsop(2.8417E-7, 3.02063623857, 51066.427731055), new Vsop87.LnVsop(3.0903E-7, 0.88366672292, 24498.8302462904), new Vsop87.LnVsop(2.6105E-7, 2.15021962878, 39609.6545831656), new Vsop87.LnVsop(1.8699E-7, 4.96496134509, 11322.6640983044), new Vsop87.LnVsop(2.127E-7, 5.36857147632, 13521.7514415914), new Vsop87.LnVsop(1.9422E-7, 4.98378705281, 10213.285546211), new Vsop87.LnVsop(1.6941E-7, 3.8876429506, 26617.5941066688), new Vsop87.LnVsop(1.5109E-7, 0.44510551618, 46514.4742339962), new Vsop87.LnVsop(1.7087E-7, 1.24077744063, 77204.32749453338), new Vsop87.LnVsop(1.394E-7, 1.62574000931, 27147.28507176339), new Vsop87.LnVsop(1.3383E-7, 1.07656603755, 51646.11531805379), new Vsop87.LnVsop(1.5011E-7, 4.28173416255, 41962.5207369374), new Vsop87.LnVsop(1.3977E-7, 4.77056852962, 33326.5787331742), new Vsop87.LnVsop(1.2794E-7, 6.06436868672, 1109.3785520934), new Vsop87.LnVsop(1.3938E-7, 1.99984923769, 25132.3033999656), new Vsop87.LnVsop(1.6297E-7, 2.63293566917, 19804.8272915828), new Vsop87.LnVsop(1.1932E-7, 2.36500445252, 4551.9534970588), new Vsop87.LnVsop(1.0612E-7, 5.46555459994, 234791.12827416777), new Vsop87.LnVsop(1.2754E-7, 2.0761125081, 529.6909650946), new Vsop87.LnVsop(1.2068E-7, 2.84997457341, 79373.087976816), new Vsop87.LnVsop(9.069E-8, 1.21263578152, 14765.2390432698), new Vsop87.LnVsop(9.491E-8, 0.83697019037, 12566.1516999828), new Vsop87.LnVsop(9.38E-8, 5.41195321678, 83925.0414738748), new Vsop87.LnVsop(7.499E-8, 2.44636675464, 30639.856638633), new Vsop87.LnVsop(7.463E-8, 5.53233826081, 32858.61374281979), new Vsop87.LnVsop(7.216E-8, 1.17101761775, 16983.9961474566), new Vsop87.LnVsop(8.492E-8, 3.56622963752, 73711.75592766379), new Vsop87.LnVsop(7.109E-8, 5.32625250539, 426.598190876), new Vsop87.LnVsop(6.862E-8, 1.82314316379, 36301.18868778519), new Vsop87.LnVsop(6.561E-8, 4.27817269714, 43071.8992890308), new Vsop87.LnVsop(8.853E-8, 3.87737929181, 50586.73338786459), new Vsop87.LnVsop(6.885E-8, 5.31108684461, 1589.0728952838), new Vsop87.LnVsop(5.943E-8, 4.06893169924, 53131.406024757), new Vsop87.LnVsop(7.653E-8, 3.91505034455, 51749.20809227239), new Vsop87.LnVsop(6.46E-8, 6.0712744861, 77154.33087262919), new Vsop87.LnVsop(5.415E-8, 5.20028106936, 65697.55772473979), new Vsop87.LnVsop(5.185E-8, 3.56743230013, 6283.0758499914), new Vsop87.LnVsop(4.091E-8, 3.67594128543, 22645.32819660879), new Vsop87.LnVsop(4.075E-8, 4.29142103675, 103292.23063610759), new Vsop87.LnVsop(4.429E-8, 5.69109395363, 45892.73043315699), new Vsop87.LnVsop(3.426E-8, 0.64910747902, 52705.49724824299), new Vsop87.LnVsop(3.353E-8, 3.49344693925, 72602.37737557039), new Vsop87.LnVsop(4.12E-8, 1.65386304528, 25448.00585526019), new Vsop87.LnVsop(3.261E-8, 1.03196144437, 68050.42387851159), new Vsop87.LnVsop(3.278E-8, 3.13863996522, 25874.6040461362), new Vsop87.LnVsop(3.054E-8, 4.12577608597, 77734.01845962799), new Vsop87.LnVsop(3.614E-8, 2.95861574665, 28306.66024576099), new Vsop87.LnVsop(2.819E-8, 4.62629009218, 18849.2275499742), new Vsop87.LnVsop(2.746E-8, 4.6788057805, 53235.18821333759), new Vsop87.LnVsop(2.713E-8, 3.56874904332, 26068.2333806744), new Vsop87.LnVsop(2.507E-8, 2.23312082053, 260879.03141574195), new Vsop87.LnVsop(3.044E-8, 5.90613444962, 105460.99111839019), new Vsop87.LnVsop(2.755E-8, 5.67587076777, 26107.57290247399), new Vsop87.LnVsop(2.267E-8, 2.17941292895, 110012.94461544899), new Vsop87.LnVsop(2.274E-8, 0.50174174314, 32370.9789915656), new Vsop87.LnVsop(2.742E-8, 4.75428269919, 63498.47038145279), new Vsop87.LnVsop(2.792E-8, 5.05148755419, 51220.20654153979), new Vsop87.LnVsop(2.557E-8, 2.95114104952, 26080.78959457339), new Vsop87.LnVsop(2.134E-8, 0.84627422908, 76674.63652943878), new Vsop87.LnVsop(1.971E-8, 0.47406458592, 48733.23133818299), new Vsop87.LnVsop(1.965E-8, 1.37420609579, 7238.6755916), new Vsop87.LnVsop(2.527E-8, 0.3453175267, 23969.1392811958), new Vsop87.LnVsop(2.022E-8, 0.33828427611, 99799.65906923798), new Vsop87.LnVsop(1.871E-8, 3.93046887107, 38654.05484155699), new Vsop87.LnVsop(1.873E-8, 0.69327419506, 26091.7844769322), new Vsop87.LnVsop(1.945E-8, 2.3738400031, 6770.7106012456), new Vsop87.LnVsop(1.863E-8, 2.26591746342, 26084.0218062162), new Vsop87.LnVsop(1.751E-8, 5.50651542385, 56727.7597802072), new Vsop87.LnVsop(1.971E-8, 3.77456264986, 19317.1925403286), new Vsop87.LnVsop(1.672E-8, 2.15275736737, 26514.5013324502), new Vsop87.LnVsop(1.703E-8, 4.28966171001, 40853.142184844), new Vsop87.LnVsop(1.657E-8, 4.98018779294, 9103.9069941176), new Vsop87.LnVsop(2.084E-8, 2.1942739348, 26301.2022370122), new Vsop87.LnVsop(1.818E-8, 4.20870875697, 25938.3399444396), new Vsop87.LnVsop(1.78E-8, 0.91702886288, 79219.3091663312), new Vsop87.LnVsop(1.525E-8, 2.15720853496, 27676.976036858), new Vsop87.LnVsop(1.533E-8, 1.54508616302, 955.5997416086), new Vsop87.LnVsop(1.614E-8, 1.27565064366, 25035.6347583858), new Vsop87.LnVsop(1.743E-8, 0.68269075458, 77837.11123384659), new Vsop87.LnVsop(1.389E-8, 4.85102187945, 62389.09182935939), new Vsop87.LnVsop(1.436E-8, 0.05742724582, 23869.1460373874), new Vsop87.LnVsop(1.563E-8, 5.84795328174, 26095.016688575), new Vsop87.LnVsop(1.64E-8, 4.66281344802, 25021.4076643842), new Vsop87.LnVsop(1.552E-8, 2.83910652908, 103242.2340142034), new Vsop87.LnVsop(1.249E-8, 1.97225258222, 91785.46086631398), new Vsop87.LnVsop(1.16E-8, 1.73111584811, 38519.945791972), new Vsop87.LnVsop(1.005E-8, 1.0589829887, 129380.13377768178), new Vsop87.LnVsop(1.041E-8, 2.7803460628, 213.299095438), new Vsop87.LnVsop(1.105E-8, 4.55512255263, 26011.6370702986), new Vsop87.LnVsop(9.79E-9, 2.43870368161, 71980.63357473118), new Vsop87.LnVsop(8.53E-9, 0.56324665532, 20760.4270331914), new Vsop87.LnVsop(8.74E-9, 4.53679289793, 639.897286314), new Vsop87.LnVsop(7.83E-9, 3.69765164671, 78793.40038981718), new Vsop87.LnVsop(7.72E-9, 4.08714779937, 94138.32702008578), new Vsop87.LnVsop(7.97E-9, 0.26237404367, 98690.28051714458), new Vsop87.LnVsop(9.65E-9, 4.70783027902, 51535.90899683439), new Vsop87.LnVsop(9.52E-9, 2.53602802805, 29530.4780865396), new Vsop87.LnVsop(7.73E-9, 2.67894491727, 131548.89425996438), new Vsop87.LnVsop(7.34E-9, 0.89231112796, 103821.92160120218), new Vsop87.LnVsop(6.68E-9, 3.73107901174, 46848.3301747656), new Vsop87.LnVsop(8.28E-9, 2.88184295232, 19406.6782881746), new Vsop87.LnVsop(6.22E-9, 1.05579834092, 59414.4818747484), new Vsop87.LnVsop(6.76E-9, 4.50351834122, 25934.1243310894), new Vsop87.LnVsop(6.02E-9, 5.2839897868, 286966.9345573162), new Vsop87.LnVsop(6.19E-9, 1.44855125892, 79323.09135491178), new Vsop87.LnVsop(6.92E-9, 6.19755283456, 51962.5071877104), new Vsop87.LnVsop(5.63E-9, 5.22994157011, 136100.84775702318), new Vsop87.LnVsop(7.82E-9, 3.2525581452, 50057.04242277), new Vsop87.LnVsop(5.51E-9, 0.33643935436, 52156.1365222486), new Vsop87.LnVsop(7.05E-9, 4.73700316767, 26241.681952059), new Vsop87.LnVsop(5.77E-9, 5.85652683859, 2118.7638603784), new Vsop87.LnVsop(5.17E-9, 3.9320422628, 102762.53967101299), new Vsop87.LnVsop(6.35E-9, 4.87720835087, 12432.0426503978), new Vsop87.LnVsop(6.35E-9, 1.81903768364, 77308.10968311399), new Vsop87.LnVsop(5.43E-9, 1.40877750421, 44937.1306915484), new Vsop87.LnVsop(5.57E-9, 5.44313297566, 85034.42002596818), new Vsop87.LnVsop(4.97E-9, 3.3900024624, 125887.56221081219), new Vsop87.LnVsop(5.46E-9, 4.7799315562, 22747.2907148744), new Vsop87.LnVsop(5.2E-9, 6.00160827202, 52168.69273614759), new Vsop87.LnVsop(4.63E-9, 3.67555016973, 25668.418497699), new Vsop87.LnVsop(4.52E-9, 3.53009642496, 58458.88213313979), new Vsop87.LnVsop(4.74E-9, 5.94337109404, 54394.56338733519), new Vsop87.LnVsop(5.59E-9, 2.44355298288, 52195.47604404819), new Vsop87.LnVsop(4.18E-9, 3.73372056542, 103925.01437542078), new Vsop87.LnVsop(3.97E-9, 0.69015519657, 64741.95798313119), new Vsop87.LnVsop(5.11E-9, 5.88239871682, 45494.58142974879), new Vsop87.LnVsop(4.13E-9, 2.2675482175, 82815.66292178139), new Vsop87.LnVsop(4.25E-9, 5.24513787195, 52389.1053785864), new Vsop87.LnVsop(4.82E-9, 0.98163319354, 25654.19140369739), new Vsop87.LnVsop(3.8E-9, 3.74414053506, 52179.6876185064), new Vsop87.LnVsop(3.59E-9, 5.50961175081, 26555.8681319286), new Vsop87.LnVsop(3.75E-9, 1.97919633246, 149.5631971346), new Vsop87.LnVsop(3.85E-9, 5.88994556216, 129330.13715577759), new Vsop87.LnVsop(3.48E-9, 4.91062953335, 1052.2683831884), new Vsop87.LnVsop(4.18E-9, 4.32915399414, 51123.53789995999), new Vsop87.LnVsop(4.25E-9, 1.43228900858, 51109.31080595839), new Vsop87.LnVsop(4.64E-9, 3.98651795995, 105307.21230790539), new Vsop87.LnVsop(3.28E-9, 5.20638855699, 52602.4044740244), new Vsop87.LnVsop(3.54E-9, 1.04382219765, 66941.04532641819), new Vsop87.LnVsop(3.24E-9, 1.6297255389, 88476.99497093359), new Vsop87.LnVsop(3.78E-9, 5.31677687871, 52171.9249477904), new Vsop87.LnVsop(4.4E-9, 1.46388471692, 89586.37352302698), new Vsop87.LnVsop(3.55E-9, 1.52732345644, 1066.49547719), new Vsop87.LnVsop(3.02E-9, 5.21118830274, 53764.8791784322), new Vsop87.LnVsop(3.01E-9, 5.02488469326, 117873.36400788819), new Vsop87.LnVsop(3.51E-9, 2.00433655367, 24395.7374720718), new Vsop87.LnVsop(2.89E-9, 6.19161795579, 26094.53170047421), new Vsop87.LnVsop(2.86E-9, 3.77109546265, 7.1135470008), new Vsop87.LnVsop(2.83E-9, 3.10942945865, 49957.0491789616), new Vsop87.LnVsop(3.85E-9, 2.47186185031, 25234.70675982219), new Vsop87.LnVsop(3.82E-9, 0.97683948367, 52026.2430860138), new Vsop87.LnVsop(2.71E-9, 5.74773027334, 25455.119402261), new Vsop87.LnVsop(2.68E-9, 2.86400819938, 80482.46652890938), new Vsop87.LnVsop(3.75E-9, 0.55193410863, 45405.0956819028), new Vsop87.LnVsop(3.05E-9, 6.00195610387, 2218.7571041868), new Vsop87.LnVsop(2.59E-9, 1.82926086584, 24505.94379329119), new Vsop87.LnVsop(2.51E-9, 4.10979366326, 155468.036919256), new Vsop87.LnVsop(2.89E-9, 3.05374038036, 26081.27458267419), new Vsop87.LnVsop(2.42E-9, 5.05513759189, 42153.969003049), new Vsop87.LnVsop(2.44E-9, 2.15545293562, 3442.5749449654), new Vsop87.LnVsop(3.15E-9, 2.61615796784, 52182.9198301492), new Vsop87.LnVsop(2.56E-9, 3.71118385343, 25619.9381512198), new Vsop87.LnVsop(2.32E-9, 2.21574125599, 16066.0658614748), new Vsop87.LnVsop(2.33E-9, 5.49032532532, 98068.53671630539), new Vsop87.LnVsop(2.36E-9, 4.08613786149, 26013.1215430069), new Vsop87.LnVsop(2.25E-9, 0.44436388903, 76144.94556434419), new Vsop87.LnVsop(2.42E-9, 3.29840670592, 6681.2248533996), new Vsop87.LnVsop(2.27E-9, 1.6324118325, 76.2660712756), new Vsop87.LnVsop(2.68E-9, 1.09036981144, 18093.37469954999), new Vsop87.LnVsop(2.55E-9, 4.20620893175, 44181.27784112419), new Vsop87.LnVsop(2.05E-9, 1.00335777675, 26190.99591579279), new Vsop87.LnVsop(2.28E-9, 1.46077026379, 77623.81213840858), new Vsop87.LnVsop(1.98E-9, 1.36691766564, 26727.8004278882), new Vsop87.LnVsop(2.59E-9, 1.28277618444, 13655.8604911764), new Vsop87.LnVsop(1.96E-9, 5.73310610578, 157636.79740153858), new Vsop87.LnVsop(1.96E-9, 0.0660256375, 40565.2543247742), new Vsop87.LnVsop(1.87E-9, 0.86191776388, 120226.23016165999), new Vsop87.LnVsop(2.62E-9, 4.14849890829, 24491.71669928959), new Vsop87.LnVsop(2.44E-9, 4.14398143655, 95247.70557217918), new Vsop87.LnVsop(2.32E-9, 5.4514220448, 33967.99229491319), new Vsop87.LnVsop(2.06E-9, 5.59194625667, 55618.3812281138), new Vsop87.LnVsop(2.03E-9, 1.6421286418, 58946.51688439399), new Vsop87.LnVsop(1.88E-9, 0.46231923609, 104881.30353139139), new Vsop87.LnVsop(1.92E-9, 1.82885117119, 25551.09862947879), new Vsop87.LnVsop(2.0E-9, 1.81390254289, 25863.55834587229), new Vsop87.LnVsop(1.91E-9, 5.57416790284, 5327.4761083828), new Vsop87.LnVsop(1.95E-9, 3.31299278224, 124778.18365871879), new Vsop87.LnVsop(1.69E-9, 1.69377804998, 90695.75207512038), new Vsop87.LnVsop(2.26E-9, 1.32358533633, 52099.5402118728), new Vsop87.LnVsop(1.77E-9, 3.29597559078, 25131.61398560359), new Vsop87.LnVsop(1.78E-9, 2.54736101162, 26720.68688088739), new Vsop87.LnVsop(1.67E-9, 3.61985108387, 23754.70674870219), new Vsop87.LnVsop(1.59E-9, 3.48407918441, 25977.69682035479), new Vsop87.LnVsop(1.8E-9, 3.94244458655, 129909.82474277639), new Vsop87.LnVsop(1.5E-9, 5.20173167043, 69159.80243060499), new Vsop87.LnVsop(1.66E-9, 0.40324154213, 100909.03762133139), new Vsop87.LnVsop(1.75E-9, 2.97505263315, 24925.4284371664), new Vsop87.LnVsop(1.54E-9, 1.27150748229, 25984.8103673556), new Vsop87.LnVsop(1.44E-9, 1.89329933647, 64607.84893354619), new Vsop87.LnVsop(1.45E-9, 2.05406539484, 313054.83769889036), new Vsop87.LnVsop(1.52E-9, 4.87194855231, 103396.01282468818), new Vsop87.LnVsop(1.37E-9, 3.86916799978, 24609.0365675098), new Vsop87.LnVsop(1.41E-9, 1.99766374692, 162188.75089859738), new Vsop87.LnVsop(1.84E-9, 6.09994107476, 23439.44831610119), new Vsop87.LnVsop(1.35E-9, 1.27330433084, 52022.0274726636), new Vsop87.LnVsop(1.27E-9, 0.70493065203, 128850.44281258718), new Vsop87.LnVsop(1.42E-9, 1.50690527956, 52329.58509363319), new Vsop87.LnVsop(1.26E-9, 2.70570221163, 28206.6670019526), new Vsop87.LnVsop(1.23E-9, 0.15653071499, 151975.46535238638), new Vsop87.LnVsop(1.26E-9, 1.61974134336, 48835.19385644859), new Vsop87.LnVsop(1.37E-9, 1.77314956898, 35191.8101356918), new Vsop87.LnVsop(1.47E-9, 4.5031207866, 105410.99449648599), new Vsop87.LnVsop(1.25E-9, 3.38986540694, 78244.0396638228), new Vsop87.LnVsop(1.19E-9, 2.77647833951, 78256.59587772179), new Vsop87.LnVsop(1.56E-9, 2.96636712768, 78050.41032928458), new Vsop87.LnVsop(1.45E-9, 1.35549047802, 3340.6124266998), new Vsop87.LnVsop(1.26E-9, 3.97012413964, 29428.515568274), new Vsop87.LnVsop(1.28E-9, 5.41920055502, 26162.6847401415), new Vsop87.LnVsop(1.1E-9, 3.87981560343, 85502.38501632259), new Vsop87.LnVsop(1.27E-9, 5.49693348651, 78283.37918562238), new Vsop87.LnVsop(1.32E-9, 4.86941737016, 24712.1293417284), new Vsop87.LnVsop(1.26E-9, 0.94880137, 121335.60871375339), new Vsop87.LnVsop(1.29E-9, 4.00700268674, 72936.23331633979), new Vsop87.LnVsop(1.02E-9, 0.50512246193, 130012.91751699499), new Vsop87.LnVsop(1.04E-9, 0.29867566906, 84546.78527471398), new Vsop87.LnVsop(1.18E-9, 0.76546423413, 131395.11544947958), new Vsop87.LnVsop(1.2E-9, 4.45274824615, 71025.0338331226), new Vsop87.LnVsop(1.17E-9, 3.31815509821, 25771.5112719176), new Vsop87.LnVsop(1.1E-9, 2.63255540457, 71582.48457132299), new Vsop87.LnVsop(9.7E-10, 2.66123209192, 155418.04029735178), new Vsop87.LnVsop(1.13E-9, 5.88929318039, 26404.2950112308), new Vsop87.LnVsop(9.8E-10, 2.01482697693, 78477.00852016058), new Vsop87.LnVsop(1.03E-9, 0.46436247195, 51756.3216392732), new Vsop87.LnVsop(9.3E-10, 2.37413256663, 419.4846438752), new Vsop87.LnVsop(1.25E-9, 1.88182927035, 26610.48055966799), new Vsop87.LnVsop(9.6E-10, 0.34531574235, 26507.38778544939), new Vsop87.LnVsop(9.3E-10, 3.80384593339, 26037.90651966999), new Vsop87.LnVsop(9.1E-10, 2.63070786684, 28421.0995344462), new Vsop87.LnVsop(1.01E-9, 5.21013194641, 433.7117378768), new Vsop87.LnVsop(9.6E-10, 4.47740402596, 77197.21394753258), new Vsop87.LnVsop(1.08E-9, 4.03687459562, 51742.09454527159), new Vsop87.LnVsop(8.6E-10, 5.14042481496, 26237.46633870879), new Vsop87.LnVsop(9.2E-10, 3.74350464437, 90829.86112470538), new Vsop87.LnVsop(8.6E-10, 1.86284853445, 27140.17152476259), new Vsop87.LnVsop(1.02E-9, 5.41450550369, 26137.8997634784), new Vsop87.LnVsop(8.6E-10, 4.01669468413, 10021.8372800994), new Vsop87.LnVsop(1.0E-9, 5.32148635395, 108903.56606335558), new Vsop87.LnVsop(7.9E-10, 4.68110092612, 27154.3986187642), new Vsop87.LnVsop(9.2E-10, 5.52113044538, 51322.60990139639), new Vsop87.LnVsop(7.8E-10, 2.87936468013, 29416.03879785439), new Vsop87.LnVsop(9.2E-10, 4.20287352869, 38813.3565763492), new Vsop87.LnVsop(9.5E-10, 4.44016161131, 115674.27666460119), new Vsop87.LnVsop(1.04E-9, 5.05012283418, 50483.640613646), new Vsop87.LnVsop(7.5E-10, 1.78913882745, 143961.2671494624), new Vsop87.LnVsop(8.6E-10, 0.51446096218, 78267.59076008058), new Vsop87.LnVsop(7.8E-10, 4.66703507622, 114564.89811250778), new Vsop87.LnVsop(7.8E-10, 4.2015476101, 1692.1656695024), new Vsop87.LnVsop(8.6E-10, 4.03049198821, 78114.14622758799), new Vsop87.LnVsop(7.3E-10, 2.27348914847, 52643.7712735028), new Vsop87.LnVsop(8.2E-10, 3.73527269254, 853.196381752), new Vsop87.LnVsop(7.1E-10, 4.89150234067, 50593.84693486539), new Vsop87.LnVsop(8.2E-10, 5.22634268892, 27999.1026247914), new Vsop87.LnVsop(9.3E-10, 1.09574629454, 77211.44104153418), new Vsop87.LnVsop(7.4E-10, 1.97836913639, 78690.30761559859), new Vsop87.LnVsop(8.1E-10, 3.59541157741, 71492.99882347698), new Vsop87.LnVsop(8.4E-10, 3.12386155848, 14477.3511832), new Vsop87.LnVsop(8.3E-10, 4.10338349247, 93028.94846799239), new Vsop87.LnVsop(6.7E-10, 0.24252839986, 66653.15746634839), new Vsop87.LnVsop(7.4E-10, 5.66943570493, 78270.82297172339), new Vsop87.LnVsop(6.8E-10, 1.98243672712, 79852.78232000639), new Vsop87.LnVsop(6.4E-10, 6.15939675587, 76044.9523205358), new Vsop87.LnVsop(6.4E-10, 5.54602351082, 25764.39772491679), new Vsop87.LnVsop(6.6E-10, 2.28176331469, 7880.08915333899), new Vsop87.LnVsop(8.7E-10, 1.76987117922, 25440.89230825939), new Vsop87.LnVsop(7.3E-10, 2.0623678663, 111122.32316754239), new Vsop87.LnVsop(7.8E-10, 0.4039575432, 49842.60989027639), new Vsop87.LnVsop(7.6E-10, 2.65569010126, 34282.1784747828), new Vsop87.LnVsop(6.4E-10, 0.87551506766, 181555.94006083018), new Vsop87.LnVsop(8.6E-10, 2.08720558248, 78259.82808936459), new Vsop87.LnVsop(7.4E-10, 0.86495417245, 50579.61984086379), new Vsop87.LnVsop(8.2E-10, 1.0290841513, 74821.13447975718), new Vsop87.LnVsop(6.2E-10, 0.94022411884, 25344.9130810416), new Vsop87.LnVsop(5.9E-10, 2.45671910437, 51543.0225438352), new Vsop87.LnVsop(5.8E-10, 2.95861307962, 52182.4348420484), new Vsop87.LnVsop(5.8E-10, 4.20403945192, 96357.08412427259), new Vsop87.LnVsop(6.1E-10, 2.82454009227, 26202.34243025941), new Vsop87.LnVsop(5.7E-10, 2.27669644556, 124156.43985787958), new Vsop87.LnVsop(5.7E-10, 4.37128574888, 1581.959348283), new Vsop87.LnVsop(5.5E-10, 0.13527477543, 25973.46385288896), new Vsop87.LnVsop(5.4E-10, 4.79282641675, 26164.1692128498), new Vsop87.LnVsop(5.4E-10, 3.05808651891, 25565.3257234804), new Vsop87.LnVsop(5.5E-10, 4.51468564617, 103711.71527998279), new Vsop87.LnVsop(5.4E-10, 3.87184860299, 18207.81398823521), new Vsop87.LnVsop(5.3E-10, 4.32466503961, 70269.18098269838), new Vsop87.LnVsop(5.4E-10, 4.6237074606, 25881.717593137), new Vsop87.LnVsop(5.0E-10, 2.50076265786, 183724.7005431128), new Vsop87.LnVsop(5.8E-10, 2.0619977727, 1596.1864422846), new Vsop87.LnVsop(6.5E-10, 5.2021824139, 26294.08869001139), new Vsop87.LnVsop(4.7E-10, 0.85032665275, 52101.02468458109), new Vsop87.LnVsop(5.8E-10, 1.43376641232, 23866.04650697719), new Vsop87.LnVsop(4.8E-10, 2.35325985848, 81706.28436968799), new Vsop87.LnVsop(5.2E-10, 0.18584318278, 92741.06060792258), new Vsop87.LnVsop(5.3E-10, 0.58740318705, 26624.70765366959), new Vsop87.LnVsop(6.1E-10, 2.61531397472, 49527.35145767539), new Vsop87.LnVsop(4.7E-10, 3.88425610956, 146314.13330323418), new Vsop87.LnVsop(4.9E-10, 6.2023817712, 32769.1279949738), new Vsop87.LnVsop(5.3E-10, 4.37477924787, 78187.44335344699), new Vsop87.LnVsop(4.8E-10, 5.97927376895, 51013.33157874059), new Vsop87.LnVsop(4.8E-10, 3.8387106184, 102232.84870591838), new Vsop87.LnVsop(4.9E-10, 5.05465236114, 7994.5284420242), new Vsop87.LnVsop(4.4E-10, 5.42834161209, 86143.79857806159), new Vsop87.LnVsop(5.8E-10, 3.8051592617, 99024.13645791399), new Vsop87.LnVsop(4.4E-10, 4.02940505346, 147423.51185532758), new Vsop87.LnVsop(5.8E-10, 6.09754644524, 52169.17772424839), new Vsop87.LnVsop(4.2E-10, 4.38821594604, 224.3447957019), new Vsop87.LnVsop(4.9E-10, 0.46999643208, 51707.84129279399), new Vsop87.LnVsop(4.2E-10, 1.57834095767, 23976.2528281966), new Vsop87.LnVsop(4.0E-10, 4.41732729204, 52815.7035694624), new Vsop87.LnVsop(4.6E-10, 3.51899431806, 130969.20667296558), new Vsop87.LnVsop(4.5E-10, 4.35498866833, 39743.7636327506), new Vsop87.LnVsop(4.9E-10, 0.90018634051, 632.7837393132), new Vsop87.LnVsop(4.4E-10, 0.77931638287, 25138.7275326044), new Vsop87.LnVsop(4.0E-10, 4.04800595628, 52278.89905736699), new Vsop87.LnVsop(3.8E-10, 0.62728056271, 50696.93970908399), new Vsop87.LnVsop(3.8E-10, 2.90143761999, 956.2891559706), new Vsop87.LnVsop(4.0E-10, 1.64469334161, 39629.32434406539), new Vsop87.LnVsop(4.3E-10, 0.11284697031, 2648.454825473), new Vsop87.LnVsop(4.2E-10, 2.74307947693, 24079.34560241519), new Vsop87.LnVsop(5.1E-10, 1.57638194838, 12725.453434775), new Vsop87.LnVsop(3.6E-10, 5.75260999162, 25867.49049913539), new Vsop87.LnVsop(3.7E-10, 1.62696286674, 129483.91596626239), new Vsop87.LnVsop(4.5E-10, 0.0508156179, 51219.51712717779), new Vsop87.LnVsop(3.5E-10, 0.09890027261, 25241.820306823), new Vsop87.LnVsop(4.9E-10, 0.07684803479, 150866.08680029298), new Vsop87.LnVsop(3.4E-10, 4.55905337378, 536.8045120954), new Vsop87.LnVsop(3.6E-10, 5.60022995084, 52808.59002246159), new Vsop87.LnVsop(3.9E-10, 5.99930414876, 104138.31347085879), new Vsop87.LnVsop(4.6E-10, 0.70705564046, 155997.72788435058), new Vsop87.LnVsop(3.3E-10, 4.5469385168, 78417.48823520739), new Vsop87.LnVsop(3.2E-10, 4.31344005149, 78109.93061423779), new Vsop87.LnVsop(3.6E-10, 5.69791953426, 26049.7701059364), new Vsop87.LnVsop(4.1E-10, 4.93127694524, 51639.00177105299), new Vsop87.LnVsop(3.4E-10, 3.32227109836, 35472.7441496494), new Vsop87.LnVsop(4.2E-10, 4.87062950014, 51951.46148744649), new Vsop87.LnVsop(4.1E-10, 2.3873772831, 68241.8721446232), new Vsop87.LnVsop(3.5E-10, 5.0955233014, 339142.7408404646), new Vsop87.LnVsop(3.3E-10, 3.74742271467, 154938.34595416137), new Vsop87.LnVsop(3.1E-10, 4.31849572821, 52072.71350892979), new Vsop87.LnVsop(3.2E-10, 3.22125075139, 178063.3684939606), new Vsop87.LnVsop(3.5E-10, 5.04239162008, 188276.6540401716), new Vsop87.LnVsop(4.1E-10, 3.2289478662, 1162.4747044078), new Vsop87.LnVsop(3.2E-10, 2.71248623758, 25780.3455206046), new Vsop87.LnVsop(3.2E-10, 3.81071008195, 157483.01859105378), new Vsop87.LnVsop(3.0E-10, 0.37624678251, 26421.7590823436), new Vsop87.LnVsop(3.0E-10, 2.31384665804, 1478.8665740644), new Vsop87.LnVsop(3.1E-10, 6.02113204508, 26198.1094627936), new Vsop87.LnVsop(4.0E-10, 1.02062201314, 27819.0254945068), new Vsop87.LnVsop(2.9E-10, 2.67809374172, 110.2063212194), new Vsop87.LnVsop(2.9E-10, 5.82834696468, 104344.49901929598), new Vsop87.LnVsop(3.0E-10, 2.25771223167, 104371.28232719658), new Vsop87.LnVsop(2.8E-10, 4.63556053618, 74923.09699802278), new Vsop87.LnVsop(3.7E-10, 3.03820461285, 11610.5519583742), new Vsop87.LnVsop(3.0E-10, 1.32768749762, 1375.7737998458), new Vsop87.LnVsop(3.2E-10, 0.26646287192, 52065.59996192899), new Vsop87.LnVsop(3.7E-10, 1.25738019637, 131498.89763806018), new Vsop87.LnVsop(3.2E-10, 1.04692878427, 26086.4186688659), new Vsop87.LnVsop(3.6E-10, 1.63924791422, 50800.03248330259), new Vsop87.LnVsop(3.0E-10, 0.15547655101, 104331.94280539699), new Vsop87.LnVsop(2.6E-10, 0.02869654675, 24815.222115947), new Vsop87.LnVsop(2.6E-10, 1.03051070102, 24292.64469785319), new Vsop87.LnVsop(2.7E-10, 0.60357942596, 111590.2881578968), new Vsop87.LnVsop(2.6E-10, 5.74760347398, 54294.57014352679), new Vsop87.LnVsop(3.1E-10, 3.35995297387, 126996.94076290558), new Vsop87.LnVsop(2.6E-10, 2.79980619229, 86457.98475793119), new Vsop87.LnVsop(2.5E-10, 3.5550722778, 156100.82065856917), new Vsop87.LnVsop(2.5E-10, 2.34197986382, 24601.92302050899), new Vsop87.LnVsop(2.6E-10, 5.71059743781, 97670.38771289718), new Vsop87.LnVsop(3.3E-10, 0.24573646815, 26395.46076254379), new Vsop87.LnVsop(2.5E-10, 5.71438388019, 181505.94343892598), new Vsop87.LnVsop(2.5E-10, 2.19646515906, 52250.5878817157), new Vsop87.LnVsop(2.5E-10, 1.82858587521, 74.7815985673), new Vsop87.LnVsop(2.3E-10, 5.07063706452, 104564.91166173479), new Vsop87.LnVsop(2.3E-10, 6.24119188701, 75615.25459924959), new Vsop87.LnVsop(2.4E-10, 2.04753578861, 26521.614879451), new Vsop87.LnVsop(2.5E-10, 3.35696591423, 28286.9904848612), new Vsop87.LnVsop(2.6E-10, 3.35225659095, 110634.68841628819), new Vsop87.LnVsop(2.8E-10, 0.56562335947, 125112.03959948818), new Vsop87.LnVsop(2.7E-10, 2.39055852898, 522.5774180938), new Vsop87.LnVsop(2.8E-10, 0.24656427036, 103.0927742186), new Vsop87.LnVsop(2.5E-10, 0.14885265829, 22759.76748529401), new Vsop87.LnVsop(3.2E-10, 1.70300856186, 26089.38761428249), new Vsop87.LnVsop(2.5E-10, 4.7248549358, 13362.4497067992), new Vsop87.LnVsop(2.6E-10, 2.07910302219, 29550.14784743939), new Vsop87.LnVsop(2.5E-10, 5.27245546317, 25936.85547173129), new Vsop87.LnVsop(2.4E-10, 0.09057155891, 51859.41441349179), new Vsop87.LnVsop(2.2E-10, 4.15509763801, 24176.703658357), new Vsop87.LnVsop(2.4E-10, 0.80826744274, 77829.99768684579), new Vsop87.LnVsop(3.0E-10, 1.21279872188, 97112.93697469679), new Vsop87.LnVsop(2.3E-10, 2.30729456974, 77410.51304297059), new Vsop87.LnVsop(2.2E-10, 4.82022861734, 13541.42120249119), new Vsop87.LnVsop(2.6E-10, 6.26940339209, 25939.82441714789), new Vsop87.LnVsop(2.3E-10, 2.65745031641, 52492.19815280499), new Vsop87.LnVsop(2.4E-10, 4.93609558838, 52698.38370124219), new Vsop87.LnVsop(2.2E-10, 1.24209358625, 103285.11708910679), new Vsop87.LnVsop(2.2E-10, 0.79086333802, 104202.04936916218), new Vsop87.LnVsop(2.2E-10, 1.95647457585, 24356.7807886416), new Vsop87.LnVsop(2.1E-10, 2.52943432215, 467.9649903544), new Vsop87.LnVsop(2.2E-10, 3.686605763, 26729.31670331319), new Vsop87.LnVsop(2.1E-10, 5.49527500986, 112231.70171963578), new Vsop87.LnVsop(2.3E-10, 1.84999492041, 76571.54375522019), new Vsop87.LnVsop(2.3E-10, 1.18923260859, 141762.17980617538), new Vsop87.LnVsop(2.5E-10, 2.55846756753, 24822.3356629478), new Vsop87.LnVsop(2.7E-10, 3.60550105765, 23962.02573419499), new Vsop87.LnVsop(2.3E-10, 2.60707335355, 25754.0472008048), new Vsop87.LnVsop(2.6E-10, 0.76123293665, 55516.4187098482), new Vsop87.LnVsop(2.6E-10, 2.09701412913, 134991.4692049298), new Vsop87.LnVsop(2.0E-10, 3.35114638284, 52595.29092702359), new Vsop87.LnVsop(2.1E-10, 0.36856325095, 97580.90196505119), new Vsop87.LnVsop(2.1E-10, 5.70555721397, 60055.89543648739), new Vsop87.LnVsop(2.4E-10, 0.51930649617, 116917.76426627958), new Vsop87.LnVsop(1.9E-10, 2.85664849845, 60370.08161635699), new Vsop87.LnVsop(1.9E-10, 0.57202736293, 52125.80966124419), new Vsop87.LnVsop(2.4E-10, 3.51346257561, 77844.22478084739), new Vsop87.LnVsop(1.9E-10, 0.5425864763, 26941.0995233262), new Vsop87.LnVsop(1.9E-10, 6.25208431325, 25973.50403466079), new Vsop87.LnVsop(2.2E-10, 5.1405323692, 104347.73123093879), new Vsop87.LnVsop(2.1E-10, 4.13818325733, 103299.34418310839), new Vsop87.LnVsop(1.9E-10, 0.33672573506, 102018.41617342478), new Vsop87.LnVsop(1.8E-10, 1.90089087831, 52325.36948028299), new Vsop87.LnVsop(1.9E-10, 4.27464346361, 122444.98726584678), new Vsop87.LnVsop(1.9E-10, 5.68003083783, 54509.0026760204), new Vsop87.LnVsop(1.8E-10, 1.43369019964, 53242.3017603384), new Vsop87.LnVsop(1.8E-10, 2.4522868243, 104358.72611329758), new Vsop87.LnVsop(1.8E-10, 1.0679837196, 27780.06881107659), new Vsop87.LnVsop(2.3E-10, 1.86418858933, 116783.65521669458), new Vsop87.LnVsop(2.1E-10, 2.9969911519, 26073.67604757259), new Vsop87.LnVsop(1.8E-10, 4.86636715695, 170049.1702910366), new Vsop87.LnVsop(1.9E-10, 4.89530983995, 53228.07466633679), new Vsop87.LnVsop(2.1E-10, 2.47209635724, 27726.9726587622), new Vsop87.LnVsop(2.0E-10, 4.99224602107, 104778.21075717278), new Vsop87.LnVsop(2.1E-10, 1.47188069923, 140652.80125408198), new Vsop87.LnVsop(2.2E-10, 0.87466972564, 119116.85160956658), new Vsop87.LnVsop(1.7E-10, 4.05072250317, 76667.52298243798), new Vsop87.LnVsop(1.8E-10, 1.69254770146, 76681.75007643958), new Vsop87.LnVsop(1.9E-10, 4.8165373342, 51528.79544983359), new Vsop87.LnVsop(2.3E-10, 2.09581007213, 52225.8029050526), new Vsop87.LnVsop(1.9E-10, 0.74728940617, 36109.7404216736), new Vsop87.LnVsop(1.6E-10, 2.9324165533, 102132.85546210999), new Vsop87.LnVsop(1.8E-10, 5.0047639239, 105940.68546158058), new Vsop87.LnVsop(2.1E-10, 3.53806328767, 106570.36967048359), new Vsop87.LnVsop(1.8E-10, 4.66155601593, 61279.713277266), new Vsop87.LnVsop(2.2E-10, 3.56812851373, 104355.49390165479), new Vsop87.LnVsop(1.9E-10, 4.43774117349, 647.0108333148), new Vsop87.LnVsop(1.7E-10, 2.10545220233, 64901.25971792339), new Vsop87.LnVsop(1.7E-10, 2.83176092494, 132658.27281205778), new Vsop87.LnVsop(1.7E-10, 5.67040223146, 25788.776747305), new Vsop87.LnVsop(1.8E-10, 2.89493956098, 26091.83529483729), new Vsop87.LnVsop(1.7E-10, 5.38147763977, 78731.674415077), new Vsop87.LnVsop(1.5E-10, 5.25853489897, 150244.3429994538), new Vsop87.LnVsop(1.9E-10, 4.36796558291, 24182.4383766338), new Vsop87.LnVsop(1.9E-10, 1.70937445812, 153.7788104848), new Vsop87.LnVsop(1.5E-10, 1.1302968538, 25042.7483053866), new Vsop87.LnVsop(1.5E-10, 2.16455066064, 26222.0121911592), new Vsop87.LnVsop(1.7E-10, 3.97920822146, 207643.8432024044), new Vsop87.LnVsop(1.5E-10, 5.1620479421, 27684.0895838588), new Vsop87.LnVsop(1.6E-10, 5.73885440717, 25352.02662804239), new Vsop87.LnVsop(1.5E-10, 2.31658070939, 51852.30086649099), new Vsop87.LnVsop(1.4E-10, 3.42267011966, 26823.77965510599), new Vsop87.LnVsop(1.4E-10, 2.50300888215, 32132.1317229496), new Vsop87.LnVsop(1.4E-10, 0.64831361219, 323.5054166574), new Vsop87.LnVsop(1.4E-10, 6.07546939857, 78270.3379836226), new Vsop87.LnVsop(1.7E-10, 6.02302146414, 26667.590728573), new Vsop87.LnVsop(1.4E-10, 1.36600630226, 23919.1426592916), new Vsop87.LnVsop(1.9E-10, 4.41224311863, 49953.94964855139), new Vsop87.LnVsop(1.3E-10, 1.32912005824, 129799.61842155698), new Vsop87.LnVsop(1.3E-10, 5.28407417719, 742.9900605326), new Vsop87.LnVsop(1.3E-10, 5.59372980773, 209812.60368468694), new Vsop87.LnVsop(1.4E-10, 1.1738182206, 104275.34649502118), new Vsop87.LnVsop(1.4E-10, 5.53140406603, 77630.92568540938), new Vsop87.LnVsop(1.4E-10, 0.44776281245, 17893.6278083656), new Vsop87.LnVsop(1.8E-10, 1.65347821757, 28256.66362385679), new Vsop87.LnVsop(1.4E-10, 4.81716097174, 2221.856634597), new Vsop87.LnVsop(1.5E-10, 3.17385925198, 176953.98994186718), new Vsop87.LnVsop(1.3E-10, 0.78761204117, 173511.41499690176), new Vsop87.LnVsop(1.4E-10, 2.91486993959, 78257.08086582259), new Vsop87.LnVsop(1.7E-10, 1.98703193197, 27037.07875054399), new Vsop87.LnVsop(1.3E-10, 2.32883100115, 27005.83342755599), new Vsop87.LnVsop(1.4E-10, 3.95960354665, 51432.81622261579), new Vsop87.LnVsop(1.5E-10, 1.32037560412, 27669.86248985719), new Vsop87.LnVsop(1.3E-10, 1.3908661479, 25024.58905812189), new Vsop87.LnVsop(1.3E-10, 3.85817843282, 182085.63102592478), new Vsop87.LnVsop(1.5E-10, 1.99264271696, 52381.99183158559), new Vsop87.LnVsop(1.2E-10, 3.33811921058, 25508.2155545754), new Vsop87.LnVsop(1.6E-10, 5.59174105029, 25446.4895798352), new Vsop87.LnVsop(1.2E-10, 3.96861439229, 78188.92782615528), new Vsop87.LnVsop(1.2E-10, 5.32870101114, 80174.90890793978), new Vsop87.LnVsop(1.6E-10, 2.19148092925, 26308.315784013), new Vsop87.LnVsop(1.2E-10, 5.45614378004, 107794.1875112622), new Vsop87.LnVsop(1.4E-10, 0.70193545832, 172402.0364448084), new Vsop87.LnVsop(1.2E-10, 1.54035928437, 52252.07235442399), new Vsop87.LnVsop(1.4E-10, 3.47280146015, 27177.6119327678), new Vsop87.LnVsop(1.4E-10, 2.70931032077, 27311.72098235281), new Vsop87.LnVsop(1.3E-10, 0.52324869857, 75930.51303185058), new Vsop87.LnVsop(1.2E-10, 5.76352424828, 50167.24874398939), new Vsop87.LnVsop(1.1E-10, 2.65933951973, 137210.22630911658), new Vsop87.LnVsop(1.1E-10, 0.61260463058, 44295.7171298094), new Vsop87.LnVsop(1.1E-10, 4.75744397675, 155571.81910783658), new Vsop87.LnVsop(1.1E-10, 0.92596625175, 22625.658435709), new Vsop87.LnVsop(1.4E-10, 5.94031170257, 52290.24557183361), new Vsop87.LnVsop(1.3E-10, 2.88183763459, 112545.88789950538), new Vsop87.LnVsop(1.2E-10, 6.20307751102, 51653.22886505459), new Vsop87.LnVsop(1.4E-10, 0.79666118269, 25953.79409198919), new Vsop87.LnVsop(1.1E-10, 2.82291310257, 77101.23472031478), new Vsop87.LnVsop(1.1E-10, 1.26691831337, 26312.2479372761), new Vsop87.LnVsop(1.1E-10, 6.04692861527, 27044.1922975448), new Vsop87.LnVsop(1.1E-10, 3.5905091067, 52712.61079524379), new Vsop87.LnVsop(1.2E-10, 3.29867482436, 52061.36699446317), new Vsop87.LnVsop(1.1E-10, 4.14868784122, 45290.65639321759), new Vsop87.LnVsop(1.2E-10, 2.20117670946, 31415.379249957), new Vsop87.LnVsop(1.1E-10, 3.28550164867, 28736.3579670472), new Vsop87.LnVsop(1.1E-10, 2.9414458188, 58857.03113654799), new Vsop87.LnVsop(1.4E-10, 2.76963894785, 23888.81579828719), new Vsop87.LnVsop(1.0E-10, 0.46195987169, 24448.8336243862), new Vsop87.LnVsop(1.0E-10, 2.86866087585, 130226.21661243298), new Vsop87.LnVsop(1.0E-10, 5.45102637711, 163298.1294506908), new Vsop87.LnVsop(1.3E-10, 4.41913559624, 19958.6061020676), new Vsop87.LnVsop(1.2E-10, 5.95935970873, 26083.97098831109), new Vsop87.LnVsop(1.3E-10, 3.57379666664, 77795.74443436819), new Vsop87.LnVsop(1.0E-10, 3.83420431277, 51226.63067417859), new Vsop87.LnVsop(1.2E-10, 1.57272284029, 91805.13062721379), new Vsop87.LnVsop(1.0E-10, 1.11456831986, 78903.60671103658), new Vsop87.LnVsop(1.1E-10, 1.35230305494, 51969.62073471119), new Vsop87.LnVsop(1.0E-10, 4.67337740333, 2111.6503133776), new Vsop87.LnVsop(1.1E-10, 5.80271751795, 27972.80430499159), new Vsop87.LnVsop(1.1E-10, 5.80527692287, 26102.1302355758), new Vsop87.LnVsop(1.3E-10, 0.32349874907, 157057.10981453978), new Vsop87.LnVsop(1.0E-10, 1.1424709658, 9384.8410080752), new Vsop87.LnVsop(1.3E-10, 4.60340992512, 25032.45336464809), new Vsop87.LnVsop(1.1E-10, 2.47098170967, 26010.1525975903), new Vsop87.LnVsop(1.0E-10, 4.34994273616, 157586.80077963436), new Vsop87.LnVsop(1.0E-10, 1.10800044909, 65831.6667743248), new Vsop87.LnVsop(1.2E-10, 5.55659972511, 22909.7573510066), new Vsop87.LnVsop(1.1E-10, 4.67416745722, 50064.15596977079), new Vsop87.LnVsop(9.0E-11, 2.37765084995, 78896.49316403578), new Vsop87.LnVsop(9.0E-11, 0.47421378853, 128106.31931499895), new Vsop87.LnVsop(1.1E-10, 6.23832638741, 30171.8916482786), new Vsop87.LnVsop(9.0E-11, 1.42183589402, 104505.39137678158), new Vsop87.LnVsop(9.0E-11, 4.85867084365, 24918.31489016559), new Vsop87.LnVsop(1.0E-10, 2.78334321933, 81591.84508100279), new Vsop87.LnVsop(1.0E-10, 0.87205573987, 78366.80219894118), new Vsop87.LnVsop(9.0E-11, 5.40574630906, 130459.18546877075), new Vsop87.LnVsop(1.0E-10, 1.65859404347, 78039.36462902068), new Vsop87.LnVsop(9.0E-11, 3.0350957563, 51329.7234483972), new Vsop87.LnVsop(9.0E-11, 1.96004127485, 26575.53789282839), new Vsop87.LnVsop(1.0E-10, 1.17585399339, 50270.341518208), new Vsop87.LnVsop(9.0E-11, 5.53838845699, 8194.2753332086), new Vsop87.LnVsop(9.0E-11, 3.66100752188, 151199.94274106238), new Vsop87.LnVsop(9.0E-11, 1.60088408502, 117893.03376878797), new Vsop87.LnVsop(1.0E-10, 3.21502369366, 77307.42026875199), new Vsop87.LnVsop(9.0E-11, 0.42023516699, 27223.5800134674), new Vsop87.LnVsop(8.0E-11, 1.34535060467, 12546.481939083), new Vsop87.LnVsop(9.0E-11, 5.4639404139, 16703.062133499), new Vsop87.LnVsop(9.0E-11, 1.60635058887, 77616.69859140778), new Vsop87.LnVsop(1.0E-10, 1.76453908885, 77726.90491262719), new Vsop87.LnVsop(9.0E-11, 5.48514099908, 138319.60486120995), new Vsop87.LnVsop(9.0E-11, 5.66705612562, 50910.238804522), new Vsop87.LnVsop(9.0E-11, 0.69447244274, 26709.6469424134), new Vsop87.LnVsop(9.0E-11, 6.23127403544, 846.0828347512), new Vsop87.LnVsop(1.0E-10, 5.49114293123, 94329.77528619739), new Vsop87.LnVsop(1.1E-10, 0.75948957862, 128320.75184749259), new Vsop87.LnVsop(9.0E-11, 0.50088873003, 27573.1938482774), new Vsop87.LnVsop(8.0E-11, 1.1861245217, 104197.83375581198), new Vsop87.LnVsop(1.1E-10, 6.20672194821, 28102.884813372), new Vsop87.LnVsop(8.0E-11, 0.96153145702, 19202.75325164339), new Vsop87.LnVsop(9.0E-11, 1.73726961641, 28791.5192962498), new Vsop87.LnVsop(8.0E-11, 4.51184849789, 27463.67694142), new Vsop87.LnVsop(8.0E-11, 3.59638355762, 76784.84285065818), new Vsop87.LnVsop(9.0E-11, 1.55645109651, 26126.036177212), new Vsop87.LnVsop(8.0E-11, 1.09983228187, 78160.61665050399), new Vsop87.LnVsop(8.0E-11, 6.23118263675, 148.0787244263), new Vsop87.LnVsop(8.0E-11, 0.87630174262, 151.0476698429), new Vsop87.LnVsop(8.0E-11, 3.17310230516, 50903.1252575212), new Vsop87.LnVsop(1.1E-10, 1.85720558473, 214364.55718174577), new Vsop87.LnVsop(8.0E-11, 2.4993551357, 51955.39364070959), new Vsop87.LnVsop(8.0E-11, 2.66478360481, 130432.40216087017), new Vsop87.LnVsop(8.0E-11, 3.12318873266, 22003.9146348698), new Vsop87.LnVsop(8.0E-11, 4.20069783382, 50380.54783942739), new Vsop87.LnVsop(8.0E-11, 5.8286989034, 3328.13565628019), new Vsop87.LnVsop(1.0E-10, 2.61302801987, 27170.98337386779), new Vsop87.LnVsop(8.0E-11, 3.45199097443, 24203.0019781568), new Vsop87.LnVsop(8.0E-11, 0.37984013982, 183570.921732628), new Vsop87.LnVsop(8.0E-11, 3.44870214429, 26402.0893214438), new Vsop87.LnVsop(8.0E-11, 6.15047498198, 37698.4550999484), new Vsop87.LnVsop(7.0E-11, 0.09645033702, 206.1855484372), new Vsop87.LnVsop(7.0E-11, 5.88329863855, 51868.2486621788), new Vsop87.LnVsop(7.0E-11, 4.80640635339, 26118.2300025786), new Vsop87.LnVsop(1.0E-10, 2.52561621829, 35833.2236974308), new Vsop87.LnVsop(7.0E-11, 3.79900304025, 103917.90082841998), new Vsop87.LnVsop(8.0E-11, 1.59041748036, 101011.00013959699), new Vsop87.LnVsop(9.0E-11, 2.57099726908, 2125.8774073792), new Vsop87.LnVsop(7.0E-11, 5.32440574441, 35077.37084700659), new Vsop87.LnVsop(7.0E-11, 2.46084982091, 52137.67324751059), new Vsop87.LnVsop(8.0E-11, 4.37434019274, 123200.84011627098), new Vsop87.LnVsop(9.0E-11, 5.1368773566, 55638.05098901359), new Vsop87.LnVsop(7.0E-11, 5.98045973961, 52179.73843641149), new Vsop87.LnVsop(9.0E-11, 2.52935998753, 25227.59321282139), new Vsop87.LnVsop(9.0E-11, 0.68598593831, 38.1330356378), new Vsop87.LnVsop(9.0E-11, 3.57329597023, 1265.5674786264), new Vsop87.LnVsop(9.0E-11, 1.65566330689, 65717.22748563958), new Vsop87.LnVsop(7.0E-11, 3.88988296844, 1485.9801210652), new Vsop87.LnVsop(7.0E-11, 4.2911056575, 155887.52156313116), new Vsop87.LnVsop(8.0E-11, 0.47377071059, 181026.24909573558), new Vsop87.LnVsop(8.0E-11, 5.57007244381, 50689.82616208319), new Vsop87.LnVsop(1.0E-10, 0.82585923948, 39763.43339365039), new Vsop87.LnVsop(7.0E-11, 4.34057816709, 129373.02023068098), new Vsop87.LnVsop(7.0E-11, 0.41164824366, 182188.72380014337), new Vsop87.LnVsop(8.0E-11, 0.23518929674, 50049.92887576919), new Vsop87.LnVsop(7.0E-11, 3.14813276838, 52061.40717623499), new Vsop87.LnVsop(8.0E-11, 1.24064472176, 76041.85279012559), new Vsop87.LnVsop(9.0E-11, 3.52369322812, 2008.557539159), new Vsop87.LnVsop(7.0E-11, 4.86954611488, 27351.06050415239), new Vsop87.LnVsop(9.0E-11, 1.96717423051, 365230.6439820388), new Vsop87.LnVsop(7.0E-11, 5.46143723851, 25985.94062330859), new Vsop87.LnVsop(8.0E-11, 6.26980974962, 204151.27163553477), new Vsop87.LnVsop(7.0E-11, 3.42584394985, 52483.36390411799), new Vsop87.LnVsop(7.0E-11, 2.52325477952, 207593.8465805002), new Vsop87.LnVsop(9.0E-11, 0.69792128051, 233731.7463439786), new Vsop87.LnVsop(7.0E-11, 0.13818691784, 52911.68279668019), new Vsop87.LnVsop(7.0E-11, 3.9867406132, 13675.5302520762), new Vsop87.LnVsop(7.0E-11, 4.44340268776, 26057.57628056979), new Vsop87.LnVsop(7.0E-11, 2.5371381474, 80382.47328510099), new Vsop87.LnVsop(7.0E-11, 0.03218225075, 31281.270200372), new Vsop87.LnVsop(7.0E-11, 4.3348956307, 167850.0829477496), new Vsop87.LnVsop(8.0E-11, 4.62571179271, 76887.93562487679), new Vsop87.LnVsop(8.0E-11, 4.03988460752, 53906.92863608099), new Vsop87.LnVsop(6.0E-11, 1.59873561232, 143980.93691036216), new Vsop87.LnVsop(7.0E-11, 3.52756376168, 52509.6622239178), new Vsop87.LnVsop(7.0E-11, 5.24448652662, 1795.258443721), new Vsop87.LnVsop(7.0E-11, 5.21000690023, 161079.37234650398), new Vsop87.LnVsop(7.0E-11, 1.70582791676, 54087.0057663656), new Vsop87.LnVsop(7.0E-11, 4.28578455719, 51130.65144696079), new Vsop87.LnVsop(7.0E-11, 3.42650023556, 29396.3690369546), new Vsop87.LnVsop(6.0E-11, 3.1878857911, 24072.9214697764), new Vsop87.LnVsop(8.0E-11, 0.7049285329, 25169.9728555924), new Vsop87.LnVsop(7.0E-11, 5.70539968132, 9745.3205558566), new Vsop87.LnVsop(8.0E-11, 0.13922543752, 136722.59155786238), new Vsop87.LnVsop(7.0E-11, 5.42861124484, 27566.76971563859), new Vsop87.LnVsop(7.0E-11, 3.9547678445, 145204.75475114078), new Vsop87.LnVsop(7.0E-11, 3.78837180264, 26189.8656598398), new Vsop87.LnVsop(8.0E-11, 3.40119385646, 78153.50310350319), new Vsop87.LnVsop(6.0E-11, 1.19861324023, 26734.913974889), new Vsop87.LnVsop(7.0E-11, 0.57045467282, 118828.96374949679), new Vsop87.LnVsop(8.0E-11, 3.30573659151, 130419.8459469712), new Vsop87.LnVsop(6.0E-11, 5.17878386927, 78338.49102328988), new Vsop87.LnVsop(7.0E-11, 1.86755524082, 1905.4647649404), new Vsop87.LnVsop(8.0E-11, 3.80625042789, 137678.191299471), new Vsop87.LnVsop(7.0E-11, 1.20815914313, 61560.64729122359), new Vsop87.LnVsop(8.0E-11, 5.80110689687, 25773.71696170459), new Vsop87.LnVsop(8.0E-11, 4.81332582969, 142871.55835826878), new Vsop87.LnVsop(8.0E-11, 1.46122702584, 87367.61641884019), new Vsop87.LnVsop(8.0E-11, 0.88124699513, 220.4126424388), new Vsop87.LnVsop(7.0E-11, 1.6417915242, 196137.07343261078), new Vsop87.LnVsop(6.0E-11, 0.90242839977, 129387.24732468258), new Vsop87.LnVsop(7.0E-11, 5.6921590988, 158746.17595363196), new Vsop87.LnVsop(6.0E-11, 4.05724988846, 52174.32181044009), new Vsop87.LnVsop(6.0E-11, 1.71090238858, 26830.8932021068), new Vsop87.LnVsop(6.0E-11, 6.10253738949, 203041.8930834414), new Vsop87.LnVsop(6.0E-11, 0.3073812356, 54374.8936264354), new Vsop87.LnVsop(6.0E-11, 0.41222313301, 2199.087343287), new Vsop87.LnVsop(6.0E-11, 1.43510177069, 2333.196392872), new Vsop87.LnVsop(6.0E-11, 3.9365680997, 130289.95251073639), new Vsop87.LnVsop(7.0E-11, 0.36974820473, 103932.12792242158), new Vsop87.LnVsop(6.0E-11, 2.72826803217, 76255.15188556358), new Vsop87.LnVsop(7.0E-11, 1.2740249479, 46046.5092436418), new Vsop87.LnVsop(6.0E-11, 0.44952989323, 208173.534167499), new Vsop87.LnVsop(8.0E-11, 4.68388468911, 25014.29411738339), new Vsop87.LnVsop(7.0E-11, 3.81640774507, 52041.69723356339), new Vsop87.LnVsop(8.0E-11, 5.42651288061, 949.1756089698), new Vsop87.LnVsop(6.0E-11, 0.5208093082, 25004.8229092806), new Vsop87.LnVsop(8.0E-11, 3.01472942819, 26076.8574413103), new Vsop87.LnVsop(7.0E-11, 5.36517964373, 77940.20400806518), new Vsop87.LnVsop(6.0E-11, 3.49010452393, 123668.80510662538), new Vsop87.LnVsop(6.0E-11, 4.57296057068, 35211.47989659159), new Vsop87.LnVsop(6.0E-11, 5.371763423, 53093.73656913019), new Vsop87.LnVsop(6.0E-11, 1.99673742216, 130435.63437251298), new Vsop87.LnVsop(6.0E-11, 3.10336530669, 77947.31755506598), new Vsop87.LnVsop(8.0E-11, 5.493574141, 53814.87580033639), new Vsop87.LnVsop(8.0E-11, 2.24316734824, 25466.159340735), new Vsop87.LnVsop(6.0E-11, 6.09625894529, 103395.32341032618), new Vsop87.LnVsop(8.0E-11, 5.31272348192, 24388.62392507099), new Vsop87.LnVsop(5.0E-11, 0.44435745265, 179172.74704605396), new Vsop87.LnVsop(5.0E-11, 5.64850202903, 28774.6252361154), new Vsop87.LnVsop(5.0E-11, 5.8698128405, 156314.1197540072), new Vsop87.LnVsop(7.0E-11, 4.21874962552, 26098.9488418381), new Vsop87.LnVsop(6.0E-11, 2.19700567791, 12412.372889498), new Vsop87.LnVsop(6.0E-11, 1.2878404111, 102975.83876645098), new Vsop87.LnVsop(5.0E-11, 4.94698005592, 50444.6839302158), new Vsop87.LnVsop(6.0E-11, 1.82802843508, 24402.8510190726), new Vsop87.LnVsop(5.0E-11, 5.64154870955, 55503.94193942859), new Vsop87.LnVsop(6.0E-11, 0.0294487624, 20043.6745601988), new Vsop87.LnVsop(6.0E-11, 1.01830751527, 183674.70392120857), new Vsop87.LnVsop(6.0E-11, 2.19844933048, 103718.82882698359), new Vsop87.LnVsop(6.0E-11, 2.48218378908, 51439.92976961659), new Vsop87.LnVsop(7.0E-11, 3.6566933811, 143005.6674078538), new Vsop87.LnVsop(6.0E-11, 5.02499172571, 78469.89497315978), new Vsop87.LnVsop(6.0E-11, 3.28107700351, 144916.86689107097), new Vsop87.LnVsop(5.0E-11, 1.5297413665, 26724.8994135984), new Vsop87.LnVsop(5.0E-11, 5.43264125558, 130446.62925487179), new Vsop87.LnVsop(6.0E-11, 6.20586010225, 114.3991069134), new Vsop87.LnVsop(5.0E-11, 1.97758412332, 130652.81480330898), new Vsop87.LnVsop(7.0E-11, 0.75444891777, 77520.71936418998), new Vsop87.LnVsop(5.0E-11, 3.42800816448, 50536.73676596039), new Vsop87.LnVsop(5.0E-11, 1.69966337069, 78786.28684281638), new Vsop87.LnVsop(5.0E-11, 5.46516609389, 103498.41618454478), new Vsop87.LnVsop(6.0E-11, 4.70912746923, 52177.29075585669), new Vsop87.LnVsop(5.0E-11, 5.0321086104, 1045.1548361876), new Vsop87.LnVsop(5.0E-11, 4.19089790418, 130363.24963659538), new Vsop87.LnVsop(5.0E-11, 6.2715795733, 1272.6810256272), new Vsop87.LnVsop(5.0E-11, 1.36461885531, 181659.72224941078), new Vsop87.LnVsop(6.0E-11, 2.86818435011, 52755.49387014719), new Vsop87.LnVsop(5.0E-11, 5.57712092238, 106262.81204951399), new Vsop87.LnVsop(7.0E-11, 3.82369524609, 62197.64356324779), new Vsop87.LnVsop(5.0E-11, 4.48988723219, 50007.0458008658), new Vsop87.LnVsop(5.0E-11, 5.67785301537, 78580.10129437919), new Vsop87.LnVsop(6.0E-11, 3.63826732126, 198489.9395863826), new Vsop87.LnVsop(7.0E-11, 3.08378061801, 52027.72755872209), new Vsop87.LnVsop(5.0E-11, 0.06002744854, 51596.1186961496), new Vsop87.LnVsop(6.0E-11, 2.81224506925, 25450.90686955), new Vsop87.LnVsop(5.0E-11, 5.06206878451, 52609.51802102519), new Vsop87.LnVsop(5.0E-11, 4.13691080116, 53867.97195265079), new Vsop87.LnVsop(5.0E-11, 0.66848559375, 104276.83096772949), new Vsop87.LnVsop(5.0E-11, 4.95249581376, 78413.27262185719), new Vsop87.LnVsop(5.0E-11, 3.55435464017, 43981.5309499398), new Vsop87.LnVsop(5.0E-11, 0.50816610094, 299.1263942692), new Vsop87.LnVsop(6.0E-11, 2.94825784581, 56259.79478985279), new Vsop87.LnVsop(5.0E-11, 5.74190826395, 103189.13786188899), new Vsop87.LnVsop(5.0E-11, 0.317417588, 78800.51393681798), new Vsop87.LnVsop(6.0E-11, 3.74336258475, 26247.2048763664), new Vsop87.LnVsop(6.0E-11, 2.73646698829, 52286.01260436779), new Vsop87.LnVsop(5.0E-11, 1.77497247774, 129586.31932611899), new Vsop87.LnVsop(6.0E-11, 2.57896380153, 26014.60601571519), new Vsop87.LnVsop(5.0E-11, 2.23635663946, 24513.057340292), new Vsop87.LnVsop(6.0E-11, 0.42705996592, 130443.39704322898), new Vsop87.LnVsop(6.0E-11, 5.13378058477, 78313.70604662679), new Vsop87.LnVsop(5.0E-11, 2.46839838469, 123758.29085447139), new Vsop87.LnVsop(6.0E-11, 1.18640004452, 25600.26839032), new Vsop87.LnVsop(6.0E-11, 5.08742416907, 53124.98189211819), new Vsop87.LnVsop(7.0E-11, 2.15977683208, 52024.75861330549), new Vsop87.LnVsop(6.0E-11, 4.52235258445, 166740.70439565618), new Vsop87.LnVsop(5.0E-11, 4.87195511152, 102659.44689679438), new Vsop87.LnVsop(6.0E-11, 0.31441101535, 102872.74599223239), new Vsop87.LnVsop(5.0E-11, 1.42393263915, 28199.55345495179), new Vsop87.LnVsop(5.0E-11, 1.3926764669, 39450.3528483734), new Vsop87.LnVsop(6.0E-11, 1.3713309296, 51120.35650622229), new Vsop87.LnVsop(6.0E-11, 6.22297289912, 78149.27013603736), new Vsop87.LnVsop(5.0E-11, 0.57729967408, 26933.9859763254), new Vsop87.LnVsop(6.0E-11, 1.80407643479, 23549.6546373206), new Vsop87.LnVsop(5.0E-11, 3.60259399818, 11.0457002639), new Vsop87.LnVsop(5.0E-11, 3.93868954411, 48713.5615772832), new Vsop87.LnVsop(6.0E-11, 1.4423405004, 76152.05911134499), new Vsop87.LnVsop(6.0E-11, 3.19917719734, 183145.012956114), new Vsop87.LnVsop(5.0E-11, 4.5519714599, 79330.20490191258), new Vsop87.LnVsop(5.0E-11, 0.84232799985, 24551.92639860479), new Vsop87.LnVsop(5.0E-11, 4.4509826439, 102769.65321801379), new Vsop87.LnVsop(5.0E-11, 2.92291007768, 54190.78795494619), new Vsop87.LnVsop(5.0E-11, 0.46604463103, 52817.21984488739), new Vsop87.LnVsop(6.0E-11, 1.11258968779, 25647.07785669659), new Vsop87.LnVsop(5.0E-11, 3.96038779086, 25657.37279743509), new Vsop87.LnVsop(5.0E-11, 3.75575867114, 52797.55008398759), new Vsop87.LnVsop(5.0E-11, 3.61079719482, 26411.4085582316), new Vsop87.LnVsop(5.0E-11, 1.6682257067, 47803.9299163742), new Vsop87.LnVsop(6.0E-11, 2.32203480843, 27665.246684022), new Vsop87.LnVsop(4.0E-11, 1.86177066589, 53771.99272543299), new Vsop87.LnVsop(5.0E-11, 4.85075574464, 54344.56676543099), new Vsop87.LnVsop(5.0E-11, 6.19447408823, 26191.68533015479), new Vsop87.LnVsop(5.0E-11, 3.73206511731, 78213.71280281838), new Vsop87.LnVsop(4.0E-11, 2.13995639327, 189386.03259226496), new Vsop87.LnVsop(6.0E-11, 2.60366708487, 78378.1487134078), new Vsop87.LnVsop(4.0E-11, 1.3991722537, 26290.15653674829), new Vsop87.LnVsop(5.0E-11, 1.09229620764, 26183.88236879199), new Vsop87.LnVsop(6.0E-11, 0.88029618554, 23336.3555418826), new Vsop87.LnVsop(5.0E-11, 6.13113074115, 26026.177166834), new Vsop87.LnVsop(4.0E-11, 4.94928690334, 52663.44103440259), new Vsop87.LnVsop(4.0E-11, 0.62360130446, 102755.42612401219), new Vsop87.LnVsop(5.0E-11, 6.04519983514, 52161.57918914679), new Vsop87.LnVsop(4.0E-11, 1.71609047005, 23762.9537327586), new Vsop87.LnVsop(4.0E-11, 0.21148637237, 19336.86230122839), new Vsop87.LnVsop(5.0E-11, 3.31951258622, 45424.76544280259), new Vsop87.LnVsop(4.0E-11, 0.09463875144, 78683.19406859778), new Vsop87.LnVsop(5.0E-11, 6.01855111376, 128220.75860368418), new Vsop87.LnVsop(5.0E-11, 1.78257995471, 187167.2754880782), new Vsop87.LnVsop(5.0E-11, 4.99565783477, 41494.55574658299), new Vsop87.LnVsop(5.0E-11, 4.64166221826, 24824.745778996), new Vsop87.LnVsop(4.0E-11, 1.61945390198, 28309.75977617119), new Vsop87.LnVsop(6.0E-11, 2.62148938551, 52171.87412988529), new Vsop87.LnVsop(4.0E-11, 0.52972446133, 77314.53381575279), new Vsop87.LnVsop(6.0E-11, 2.56621666333, 51876.67988887919), new Vsop87.LnVsop(6.0E-11, 2.53671356332, 52190.03337714999), new Vsop87.LnVsop(5.0E-11, 5.84026664575, 104344.98400739678), new Vsop87.LnVsop(4.0E-11, 3.77333237335, 153084.84390447979), new Vsop87.LnVsop(4.0E-11, 3.42433134364, 53311.4831550416), new Vsop87.LnVsop(4.0E-11, 1.92553176807, 156547.08861034497), new Vsop87.LnVsop(4.0E-11, 4.29836210336, 130593.29451835579), new Vsop87.LnVsop(5.0E-11, 0.30567664615, 103883.64757594238), new Vsop87.LnVsop(4.0E-11, 4.24846221979, 189853.99758261937), new Vsop87.LnVsop(4.0E-11, 6.09490221813, 77417.62658997139), new Vsop87.LnVsop(5.0E-11, 3.46214176278, 48847.6706268682), new Vsop87.LnVsop(6.0E-11, 3.71691630302, 81604.32185142238), new Vsop87.LnVsop(4.0E-11, 3.62019381955, 70383.6202713836), new Vsop87.LnVsop(4.0E-11, 3.62744843597, 53029.0026649004), new Vsop87.LnVsop(4.0E-11, 1.40344660688, 25885.64974640009), new Vsop87.LnVsop(6.0E-11, 2.54555794681, 54060.70744656579), new Vsop87.LnVsop(4.0E-11, 4.06110284313, 91919.56991589899), new Vsop87.LnVsop(5.0E-11, 3.9250461459, 101703.15774082378), new Vsop87.LnVsop(4.0E-11, 5.48109256361, 78225.57638908479), new Vsop87.LnVsop(4.0E-11, 5.92354219151, 84944.9342781222), new Vsop87.LnVsop(5.0E-11, 1.45746030546, 51102.19725895759), new Vsop87.LnVsop(4.0E-11, 0.18748530762, 52489.992463018), new Vsop87.LnVsop(5.0E-11, 0.64220436035, 3178.1457905676), new Vsop87.LnVsop(5.0E-11, 1.74091893413, 79315.97780791098), new Vsop87.LnVsop(5.0E-11, 4.33120733566, 51112.49219969609), new Vsop87.LnVsop(5.0E-11, 0.28595106407, 26161.20026743319), new Vsop87.LnVsop(5.0E-11, 0.30883343706, 53265.515074342), new Vsop87.LnVsop(4.0E-11, 4.51338981538, 78339.97549599818), new Vsop87.LnVsop(5.0E-11, 1.96614115805, 130866.11389874699), new Vsop87.LnVsop(4.0E-11, 0.09019783661, 58220.0348645238), new Vsop87.LnVsop(4.0E-11, 5.51106442769, 78043.29678228378), new Vsop87.LnVsop(4.0E-11, 0.59216167629, 16342.5825857176), new Vsop87.LnVsop(5.0E-11, 0.32341090439, 28096.46068073319), new Vsop87.LnVsop(4.0E-11, 5.15437140585, 24285.5311508524), new Vsop87.LnVsop(5.0E-11, 2.15151582679, 48997.6604925808), new Vsop87.LnVsop(5.0E-11, 4.75657933833, 240452.46032331997), new Vsop87.LnVsop(4.0E-11, 5.35396036827, 104984.39630560997), new Vsop87.LnVsop(4.0E-11, 3.83354739662, 14.2270940016), new Vsop87.LnVsop(4.0E-11, 1.52206374281, 26267.9802718588), new Vsop87.LnVsop(4.0E-11, 2.36732975711, 19.66976089979), new Vsop87.LnVsop(4.0E-11, 5.1095428608, 31722.9368709266), new Vsop87.LnVsop(4.0E-11, 1.54518951672, 52206.1331441528), new Vsop87.LnVsop(4.0E-11, 4.66669337352, 104127.26777059489), new Vsop87.LnVsop(5.0E-11, 5.74829513019, 51841.950342379), new Vsop87.LnVsop(4.0E-11, 3.3010603579, 316.3918696566), new Vsop87.LnVsop(4.0E-11, 2.93299901703, 31775.5335105262), new Vsop87.LnVsop(4.0E-11, 4.06219603307, 130285.73689738619), new Vsop87.LnVsop(4.0E-11, 1.74441095464, 26248.310510959), new Vsop87.LnVsop(4.0E-11, 4.12254586219, 27441.651886591), new Vsop87.LnVsop(4.0E-11, 4.15776973428, 26279.35140768579), new Vsop87.LnVsop(4.0E-11, 1.15784310255, 50264.6067999312), new Vsop87.LnVsop(4.0E-11, 5.23429009814, 52396.2189255872), new Vsop87.LnVsop(4.0E-11, 5.30327887066, 25672.35065096209), new Vsop87.LnVsop(5.0E-11, 1.10382058499, 31903.01400121119), new Vsop87.LnVsop(5.0E-11, 2.71036686336, 24952.226269681), new Vsop87.LnVsop(4.0E-11, 2.64042462073, 24602.61243487099), new Vsop87.LnVsop(4.0E-11, 1.87407286172, 15406.65260500879), new Vsop87.LnVsop(4.0E-11, 5.78862899204, 22779.4372461938), new Vsop87.LnVsop(4.0E-11, 4.22021430563, 1731.1223529326), new Vsop87.LnVsop(4.0E-11, 3.29759878123, 76137.83201734339), new Vsop87.LnVsop(5.0E-11, 4.41662635417, 78057.52387628538), new Vsop87.LnVsop(4.0E-11, 1.57423026339, 128747.35003836859), new Vsop87.LnVsop(5.0E-11, 5.17627834613, 19367.1891622328), new Vsop87.LnVsop(4.0E-11, 4.6827193637, 103814.80805420138), new Vsop87.LnVsop(4.0E-11, 2.99546350548, 77741.13200662879), new Vsop87.LnVsop(4.0E-11, 3.47912671031, 53661.0969898516), new Vsop87.LnVsop(4.0E-11, 1.47969113461, 120417.67842777158), new Vsop87.LnVsop(4.0E-11, 5.51314482955, 132350.71519108818), new Vsop87.LnVsop(4.0E-11, 2.11602271207, 235900.50682626115), new Vsop87.LnVsop(4.0E-11, 3.41919050321, 26114.201461374), new Vsop87.LnVsop(4.0E-11, 2.87953962922, 25862.073873164), new Vsop87.LnVsop(5.0E-11, 5.71960795619, 1911.1994832172), new Vsop87.LnVsop(4.0E-11, 2.8295437906, 133767.65136415116), new Vsop87.LnVsop(4.0E-11, 3.12567603415, 20894.5360827764), new Vsop87.LnVsop(4.0E-11, 2.20022040184, 52073.84376488279), new Vsop87.LnVsop(3.0E-11, 1.654472895, 51006.21803173979), new Vsop87.LnVsop(4.0E-11, 0.72729563393, 25865.04281858059), new Vsop87.LnVsop(4.0E-11, 4.75773817489, 156740.7179448832), new Vsop87.LnVsop(4.0E-11, 5.61140287619, 53258.88651544199), new Vsop87.LnVsop(4.0E-11, 1.55115346866, 53438.96364572659), new Vsop87.LnVsop(5.0E-11, 0.91157457367, 25665.23710396129), new Vsop87.LnVsop(5.0E-11, 6.11074430084, 156507.7490885454), new Vsop87.LnVsop(3.0E-11, 3.13187739577, 80462.79676800959), new Vsop87.LnVsop(4.0E-11, 0.99586228194, 149288.74325784517), new Vsop87.LnVsop(4.0E-11, 3.81858133541, 26513.8119180882), new Vsop87.LnVsop(3.0E-11, 3.76308396741, 77.7505439839), new Vsop87.LnVsop(4.0E-11, 2.20983069576, 76777.72930365738), new Vsop87.LnVsop(4.0E-11, 1.96565283101, 132028.58860315479), new Vsop87.LnVsop(4.0E-11, 0.75635766859, 23384.2869868986), new Vsop87.LnVsop(3.0E-11, 2.47442898563, 77956.15180375299), new Vsop87.LnVsop(4.0E-11, 3.82892344861, 104454.70534051539), new Vsop87.LnVsop(4.0E-11, 4.06084495744, 33856.2696982688), new Vsop87.LnVsop(4.0E-11, 1.56161739887, 1055.4497769261), new Vsop87.LnVsop(5.0E-11, 3.1167545854, 26149.62911631439), new Vsop87.LnVsop(4.0E-11, 3.7520727365, 49424.25868345679), new Vsop87.LnVsop(4.0E-11, 4.12046971863, 104991.50985261079), new Vsop87.LnVsop(3.0E-11, 4.55090472605, 57503.2823915312), new Vsop87.LnVsop(4.0E-11, 0.52382972546, 154194.22245657316), new Vsop87.LnVsop(3.0E-11, 4.57699005153, 21716.0267748), new Vsop87.LnVsop(3.0E-11, 4.03880524047, 104248.51979207818), new Vsop87.LnVsop(4.0E-11, 0.75633347724, 79994.83177765518), new Vsop87.LnVsop(3.0E-11, 0.9484815316, 143164.96914264598), new Vsop87.LnVsop(5.0E-11, 4.29018004927, 53757.76563143139), new Vsop87.LnVsop(4.0E-11, 2.29764966629, 51534.3927214094), new Vsop87.LnVsop(4.0E-11, 3.74755373208, 25970.58327335399), new Vsop87.LnVsop(4.0E-11, 1.22491945176, 25927.49577218939), new Vsop87.LnVsop(3.0E-11, 0.19025922851, 50290.905119731), new Vsop87.LnVsop(3.0E-11, 0.82865789636, 30689.8532605372), new Vsop87.LnVsop(4.0E-11, 2.9393800967, 30110.1656735384), new Vsop87.LnVsop(3.0E-11, 2.37855052298, 25459.05155552409), new Vsop87.LnVsop(3.0E-11, 5.61456633749, 156520.30530244438), new Vsop87.LnVsop(3.0E-11, 0.54027108346, 130005.80396999417), new Vsop87.LnVsop(4.0E-11, 6.15218047879, 76991.02839909539), new Vsop87.LnVsop(4.0E-11, 3.50355655289, 33480.357543659), new Vsop87.LnVsop(3.0E-11, 0.0112436854, 78571.26704569219), new Vsop87.LnVsop(4.0E-11, 1.42998120813, 23446.561863102), new Vsop87.LnVsop(4.0E-11, 4.30859600855, 2538.2485042536), new Vsop87.LnVsop(3.0E-11, 4.07249909537, 32808.6171209156), new Vsop87.LnVsop(4.0E-11, 4.579677441, 52213.9393187862), new Vsop87.LnVsop(4.0E-11, 2.71237687854, 107679.74822257696), new Vsop87.LnVsop(4.0E-11, 2.1086768693, 27331.3907432526), new Vsop87.LnVsop(4.0E-11, 2.63978309242, 80596.9058175946), new Vsop87.LnVsop(4.0E-11, 1.44726666359, 25907.8260112896), new Vsop87.LnVsop(3.0E-11, 2.77225709802, 25984.1209529936), new Vsop87.LnVsop(3.0E-11, 0.77055249403, 23389.451694197), new Vsop87.LnVsop(4.0E-11, 2.22943193042, 104819.57755665119), new Vsop87.LnVsop(4.0E-11, 5.53757642567, 52098.05573916449), new Vsop87.LnVsop(3.0E-11, 4.85887200017, 1063.3140834523), new Vsop87.LnVsop(4.0E-11, 5.5090293544, 51315.49635439559), new Vsop87.LnVsop(3.0E-11, 6.10316637842, 48091.817776444), new Vsop87.LnVsop(4.0E-11, 4.67601599622, 18073.7049386502), new Vsop87.LnVsop(3.0E-11, 4.58899296863, 25896.4548754626), new Vsop87.LnVsop(3.0E-11, 5.35415033267, 233681.74972207437), new Vsop87.LnVsop(3.0E-11, 2.076383245, 3.9321532631), new Vsop87.LnVsop(3.0E-11, 2.40851756173, 76998.14194609619), new Vsop87.LnVsop(3.0E-11, 3.54974279869, 23401.181047033), new Vsop87.LnVsop(3.0E-11, 6.24455798435, 54824.2611086214), new Vsop87.LnVsop(3.0E-11, 5.95091721147, 6751.0408403458), new Vsop87.LnVsop(3.0E-11, 4.46119653187, 127098.90328117118), new Vsop87.LnVsop(4.0E-11, 1.45335178532, 1073.6090241908), new Vsop87.LnVsop(4.0E-11, 3.64332193223, 860.3099287528), new Vsop87.LnVsop(3.0E-11, 5.19214304483, 52309.9153327334), new Vsop87.LnVsop(3.0E-11, 3.87383641149, 56777.7564021114), new Vsop87.LnVsop(4.0E-11, 1.93735592711, 26603.3670126672), new Vsop87.LnVsop(3.0E-11, 2.94612910423, 27039.97976483379), new Vsop87.LnVsop(4.0E-11, 2.04162116492, 27623.8798845436), new Vsop87.LnVsop(3.0E-11, 1.90299644295, 126067.63934109679), new Vsop87.LnVsop(3.0E-11, 5.46693649158, 149846.1939960456), new Vsop87.LnVsop(4.0E-11, 3.72194883593, 51257.8759971666), new Vsop87.LnVsop(4.0E-11, 5.84175823655, 25650.2592504343), new Vsop87.LnVsop(3.0E-11, 2.84825042585, 159855.55450572536), new Vsop87.LnVsop(3.0E-11, 5.38166577823, 26061.60482177439), new Vsop87.LnVsop(4.0E-11, 4.82038901276, 391318.54712361295), new Vsop87.LnVsop(3.0E-11, 0.24758758375, 28632.5757784666), new Vsop87.LnVsop(4.0E-11, 3.73245535012, 29580.4747084438), new Vsop87.LnVsop(3.0E-11, 5.50683793531, 25928.601406782), new Vsop87.LnVsop(4.0E-11, 1.30672083529, 128857.55635958798), new Vsop87.LnVsop(4.0E-11, 2.91975490767, 104358.2411251968), new Vsop87.LnVsop(3.0E-11, 4.20598772135, 52400.1510788503), new Vsop87.LnVsop(3.0E-11, 2.10934687772, 60170.3347251726), new Vsop87.LnVsop(3.0E-11, 3.58809373398, 28471.0961563504), new Vsop87.LnVsop(3.0E-11, 3.28239195135, 208276.62694171758), new Vsop87.LnVsop(3.0E-11, 2.85078808201, 27360.58416720139), new Vsop87.LnVsop(3.0E-11, 2.1758205666, 27047.0260015318), new Vsop87.LnVsop(3.0E-11, 1.50018330501, 4371.8763667742), new Vsop87.LnVsop(3.0E-11, 0.91046516994, 76468.45098100159), new Vsop87.LnVsop(3.0E-11, 5.28365186085, 2751.5475996916), new Vsop87.LnVsop(3.0E-11, 0.87901414894, 1699.2792165032), new Vsop87.LnVsop(3.0E-11, 1.88463694401, 27353.47062020059), new Vsop87.LnVsop(3.0E-11, 5.30944897904, 51554.06248230919), new Vsop87.LnVsop(3.0E-11, 1.34767282324, 1169.5882514086), new Vsop87.LnVsop(3.0E-11, 1.02260378622, 193937.9860893238), new Vsop87.LnVsop(3.0E-11, 0.08040381198, 104241.40624507738), new Vsop87.LnVsop(4.0E-11, 0.92990491519, 23735.03698780239), new Vsop87.LnVsop(3.0E-11, 0.9489374418, 25991.92391435639), new Vsop87.LnVsop(3.0E-11, 0.22588113722, 203375.74902421076), new Vsop87.LnVsop(3.0E-11, 4.57210118096, 34102.10134449819), new Vsop87.LnVsop(3.0E-11, 1.7221584207, 170068.84005193636), new Vsop87.LnVsop(3.0E-11, 0.81863700708, 78262.22495201428), new Vsop87.LnVsop(3.0E-11, 3.80268685478, 25384.26995695679), new Vsop87.LnVsop(3.0E-11, 2.04040938346, 176332.24614102798), new Vsop87.LnVsop(3.0E-11, 1.84457498582, 45455.092303807), new Vsop87.LnVsop(3.0E-11, 0.65752082616, 35679.44488694599), new Vsop87.LnVsop(3.0E-11, 5.96488404544, 52164.76058288449), new Vsop87.LnVsop(3.0E-11, 5.22098781756, 3462.2447058652), new Vsop87.LnVsop(3.0E-11, 2.07639441349, 24072.23205541439), new Vsop87.LnVsop(3.0E-11, 4.1515393198, 128843.32926558638), new Vsop87.LnVsop(3.0E-11, 4.53866780815, 28908.7342857004), new Vsop87.LnVsop(3.0E-11, 6.18743354616, 50160.82461135059), new Vsop87.LnVsop(3.0E-11, 4.26626022439, 67608.75720795698), new Vsop87.LnVsop(3.0E-11, 4.07476395108, 33917.99567300899), new Vsop87.LnVsop(3.0E-11, 4.19552535253, 149642.26895951436), new Vsop87.LnVsop(3.0E-11, 1.00306343406, 155460.9233722552), new Vsop87.LnVsop(3.0E-11, 1.95424623759, 104426.39416486409), new Vsop87.LnVsop(3.0E-11, 1.43273740893, 24719.24288872919), new Vsop87.LnVsop(3.0E-11, 4.35442914687, 38634.3850806572), new Vsop87.LnVsop(3.0E-11, 4.6455204172, 54879.422437824), new Vsop87.LnVsop(3.0E-11, 4.16961765976, 76358.24465978218), new Vsop87.LnVsop(3.0E-11, 5.81598121096, 49976.71893986139), new Vsop87.LnVsop(3.0E-11, 4.34295741397, 16964.3263865568), new Vsop87.LnVsop(3.0E-11, 2.53451860055, 51861.62010327879), new Vsop87.LnVsop(3.0E-11, 2.49492450438, 636.9962720242), new Vsop87.LnVsop(3.0E-11, 3.9217394364, 155475.15046625677), new Vsop87.LnVsop(3.0E-11, 3.12145981611, 162810.49469943656), new Vsop87.LnVsop(2.0E-11, 0.59129261912, 50951.98844236979), new Vsop87.LnVsop(3.0E-11, 1.17681439145, 52145.47942214399), new Vsop87.LnVsop(3.0E-11, 3.00732745961, 24705.01579472759), new Vsop87.LnVsop(2.0E-11, 5.95257930202, 53399.624123927), new Vsop87.LnVsop(3.0E-11, 4.63479353604, 104874.18998439058), new Vsop87.LnVsop(3.0E-11, 4.8338459343, 156523.5375140872), new Vsop87.LnVsop(2.0E-11, 3.69719041336, 24616.1501145106), new Vsop87.LnVsop(3.0E-11, 5.46916395598, 61921.12683900499), new Vsop87.LnVsop(3.0E-11, 0.61188230666, 171292.65789271498), new Vsop87.LnVsop(3.0E-11, 0.02228487735, 1.4844727083), new Vsop87.LnVsop(3.0E-11, 0.17724758311, 24510.5595991264), new Vsop87.LnVsop(3.0E-11, 4.95237759532, 102129.75593169978), new Vsop87.LnVsop(3.0E-11, 5.9906150951, 29864.334027309), new Vsop87.LnVsop(3.0E-11, 3.9301871107, 17098.43543614181), new Vsop87.LnVsop(2.0E-11, 4.2193704628, 10681.2505365654), new Vsop87.LnVsop(3.0E-11, 0.28167729696, 169093.57054942797), new Vsop87.LnVsop(2.0E-11, 3.49816744164, 51092.7260508548), new Vsop87.LnVsop(3.0E-11, 0.52178350633, 52277.768801414), new Vsop87.LnVsop(3.0E-11, 4.05955850118, 97466.46267636596), new Vsop87.LnVsop(2.0E-11, 5.23971659541, 1639.069517188), new Vsop87.LnVsop(3.0E-11, 3.80600862869, 25124.50043860279), new Vsop87.LnVsop(2.0E-11, 0.12283639421, 149756.7082481996), new Vsop87.LnVsop(2.0E-11, 0.58027608343, 27573.88326263939), new Vsop87.LnVsop(3.0E-11, 3.08645332652, 4083.9885067044), new Vsop87.LnVsop(2.0E-11, 0.63115841045, 1485.2907067032), new Vsop87.LnVsop(2.0E-11, 0.17989490547, 78597.56536549199), new Vsop87.LnVsop(3.0E-11, 4.97930287376, 180496.558130641), new Vsop87.LnVsop(2.0E-11, 0.84663844231, 163766.0944410452), new Vsop87.LnVsop(3.0E-11, 2.12660879167, 42790.9652750732), new Vsop87.LnVsop(3.0E-11, 5.24817307826, 6885.14988993081), new Vsop87.LnVsop(3.0E-11, 3.26326592296, 156531.3001848032), new Vsop87.LnVsop(3.0E-11, 4.84282671665, 49637.55777889479), new Vsop87.LnVsop(2.0E-11, 3.66265576771, 26397.18146422999), new Vsop87.LnVsop(3.0E-11, 4.15745762538, 51688.1715318942), new Vsop87.LnVsop(2.0E-11, 4.40058588833, 31127.49138988719), new Vsop87.LnVsop(2.0E-11, 4.51215350981, 52812.8025551726), new Vsop87.LnVsop(2.0E-11, 1.8561415456, 104401.60918820098), new Vsop87.LnVsop(3.0E-11, 0.24921211552, 25778.62481891839), new Vsop87.LnVsop(3.0E-11, 6.05682256137, 48153.54375118419), new Vsop87.LnVsop(2.0E-11, 4.09759047914, 24864.08530079559), new Vsop87.LnVsop(2.0E-11, 4.2796172361, 220025.88923089797), new Vsop87.LnVsop(2.0E-11, 5.31413874636, 75085.56363415498), new Vsop87.LnVsop(2.0E-11, 4.400435386, 25248.9338538238), new Vsop87.LnVsop(2.0E-11, 5.50124846637, 106470.37642667518), new Vsop87.LnVsop(2.0E-11, 1.36339547689, 6044.2285813754), new Vsop87.LnVsop(2.0E-11, 5.61481903582, 28213.78054895339), new Vsop87.LnVsop(2.0E-11, 1.71226573993, 76532.58707178998), new Vsop87.LnVsop(2.0E-11, 1.47894403485, 78265.19389743089), new Vsop87.LnVsop(2.0E-11, 2.81905656676, 63786.3582415226), new Vsop87.LnVsop(2.0E-11, 2.6682560217, 53132.09543911899), new Vsop87.LnVsop(2.0E-11, 3.58699104379, 24787.0763233692), new Vsop87.LnVsop(2.0E-11, 6.10133380039, 104035.22069664019), new Vsop87.LnVsop(2.0E-11, 3.23064508032, 130020.03106399579), new Vsop87.LnVsop(2.0E-11, 1.11637372513, 76094.94894244), new Vsop87.LnVsop(2.0E-11, 5.2466618317, 24734.1543965574), new Vsop87.LnVsop(2.0E-11, 3.73466434913, 199599.31813847594), new Vsop87.LnVsop(2.0E-11, 5.76862263272, 25661.9943650602), new Vsop87.LnVsop(2.0E-11, 4.46773900208, 26926.87242932459), new Vsop87.LnVsop(3.0E-11, 5.47127542511, 27388.72995977919), new Vsop87.LnVsop(2.0E-11, 2.48055036253, 25543.985082478), new Vsop87.LnVsop(2.0E-11, 0.28737768397, 174620.79354899516), new Vsop87.LnVsop(2.0E-11, 3.2394701043, 42430.4857272918), new Vsop87.LnVsop(2.0E-11, 1.90098213386, 20272.7922819372), new Vsop87.LnVsop(2.0E-11, 4.30589300181, 2324.9494088156), new Vsop87.LnVsop(2.0E-11, 1.33937343257, 196156.74319351057), new Vsop87.LnVsop(3.0E-11, 0.24285063924, 23113.2931869632), new Vsop87.LnVsop(2.0E-11, 0.20903760722, 177287.84588263658), new Vsop87.LnVsop(3.0E-11, 4.480207249, 156954.01704032117), new Vsop87.LnVsop(2.0E-11, 0.58830784715, 156377.8556523106), new Vsop87.LnVsop(2.0E-11, 2.17673056463, 133882.09065283637), new Vsop87.LnVsop(2.0E-11, 2.97360848608, 26235.9818660005), new Vsop87.LnVsop(2.0E-11, 2.39528557885, 104668.00443595338), new Vsop87.LnVsop(2.0E-11, 1.98009462137, 50476.52706664519), new Vsop87.LnVsop(2.0E-11, 3.7978577272, 65851.33653522459), new Vsop87.LnVsop(2.0E-11, 5.1473333277, 289185.69166150293), new Vsop87.LnVsop(2.0E-11, 3.15820059422, 207114.15223730978), new Vsop87.LnVsop(2.0E-11, 0.99424509152, 2064.978293702), new Vsop87.LnVsop(2.0E-11, 3.96748008059, 225687.22128005017), new Vsop87.LnVsop(2.0E-11, 1.75880221581, 22595.33157470459), new Vsop87.LnVsop(2.0E-11, 0.35945480523, 104301.61594439259), new Vsop87.LnVsop(2.0E-11, 4.50142650477, 21067.98465416099), new Vsop87.LnVsop(2.0E-11, 4.06761017581, 1685.0521225016), new Vsop87.LnVsop(2.0E-11, 4.80714121052, 440.8252848776), new Vsop87.LnVsop(2.0E-11, 3.69573475242, 1574.8458012822), new Vsop87.LnVsop(2.0E-11, 4.47164076488, 65538.25598994759), new Vsop87.LnVsop(2.0E-11, 5.27720278071, 24998.19435038059), new Vsop87.LnVsop(2.0E-11, 0.03956368481, 24189.5519236346), new Vsop87.LnVsop(2.0E-11, 1.88701981019, 40738.70289615879), new Vsop87.LnVsop(3.0E-11, 3.07558765849, 230239.17477710897), new Vsop87.LnVsop(2.0E-11, 2.0068296723, 28786.3545889514), new Vsop87.LnVsop(2.0E-11, 2.92175843057, 22065.64060961), new Vsop87.LnVsop(2.0E-11, 4.42508659344, 93696.66034953119), new Vsop87.LnVsop(2.0E-11, 0.02297616821, 197092.67317421938), new Vsop87.LnVsop(2.0E-11, 2.53282099987, 249268.47945736776), new Vsop87.LnVsop(2.0E-11, 1.06567957268, 21562.2479643152), new Vsop87.LnVsop(2.0E-11, 0.84740706727, 24494.89809302729), new Vsop87.LnVsop(2.0E-11, 4.28261879219, 123554.36581794015), new Vsop87.LnVsop(2.0E-11, 0.10971441902, 55484.27217852879), new Vsop87.LnVsop(2.0E-11, 0.293458378, 24765.2254940428), new Vsop87.LnVsop(2.0E-11, 3.98649649262, 24808.1085689462), new Vsop87.LnVsop(2.0E-11, 5.89087983305, 283524.3596123507), new Vsop87.LnVsop(2.0E-11, 2.29200392607, 27410.5807891056), new Vsop87.LnVsop(2.0E-11, 1.16567793728, 53551.5800829942), new Vsop87.LnVsop(2.0E-11, 1.12952757353, 25572.43927048119), new Vsop87.LnVsop(2.0E-11, 1.63321646369, 66826.60603773296), new Vsop87.LnVsop(2.0E-11, 4.53722544295, 52355.883413433), new Vsop87.LnVsop(2.0E-11, 4.30854449363, 71378.55953479178), new Vsop87.LnVsop(2.0E-11, 1.97399498955, 430.5303441391), new Vsop87.LnVsop(2.0E-11, 1.99872081555, 24932.54198416719), new Vsop87.LnVsop(2.0E-11, 4.55759105401, 49850.85687433279), new Vsop87.LnVsop(2.0E-11, 0.37032643194, 26500.27423844859), new Vsop87.LnVsop(2.0E-11, 3.83442901458, 307.5576209696), new Vsop87.LnVsop(2.0E-11, 5.81356382743, 51538.81001112419), new Vsop87.LnVsop(2.0E-11, 2.06311358499, 23233.262767664), new Vsop87.LnVsop(2.0E-11, 2.21513587213, 25675.5320446998), new Vsop87.LnVsop(2.0E-11, 1.86537837885, 2703.6161546756), new Vsop87.LnVsop(2.0E-11, 4.36625276614, 41520.8540663828), new Vsop87.LnVsop(2.0E-11, 2.41635418383, 26713.57333388659), new Vsop87.LnVsop(2.0E-11, 5.53696157861, 87253.17713015496), new Vsop87.LnVsop(2.0E-11, 0.54252317353, 3.881335358), new Vsop87.LnVsop(2.0E-11, 4.25487079347, 90989.16285949759), new Vsop87.LnVsop(2.0E-11, 4.42845015108, 158116.491744729), new Vsop87.LnVsop(2.0E-11, 2.30331517982, 27883.16158529519), new Vsop87.LnVsop(2.0E-11, 2.98672680729, 57369.17334194619), new Vsop87.LnVsop(2.0E-11, 6.08199781417, 18043.37807764579), new Vsop87.LnVsop(2.0E-11, 0.73324052336, 25757.28417791599), new Vsop87.LnVsop(2.0E-11, 6.16225556919, 49.9966219042), new Vsop87.LnVsop(2.0E-11, 6.04230640954, 78115.63070029629), new Vsop87.LnVsop(2.0E-11, 2.01671299774, 46564.4708559004), new Vsop87.LnVsop(2.0E-11, 2.52858429504, 26140.99929388859), new Vsop87.LnVsop(2.0E-11, 4.60594242656, 52336.2136525332), new Vsop87.LnVsop(2.0E-11, 4.0753148716, 51734.98099827079), new Vsop87.LnVsop(2.0E-11, 5.76630255453, 78373.91574594198), new Vsop87.LnVsop(2.0E-11, 0.16910812024, 25462.2329492618), new Vsop87.LnVsop(2.0E-11, 0.29867787782, 107692.22499299659), new Vsop87.LnVsop(2.0E-11, 0.08977124652, 25135.8265183146), new Vsop87.LnVsop(2.0E-11, 6.02059582335, 164721.69418265377), new Vsop87.LnVsop(2.0E-11, 2.48908964809, 13705.8571130806), new Vsop87.LnVsop(2.0E-11, 3.07002924674, 23432.33476910039), new Vsop87.LnVsop(2.0E-11, 3.46681243572, 154408.65498906677), new Vsop87.LnVsop(2.0E-11, 0.05687800902, 26034.8069892598), new Vsop87.LnVsop(2.0E-11, 0.04904063753, 229463.65216578494), new Vsop87.LnVsop(2.0E-11, 4.28354458896, 24484.60315228879), new Vsop87.LnVsop(2.0E-11, 1.75454322097, 78697.42116259939), new Vsop87.LnVsop(2.0E-11, 4.02876141227, 26238.95081141709), new Vsop87.LnVsop(2.0E-11, 3.24222429199, 21509.65132471559), new Vsop87.LnVsop(2.0E-11, 1.81543335689, 87648.55043279778), new Vsop87.LnVsop(2.0E-11, 2.07300031744, 53654.67285721279), new Vsop87.LnVsop(2.0E-11, 2.52315832958, 210614.42461581077), new Vsop87.LnVsop(2.0E-11, 2.32677216347, 54862.5283776896), new Vsop87.LnVsop(2.0E-11, 3.03967372772, 104771.09721017198), new Vsop87.LnVsop(2.0E-11, 5.0702262377, 78112.66175487968), new Vsop87.LnVsop(2.0E-11, 1.10376435729, 50912.6489205702), new Vsop87.LnVsop(2.0E-11, 3.46489468484, 78905.12298646157), new Vsop87.LnVsop(2.0E-11, 0.67835568542, 235746.72801577637), new Vsop87.LnVsop(2.0E-11, 3.79260774499, 3308.4658953804), new Vsop87.LnVsop(2.0E-11, 5.85661754245, 2974.609954611), new Vsop87.LnVsop(2.0E-11, 2.25512645553, 77929.8534839532), new Vsop87.LnVsop(2.0E-11, 5.18613735503, 50600.9604818662), new Vsop87.LnVsop(2.0E-11, 2.56189724502, 76064.62208143558), new Vsop87.LnVsop(2.0E-11, 4.05996888958, 24502.76239955349), new Vsop87.LnVsop(2.0E-11, 5.5387703997, 51040.1294112552), new Vsop87.LnVsop(2.0E-11, 0.76026031493, 1802.3719907218), new Vsop87.LnVsop(2.0E-11, 4.62411854151, 247223.17092456558), new Vsop87.LnVsop(2.0E-11, 0.05336994875, 146505.58156934578), new Vsop87.LnVsop(2.0E-11, 5.61214825198, 34082.4315835984), new Vsop87.LnVsop(1.0E-11, 5.70524522839, 52072.0240945678), new Vsop87.LnVsop(1.0E-11, 5.47105937931, 50690.51557644519), new Vsop87.LnVsop(2.0E-11, 1.73035919617, 99979.7361995226), new Vsop87.LnVsop(2.0E-11, 5.62955025847, 21819.80896338059), new Vsop87.LnVsop(1.0E-11, 5.12943475162, 23704.71012679799), new Vsop87.LnVsop(1.0E-11, 3.55982710637, 209658.82487420217), new Vsop87.LnVsop(2.0E-11, 0.1124953909, 38469.94917006779), new Vsop87.LnVsop(2.0E-11, 4.348230976, 148532.89040742096), new Vsop87.LnVsop(2.0E-11, 4.7038211131, 50490.75416064679), new Vsop87.LnVsop(1.0E-11, 2.70277319349, 78249.48233072099), new Vsop87.LnVsop(2.0E-11, 0.62470424533, 51745.27593900929), new Vsop87.LnVsop(2.0E-11, 2.5007782763, 179966.86716554637), new Vsop87.LnVsop(1.0E-11, 4.52201346507, 98575.84122845937), new Vsop87.LnVsop(2.0E-11, 6.07032776125, 74935.5737684424), new Vsop87.LnVsop(1.0E-11, 3.751226119, 76352.50994150538), new Vsop87.LnVsop(2.0E-11, 5.33836077527, 106684.80895916879), new Vsop87.LnVsop(1.0E-11, 0.71806518278, 28928.40404660019)};
        private static Vsop87.LnVsop[] mercury_radius_r1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.0021734774, 4.65617158665, 26087.9031415742), new Vsop87.LnVsop(4.4141826E-4, 1.42385544001, 52175.8062831484), new Vsop87.LnVsop(1.0094479E-4, 4.47466326327, 78263.70942472259), new Vsop87.LnVsop(2.432805E-5, 1.24226083323, 104351.61256629678), new Vsop87.LnVsop(1.624367E-5, 0.0, 0.0), new Vsop87.LnVsop(6.03996E-6, 4.29303116468, 130439.51570787099), new Vsop87.LnVsop(1.52851E-6, 1.06060778072, 156527.41884944518), new Vsop87.LnVsop(3.9202E-7, 4.11136733071, 182615.3219910194), new Vsop87.LnVsop(1.776E-7, 4.54424729034, 27197.2816936676), new Vsop87.LnVsop(1.7999E-7, 4.71193597233, 24978.5245894808), new Vsop87.LnVsop(1.0154E-7, 0.87893540982, 208703.2251325936), new Vsop87.LnVsop(8.086E-8, 3.00540629863, 25028.521211385), new Vsop87.LnVsop(4.444E-8, 2.13638817844, 20426.571092422), new Vsop87.LnVsop(4.393E-8, 1.48073536997, 51066.427731055), new Vsop87.LnVsop(3.51E-8, 3.21169312709, 1059.3819301892), new Vsop87.LnVsop(3.133E-8, 5.23846816226, 21535.9496445154), new Vsop87.LnVsop(2.65E-8, 3.92968869319, 234791.12827416777), new Vsop87.LnVsop(2.498E-8, 2.02627371234, 24498.8302462904), new Vsop87.LnVsop(2.011E-8, 1.23910805857, 53285.1848352418), new Vsop87.LnVsop(1.963E-8, 4.04525058702, 5661.3320491522), new Vsop87.LnVsop(1.546E-8, 2.61850768654, 26617.5941066688), new Vsop87.LnVsop(1.542E-8, 2.35662446357, 27043.5028831828), new Vsop87.LnVsop(1.418E-8, 1.37877634525, 1109.3785520934), new Vsop87.LnVsop(1.295E-8, 5.19094994605, 46514.4742339962), new Vsop87.LnVsop(1.241E-8, 0.21244114624, 11322.6640983044), new Vsop87.LnVsop(1.09E-8, 6.23729220424, 27147.28507176339), new Vsop87.LnVsop(1.271E-8, 0.56438178969, 25132.3033999656), new Vsop87.LnVsop(1.12E-8, 0.8637258292, 57837.1383323006), new Vsop87.LnVsop(1.005E-8, 3.28270573299, 37410.5672398786), new Vsop87.LnVsop(1.177E-8, 4.53194587462, 77154.33087262919), new Vsop87.LnVsop(8.41E-9, 5.96255043354, 14765.2390432698), new Vsop87.LnVsop(9.35E-9, 2.3727729384, 25661.3049506982), new Vsop87.LnVsop(7.43E-9, 0.77744171599, 32858.61374281979), new Vsop87.LnVsop(7.36E-9, 4.06886325615, 1589.0728952838), new Vsop87.LnVsop(7.13E-9, 2.70877599555, 16983.9961474566), new Vsop87.LnVsop(8.63E-9, 5.55319075962, 25558.2121764796), new Vsop87.LnVsop(7.07E-9, 0.92994379913, 30639.856638633), new Vsop87.LnVsop(6.96E-9, 0.6973460978, 260879.03141574195), new Vsop87.LnVsop(6.78E-9, 2.02192026554, 26068.2333806744), new Vsop87.LnVsop(6.08E-9, 0.85717026702, 4551.9534970588), new Vsop87.LnVsop(5.45E-9, 5.38146993956, 26091.7844769322), new Vsop87.LnVsop(6.08E-9, 3.65993695204, 25448.00585526019), new Vsop87.LnVsop(5.97E-9, 4.64866860427, 26080.78959457339), new Vsop87.LnVsop(5.72E-9, 3.50127448259, 10213.285546211), new Vsop87.LnVsop(5.15E-9, 4.83661700395, 50586.73338786459), new Vsop87.LnVsop(5.32E-9, 5.21858845471, 22645.32819660879), new Vsop87.LnVsop(5.72E-9, 0.62744603883, 13521.7514415914), new Vsop87.LnVsop(5.17E-9, 3.89429240358, 83925.0414738748), new Vsop87.LnVsop(5.07E-9, 5.55468086446, 12566.1516999828), new Vsop87.LnVsop(6.06E-9, 4.50209900884, 28306.66024576099), new Vsop87.LnVsop(5.33E-9, 0.93585445428, 26107.57290247399), new Vsop87.LnVsop(4.35E-9, 5.79040236288, 43071.8992890308), new Vsop87.LnVsop(4.36E-9, 5.86661030748, 25035.6347583858), new Vsop87.LnVsop(4.29E-9, 0.26257002232, 36301.18868778519), new Vsop87.LnVsop(4.72E-9, 6.0051200608, 77204.32749453338), new Vsop87.LnVsop(4.43E-9, 3.86746180481, 26084.0218062162), new Vsop87.LnVsop(4.87E-9, 4.23944310239, 26095.016688575), new Vsop87.LnVsop(4.06E-9, 5.60324675895, 52705.49724824299), new Vsop87.LnVsop(5.24E-9, 0.06435802551, 25021.4076643842), new Vsop87.LnVsop(3.79E-9, 1.95636892131, 72602.37737557039), new Vsop87.LnVsop(3.9E-9, 3.81996113063, 426.598190876), new Vsop87.LnVsop(4.18E-9, 2.77521264952, 41962.5207369374), new Vsop87.LnVsop(4.53E-9, 0.72806552601, 529.6909650946), new Vsop87.LnVsop(3.58E-9, 6.00165773999, 33326.5787331742), new Vsop87.LnVsop(3.47E-9, 1.39489736517, 23969.1392811958), new Vsop87.LnVsop(3.4E-9, 0.24130963838, 26301.2022370122), new Vsop87.LnVsop(3.25E-9, 4.78755454456, 23869.1460373874), new Vsop87.LnVsop(2.9E-9, 3.04040767889, 53235.18821333759), new Vsop87.LnVsop(3.26E-9, 1.30032135752, 103242.2340142034), new Vsop87.LnVsop(3.16E-9, 2.22800622388, 19317.1925403286), new Vsop87.LnVsop(2.64E-9, 3.93162118303, 6770.7106012456), new Vsop87.LnVsop(3.32E-9, 3.59225598431, 51220.20654153979), new Vsop87.LnVsop(2.23E-9, 2.76527165172, 103292.23063610759), new Vsop87.LnVsop(2.15E-9, 3.98001918299, 56727.7597802072), new Vsop87.LnVsop(2.35E-9, 2.24084854536, 25874.6040461362), new Vsop87.LnVsop(2.15E-9, 6.16644528217, 51646.11531805379), new Vsop87.LnVsop(2.08E-9, 2.74550745517, 40853.142184844), new Vsop87.LnVsop(2.04E-9, 3.44662595112, 9103.9069941176), new Vsop87.LnVsop(1.97E-9, 0.80045639402, 27676.976036858), new Vsop87.LnVsop(1.96E-9, 1.99906300504, 48733.23133818299), new Vsop87.LnVsop(2.05E-9, 3.20834398876, 18849.2275499742), new Vsop87.LnVsop(2.18E-9, 2.11855599471, 73711.75592766379), new Vsop87.LnVsop(1.89E-9, 0.65683523675, 110012.94461544899), new Vsop87.LnVsop(2.07E-9, 5.89089887294, 31749.2351907264), new Vsop87.LnVsop(1.84E-9, 3.74833520338, 286966.9345573162), new Vsop87.LnVsop(1.74E-9, 5.8126132215, 68050.42387851159), new Vsop87.LnVsop(1.63E-9, 4.00374821064, 79373.087976816), new Vsop87.LnVsop(1.52E-9, 5.07392487296, 52156.1365222486), new Vsop87.LnVsop(1.51E-9, 2.83396005215, 955.5997416086), new Vsop87.LnVsop(1.51E-9, 0.40937127334, 26514.5013324502), new Vsop87.LnVsop(1.47E-9, 2.32188363628, 38654.05484155699), new Vsop87.LnVsop(1.54E-9, 3.26432452388, 38519.945791972), new Vsop87.LnVsop(1.85E-9, 0.98990596875, 29530.4780865396), new Vsop87.LnVsop(1.5E-9, 3.69227943541, 65697.55772473979), new Vsop87.LnVsop(1.32E-9, 2.71821268672, 77734.01845962799), new Vsop87.LnVsop(1.4E-9, 2.05758999121, 6283.0758499914), new Vsop87.LnVsop(1.22E-9, 3.31360115889, 62389.09182935939), new Vsop87.LnVsop(1.23E-9, 2.0794046779, 25668.418497699), new Vsop87.LnVsop(1.18E-9, 0.51915032422, 51535.90899683439), new Vsop87.LnVsop(1.2E-9, 2.15439400962, 52179.6876185064), new Vsop87.LnVsop(1.52E-9, 2.66001905502, 25654.19140369739), new Vsop87.LnVsop(1.13E-9, 2.33266633795, 78793.40038981718), new Vsop87.LnVsop(1.24E-9, 3.13057843195, 51109.31080595839), new Vsop87.LnVsop(1.5E-9, 2.60372699526, 639.897286314), new Vsop87.LnVsop(1.24E-9, 2.65134648993, 51123.53789995999), new Vsop87.LnVsop(1.06E-9, 1.3144408878, 47623.8527860896), new Vsop87.LnVsop(1.12E-9, 5.00800079212, 98690.28051714458), new Vsop87.LnVsop(1.07E-9, 5.12874134815, 99799.65906923798), new Vsop87.LnVsop(1.23E-9, 6.13777841633, 1066.49547719), new Vsop87.LnVsop(1.06E-9, 1.42968371953, 52168.69273614759), new Vsop87.LnVsop(1.04E-9, 4.51535298285, 25234.70675982219), new Vsop87.LnVsop(1.2E-9, 4.0657546826, 45892.73043315699), new Vsop87.LnVsop(9.3E-10, 4.72793717538, 2118.7638603784), new Vsop87.LnVsop(1.12E-9, 4.78989437046, 53131.406024757), new Vsop87.LnVsop(9.6E-10, 5.03480533398, 32370.9789915656), new Vsop87.LnVsop(9.1E-10, 4.22087947367, 50057.04242277), new Vsop87.LnVsop(1.07E-9, 0.14589408309, 12432.0426503978), new Vsop87.LnVsop(9.1E-10, 4.35426331615, 129330.13715577759), new Vsop87.LnVsop(8.4E-10, 0.32895187929, 1052.2683831884), new Vsop87.LnVsop(8.4E-10, 5.81466213086, 129380.13377768178), new Vsop87.LnVsop(9.2E-10, 0.34545636827, 77308.10968311399), new Vsop87.LnVsop(7.8E-10, 1.17740935265, 76674.63652943878), new Vsop87.LnVsop(1.07E-9, 1.01247025157, 52182.9198301492), new Vsop87.LnVsop(8.2E-10, 6.11430864932, 79323.09135491178), new Vsop87.LnVsop(8.6E-10, 2.50452244748, 7238.6755916), new Vsop87.LnVsop(7.2E-10, 1.56149801558, 49957.0491789616), new Vsop87.LnVsop(7.6E-10, 1.62516369719, 15874.6175953632), new Vsop87.LnVsop(9.0E-10, 5.75449025797, 24491.71669928959), new Vsop87.LnVsop(9.2E-10, 3.97742380655, 52195.47604404819), new Vsop87.LnVsop(6.8E-10, 0.44537901082, 91785.46086631398), new Vsop87.LnVsop(7.8E-10, 0.63568556169, 52171.9249477904), new Vsop87.LnVsop(6.4E-10, 2.57343416459, 94138.32702008578), new Vsop87.LnVsop(6.5E-10, 2.12923498203, 7.1135470008), new Vsop87.LnVsop(6.2E-10, 3.70758538046, 136100.84775702318), new Vsop87.LnVsop(6.8E-10, 1.18992116627, 54394.56338733519), new Vsop87.LnVsop(7.9E-10, 3.35587970544, 52389.1053785864), new Vsop87.LnVsop(6.0E-10, 6.26094287016, 24505.94379329119), new Vsop87.LnVsop(6.5E-10, 5.09697559988, 51962.5071877104), new Vsop87.LnVsop(6.1E-10, 0.7386364712, 82815.66292178139), new Vsop87.LnVsop(6.3E-10, 1.29903752227, 2218.7571041868), new Vsop87.LnVsop(7.0E-10, 5.28679522332, 45405.0956819028), new Vsop87.LnVsop(5.4E-10, 0.89790115044, 71980.63357473118), new Vsop87.LnVsop(5.7E-10, 1.92411310638, 20760.4270331914), new Vsop87.LnVsop(5.1E-10, 4.71610129635, 105460.99111839019), new Vsop87.LnVsop(5.4E-10, 6.22074076941, 44937.1306915484), new Vsop87.LnVsop(5.2E-10, 3.43154581427, 25551.09862947879), new Vsop87.LnVsop(5.2E-10, 5.77926746609, 66941.04532641819), new Vsop87.LnVsop(4.8E-10, 0.51820543805, 313054.83769889036), new Vsop87.LnVsop(5.2E-10, 5.71872770622, 103821.92160120218), new Vsop87.LnVsop(4.7E-10, 3.82177422106, 53764.8791784322), new Vsop87.LnVsop(5.0E-10, 5.75583590982, 25938.3399444396), new Vsop87.LnVsop(4.7E-10, 5.527762227, 77837.11123384659), new Vsop87.LnVsop(4.3E-10, 5.84980653694, 63498.47038145279), new Vsop87.LnVsop(5.2E-10, 2.63480617664, 18093.37469954999), new Vsop87.LnVsop(4.2E-10, 5.39170998784, 64741.95798313119), new Vsop87.LnVsop(4.1E-10, 1.87436617947, 125887.56221081219), new Vsop87.LnVsop(4.5E-10, 4.04573573351, 55618.3812281138), new Vsop87.LnVsop(3.9E-10, 3.50885173288, 52602.4044740244), new Vsop87.LnVsop(5.1E-10, 6.02412463531, 13655.8604911764), new Vsop87.LnVsop(4.8E-10, 0.72398672501, 33967.99229491319), new Vsop87.LnVsop(3.8E-10, 0.09228296016, 88476.99497093359), new Vsop87.LnVsop(3.8E-10, 1.84192926335, 78244.0396638228), new Vsop87.LnVsop(4.1E-10, 5.74762731223, 26727.8004278882), new Vsop87.LnVsop(4.5E-10, 5.73856748504, 44181.27784112419), new Vsop87.LnVsop(3.8E-10, 5.1773164872, 23754.70674870219), new Vsop87.LnVsop(3.5E-10, 0.81850559713, 23439.44831610119), new Vsop87.LnVsop(3.6E-10, 4.81776409496, 51116.4243529592), new Vsop87.LnVsop(4.1E-10, 2.91924856282, 26241.681952059), new Vsop87.LnVsop(3.2E-10, 1.91980495251, 58458.88213313979), new Vsop87.LnVsop(3.3E-10, 1.27537006504, 131548.89425996438), new Vsop87.LnVsop(3.1E-10, 5.02484981561, 46848.3301747656), new Vsop87.LnVsop(3.0E-10, 3.95195102074, 26555.8681319286), new Vsop87.LnVsop(3.1E-10, 1.17956097833, 59414.4818747484), new Vsop87.LnVsop(3.0E-10, 0.55660013087, 3442.5749449654), new Vsop87.LnVsop(3.3E-10, 5.35914498696, 104881.30353139139), new Vsop87.LnVsop(3.4E-10, 3.55545989401, 433.7117378768), new Vsop87.LnVsop(3.0E-10, 1.25027037776, 26202.34243025941), new Vsop87.LnVsop(2.9E-10, 2.98819043245, 27154.3986187642), new Vsop87.LnVsop(3.5E-10, 3.23315937408, 25455.119402261), new Vsop87.LnVsop(3.3E-10, 3.55107682453, 25440.89230825939), new Vsop87.LnVsop(2.8E-10, 4.36009500774, 80482.46652890938), new Vsop87.LnVsop(3.3E-10, 1.77301132586, 124778.18365871879), new Vsop87.LnVsop(2.9E-10, 0.03485368228, 79219.3091663312), new Vsop87.LnVsop(3.0E-10, 5.14824322621, 51756.3216392732), new Vsop87.LnVsop(2.7E-10, 2.59987755832, 155468.036919256), new Vsop87.LnVsop(2.7E-10, 1.05618361621, 28421.0995344462), new Vsop87.LnVsop(3.0E-10, 5.72049964303, 51742.09454527159), new Vsop87.LnVsop(2.9E-10, 5.20497301981, 78267.59076008058), new Vsop87.LnVsop(3.0E-10, 6.10164768471, 26011.6370702986), new Vsop87.LnVsop(2.6E-10, 1.11277156957, 155418.04029735178), new Vsop87.LnVsop(2.7E-10, 3.38581716378, 103396.01282468818), new Vsop87.LnVsop(2.5E-10, 3.48854332661, 117873.36400788819), new Vsop87.LnVsop(2.6E-10, 6.19594686594, 77197.21394753258), new Vsop87.LnVsop(2.5E-10, 1.70207039258, 25973.46385288896), new Vsop87.LnVsop(2.3E-10, 1.48784027849, 28206.6670019526), new Vsop87.LnVsop(2.3E-10, 3.86573027322, 16066.0658614748), new Vsop87.LnVsop(2.7E-10, 4.06662296312, 78270.82297172339), new Vsop87.LnVsop(2.2E-10, 4.03831631421, 419.4846438752), new Vsop87.LnVsop(2.3E-10, 3.38647417024, 58946.51688439399), new Vsop87.LnVsop(2.2E-10, 1.34032161201, 51322.60990139639), new Vsop87.LnVsop(2.3E-10, 2.24016677563, 103925.01437542078), new Vsop87.LnVsop(2.4E-10, 3.67307410546, 26610.48055966799), new Vsop87.LnVsop(2.1E-10, 4.49579658422, 78256.59587772179), new Vsop87.LnVsop(2.1E-10, 3.69230315983, 77623.81213840858), new Vsop87.LnVsop(2.8E-10, 5.71579741424, 77211.44104153418), new Vsop87.LnVsop(2.0E-10, 3.97824189549, 98068.53671630539), new Vsop87.LnVsop(2.0E-10, 5.61186204564, 120226.23016165999), new Vsop87.LnVsop(2.4E-10, 1.72755836618, 853.196381752), new Vsop87.LnVsop(2.0E-10, 6.15795630851, 213.299095438), new Vsop87.LnVsop(2.4E-10, 2.89550770232, 105410.99449648599), new Vsop87.LnVsop(2.1E-10, 0.42057491496, 149.5631971346), new Vsop87.LnVsop(2.0E-10, 4.41593605146, 29416.03879785439), new Vsop87.LnVsop(2.4E-10, 2.43647861768, 50579.61984086379), new Vsop87.LnVsop(2.0E-10, 0.62149243389, 85034.42002596818), new Vsop87.LnVsop(2.1E-10, 0.18471197727, 35191.8101356918), new Vsop87.LnVsop(2.0E-10, 0.48534032212, 162188.75089859738), new Vsop87.LnVsop(1.9E-10, 2.391348992, 26037.90651966999), new Vsop87.LnVsop(1.8E-10, 4.60102058427, 76044.9523205358), new Vsop87.LnVsop(1.8E-10, 3.06506502101, 50593.84693486539), new Vsop87.LnVsop(2.2E-10, 0.44685187346, 1596.1864422846), new Vsop87.LnVsop(1.9E-10, 3.5904344951, 27140.17152476259), new Vsop87.LnVsop(1.9E-10, 1.77495862092, 78050.41032928458), new Vsop87.LnVsop(2.1E-10, 0.16420917914, 78477.00852016058), new Vsop87.LnVsop(2.1E-10, 3.45801523273, 102762.53967101299), new Vsop87.LnVsop(1.8E-10, 1.82673294922, 25565.3257234804), new Vsop87.LnVsop(2.2E-10, 4.62812554933, 19406.6782881746), new Vsop87.LnVsop(1.9E-10, 5.28521008361, 26624.70765366959), new Vsop87.LnVsop(1.9E-10, 2.69563356202, 105307.21230790539), new Vsop87.LnVsop(1.6E-10, 4.38108594875, 25131.61398560359), new Vsop87.LnVsop(1.8E-10, 4.12920214042, 5327.4761083828), new Vsop87.LnVsop(1.8E-10, 1.12132022143, 76144.94556434419), new Vsop87.LnVsop(1.5E-10, 0.52310488443, 42153.969003049), new Vsop87.LnVsop(1.8E-10, 2.04183547601, 71492.99882347698), new Vsop87.LnVsop(1.8E-10, 0.72265923388, 78283.37918562238), new Vsop87.LnVsop(2.0E-10, 3.87063422695, 51749.20809227239), new Vsop87.LnVsop(1.4E-10, 0.06668257964, 25984.8103673556), new Vsop87.LnVsop(1.8E-10, 3.79515954928, 108903.56606335558), new Vsop87.LnVsop(1.4E-10, 4.25123740486, 157636.79740153858), new Vsop87.LnVsop(1.4E-10, 2.30100270598, 18207.81398823521), new Vsop87.LnVsop(1.9E-10, 2.52491398171, 129909.82474277639), new Vsop87.LnVsop(1.3E-10, 4.91446105451, 151975.46535238638), new Vsop87.LnVsop(1.4E-10, 3.82631305037, 7880.08915333899), new Vsop87.LnVsop(1.5E-10, 1.42348252663, 40565.2543247742), new Vsop87.LnVsop(1.4E-10, 0.49847426695, 26137.8997634784), new Vsop87.LnVsop(1.6E-10, 1.93614457319, 49842.60989027639), new Vsop87.LnVsop(1.4E-10, 1.6831548602, 6681.2248533996), new Vsop87.LnVsop(1.6E-10, 2.97339589661, 71025.0338331226), new Vsop87.LnVsop(1.3E-10, 0.09179476261, 76.2660712756), new Vsop87.LnVsop(1.3E-10, 2.1878908334, 90829.86112470538), new Vsop87.LnVsop(1.2E-10, 2.17529291977, 29428.515568274), new Vsop87.LnVsop(1.3E-10, 0.55788178178, 79852.78232000639), new Vsop87.LnVsop(1.6E-10, 3.67857856689, 78259.82808936459), new Vsop87.LnVsop(1.3E-10, 3.16115557204, 25881.717593137), new Vsop87.LnVsop(1.2E-10, 3.49193422292, 64607.84893354619), new Vsop87.LnVsop(1.2E-10, 0.81761525395, 81706.28436968799), new Vsop87.LnVsop(1.2E-10, 0.31632203314, 78690.30761559859), new Vsop87.LnVsop(1.2E-10, 2.09762480906, 24609.0365675098), new Vsop87.LnVsop(1.5E-10, 2.58203356183, 93028.94846799239), new Vsop87.LnVsop(1.2E-10, 3.14266169479, 114564.89811250778), new Vsop87.LnVsop(1.3E-10, 3.56100116701, 339142.7408404646), new Vsop87.LnVsop(1.1E-10, 0.04545445248, 19804.8272915828), new Vsop87.LnVsop(1.1E-10, 4.95969052565, 84546.78527471398), new Vsop87.LnVsop(1.1E-10, 2.38972392013, 10021.8372800994), new Vsop87.LnVsop(1.1E-10, 3.22945823005, 90695.75207512038), new Vsop87.LnVsop(1.2E-10, 0.71734482256, 26294.08869001139), new Vsop87.LnVsop(1.0E-10, 2.92861070824, 536.8045120954), new Vsop87.LnVsop(1.1E-10, 1.78852128558, 69159.80243060499), new Vsop87.LnVsop(1.0E-10, 1.89783740289, 24925.4284371664), new Vsop87.LnVsop(1.1E-10, 3.48412644818, 7994.5284420242), new Vsop87.LnVsop(1.2E-10, 0.12617932392, 51543.0225438352), new Vsop87.LnVsop(1.0E-10, 3.60589886808, 49527.35145767539), new Vsop87.LnVsop(1.2E-10, 6.27492199816, 1581.959348283), new Vsop87.LnVsop(1.2E-10, 6.05888678029, 52329.58509363319), new Vsop87.LnVsop(9.0E-11, 5.35262821933, 2648.454825473), new Vsop87.LnVsop(1.1E-10, 1.66471845038, 26507.38778544939), new Vsop87.LnVsop(1.0E-10, 2.53893582711, 52815.7035694624), new Vsop87.LnVsop(9.0E-11, 5.25424591978, 130012.91751699499), new Vsop87.LnVsop(1.0E-10, 5.63677389632, 181555.94006083018), new Vsop87.LnVsop(1.1E-10, 4.93443540854, 104331.94280539699), new Vsop87.LnVsop(9.0E-11, 0.35849773025, 26521.614879451), new Vsop87.LnVsop(1.0E-10, 2.79816937867, 39743.7636327506), new Vsop87.LnVsop(9.0E-11, 0.7122022537, 25764.39772491679), new Vsop87.LnVsop(1.0E-10, 1.17340335585, 25934.1243310894), new Vsop87.LnVsop(9.0E-11, 3.20002719704, 39629.32434406539), new Vsop87.LnVsop(8.0E-11, 4.19761308993, 181505.94343892598), new Vsop87.LnVsop(1.0E-10, 2.48682113937, 103299.34418310839), new Vsop87.LnVsop(1.1E-10, 0.22893201377, 51639.00177105299), new Vsop87.LnVsop(8.0E-11, 0.16348041588, 129483.91596626239), new Vsop87.LnVsop(9.0E-11, 0.30337489561, 27999.1026247914), new Vsop87.LnVsop(9.0E-11, 3.99498377108, 522.5774180938), new Vsop87.LnVsop(8.0E-11, 2.54138408889, 26190.99591579279), new Vsop87.LnVsop(1.1E-10, 5.95249130311, 38813.3565763492), new Vsop87.LnVsop(8.0E-11, 3.31854576667, 24395.7374720718), new Vsop87.LnVsop(8.0E-11, 4.6466238439, 26094.53170047421), new Vsop87.LnVsop(1.1E-10, 4.84765242606, 150866.08680029298), new Vsop87.LnVsop(8.0E-11, 5.11571024014, 25619.9381512198), new Vsop87.LnVsop(8.0E-11, 0.71596259507, 52643.7712735028), new Vsop87.LnVsop(8.0E-11, 1.19651473439, 25867.49049913539), new Vsop87.LnVsop(8.0E-11, 0.31282225043, 51528.79544983359), new Vsop87.LnVsop(8.0E-11, 5.8965437978, 23976.2528281966), new Vsop87.LnVsop(1.0E-10, 2.11360383925, 130969.20667296558), new Vsop87.LnVsop(8.0E-11, 4.88364028664, 22759.76748529401), new Vsop87.LnVsop(7.0E-11, 0.23623382371, 143961.2671494624), new Vsop87.LnVsop(7.0E-11, 0.85604718929, 104358.72611329758), new Vsop87.LnVsop(9.0E-11, 3.29913653682, 12725.453434775), new Vsop87.LnVsop(7.0E-11, 3.46214563345, 26237.46633870879), new Vsop87.LnVsop(7.0E-11, 6.03210574641, 53242.3017603384), new Vsop87.LnVsop(7.0E-11, 2.37810032854, 146314.13330323418), new Vsop87.LnVsop(7.0E-11, 3.13316977597, 632.7837393132), new Vsop87.LnVsop(7.0E-11, 2.54301544837, 77829.99768684579), new Vsop87.LnVsop(7.0E-11, 0.73956927174, 124156.43985787958), new Vsop87.LnVsop(7.0E-11, 3.7002649473, 85502.38501632259), new Vsop87.LnVsop(7.0E-11, 5.62145437858, 131395.11544947958), new Vsop87.LnVsop(8.0E-11, 1.94555311267, 77844.22478084739), new Vsop87.LnVsop(7.0E-11, 5.14149225737, 35472.7441496494), new Vsop87.LnVsop(8.0E-11, 3.48926584442, 25863.55834587229), new Vsop87.LnVsop(8.0E-11, 1.49877323045, 26081.27458267419), new Vsop87.LnVsop(8.0E-11, 5.18714163199, 23962.02573419499), new Vsop87.LnVsop(9.0E-11, 2.01436615102, 104355.49390165479), new Vsop87.LnVsop(6.0E-11, 3.29980048581, 104564.91166173479), new Vsop87.LnVsop(7.0E-11, 2.0378526697, 100909.03762133139), new Vsop87.LnVsop(7.0E-11, 0.57886086091, 86143.79857806159), new Vsop87.LnVsop(6.0E-11, 5.26631894455, 50696.93970908399), new Vsop87.LnVsop(6.0E-11, 4.15417610256, 54509.0026760204), new Vsop87.LnVsop(6.0E-11, 4.43201408602, 54294.57014352679), new Vsop87.LnVsop(7.0E-11, 4.34076115792, 52290.24557183361), new Vsop87.LnVsop(6.0E-11, 3.56561263718, 27684.0895838588), new Vsop87.LnVsop(8.0E-11, 5.96307679067, 131498.89763806018), new Vsop87.LnVsop(6.0E-11, 0.71203388696, 89586.37352302698), new Vsop87.LnVsop(7.0E-11, 4.87238413087, 26941.0995233262), new Vsop87.LnVsop(7.0E-11, 3.86685146587, 34282.1784747828), new Vsop87.LnVsop(6.0E-11, 5.78409267205, 70269.18098269838), new Vsop87.LnVsop(6.0E-11, 1.41633910671, 102132.85546210999), new Vsop87.LnVsop(7.0E-11, 3.58295941315, 188276.6540401716), new Vsop87.LnVsop(6.0E-11, 4.72373191376, 104138.31347085879), new Vsop87.LnVsop(6.0E-11, 4.58647990894, 25977.69682035479), new Vsop87.LnVsop(6.0E-11, 5.13295981391, 97580.90196505119), new Vsop87.LnVsop(7.0E-11, 6.19371116461, 128850.44281258718), new Vsop87.LnVsop(7.0E-11, 2.66802033812, 647.0108333148), new Vsop87.LnVsop(5.0E-11, 0.04375887104, 13541.42120249119), new Vsop87.LnVsop(6.0E-11, 0.33123091213, 26308.315784013), new Vsop87.LnVsop(5.0E-11, 5.56381967808, 96357.08412427259), new Vsop87.LnVsop(5.0E-11, 4.80464589535, 51013.33157874059), new Vsop87.LnVsop(6.0E-11, 5.53758966617, 155997.72788435058), new Vsop87.LnVsop(5.0E-11, 5.60807429033, 76667.52298243798), new Vsop87.LnVsop(6.0E-11, 4.28669891744, 14477.3511832), new Vsop87.LnVsop(5.0E-11, 3.1958020693, 26164.1692128498), new Vsop87.LnVsop(5.0E-11, 2.77179581202, 224.3447957019), new Vsop87.LnVsop(5.0E-11, 5.49690701497, 52125.80966124419), new Vsop87.LnVsop(6.0E-11, 3.04296474364, 13362.4497067992), new Vsop87.LnVsop(6.0E-11, 1.12902280478, 27311.72098235281), new Vsop87.LnVsop(5.0E-11, 3.67139738592, 25241.820306823), new Vsop87.LnVsop(5.0E-11, 3.09230254875, 115674.27666460119), new Vsop87.LnVsop(5.0E-11, 4.44854763906, 25227.59321282139), new Vsop87.LnVsop(5.0E-11, 6.11660618145, 76681.75007643958), new Vsop87.LnVsop(5.0E-11, 4.08211677301, 209812.60368468694), new Vsop87.LnVsop(5.0E-11, 1.73089458865, 956.2891559706), new Vsop87.LnVsop(5.0E-11, 5.66811291485, 45290.65639321759), new Vsop87.LnVsop(5.0E-11, 3.13493063609, 103285.11708910679), new Vsop87.LnVsop(6.0E-11, 0.68903019707, 26720.68688088739), new Vsop87.LnVsop(5.0E-11, 1.38851632143, 104344.49901929598), new Vsop87.LnVsop(5.0E-11, 4.91303143516, 52061.36699446317), new Vsop87.LnVsop(5.0E-11, 1.74146694456, 178063.3684939606), new Vsop87.LnVsop(6.0E-11, 0.57541579782, 134991.4692049298), new Vsop87.LnVsop(5.0E-11, 2.68983687693, 50064.15596977079), new Vsop87.LnVsop(4.0E-11, 1.00808694646, 183724.7005431128), new Vsop87.LnVsop(6.0E-11, 3.7160771723, 26162.6847401415), new Vsop87.LnVsop(4.0E-11, 0.62283626032, 22747.2907148744), new Vsop87.LnVsop(4.0E-11, 4.50456714341, 77410.51304297059), new Vsop87.LnVsop(5.0E-11, 1.56490281477, 11610.5519583742), new Vsop87.LnVsop(5.0E-11, 4.32652438787, 32132.1317229496), new Vsop87.LnVsop(4.0E-11, 1.00639601102, 51219.51712717779), new Vsop87.LnVsop(4.0E-11, 1.51036812292, 66653.15746634839), new Vsop87.LnVsop(4.0E-11, 0.36128713063, 48835.19385644859), new Vsop87.LnVsop(4.0E-11, 0.41686657221, 52698.38370124219), new Vsop87.LnVsop(5.0E-11, 0.98141094776, 71582.48457132299), new Vsop87.LnVsop(5.0E-11, 3.11319066063, 61279.713277266), new Vsop87.LnVsop(5.0E-11, 2.13218330001, 39609.6545831656), new Vsop87.LnVsop(4.0E-11, 1.96389435563, 52712.61079524379), new Vsop87.LnVsop(4.0E-11, 5.99354847872, 121335.60871375339), new Vsop87.LnVsop(4.0E-11, 5.78126086314, 26734.913974889), new Vsop87.LnVsop(4.0E-11, 2.7321288251, 1692.1656695024), new Vsop87.LnVsop(4.0E-11, 3.01852709067, 52072.71350892979), new Vsop87.LnVsop(5.0E-11, 5.66771377195, 119116.85160956658), new Vsop87.LnVsop(5.0E-11, 0.77258282125, 103711.71527998279), new Vsop87.LnVsop(5.0E-11, 6.04945174043, 97112.93697469679), new Vsop87.LnVsop(4.0E-11, 0.36575665885, 31415.379249957), new Vsop87.LnVsop(5.0E-11, 5.02731895212, 51653.22886505459), new Vsop87.LnVsop(4.0E-11, 3.93621649933, 104371.28232719658), new Vsop87.LnVsop(4.0E-11, 5.41284039165, 72936.23331633979), new Vsop87.LnVsop(4.0E-11, 2.92377236341, 78417.48823520739), new Vsop87.LnVsop(4.0E-11, 3.51647396311, 74821.13447975718), new Vsop87.LnVsop(4.0E-11, 4.54421819395, 26198.1094627936), new Vsop87.LnVsop(4.0E-11, 0.88403223565, 60055.89543648739), new Vsop87.LnVsop(3.0E-11, 2.66890053344, 24176.703658357), new Vsop87.LnVsop(4.0E-11, 5.69108860339, 25138.7275326044), new Vsop87.LnVsop(3.0E-11, 3.87783398339, 107794.1875112622), new Vsop87.LnVsop(3.0E-11, 5.41502481469, 44295.7171298094), new Vsop87.LnVsop(4.0E-11, 6.15603833593, 140652.80125408198), new Vsop87.LnVsop(3.0E-11, 2.04324855763, 156100.82065856917), new Vsop87.LnVsop(3.0E-11, 1.43970050784, 130226.21661243298), new Vsop87.LnVsop(4.0E-11, 4.42783340987, 32769.1279949738), new Vsop87.LnVsop(4.0E-11, 1.81467845339, 50049.92887576919), new Vsop87.LnVsop(3.0E-11, 0.63347622471, 104347.73123093879), new Vsop87.LnVsop(3.0E-11, 3.32438215067, 170049.1702910366), new Vsop87.LnVsop(3.0E-11, 0.67090491468, 26222.0121911592), new Vsop87.LnVsop(4.0E-11, 1.76229044896, 110634.68841628819), new Vsop87.LnVsop(3.0E-11, 5.53149982046, 52101.02468458109), new Vsop87.LnVsop(4.0E-11, 4.50620915113, 52169.17772424839), new Vsop87.LnVsop(4.0E-11, 3.5688550472, 105940.68546158058), new Vsop87.LnVsop(4.0E-11, 0.21580922543, 214364.55718174577), new Vsop87.LnVsop(3.0E-11, 3.38684695593, 77616.69859140778), new Vsop87.LnVsop(4.0E-11, 2.17281001389, 182085.63102592478), new Vsop87.LnVsop(3.0E-11, 2.92184086259, 78187.44335344699), new Vsop87.LnVsop(3.0E-11, 3.6236787811, 102232.84870591838), new Vsop87.LnVsop(3.0E-11, 6.16140322421, 12546.481939083), new Vsop87.LnVsop(4.0E-11, 0.33659131492, 53228.07466633679), new Vsop87.LnVsop(4.0E-11, 0.86535240325, 24822.3356629478), new Vsop87.LnVsop(3.0E-11, 3.54130574747, 28791.5192962498), new Vsop87.LnVsop(3.0E-11, 5.53380981999, 323.5054166574), new Vsop87.LnVsop(3.0E-11, 0.55130340136, 1911.1994832172), new Vsop87.LnVsop(3.0E-11, 0.87110894776, 207593.8465805002), new Vsop87.LnVsop(3.0E-11, 5.53793227956, 129387.24732468258), new Vsop87.LnVsop(4.0E-11, 1.4894406773, 176953.98994186718), new Vsop87.LnVsop(3.0E-11, 1.39556385937, 110.2063212194), new Vsop87.LnVsop(3.0E-11, 3.73684881528, 68241.8721446232), new Vsop87.LnVsop(3.0E-11, 5.18504918985, 17893.6278083656), new Vsop87.LnVsop(3.0E-11, 5.78973675301, 27780.06881107659), new Vsop87.LnVsop(3.0E-11, 1.3460955204, 52182.4348420484), new Vsop87.LnVsop(4.0E-11, 0.33642454097, 365230.6439820388), new Vsop87.LnVsop(3.0E-11, 3.31724366253, 104778.21075717278), new Vsop87.LnVsop(3.0E-11, 0.35623812687, 75615.25459924959), new Vsop87.LnVsop(3.0E-11, 5.28343621642, 183570.921732628), new Vsop87.LnVsop(3.0E-11, 0.96990585284, 25780.3455206046), new Vsop87.LnVsop(3.0E-11, 5.33125415195, 172402.0364448084), new Vsop87.LnVsop(3.0E-11, 0.56049277948, 52250.5878817157), new Vsop87.LnVsop(3.0E-11, 4.87139349011, 27044.1922975448), new Vsop87.LnVsop(4.0E-11, 5.37885673963, 52022.0274726636), new Vsop87.LnVsop(3.0E-11, 2.98512848612, 102769.65321801379), new Vsop87.LnVsop(3.0E-11, 3.02425841901, 74923.09699802278), new Vsop87.LnVsop(3.0E-11, 0.49237630844, 35077.37084700659), new Vsop87.LnVsop(3.0E-11, 3.10202105417, 155571.81910783658), new Vsop87.LnVsop(3.0E-11, 2.40265630063, 207643.8432024044), new Vsop87.LnVsop(3.0E-11, 5.24629397059, 55516.4187098482), new Vsop87.LnVsop(3.0E-11, 1.46721236412, 77101.23472031478), new Vsop87.LnVsop(3.0E-11, 2.66397867066, 157586.80077963436), new Vsop87.LnVsop(3.0E-11, 0.67298226082, 112231.70171963578), new Vsop87.LnVsop(3.0E-11, 4.9960516907, 103932.12792242158), new Vsop87.LnVsop(3.0E-11, 4.10691179553, 1478.8665740644), new Vsop87.LnVsop(3.0E-11, 6.27831375933, 3340.6124266998), new Vsop87.LnVsop(3.0E-11, 4.70793427922, 52595.29092702359), new Vsop87.LnVsop(3.0E-11, 3.30698355673, 111122.32316754239), new Vsop87.LnVsop(3.0E-11, 3.59410472234, 161079.37234650398), new Vsop87.LnVsop(3.0E-11, 1.0859846521, 2125.8774073792), new Vsop87.LnVsop(3.0E-11, 2.86835872465, 79330.20490191258), new Vsop87.LnVsop(3.0E-11, 0.03528312928, 130652.81480330898), new Vsop87.LnVsop(3.0E-11, 4.91342309115, 130443.39704322898), new Vsop87.LnVsop(3.0E-11, 3.81834920265, 130446.62925487179), new Vsop87.LnVsop(3.0E-11, 5.36562496748, 36109.7404216736), new Vsop87.LnVsop(3.0E-11, 4.08661000212, 97670.38771289718), new Vsop87.LnVsop(3.0E-11, 3.26620026556, 27669.86248985719), new Vsop87.LnVsop(3.0E-11, 3.18918832992, 64901.25971792339), new Vsop87.LnVsop(3.0E-11, 5.81508759911, 65831.6667743248), new Vsop87.LnVsop(3.0E-11, 5.12438368628, 225687.22128005017), new Vsop87.LnVsop(3.0E-11, 5.22842077296, 116917.76426627958), new Vsop87.LnVsop(3.0E-11, 4.3406244245, 128220.75860368418), new Vsop87.LnVsop(3.0E-11, 6.07858503745, 26724.8994135984), new Vsop87.LnVsop(2.0E-11, 5.50809745225, 78903.60671103658), new Vsop87.LnVsop(3.0E-11, 4.22986268574, 53399.624123927), new Vsop87.LnVsop(2.0E-11, 3.93729718963, 25352.02662804239), new Vsop87.LnVsop(3.0E-11, 4.09989052992, 25446.4895798352), new Vsop87.LnVsop(2.0E-11, 1.09392137734, 24998.19435038059), new Vsop87.LnVsop(2.0E-11, 3.68762047589, 150244.3429994538), new Vsop87.LnVsop(3.0E-11, 3.19241041107, 77630.92568540938), new Vsop87.LnVsop(3.0E-11, 6.21988692602, 51969.62073471119), new Vsop87.LnVsop(3.0E-11, 1.11955202845, 80382.47328510099), new Vsop87.LnVsop(2.0E-11, 2.12662656444, 28736.3579670472), new Vsop87.LnVsop(3.0E-11, 2.0412729636, 76784.84285065818), new Vsop87.LnVsop(2.0E-11, 5.87891896219, 104505.39137678158), new Vsop87.LnVsop(3.0E-11, 1.71543070116, 130419.8459469712), new Vsop87.LnVsop(2.0E-11, 2.72423428668, 23866.04650697719), new Vsop87.LnVsop(3.0E-11, 4.73772050139, 204151.27163553477), new Vsop87.LnVsop(2.0E-11, 1.63035800038, 206.1855484372), new Vsop87.LnVsop(2.0E-11, 0.28516429317, 52325.36948028299), new Vsop87.LnVsop(3.0E-11, 1.04046826719, 78378.1487134078), new Vsop87.LnVsop(2.0E-11, 5.57938361325, 24292.64469785319), new Vsop87.LnVsop(2.0E-11, 1.79521955728, 123668.80510662538), new Vsop87.LnVsop(3.0E-11, 5.4583879665, 220.4126424388), new Vsop87.LnVsop(3.0E-11, 4.42874475531, 51955.39364070959), new Vsop87.LnVsop(2.0E-11, 2.17330948821, 157483.01859105378), new Vsop87.LnVsop(2.0E-11, 4.42013828428, 78270.3379836226), new Vsop87.LnVsop(2.0E-11, 1.95807177582, 102018.41617342478), new Vsop87.LnVsop(3.0E-11, 0.9031207914, 80596.9058175946), new Vsop87.LnVsop(3.0E-11, 0.7926499595, 87253.17713015496), new Vsop87.LnVsop(2.0E-11, 0.27619168326, 111590.2881578968), new Vsop87.LnVsop(2.0E-11, 6.07933917378, 39450.3528483734), new Vsop87.LnVsop(2.0E-11, 3.76044810773, 78731.674415077), new Vsop87.LnVsop(2.0E-11, 2.15358480656, 78213.71280281838), new Vsop87.LnVsop(3.0E-11, 2.99177358632, 102755.42612401219), new Vsop87.LnVsop(2.0E-11, 4.2159894569, 81591.84508100279), new Vsop87.LnVsop(3.0E-11, 2.32279667601, 145204.75475114078), new Vsop87.LnVsop(2.0E-11, 0.25549281668, 22909.7573510066), new Vsop87.LnVsop(2.0E-11, 6.14643883768, 141762.17980617538), new Vsop87.LnVsop(2.0E-11, 4.52361884313, 20043.6745601988), new Vsop87.LnVsop(3.0E-11, 1.75443444354, 77741.13200662879), new Vsop87.LnVsop(3.0E-11, 5.20551476382, 26709.6469424134), new Vsop87.LnVsop(3.0E-11, 5.08171722545, 157057.10981453978), new Vsop87.LnVsop(2.0E-11, 5.5248119467, 104202.04936916218), new Vsop87.LnVsop(2.0E-11, 0.47870092643, 2111.6503133776), new Vsop87.LnVsop(2.0E-11, 2.47915773617, 78114.14622758799), new Vsop87.LnVsop(3.0E-11, 2.27153901784, 25953.79409198919), new Vsop87.LnVsop(2.0E-11, 3.82824341716, 1162.4747044078), new Vsop87.LnVsop(2.0E-11, 0.51034872663, 133882.09065283637), new Vsop87.LnVsop(2.0E-11, 3.73613869026, 24601.92302050899), new Vsop87.LnVsop(3.0E-11, 3.59795425725, 52396.2189255872), new Vsop87.LnVsop(2.0E-11, 5.13033023401, 26823.77965510599), new Vsop87.LnVsop(2.0E-11, 4.43860191568, 25450.90686955), new Vsop87.LnVsop(2.0E-11, 5.79358770849, 181026.24909573558), new Vsop87.LnVsop(2.0E-11, 2.21653310659, 26402.0893214438), new Vsop87.LnVsop(2.0E-11, 4.78156121936, 51859.41441349179), new Vsop87.LnVsop(2.0E-11, 2.34758825112, 78109.93061423779), new Vsop87.LnVsop(2.0E-11, 3.31605319473, 52609.51802102519), new Vsop87.LnVsop(2.0E-11, 3.95441673698, 52808.59002246159), new Vsop87.LnVsop(2.0E-11, 2.72617137486, 123200.84011627098), new Vsop87.LnVsop(2.0E-11, 3.7853998732, 52381.99183158559), new Vsop87.LnVsop(2.0E-11, 1.51043652717, 78149.27013603736), new Vsop87.LnVsop(2.0E-11, 2.79844678677, 167850.0829477496), new Vsop87.LnVsop(2.0E-11, 1.04172617563, 52492.19815280499), new Vsop87.LnVsop(3.0E-11, 2.56160742762, 154938.34595416137), new Vsop87.LnVsop(2.0E-11, 4.64184952554, 60370.08161635699), new Vsop87.LnVsop(2.0E-11, 1.36020518792, 3328.13565628019), new Vsop87.LnVsop(2.0E-11, 1.24306133807, 58857.03113654799), new Vsop87.LnVsop(2.0E-11, 0.61134558822, 128320.75184749259), new Vsop87.LnVsop(2.0E-11, 3.66766587868, 51852.30086649099), new Vsop87.LnVsop(3.0E-11, 3.6064304556, 52225.8029050526), new Vsop87.LnVsop(2.0E-11, 3.83820356329, 16703.062133499), new Vsop87.LnVsop(2.0E-11, 6.27055581751, 130866.11389874699), new Vsop87.LnVsop(2.0E-11, 1.60943083243, 53029.0026649004), new Vsop87.LnVsop(2.0E-11, 0.7491000083, 26667.590728573), new Vsop87.LnVsop(2.0E-11, 1.22999905791, 103498.41618454478), new Vsop87.LnVsop(2.0E-11, 6.15892249504, 52252.07235442399), new Vsop87.LnVsop(2.0E-11, 5.23865884724, 26729.31670331319), new Vsop87.LnVsop(2.0E-11, 5.92374472867, 78160.61665050399), new Vsop87.LnVsop(2.0E-11, 5.69052913085, 189853.99758261937), new Vsop87.LnVsop(2.0E-11, 3.69732655609, 52309.9153327334), new Vsop87.LnVsop(2.0E-11, 4.0163819369, 51868.2486621788), new Vsop87.LnVsop(2.0E-11, 5.60946469584, 103917.90082841998), new Vsop87.LnVsop(2.0E-11, 2.05507054538, 70383.6202713836), new Vsop87.LnVsop(2.0E-11, 6.01217703537, 94329.77528619739), new Vsop87.LnVsop(2.0E-11, 2.32199957299, 51226.63067417859), new Vsop87.LnVsop(2.0E-11, 2.67908261522, 173511.41499690176), new Vsop87.LnVsop(2.0E-11, 3.62032090461, 6885.14988993081), new Vsop87.LnVsop(2.0E-11, 1.58668212347, 26013.1215430069), new Vsop87.LnVsop(2.0E-11, 1.81879125394, 27177.6119327678), new Vsop87.LnVsop(2.0E-11, 1.81202528574, 25771.5112719176), new Vsop87.LnVsop(2.0E-11, 6.06186683896, 129373.02023068098), new Vsop87.LnVsop(2.0E-11, 5.38601913539, 151199.94274106238), new Vsop87.LnVsop(2.0E-11, 0.20113172923, 25754.0472008048), new Vsop87.LnVsop(2.0E-11, 5.96231230667, 23919.1426592916), new Vsop87.LnVsop(2.0E-11, 5.44340217714, 95247.70557217918), new Vsop87.LnVsop(2.0E-11, 1.68782102934, 27250.37784598199), new Vsop87.LnVsop(2.0E-11, 4.33776532179, 26404.2950112308), new Vsop87.LnVsop(2.0E-11, 1.10098144775, 1223.81784077861), new Vsop87.LnVsop(2.0E-11, 2.87118340279, 137678.191299471), new Vsop87.LnVsop(2.0E-11, 1.73319857606, 92741.06060792258), new Vsop87.LnVsop(2.0E-11, 3.7258049498, 34082.4315835984), new Vsop87.LnVsop(2.0E-11, 5.77505044086, 25600.26839032), new Vsop87.LnVsop(2.0E-11, 0.26892495924, 53771.99272543299), new Vsop87.LnVsop(2.0E-11, 3.97982464503, 129799.61842155698), new Vsop87.LnVsop(2.0E-11, 0.60185817387, 74.7815985673), new Vsop87.LnVsop(2.0E-11, 3.37711958412, 2221.856634597), new Vsop87.LnVsop(2.0E-11, 3.37390513588, 26575.53789282839), new Vsop87.LnVsop(2.0E-11, 2.81094355112, 118828.96374949679), new Vsop87.LnVsop(2.0E-11, 5.68640078492, 50264.6067999312), new Vsop87.LnVsop(2.0E-11, 4.37218185067, 8194.2753332086), new Vsop87.LnVsop(2.0E-11, 6.09074384651, 2333.196392872), new Vsop87.LnVsop(2.0E-11, 5.21226121395, 52278.89905736699), new Vsop87.LnVsop(2.0E-11, 0.4705749451, 25773.71696170459), new Vsop87.LnVsop(2.0E-11, 1.23732034066, 78257.08086582259), new Vsop87.LnVsop(2.0E-11, 4.51390388591, 37698.4550999484), new Vsop87.LnVsop(2.0E-11, 3.29240007524, 77726.90491262719), new Vsop87.LnVsop(2.0E-11, 5.79437105261, 26312.2479372761), new Vsop87.LnVsop(2.0E-11, 1.11912985777, 51315.49635439559), new Vsop87.LnVsop(2.0E-11, 2.50406010238, 19202.75325164339), new Vsop87.LnVsop(2.0E-11, 1.61719066741, 24079.34560241519), new Vsop87.LnVsop(2.0E-11, 5.00820642202, 182188.72380014337), new Vsop87.LnVsop(2.0E-11, 3.08979268503, 195047.36464141717), new Vsop87.LnVsop(2.0E-11, 2.19163720361, 26395.46076254379), new Vsop87.LnVsop(2.0E-11, 1.93268238025, 26189.8656598398), new Vsop87.LnVsop(1.0E-11, 1.9565150886, 26073.67604757259), new Vsop87.LnVsop(2.0E-11, 1.69360766883, 48847.6706268682), new Vsop87.LnVsop(2.0E-11, 4.77850859259, 136722.59155786238), new Vsop87.LnVsop(2.0E-11, 1.23109092649, 52286.01260436779), new Vsop87.LnVsop(2.0E-11, 1.92969421017, 143005.6674078538), new Vsop87.LnVsop(2.0E-11, 5.31894725019, 23384.2869868986), new Vsop87.LnVsop(2.0E-11, 4.016010581, 189386.03259226496), new Vsop87.LnVsop(2.0E-11, 4.13493316476, 25466.159340735), new Vsop87.LnVsop(2.0E-11, 4.58005710714, 25004.8229092806), new Vsop87.LnVsop(1.0E-11, 4.50232888505, 101703.15774082378), new Vsop87.LnVsop(2.0E-11, 1.99945872949, 17098.43543614181), new Vsop87.LnVsop(1.0E-11, 5.86202636151, 163766.0944410452), new Vsop87.LnVsop(2.0E-11, 4.42951918443, 132658.27281205778), new Vsop87.LnVsop(2.0E-11, 4.91675947523, 24448.8336243862), new Vsop87.LnVsop(2.0E-11, 2.35593686283, 147423.51185532758), new Vsop87.LnVsop(2.0E-11, 4.356248579, 130432.40216087017), new Vsop87.LnVsop(1.0E-11, 4.98789585706, 78800.51393681798), new Vsop87.LnVsop(1.0E-11, 1.09794599902, 55503.94193942859), new Vsop87.LnVsop(2.0E-11, 1.80354488061, 860.3099287528), new Vsop87.LnVsop(2.0E-11, 2.50676380667, 61560.64729122359), new Vsop87.LnVsop(2.0E-11, 0.29051427089, 24356.7807886416), new Vsop87.LnVsop(2.0E-11, 6.11873017537, 87367.61641884019), new Vsop87.LnVsop(1.0E-11, 1.32811901694, 154194.22245657316), new Vsop87.LnVsop(2.0E-11, 1.30375159885, 144916.86689107097), new Vsop87.LnVsop(1.0E-11, 3.51165251141, 26421.7590823436), new Vsop87.LnVsop(1.0E-11, 5.54890134424, 220025.88923089797), new Vsop87.LnVsop(1.0E-11, 4.52193457212, 27170.98337386779), new Vsop87.LnVsop(2.0E-11, 2.16673373766, 103.0927742186), new Vsop87.LnVsop(1.0E-11, 2.97156317234, 846.0828347512), new Vsop87.LnVsop(1.0E-11, 3.56056299689, 78786.28684281638), new Vsop87.LnVsop(1.0E-11, 1.72265685452, 25508.2155545754), new Vsop87.LnVsop(2.0E-11, 1.14700860003, 61165.27398858079), new Vsop87.LnVsop(2.0E-11, 5.40448093264, 1265.5674786264), new Vsop87.LnVsop(2.0E-11, 0.63660432851, 52065.59996192899), new Vsop87.LnVsop(1.0E-11, 5.30775305827, 22625.658435709), new Vsop87.LnVsop(2.0E-11, 2.87848636951, 166740.70439565618), new Vsop87.LnVsop(2.0E-11, 1.64559155822, 75930.51303185058), new Vsop87.LnVsop(1.0E-11, 0.5178240706, 113341.08027172917), new Vsop87.LnVsop(1.0E-11, 0.26594892339, 76571.54375522019), new Vsop87.LnVsop(1.0E-11, 1.68473271541, 28286.9904848612), new Vsop87.LnVsop(1.0E-11, 3.43479665429, 130435.63437251298), new Vsop87.LnVsop(1.0E-11, 4.94766296108, 205260.65018762814), new Vsop87.LnVsop(1.0E-11, 5.6718936459, 122444.98726584678), new Vsop87.LnVsop(2.0E-11, 0.3500357898, 132028.58860315479), new Vsop87.LnVsop(1.0E-11, 3.82950218931, 50910.238804522), new Vsop87.LnVsop(1.0E-11, 0.58719200248, 78896.49316403578), new Vsop87.LnVsop(1.0E-11, 1.40281382564, 467.9649903544), new Vsop87.LnVsop(1.0E-11, 3.70071408896, 116783.65521669458), new Vsop87.LnVsop(1.0E-11, 1.98838052622, 81604.32185142238), new Vsop87.LnVsop(1.0E-11, 5.87508556606, 104275.34649502118), new Vsop87.LnVsop(1.0E-11, 2.06878150381, 78188.92782615528), new Vsop87.LnVsop(1.0E-11, 3.0854322754, 9384.8410080752), new Vsop87.LnVsop(1.0E-11, 3.30520943702, 19.66976089979), new Vsop87.LnVsop(1.0E-11, 2.76310033884, 52812.8025551726), new Vsop87.LnVsop(1.0E-11, 5.76310756779, 1375.7737998458), new Vsop87.LnVsop(1.0E-11, 5.71684807894, 76152.05911134499), new Vsop87.LnVsop(1.0E-11, 3.43817796928, 65717.22748563958), new Vsop87.LnVsop(1.0E-11, 0.85559605439, 25985.94062330859), new Vsop87.LnVsop(1.0E-11, 5.99281135918, 106570.36967048359), new Vsop87.LnVsop(1.0E-11, 1.87029583839, 26411.4085582316), new Vsop87.LnVsop(1.0E-11, 2.97621377443, 91805.13062721379), new Vsop87.LnVsop(1.0E-11, 2.8181949701, 168959.46149984296), new Vsop87.LnVsop(1.0E-11, 6.14145843596, 221135.26778299137), new Vsop87.LnVsop(1.0E-11, 6.19284917502, 103718.82882698359), new Vsop87.LnVsop(1.0E-11, 0.38545603521, 130459.18546877075), new Vsop87.LnVsop(1.0E-11, 5.58283403624, 104197.83375581198), new Vsop87.LnVsop(1.0E-11, 2.74916354771, 170068.84005193636), new Vsop87.LnVsop(1.0E-11, 2.29937985557, 58220.0348645238), new Vsop87.LnVsop(1.0E-11, 0.77298125199, 26102.1302355758), new Vsop87.LnVsop(1.0E-11, 3.82192552665, 25928.601406782), new Vsop87.LnVsop(1.0E-11, 0.48738972037, 104819.57755665119), new Vsop87.LnVsop(1.0E-11, 0.34737694069, 1795.258443721), new Vsop87.LnVsop(1.0E-11, 5.0467220846, 26247.2048763664), new Vsop87.LnVsop(1.0E-11, 4.44724577178, 6044.2285813754), new Vsop87.LnVsop(1.0E-11, 4.31124637329, 50483.640613646), new Vsop87.LnVsop(1.0E-11, 3.69136847395, 77307.42026875199), new Vsop87.LnVsop(1.0E-11, 0.4047421702, 636.9962720242), new Vsop87.LnVsop(1.0E-11, 6.11533644929, 241561.83887541335), new Vsop87.LnVsop(1.0E-11, 0.08760404468, 54879.422437824), new Vsop87.LnVsop(1.0E-11, 1.61849542996, 128106.31931499895), new Vsop87.LnVsop(1.0E-11, 6.2773200613, 196137.07343261078), new Vsop87.LnVsop(1.0E-11, 0.82044479603, 51329.7234483972), new Vsop87.LnVsop(1.0E-11, 0.98691419134, 163298.1294506908), new Vsop87.LnVsop(1.0E-11, 2.30107750853, 179172.74704605396), new Vsop87.LnVsop(1.0E-11, 0.61075768459, 51534.3927214094), new Vsop87.LnVsop(1.0E-11, 0.58942299216, 78469.89497315978), new Vsop87.LnVsop(1.0E-11, 3.29001702156, 79315.97780791098), new Vsop87.LnVsop(1.0E-11, 4.50997601178, 203041.8930834414), new Vsop87.LnVsop(1.0E-11, 1.194006952, 8989.46770543239), new Vsop87.LnVsop(1.0E-11, 2.30283274772, 50380.54783942739), new Vsop87.LnVsop(1.0E-11, 3.04434275932, 78057.52387628538), new Vsop87.LnVsop(1.0E-11, 1.59838533079, 137210.22630911658), new Vsop87.LnVsop(1.0E-11, 6.25852814644, 50800.03248330259), new Vsop87.LnVsop(1.0E-11, 4.59739779893, 156507.7490885454), new Vsop87.LnVsop(1.0E-11, 3.52857712732, 78338.49102328988), new Vsop87.LnVsop(1.0E-11, 3.29578424156, 51841.950342379), new Vsop87.LnVsop(1.0E-11, 4.37115478363, 231348.55332920235), new Vsop87.LnVsop(1.0E-11, 6.21157459837, 199599.31813847594), new Vsop87.LnVsop(1.0E-11, 5.68807537585, 3178.1457905676), new Vsop87.LnVsop(1.0E-11, 6.16099382664, 103814.80805420138), new Vsop87.LnVsop(1.0E-11, 3.5870329979, 106262.81204951399), new Vsop87.LnVsop(1.0E-11, 2.12644283427, 62197.64356324779), new Vsop87.LnVsop(1.0E-11, 3.67624268292, 2703.6161546756), new Vsop87.LnVsop(1.0E-11, 1.94597992024, 45494.58142974879), new Vsop87.LnVsop(1.0E-11, 5.27747039682, 52041.69723356339), new Vsop87.LnVsop(1.0E-11, 2.87032894974, 38634.3850806572), new Vsop87.LnVsop(1.0E-11, 0.2327074545, 138319.60486120995), new Vsop87.LnVsop(1.0E-11, 5.53197596443, 27819.0254945068), new Vsop87.LnVsop(1.0E-11, 5.12208743996, 142871.55835826878), new Vsop87.LnVsop(1.0E-11, 1.39038865276, 112545.88789950538), new Vsop87.LnVsop(1.0E-11, 4.74583618954, 53265.515074342), new Vsop87.LnVsop(1.0E-11, 5.3878612039, 99024.13645791399), new Vsop87.LnVsop(1.0E-11, 0.39696641642, 42790.9652750732), new Vsop87.LnVsop(1.0E-11, 0.71118375221, 52026.2430860138), new Vsop87.LnVsop(1.0E-11, 2.16468187079, 1485.9801210652), new Vsop87.LnVsop(1.0E-11, 5.72787089962, 153084.84390447979), new Vsop87.LnVsop(1.0E-11, 4.66269784654, 54374.8936264354)};
        private static Vsop87.LnVsop[] mercury_radius_r2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.117867E-5, 3.08231840294, 26087.9031415742), new Vsop87.LnVsop(1.245397E-5, 6.1518331681, 52175.8062831484), new Vsop87.LnVsop(4.24822E-6, 2.92583350003, 78263.70942472259), new Vsop87.LnVsop(1.3613E-6, 5.97983927257, 104351.61256629678), new Vsop87.LnVsop(4.2176E-7, 2.74936984182, 130439.51570787099), new Vsop87.LnVsop(2.1759E-7, 3.14159265359, 0.0), new Vsop87.LnVsop(1.2794E-7, 5.80143158303, 156527.41884944518), new Vsop87.LnVsop(3.825E-8, 2.56993470104, 182615.3219910194), new Vsop87.LnVsop(1.042E-8, 3.14646747795, 24978.5245894808), new Vsop87.LnVsop(1.131E-8, 5.62140894157, 208703.2251325936), new Vsop87.LnVsop(4.83E-9, 6.14311665486, 27197.2816936676), new Vsop87.LnVsop(3.32E-9, 2.38990569407, 234791.12827416777), new Vsop87.LnVsop(3.2E-9, 6.20678671907, 51066.427731055), new Vsop87.LnVsop(1.2E-9, 0.56753278081, 20426.571092422), new Vsop87.LnVsop(1.13E-9, 3.28087063421, 24498.8302462904), new Vsop87.LnVsop(1.05E-9, 4.36644825356, 25028.521211385), new Vsop87.LnVsop(9.7E-10, 5.44142060651, 260879.03141574195), new Vsop87.LnVsop(9.5E-10, 1.70261963549, 1059.3819301892), new Vsop87.LnVsop(1.03E-9, 2.98025866325, 77154.33087262919), new Vsop87.LnVsop(7.4E-10, 1.28624418497, 26617.5941066688), new Vsop87.LnVsop(5.7E-10, 2.96811822826, 1109.3785520934), new Vsop87.LnVsop(6.6E-10, 5.68227129537, 25132.3033999656), new Vsop87.LnVsop(5.3E-10, 3.63665664342, 46514.4742339962), new Vsop87.LnVsop(5.9E-10, 3.109572212, 27043.5028831828), new Vsop87.LnVsop(5.3E-10, 0.66664633754, 21535.9496445154), new Vsop87.LnVsop(4.3E-10, 4.69265718173, 27147.28507176339), new Vsop87.LnVsop(4.2E-10, 2.77425162061, 1589.0728952838), new Vsop87.LnVsop(3.6E-10, 4.39785847487, 14765.2390432698), new Vsop87.LnVsop(3.5E-10, 1.80414409714, 11322.6640983044), new Vsop87.LnVsop(4.3E-10, 6.07298394731, 28306.66024576099), new Vsop87.LnVsop(3.3E-10, 5.34403985744, 25448.00585526019), new Vsop87.LnVsop(3.1E-10, 5.66726050432, 30639.856638633), new Vsop87.LnVsop(3.1E-10, 2.36583154631, 32858.61374281979), new Vsop87.LnVsop(3.1E-10, 4.27240840519, 16983.9961474566), new Vsop87.LnVsop(3.3E-10, 3.23005237683, 23869.1460373874), new Vsop87.LnVsop(3.1E-10, 0.49978982972, 22645.32819660879), new Vsop87.LnVsop(2.8E-10, 2.21272342124, 286966.9345573162), new Vsop87.LnVsop(3.3E-10, 6.03641747595, 103242.2340142034), new Vsop87.LnVsop(2.5E-10, 4.24265705908, 52705.49724824299), new Vsop87.LnVsop(2.3E-10, 2.59657279752, 23969.1392811958), new Vsop87.LnVsop(2.7E-10, 2.10611676289, 25558.2121764796), new Vsop87.LnVsop(2.1E-10, 0.41168883239, 72602.37737557039), new Vsop87.LnVsop(2.5E-10, 5.69956303861, 5661.3320491522), new Vsop87.LnVsop(2.2E-10, 4.86511394552, 26301.2022370122), new Vsop87.LnVsop(2.4E-10, 0.6632876741, 19317.1925403286), new Vsop87.LnVsop(2.1E-10, 2.30174192487, 51220.20654153979), new Vsop87.LnVsop(2.0E-10, 5.62040366872, 4551.9534970588), new Vsop87.LnVsop(1.8E-10, 0.49330577083, 26068.2333806744), new Vsop87.LnVsop(1.6E-10, 6.08123098154, 50586.73338786459), new Vsop87.LnVsop(1.6E-10, 1.48825706159, 53235.18821333759), new Vsop87.LnVsop(1.7E-10, 2.94317208111, 53285.1848352418), new Vsop87.LnVsop(1.5E-10, 2.39611761878, 83925.0414738748), new Vsop87.LnVsop(1.5E-10, 3.85588323044, 26091.7844769322), new Vsop87.LnVsop(1.4E-10, 4.13824962282, 12566.1516999828), new Vsop87.LnVsop(1.5E-10, 5.5122476133, 6770.7106012456), new Vsop87.LnVsop(1.4E-10, 5.68202466008, 57837.1383323006), new Vsop87.LnVsop(1.4E-10, 5.73541534358, 27676.976036858), new Vsop87.LnVsop(1.6E-10, 5.69568023163, 26107.57290247399), new Vsop87.LnVsop(1.5E-10, 5.72321197499, 29530.4780865396), new Vsop87.LnVsop(1.4E-10, 5.00810046723, 37410.5672398786), new Vsop87.LnVsop(1.2E-10, 1.18950088434, 40853.142184844), new Vsop87.LnVsop(1.3E-10, 2.34556111896, 26084.0218062162), new Vsop87.LnVsop(1.2E-10, 2.43751302567, 56727.7597802072), new Vsop87.LnVsop(1.2E-10, 1.11729686867, 43071.8992890308), new Vsop87.LnVsop(1.2E-10, 4.91255816577, 36301.18868778519), new Vsop87.LnVsop(1.1E-10, 1.87794158603, 9103.9069941176), new Vsop87.LnVsop(1.0E-10, 2.33246324171, 426.598190876), new Vsop87.LnVsop(1.1E-10, 2.79095158447, 129330.13715577759), new Vsop87.LnVsop(1.0E-10, 5.86523749031, 26202.34243025941), new Vsop87.LnVsop(9.0E-11, 0.03195500104, 25234.70675982219), new Vsop87.LnVsop(1.1E-10, 0.9260369508, 639.897286314), new Vsop87.LnVsop(1.0E-10, 3.9442277939, 25661.3049506982), new Vsop87.LnVsop(8.0E-11, 5.42470507867, 110012.94461544899), new Vsop87.LnVsop(8.0E-11, 6.27857478248, 49957.0491789616), new Vsop87.LnVsop(8.0E-11, 3.40746854679, 25973.46385288896), new Vsop87.LnVsop(9.0E-11, 4.83419682076, 38519.945791972), new Vsop87.LnVsop(8.0E-11, 5.64863461479, 53131.406024757), new Vsop87.LnVsop(9.0E-11, 5.74323028796, 51116.4243529592), new Vsop87.LnVsop(8.0E-11, 1.97671803181, 13521.7514415914), new Vsop87.LnVsop(8.0E-11, 3.52143325301, 52156.1365222486), new Vsop87.LnVsop(8.0E-11, 0.94287580197, 78793.40038981718), new Vsop87.LnVsop(8.0E-11, 5.25159704872, 313054.83769889036), new Vsop87.LnVsop(7.0E-11, 3.57055320328, 48733.23133818299), new Vsop87.LnVsop(8.0E-11, 5.33870577078, 51646.11531805379), new Vsop87.LnVsop(8.0E-11, 4.34685532674, 31749.2351907264), new Vsop87.LnVsop(1.0E-10, 5.07112035424, 25874.6040461362), new Vsop87.LnVsop(7.0E-11, 3.44200114221, 26080.78959457339), new Vsop87.LnVsop(8.0E-11, 3.46506333076, 98690.28051714458), new Vsop87.LnVsop(7.0E-11, 5.27632613466, 77308.10968311399), new Vsop87.LnVsop(7.0E-11, 1.97132570364, 10213.285546211), new Vsop87.LnVsop(7.0E-11, 3.47394709299, 2118.7638603784), new Vsop87.LnVsop(7.0E-11, 1.19332181936, 103292.23063610759), new Vsop87.LnVsop(7.0E-11, 0.8822542155, 38654.05484155699), new Vsop87.LnVsop(7.0E-11, 4.28963258668, 955.5997416086), new Vsop87.LnVsop(9.0E-11, 2.12066223909, 18849.2275499742), new Vsop87.LnVsop(8.0E-11, 2.74524992169, 26095.016688575), new Vsop87.LnVsop(7.0E-11, 4.98611088801, 529.6909650946), new Vsop87.LnVsop(7.0E-11, 0.21206642896, 33326.5787331742), new Vsop87.LnVsop(6.0E-11, 1.24554634942, 41962.5207369374), new Vsop87.LnVsop(6.0E-11, 0.58325989516, 52179.6876185064), new Vsop87.LnVsop(6.0E-11, 4.54627482504, 79323.09135491178), new Vsop87.LnVsop(6.0E-11, 1.74421492528, 62389.09182935939), new Vsop87.LnVsop(5.0E-11, 2.14134003331, 51535.90899683439), new Vsop87.LnVsop(7.0E-11, 4.18624565491, 77204.32749453338), new Vsop87.LnVsop(6.0E-11, 4.90636348078, 26514.5013324502), new Vsop87.LnVsop(5.0E-11, 4.28760477114, 68050.42387851159), new Vsop87.LnVsop(7.0E-11, 1.6876820534, 12432.0426503978), new Vsop87.LnVsop(6.0E-11, 1.67734378339, 52389.1053785864), new Vsop87.LnVsop(5.0E-11, 2.621929764, 79373.087976816), new Vsop87.LnVsop(6.0E-11, 3.7232136248, 45405.0956819028), new Vsop87.LnVsop(5.0E-11, 2.80648643213, 54394.56338733519), new Vsop87.LnVsop(4.0E-11, 6.27711808251, 52168.69273614759), new Vsop87.LnVsop(5.0E-11, 4.49206719344, 13655.8604911764), new Vsop87.LnVsop(6.0E-11, 2.4205424774, 52195.47604404819), new Vsop87.LnVsop(5.0E-11, 5.36726437404, 52171.9249477904), new Vsop87.LnVsop(4.0E-11, 2.39080386734, 53764.8791784322), new Vsop87.LnVsop(4.0E-11, 5.45239063221, 82815.66292178139), new Vsop87.LnVsop(4.0E-11, 2.45845698665, 55618.3812281138), new Vsop87.LnVsop(4.0E-11, 5.46064307091, 50057.04242277), new Vsop87.LnVsop(4.0E-11, 4.2454377568, 129380.13377768178), new Vsop87.LnVsop(4.0E-11, 2.16475111801, 136100.84775702318), new Vsop87.LnVsop(4.0E-11, 3.27367961735, 7238.6755916), new Vsop87.LnVsop(4.0E-11, 4.23033954187, 66941.04532641819), new Vsop87.LnVsop(4.0E-11, 5.86077781318, 155418.04029735178), new Vsop87.LnVsop(4.0E-11, 2.91823301912, 2218.7571041868), new Vsop87.LnVsop(4.0E-11, 2.22132272424, 33967.99229491319), new Vsop87.LnVsop(4.0E-11, 4.13443053346, 32370.9789915656), new Vsop87.LnVsop(4.0E-11, 0.97401599373, 44181.27784112419), new Vsop87.LnVsop(5.0E-11, 5.73865924281, 52182.9198301492), new Vsop87.LnVsop(3.0E-11, 5.77600031262, 28421.0995344462), new Vsop87.LnVsop(3.0E-11, 3.60566098017, 99799.65906923798), new Vsop87.LnVsop(3.0E-11, 4.89516568247, 47623.8527860896), new Vsop87.LnVsop(3.0E-11, 2.65837542043, 76674.63652943878), new Vsop87.LnVsop(4.0E-11, 3.97575019999, 26727.8004278882), new Vsop87.LnVsop(4.0E-11, 1.58883137896, 77734.01845962799), new Vsop87.LnVsop(3.0E-11, 4.0537792322, 18093.37469954999), new Vsop87.LnVsop(3.0E-11, 0.32164436845, 78244.0396638228), new Vsop87.LnVsop(3.0E-11, 4.55918659193, 1066.49547719), new Vsop87.LnVsop(3.0E-11, 1.04073203752, 94138.32702008578), new Vsop87.LnVsop(3.0E-11, 5.11379070475, 1052.2683831884), new Vsop87.LnVsop(4.0E-11, 0.0028965674, 7.1135470008), new Vsop87.LnVsop(3.0E-11, 6.00211964373, 29416.03879785439), new Vsop87.LnVsop(3.0E-11, 0.83769822705, 73711.75592766379), new Vsop87.LnVsop(3.0E-11, 6.2455872429, 853.196381752), new Vsop87.LnVsop(3.0E-11, 1.04516366216, 51123.53789995999), new Vsop87.LnVsop(3.0E-11, 1.58718103357, 51109.31080595839), new Vsop87.LnVsop(3.0E-11, 1.95786741975, 103396.01282468818), new Vsop87.LnVsop(2.0E-11, 1.84359601235, 52602.4044740244), new Vsop87.LnVsop(3.0E-11, 0.20363902961, 124778.18365871879), new Vsop87.LnVsop(3.0E-11, 3.92029951121, 104881.30353139139), new Vsop87.LnVsop(2.0E-11, 3.86834138575, 64741.95798313119), new Vsop87.LnVsop(2.0E-11, 4.78277672679, 88476.99497093359), new Vsop87.LnVsop(2.0E-11, 3.02197674612, 76044.9523205358), new Vsop87.LnVsop(2.0E-11, 2.56056246046, 51962.5071877104), new Vsop87.LnVsop(2.0E-11, 0.39257053002, 23754.70674870219), new Vsop87.LnVsop(2.0E-11, 1.93806690975, 117873.36400788819), new Vsop87.LnVsop(3.0E-11, 4.94947672066, 44937.1306915484), new Vsop87.LnVsop(2.0E-11, 5.16794137847, 91785.46086631398), new Vsop87.LnVsop(2.0E-11, 3.69784569438, 78267.59076008058), new Vsop87.LnVsop(2.0E-11, 0.12898246901, 28206.6670019526), new Vsop87.LnVsop(2.0E-11, 2.71494330191, 52290.24557183361), new Vsop87.LnVsop(2.0E-11, 1.01643765523, 155468.036919256), new Vsop87.LnVsop(2.0E-11, 1.94864163639, 7994.5284420242), new Vsop87.LnVsop(2.0E-11, 0.34644075002, 125887.56221081219), new Vsop87.LnVsop(2.0E-11, 2.07439531255, 339142.7408404646), new Vsop87.LnVsop(2.0E-11, 0.47977325476, 74821.13447975718), new Vsop87.LnVsop(2.0E-11, 2.16320557771, 65697.55772473979), new Vsop87.LnVsop(2.0E-11, 5.55432178842, 78283.37918562238), new Vsop87.LnVsop(2.0E-11, 1.29900775156, 105410.99449648599), new Vsop87.LnVsop(2.0E-11, 2.53975890096, 78270.82297172339), new Vsop87.LnVsop(2.0E-11, 3.05127595992, 78256.59587772179), new Vsop87.LnVsop(2.0E-11, 0.74524218739, 18207.81398823521), new Vsop87.LnVsop(2.0E-11, 2.52077863728, 45892.73043315699), new Vsop87.LnVsop(2.0E-11, 4.40145815211, 103821.92160120218), new Vsop87.LnVsop(2.0E-11, 0.48596602676, 71492.99882347698), new Vsop87.LnVsop(2.0E-11, 5.20647406504, 162188.75089859738), new Vsop87.LnVsop(2.0E-11, 4.82705668292, 35191.8101356918), new Vsop87.LnVsop(2.0E-11, 2.53400006045, 181505.94343892598), new Vsop87.LnVsop(2.0E-11, 5.01222373888, 3442.5749449654), new Vsop87.LnVsop(2.0E-11, 4.77472325123, 78477.00852016058), new Vsop87.LnVsop(2.0E-11, 4.04794032959, 120226.23016165999), new Vsop87.LnVsop(2.0E-11, 4.91210946644, 129483.91596626239), new Vsop87.LnVsop(2.0E-11, 4.13616693949, 77211.44104153418), new Vsop87.LnVsop(2.0E-11, 5.55063812006, 71980.63357473118), new Vsop87.LnVsop(2.0E-11, 1.87550379173, 23439.44831610119), new Vsop87.LnVsop(2.0E-11, 4.79089230864, 15874.6175953632), new Vsop87.LnVsop(2.0E-11, 4.07209162893, 77837.11123384659), new Vsop87.LnVsop(2.0E-11, 3.28278777867, 51322.60990139639), new Vsop87.LnVsop(1.0E-11, 3.34910054328, 151975.46535238638), new Vsop87.LnVsop(1.0E-11, 2.46216864998, 98068.53671630539), new Vsop87.LnVsop(2.0E-11, 2.5524527794, 39609.6545831656), new Vsop87.LnVsop(2.0E-11, 2.20615341805, 78259.82808936459), new Vsop87.LnVsop(1.0E-11, 1.85625086925, 27140.17152476259), new Vsop87.LnVsop(1.0E-11, 4.90356608602, 78690.30761559859), new Vsop87.LnVsop(2.0E-11, 2.05592477737, 433.7117378768), new Vsop87.LnVsop(1.0E-11, 0.57135579166, 58458.88213313979), new Vsop87.LnVsop(1.0E-11, 6.02187954635, 102132.85546210999), new Vsop87.LnVsop(2.0E-11, 3.23303486183, 150866.08680029298), new Vsop87.LnVsop(1.0E-11, 4.60285163809, 77197.21394753258), new Vsop87.LnVsop(1.0E-11, 3.29652393557, 104331.94280539699), new Vsop87.LnVsop(2.0E-11, 0.37358476984, 52061.36699446317), new Vsop87.LnVsop(2.0E-11, 6.05813345839, 78050.41032928458), new Vsop87.LnVsop(1.0E-11, 5.03719934254, 105460.99111839019), new Vsop87.LnVsop(1.0E-11, 5.61325235757, 81706.28436968799), new Vsop87.LnVsop(1.0E-11, 4.16559096091, 51742.09454527159), new Vsop87.LnVsop(1.0E-11, 2.18291711529, 104371.28232719658), new Vsop87.LnVsop(1.0E-11, 1.56268200733, 114564.89811250778), new Vsop87.LnVsop(1.0E-11, 2.9780193791, 26941.0995233262), new Vsop87.LnVsop(2.0E-11, 0.60670302239, 130969.20667296558), new Vsop87.LnVsop(1.0E-11, 1.28661284202, 27154.3986187642), new Vsop87.LnVsop(1.0E-11, 0.32656599185, 6283.0758499914), new Vsop87.LnVsop(2.0E-11, 0.98900298585, 129909.82474277639), new Vsop87.LnVsop(2.0E-11, 0.34266376084, 104355.49390165479), new Vsop87.LnVsop(1.0E-11, 1.70449480453, 71025.0338331226), new Vsop87.LnVsop(1.0E-11, 0.69109808707, 103925.01437542078), new Vsop87.LnVsop(1.0E-11, 5.99111938887, 104344.49901929598), new Vsop87.LnVsop(1.0E-11, 1.29444105614, 26241.681952059), new Vsop87.LnVsop(1.0E-11, 1.52348055432, 104564.91166173479), new Vsop87.LnVsop(1.0E-11, 1.02840142284, 93028.94846799239), new Vsop87.LnVsop(1.0E-11, 2.70610275891, 59414.4818747484), new Vsop87.LnVsop(1.0E-11, 3.38720596578, 24864.08530079559), new Vsop87.LnVsop(1.0E-11, 4.01905758539, 181555.94006083018), new Vsop87.LnVsop(1.0E-11, 0.19437065391, 131548.89425996438), new Vsop87.LnVsop(1.0E-11, 2.33926236379, 108903.56606335558), new Vsop87.LnVsop(1.0E-11, 3.48554697151, 97580.90196505119), new Vsop87.LnVsop(1.0E-11, 2.21845432691, 107794.1875112622), new Vsop87.LnVsop(1.0E-11, 5.21032711478, 134991.4692049298), new Vsop87.LnVsop(1.0E-11, 3.36974859678, 22759.76748529401), new Vsop87.LnVsop(1.0E-11, 3.6970462026, 51749.20809227239), new Vsop87.LnVsop(1.0E-11, 5.50712708044, 104358.72611329758), new Vsop87.LnVsop(1.0E-11, 3.54339432961, 84546.78527471398), new Vsop87.LnVsop(1.0E-11, 1.85236380912, 76144.94556434419), new Vsop87.LnVsop(1.0E-11, 1.35457977308, 103285.11708910679), new Vsop87.LnVsop(1.0E-11, 5.41788745559, 79852.78232000639), new Vsop87.LnVsop(1.0E-11, 2.71021284118, 419.4846438752), new Vsop87.LnVsop(1.0E-11, 5.20690925178, 58946.51688439399), new Vsop87.LnVsop(1.0E-11, 2.58243930041, 79219.3091663312), new Vsop87.LnVsop(1.0E-11, 4.14551403325, 2648.454825473), new Vsop87.LnVsop(1.0E-11, 0.80546617242, 52815.7035694624), new Vsop87.LnVsop(1.0E-11, 4.3526382888, 131498.89763806018), new Vsop87.LnVsop(1.0E-11, 2.96821079393, 63498.47038145279), new Vsop87.LnVsop(1.0E-11, 1.67750729252, 64607.84893354619), new Vsop87.LnVsop(1.0E-11, 1.27183275592, 39743.7636327506), new Vsop87.LnVsop(1.0E-11, 4.96647288061, 365230.6439820388), new Vsop87.LnVsop(1.0E-11, 0.9940651896, 50579.61984086379), new Vsop87.LnVsop(1.0E-11, 5.18049622713, 1596.1864422846), new Vsop87.LnVsop(1.0E-11, 3.02654575849, 54294.57014352679), new Vsop87.LnVsop(1.0E-11, 5.63350272797, 78378.1487134078), new Vsop87.LnVsop(1.0E-11, 4.40490970421, 25021.4076643842), new Vsop87.LnVsop(1.0E-11, 3.63610465805, 51756.3216392732), new Vsop87.LnVsop(1.0E-11, 4.26629771518, 26724.8994135984), new Vsop87.LnVsop(1.0E-11, 2.79177248963, 157636.79740153858), new Vsop87.LnVsop(1.0E-11, 4.5698813352, 19804.8272915828), new Vsop87.LnVsop(1.0E-11, 2.63303478623, 5327.4761083828), new Vsop87.LnVsop(1.0E-11, 5.14973525909, 104347.73123093879), new Vsop87.LnVsop(1.0E-11, 3.74530927136, 44295.7171298094), new Vsop87.LnVsop(1.0E-11, 0.68414890944, 90829.86112470538), new Vsop87.LnVsop(1.0E-11, 0.49165582856, 69159.80243060499), new Vsop87.LnVsop(1.0E-11, 1.49658721659, 61279.713277266), new Vsop87.LnVsop(1.0E-11, 5.27847149725, 25934.1243310894), new Vsop87.LnVsop(1.0E-11, 5.17229158556, 149.5631971346), new Vsop87.LnVsop(1.0E-11, 3.18169864614, 78149.27013603736), new Vsop87.LnVsop(1.0E-11, 0.76788482924, 146314.13330323418), new Vsop87.LnVsop(1.0E-11, 5.2952848025, 26137.8997634784), new Vsop87.LnVsop(1.0E-11, 3.51389080283, 49842.60989027639), new Vsop87.LnVsop(1.0E-11, 0.80519817567, 103299.34418310839), new Vsop87.LnVsop(1.0E-11, 1.91164708185, 105940.68546158058), new Vsop87.LnVsop(1.0E-11, 0.84584454465, 77829.99768684579), new Vsop87.LnVsop(1.0E-11, 4.68188188415, 90695.75207512038), new Vsop87.LnVsop(1.0E-11, 0.65295847908, 26037.90651966999), new Vsop87.LnVsop(1.0E-11, 0.23063503545, 105307.21230790539), new Vsop87.LnVsop(1.0E-11, 3.8232058119, 25619.9381512198), new Vsop87.LnVsop(1.0E-11, 4.40595033152, 70269.18098269838), new Vsop87.LnVsop(1.0E-11, 5.8354369829, 27311.72098235281), new Vsop87.LnVsop(1.0E-11, 4.93010556318, 143961.2671494624), new Vsop87.LnVsop(1.0E-11, 0.69055367085, 10021.8372800994), new Vsop87.LnVsop(1.0E-11, 4.04373064295, 25565.3257234804), new Vsop87.LnVsop(1.0E-11, 2.76360990402, 55503.94193942859), new Vsop87.LnVsop(1.0E-11, 5.27048505986, 52643.7712735028), new Vsop87.LnVsop(1.0E-11, 5.30671272193, 77623.81213840858), new Vsop87.LnVsop(1.0E-11, 3.5900148554, 130012.91751699499), new Vsop87.LnVsop(1.0E-11, 6.20174437935, 3328.13565628019), new Vsop87.LnVsop(1.0E-11, 4.37843587271, 52329.58509363319), new Vsop87.LnVsop(1.0E-11, 5.35804254604, 7880.08915333899), new Vsop87.LnVsop(1.0E-11, 0.37001213364, 29428.515568274), new Vsop87.LnVsop(1.0E-11, 2.09823688356, 26610.48055966799), new Vsop87.LnVsop(1.0E-11, 1.90742269266, 188276.6540401716), new Vsop87.LnVsop(1.0E-11, 2.07583539066, 26555.8681319286), new Vsop87.LnVsop(1.0E-11, 2.74928843672, 54509.0026760204), new Vsop87.LnVsop(1.0E-11, 4.7836192657, 25450.90686955), new Vsop87.LnVsop(1.0E-11, 4.66282101332, 1581.959348283), new Vsop87.LnVsop(1.0E-11, 1.93180863256, 85034.42002596818), new Vsop87.LnVsop(1.0E-11, 1.39574142846, 50593.84693486539), new Vsop87.LnVsop(1.0E-11, 4.28383546403, 53242.3017603384), new Vsop87.LnVsop(1.0E-11, 0.36440946351, 89586.37352302698), new Vsop87.LnVsop(1.0E-11, 3.84510723447, 119116.85160956658), new Vsop87.LnVsop(1.0E-11, 0.98328228963, 536.8045120954), new Vsop87.LnVsop(1.0E-11, 6.21114511135, 25668.418497699), new Vsop87.LnVsop(1.0E-11, 3.66409514672, 26624.70765366959), new Vsop87.LnVsop(1.0E-11, 4.38823198457, 12546.481939083), new Vsop87.LnVsop(0.0, 3.66005454502, 95247.70557217918), new Vsop87.LnVsop(1.0E-11, 3.254815521, 46848.3301747656), new Vsop87.LnVsop(0.0, 6.18816289886, 213.299095438), new Vsop87.LnVsop(0.0, 5.42382537447, 124156.43985787958), new Vsop87.LnVsop(0.0, 3.08747000862, 104138.31347085879), new Vsop87.LnVsop(0.0, 4.37059865637, 80482.46652890938), new Vsop87.LnVsop(0.0, 4.90249116112, 26521.614879451), new Vsop87.LnVsop(0.0, 4.11303810429, 65831.6667743248), new Vsop87.LnVsop(0.0, 3.42919047371, 116917.76426627958), new Vsop87.LnVsop(1.0E-11, 4.86353089367, 51639.00177105299), new Vsop87.LnVsop(0.0, 0.20560781967, 77844.22478084739), new Vsop87.LnVsop(0.0, 6.23379339496, 48847.6706268682), new Vsop87.LnVsop(0.0, 4.71445024355, 76.2660712756), new Vsop87.LnVsop(1.0E-11, 2.25536112069, 25551.09862947879), new Vsop87.LnVsop(0.0, 6.00692447908, 26507.38778544939), new Vsop87.LnVsop(0.0, 0.02652054523, 6681.2248533996), new Vsop87.LnVsop(0.0, 1.97940011643, 86143.79857806159), new Vsop87.LnVsop(0.0, 4.41963004243, 114.43928868521)};
        private static Vsop87.LnVsop[] mercury_radius_r3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.2676E-7, 1.67971641967, 26087.9031415742), new Vsop87.LnVsop(2.4166E-7, 4.63403168878, 52175.8062831484), new Vsop87.LnVsop(1.2133E-7, 1.38983777816, 78263.70942472259), new Vsop87.LnVsop(5.141E-8, 4.43915486864, 104351.61256629678), new Vsop87.LnVsop(1.981E-8, 1.20734065292, 130439.51570787099), new Vsop87.LnVsop(1.46E-8, 3.14159265359, 0.0), new Vsop87.LnVsop(7.19E-9, 4.25914225052, 156527.41884944518), new Vsop87.LnVsop(2.5E-9, 1.02794489584, 182615.3219910194), new Vsop87.LnVsop(8.4E-10, 4.08003393556, 208703.2251325936), new Vsop87.LnVsop(2.8E-10, 0.84976129869, 234791.12827416777), new Vsop87.LnVsop(2.3E-10, 1.60056693427, 24978.5245894808), new Vsop87.LnVsop(1.1E-10, 4.5790690182, 27197.2816936676), new Vsop87.LnVsop(1.2E-10, 4.66186402631, 51066.427731055), new Vsop87.LnVsop(9.0E-11, 3.90351105399, 260879.03141574195), new Vsop87.LnVsop(5.0E-11, 1.44899194699, 77154.33087262919), new Vsop87.LnVsop(4.0E-11, 1.37039350951, 53285.1848352418), new Vsop87.LnVsop(3.0E-11, 0.65216170836, 286966.9345573162), new Vsop87.LnVsop(2.0E-11, 5.31647339795, 20426.571092422), new Vsop87.LnVsop(2.0E-11, 1.54948310012, 1109.3785520934), new Vsop87.LnVsop(2.0E-11, 4.46650154841, 103242.2340142034), new Vsop87.LnVsop(2.0E-11, 0.2031117197, 1059.3819301892), new Vsop87.LnVsop(1.0E-11, 4.18509315538, 25132.3033999656), new Vsop87.LnVsop(1.0E-11, 2.08677361801, 46514.4742339962), new Vsop87.LnVsop(1.0E-11, 3.22427097914, 27147.28507176339), new Vsop87.LnVsop(1.0E-11, 1.31990592569, 1589.0728952838), new Vsop87.LnVsop(1.0E-11, 6.11476749247, 26617.5941066688), new Vsop87.LnVsop(1.0E-11, 3.87574939924, 4551.9534970588), new Vsop87.LnVsop(1.0E-11, 5.13451991746, 72602.37737557039), new Vsop87.LnVsop(1.0E-11, 2.82416621766, 14765.2390432698), new Vsop87.LnVsop(1.0E-11, 3.69788379486, 313054.83769889036), new Vsop87.LnVsop(1.0E-11, 1.23397179166, 129330.13715577759), new Vsop87.LnVsop(1.0E-11, 1.47670395865, 27043.5028831828), new Vsop87.LnVsop(1.0E-11, 2.829933738, 52705.49724824299), new Vsop87.LnVsop(1.0E-11, 1.6989676563, 23869.1460373874), new Vsop87.LnVsop(1.0E-11, 0.32413035355, 9103.9069941176), new Vsop87.LnVsop(1.0E-11, 4.2016156951, 27676.976036858), new Vsop87.LnVsop(1.0E-11, 4.34344280909, 79373.087976816), new Vsop87.LnVsop(1.0E-11, 0.89956318302, 51220.20654153979), new Vsop87.LnVsop(1.0E-11, 2.20322858011, 21535.9496445154), new Vsop87.LnVsop(1.0E-11, 3.19342492912, 26301.2022370122), new Vsop87.LnVsop(1.0E-11, 1.88258101468, 98690.28051714458), new Vsop87.LnVsop(1.0E-11, 4.68591095165, 50586.73338786459), new Vsop87.LnVsop(1.0E-11, 5.85065851846, 40853.142184844), new Vsop87.LnVsop(1.0E-11, 1.23101504358, 54394.56338733519), new Vsop87.LnVsop(1.0E-11, 6.23351653071, 53235.18821333759), new Vsop87.LnVsop(1.0E-11, 3.87422845306, 77308.10968311399), new Vsop87.LnVsop(1.0E-11, 0.79126413034, 32858.61374281979), new Vsop87.LnVsop(1.0E-11, 4.14416492315, 29530.4780865396), new Vsop87.LnVsop(1.0E-11, 3.66291049805, 82815.66292178139), new Vsop87.LnVsop(1.0E-11, 4.44414264582, 53131.406024757), new Vsop87.LnVsop(1.0E-11, 5.39898005107, 19317.1925403286), new Vsop87.LnVsop(1.0E-11, 5.74090182848, 78793.40038981718), new Vsop87.LnVsop(1.0E-11, 2.04445272211, 22645.32819660879), new Vsop87.LnVsop(0.0, 5.20058182117, 26068.2333806744), new Vsop87.LnVsop(0.0, 2.88882171293, 79323.09135491178), new Vsop87.LnVsop(0.0, 0.77734457598, 83925.0414738748), new Vsop87.LnVsop(0.0, 1.85241611022, 25973.46385288896), new Vsop87.LnVsop(0.0, 4.31134434847, 26202.34243025941), new Vsop87.LnVsop(0.0, 2.48865412354, 25028.521211385), new Vsop87.LnVsop(0.0, 4.73702212377, 49957.0491789616), new Vsop87.LnVsop(1.0E-11, 4.52312859491, 28306.66024576099), new Vsop87.LnVsop(0.0, 6.22434083886, 25558.2121764796), new Vsop87.LnVsop(0.0, 4.43739303442, 57837.1383323006), new Vsop87.LnVsop(0.0, 4.22145138443, 155418.04029735178), new Vsop87.LnVsop(1.0E-11, 4.15987542477, 3442.5749449654), new Vsop87.LnVsop(0.0, 3.37837484563, 37410.5672398786), new Vsop87.LnVsop(0.0, 4.06445772133, 30639.856638633), new Vsop87.LnVsop(0.0, 1.88469600324, 52156.1365222486), new Vsop87.LnVsop(0.0, 5.55588074115, 639.897286314), new Vsop87.LnVsop(0.0, 4.12649087613, 26107.57290247399), new Vsop87.LnVsop(1.0E-11, 2.12434762874, 45405.0956819028), new Vsop87.LnVsop(0.0, 3.520503578, 51646.11531805379), new Vsop87.LnVsop(0.0, 0.9561790289, 56727.7597802072), new Vsop87.LnVsop(0.0, 2.68844434121, 25874.6040461362), new Vsop87.LnVsop(0.0, 0.77169310211, 26084.0218062162), new Vsop87.LnVsop(0.0, 1.28280882604, 31749.2351907264), new Vsop87.LnVsop(0.0, 3.77504856922, 110012.94461544899), new Vsop87.LnVsop(0.0, 5.5189577876, 51116.4243529592), new Vsop87.LnVsop(0.0, 2.46996848792, 12566.1516999828), new Vsop87.LnVsop(0.0, 2.0608030281, 26091.7844769322), new Vsop87.LnVsop(0.0, 4.06656248201, 6770.7106012456), new Vsop87.LnVsop(0.0, 5.64089373958, 43071.8992890308), new Vsop87.LnVsop(0.0, 3.01044907413, 529.6909650946), new Vsop87.LnVsop(0.0, 3.74932541209, 58946.51688439399), new Vsop87.LnVsop(0.0, 1.59982844601, 24498.8302462904), new Vsop87.LnVsop(0.0, 6.18077135384, 52389.1053785864), new Vsop87.LnVsop(0.0, 3.54760851916, 5661.3320491522), new Vsop87.LnVsop(0.0, 0.36958867063, 339142.7408404646), new Vsop87.LnVsop(0.0, 1.28365548551, 105460.99111839019), new Vsop87.LnVsop(0.0, 2.54309051397, 66941.04532641819), new Vsop87.LnVsop(0.0, 1.20651308836, 76674.63652943878), new Vsop87.LnVsop(0.0, 0.56648671737, 426.598190876), new Vsop87.LnVsop(0.0, 5.16253006866, 955.5997416086), new Vsop87.LnVsop(0.0, 0.44574885677, 51535.90899683439), new Vsop87.LnVsop(0.0, 3.22440388798, 36301.18868778519), new Vsop87.LnVsop(0.0, 5.18616332697, 52179.6876185064), new Vsop87.LnVsop(0.0, 1.77057901742, 2118.7638603784), new Vsop87.LnVsop(0.0, 0.83059819658, 53764.8791784322), new Vsop87.LnVsop(0.0, 4.82874431323, 78244.0396638228), new Vsop87.LnVsop(0.0, 5.46044714578, 38654.05484155699), new Vsop87.LnVsop(0.0, 1.3523810858, 76044.9523205358), new Vsop87.LnVsop(0.0, 0.78426047136, 52195.47604404819), new Vsop87.LnVsop(0.0, 1.56504928662, 2218.7571041868), new Vsop87.LnVsop(0.0, 0.44110358867, 136100.84775702318), new Vsop87.LnVsop(0.0, 3.95443065599, 50057.04242277), new Vsop87.LnVsop(0.0, 0.69662881483, 55618.3812281138), new Vsop87.LnVsop(0.0, 0.00690662625, 213.299095438), new Vsop87.LnVsop(0.0, 3.72355104277, 52171.9249477904), new Vsop87.LnVsop(0.0, 5.77253301832, 105410.99449648599), new Vsop87.LnVsop(0.0, 0.68653770637, 79219.3091663312), new Vsop87.LnVsop(0.0, 2.14142206148, 64741.95798313119)};
        private static Vsop87.LnVsop[] mercury_radius_r4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.94E-9, 0.36736738836, 26087.9031415742), new Vsop87.LnVsop(3.87E-9, 3.1856889414, 52175.8062831484), new Vsop87.LnVsop(2.7E-9, 6.16979809593, 78263.70942472259), new Vsop87.LnVsop(1.49E-9, 2.91591472142, 104351.61256629678), new Vsop87.LnVsop(7.1E-10, 5.95888916295, 130439.51570787099), new Vsop87.LnVsop(3.1E-10, 2.72386331553, 156527.41884944518), new Vsop87.LnVsop(1.7E-10, 0.0, 0.0), new Vsop87.LnVsop(1.2E-10, 5.77758679438, 182615.3219910194), new Vsop87.LnVsop(5.0E-11, 2.54442235521, 208703.2251325936), new Vsop87.LnVsop(2.0E-11, 5.59215484513, 234791.12827416777), new Vsop87.LnVsop(1.0E-11, 2.31734413223, 260879.03141574195), new Vsop87.LnVsop(0.0, 5.37041038965, 286966.9345573162), new Vsop87.LnVsop(0.0, 3.05050417438, 51066.427731055), new Vsop87.LnVsop(0.0, 0.07052854591, 24978.5245894808), new Vsop87.LnVsop(0.0, 5.93192891756, 53285.1848352418), new Vsop87.LnVsop(0.0, 6.03840913462, 77154.33087262919), new Vsop87.LnVsop(0.0, 3.02089425425, 27197.2816936676)};
        private static Vsop87.LnVsop[] mercury_radius_r5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(6.0E-11, 3.98812118954, 26087.9031415742), new Vsop87.LnVsop(6.0E-11, 1.55172409309, 52175.8062831484), new Vsop87.LnVsop(5.0E-11, 4.65488347662, 78263.70942472259), new Vsop87.LnVsop(4.0E-11, 1.40628214181, 104351.61256629678), new Vsop87.LnVsop(2.0E-11, 4.44423794944, 130439.51570787099), new Vsop87.LnVsop(1.0E-11, 3.14159265359, 0.0), new Vsop87.LnVsop(1.0E-11, 1.21235041448, 156527.41884944518), new Vsop87.LnVsop(1.0E-11, 4.24238056507, 182615.3219910194), new Vsop87.LnVsop(0.0, 0.95140152937, 208703.2251325936), new Vsop87.LnVsop(0.0, 4.00511196914, 234791.12827416777)};

        Radius() {
        }
    }

    static class Latitude {
        private static Vsop87.LnVsop[] mercury_latitude_b0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.11737528961, 1.98357498767, 26087.9031415742), new Vsop87.LnVsop(0.02388076996, 5.03738959686, 52175.8062831484), new Vsop87.LnVsop(0.01222839532, 3.14159265359, 0.0), new Vsop87.LnVsop(0.0054325181, 1.79644363964, 78263.70942472259), new Vsop87.LnVsop(0.0012977877, 4.83232503958, 104351.61256629678), new Vsop87.LnVsop(3.1866927E-4, 1.58088495658, 130439.51570787099), new Vsop87.LnVsop(7.963301E-5, 4.60972126127, 156527.41884944518), new Vsop87.LnVsop(2.014189E-5, 1.35324164377, 182615.3219910194), new Vsop87.LnVsop(5.13953E-6, 4.37835406663, 208703.2251325936), new Vsop87.LnVsop(2.07674E-6, 4.91772567908, 27197.2816936676), new Vsop87.LnVsop(2.08584E-6, 2.02020295489, 24978.5245894808), new Vsop87.LnVsop(1.32013E-6, 1.11908482553, 234791.12827416777), new Vsop87.LnVsop(1.00454E-6, 5.65684757892, 20426.571092422), new Vsop87.LnVsop(1.21395E-6, 1.81271747279, 53285.1848352418), new Vsop87.LnVsop(9.1566E-7, 2.28163127292, 25028.521211385), new Vsop87.LnVsop(9.9214E-7, 0.09391887897, 51116.4243529592), new Vsop87.LnVsop(9.4574E-7, 1.2418492092, 31749.2351907264), new Vsop87.LnVsop(7.8785E-7, 4.40725881159, 57837.1383323006), new Vsop87.LnVsop(7.7747E-7, 0.52557074433, 1059.3819301892), new Vsop87.LnVsop(8.4264E-7, 5.08510405853, 51066.427731055), new Vsop87.LnVsop(4.9948E-7, 3.49752943761, 5661.3320491522), new Vsop87.LnVsop(4.6454E-7, 3.23739220729, 77204.32749453338), new Vsop87.LnVsop(4.4767E-7, 4.8784979856, 79373.087976816), new Vsop87.LnVsop(4.0766E-7, 2.46558335253, 46514.4742339962), new Vsop87.LnVsop(3.7378E-7, 4.45768804232, 4551.9534970588), new Vsop87.LnVsop(3.4082E-7, 4.14209218714, 260879.03141574195), new Vsop87.LnVsop(3.5911E-7, 1.09057337889, 1109.3785520934), new Vsop87.LnVsop(3.1953E-7, 1.18516370205, 83925.0414738748), new Vsop87.LnVsop(3.0954E-7, 3.50327936487, 21535.9496445154), new Vsop87.LnVsop(3.1808E-7, 2.41474596045, 47623.8527860896), new Vsop87.LnVsop(2.8691E-7, 1.84828593103, 77154.33087262919), new Vsop87.LnVsop(2.5765E-7, 2.77593431876, 27043.5028831828), new Vsop87.LnVsop(2.5199E-7, 3.59062253553, 27147.28507176339), new Vsop87.LnVsop(2.0244E-7, 3.06833786595, 51646.11531805379), new Vsop87.LnVsop(1.8591E-7, 5.58427343534, 73711.75592766379), new Vsop87.LnVsop(1.6971E-7, 0.02791235969, 103292.23063610759), new Vsop87.LnVsop(2.0099E-7, 4.06592941642, 25132.3033999656), new Vsop87.LnVsop(1.7002E-7, 6.13739539823, 41962.5207369374), new Vsop87.LnVsop(1.4984E-7, 1.64717988399, 105460.99111839019), new Vsop87.LnVsop(1.4186E-7, 0.33074004324, 10213.285546211), new Vsop87.LnVsop(1.5577E-7, 6.0769363626, 53131.406024757), new Vsop87.LnVsop(1.5795E-7, 3.79629550117, 529.6909650946), new Vsop87.LnVsop(1.4011E-7, 5.52786584585, 72602.37737557039), new Vsop87.LnVsop(1.2309E-7, 3.16626255554, 14765.2390432698), new Vsop87.LnVsop(1.1261E-7, 0.11326489831, 13521.7514415914), new Vsop87.LnVsop(1.2448E-7, 4.05109307874, 39609.6545831656), new Vsop87.LnVsop(1.3044E-7, 3.48016460676, 37410.5672398786), new Vsop87.LnVsop(1.1042E-7, 4.23192795686, 110012.94461544899), new Vsop87.LnVsop(1.1152E-7, 0.55658540702, 63498.47038145279), new Vsop87.LnVsop(1.0717E-7, 1.53686088392, 25661.3049506982), new Vsop87.LnVsop(1.0213E-7, 2.8788115488, 12566.1516999828), new Vsop87.LnVsop(9.924E-8, 0.94824538375, 65697.55772473979), new Vsop87.LnVsop(1.1047E-7, 5.79741513221, 51749.20809227239), new Vsop87.LnVsop(1.046E-7, 5.82962192197, 50586.73338786459), new Vsop87.LnVsop(9.774E-8, 1.66272232331, 24498.8302462904), new Vsop87.LnVsop(9.412E-8, 1.82364862409, 15874.6175953632), new Vsop87.LnVsop(1.2866E-7, 4.81650992216, 30639.856638633), new Vsop87.LnVsop(9.123E-8, 4.88604621694, 103242.2340142034), new Vsop87.LnVsop(9.011E-8, 1.04262054312, 426.598190876), new Vsop87.LnVsop(8.735E-8, 3.04135873601, 68050.42387851159), new Vsop87.LnVsop(8.491E-8, 1.05130636798, 1589.0728952838), new Vsop87.LnVsop(8.835E-8, 0.88128578222, 286966.9345573162), new Vsop87.LnVsop(8.823E-8, 5.81343394292, 11322.6640983044), new Vsop87.LnVsop(8.196E-8, 0.84015152502, 51220.20654153979), new Vsop87.LnVsop(7.64E-8, 3.43583985772, 36301.18868778519), new Vsop87.LnVsop(9.175E-8, 6.16060208369, 77734.01845962799), new Vsop87.LnVsop(8.897E-8, 0.39691887001, 53235.18821333759), new Vsop87.LnVsop(7.253E-8, 2.37180881419, 99799.65906923798), new Vsop87.LnVsop(7.104E-8, 5.73556965976, 26617.5941066688), new Vsop87.LnVsop(8.322E-8, 5.27157093377, 25558.2121764796), new Vsop87.LnVsop(6.578E-8, 2.66741919711, 52705.49724824299), new Vsop87.LnVsop(5.825E-8, 6.25072209775, 33326.5787331742), new Vsop87.LnVsop(5.625E-8, 3.08030235705, 129380.13377768178), new Vsop87.LnVsop(5.295E-8, 1.35863384912, 45892.73043315699), new Vsop87.LnVsop(5.116E-8, 2.67577088825, 76674.63652943878), new Vsop87.LnVsop(5.035E-8, 2.66615253453, 77837.11123384659), new Vsop87.LnVsop(4.762E-8, 4.68983281649, 131548.89425996438), new Vsop87.LnVsop(5.714E-8, 2.87338979816, 79219.3091663312), new Vsop87.LnVsop(5.602E-8, 5.37191138944, 955.5997416086), new Vsop87.LnVsop(4.965E-8, 3.47619928213, 59414.4818747484), new Vsop87.LnVsop(5.468E-8, 1.43781628125, 56727.7597802072), new Vsop87.LnVsop(4.08E-8, 4.01668024064, 91785.46086631398), new Vsop87.LnVsop(3.971E-8, 5.44452628396, 6283.0758499914), new Vsop87.LnVsop(4.063E-8, 5.64286268741, 26068.2333806744), new Vsop87.LnVsop(3.878E-8, 3.60888347246, 89586.37352302698), new Vsop87.LnVsop(4.047E-8, 5.95237490666, 38654.05484155699), new Vsop87.LnVsop(4.064E-8, 1.4627790849, 26107.57290247399), new Vsop87.LnVsop(3.681E-8, 0.47366868505, 62389.09182935939), new Vsop87.LnVsop(4.247E-8, 6.23163524997, 40853.142184844), new Vsop87.LnVsop(3.694E-8, 2.75543299806, 7238.6755916), new Vsop87.LnVsop(3.348E-8, 5.9187026734, 43071.8992890308), new Vsop87.LnVsop(4.475E-8, 2.28938990458, 98690.28051714458), new Vsop87.LnVsop(3.115E-8, 0.74944300245, 32858.61374281979), new Vsop87.LnVsop(3.1E-8, 3.35203539679, 19804.8272915828), new Vsop87.LnVsop(3.215E-8, 6.11377023104, 94138.32702008578), new Vsop87.LnVsop(3.558E-8, 0.98821355044, 136100.84775702318), new Vsop87.LnVsop(2.908E-8, 4.06284717343, 26514.5013324502), new Vsop87.LnVsop(2.799E-8, 1.63603233307, 129330.13715577759), new Vsop87.LnVsop(2.8E-8, 3.88358973835, 77308.10968311399), new Vsop87.LnVsop(2.68E-8, 4.48236519244, 71980.63357473118), new Vsop87.LnVsop(2.767E-8, 4.12702608202, 27676.976036858), new Vsop87.LnVsop(3.285E-8, 0.3939835153, 18849.2275499742), new Vsop87.LnVsop(3.29E-8, 2.93489975877, 103821.92160120218), new Vsop87.LnVsop(3.048E-8, 0.67698956234, 9103.9069941176), new Vsop87.LnVsop(2.484E-8, 5.42344230141, 125887.56221081219), new Vsop87.LnVsop(2.663E-8, 1.70279606207, 16983.9961474566), new Vsop87.LnVsop(2.791E-8, 2.7684233936, 26091.7844769322), new Vsop87.LnVsop(2.747E-8, 5.75135690787, 19317.1925403286), new Vsop87.LnVsop(2.676E-8, 5.73637768264, 78793.40038981718), new Vsop87.LnVsop(2.71E-8, 4.31274423123, 58946.51688439399), new Vsop87.LnVsop(2.877E-8, 3.45421450693, 79323.09135491178), new Vsop87.LnVsop(2.791E-8, 4.34021895901, 26084.0218062162), new Vsop87.LnVsop(2.097E-8, 2.09090395873, 23869.1460373874), new Vsop87.LnVsop(2.297E-8, 3.90330505329, 313054.83769889036), new Vsop87.LnVsop(2.535E-8, 3.05171357512, 69159.80243060499), new Vsop87.LnVsop(2.211E-8, 4.65120829674, 28306.66024576099), new Vsop87.LnVsop(1.912E-8, 5.78419180084, 102762.53967101299), new Vsop87.LnVsop(2.265E-8, 3.34480087923, 22645.32819660879), new Vsop87.LnVsop(1.817E-8, 5.74263950195, 103925.01437542078), new Vsop87.LnVsop(1.961E-8, 5.94579007147, 105307.21230790539), new Vsop87.LnVsop(1.922E-8, 4.43763750052, 82815.66292178139), new Vsop87.LnVsop(1.667E-8, 4.51885560989, 52195.47604404819), new Vsop87.LnVsop(1.771E-8, 6.12283446589, 155468.036919256), new Vsop87.LnVsop(1.515E-8, 1.72460827268, 54394.56338733519), new Vsop87.LnVsop(1.585E-8, 0.23900607949, 85502.38501632259), new Vsop87.LnVsop(1.477E-8, 4.73358609259, 29530.4780865396), new Vsop87.LnVsop(1.47E-8, 1.44576864221, 157636.79740153858), new Vsop87.LnVsop(1.652E-8, 2.41345125134, 52156.1365222486), new Vsop87.LnVsop(1.377E-8, 0.59981275344, 26080.78959457339), new Vsop87.LnVsop(1.43E-8, 0.78425681154, 117873.36400788819), new Vsop87.LnVsop(1.68E-8, 3.42686804945, 6770.7106012456), new Vsop87.LnVsop(1.604E-8, 4.52048713019, 3442.5749449654), new Vsop87.LnVsop(1.345E-8, 0.31855634174, 51535.90899683439), new Vsop87.LnVsop(1.357E-8, 3.17346823148, 25874.6040461362), new Vsop87.LnVsop(1.25E-8, 2.33381266189, 25448.00585526019), new Vsop87.LnVsop(1.196E-8, 2.09281738041, 48733.23133818299), new Vsop87.LnVsop(1.195E-8, 0.36393992281, 115674.27666460119), new Vsop87.LnVsop(1.443E-8, 2.73206411694, 64741.95798313119), new Vsop87.LnVsop(1.375E-8, 5.32685986405, 124778.18365871879), new Vsop87.LnVsop(1.325E-8, 3.57822655677, 88476.99497093359), new Vsop87.LnVsop(1.115E-8, 0.26093704362, 639.897286314), new Vsop87.LnVsop(1.094E-8, 2.22756345548, 32370.9789915656), new Vsop87.LnVsop(1.433E-8, 3.03965823547, 66941.04532641819), new Vsop87.LnVsop(1.37E-8, 3.45925392964, 44937.1306915484), new Vsop87.LnVsop(1.003E-8, 0.28767648474, 25934.1243310894), new Vsop87.LnVsop(1.136E-8, 1.1105676113, 52171.9249477904), new Vsop87.LnVsop(9.99E-9, 0.52453704666, 26241.681952059), new Vsop87.LnVsop(1.033E-8, 2.5555991533, 45405.0956819028), new Vsop87.LnVsop(1.096E-8, 5.01258599679, 7.1135470008), new Vsop87.LnVsop(1.146E-8, 5.40632535415, 213.299095438), new Vsop87.LnVsop(1.08E-8, 5.97872394252, 129909.82474277639), new Vsop87.LnVsop(9.88E-9, 1.25836520092, 98068.53671630539), new Vsop87.LnVsop(1.062E-8, 2.88170970708, 120226.23016165999), new Vsop87.LnVsop(8.92E-9, 0.63718796304, 103396.01282468818), new Vsop87.LnVsop(1.041E-8, 0.89366857677, 52602.4044740244), new Vsop87.LnVsop(9.78E-9, 0.9310056672, 53764.8791784322), new Vsop87.LnVsop(1.136E-8, 5.82021916863, 52179.6876185064), new Vsop87.LnVsop(8.38E-9, 4.66564092179, 155418.04029735178), new Vsop87.LnVsop(9.1E-9, 5.53570859596, 58458.88213313979), new Vsop87.LnVsop(8.34E-9, 5.16157375656, 49957.0491789616), new Vsop87.LnVsop(1.1E-8, 4.0218695776, 162188.75089859738), new Vsop87.LnVsop(8.05E-9, 1.03424867259, 23969.1392811958), new Vsop87.LnVsop(8.35E-9, 5.28207308572, 50057.04242277), new Vsop87.LnVsop(8.91E-9, 0.21549052344, 105410.99449648599), new Vsop87.LnVsop(7.43E-9, 0.86942889867, 52389.1053785864), new Vsop87.LnVsop(7.83E-9, 3.32305564501, 26301.2022370122), new Vsop87.LnVsop(7.11E-9, 1.57776037431, 2118.7638603784), new Vsop87.LnVsop(8.01E-9, 2.18307947662, 151975.46535238638), new Vsop87.LnVsop(9.15E-9, 1.71248761076, 51962.5071877104), new Vsop87.LnVsop(8.32E-9, 5.53504230089, 74821.13447975718), new Vsop87.LnVsop(7.5E-9, 2.16182593895, 52168.69273614759), new Vsop87.LnVsop(9.23E-9, 2.50216511819, 104881.30353139139), new Vsop87.LnVsop(7.27E-9, 6.05391736381, 95247.70557217918), new Vsop87.LnVsop(6.4E-9, 2.71757218637, 131395.11544947958), new Vsop87.LnVsop(6.28E-9, 1.43928263436, 55618.3812281138), new Vsop87.LnVsop(6.22E-9, 3.46096554268, 77623.81213840858), new Vsop87.LnVsop(8.25E-9, 1.00555394841, 85034.42002596818), new Vsop87.LnVsop(6.11E-9, 0.99681307094, 2218.7571041868), new Vsop87.LnVsop(6.05E-9, 4.68162394146, 52182.9198301492), new Vsop87.LnVsop(6.46E-9, 2.57909918586, 128850.44281258718), new Vsop87.LnVsop(6.21E-9, 1.1658505091, 108903.56606335558), new Vsop87.LnVsop(6.51E-9, 1.60040358652, 26095.016688575), new Vsop87.LnVsop(5.99E-9, 2.5122032014, 130012.91751699499), new Vsop87.LnVsop(5.7E-9, 1.27723576108, 78283.37918562238), new Vsop87.LnVsop(6.16E-9, 2.88988928491, 52026.2430860138), new Vsop87.LnVsop(5.53E-9, 5.1765343376, 25938.3399444396), new Vsop87.LnVsop(5.6E-9, 3.32832430147, 51109.31080595839), new Vsop87.LnVsop(5.38E-9, 4.74589660911, 80482.46652890938), new Vsop87.LnVsop(5.14E-9, 5.52495100856, 25021.4076643842), new Vsop87.LnVsop(5.12E-9, 2.1202803077, 25035.6347583858), new Vsop87.LnVsop(5.45E-9, 1.31026218764, 26555.8681319286), new Vsop87.LnVsop(4.75E-9, 4.05388482, 149.5631971346), new Vsop87.LnVsop(4.64E-9, 3.26227850989, 111590.2881578968), new Vsop87.LnVsop(4.6E-9, 5.34045473945, 46848.3301747656), new Vsop87.LnVsop(5.5E-9, 5.84636209826, 25619.9381512198), new Vsop87.LnVsop(4.47E-9, 3.57688662734, 1066.49547719), new Vsop87.LnVsop(5.5E-9, 6.22076738343, 51123.53789995999), new Vsop87.LnVsop(5.96E-9, 0.64537969407, 339142.7408404646), new Vsop87.LnVsop(4.84E-9, 3.16179359489, 38519.945791972), new Vsop87.LnVsop(4.41E-9, 0.67390934097, 1052.2683831884), new Vsop87.LnVsop(4.77E-9, 0.22612097814, 71025.0338331226), new Vsop87.LnVsop(4.23E-9, 2.08217197834, 76144.94556434419), new Vsop87.LnVsop(4.18E-9, 3.57900885312, 52329.58509363319), new Vsop87.LnVsop(4.72E-9, 3.35497952386, 35191.8101356918), new Vsop87.LnVsop(4.41E-9, 4.91198712765, 78050.41032928458), new Vsop87.LnVsop(4.4E-9, 4.47943362012, 183724.7005431128), new Vsop87.LnVsop(4.35E-9, 1.98195617971, 26094.53170047421), new Vsop87.LnVsop(5.64E-9, 5.45425629323, 78244.0396638228), new Vsop87.LnVsop(5.4E-9, 2.87640883368, 181555.94006083018), new Vsop87.LnVsop(4.5E-9, 6.09068205356, 93028.94846799239), new Vsop87.LnVsop(4.62E-9, 3.82441945925, 143961.2671494624), new Vsop87.LnVsop(4.08E-9, 3.34306652412, 52022.0274726636), new Vsop87.LnVsop(4.12E-9, 2.07642366233, 150866.08680029298), new Vsop87.LnVsop(4.35E-9, 5.12506127285, 26081.27458267419), new Vsop87.LnVsop(4.09E-9, 0.568140533, 64607.84893354619), new Vsop87.LnVsop(3.88E-9, 4.16031676214, 78259.82808936459), new Vsop87.LnVsop(3.93E-9, 3.23714650276, 13655.8604911764), new Vsop87.LnVsop(3.75E-9, 5.33297139411, 26011.6370702986), new Vsop87.LnVsop(4.67E-9, 5.77560193533, 90829.86112470538), new Vsop87.LnVsop(3.5E-9, 5.62305509992, 71492.99882347698), new Vsop87.LnVsop(3.52E-9, 3.27694424296, 26727.8004278882), new Vsop87.LnVsop(3.51E-9, 3.39353257328, 141762.17980617538), new Vsop87.LnVsop(3.9E-9, 2.58789385607, 78267.59076008058), new Vsop87.LnVsop(3.65E-9, 3.1992351035, 52099.5402118728), new Vsop87.LnVsop(4.33E-9, 1.55191555585, 20760.4270331914), new Vsop87.LnVsop(3.27E-9, 5.69237369433, 12432.0426503978), new Vsop87.LnVsop(3.39E-9, 1.58087406629, 45494.58142974879), new Vsop87.LnVsop(3.38E-9, 2.73269880607, 155997.72788435058), new Vsop87.LnVsop(3.15E-9, 4.00042191791, 78477.00852016058), new Vsop87.LnVsop(4.35E-9, 0.36539433019, 114564.89811250778), new Vsop87.LnVsop(3.44E-9, 5.02598371077, 78256.59587772179), new Vsop87.LnVsop(3.46E-9, 4.14119753561, 111122.32316754239), new Vsop87.LnVsop(2.86E-9, 5.40508625698, 6681.2248533996), new Vsop87.LnVsop(2.83E-9, 3.6551431699, 76.2660712756), new Vsop87.LnVsop(3.25E-9, 4.30579452294, 124156.43985787958), new Vsop87.LnVsop(3.64E-9, 2.32783082897, 84546.78527471398), new Vsop87.LnVsop(3.31E-9, 0.77022299532, 188276.6540401716), new Vsop87.LnVsop(2.67E-9, 3.81782594348, 19406.6782881746), new Vsop87.LnVsop(2.7E-9, 6.02001495547, 78114.14622758799), new Vsop87.LnVsop(2.73E-9, 3.66893645163, 129483.91596626239), new Vsop87.LnVsop(2.63E-9, 0.18734818549, 77197.21394753258), new Vsop87.LnVsop(2.68E-9, 3.25183532034, 131498.89763806018), new Vsop87.LnVsop(2.84E-9, 1.93841351149, 76044.9523205358), new Vsop87.LnVsop(2.95E-9, 5.54100863182, 130969.20667296558), new Vsop87.LnVsop(2.46E-9, 1.45339450432, 78270.82297172339), new Vsop87.LnVsop(2.59E-9, 3.08233305443, 77211.44104153418), new Vsop87.LnVsop(3.35E-9, 5.92215647534, 146314.13330323418), new Vsop87.LnVsop(2.53E-9, 2.86398839801, 121335.60871375339), new Vsop87.LnVsop(3.38E-9, 3.95834695582, 78690.30761559859), new Vsop87.LnVsop(3.17E-9, 3.98389279162, 79852.78232000639), new Vsop87.LnVsop(2.32E-9, 4.66675132764, 28206.6670019526), new Vsop87.LnVsop(2.47E-9, 1.40502512052, 181505.94343892598), new Vsop87.LnVsop(2.28E-9, 0.2567002526, 103711.71527998279), new Vsop87.LnVsop(2.19E-9, 4.69778127839, 71582.48457132299), new Vsop87.LnVsop(2.21E-9, 4.46397767224, 81706.28436968799), new Vsop87.LnVsop(2.54E-9, 1.43722023804, 5327.4761083828), new Vsop87.LnVsop(1.99E-9, 5.76845937762, 157483.01859105378), new Vsop87.LnVsop(2.53E-9, 2.47477562856, 72936.23331633979), new Vsop87.LnVsop(1.91E-9, 4.17878596373, 134991.4692049298), new Vsop87.LnVsop(2.46E-9, 5.21482964733, 178063.3684939606), new Vsop87.LnVsop(1.82E-9, 4.31642421149, 104371.28232719658), new Vsop87.LnVsop(2.06E-9, 1.62001821938, 106570.36967048359), new Vsop87.LnVsop(2.34E-9, 2.18969474341, 100909.03762133139), new Vsop87.LnVsop(1.76E-9, 3.58295520082, 48835.19385644859), new Vsop87.LnVsop(1.88E-9, 2.58568213426, 51707.84129279399), new Vsop87.LnVsop(1.77E-9, 1.89452084301, 52169.17772424839), new Vsop87.LnVsop(1.68E-9, 3.01268585761, 23754.70674870219), new Vsop87.LnVsop(2.22E-9, 4.35554033541, 52643.7712735028), new Vsop87.LnVsop(1.69E-9, 5.25191713657, 102232.84870591838), new Vsop87.LnVsop(1.88E-9, 5.55461046577, 156100.82065856917), new Vsop87.LnVsop(1.63E-9, 1.72111046975, 104138.31347085879), new Vsop87.LnVsop(2.04E-9, 5.64364799554, 154938.34595416137), new Vsop87.LnVsop(1.61E-9, 0.06505273733, 78187.44335344699), new Vsop87.LnVsop(1.55E-9, 3.29528249467, 97112.93697469679), new Vsop87.LnVsop(1.52E-9, 1.66427224942, 25654.19140369739), new Vsop87.LnVsop(1.79E-9, 2.20391378287, 104331.94280539699), new Vsop87.LnVsop(1.57E-9, 5.91591630738, 51742.09454527159), new Vsop87.LnVsop(1.76E-9, 5.0339897777, 52182.4348420484), new Vsop87.LnVsop(1.45E-9, 0.34805544633, 78417.48823520739), new Vsop87.LnVsop(1.51E-9, 0.84018770177, 26237.46633870879), new Vsop87.LnVsop(1.43E-9, 0.36103472282, 27154.3986187642), new Vsop87.LnVsop(1.42E-9, 5.87483350318, 26037.90651966999), new Vsop87.LnVsop(1.67E-9, 4.43526495468, 25668.418497699), new Vsop87.LnVsop(1.37E-9, 2.85270426804, 119116.85160956658), new Vsop87.LnVsop(1.61E-9, 5.91460332085, 207643.8432024044), new Vsop87.LnVsop(1.3E-9, 6.26916213189, 137678.191299471), new Vsop87.LnVsop(1.3E-9, 0.93333784378, 433.7117378768), new Vsop87.LnVsop(1.4E-9, 1.22461009264, 26137.8997634784), new Vsop87.LnVsop(1.44E-9, 4.56299590276, 419.4846438752), new Vsop87.LnVsop(1.45E-9, 2.5328601799, 116917.76426627958), new Vsop87.LnVsop(1.45E-9, 3.7460662372, 27140.17152476259), new Vsop87.LnVsop(1.55E-9, 3.66242807884, 365230.6439820388), new Vsop87.LnVsop(1.24E-9, 0.92717268171, 104347.73123093879), new Vsop87.LnVsop(1.4E-9, 0.11273697711, 78109.93061423779), new Vsop87.LnVsop(1.26E-9, 1.13792891192, 51322.60990139639), new Vsop87.LnVsop(1.46E-9, 3.2566356195, 3340.6124266998), new Vsop87.LnVsop(1.21E-9, 5.11057976962, 176953.98994186718), new Vsop87.LnVsop(1.25E-9, 5.63667517623, 104355.49390165479), new Vsop87.LnVsop(1.55E-9, 2.308386156, 51756.3216392732), new Vsop87.LnVsop(1.36E-9, 3.42158321317, 140652.80125408198), new Vsop87.LnVsop(1.15E-9, 6.25287963576, 39743.7636327506), new Vsop87.LnVsop(1.13E-9, 0.7934702234, 7994.5284420242), new Vsop87.LnVsop(1.26E-9, 0.12477471678, 52815.7035694624), new Vsop87.LnVsop(1.21E-9, 0.6806270512, 50483.640613646), new Vsop87.LnVsop(1.18E-9, 0.87289599411, 137210.22630911658), new Vsop87.LnVsop(1.12E-9, 2.41400200785, 97580.90196505119), new Vsop87.LnVsop(1.3E-9, 1.2263615734, 209812.60368468694), new Vsop87.LnVsop(1.1E-9, 3.15710759789, 25234.70675982219), new Vsop87.LnVsop(1.09E-9, 2.85474641096, 24395.7374720718), new Vsop87.LnVsop(1.08E-9, 5.73546302458, 853.196381752), new Vsop87.LnVsop(1.41E-9, 4.76861590569, 28421.0995344462), new Vsop87.LnVsop(1.43E-9, 0.57981900049, 170049.1702910366), new Vsop87.LnVsop(1.27E-9, 5.39584845133, 110634.68841628819), new Vsop87.LnVsop(1.1E-9, 0.79295057311, 104564.91166173479), new Vsop87.LnVsop(1.02E-9, 5.77868711823, 182085.63102592478), new Vsop87.LnVsop(1.08E-9, 0.78119056015, 42153.969003049), new Vsop87.LnVsop(1.01E-9, 6.24154568899, 1692.1656695024), new Vsop87.LnVsop(1.25E-9, 1.72826454224, 104344.49901929598), new Vsop87.LnVsop(1.12E-9, 1.53710769184, 18093.37469954999), new Vsop87.LnVsop(1.0E-9, 6.03680991052, 147423.51185532758), new Vsop87.LnVsop(1.02E-9, 2.16764418605, 32769.1279949738), new Vsop87.LnVsop(1.27E-9, 5.69553247654, 44181.27784112419), new Vsop87.LnVsop(9.6E-10, 2.81661028351, 104202.04936916218), new Vsop87.LnVsop(9.5E-10, 6.16381857353, 103299.34418310839), new Vsop87.LnVsop(9.5E-10, 3.0857732466, 70269.18098269838), new Vsop87.LnVsop(9.6E-10, 3.26683160108, 103285.11708910679), new Vsop87.LnVsop(1.01E-9, 1.49873307582, 40565.2543247742), new Vsop87.LnVsop(9.9E-10, 0.12170167751, 167850.0829477496), new Vsop87.LnVsop(9.9E-10, 3.80889608656, 214364.55718174577), new Vsop87.LnVsop(9.3E-10, 3.27145572677, 90695.75207512038), new Vsop87.LnVsop(1.04E-9, 5.35399197115, 126996.94076290558), new Vsop87.LnVsop(1.05E-9, 0.73047337573, 104778.21075717278), new Vsop87.LnVsop(8.9E-10, 2.8272926468, 50579.61984086379), new Vsop87.LnVsop(9.8E-10, 0.55396763839, 33967.99229491319), new Vsop87.LnVsop(8.7E-10, 1.47914076091, 97670.38771289718), new Vsop87.LnVsop(8.9E-10, 0.41556188853, 26164.1692128498), new Vsop87.LnVsop(1.17E-9, 0.17847108292, 61279.713277266), new Vsop87.LnVsop(1.03E-9, 2.68612271799, 172402.0364448084), new Vsop87.LnVsop(9.1E-10, 2.29372021338, 157057.10981453978), new Vsop87.LnVsop(8.4E-10, 4.31845216169, 60055.89543648739), new Vsop87.LnVsop(8.5E-10, 4.50689362891, 104358.72611329758), new Vsop87.LnVsop(9.8E-10, 0.75115343364, 105940.68546158058), new Vsop87.LnVsop(8.2E-10, 2.80073166731, 52101.02468458109), new Vsop87.LnVsop(8.6E-10, 0.38064985881, 74923.09699802278), new Vsop87.LnVsop(7.7E-10, 4.91622546328, 24491.71669928959), new Vsop87.LnVsop(1.04E-9, 6.08675041589, 10021.8372800994), new Vsop87.LnVsop(9.4E-10, 2.21717937515, 25973.46385288896), new Vsop87.LnVsop(7.9E-10, 4.63581240332, 2333.196392872), new Vsop87.LnVsop(7.6E-10, 4.09099479123, 1596.1864422846), new Vsop87.LnVsop(7.6E-10, 0.07595547847, 157586.80077963436), new Vsop87.LnVsop(8.9E-10, 0.519242848, 50593.84693486539), new Vsop87.LnVsop(7.8E-10, 5.85409167716, 18207.81398823521), new Vsop87.LnVsop(8.3E-10, 1.48349269554, 54294.57014352679), new Vsop87.LnVsop(1.02E-9, 1.11721130868, 150244.3429994538), new Vsop87.LnVsop(8.1E-10, 0.43636227439, 155571.81910783658), new Vsop87.LnVsop(7.2E-10, 2.77542766328, 77829.99768684579), new Vsop87.LnVsop(9.8E-10, 3.04610370668, 16066.0658614748), new Vsop87.LnVsop(8.9E-10, 3.9149043855, 68241.8721446232), new Vsop87.LnVsop(7.6E-10, 3.32866048942, 129799.61842155698), new Vsop87.LnVsop(9.1E-10, 4.99129744497, 102132.85546210999), new Vsop87.LnVsop(8.8E-10, 4.54427823805, 51543.0225438352), new Vsop87.LnVsop(9.2E-10, 4.88784734744, 26202.34243025941), new Vsop87.LnVsop(6.6E-10, 1.97294274713, 632.7837393132), new Vsop87.LnVsop(6.6E-10, 1.34878248252, 52808.59002246159), new Vsop87.LnVsop(7.1E-10, 1.21542275966, 107794.1875112622), new Vsop87.LnVsop(8.8E-10, 3.90645324859, 74.7815985673), new Vsop87.LnVsop(7.6E-10, 1.11687579908, 78731.674415077), new Vsop87.LnVsop(6.0E-10, 4.94675806504, 78257.08086582259), new Vsop87.LnVsop(6.9E-10, 5.4670059921, 77844.22478084739), new Vsop87.LnVsop(6.7E-10, 4.25059971851, 14477.3511832), new Vsop87.LnVsop(6.0E-10, 2.79968815396, 25863.55834587229), new Vsop87.LnVsop(6.0E-10, 4.24009349898, 52225.8029050526), new Vsop87.LnVsop(5.9E-10, 3.80960613484, 76571.54375522019), new Vsop87.LnVsop(5.9E-10, 5.90296243964, 103.0927742186), new Vsop87.LnVsop(6.0E-10, 5.62071455354, 77795.74443436819), new Vsop87.LnVsop(6.9E-10, 4.37177618753, 207593.8465805002), new Vsop87.LnVsop(6.6E-10, 0.49864122197, 51951.46148744649), new Vsop87.LnVsop(5.8E-10, 4.28165906216, 77410.51304297059), new Vsop87.LnVsop(5.8E-10, 1.6382921544, 51013.33157874059), new Vsop87.LnVsop(6.6E-10, 0.61355815218, 51639.00177105299), new Vsop87.LnVsop(5.7E-10, 3.15664991567, 104275.34649502118), new Vsop87.LnVsop(5.8E-10, 4.41184070176, 26720.68688088739), new Vsop87.LnVsop(7.5E-10, 0.13948969985, 1581.959348283), new Vsop87.LnVsop(5.7E-10, 0.42010984372, 23439.44831610119), new Vsop87.LnVsop(6.9E-10, 6.03960082139, 29428.515568274), new Vsop87.LnVsop(5.5E-10, 0.87572150774, 161079.37234650398), new Vsop87.LnVsop(5.4E-10, 2.10493067106, 2648.454825473), new Vsop87.LnVsop(7.0E-10, 1.89517732514, 204151.27163553477), new Vsop87.LnVsop(5.4E-10, 3.73432597012, 24925.4284371664), new Vsop87.LnVsop(5.5E-10, 4.74357158199, 49527.35145767539), new Vsop87.LnVsop(7.1E-10, 2.67042805934, 24505.94379329119), new Vsop87.LnVsop(5.7E-10, 1.10423273567, 130459.18546877075), new Vsop87.LnVsop(6.8E-10, 5.2916535582, 26013.1215430069), new Vsop87.LnVsop(5.4E-10, 0.06015891365, 52072.71350892979), new Vsop87.LnVsop(5.3E-10, 0.06492319557, 536.8045120954), new Vsop87.LnVsop(5.3E-10, 5.00803045767, 25977.69682035479), new Vsop87.LnVsop(5.2E-10, 4.17449418547, 25131.61398560359), new Vsop87.LnVsop(5.2E-10, 3.31068956896, 7880.08915333899), new Vsop87.LnVsop(7.0E-10, 6.10736618856, 52278.89905736699), new Vsop87.LnVsop(5.2E-10, 0.1790620153, 224.3447957019), new Vsop87.LnVsop(5.9E-10, 1.97907742423, 51219.51712717779), new Vsop87.LnVsop(5.7E-10, 2.64610234569, 52125.80966124419), new Vsop87.LnVsop(5.1E-10, 2.51000813692, 183570.921732628), new Vsop87.LnVsop(5.0E-10, 4.67879007204, 130226.21661243298), new Vsop87.LnVsop(5.0E-10, 4.77338184815, 25780.3455206046), new Vsop87.LnVsop(5.3E-10, 2.81565030425, 55516.4187098482), new Vsop87.LnVsop(5.7E-10, 2.13334998272, 128320.75184749259), new Vsop87.LnVsop(4.9E-10, 2.32089689347, 26395.46076254379), new Vsop87.LnVsop(4.9E-10, 4.95995730259, 956.2891559706), new Vsop87.LnVsop(4.7E-10, 4.20639928841, 52250.5878817157), new Vsop87.LnVsop(5.8E-10, 2.23088726891, 52065.59996192899), new Vsop87.LnVsop(4.8E-10, 5.31281750704, 1162.4747044078), new Vsop87.LnVsop(6.2E-10, 6.11760884137, 22747.2907148744), new Vsop87.LnVsop(5.1E-10, 5.16824462074, 130419.8459469712), new Vsop87.LnVsop(5.8E-10, 1.50489246106, 54509.0026760204), new Vsop87.LnVsop(6.0E-10, 0.4387895693, 116783.65521669458), new Vsop87.LnVsop(5.9E-10, 1.50481526118, 26507.38778544939), new Vsop87.LnVsop(4.7E-10, 3.28472646958, 25565.3257234804), new Vsop87.LnVsop(5.6E-10, 2.45380736735, 181026.24909573558), new Vsop87.LnVsop(4.5E-10, 0.64406765475, 52698.38370124219), new Vsop87.LnVsop(5.1E-10, 3.46813739714, 53242.3017603384), new Vsop87.LnVsop(4.9E-10, 0.43567376549, 27999.1026247914), new Vsop87.LnVsop(4.6E-10, 0.93498183343, 26162.6847401415), new Vsop87.LnVsop(4.3E-10, 5.95322613197, 76667.52298243798), new Vsop87.LnVsop(6.0E-10, 1.79766045757, 78270.3379836226), new Vsop87.LnVsop(5.6E-10, 2.27821469853, 182188.72380014337), new Vsop87.LnVsop(4.3E-10, 2.06804186419, 51859.41441349179), new Vsop87.LnVsop(4.3E-10, 3.95891822367, 26521.614879451), new Vsop87.LnVsop(4.4E-10, 1.68132632019, 23888.81579828719), new Vsop87.LnVsop(5.1E-10, 5.32970797935, 66653.15746634839), new Vsop87.LnVsop(5.4E-10, 3.94227996, 52325.36948028299), new Vsop87.LnVsop(4.3E-10, 5.13712390348, 11610.5519583742), new Vsop87.LnVsop(4.2E-10, 4.6141491345, 52492.19815280499), new Vsop87.LnVsop(4.6E-10, 3.3964447796, 104505.39137678158), new Vsop87.LnVsop(4.6E-10, 4.83404952611, 110.2063212194), new Vsop87.LnVsop(4.5E-10, 3.54033283524, 50800.03248330259), new Vsop87.LnVsop(4.1E-10, 5.69274197267, 24712.1293417284), new Vsop87.LnVsop(4.0E-10, 0.05183500108, 123200.84011627098), new Vsop87.LnVsop(5.3E-10, 0.61041631437, 53228.07466633679), new Vsop87.LnVsop(3.9E-10, 3.11160576014, 25984.8103673556), new Vsop87.LnVsop(4.6E-10, 2.53560218838, 50696.93970908399), new Vsop87.LnVsop(3.8E-10, 4.4434786655, 29416.03879785439), new Vsop87.LnVsop(4.1E-10, 2.6568489705, 233731.7463439786), new Vsop87.LnVsop(3.7E-10, 3.37391100283, 1375.7737998458), new Vsop87.LnVsop(3.8E-10, 5.61387655032, 143005.6674078538), new Vsop87.LnVsop(3.7E-10, 5.4285819309, 28286.9904848612), new Vsop87.LnVsop(4.9E-10, 5.33663311556, 99024.13645791399), new Vsop87.LnVsop(4.0E-10, 5.63437453789, 522.5774180938), new Vsop87.LnVsop(3.6E-10, 5.94438052681, 145204.75475114078), new Vsop87.LnVsop(3.7E-10, 5.22344534146, 52595.29092702359), new Vsop87.LnVsop(3.9E-10, 3.40316202566, 25551.09862947879), new Vsop87.LnVsop(3.8E-10, 2.0772489991, 153084.84390447979), new Vsop87.LnVsop(3.9E-10, 3.20082564706, 163766.0944410452), new Vsop87.LnVsop(4.2E-10, 4.90498753252, 25771.5112719176), new Vsop87.LnVsop(4.1E-10, 2.9901418675, 26190.99591579279), new Vsop87.LnVsop(4.4E-10, 1.11568032791, 26404.2950112308), new Vsop87.LnVsop(4.5E-10, 4.61945019127, 132658.27281205778), new Vsop87.LnVsop(3.7E-10, 0.21864451347, 166740.70439565618), new Vsop87.LnVsop(3.4E-10, 1.94277190876, 203041.8930834414), new Vsop87.LnVsop(4.5E-10, 3.16163643681, 104197.83375581198), new Vsop87.LnVsop(4.6E-10, 4.46390395917, 316.3918696566), new Vsop87.LnVsop(3.9E-10, 2.02714443659, 136722.59155786238), new Vsop87.LnVsop(3.4E-10, 1.34251978696, 467.9649903544), new Vsop87.LnVsop(4.3E-10, 3.34502651928, 78903.60671103658), new Vsop87.LnVsop(3.9E-10, 3.65197311309, 196137.07343261078), new Vsop87.LnVsop(3.7E-10, 0.36873111038, 391318.54712361295), new Vsop87.LnVsop(3.7E-10, 2.88381301226, 36109.7404216736), new Vsop87.LnVsop(3.7E-10, 1.6644937118, 52290.24557183361), new Vsop87.LnVsop(3.6E-10, 3.91802057863, 54087.0057663656), new Vsop87.LnVsop(3.4E-10, 0.07829118699, 26294.08869001139), new Vsop87.LnVsop(3.3E-10, 2.57632788743, 26941.0995233262), new Vsop87.LnVsop(3.4E-10, 1.66576107128, 49842.60989027639), new Vsop87.LnVsop(4.2E-10, 3.65180415116, 76681.75007643958), new Vsop87.LnVsop(3.2E-10, 4.02686738221, 24356.7807886416), new Vsop87.LnVsop(4.1E-10, 3.48139478644, 26610.48055966799), new Vsop87.LnVsop(4.2E-10, 4.68451282229, 24609.0365675098), new Vsop87.LnVsop(4.0E-10, 1.30779951065, 77630.92568540938), new Vsop87.LnVsop(3.3E-10, 3.31610603906, 65831.6667743248), new Vsop87.LnVsop(3.1E-10, 0.54967680937, 13362.4497067992), new Vsop87.LnVsop(3.4E-10, 2.432945642, 26421.7590823436), new Vsop87.LnVsop(3.1E-10, 2.40792798784, 130443.39704322898), new Vsop87.LnVsop(3.5E-10, 5.90129083656, 78188.92782615528), new Vsop87.LnVsop(3.2E-10, 5.58376072198, 25881.717593137), new Vsop87.LnVsop(3.1E-10, 3.9817899305, 130435.63437251298), new Vsop87.LnVsop(3.2E-10, 3.03405555905, 27780.06881107659), new Vsop87.LnVsop(3.1E-10, 5.37276115971, 75930.51303185058), new Vsop87.LnVsop(3.8E-10, 4.61595624173, 130432.40216087017), new Vsop87.LnVsop(3.4E-10, 4.68012563436, 25754.0472008048), new Vsop87.LnVsop(3.0E-10, 2.76994252191, 173511.41499690176), new Vsop87.LnVsop(3.7E-10, 4.37555392925, 1478.8665740644), new Vsop87.LnVsop(3.0E-10, 2.69926409993, 208173.534167499), new Vsop87.LnVsop(3.9E-10, 4.04332875289, 34282.1784747828), new Vsop87.LnVsop(3.3E-10, 1.47225901574, 55503.94193942859), new Vsop87.LnVsop(2.9E-10, 3.09378372977, 27819.0254945068), new Vsop87.LnVsop(3.0E-10, 2.31018804154, 26624.70765366959), new Vsop87.LnVsop(2.7E-10, 0.66232275031, 240452.46032331997), new Vsop87.LnVsop(3.5E-10, 2.18492047595, 22759.76748529401), new Vsop87.LnVsop(3.5E-10, 5.40621887499, 58857.03113654799), new Vsop87.LnVsop(2.8E-10, 5.46919985489, 123668.80510662538), new Vsop87.LnVsop(2.8E-10, 3.82777149286, 130866.11389874699), new Vsop87.LnVsop(2.7E-10, 3.91211962905, 163298.1294506908), new Vsop87.LnVsop(3.2E-10, 3.55778676569, 52252.07235442399), new Vsop87.LnVsop(3.6E-10, 5.27162720206, 52061.36699446317), new Vsop87.LnVsop(2.7E-10, 0.81850160176, 25455.119402261), new Vsop87.LnVsop(3.0E-10, 6.23443583867, 24176.703658357), new Vsop87.LnVsop(2.5E-10, 1.48733698955, 60370.08161635699), new Vsop87.LnVsop(2.5E-10, 3.33473959558, 206.1855484372), new Vsop87.LnVsop(2.5E-10, 2.2302074861, 12725.453434775), new Vsop87.LnVsop(2.7E-10, 4.42031362938, 78896.49316403578), new Vsop87.LnVsop(2.5E-10, 5.37655641321, 183145.012956114), new Vsop87.LnVsop(2.6E-10, 3.84636156987, 132028.58860315479), new Vsop87.LnVsop(2.5E-10, 2.93714796459, 129387.24732468258), new Vsop87.LnVsop(2.4E-10, 4.03438874235, 26089.38761428249), new Vsop87.LnVsop(2.4E-10, 4.80804047978, 27311.72098235281), new Vsop87.LnVsop(2.5E-10, 5.86264185382, 130289.95251073639), new Vsop87.LnVsop(2.4E-10, 3.09117849899, 26086.4186688659), new Vsop87.LnVsop(2.4E-10, 1.40367634737, 25446.4895798352), new Vsop87.LnVsop(3.4E-10, 3.35416716912, 193937.9860893238), new Vsop87.LnVsop(3.3E-10, 4.25244677806, 235900.50682626115), new Vsop87.LnVsop(2.4E-10, 2.35927539622, 25440.89230825939), new Vsop87.LnVsop(2.7E-10, 2.64020366218, 44295.7171298094), new Vsop87.LnVsop(2.4E-10, 2.60446530529, 125112.03959948818), new Vsop87.LnVsop(2.8E-10, 3.86103745286, 130652.81480330898), new Vsop87.LnVsop(2.6E-10, 3.37480543898, 87367.61641884019), new Vsop87.LnVsop(2.4E-10, 3.83246872537, 52381.99183158559), new Vsop87.LnVsop(2.3E-10, 0.19120233351, 647.0108333148), new Vsop87.LnVsop(2.7E-10, 4.1481261296, 176332.24614102798), new Vsop87.LnVsop(2.3E-10, 5.73059971283, 26729.31670331319), new Vsop87.LnVsop(2.5E-10, 0.03995490746, 129373.02023068098), new Vsop87.LnVsop(2.8E-10, 6.14165948724, 38813.3565763492), new Vsop87.LnVsop(2.5E-10, 5.64177196482, 198489.9395863826), new Vsop87.LnVsop(2.6E-10, 2.7786200885, 64901.25971792339), new Vsop87.LnVsop(2.2E-10, 2.47522981968, 24864.08530079559), new Vsop87.LnVsop(2.3E-10, 4.26566547587, 26222.0121911592), new Vsop87.LnVsop(2.4E-10, 4.52888862412, 123758.29085447139), new Vsop87.LnVsop(2.2E-10, 2.21341244399, 23866.04650697719), new Vsop87.LnVsop(2.3E-10, 2.8908635451, 25953.79409198919), new Vsop87.LnVsop(2.8E-10, 4.67525933004, 80382.47328510099), new Vsop87.LnVsop(2.5E-10, 0.81895690109, 94329.77528619739), new Vsop87.LnVsop(2.1E-10, 5.56950527628, 52712.61079524379), new Vsop87.LnVsop(2.1E-10, 0.94595250629, 27684.0895838588), new Vsop87.LnVsop(2.3E-10, 1.24936319391, 130446.62925487179), new Vsop87.LnVsop(2.2E-10, 1.55521011593, 24998.19435038059), new Vsop87.LnVsop(2.4E-10, 3.25849979981, 27669.86248985719), new Vsop87.LnVsop(2.1E-10, 3.15563465532, 183674.70392120857), new Vsop87.LnVsop(2.0E-10, 1.45816857985, 75615.25459924959), new Vsop87.LnVsop(2.8E-10, 2.65265871685, 78366.80219894118), new Vsop87.LnVsop(2.0E-10, 2.85755801769, 78160.61665050399), new Vsop87.LnVsop(2.2E-10, 0.13822368415, 51528.79544983359), new Vsop87.LnVsop(2.2E-10, 1.54444862819, 158746.17595363196), new Vsop87.LnVsop(1.9E-10, 1.96807510475, 25344.9130810416), new Vsop87.LnVsop(1.9E-10, 3.62647514058, 78039.36462902068), new Vsop87.LnVsop(1.9E-10, 2.59520978672, 17893.6278083656), new Vsop87.LnVsop(1.9E-10, 5.07604473723, 230239.17477710897), new Vsop87.LnVsop(1.9E-10, 5.86669383027, 103917.90082841998), new Vsop87.LnVsop(2.3E-10, 1.73834723518, 128220.75860368418), new Vsop87.LnVsop(2.0E-10, 5.58923906956, 27177.6119327678), new Vsop87.LnVsop(1.8E-10, 3.70639453097, 77726.90491262719), new Vsop87.LnVsop(1.9E-10, 2.26467048619, 103932.12792242158), new Vsop87.LnVsop(1.8E-10, 5.25381269855, 28736.3579670472), new Vsop87.LnVsop(1.8E-10, 4.77217402671, 77101.23472031478), new Vsop87.LnVsop(1.9E-10, 3.72677202378, 31415.379249957), new Vsop87.LnVsop(1.9E-10, 4.18744479746, 104819.57755665119), new Vsop87.LnVsop(1.8E-10, 5.1211173017, 77307.42026875199), new Vsop87.LnVsop(1.9E-10, 1.61508433009, 51653.22886505459), new Vsop87.LnVsop(2.2E-10, 3.45701154104, 101011.00013959699), new Vsop87.LnVsop(1.8E-10, 0.82201704537, 26073.67604757259), new Vsop87.LnVsop(1.7E-10, 3.34555502934, 23919.1426592916), new Vsop87.LnVsop(1.7E-10, 0.84066532921, 86143.79857806159), new Vsop87.LnVsop(1.6E-10, 1.27849952927, 51868.2486621788), new Vsop87.LnVsop(2.0E-10, 0.96796480913, 52609.51802102519), new Vsop87.LnVsop(1.8E-10, 5.44449345767, 25508.2155545754), new Vsop87.LnVsop(1.6E-10, 0.52044099995, 2221.856634597), new Vsop87.LnVsop(2.2E-10, 3.54324097486, 181659.72224941078), new Vsop87.LnVsop(2.0E-10, 0.07176334053, 155887.52156313116), new Vsop87.LnVsop(1.6E-10, 0.63079626568, 102659.44689679438), new Vsop87.LnVsop(1.7E-10, 3.92564748171, 51852.30086649099), new Vsop87.LnVsop(1.6E-10, 5.74192653915, 96357.08412427259), new Vsop87.LnVsop(1.9E-10, 5.08675029863, 118828.96374949679), new Vsop87.LnVsop(1.7E-10, 2.60085033622, 24448.8336243862), new Vsop87.LnVsop(1.6E-10, 5.52297362078, 2199.087343287), new Vsop87.LnVsop(1.6E-10, 3.37075960327, 1911.1994832172), new Vsop87.LnVsop(1.9E-10, 1.2958784405, 233681.74972207437), new Vsop87.LnVsop(2.0E-10, 3.18923375101, 51969.62073471119), new Vsop87.LnVsop(1.6E-10, 1.11677427544, 103498.41618454478), new Vsop87.LnVsop(1.7E-10, 3.27627721422, 26312.2479372761), new Vsop87.LnVsop(1.6E-10, 1.13221502154, 742.9900605326), new Vsop87.LnVsop(1.6E-10, 5.54277096187, 207114.15223730978), new Vsop87.LnVsop(1.5E-10, 2.7545444235, 26709.6469424134), new Vsop87.LnVsop(1.6E-10, 5.3198854146, 78153.50310350319), new Vsop87.LnVsop(1.5E-10, 1.72659803202, 104344.98400739678), new Vsop87.LnVsop(1.5E-10, 1.16473739048, 92741.06060792258), new Vsop87.LnVsop(1.5E-10, 6.19260970054, 130363.24963659538), new Vsop87.LnVsop(1.5E-10, 4.39941864192, 25466.159340735), new Vsop87.LnVsop(1.5E-10, 5.91639466654, 81604.32185142238), new Vsop87.LnVsop(1.6E-10, 1.7797832725, 26667.590728573), new Vsop87.LnVsop(1.4E-10, 1.02452017274, 78313.70604662679), new Vsop87.LnVsop(1.6E-10, 1.76432370787, 27044.1922975448), new Vsop87.LnVsop(1.4E-10, 2.39923226256, 103883.64757594238), new Vsop87.LnVsop(1.9E-10, 6.2743914302, 25764.39772491679), new Vsop87.LnVsop(1.4E-10, 1.89468926641, 37698.4550999484), new Vsop87.LnVsop(1.5E-10, 2.42074969299, 27250.37784598199), new Vsop87.LnVsop(1.7E-10, 5.62209405324, 51432.81622261579), new Vsop87.LnVsop(1.4E-10, 0.57719222986, 8194.2753332086), new Vsop87.LnVsop(1.6E-10, 3.05485736253, 22625.658435709), new Vsop87.LnVsop(1.4E-10, 2.01915358765, 156507.7490885454), new Vsop87.LnVsop(1.4E-10, 4.00068734895, 187167.2754880782), new Vsop87.LnVsop(1.8E-10, 2.79341357052, 323.5054166574), new Vsop87.LnVsop(1.4E-10, 3.8139379022, 28256.66362385679), new Vsop87.LnVsop(1.6E-10, 5.63776026285, 209658.82487420217), new Vsop87.LnVsop(1.4E-10, 0.41463717901, 76887.93562487679), new Vsop87.LnVsop(1.5E-10, 4.52522828506, 27726.9726587622), new Vsop87.LnVsop(1.7E-10, 1.61712241486, 26198.1094627936), new Vsop87.LnVsop(1.7E-10, 4.28622469558, 133882.09065283637), new Vsop87.LnVsop(1.3E-10, 1.03005720435, 25867.49049913539), new Vsop87.LnVsop(1.4E-10, 5.57249033787, 2008.557539159), new Vsop87.LnVsop(1.4E-10, 1.55327261244, 156314.1197540072), new Vsop87.LnVsop(1.7E-10, 6.07980209544, 49953.94964855139), new Vsop87.LnVsop(1.5E-10, 4.87082556178, 104358.2411251968), new Vsop87.LnVsop(1.3E-10, 3.77190272158, 19.66976089979), new Vsop87.LnVsop(1.4E-10, 1.15128244599, 949.1756089698), new Vsop87.LnVsop(1.5E-10, 5.41370603467, 208276.62694171758), new Vsop87.LnVsop(1.7E-10, 4.64348696761, 112231.70171963578), new Vsop87.LnVsop(1.5E-10, 5.32660829331, 154408.65498906677), new Vsop87.LnVsop(1.3E-10, 2.83396822652, 25169.9728555924), new Vsop87.LnVsop(1.3E-10, 4.02048329912, 417406.4502651872), new Vsop87.LnVsop(1.6E-10, 3.55065193748, 86457.98475793119), new Vsop87.LnVsop(1.4E-10, 3.36690643779, 12546.481939083), new Vsop87.LnVsop(1.3E-10, 0.9993633798, 78338.49102328988), new Vsop87.LnVsop(1.2E-10, 3.73185561368, 78786.28684281638), new Vsop87.LnVsop(1.3E-10, 4.55944709442, 80596.9058175946), new Vsop87.LnVsop(1.3E-10, 3.68826251139, 79315.97780791098), new Vsop87.LnVsop(1.4E-10, 4.1679843922, 156547.08861034497), new Vsop87.LnVsop(1.2E-10, 3.12250614731, 149288.74325784517), new Vsop87.LnVsop(1.2E-10, 2.69822275229, 153.7788104848), new Vsop87.LnVsop(1.2E-10, 4.38117483432, 27005.83342755599), new Vsop87.LnVsop(1.2E-10, 0.18670274235, 27463.67694142), new Vsop87.LnVsop(1.4E-10, 4.15157533592, 29550.14784743939), new Vsop87.LnVsop(1.2E-10, 2.802429063, 102755.42612401219), new Vsop87.LnVsop(1.1E-10, 5.82534982697, 259819.64948555277), new Vsop87.LnVsop(1.1E-10, 2.4075149941, 169093.57054942797), new Vsop87.LnVsop(1.2E-10, 0.49717322689, 102769.65321801379), new Vsop87.LnVsop(1.4E-10, 5.70135994622, 76784.84285065818), new Vsop87.LnVsop(1.2E-10, 5.56466695759, 26402.0893214438), new Vsop87.LnVsop(1.2E-10, 5.2093926748, 77947.31755506598), new Vsop87.LnVsop(1.2E-10, 1.48332519091, 78580.10129437919), new Vsop87.LnVsop(1.1E-10, 1.64550613889, 25773.71696170459), new Vsop87.LnVsop(1.4E-10, 2.00272444242, 846.0828347512), new Vsop87.LnVsop(1.1E-10, 2.45694663172, 34082.4315835984), new Vsop87.LnVsop(1.3E-10, 0.71976807921, 78413.27262185719), new Vsop87.LnVsop(1.1E-10, 5.17923563094, 162810.49469943656), new Vsop87.LnVsop(1.1E-10, 5.59096637831, 24203.0019781568), new Vsop87.LnVsop(1.1E-10, 2.73725230614, 171292.65789271498), new Vsop87.LnVsop(1.1E-10, 0.45561312943, 2111.6503133776), new Vsop87.LnVsop(1.0E-10, 3.29302391758, 192828.60753723036), new Vsop87.LnVsop(1.0E-10, 0.45749830582, 222224.97657418498), new Vsop87.LnVsop(1.3E-10, 5.70888843757, 78213.71280281838), new Vsop87.LnVsop(1.1E-10, 0.63918585952, 26118.2300025786), new Vsop87.LnVsop(1.1E-10, 4.37242083406, 103718.82882698359), new Vsop87.LnVsop(1.3E-10, 5.83046207525, 26411.4085582316), new Vsop87.LnVsop(1.0E-10, 4.69854881597, 2125.8774073792), new Vsop87.LnVsop(1.0E-10, 5.45767490076, 52483.36390411799), new Vsop87.LnVsop(1.1E-10, 0.28780192978, 26057.57628056979), new Vsop87.LnVsop(9.0E-11, 5.57296516954, 151199.94274106238), new Vsop87.LnVsop(1.1E-10, 0.03043165356, 104991.50985261079), new Vsop87.LnVsop(1.3E-10, 0.25136435742, 79330.20490191258), new Vsop87.LnVsop(1.0E-10, 6.23928786518, 128106.31931499895), new Vsop87.LnVsop(9.0E-11, 3.68851867839, 148532.89040742096), new Vsop87.LnVsop(1.3E-10, 3.60684923313, 39629.32434406539), new Vsop87.LnVsop(1.1E-10, 6.22990755807, 130285.73689738619), new Vsop87.LnVsop(1.1E-10, 2.89470344307, 122444.98726584678), new Vsop87.LnVsop(1.0E-10, 2.08672189789, 78683.19406859778), new Vsop87.LnVsop(1.1E-10, 1.47256834447, 156520.30530244438), new Vsop87.LnVsop(9.0E-11, 5.65081400311, 1265.5674786264), new Vsop87.LnVsop(9.0E-11, 5.2410398932, 138319.60486120995), new Vsop87.LnVsop(1.2E-10, 0.18150039505, 130593.29451835579), new Vsop87.LnVsop(9.0E-11, 6.25519800847, 53906.92863608099), new Vsop87.LnVsop(1.1E-10, 3.36897466391, 142871.55835826878), new Vsop87.LnVsop(9.0E-11, 5.47220139772, 156531.3001848032), new Vsop87.LnVsop(9.0E-11, 4.79193935369, 101703.15774082378), new Vsop87.LnVsop(9.0E-11, 2.73233240796, 38.1330356378), new Vsop87.LnVsop(9.0E-11, 5.92203424852, 62197.64356324779), new Vsop87.LnVsop(9.0E-11, 4.73313854519, 78378.1487134078), new Vsop87.LnVsop(1.1E-10, 0.80835589901, 3328.13565628019), new Vsop87.LnVsop(9.0E-11, 6.25211275054, 91919.56991589899), new Vsop87.LnVsop(9.0E-11, 5.86117346092, 199599.31813847594), new Vsop87.LnVsop(9.0E-11, 0.76170025619, 156523.5375140872), new Vsop87.LnVsop(8.0E-11, 2.63159027428, 25138.7275326044), new Vsop87.LnVsop(8.0E-11, 0.63376834726, 80174.90890793978), new Vsop87.LnVsop(8.0E-11, 5.0113188183, 229129.79622501557), new Vsop87.LnVsop(8.0E-11, 0.59095609782, 156954.01704032117), new Vsop87.LnVsop(8.0E-11, 3.96069371818, 120417.67842777158), new Vsop87.LnVsop(8.0E-11, 0.20472704456, 113455.51956041438), new Vsop87.LnVsop(8.0E-11, 0.21378629185, 13541.42120249119), new Vsop87.LnVsop(9.0E-11, 6.19522776711, 189853.99758261937), new Vsop87.LnVsop(8.0E-11, 3.46743939606, 77616.69859140778), new Vsop87.LnVsop(8.0E-11, 1.77055863395, 26076.8574413103), new Vsop87.LnVsop(7.0E-11, 0.60951368208, 158116.491744729), new Vsop87.LnVsop(7.0E-11, 5.88307805923, 51226.63067417859), new Vsop87.LnVsop(8.0E-11, 2.06054527018, 78149.27013603736), new Vsop87.LnVsop(7.0E-11, 0.67573699734, 52177.29075585669), new Vsop87.LnVsop(7.0E-11, 0.56541937862, 25985.94062330859), new Vsop87.LnVsop(8.0E-11, 5.86693477979, 104454.70534051539), new Vsop87.LnVsop(9.0E-11, 1.96737763224, 1272.6810256272), new Vsop87.LnVsop(7.0E-11, 0.44264721986, 104127.26777059489), new Vsop87.LnVsop(7.0E-11, 0.0874952827, 90989.16285949759), new Vsop87.LnVsop(7.0E-11, 0.730049807, 78469.89497315978), new Vsop87.LnVsop(7.0E-11, 6.23421813357, 52174.32181044009), new Vsop87.LnVsop(1.0E-10, 2.72048541419, 104276.83096772949), new Vsop87.LnVsop(7.0E-11, 5.16297609447, 26189.8656598398), new Vsop87.LnVsop(7.0E-11, 5.16783260362, 179172.74704605396), new Vsop87.LnVsop(8.0E-11, 0.198597914, 1.4844727083), new Vsop87.LnVsop(8.0E-11, 0.9897416462, 16703.062133499), new Vsop87.LnVsop(7.0E-11, 0.08448723866, 26098.9488418381), new Vsop87.LnVsop(7.0E-11, 5.26655384619, 48847.6706268682), new Vsop87.LnVsop(7.0E-11, 5.67290992258, 53029.0026649004), new Vsop87.LnVsop(7.0E-11, 0.70298146974, 65717.22748563958), new Vsop87.LnVsop(7.0E-11, 0.52879503896, 103814.80805420138), new Vsop87.LnVsop(7.0E-11, 1.45586274186, 51841.950342379), new Vsop87.LnVsop(8.0E-11, 2.25244914252, 149756.7082481996), new Vsop87.LnVsop(7.0E-11, 1.96966094639, 103395.32341032618), new Vsop87.LnVsop(7.0E-11, 2.29501149303, 54374.8936264354), new Vsop87.LnVsop(7.0E-11, 1.15651167402, 261988.40996783535), new Vsop87.LnVsop(7.0E-11, 0.91078726535, 27972.80430499159), new Vsop87.LnVsop(7.0E-11, 6.0271702615, 155475.15046625677), new Vsop87.LnVsop(8.0E-11, 0.6650767091, 156740.7179448832), new Vsop87.LnVsop(7.0E-11, 0.94700175748, 202420.14928260216), new Vsop87.LnVsop(8.0E-11, 0.34134938947, 78339.97549599818), new Vsop87.LnVsop(8.0E-11, 1.98845877732, 84944.9342781222), new Vsop87.LnVsop(6.0E-11, 3.16993837728, 76041.85279012559), new Vsop87.LnVsop(7.0E-11, 1.19047076397, 104984.39630560997), new Vsop87.LnVsop(7.0E-11, 2.69108098458, 156377.8556523106), new Vsop87.LnVsop(7.0E-11, 6.13097420651, 53867.97195265079), new Vsop87.LnVsop(7.0E-11, 4.82055011453, 52286.01260436779), new Vsop87.LnVsop(6.0E-11, 2.1160923388, 148.0787244263), new Vsop87.LnVsop(8.0E-11, 5.56002050185, 52509.6622239178), new Vsop87.LnVsop(6.0E-11, 3.05974031426, 151.0476698429), new Vsop87.LnVsop(7.0E-11, 2.65161871524, 220.4126424388), new Vsop87.LnVsop(6.0E-11, 2.56280940006, 224577.84272795677), new Vsop87.LnVsop(7.0E-11, 0.86158158633, 50444.6839302158), new Vsop87.LnVsop(6.0E-11, 2.00889517237, 102018.41617342478), new Vsop87.LnVsop(7.0E-11, 1.62169979249, 103189.13786188899), new Vsop87.LnVsop(7.0E-11, 0.09240531376, 220025.88923089797), new Vsop87.LnVsop(6.0E-11, 4.82758891211, 154308.6617452584), new Vsop87.LnVsop(6.0E-11, 2.408532616, 78800.51393681798), new Vsop87.LnVsop(6.0E-11, 5.65068346886, 234261.43730907317), new Vsop87.LnVsop(7.0E-11, 1.38382796577, 106470.37642667518), new Vsop87.LnVsop(6.0E-11, 2.68051758089, 77520.71936418998), new Vsop87.LnVsop(7.0E-11, 0.27107569571, 127098.90328117118), new Vsop87.LnVsop(6.0E-11, 0.91950758032, 57503.2823915312), new Vsop87.LnVsop(6.0E-11, 5.40186174612, 130020.03106399579), new Vsop87.LnVsop(7.0E-11, 4.61008524779, 81591.84508100279), new Vsop87.LnVsop(6.0E-11, 2.52775281113, 52817.21984488739), new Vsop87.LnVsop(6.0E-11, 0.06428030158, 53757.76563143139), new Vsop87.LnVsop(7.0E-11, 3.13678251018, 155460.9233722552), new Vsop87.LnVsop(5.0E-11, 2.16958206998, 104241.40624507738), new Vsop87.LnVsop(5.0E-11, 2.1612222582, 209232.91609768817), new Vsop87.LnVsop(6.0E-11, 2.67263390138, 130005.80396999417), new Vsop87.LnVsop(5.0E-11, 1.01489122668, 55638.05098901359), new Vsop87.LnVsop(5.0E-11, 1.58074341774, 50167.24874398939), new Vsop87.LnVsop(7.0E-11, 1.3200111959, 149846.1939960456), new Vsop87.LnVsop(5.0E-11, 2.48050355533, 9384.8410080752), new Vsop87.LnVsop(5.0E-11, 3.64485355863, 39450.3528483734), new Vsop87.LnVsop(7.0E-11, 5.71272099811, 70383.6202713836), new Vsop87.LnVsop(6.0E-11, 4.54553892082, 51955.39364070959), new Vsop87.LnVsop(5.0E-11, 3.69884871494, 266540.3634648941), new Vsop87.LnVsop(5.0E-11, 3.50561067502, 102975.83876645098), new Vsop87.LnVsop(5.0E-11, 3.9787215565, 53771.99272543299), new Vsop87.LnVsop(5.0E-11, 1.30705357996, 53814.87580033639), new Vsop87.LnVsop(6.0E-11, 1.01004635563, 77940.20400806518), new Vsop87.LnVsop(7.0E-11, 6.03507811966, 1485.9801210652), new Vsop87.LnVsop(5.0E-11, 2.49612730964, 102872.74599223239), new Vsop87.LnVsop(6.0E-11, 0.44812743722, 50064.15596977079), new Vsop87.LnVsop(7.0E-11, 3.00491549599, 50264.6067999312), new Vsop87.LnVsop(5.0E-11, 4.43939776622, 51534.3927214094), new Vsop87.LnVsop(5.0E-11, 2.29114170922, 61560.64729122359), new Vsop87.LnVsop(5.0E-11, 0.95563241527, 130907.4806982254), new Vsop87.LnVsop(5.0E-11, 0.0745993784, 78057.52387628538), new Vsop87.LnVsop(5.0E-11, 1.56476312573, 53399.624123927), new Vsop87.LnVsop(6.0E-11, 4.33011184164, 156534.53239644598), new Vsop87.LnVsop(5.0E-11, 4.55586232098, 52137.67324751059), new Vsop87.LnVsop(4.0E-11, 0.55691399276, 189386.03259226496), new Vsop87.LnVsop(4.0E-11, 2.65454855015, 107692.22499299659), new Vsop87.LnVsop(5.0E-11, 3.71195236567, 128747.35003836859), new Vsop87.LnVsop(4.0E-11, 0.50974112501, 54344.56676543099), new Vsop87.LnVsop(6.0E-11, 6.09359126879, 104248.51979207818), new Vsop87.LnVsop(4.0E-11, 5.91763059228, 52041.69723356339), new Vsop87.LnVsop(4.0E-11, 4.01088339341, 104401.60918820098), new Vsop87.LnVsop(5.0E-11, 0.98755148462, 1795.258443721), new Vsop87.LnVsop(5.0E-11, 4.16457595792, 129586.31932611899), new Vsop87.LnVsop(5.0E-11, 3.17164389668, 181975.4247047054), new Vsop87.LnVsop(4.0E-11, 6.18497065795, 209762.60706278277), new Vsop87.LnVsop(6.0E-11, 4.82052927723, 77741.13200662879), new Vsop87.LnVsop(5.0E-11, 0.22285727897, 50007.0458008658), new Vsop87.LnVsop(4.0E-11, 4.57695596525, 184834.07909520617), new Vsop87.LnVsop(4.0E-11, 2.32551642285, 53265.515074342), new Vsop87.LnVsop(4.0E-11, 4.83714899252, 52755.49387014719), new Vsop87.LnVsop(4.0E-11, 0.47417846704, 105403.88094948517), new Vsop87.LnVsop(4.0E-11, 2.61192597252, 50049.92887576919), new Vsop87.LnVsop(4.0E-11, 1.01847002831, 52309.9153327334), new Vsop87.LnVsop(4.0E-11, 4.93491619845, 63786.3582415226), new Vsop87.LnVsop(5.0E-11, 0.29106641233, 207747.625390985), new Vsop87.LnVsop(4.0E-11, 5.23227546931, 52027.72755872209), new Vsop87.LnVsop(4.0E-11, 4.51166201853, 77956.15180375299), new Vsop87.LnVsop(4.0E-11, 5.45050466984, 129971.55071751658), new Vsop87.LnVsop(4.0E-11, 3.77460109134, 104501.17576343138), new Vsop87.LnVsop(5.0E-11, 5.22637270443, 51329.7234483972), new Vsop87.LnVsop(4.0E-11, 1.64240288075, 130446.14426677099), new Vsop87.LnVsop(4.0E-11, 4.12681734359, 52024.75861330549), new Vsop87.LnVsop(4.0E-11, 1.28556784404, 112545.88789950538), new Vsop87.LnVsop(4.0E-11, 4.76459208241, 130432.88714897096), new Vsop87.LnVsop(5.0E-11, 1.15142161162, 27566.76971563859), new Vsop87.LnVsop(4.0E-11, 3.5013384701, 76152.05911134499), new Vsop87.LnVsop(4.0E-11, 3.46894421635, 128857.55635958798), new Vsop87.LnVsop(4.0E-11, 5.61652153909, 43981.5309499398), new Vsop87.LnVsop(4.0E-11, 4.02759705517, 104426.39416486409), new Vsop87.LnVsop(4.0E-11, 1.34875445004, 106684.80895916879), new Vsop87.LnVsop(4.0E-11, 5.13091111991, 735.8765135318)};
        private static Vsop87.LnVsop[] mercury_latitude_b1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.00274646065, 3.95008450011, 26087.9031415742), new Vsop87.LnVsop(9.9737713E-4, 3.14159265359, 0.0), new Vsop87.LnVsop(1.8772047E-4, 0.05141288887, 78263.70942472259), new Vsop87.LnVsop(2.3970726E-4, 2.53272082947, 52175.8062831484), new Vsop87.LnVsop(8.097508E-5, 3.20946389315, 104351.61256629678), new Vsop87.LnVsop(2.890729E-5, 0.00943621371, 130439.51570787099), new Vsop87.LnVsop(9.49669E-6, 3.06780459575, 156527.41884944518), new Vsop87.LnVsop(2.98013E-6, 6.11414444304, 182615.3219910194), new Vsop87.LnVsop(9.0863E-7, 2.87023913203, 208703.2251325936), new Vsop87.LnVsop(2.7163E-7, 5.90488705529, 234791.12827416777), new Vsop87.LnVsop(2.4677E-7, 0.37210176608, 27197.2816936676), new Vsop87.LnVsop(1.6001E-7, 0.37499685422, 24978.5245894808), new Vsop87.LnVsop(1.1035E-7, 3.4885532911, 53285.1848352418), new Vsop87.LnVsop(8.004E-8, 2.65315026358, 260879.03141574195), new Vsop87.LnVsop(8.817E-8, 3.46732763537, 51066.427731055), new Vsop87.LnVsop(4.863E-8, 3.13533089859, 31749.2351907264), new Vsop87.LnVsop(4.419E-8, 2.23904465242, 51116.4243529592), new Vsop87.LnVsop(3.814E-8, 0.25548693522, 77154.33087262919), new Vsop87.LnVsop(2.815E-8, 0.26202289859, 79373.087976816), new Vsop87.LnVsop(2.53E-8, 0.93822440376, 25028.521211385), new Vsop87.LnVsop(2.333E-8, 5.68288980482, 286966.9345573162), new Vsop87.LnVsop(1.895E-8, 0.10856961205, 57837.1383323006), new Vsop87.LnVsop(1.701E-8, 4.37082841476, 47623.8527860896), new Vsop87.LnVsop(1.899E-8, 4.11252610224, 21535.9496445154), new Vsop87.LnVsop(1.471E-8, 3.31454498058, 103242.2340142034), new Vsop87.LnVsop(1.398E-8, 0.70775253481, 46514.4742339962), new Vsop87.LnVsop(1.479E-8, 2.73615287841, 1109.3785520934), new Vsop87.LnVsop(1.354E-8, 4.55218165396, 27043.5028831828), new Vsop87.LnVsop(1.109E-8, 5.45818445766, 37410.5672398786), new Vsop87.LnVsop(1.052E-8, 1.49151534032, 5661.3320491522), new Vsop87.LnVsop(9.3E-9, 1.64333447742, 27147.28507176339), new Vsop87.LnVsop(9.89E-9, 3.0524351962, 26107.57290247399), new Vsop87.LnVsop(1.079E-8, 5.57037418878, 77204.32749453338), new Vsop87.LnVsop(9.06E-9, 1.01615991422, 50586.73338786459), new Vsop87.LnVsop(8.83E-9, 3.88701951249, 72602.37737557039), new Vsop87.LnVsop(8.15E-9, 4.05203293287, 26068.2333806744), new Vsop87.LnVsop(1.01E-8, 4.26926247841, 1059.3819301892), new Vsop87.LnVsop(8.65E-9, 2.54233867528, 25132.3033999656), new Vsop87.LnVsop(8.61E-9, 3.07069188532, 20426.571092422), new Vsop87.LnVsop(8.04E-9, 3.64421854876, 25558.2121764796), new Vsop87.LnVsop(8.01E-9, 5.97109208562, 26084.0218062162), new Vsop87.LnVsop(7.31E-9, 2.98501758578, 30639.856638633), new Vsop87.LnVsop(6.38E-9, 2.35143884682, 63498.47038145279), new Vsop87.LnVsop(8.34E-9, 1.43265392502, 53131.406024757), new Vsop87.LnVsop(6.81E-9, 1.1265221023, 26091.7844769322), new Vsop87.LnVsop(6.33E-9, 0.25824675505, 529.6909650946), new Vsop87.LnVsop(5.57E-9, 1.6460979015, 51749.20809227239), new Vsop87.LnVsop(5.71E-9, 5.59911115025, 51220.20654153979), new Vsop87.LnVsop(6.74E-9, 2.428158557, 313054.83769889036), new Vsop87.LnVsop(5.31E-9, 0.08195485862, 129330.13715577759), new Vsop87.LnVsop(5.16E-9, 3.3081756374, 105460.99111839019), new Vsop87.LnVsop(5.47E-9, 4.88873057421, 53235.18821333759), new Vsop87.LnVsop(6.46E-9, 5.15532565106, 51646.11531805379), new Vsop87.LnVsop(4.98E-9, 6.25926046322, 39609.6545831656), new Vsop87.LnVsop(4.86E-9, 1.90882118195, 41962.5207369374), new Vsop87.LnVsop(4.87E-9, 1.46686338689, 14765.2390432698), new Vsop87.LnVsop(4.95E-9, 1.33429661042, 73711.75592766379), new Vsop87.LnVsop(4.96E-9, 6.18531128569, 1589.0728952838), new Vsop87.LnVsop(4.62E-9, 0.10800789461, 28306.66024576099), new Vsop87.LnVsop(4.36E-9, 3.9485901001, 26617.5941066688), new Vsop87.LnVsop(4.28E-9, 2.66017504161, 32858.61374281979), new Vsop87.LnVsop(4.33E-9, 2.66167748924, 10213.285546211), new Vsop87.LnVsop(4.54E-9, 1.26447194685, 52705.49724824299), new Vsop87.LnVsop(4.24E-9, 2.16539582623, 24498.8302462904), new Vsop87.LnVsop(3.82E-9, 4.92616226033, 13521.7514415914), new Vsop87.LnVsop(3.78E-9, 2.51470161086, 110012.94461544899), new Vsop87.LnVsop(3.69E-9, 0.49272546225, 23869.1460373874), new Vsop87.LnVsop(3.59E-9, 6.10388198518, 52195.47604404819), new Vsop87.LnVsop(3.77E-9, 0.82879515558, 52156.1365222486), new Vsop87.LnVsop(3.41E-9, 3.96944896611, 76674.63652943878), new Vsop87.LnVsop(4.23E-9, 6.02804558448, 56727.7597802072), new Vsop87.LnVsop(3.85E-9, 1.53468252007, 43071.8992890308), new Vsop87.LnVsop(3.54E-9, 2.22262764622, 4551.9534970588), new Vsop87.LnVsop(3.46E-9, 4.52919441767, 22645.32819660879), new Vsop87.LnVsop(4.1E-9, 0.69983495069, 98690.28051714458), new Vsop87.LnVsop(2.86E-9, 3.35426943723, 54394.56338733519), new Vsop87.LnVsop(2.73E-9, 2.36744757405, 77308.10968311399), new Vsop87.LnVsop(2.94E-9, 2.74202105897, 52171.9249477904), new Vsop87.LnVsop(3.04E-9, 2.385405702, 19804.8272915828), new Vsop87.LnVsop(3.47E-9, 5.86460557162, 25661.3049506982), new Vsop87.LnVsop(3.26E-9, 5.9592182226, 58946.51688439399), new Vsop87.LnVsop(2.82E-9, 4.58303975832, 40853.142184844), new Vsop87.LnVsop(2.95E-9, 4.14948936071, 19317.1925403286), new Vsop87.LnVsop(2.34E-9, 2.42226658329, 51535.90899683439), new Vsop87.LnVsop(3.08E-9, 4.18990062677, 52179.6876185064), new Vsop87.LnVsop(2.27E-9, 3.10129561309, 29530.4780865396), new Vsop87.LnVsop(2.23E-9, 3.39292203864, 52168.69273614759), new Vsop87.LnVsop(3.01E-9, 4.98290551019, 83925.0414738748), new Vsop87.LnVsop(2.1E-9, 1.29236814505, 129380.13377768178), new Vsop87.LnVsop(2.31E-9, 2.78805501752, 27676.976036858), new Vsop87.LnVsop(2.54E-9, 1.75202182861, 79323.09135491178), new Vsop87.LnVsop(2.19E-9, 3.11799781949, 65697.55772473979), new Vsop87.LnVsop(2.28E-9, 4.7538214543, 69159.80243060499), new Vsop87.LnVsop(2.21E-9, 5.66487908503, 136100.84775702318), new Vsop87.LnVsop(2.56E-9, 4.33563337332, 78793.40038981718), new Vsop87.LnVsop(1.86E-9, 5.08965761232, 51109.31080595839), new Vsop87.LnVsop(2.05E-9, 5.61491216184, 15874.6175953632), new Vsop87.LnVsop(2.2E-9, 5.33790249773, 9103.9069941176), new Vsop87.LnVsop(2.13E-9, 2.92176515735, 7.1135470008), new Vsop87.LnVsop(2.54E-9, 3.83544410132, 103292.23063610759), new Vsop87.LnVsop(1.82E-9, 3.12436060186, 155418.04029735178), new Vsop87.LnVsop(1.72E-9, 3.57237148676, 49957.0491789616), new Vsop87.LnVsop(1.7E-9, 5.34074841499, 59414.4818747484), new Vsop87.LnVsop(1.98E-9, 2.80899484175, 82815.66292178139), new Vsop87.LnVsop(1.69E-9, 3.95433715382, 48733.23133818299), new Vsop87.LnVsop(1.6E-9, 4.06638746066, 38654.05484155699), new Vsop87.LnVsop(1.69E-9, 2.98278429311, 52182.9198301492), new Vsop87.LnVsop(1.64E-9, 0.4840685266, 25035.6347583858), new Vsop87.LnVsop(1.93E-9, 5.45282424425, 339142.7408404646), new Vsop87.LnVsop(1.67E-9, 3.7696864961, 124778.18365871879), new Vsop87.LnVsop(1.77E-9, 0.50498686165, 12566.1516999828), new Vsop87.LnVsop(1.74E-9, 2.93891001182, 3442.5749449654), new Vsop87.LnVsop(1.39E-9, 2.89354352723, 16983.9961474566), new Vsop87.LnVsop(1.35E-9, 0.95689929067, 25021.4076643842), new Vsop87.LnVsop(1.35E-9, 1.85739871878, 1066.49547719), new Vsop87.LnVsop(1.4E-9, 0.95231303882, 45405.0956819028), new Vsop87.LnVsop(1.29E-9, 4.98272235175, 62389.09182935939), new Vsop87.LnVsop(1.63E-9, 4.43252627959, 79219.3091663312), new Vsop87.LnVsop(1.27E-9, 2.64712841018, 6283.0758499914), new Vsop87.LnVsop(1.48E-9, 4.42851788044, 639.897286314), new Vsop87.LnVsop(1.2E-9, 5.47170236878, 89586.37352302698), new Vsop87.LnVsop(1.38E-9, 4.66882702924, 25448.00585526019), new Vsop87.LnVsop(1.31E-9, 2.39432798293, 1052.2683831884), new Vsop87.LnVsop(1.27E-9, 4.28199485177, 45892.73043315699), new Vsop87.LnVsop(1.48E-9, 5.8876868652, 26095.016688575), new Vsop87.LnVsop(1.13E-9, 5.41723025442, 103396.01282468818), new Vsop87.LnVsop(1.41E-9, 0.66045444891, 955.5997416086), new Vsop87.LnVsop(1.32E-9, 3.31487233981, 25874.6040461362), new Vsop87.LnVsop(1.11E-9, 2.30602187706, 26514.5013324502), new Vsop87.LnVsop(1.27E-9, 4.92872197982, 77837.11123384659), new Vsop87.LnVsop(1.46E-9, 4.4451496995, 51123.53789995999), new Vsop87.LnVsop(1.08E-9, 1.38943506443, 26301.2022370122), new Vsop87.LnVsop(1.07E-9, 2.87108086381, 78283.37918562238), new Vsop87.LnVsop(1.07E-9, 6.11750618089, 55618.3812281138), new Vsop87.LnVsop(1.06E-9, 4.34929118982, 94138.32702008578), new Vsop87.LnVsop(1.41E-9, 5.99037156525, 26080.78959457339), new Vsop87.LnVsop(1.4E-9, 1.44143660799, 66941.04532641819), new Vsop87.LnVsop(1.45E-9, 3.88502701676, 78244.0396638228), new Vsop87.LnVsop(1.14E-9, 4.48951543952, 155468.036919256), new Vsop87.LnVsop(1.27E-9, 4.99565339762, 6770.7106012456), new Vsop87.LnVsop(1.22E-9, 0.26346073379, 50057.04242277), new Vsop87.LnVsop(1.06E-9, 5.21881168514, 213.299095438), new Vsop87.LnVsop(1.16E-9, 0.96831158986, 78267.59076008058), new Vsop87.LnVsop(1.13E-9, 1.04970035229, 11322.6640983044), new Vsop87.LnVsop(9.5E-10, 2.69641328629, 33326.5787331742), new Vsop87.LnVsop(1.14E-9, 1.09238127979, 104881.30353139139), new Vsop87.LnVsop(1.13E-9, 5.10217474462, 52389.1053785864), new Vsop87.LnVsop(8.9E-10, 5.79526808183, 78259.82808936459), new Vsop87.LnVsop(8.9E-10, 2.61728576551, 77734.01845962799), new Vsop87.LnVsop(1.05E-9, 5.07516625809, 18849.2275499742), new Vsop87.LnVsop(1.04E-9, 4.85110269983, 105410.99449648599), new Vsop87.LnVsop(8.8E-10, 0.07845540889, 80482.46652890938), new Vsop87.LnVsop(8.9E-10, 0.1731218586, 36301.18868778519), new Vsop87.LnVsop(8.5E-10, 2.60578915417, 2218.7571041868), new Vsop87.LnVsop(9.1E-10, 0.98738393447, 64741.95798313119), new Vsop87.LnVsop(9.2E-10, 5.59469661827, 77623.81213840858), new Vsop87.LnVsop(8.2E-10, 1.92444262254, 77197.21394753258), new Vsop87.LnVsop(8.7E-10, 0.20380347433, 78256.59587772179), new Vsop87.LnVsop(9.6E-10, 0.08189739553, 32370.9789915656), new Vsop87.LnVsop(1.07E-9, 5.8371004117, 53764.8791784322), new Vsop87.LnVsop(8.1E-10, 3.69706776323, 125887.56221081219), new Vsop87.LnVsop(8.0E-10, 5.03346565385, 38519.945791972), new Vsop87.LnVsop(7.7E-10, 6.07816721358, 78270.82297172339), new Vsop87.LnVsop(8.2E-10, 0.51152795715, 102762.53967101299), new Vsop87.LnVsop(8.5E-10, 1.92105479279, 88476.99497093359), new Vsop87.LnVsop(1.01E-9, 0.96161245897, 74821.13447975718), new Vsop87.LnVsop(8.6E-10, 0.56718393948, 2118.7638603784), new Vsop87.LnVsop(8.0E-10, 5.85129854966, 108903.56606335558), new Vsop87.LnVsop(8.5E-10, 0.33559096416, 68050.42387851159), new Vsop87.LnVsop(1.01E-9, 2.44941820933, 162188.75089859738), new Vsop87.LnVsop(7.2E-10, 5.40658854751, 52602.4044740244), new Vsop87.LnVsop(7.3E-10, 1.35284250657, 77211.44104153418), new Vsop87.LnVsop(7.8E-10, 1.829325449, 23969.1392811958), new Vsop87.LnVsop(7.8E-10, 1.14557641661, 103821.92160120218), new Vsop87.LnVsop(6.3E-10, 0.55276835341, 150866.08680029298), new Vsop87.LnVsop(6.0E-10, 0.75277278015, 51962.5071877104), new Vsop87.LnVsop(6.7E-10, 0.35378094005, 76044.9523205358), new Vsop87.LnVsop(6.6E-10, 1.22896212635, 120226.23016165999), new Vsop87.LnVsop(7.5E-10, 1.90096013413, 44937.1306915484), new Vsop87.LnVsop(7.8E-10, 2.65007000101, 85034.42002596818), new Vsop87.LnVsop(6.7E-10, 5.96206801213, 99799.65906923798), new Vsop87.LnVsop(5.7E-10, 4.04412361561, 71492.99882347698), new Vsop87.LnVsop(6.3E-10, 2.22382469625, 64607.84893354619), new Vsop87.LnVsop(5.7E-10, 1.26261980819, 26727.8004278882), new Vsop87.LnVsop(6.6E-10, 5.0861305638, 426.598190876), new Vsop87.LnVsop(6.1E-10, 6.17937752731, 181505.94343892598), new Vsop87.LnVsop(5.7E-10, 1.67383119023, 13655.8604911764), new Vsop87.LnVsop(5.5E-10, 2.01862939432, 78477.00852016058), new Vsop87.LnVsop(5.9E-10, 2.31048572111, 25934.1243310894), new Vsop87.LnVsop(5.2E-10, 5.28302108918, 117873.36400788819), new Vsop87.LnVsop(5.8E-10, 4.52853866098, 93028.94846799239), new Vsop87.LnVsop(5.1E-10, 1.37470570114, 51742.09454527159), new Vsop87.LnVsop(4.9E-10, 4.95150906291, 27154.3986187642), new Vsop87.LnVsop(5.4E-10, 3.22580705063, 76144.94556434419), new Vsop87.LnVsop(5.5E-10, 4.34494801509, 129909.82474277639), new Vsop87.LnVsop(5.2E-10, 0.64534027826, 104331.94280539699), new Vsop87.LnVsop(4.9E-10, 0.54893867721, 151975.46535238638), new Vsop87.LnVsop(5.0E-10, 2.16547944799, 365230.6439820388), new Vsop87.LnVsop(4.2E-10, 3.33958631905, 25654.19140369739), new Vsop87.LnVsop(4.3E-10, 2.86670192586, 81706.28436968799), new Vsop87.LnVsop(4.5E-10, 4.36618153094, 23754.70674870219), new Vsop87.LnVsop(4.6E-10, 4.11608179511, 130969.20667296558), new Vsop87.LnVsop(4.2E-10, 3.34341658738, 58458.88213313979), new Vsop87.LnVsop(4.3E-10, 2.17611617409, 129483.91596626239), new Vsop87.LnVsop(4.0E-10, 5.67208441017, 98068.53671630539), new Vsop87.LnVsop(5.4E-10, 2.01769359183, 71980.63357473118), new Vsop87.LnVsop(4.1E-10, 4.03526737986, 104355.49390165479), new Vsop87.LnVsop(4.4E-10, 1.34241743313, 95247.70557217918), new Vsop87.LnVsop(4.8E-10, 2.80283584379, 25668.418497699), new Vsop87.LnVsop(5.2E-10, 1.57841300473, 91785.46086631398), new Vsop87.LnVsop(5.1E-10, 1.28828842075, 181555.94006083018), new Vsop87.LnVsop(4.0E-10, 1.64623403786, 131498.89763806018), new Vsop87.LnVsop(4.3E-10, 1.22261583745, 25619.9381512198), new Vsop87.LnVsop(3.8E-10, 5.49413456622, 433.7117378768), new Vsop87.LnVsop(4.5E-10, 3.7950719832, 25973.46385288896), new Vsop87.LnVsop(3.6E-10, 0.95495171363, 12432.0426503978), new Vsop87.LnVsop(4.4E-10, 2.60019583483, 79852.78232000639), new Vsop87.LnVsop(3.5E-10, 3.78148248909, 78050.41032928458), new Vsop87.LnVsop(3.6E-10, 1.55620646402, 35191.8101356918), new Vsop87.LnVsop(3.6E-10, 3.27238519467, 51322.60990139639), new Vsop87.LnVsop(3.8E-10, 4.98002708714, 71025.0338331226), new Vsop87.LnVsop(4.1E-10, 5.50852676734, 188276.6540401716), new Vsop87.LnVsop(3.6E-10, 6.11354609097, 419.4846438752), new Vsop87.LnVsop(3.9E-10, 0.62636542709, 51756.3216392732), new Vsop87.LnVsop(3.3E-10, 0.05318157962, 157636.79740153858), new Vsop87.LnVsop(3.1E-10, 4.47853571883, 50579.61984086379), new Vsop87.LnVsop(4.2E-10, 4.11842354719, 90829.86112470538), new Vsop87.LnVsop(4.1E-10, 5.03998788697, 114564.89811250778), new Vsop87.LnVsop(4.1E-10, 3.30990629103, 26202.34243025941), new Vsop87.LnVsop(2.9E-10, 2.87668564214, 104358.72611329758), new Vsop87.LnVsop(2.9E-10, 4.48238942132, 103299.34418310839), new Vsop87.LnVsop(2.9E-10, 5.92039948279, 104371.28232719658), new Vsop87.LnVsop(3.7E-10, 5.51946984459, 27140.17152476259), new Vsop87.LnVsop(2.7E-10, 6.23586367522, 131548.89425996438), new Vsop87.LnVsop(2.8E-10, 4.05590031045, 26241.681952059), new Vsop87.LnVsop(2.8E-10, 2.50435883057, 134991.4692049298), new Vsop87.LnVsop(3.3E-10, 2.24161818527, 78690.30761559859), new Vsop87.LnVsop(3.3E-10, 3.52014855585, 28206.6670019526), new Vsop87.LnVsop(3.4E-10, 3.16651260001, 28421.0995344462), new Vsop87.LnVsop(2.6E-10, 5.00736740368, 52026.2430860138), new Vsop87.LnVsop(2.9E-10, 2.17466338621, 143961.2671494624), new Vsop87.LnVsop(2.7E-10, 4.99746573906, 103285.11708910679), new Vsop87.LnVsop(2.5E-10, 2.48133226582, 1596.1864422846), new Vsop87.LnVsop(2.7E-10, 2.69046712792, 26137.8997634784), new Vsop87.LnVsop(2.4E-10, 4.42906084435, 52815.7035694624), new Vsop87.LnVsop(2.4E-10, 0.28078732255, 24491.71669928959), new Vsop87.LnVsop(2.7E-10, 3.18888227928, 106570.36967048359), new Vsop87.LnVsop(2.6E-10, 1.03825669554, 155997.72788435058), new Vsop87.LnVsop(2.5E-10, 0.92922476652, 46848.3301747656), new Vsop87.LnVsop(3.0E-10, 4.33105881883, 146314.13330323418), new Vsop87.LnVsop(2.3E-10, 5.18080408909, 104564.91166173479), new Vsop87.LnVsop(2.8E-10, 3.65474790938, 853.196381752), new Vsop87.LnVsop(2.2E-10, 0.85921724567, 97580.90196505119), new Vsop87.LnVsop(2.4E-10, 1.23363961966, 44181.27784112419), new Vsop87.LnVsop(2.2E-10, 0.70470227963, 130012.91751699499), new Vsop87.LnVsop(2.2E-10, 4.49230772734, 77829.99768684579), new Vsop87.LnVsop(2.8E-10, 2.49868158665, 103711.71527998279), new Vsop87.LnVsop(2.7E-10, 3.29515496156, 104344.49901929598), new Vsop87.LnVsop(2.2E-10, 0.4457297552, 84546.78527471398), new Vsop87.LnVsop(2.2E-10, 5.88047033548, 111122.32316754239), new Vsop87.LnVsop(2.2E-10, 2.60977946903, 124156.43985787958), new Vsop87.LnVsop(2.2E-10, 4.44538253487, 26037.90651966999), new Vsop87.LnVsop(2.0E-10, 4.82064305548, 50593.84693486539), new Vsop87.LnVsop(1.9E-10, 2.55536179284, 104347.73123093879), new Vsop87.LnVsop(2.0E-10, 4.6403113915, 39743.7636327506), new Vsop87.LnVsop(2.0E-10, 5.75240741273, 26555.8681319286), new Vsop87.LnVsop(1.9E-10, 3.61612329821, 176953.98994186718), new Vsop87.LnVsop(2.1E-10, 1.87806754676, 53242.3017603384), new Vsop87.LnVsop(2.1E-10, 5.3347239249, 25234.70675982219), new Vsop87.LnVsop(2.4E-10, 3.22504783392, 103925.01437542078), new Vsop87.LnVsop(2.0E-10, 0.66874668037, 24505.94379329119), new Vsop87.LnVsop(1.8E-10, 4.02462395449, 25455.119402261), new Vsop87.LnVsop(2.4E-10, 3.43375195287, 102132.85546210999), new Vsop87.LnVsop(1.9E-10, 2.22650377926, 51639.00177105299), new Vsop87.LnVsop(1.7E-10, 5.55040575898, 7994.5284420242), new Vsop87.LnVsop(2.2E-10, 2.31932242347, 33967.99229491319), new Vsop87.LnVsop(1.8E-10, 3.12472807269, 2333.196392872), new Vsop87.LnVsop(1.7E-10, 1.3304657234, 119116.85160956658), new Vsop87.LnVsop(2.2E-10, 2.3138711772, 7238.6755916), new Vsop87.LnVsop(1.9E-10, 3.58998679047, 100909.03762133139), new Vsop87.LnVsop(1.9E-10, 3.87014504106, 77844.22478084739), new Vsop87.LnVsop(1.9E-10, 3.09565971234, 183724.7005431128), new Vsop87.LnVsop(1.6E-10, 5.37852102811, 52099.5402118728), new Vsop87.LnVsop(1.6E-10, 0.33931328678, 104138.31347085879), new Vsop87.LnVsop(1.6E-10, 3.61136447801, 25938.3399444396), new Vsop87.LnVsop(1.6E-10, 4.67702694427, 70269.18098269838), new Vsop87.LnVsop(1.6E-10, 3.62892599352, 45494.58142974879), new Vsop87.LnVsop(1.8E-10, 0.09335270206, 52290.24557183361), new Vsop87.LnVsop(1.6E-10, 4.26164005531, 18207.81398823521), new Vsop87.LnVsop(1.8E-10, 3.0329799939, 18093.37469954999), new Vsop87.LnVsop(1.8E-10, 1.42431884027, 52329.58509363319), new Vsop87.LnVsop(1.8E-10, 1.9575184201, 1581.959348283), new Vsop87.LnVsop(1.6E-10, 5.7748668233, 105940.68546158058), new Vsop87.LnVsop(1.8E-10, 4.34696486181, 207643.8432024044), new Vsop87.LnVsop(1.6E-10, 5.63459120036, 60055.89543648739), new Vsop87.LnVsop(1.9E-10, 3.63064346775, 178063.3684939606), new Vsop87.LnVsop(1.4E-10, 2.24040737633, 26521.614879451), new Vsop87.LnVsop(1.5E-10, 0.02625056785, 5327.4761083828), new Vsop87.LnVsop(1.6E-10, 2.36249545609, 53228.07466633679), new Vsop87.LnVsop(1.4E-10, 4.71907120236, 536.8045120954), new Vsop87.LnVsop(1.4E-10, 4.97342838812, 632.7837393132), new Vsop87.LnVsop(1.3E-10, 0.88467126264, 157057.10981453978), new Vsop87.LnVsop(1.7E-10, 3.02173052534, 128850.44281258718), new Vsop87.LnVsop(1.4E-10, 3.69908958351, 130419.8459469712), new Vsop87.LnVsop(1.7E-10, 2.9736325737, 207593.8465805002), new Vsop87.LnVsop(1.4E-10, 3.36313158411, 26507.38778544939), new Vsop87.LnVsop(1.4E-10, 5.19298126606, 391318.54712361295), new Vsop87.LnVsop(1.6E-10, 6.22012529996, 54509.0026760204), new Vsop87.LnVsop(1.5E-10, 0.11681094638, 77410.51304297059), new Vsop87.LnVsop(1.2E-10, 1.76556010523, 97112.93697469679), new Vsop87.LnVsop(1.2E-10, 1.25999627705, 131395.11544947958), new Vsop87.LnVsop(1.6E-10, 0.55859453886, 52061.36699446317), new Vsop87.LnVsop(1.2E-10, 4.71974002613, 157586.80077963436), new Vsop87.LnVsop(1.4E-10, 1.8307172475, 140652.80125408198), new Vsop87.LnVsop(1.2E-10, 2.28368820761, 214364.55718174577), new Vsop87.LnVsop(1.2E-10, 6.24305669176, 102232.84870591838), new Vsop87.LnVsop(1.3E-10, 0.94418392757, 116917.76426627958), new Vsop87.LnVsop(1.3E-10, 5.67747595071, 52022.0274726636), new Vsop87.LnVsop(1.4E-10, 2.65222906369, 52643.7712735028), new Vsop87.LnVsop(1.1E-10, 4.46099054997, 90695.75207512038), new Vsop87.LnVsop(1.1E-10, 0.77812998358, 130443.39704322898), new Vsop87.LnVsop(1.1E-10, 4.78834330208, 647.0108333148), new Vsop87.LnVsop(1.2E-10, 5.2162943563, 155571.81910783658), new Vsop87.LnVsop(1.0E-10, 3.98538100953, 26011.6370702986), new Vsop87.LnVsop(1.1E-10, 5.35398161802, 26610.48055966799), new Vsop87.LnVsop(1.4E-10, 0.26737723968, 54294.57014352679), new Vsop87.LnVsop(1.2E-10, 5.9738132744, 49527.35145767539), new Vsop87.LnVsop(1.1E-10, 5.93849929007, 107794.1875112622), new Vsop87.LnVsop(1.1E-10, 0.52555554946, 26941.0995233262), new Vsop87.LnVsop(1.0E-10, 0.77987261513, 26081.27458267419), new Vsop87.LnVsop(1.0E-10, 2.15201941222, 85502.38501632259), new Vsop87.LnVsop(1.0E-10, 2.4303203357, 52698.38370124219), new Vsop87.LnVsop(1.2E-10, 5.21081550816, 25551.09862947879), new Vsop87.LnVsop(1.3E-10, 2.74248443392, 42153.969003049), new Vsop87.LnVsop(9.0E-11, 5.60699637563, 27684.0895838588), new Vsop87.LnVsop(9.0E-11, 1.26689967531, 76667.52298243798), new Vsop87.LnVsop(1.0E-10, 3.89379538762, 156100.82065856917), new Vsop87.LnVsop(1.2E-10, 1.39954193335, 51543.0225438352), new Vsop87.LnVsop(1.2E-10, 1.52257139502, 20760.4270331914), new Vsop87.LnVsop(9.0E-11, 4.20492959289, 182085.63102592478), new Vsop87.LnVsop(1.1E-10, 0.66834392142, 22759.76748529401), new Vsop87.LnVsop(1.0E-10, 1.22929752466, 2648.454825473), new Vsop87.LnVsop(9.0E-11, 3.54074354837, 22747.2907148744), new Vsop87.LnVsop(1.0E-10, 0.12918931028, 29416.03879785439), new Vsop87.LnVsop(1.1E-10, 1.24509960603, 52125.80966124419), new Vsop87.LnVsop(1.1E-10, 5.24371045714, 170049.1702910366), new Vsop87.LnVsop(9.0E-11, 1.96952049653, 51528.79544983359), new Vsop87.LnVsop(8.0E-11, 1.2329790024, 129387.24732468258), new Vsop87.LnVsop(1.0E-10, 0.46604003447, 26624.70765366959), new Vsop87.LnVsop(9.0E-11, 1.88003142152, 25565.3257234804), new Vsop87.LnVsop(8.0E-11, 5.66609855382, 161079.37234650398), new Vsop87.LnVsop(1.0E-10, 5.37595917575, 104778.21075717278), new Vsop87.LnVsop(1.0E-10, 4.32195478071, 10021.8372800994), new Vsop87.LnVsop(8.0E-11, 4.28630606896, 157483.01859105378), new Vsop87.LnVsop(1.0E-10, 1.11167068209, 172402.0364448084), new Vsop87.LnVsop(8.0E-11, 3.86388656968, 24864.08530079559), new Vsop87.LnVsop(1.0E-10, 4.98434698939, 61279.713277266), new Vsop87.LnVsop(8.0E-11, 1.68789367623, 141762.17980617538), new Vsop87.LnVsop(8.0E-11, 3.27159786562, 27311.72098235281), new Vsop87.LnVsop(1.0E-10, 4.04735211723, 72936.23331633979), new Vsop87.LnVsop(9.0E-11, 0.6666194985, 522.5774180938), new Vsop87.LnVsop(8.0E-11, 2.11915755526, 111590.2881578968), new Vsop87.LnVsop(1.0E-10, 3.96196817321, 26094.53170047421), new Vsop87.LnVsop(9.0E-11, 5.9789921761, 209812.60368468694), new Vsop87.LnVsop(8.0E-11, 5.90414175287, 130446.62925487179), new Vsop87.LnVsop(9.0E-11, 4.70218884623, 26190.99591579279), new Vsop87.LnVsop(7.0E-11, 5.0002883811, 7880.08915333899), new Vsop87.LnVsop(7.0E-11, 0.2766260262, 105307.21230790539), new Vsop87.LnVsop(8.0E-11, 3.59796141286, 110634.68841628819), new Vsop87.LnVsop(6.0E-11, 4.71394306694, 78417.48823520739), new Vsop87.LnVsop(7.0E-11, 5.65972341474, 129799.61842155698), new Vsop87.LnVsop(6.0E-11, 1.30176713541, 78903.60671103658), new Vsop87.LnVsop(7.0E-11, 0.48324947354, 204151.27163553477), new Vsop87.LnVsop(6.0E-11, 2.68955966786, 130459.18546877075), new Vsop87.LnVsop(6.0E-11, 3.9119444999, 123668.80510662538), new Vsop87.LnVsop(6.0E-11, 4.25610046715, 121335.60871375339), new Vsop87.LnVsop(6.0E-11, 4.39774898148, 145204.75475114078), new Vsop87.LnVsop(6.0E-11, 2.03358239461, 130652.81480330898), new Vsop87.LnVsop(6.0E-11, 5.10307826199, 13362.4497067992), new Vsop87.LnVsop(7.0E-11, 5.73368412719, 150244.3429994538), new Vsop87.LnVsop(7.0E-11, 1.79893081867, 129373.02023068098), new Vsop87.LnVsop(6.0E-11, 1.6022075741, 31415.379249957), new Vsop87.LnVsop(5.0E-11, 5.3358735407, 77726.90491262719), new Vsop87.LnVsop(6.0E-11, 0.69127308024, 103932.12792242158), new Vsop87.LnVsop(6.0E-11, 1.30528239429, 103917.90082841998), new Vsop87.LnVsop(7.0E-11, 3.42052770753, 25881.717593137), new Vsop87.LnVsop(6.0E-11, 0.20662663852, 128220.75860368418), new Vsop87.LnVsop(6.0E-11, 1.76394381916, 76681.75007643958), new Vsop87.LnVsop(5.0E-11, 1.55332352133, 65831.6667743248), new Vsop87.LnVsop(5.0E-11, 0.39891046615, 203041.8930834414), new Vsop87.LnVsop(5.0E-11, 5.00920311857, 154938.34595416137), new Vsop87.LnVsop(7.0E-11, 0.0754199349, 130432.40216087017), new Vsop87.LnVsop(5.0E-11, 3.95655297699, 25440.89230825939), new Vsop87.LnVsop(5.0E-11, 1.60878156139, 25984.8103673556), new Vsop87.LnVsop(5.0E-11, 5.63420105001, 130435.63437251298), new Vsop87.LnVsop(5.0E-11, 5.71235725527, 52225.8029050526), new Vsop87.LnVsop(5.0E-11, 4.82602182938, 123200.84011627098), new Vsop87.LnVsop(5.0E-11, 4.28914322665, 51707.84129279399), new Vsop87.LnVsop(5.0E-11, 2.45008961451, 132028.58860315479), new Vsop87.LnVsop(5.0E-11, 3.44380232013, 130226.21661243298), new Vsop87.LnVsop(5.0E-11, 0.69360997254, 126996.94076290558), new Vsop87.LnVsop(5.0E-11, 1.20349712708, 233731.7463439786), new Vsop87.LnVsop(5.0E-11, 4.94561230543, 137678.191299471), new Vsop87.LnVsop(5.0E-11, 4.02914734341, 143005.6674078538), new Vsop87.LnVsop(4.0E-11, 3.1570547589, 78378.1487134078), new Vsop87.LnVsop(5.0E-11, 6.19462947577, 1478.8665740644), new Vsop87.LnVsop(5.0E-11, 6.1934617354, 132658.27281205778), new Vsop87.LnVsop(4.0E-11, 4.93966028252, 166740.70439565618), new Vsop87.LnVsop(5.0E-11, 5.83365858307, 68241.8721446232), new Vsop87.LnVsop(5.0E-11, 4.88444080196, 79330.20490191258), new Vsop87.LnVsop(4.0E-11, 1.49931528728, 26294.08869001139), new Vsop87.LnVsop(4.0E-11, 4.91166258069, 167850.0829477496), new Vsop87.LnVsop(4.0E-11, 0.5121414737, 156507.7490885454), new Vsop87.LnVsop(4.0E-11, 2.48188443978, 11610.5519583742), new Vsop87.LnVsop(4.0E-11, 5.18875909536, 206.1855484372), new Vsop87.LnVsop(4.0E-11, 4.96587091153, 77630.92568540938), new Vsop87.LnVsop(4.0E-11, 2.56954562406, 137210.22630911658), new Vsop87.LnVsop(5.0E-11, 6.06172636184, 3340.6124266998), new Vsop87.LnVsop(4.0E-11, 2.59361967134, 6681.2248533996), new Vsop87.LnVsop(4.0E-11, 3.9818289606, 52712.61079524379), new Vsop87.LnVsop(4.0E-11, 1.85196935264, 87367.61641884019), new Vsop87.LnVsop(4.0E-11, 2.97167846271, 80596.9058175946), new Vsop87.LnVsop(4.0E-11, 0.38918279754, 52595.29092702359), new Vsop87.LnVsop(5.0E-11, 5.71555094572, 32769.1279949738), new Vsop87.LnVsop(4.0E-11, 2.86579870082, 128320.75184749259), new Vsop87.LnVsop(4.0E-11, 0.86678424442, 75930.51303185058), new Vsop87.LnVsop(4.0E-11, 5.77822773684, 78731.674415077), new Vsop87.LnVsop(3.0E-11, 4.14814530126, 25867.49049913539), new Vsop87.LnVsop(4.0E-11, 2.6578656826, 75615.25459924959), new Vsop87.LnVsop(4.0E-11, 1.05721792395, 183570.921732628), new Vsop87.LnVsop(4.0E-11, 3.26707290101, 80382.47328510099), new Vsop87.LnVsop(4.0E-11, 2.14799227897, 130866.11389874699), new Vsop87.LnVsop(4.0E-11, 3.39584566237, 55503.94193942859), new Vsop87.LnVsop(4.0E-11, 3.05837967978, 115674.27666460119), new Vsop87.LnVsop(4.0E-11, 6.04280069605, 233681.74972207437), new Vsop87.LnVsop(4.0E-11, 3.63969036598, 78149.27013603736), new Vsop87.LnVsop(4.0E-11, 1.85496913222, 116783.65521669458), new Vsop87.LnVsop(4.0E-11, 3.24711503875, 103498.41618454478), new Vsop87.LnVsop(3.0E-11, 5.41660260354, 52609.51802102519), new Vsop87.LnVsop(3.0E-11, 1.52254818578, 183674.70392120857), new Vsop87.LnVsop(4.0E-11, 2.41183349287, 3328.13565628019), new Vsop87.LnVsop(4.0E-11, 3.99911605099, 956.2891559706), new Vsop87.LnVsop(3.0E-11, 4.4249467472, 102755.42612401219), new Vsop87.LnVsop(3.0E-11, 3.8563295199, 156531.3001848032), new Vsop87.LnVsop(3.0E-11, 5.43028376893, 79315.97780791098), new Vsop87.LnVsop(4.0E-11, 1.56175361682, 149.5631971346), new Vsop87.LnVsop(3.0E-11, 3.9877468567, 183145.012956114), new Vsop87.LnVsop(3.0E-11, 5.35092623925, 77616.69859140778), new Vsop87.LnVsop(3.0E-11, 0.90485441793, 76.2660712756), new Vsop87.LnVsop(4.0E-11, 2.70337567475, 133882.09065283637), new Vsop87.LnVsop(4.0E-11, 2.08518328683, 78114.14622758799), new Vsop87.LnVsop(3.0E-11, 2.3395353258, 86143.79857806159), new Vsop87.LnVsop(4.0E-11, 0.81158752062, 182188.72380014337), new Vsop87.LnVsop(3.0E-11, 2.11502738121, 196137.07343261078), new Vsop87.LnVsop(3.0E-11, 0.95681396301, 12546.481939083), new Vsop87.LnVsop(3.0E-11, 1.37222728295, 181026.24909573558), new Vsop87.LnVsop(3.0E-11, 2.23536000215, 417406.4502651872), new Vsop87.LnVsop(3.0E-11, 5.3716500751, 240452.46032331997), new Vsop87.LnVsop(3.0E-11, 1.20257903149, 44295.7171298094), new Vsop87.LnVsop(3.0E-11, 0.52673171914, 136722.59155786238), new Vsop87.LnVsop(3.0E-11, 0.52016201639, 71582.48457132299), new Vsop87.LnVsop(3.0E-11, 3.50325656987, 49842.60989027639), new Vsop87.LnVsop(3.0E-11, 3.62611352126, 53029.0026649004), new Vsop87.LnVsop(3.0E-11, 1.62670747573, 104505.39137678158), new Vsop87.LnVsop(3.0E-11, 3.48868699337, 51219.51712717779), new Vsop87.LnVsop(2.0E-11, 3.6751108391, 19406.6782881746), new Vsop87.LnVsop(3.0E-11, 0.39109925063, 66653.15746634839), new Vsop87.LnVsop(3.0E-11, 2.84800545852, 235900.50682626115), new Vsop87.LnVsop(2.0E-11, 5.66788822044, 52381.99183158559), new Vsop87.LnVsop(3.0E-11, 5.55181174326, 78786.28684281638), new Vsop87.LnVsop(2.0E-11, 4.8807464996, 64901.25971792339), new Vsop87.LnVsop(3.0E-11, 1.5006193136, 52278.89905736699), new Vsop87.LnVsop(2.0E-11, 1.30186439584, 96357.08412427259), new Vsop87.LnVsop(2.0E-11, 4.21971266464, 198489.9395863826), new Vsop87.LnVsop(3.0E-11, 2.00366252191, 181659.72224941078), new Vsop87.LnVsop(2.0E-11, 3.71342666703, 48847.6706268682), new Vsop87.LnVsop(2.0E-11, 5.93200805535, 16066.0658614748), new Vsop87.LnVsop(2.0E-11, 1.0571848166, 208173.534167499), new Vsop87.LnVsop(3.0E-11, 2.15332656359, 103.0927742186), new Vsop87.LnVsop(2.0E-11, 4.39182749038, 155475.15046625677), new Vsop87.LnVsop(3.0E-11, 4.28206460476, 78213.71280281838), new Vsop87.LnVsop(3.0E-11, 5.86398017019, 48835.19385644859), new Vsop87.LnVsop(2.0E-11, 2.36207569977, 53771.99272543299), new Vsop87.LnVsop(2.0E-11, 1.5691076925, 163766.0944410452), new Vsop87.LnVsop(2.0E-11, 2.59173243384, 50483.640613646), new Vsop87.LnVsop(3.0E-11, 4.91698084392, 102769.65321801379), new Vsop87.LnVsop(2.0E-11, 2.55209144895, 176332.24614102798), new Vsop87.LnVsop(2.0E-11, 5.16963361594, 27669.86248985719), new Vsop87.LnVsop(2.0E-11, 1.10612817954, 1162.4747044078), new Vsop87.LnVsop(2.0E-11, 2.31962293255, 34082.4315835984), new Vsop87.LnVsop(2.0E-11, 2.51789048589, 51951.46148744649), new Vsop87.LnVsop(2.0E-11, 2.36943618837, 78187.44335344699)};
        private static Vsop87.LnVsop[] mercury_latitude_b2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(2.747165E-5, 5.24567337999, 26087.9031415742), new Vsop87.LnVsop(2.047257E-5, 0.0, 0.0), new Vsop87.LnVsop(5.1603E-6, 0.49321133154, 52175.8062831484), new Vsop87.LnVsop(4.07309E-6, 4.32215500849, 78263.70942472259), new Vsop87.LnVsop(2.66936E-6, 1.42744634495, 104351.61256629678), new Vsop87.LnVsop(1.33544E-6, 4.61055165903, 130439.51570787099), new Vsop87.LnVsop(5.6956E-7, 1.44017544018, 156527.41884944518), new Vsop87.LnVsop(2.2049E-7, 4.52127237069, 182615.3219910194), new Vsop87.LnVsop(8.008E-8, 1.30182043008, 208703.2251325936), new Vsop87.LnVsop(2.781E-8, 4.35468456951, 234791.12827416777), new Vsop87.LnVsop(1.304E-8, 2.02991901716, 27197.2816936676), new Vsop87.LnVsop(9.34E-9, 1.11727595126, 260879.03141574195), new Vsop87.LnVsop(5.11E-9, 4.80027921181, 24978.5245894808), new Vsop87.LnVsop(4.33E-9, 5.13987059401, 53285.1848352418), new Vsop87.LnVsop(4.13E-9, 1.75599872832, 51066.427731055), new Vsop87.LnVsop(3.06E-9, 4.15800645361, 286966.9345573162), new Vsop87.LnVsop(2.36E-9, 4.88575156209, 77154.33087262919), new Vsop87.LnVsop(1.23E-9, 3.39712849299, 51116.4243529592), new Vsop87.LnVsop(1.13E-9, 1.69721095056, 103242.2340142034), new Vsop87.LnVsop(1.09E-9, 4.54767694492, 31749.2351907264), new Vsop87.LnVsop(1.08E-9, 5.9332742468, 21535.9496445154), new Vsop87.LnVsop(7.8E-10, 5.68234392096, 27043.5028831828), new Vsop87.LnVsop(9.8E-10, 0.91744844557, 313054.83769889036), new Vsop87.LnVsop(6.5E-10, 1.90438129465, 79373.087976816), new Vsop87.LnVsop(4.9E-10, 4.78044793954, 129330.13715577759), new Vsop87.LnVsop(5.3E-10, 2.39315457975, 50586.73338786459), new Vsop87.LnVsop(4.1E-10, 1.89540481457, 28306.66024576099), new Vsop87.LnVsop(4.2E-10, 1.13215562166, 20426.571092422), new Vsop87.LnVsop(4.0E-10, 5.86412789562, 47623.8527860896), new Vsop87.LnVsop(3.6E-10, 2.38000382517, 53131.406024757), new Vsop87.LnVsop(4.0E-10, 0.82891454094, 37410.5672398786), new Vsop87.LnVsop(3.4E-10, 1.74213345173, 25132.3033999656), new Vsop87.LnVsop(3.6E-10, 4.80372288439, 46514.4742339962), new Vsop87.LnVsop(3.0E-10, 5.75393949543, 22645.32819660879), new Vsop87.LnVsop(3.5E-10, 5.5181181521, 529.6909650946), new Vsop87.LnVsop(2.9E-10, 5.15973032252, 23869.1460373874), new Vsop87.LnVsop(2.9E-10, 2.04610351418, 72602.37737557039), new Vsop87.LnVsop(2.7E-10, 5.07400464228, 1109.3785520934), new Vsop87.LnVsop(3.1E-10, 3.94180796281, 339142.7408404646), new Vsop87.LnVsop(2.4E-10, 4.46907480172, 51220.20654153979), new Vsop87.LnVsop(2.7E-10, 4.50770662559, 32858.61374281979), new Vsop87.LnVsop(2.3E-10, 5.00540243174, 54394.56338733519), new Vsop87.LnVsop(2.5E-10, 6.03143676776, 25028.521211385), new Vsop87.LnVsop(2.2E-10, 4.97381466604, 26107.57290247399), new Vsop87.LnVsop(2.1E-10, 2.35286083421, 26617.5941066688), new Vsop87.LnVsop(2.3E-10, 3.65155458684, 25558.2121764796), new Vsop87.LnVsop(1.9E-10, 1.56301436637, 155418.04029735178), new Vsop87.LnVsop(2.3E-10, 0.21718413372, 51646.11531805379), new Vsop87.LnVsop(1.8E-10, 1.62952557958, 26084.0218062162), new Vsop87.LnVsop(1.7E-10, 1.10257903328, 57837.1383323006), new Vsop87.LnVsop(1.8E-10, 5.97011387153, 52705.49724824299), new Vsop87.LnVsop(2.2E-10, 5.72062354443, 77204.32749453338), new Vsop87.LnVsop(1.6E-10, 3.15376195838, 53235.18821333759), new Vsop87.LnVsop(1.6E-10, 1.95864204506, 49957.0491789616), new Vsop87.LnVsop(1.6E-10, 3.95804080297, 63498.47038145279), new Vsop87.LnVsop(1.9E-10, 5.27215888569, 98690.28051714458), new Vsop87.LnVsop(1.7E-10, 5.49404503835, 14765.2390432698), new Vsop87.LnVsop(1.9E-10, 3.33825173375, 43071.8992890308), new Vsop87.LnVsop(1.5E-10, 6.15675923639, 4551.9534970588), new Vsop87.LnVsop(2.0E-10, 6.08858427909, 26068.2333806744), new Vsop87.LnVsop(1.4E-10, 5.89923942766, 25874.6040461362), new Vsop87.LnVsop(1.8E-10, 4.82964144481, 1589.0728952838), new Vsop87.LnVsop(1.4E-10, 1.07537737789, 77308.10968311399), new Vsop87.LnVsop(1.7E-10, 3.1478356971, 26091.7844769322), new Vsop87.LnVsop(1.4E-10, 3.32356467619, 25661.3049506982), new Vsop87.LnVsop(1.6E-10, 5.27195291262, 76674.63652943878), new Vsop87.LnVsop(1.4E-10, 1.10462125133, 39609.6545831656), new Vsop87.LnVsop(1.4E-10, 4.2560245003, 51535.90899683439), new Vsop87.LnVsop(1.7E-10, 1.33800696335, 58946.51688439399), new Vsop87.LnVsop(1.6E-10, 2.52350108526, 19317.1925403286), new Vsop87.LnVsop(1.2E-10, 2.79038116103, 40853.142184844), new Vsop87.LnVsop(1.2E-10, 1.85567065198, 103292.23063610759), new Vsop87.LnVsop(1.4E-10, 4.37656794787, 56727.7597802072), new Vsop87.LnVsop(1.5E-10, 5.47646255736, 25973.46385288896), new Vsop87.LnVsop(1.1E-10, 5.96971832495, 27147.28507176339), new Vsop87.LnVsop(1.2E-10, 2.70038843071, 41962.5207369374), new Vsop87.LnVsop(1.3E-10, 1.60466136746, 26202.34243025941), new Vsop87.LnVsop(1.0E-10, 3.38206384741, 24498.8302462904), new Vsop87.LnVsop(1.1E-10, 5.82335799292, 48733.23133818299), new Vsop87.LnVsop(1.3E-10, 2.8216492732, 78793.40038981718), new Vsop87.LnVsop(1.1E-10, 0.07458891736, 79323.09135491178), new Vsop87.LnVsop(9.0E-11, 2.11663162533, 26095.016688575), new Vsop87.LnVsop(9.0E-11, 1.32867484444, 29530.4780865396), new Vsop87.LnVsop(9.0E-11, 0.82317919987, 365230.6439820388), new Vsop87.LnVsop(1.1E-10, 2.5198207061, 213.299095438), new Vsop87.LnVsop(9.0E-11, 5.6125510058, 45405.0956819028), new Vsop87.LnVsop(8.0E-11, 0.5105233569, 110012.94461544899), new Vsop87.LnVsop(8.0E-11, 3.57838242313, 9103.9069941176), new Vsop87.LnVsop(1.1E-10, 3.16612623037, 10213.285546211), new Vsop87.LnVsop(9.0E-11, 1.1780698089, 82815.66292178139), new Vsop87.LnVsop(7.0E-11, 4.44614528188, 55618.3812281138), new Vsop87.LnVsop(1.0E-10, 1.64021877585, 30639.856638633), new Vsop87.LnVsop(7.0E-11, 3.01288118296, 33326.5787331742), new Vsop87.LnVsop(1.0E-10, 6.01140407134, 36301.18868778519), new Vsop87.LnVsop(7.0E-11, 2.76299517138, 83925.0414738748), new Vsop87.LnVsop(9.0E-11, 1.93819742025, 124778.18365871879), new Vsop87.LnVsop(7.0E-11, 5.86071538076, 26301.2022370122), new Vsop87.LnVsop(9.0E-11, 2.91823648304, 26080.78959457339), new Vsop87.LnVsop(8.0E-11, 1.31267725201, 3442.5749449654), new Vsop87.LnVsop(7.0E-11, 3.27939983168, 16983.9961474566), new Vsop87.LnVsop(7.0E-11, 2.72030070524, 51749.20809227239), new Vsop87.LnVsop(9.0E-11, 1.66808932215, 50057.04242277), new Vsop87.LnVsop(7.0E-11, 5.03188425899, 76044.9523205358), new Vsop87.LnVsop(6.0E-11, 5.00360500512, 79219.3091663312), new Vsop87.LnVsop(7.0E-11, 6.07818216662, 7.1135470008), new Vsop87.LnVsop(7.0E-11, 5.25223733427, 129380.13377768178), new Vsop87.LnVsop(6.0E-11, 0.66028465921, 38519.945791972), new Vsop87.LnVsop(8.0E-11, 1.46897620912, 27676.976036858), new Vsop87.LnVsop(6.0E-11, 3.892971537, 136100.84775702318), new Vsop87.LnVsop(6.0E-11, 1.42686898116, 1059.3819301892), new Vsop87.LnVsop(7.0E-11, 4.44152723528, 15874.6175953632), new Vsop87.LnVsop(6.0E-11, 4.59565794787, 181505.94343892598), new Vsop87.LnVsop(7.0E-11, 6.07267965515, 66941.04532641819), new Vsop87.LnVsop(6.0E-11, 3.24607855066, 52389.1053785864), new Vsop87.LnVsop(5.0E-11, 4.06197322543, 103396.01282468818), new Vsop87.LnVsop(5.0E-11, 0.20766621493, 69159.80243060499), new Vsop87.LnVsop(7.0E-11, 5.63268204588, 104881.30353139139), new Vsop87.LnVsop(6.0E-11, 4.70546255833, 52290.24557183361), new Vsop87.LnVsop(5.0E-11, 5.48898995924, 5661.3320491522), new Vsop87.LnVsop(6.0E-11, 2.60268608066, 639.897286314), new Vsop87.LnVsop(5.0E-11, 3.75395808867, 1066.49547719), new Vsop87.LnVsop(5.0E-11, 2.27447016547, 52061.36699446317), new Vsop87.LnVsop(6.0E-11, 5.59309697114, 23754.70674870219), new Vsop87.LnVsop(6.0E-11, 3.30437999047, 51962.5071877104), new Vsop87.LnVsop(5.0E-11, 2.83333016549, 77734.01845962799), new Vsop87.LnVsop(4.0E-11, 4.18886248495, 2218.7571041868), new Vsop87.LnVsop(4.0E-11, 5.44996443878, 25448.00585526019), new Vsop87.LnVsop(4.0E-11, 2.49467694933, 6283.0758499914), new Vsop87.LnVsop(5.0E-11, 5.70870935931, 2118.7638603784), new Vsop87.LnVsop(5.0E-11, 3.22395783989, 105410.99449648599), new Vsop87.LnVsop(4.0E-11, 0.09916856221, 13655.8604911764), new Vsop87.LnVsop(5.0E-11, 0.59973221538, 955.5997416086), new Vsop87.LnVsop(4.0E-11, 1.80254747407, 80482.46652890938), new Vsop87.LnVsop(3.0E-11, 5.23309315292, 64741.95798313119), new Vsop87.LnVsop(3.0E-11, 2.39330094298, 38654.05484155699), new Vsop87.LnVsop(3.0E-11, 2.57458433543, 155468.036919256), new Vsop87.LnVsop(4.0E-11, 5.07115322045, 78267.59076008058), new Vsop87.LnVsop(4.0E-11, 5.77967325372, 26514.5013324502), new Vsop87.LnVsop(3.0E-11, 2.3014815175, 73711.75592766379), new Vsop87.LnVsop(4.0E-11, 4.21727708992, 1052.2683831884), new Vsop87.LnVsop(3.0E-11, 2.46345351544, 426.598190876), new Vsop87.LnVsop(3.0E-11, 4.25457558968, 108903.56606335558), new Vsop87.LnVsop(3.0E-11, 5.13279896483, 150866.08680029298), new Vsop87.LnVsop(3.0E-11, 4.72421832023, 18849.2275499742), new Vsop87.LnVsop(3.0E-11, 6.1159331072, 59414.4818747484), new Vsop87.LnVsop(3.0E-11, 2.488795594, 71492.99882347698), new Vsop87.LnVsop(3.0E-11, 4.4764330263, 53764.8791784322), new Vsop87.LnVsop(4.0E-11, 6.14344706234, 78477.00852016058), new Vsop87.LnVsop(3.0E-11, 1.51533003761, 28421.0995344462), new Vsop87.LnVsop(3.0E-11, 0.71956036719, 11322.6640983044), new Vsop87.LnVsop(3.0E-11, 2.6734837986, 74821.13447975718), new Vsop87.LnVsop(3.0E-11, 0.79945669251, 162188.75089859738), new Vsop87.LnVsop(3.0E-11, 2.14815045285, 78244.0396638228), new Vsop87.LnVsop(3.0E-11, 2.82222191238, 62389.09182935939), new Vsop87.LnVsop(3.0E-11, 2.76748201992, 52602.4044740244), new Vsop87.LnVsop(3.0E-11, 1.9689835293, 102762.53967101299), new Vsop87.LnVsop(2.0E-11, 1.16780835398, 78283.37918562238), new Vsop87.LnVsop(2.0E-11, 4.47449945171, 12566.1516999828), new Vsop87.LnVsop(3.0E-11, 2.8804718318, 93028.94846799239), new Vsop87.LnVsop(2.0E-11, 3.80780256116, 64607.84893354619), new Vsop87.LnVsop(2.0E-11, 1.27798847041, 81706.28436968799), new Vsop87.LnVsop(2.0E-11, 1.54584958809, 28206.6670019526), new Vsop87.LnVsop(3.0E-11, 1.17857208902, 77623.81213840858), new Vsop87.LnVsop(2.0E-11, 4.88982108835, 68050.42387851159), new Vsop87.LnVsop(2.0E-11, 2.64659209004, 130969.20667296558), new Vsop87.LnVsop(2.0E-11, 0.77279881726, 129483.91596626239), new Vsop87.LnVsop(2.0E-11, 4.19328099887, 78259.82808936459), new Vsop87.LnVsop(2.0E-11, 1.80053876257, 853.196381752), new Vsop87.LnVsop(2.0E-11, 2.85455305411, 7994.5284420242), new Vsop87.LnVsop(2.0E-11, 4.55116089785, 52156.1365222486), new Vsop87.LnVsop(2.0E-11, 4.39479757391, 85034.42002596818), new Vsop87.LnVsop(2.0E-11, 0.20942265156, 88476.99497093359), new Vsop87.LnVsop(2.0E-11, 1.26254478035, 79852.78232000639), new Vsop87.LnVsop(2.0E-11, 3.8915072232, 391318.54712361295), new Vsop87.LnVsop(2.0E-11, 2.04228268324, 13521.7514415914), new Vsop87.LnVsop(2.0E-11, 1.63162182525, 52179.6876185064), new Vsop87.LnVsop(2.0E-11, 0.06540438917, 131498.89763806018), new Vsop87.LnVsop(2.0E-11, 2.37116664144, 94138.32702008578), new Vsop87.LnVsop(2.0E-11, 5.93228693986, 52168.69273614759), new Vsop87.LnVsop(2.0E-11, 3.72472287325, 65697.55772473979), new Vsop87.LnVsop(2.0E-11, 3.93660707629, 99799.65906923798), new Vsop87.LnVsop(2.0E-11, 4.86329180578, 131548.89425996438), new Vsop87.LnVsop(2.0E-11, 3.49584320658, 52195.47604404819), new Vsop87.LnVsop(2.0E-11, 4.53167102336, 76144.94556434419), new Vsop87.LnVsop(2.0E-11, 0.10881384247, 6770.7106012456), new Vsop87.LnVsop(2.0E-11, 1.48407007502, 105307.21230790539), new Vsop87.LnVsop(2.0E-11, 1.81828652056, 102132.85546210999), new Vsop87.LnVsop(2.0E-11, 3.7527454864, 105460.99111839019), new Vsop87.LnVsop(2.0E-11, 5.33436795308, 104331.94280539699), new Vsop87.LnVsop(1.0E-11, 0.16054262075, 52171.9249477904), new Vsop87.LnVsop(2.0E-11, 5.19574633584, 51322.60990139639), new Vsop87.LnVsop(2.0E-11, 5.79451235679, 103821.92160120218), new Vsop87.LnVsop(1.0E-11, 4.31275936318, 104371.28232719658), new Vsop87.LnVsop(2.0E-11, 5.87361011941, 181555.94006083018), new Vsop87.LnVsop(1.0E-11, 0.84208500803, 51123.53789995999), new Vsop87.LnVsop(1.0E-11, 5.8342411387, 120226.23016165999), new Vsop87.LnVsop(1.0E-11, 1.49109031037, 78378.1487134078), new Vsop87.LnVsop(1.0E-11, 2.29392399306, 104355.49390165479), new Vsop87.LnVsop(1.0E-11, 1.63896473054, 125887.56221081219), new Vsop87.LnVsop(1.0E-11, 3.95295093204, 188276.6540401716), new Vsop87.LnVsop(1.0E-11, 0.96789367427, 44937.1306915484), new Vsop87.LnVsop(2.0E-11, 1.30685997283, 51109.31080595839), new Vsop87.LnVsop(2.0E-11, 0.18671610339, 25021.4076643842), new Vsop87.LnVsop(1.0E-11, 0.9582640192, 104347.73123093879), new Vsop87.LnVsop(1.0E-11, 5.52121474401, 97580.90196505119), new Vsop87.LnVsop(2.0E-11, 0.59513540388, 35191.8101356918), new Vsop87.LnVsop(1.0E-11, 5.15925373621, 19804.8272915828), new Vsop87.LnVsop(1.0E-11, 0.65006628215, 78050.41032928458), new Vsop87.LnVsop(2.0E-11, 1.90450740831, 23969.1392811958), new Vsop87.LnVsop(1.0E-11, 4.32826013352, 77837.11123384659), new Vsop87.LnVsop(1.0E-11, 4.65423180642, 78256.59587772179), new Vsop87.LnVsop(1.0E-11, 4.01765755434, 45892.73043315699), new Vsop87.LnVsop(1.0E-11, 1.0620572703, 134991.4692049298), new Vsop87.LnVsop(1.0E-11, 5.91135191152, 26727.8004278882), new Vsop87.LnVsop(1.0E-11, 5.33774808422, 78149.27013603736), new Vsop87.LnVsop(1.0E-11, 5.7819842315, 91785.46086631398), new Vsop87.LnVsop(1.0E-11, 2.96773065217, 129909.82474277639), new Vsop87.LnVsop(1.0E-11, 3.3097581918, 39743.7636327506), new Vsop87.LnVsop(1.0E-11, 6.10771078765, 25035.6347583858), new Vsop87.LnVsop(1.0E-11, 5.67221349248, 52182.9198301492), new Vsop87.LnVsop(1.0E-11, 2.48518819686, 90829.86112470538), new Vsop87.LnVsop(1.0E-11, 4.24431178719, 78270.82297172339), new Vsop87.LnVsop(1.0E-11, 3.23031265434, 7238.6755916), new Vsop87.LnVsop(1.0E-11, 3.34535840387, 114564.89811250778), new Vsop87.LnVsop(1.0E-11, 3.87498999181, 71025.0338331226), new Vsop87.LnVsop(1.0E-11, 0.37439113949, 78690.30761559859), new Vsop87.LnVsop(1.0E-11, 3.33731181959, 104564.91166173479), new Vsop87.LnVsop(1.0E-11, 5.11692827664, 151975.46535238638), new Vsop87.LnVsop(1.0E-11, 2.03914564106, 176953.98994186718), new Vsop87.LnVsop(1.0E-11, 6.15951882831, 70269.18098269838), new Vsop87.LnVsop(1.0E-11, 1.26757694099, 104358.72611329758)};
        private static Vsop87.LnVsop[] mercury_latitude_b3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(6.468E-7, 2.16518315874, 26087.9031415742), new Vsop87.LnVsop(3.0733E-7, 0.0, 0.0), new Vsop87.LnVsop(1.8929E-7, 5.40870348072, 52175.8062831484), new Vsop87.LnVsop(9.797E-8, 2.41402344018, 78263.70942472259), new Vsop87.LnVsop(6.861E-8, 5.88312096876, 104351.61256629678), new Vsop87.LnVsop(4.367E-8, 2.88362764626, 130439.51570787099), new Vsop87.LnVsop(2.344E-8, 6.0558166462, 156527.41884944518), new Vsop87.LnVsop(1.105E-8, 2.89178837278, 182615.3219910194), new Vsop87.LnVsop(4.75E-9, 5.98256115875, 208703.2251325936), new Vsop87.LnVsop(1.91E-9, 2.77298018505, 234791.12827416777), new Vsop87.LnVsop(7.3E-10, 5.83474996935, 260879.03141574195), new Vsop87.LnVsop(2.7E-10, 2.60945701067, 286966.9345573162), new Vsop87.LnVsop(2.4E-10, 3.87337367986, 27197.2816936676), new Vsop87.LnVsop(1.6E-10, 1.06059146335, 24978.5245894808), new Vsop87.LnVsop(8.0E-11, 5.66780041298, 313054.83769889036), new Vsop87.LnVsop(6.0E-11, 5.58854950623, 51066.427731055), new Vsop87.LnVsop(7.0E-11, 3.08546607033, 77154.33087262919), new Vsop87.LnVsop(5.0E-11, 0.02983831713, 103242.2340142034), new Vsop87.LnVsop(3.0E-11, 2.47133249668, 339142.7408404646), new Vsop87.LnVsop(2.0E-11, 1.54850606185, 1109.3785520934), new Vsop87.LnVsop(3.0E-11, 1.80338603638, 53285.1848352418), new Vsop87.LnVsop(2.0E-11, 3.17513673341, 129330.13715577759), new Vsop87.LnVsop(2.0E-11, 0.12967223359, 79373.087976816), new Vsop87.LnVsop(1.0E-11, 5.35275811299, 20426.571092422), new Vsop87.LnVsop(1.0E-11, 1.51126337634, 21535.9496445154), new Vsop87.LnVsop(1.0E-11, 2.60937074595, 46514.4742339962), new Vsop87.LnVsop(1.0E-11, 4.35415847538, 25132.3033999656), new Vsop87.LnVsop(1.0E-11, 0.0149555542, 1059.3819301892), new Vsop87.LnVsop(1.0E-11, 0.38681085251, 31749.2351907264), new Vsop87.LnVsop(1.0E-11, 1.49317898303, 27043.5028831828), new Vsop87.LnVsop(1.0E-11, 1.37353507736, 1589.0728952838), new Vsop87.LnVsop(1.0E-11, 4.03577664541, 4551.9534970588), new Vsop87.LnVsop(1.0E-11, 3.34548299714, 105460.99111839019), new Vsop87.LnVsop(1.0E-11, 5.16936349855, 25028.521211385), new Vsop87.LnVsop(1.0E-11, 0.11390654963, 5661.3320491522), new Vsop87.LnVsop(1.0E-11, 1.41108698419, 47623.8527860896), new Vsop87.LnVsop(1.0E-11, 6.2512804421, 155418.04029735178), new Vsop87.LnVsop(0.0, 5.54564708703, 365230.6439820388), new Vsop87.LnVsop(1.0E-11, 6.08850785156, 51116.4243529592)};
        private static Vsop87.LnVsop[] mercury_latitude_b4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.427E-8, 4.97519726738, 26087.9031415742), new Vsop87.LnVsop(4.91E-9, 3.14159265359, 0.0), new Vsop87.LnVsop(3.36E-9, 3.19691284098, 52175.8062831484), new Vsop87.LnVsop(2.43E-9, 0.57739947651, 78263.70942472259), new Vsop87.LnVsop(1.7E-9, 4.04262780835, 104351.61256629678), new Vsop87.LnVsop(1.2E-9, 1.12342918082, 130439.51570787099), new Vsop87.LnVsop(7.6E-10, 4.36272648537, 156527.41884944518), new Vsop87.LnVsop(4.3E-10, 1.23406162348, 182615.3219910194), new Vsop87.LnVsop(2.2E-10, 4.35637189777, 208703.2251325936), new Vsop87.LnVsop(1.0E-10, 1.16395130801, 234791.12827416777), new Vsop87.LnVsop(4.0E-11, 4.27354172628, 260879.03141574195), new Vsop87.LnVsop(1.0E-11, 1.02393401255, 286966.9345573162), new Vsop87.LnVsop(0.0, 4.13470035458, 313054.83769889036)};
        private static Vsop87.LnVsop[] mercury_latitude_b5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(9.0E-11, 1.38311629808, 52175.8062831484), new Vsop87.LnVsop(8.0E-11, 5.38548752147, 26087.9031415742), new Vsop87.LnVsop(6.0E-11, 4.90804019263, 78263.70942472259), new Vsop87.LnVsop(6.0E-11, 0.0, 0.0), new Vsop87.LnVsop(4.0E-11, 2.13779173141, 104351.61256629678), new Vsop87.LnVsop(3.0E-11, 5.58133586504, 130439.51570787099), new Vsop87.LnVsop(2.0E-11, 2.64274667677, 156527.41884944518), new Vsop87.LnVsop(1.0E-11, 5.83772628756, 182615.3219910194), new Vsop87.LnVsop(1.0E-11, 2.68770315459, 208703.2251325936), new Vsop87.LnVsop(0.0, 5.84365103714, 234791.12827416777)};

        Latitude() {
        }
    }

    static class Longitude1 {
        private static Vsop87.LnVsop[] mercury_longitude_l1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(26087.90313685529, 0.0, 0.0), new Vsop87.LnVsop(0.01131199811, 6.21874197797, 26087.9031415742), new Vsop87.LnVsop(0.00292242298, 3.04449355541, 52175.8062831484), new Vsop87.LnVsop(7.5775081E-4, 6.08568821653, 78263.70942472259), new Vsop87.LnVsop(1.9676525E-4, 2.80965111777, 104351.61256629678), new Vsop87.LnVsop(5.119883E-5, 5.79432353574, 130439.51570787099), new Vsop87.LnVsop(1.336324E-5, 2.47909947012, 156527.41884944518), new Vsop87.LnVsop(3.5223E-6, 3.05246348628, 1109.3785520934), new Vsop87.LnVsop(3.50236E-6, 5.43397743985, 182615.3219910194), new Vsop87.LnVsop(9.3444E-7, 6.11761855456, 27197.2816936676), new Vsop87.LnVsop(9.0588E-7, 5.3733031E-4, 24978.5245894808), new Vsop87.LnVsop(9.2259E-7, 2.09530377053, 208703.2251325936), new Vsop87.LnVsop(5.1943E-7, 5.62157845897, 5661.3320491522), new Vsop87.LnVsop(4.4343E-7, 4.57417248957, 25028.521211385), new Vsop87.LnVsop(2.7651E-7, 3.03660330131, 51066.427731055), new Vsop87.LnVsop(2.1994E-7, 0.8647518216, 955.5997416086), new Vsop87.LnVsop(2.0378E-7, 3.71392682666, 20426.571092422), new Vsop87.LnVsop(2.0226E-7, 0.52020649631, 21535.9496445154), new Vsop87.LnVsop(2.4445E-7, 5.03171884876, 234791.12827416777), new Vsop87.LnVsop(1.7507E-7, 5.72782246025, 4551.9534970588), new Vsop87.LnVsop(1.6673E-7, 1.34980149127, 529.6909650946), new Vsop87.LnVsop(1.5305E-7, 1.79227510901, 11322.6640983044), new Vsop87.LnVsop(1.5398E-7, 5.7425911966, 19.66976089979), new Vsop87.LnVsop(1.396E-7, 3.59440619771, 24498.8302462904), new Vsop87.LnVsop(1.3163E-7, 2.71002769534, 53285.1848352418), new Vsop87.LnVsop(1.2621E-7, 3.89533871193, 3.881335358), new Vsop87.LnVsop(1.2503E-7, 4.7013355234, 1059.3819301892), new Vsop87.LnVsop(7.967E-8, 4.1717547088, 26617.5941066688), new Vsop87.LnVsop(8.012E-8, 3.92669813128, 27043.5028831828), new Vsop87.LnVsop(7.703E-8, 0.4960922418, 46514.4742339962), new Vsop87.LnVsop(7.496E-8, 2.4777465217, 57837.1383323006), new Vsop87.LnVsop(8.388E-8, 6.05157476676, 77154.33087262919), new Vsop87.LnVsop(6.84E-8, 2.7739372243, 7.1135470008), new Vsop87.LnVsop(6.554E-8, 5.5349960828, 6770.7106012456), new Vsop87.LnVsop(5.846E-8, 4.28173811514, 16983.9961474566), new Vsop87.LnVsop(7.178E-8, 2.97769079034, 2218.7571041868), new Vsop87.LnVsop(6.358E-8, 2.13820928214, 25132.3033999656), new Vsop87.LnVsop(5.879E-8, 2.19602452599, 13521.7514415914), new Vsop87.LnVsop(5.065E-8, 2.48292263185, 30639.856638633), new Vsop87.LnVsop(6.517E-8, 1.67892400042, 260879.03141574195), new Vsop87.LnVsop(4.85E-8, 4.84628981357, 37410.5672398786), new Vsop87.LnVsop(5.019E-8, 3.94203732877, 25661.3049506982), new Vsop87.LnVsop(4.392E-8, 1.54280887262, 27147.28507176339), new Vsop87.LnVsop(4.382E-8, 4.94443288387, 213.299095438), new Vsop87.LnVsop(4.017E-8, 5.52771226937, 83925.0414738748), new Vsop87.LnVsop(4.299E-8, 5.08757395593, 10213.285546211), new Vsop87.LnVsop(4.588E-8, 0.82044096381, 25558.2121764796), new Vsop87.LnVsop(3.569E-8, 2.3431918046, 32858.61374281979), new Vsop87.LnVsop(3.549E-8, 3.59449539427, 26068.2333806744), new Vsop87.LnVsop(4.456E-8, 5.79195846107, 3442.5749449654), new Vsop87.LnVsop(3.418E-8, 0.49892587318, 22645.32819660879), new Vsop87.LnVsop(3.473E-8, 1.39724118346, 77204.32749453338), new Vsop87.LnVsop(3.186E-8, 1.25564690041, 14765.2390432698), new Vsop87.LnVsop(3.029E-8, 4.45211520724, 7238.6755916), new Vsop87.LnVsop(2.98E-8, 0.13991629145, 50586.73338786459), new Vsop87.LnVsop(3.284E-8, 5.23011989016, 25448.00585526019), new Vsop87.LnVsop(2.857E-8, 0.67101346147, 26091.7844769322), new Vsop87.LnVsop(3.133E-8, 6.21363252783, 26080.78959457339), new Vsop87.LnVsop(2.724E-8, 5.64058806769, 1589.0728952838), new Vsop87.LnVsop(2.628E-8, 0.87590020075, 52705.49724824299), new Vsop87.LnVsop(2.641E-8, 3.52814897103, 72602.37737557039), new Vsop87.LnVsop(3.124E-8, 6.07149300722, 28306.66024576099), new Vsop87.LnVsop(2.797E-8, 2.51124084505, 26107.57290247399), new Vsop87.LnVsop(2.403E-8, 1.15501613908, 25035.6347583858), new Vsop87.LnVsop(2.503E-8, 4.35025740225, 41962.5207369374), new Vsop87.LnVsop(2.241E-8, 1.84953945797, 36301.18868778519), new Vsop87.LnVsop(2.32E-8, 5.4424311037, 26084.0218062162), new Vsop87.LnVsop(2.534E-8, 5.80058447871, 26095.016688575), new Vsop87.LnVsop(2.871E-8, 1.63509831596, 25021.4076643842), new Vsop87.LnVsop(2.063E-8, 1.07103665169, 43071.8992890308), new Vsop87.LnVsop(1.986E-8, 2.95920226047, 23969.1392811958), new Vsop87.LnVsop(2.508E-8, 2.76403654972, 103242.2340142034), new Vsop87.LnVsop(1.961E-8, 0.83450558631, 12566.1516999828), new Vsop87.LnVsop(1.846E-8, 4.42974192764, 103292.23063610759), new Vsop87.LnVsop(1.651E-8, 1.25437456685, 33326.5787331742), new Vsop87.LnVsop(1.786E-8, 1.8101082268, 26301.2022370122), new Vsop87.LnVsop(1.594E-8, 2.2686796279, 110012.94461544899), new Vsop87.LnVsop(1.579E-8, 4.61224012719, 53235.18821333759), new Vsop87.LnVsop(1.779E-8, 5.17437777314, 426.598190876), new Vsop87.LnVsop(1.601E-8, 5.53140059013, 56727.7597802072), new Vsop87.LnVsop(2.099E-8, 5.15770653744, 51220.20654153979), new Vsop87.LnVsop(1.59E-8, 0.07655136418, 23869.1460373874), new Vsop87.LnVsop(1.748E-8, 4.6041925959, 286966.9345573162), new Vsop87.LnVsop(1.593E-8, 4.86694690893, 79373.087976816), new Vsop87.LnVsop(1.525E-8, 3.75842012487, 73711.75592766379), new Vsop87.LnVsop(1.358E-8, 1.44570665984, 51646.11531805379), new Vsop87.LnVsop(1.324E-8, 1.13417813347, 68050.42387851159), new Vsop87.LnVsop(1.345E-8, 3.80182679561, 19317.1925403286), new Vsop87.LnVsop(1.242E-8, 3.79390052115, 25874.6040461362), new Vsop87.LnVsop(1.132E-8, 1.2472367602, 31749.2351907264), new Vsop87.LnVsop(1.259E-8, 1.73164966232, 12432.0426503978), new Vsop87.LnVsop(1.035E-8, 4.30505315648, 40853.142184844), new Vsop87.LnVsop(1.01E-8, 3.57886637986, 48733.23133818299), new Vsop87.LnVsop(9.81E-9, 0.32956536507, 52156.1365222486), new Vsop87.LnVsop(1.031E-8, 3.72181647641, 6283.0758499914), new Vsop87.LnVsop(1.015E-8, 4.34316985494, 77734.01845962799), new Vsop87.LnVsop(1.143E-8, 2.5649719048, 29530.4780865396), new Vsop87.LnVsop(9.76E-9, 5.29476493474, 65697.55772473979), new Vsop87.LnVsop(8.49E-9, 4.90682657214, 62389.09182935939), new Vsop87.LnVsop(8.61E-9, 0.48881788219, 99799.65906923798), new Vsop87.LnVsop(8.72E-9, 4.78830513218, 18849.2275499742), new Vsop87.LnVsop(8.49E-9, 3.87015948421, 78793.40038981718), new Vsop87.LnVsop(8.55E-9, 0.25155177774, 98690.28051714458), new Vsop87.LnVsop(8.09E-9, 2.35162494261, 27676.976036858), new Vsop87.LnVsop(7.56E-9, 3.91466184753, 38654.05484155699), new Vsop87.LnVsop(7.77E-9, 3.69099415988, 52179.6876185064), new Vsop87.LnVsop(7.41E-9, 0.37372573509, 105460.99111839019), new Vsop87.LnVsop(7.44E-9, 2.09528358878, 51535.90899683439), new Vsop87.LnVsop(7.36E-9, 6.05485667197, 114.43928868521), new Vsop87.LnVsop(7.29E-9, 1.15635861097, 129380.13377768178), new Vsop87.LnVsop(6.99E-9, 3.14468277514, 47623.8527860896), new Vsop87.LnVsop(6.98E-9, 2.99353080731, 52168.69273614759), new Vsop87.LnVsop(8.28E-9, 0.03967891327, 53131.406024757), new Vsop87.LnVsop(7.51E-9, 4.22622963362, 51123.53789995999), new Vsop87.LnVsop(7.52E-9, 4.70040857872, 51109.31080595839), new Vsop87.LnVsop(6.51E-9, 5.8735389219, 2333.196392872), new Vsop87.LnVsop(6.98E-9, 4.82796933102, 38519.945791972), new Vsop87.LnVsop(6.56E-9, 3.65489167792, 25668.418497699), new Vsop87.LnVsop(7.4E-9, 5.74343325106, 129330.13715577759), new Vsop87.LnVsop(6.4E-9, 1.96265162206, 26514.5013324502), new Vsop87.LnVsop(7.53E-9, 5.64825867964, 45892.73043315699), new Vsop87.LnVsop(6.1E-9, 1.21211116825, 153.7788104848), new Vsop87.LnVsop(8.11E-9, 4.22901744472, 25654.19140369739), new Vsop87.LnVsop(5.84E-9, 2.65166793147, 76674.63652943878), new Vsop87.LnVsop(6.71E-9, 1.88069825702, 77308.10968311399), new Vsop87.LnVsop(5.59E-9, 5.26845568234, 136100.84775702318), new Vsop87.LnVsop(5.67E-9, 6.08799470543, 25234.70675982219), new Vsop87.LnVsop(5.23E-9, 4.17422789646, 94138.32702008578), new Vsop87.LnVsop(5.27E-9, 5.8336653223, 50057.04242277), new Vsop87.LnVsop(5.23E-9, 2.45663231877, 467.9649903544), new Vsop87.LnVsop(5.26E-9, 2.06863255789, 91785.46086631398), new Vsop87.LnVsop(6.97E-9, 2.57166718581, 52182.9198301492), new Vsop87.LnVsop(5.23E-9, 1.35829138439, 79323.09135491178), new Vsop87.LnVsop(5.54E-9, 3.10829478558, 15874.6175953632), new Vsop87.LnVsop(5.46E-9, 2.77273663291, 54394.56338733519), new Vsop87.LnVsop(4.91E-9, 0.38994513676, 32370.9789915656), new Vsop87.LnVsop(5.05E-9, 2.27352111828, 82815.66292178139), new Vsop87.LnVsop(5.86E-9, 5.45833122512, 52195.47604404819), new Vsop87.LnVsop(6.16E-9, 4.18181890063, 639.897286314), new Vsop87.LnVsop(5.01E-9, 2.12293246629, 52171.9249477904), new Vsop87.LnVsop(4.44E-9, 3.09631644931, 49957.0491789616), new Vsop87.LnVsop(4.27E-9, 5.35376808888, 49.9966219042), new Vsop87.LnVsop(4.7E-9, 1.23850164176, 313054.83769889036), new Vsop87.LnVsop(4.69E-9, 1.4651800672, 1066.49547719), new Vsop87.LnVsop(4.0E-9, 5.24589064914, 58946.51688439399), new Vsop87.LnVsop(5.21E-9, 4.9237717714, 52389.1053785864), new Vsop87.LnVsop(4.04E-9, 2.49441656744, 71980.63357473118), new Vsop87.LnVsop(4.42E-9, 1.05846681262, 103821.92160120218), new Vsop87.LnVsop(5.09E-9, 1.03889091502, 24491.71669928959), new Vsop87.LnVsop(4.21E-9, 0.36954299695, 51962.5071877104), new Vsop87.LnVsop(3.86E-9, 0.92423685606, 77837.11123384659), new Vsop87.LnVsop(3.63E-9, 3.08451517102, 131548.89425996438), new Vsop87.LnVsop(4.0E-9, 3.51672858608, 20760.4270331914), new Vsop87.LnVsop(3.58E-9, 0.02964909169, 2118.7638603784), new Vsop87.LnVsop(3.56E-9, 2.03742854569, 1052.2683831884), new Vsop87.LnVsop(3.52E-9, 3.49165605975, 125887.56221081219), new Vsop87.LnVsop(4.23E-9, 4.21490947326, 18093.37469954999), new Vsop87.LnVsop(3.36E-9, 1.55219177388, 24505.94379329119), new Vsop87.LnVsop(3.28E-9, 5.45155251381, 7880.08915333899), new Vsop87.LnVsop(3.33E-9, 1.04986280945, 66941.04532641819), new Vsop87.LnVsop(3.05E-9, 1.70579427712, 79219.3091663312), new Vsop87.LnVsop(2.94E-9, 0.89719097618, 63498.47038145279), new Vsop87.LnVsop(2.89E-9, 1.66524837037, 88476.99497093359), new Vsop87.LnVsop(3.21E-9, 5.58902496814, 55618.3812281138), new Vsop87.LnVsop(3.81E-9, 2.16600770844, 522.5774180938), new Vsop87.LnVsop(3.89E-9, 0.54659889883, 45405.0956819028), new Vsop87.LnVsop(3.05E-9, 1.52082857349, 44937.1306915484), new Vsop87.LnVsop(2.75E-9, 3.32813520041, 78244.0396638228), new Vsop87.LnVsop(2.66E-9, 0.68060995712, 64741.95798313119), new Vsop87.LnVsop(2.88E-9, 4.98360015732, 25551.09862947879), new Vsop87.LnVsop(2.6E-9, 5.34007178889, 53764.8791784322), new Vsop87.LnVsop(2.55E-9, 4.14975855255, 155468.036919256), new Vsop87.LnVsop(2.64E-9, 0.57786571512, 104881.30353139139), new Vsop87.LnVsop(2.66E-9, 3.23724695644, 124778.18365871879), new Vsop87.LnVsop(2.65E-9, 1.0424012469, 25938.3399444396), new Vsop87.LnVsop(2.42E-9, 0.4480742492, 23754.70674870219), new Vsop87.LnVsop(2.22E-9, 0.45066526427, 51116.4243529592), new Vsop87.LnVsop(2.18E-9, 5.05361806009, 52602.4044740244), new Vsop87.LnVsop(2.11E-9, 5.09174612431, 117873.36400788819), new Vsop87.LnVsop(2.82E-9, 3.81278076218, 536.8045120954), new Vsop87.LnVsop(2.07E-9, 3.49711450533, 58458.88213313979), new Vsop87.LnVsop(2.0E-9, 5.41587372095, 16066.0658614748), new Vsop87.LnVsop(2.02E-9, 2.38190671463, 23439.44831610119), new Vsop87.LnVsop(2.14E-9, 0.40710565979, 78267.59076008058), new Vsop87.LnVsop(2.15E-9, 2.42593080866, 155418.04029735178), new Vsop87.LnVsop(1.96E-9, 3.91420687435, 103925.01437542078), new Vsop87.LnVsop(2.01E-9, 2.7317198003, 59414.4818747484), new Vsop87.LnVsop(2.07E-9, 4.87003667439, 103396.01282468818), new Vsop87.LnVsop(1.88E-9, 3.84383993794, 69159.80243060499), new Vsop87.LnVsop(1.84E-9, 0.90817110368, 120226.23016165999), new Vsop87.LnVsop(2.15E-9, 5.35772672442, 206.1855484372), new Vsop87.LnVsop(1.78E-9, 1.2517021027, 103.0927742186), new Vsop87.LnVsop(1.86E-9, 1.97860871529, 162188.75089859738), new Vsop87.LnVsop(1.83E-9, 2.87999350716, 3328.13565628019), new Vsop87.LnVsop(1.95E-9, 0.44655194207, 51756.3216392732), new Vsop87.LnVsop(2.17E-9, 4.48208092219, 26241.681952059), new Vsop87.LnVsop(2.15E-9, 2.26829365379, 33967.99229491319), new Vsop87.LnVsop(2.0E-9, 1.01165670813, 51742.09454527159), new Vsop87.LnVsop(1.79E-9, 1.42332722447, 77197.21394753258), new Vsop87.LnVsop(2.23E-9, 0.97930066855, 77211.44104153418), new Vsop87.LnVsop(1.93E-9, 5.5921663636, 78270.82297172339), new Vsop87.LnVsop(1.62E-9, 5.5570382582, 98068.53671630539), new Vsop87.LnVsop(1.61E-9, 5.51813734364, 26555.8681319286), new Vsop87.LnVsop(1.97E-9, 4.80011640279, 25455.119402261), new Vsop87.LnVsop(1.73E-9, 4.35603175355, 105307.21230790539), new Vsop87.LnVsop(1.58E-9, 2.63936949472, 28421.0995344462), new Vsop87.LnVsop(1.63E-9, 2.82189871585, 26202.34243025941), new Vsop87.LnVsop(1.54E-9, 2.25328873364, 89586.37352302698), new Vsop87.LnVsop(1.55E-9, 5.21123811238, 77623.81213840858), new Vsop87.LnVsop(1.95E-9, 1.02146810928, 44181.27784112419), new Vsop87.LnVsop(1.87E-9, 4.98586575384, 102762.53967101299), new Vsop87.LnVsop(1.79E-9, 5.1142972288, 25440.89230825939), new Vsop87.LnVsop(1.52E-9, 5.99106319634, 78256.59587772179), new Vsop87.LnVsop(1.64E-9, 4.36120554838, 105410.99449648599), new Vsop87.LnVsop(1.84E-9, 0.26387432742, 419.4846438752), new Vsop87.LnVsop(1.44E-9, 2.90699736539, 51322.60990139639), new Vsop87.LnVsop(1.43E-9, 5.95657669344, 157636.79740153858), new Vsop87.LnVsop(1.49E-9, 5.77248289868, 80482.46652890938), new Vsop87.LnVsop(1.6E-9, 1.00653088516, 26727.8004278882), new Vsop87.LnVsop(1.6E-9, 1.39442186441, 26011.6370702986), new Vsop87.LnVsop(1.39E-9, 0.27101064668, 46848.3301747656), new Vsop87.LnVsop(1.33E-9, 3.26795404064, 25973.46385288896), new Vsop87.LnVsop(1.41E-9, 3.31881997762, 78050.41032928458), new Vsop87.LnVsop(1.31E-9, 0.6987483409, 3340.6124266998), new Vsop87.LnVsop(1.52E-9, 1.72125145972, 78477.00852016058), new Vsop87.LnVsop(1.54E-9, 5.27681182377, 108903.56606335558), new Vsop87.LnVsop(1.26E-9, 0.20427766386, 151975.46535238638), new Vsop87.LnVsop(1.65E-9, 4.06407630596, 129909.82474277639), new Vsop87.LnVsop(1.47E-9, 4.06027405748, 50579.61984086379), new Vsop87.LnVsop(1.25E-9, 6.09822754682, 76044.9523205358), new Vsop87.LnVsop(1.63E-9, 6.16787830179, 19406.6782881746), new Vsop87.LnVsop(1.38E-9, 5.11907374655, 433.7117378768), new Vsop87.LnVsop(1.28E-9, 4.15814269417, 339142.7408404646), new Vsop87.LnVsop(1.33E-9, 5.23408461673, 26610.48055966799), new Vsop87.LnVsop(1.53E-9, 1.29821059795, 13655.8604911764), new Vsop87.LnVsop(1.14E-9, 4.61849532926, 50593.84693486539), new Vsop87.LnVsop(1.22E-9, 2.53164787291, 76144.94556434419), new Vsop87.LnVsop(1.13E-9, 4.51202339397, 27154.3986187642), new Vsop87.LnVsop(1.02E-9, 3.96711417536, 26037.90651966999), new Vsop87.LnVsop(1.1E-9, 3.4597531715, 25565.3257234804), new Vsop87.LnVsop(1.01E-9, 0.11486997352, 74821.13447975718), new Vsop87.LnVsop(1.0E-9, 1.88687551078, 85034.42002596818), new Vsop87.LnVsop(9.9E-10, 5.98979152528, 29416.03879785439), new Vsop87.LnVsop(1.32E-9, 5.4433122863, 51749.20809227239), new Vsop87.LnVsop(9.7E-10, 3.01165560161, 28206.6670019526), new Vsop87.LnVsop(9.6E-10, 5.22162983089, 85502.38501632259), new Vsop87.LnVsop(1.32E-9, 5.94907535629, 1223.81784077861), new Vsop87.LnVsop(1.13E-9, 3.55407420407, 71492.99882347698), new Vsop87.LnVsop(1.23E-9, 2.05111107086, 78283.37918562238), new Vsop87.LnVsop(9.0E-10, 5.94701228084, 25131.61398560359), new Vsop87.LnVsop(1.09E-9, 5.03445354966, 78259.82808936459), new Vsop87.LnVsop(9.3E-10, 2.31189694942, 81706.28436968799), new Vsop87.LnVsop(9.5E-10, 4.68010019254, 114564.89811250778), new Vsop87.LnVsop(1.03E-9, 4.0574744332, 93028.94846799239), new Vsop87.LnVsop(9.7E-10, 2.65105244357, 9103.9069941176), new Vsop87.LnVsop(8.7E-10, 0.84408485633, 181555.94006083018), new Vsop87.LnVsop(8.8E-10, 3.70188799404, 90829.86112470538), new Vsop87.LnVsop(9.8E-10, 0.52096836281, 26624.70765366959), new Vsop87.LnVsop(8.3E-10, 2.12974304987, 42153.969003049), new Vsop87.LnVsop(9.8E-10, 3.31309863421, 853.196381752), new Vsop87.LnVsop(8.1E-10, 1.81824819424, 143961.2671494624), new Vsop87.LnVsop(8.4E-10, 5.18245305336, 220.4126424388), new Vsop87.LnVsop(1.01E-9, 4.52477254053, 71025.0338331226), new Vsop87.LnVsop(7.7E-10, 0.62552658856, 130012.91751699499), new Vsop87.LnVsop(7.6E-10, 1.62946702195, 25984.8103673556), new Vsop87.LnVsop(7.6E-10, 5.02442522075, 115674.27666460119), new Vsop87.LnVsop(8.0E-10, 1.97972400646, 149.5631971346), new Vsop87.LnVsop(8.0E-10, 2.03736548887, 79852.78232000639), new Vsop87.LnVsop(1.03E-9, 4.71419562154, 12725.453434775), new Vsop87.LnVsop(7.5E-10, 0.26953948526, 84546.78527471398), new Vsop87.LnVsop(7.9E-10, 0.0469425045, 104331.94280539699), new Vsop87.LnVsop(7.5E-10, 5.0815645271, 27140.17152476259), new Vsop87.LnVsop(7.6E-10, 0.97242106203, 131395.11544947958), new Vsop87.LnVsop(8.3E-10, 2.04932157543, 1596.1864422846), new Vsop87.LnVsop(7.1E-10, 5.07452765154, 1911.1994832172), new Vsop87.LnVsop(7.8E-10, 2.062014115, 26137.8997634784), new Vsop87.LnVsop(7.5E-10, 5.47582690516, 134.109049585), new Vsop87.LnVsop(7.0E-10, 3.68283702967, 24609.0365675098), new Vsop87.LnVsop(7.0E-10, 1.81758262361, 78690.30761559859), new Vsop87.LnVsop(8.2E-10, 3.56719394593, 130969.20667296558), new Vsop87.LnVsop(6.9E-10, 1.56209488244, 19804.8272915828), new Vsop87.LnVsop(8.1E-10, 6.21759166284, 150866.08680029298), new Vsop87.LnVsop(7.9E-10, 1.36891218086, 52329.58509363319), new Vsop87.LnVsop(6.3E-10, 1.65140982876, 13541.42120249119), new Vsop87.LnVsop(6.8E-10, 4.75308792133, 25881.717593137), new Vsop87.LnVsop(6.1E-10, 3.48595464034, 24925.4284371664), new Vsop87.LnVsop(6.3E-10, 1.57827554991, 129483.91596626239), new Vsop87.LnVsop(7.8E-10, 3.56226703365, 49842.60989027639), new Vsop87.LnVsop(6.2E-10, 5.3983564622, 181505.94343892598), new Vsop87.LnVsop(6.1E-10, 3.9140667011, 146314.13330323418), new Vsop87.LnVsop(5.9E-10, 2.97195438319, 110.2063212194), new Vsop87.LnVsop(6.8E-10, 2.328218099, 26294.08869001139), new Vsop87.LnVsop(5.8E-10, 3.88873694244, 18207.81398823521), new Vsop87.LnVsop(5.8E-10, 3.71053330388, 29428.515568274), new Vsop87.LnVsop(7.5E-10, 1.41437208584, 128850.44281258718), new Vsop87.LnVsop(7.8E-10, 6.14359232239, 14477.3511832), new Vsop87.LnVsop(5.6E-10, 2.29859296005, 124156.43985787958), new Vsop87.LnVsop(6.6E-10, 1.69753750078, 51543.0225438352), new Vsop87.LnVsop(5.6E-10, 5.26803267928, 49527.35145767539), new Vsop87.LnVsop(5.4E-10, 2.60951368247, 183724.7005431128), new Vsop87.LnVsop(6.9E-10, 1.78610678374, 51639.00177105299), new Vsop87.LnVsop(5.4E-10, 2.29388731799, 52643.7712735028), new Vsop87.LnVsop(6.6E-10, 4.00966591652, 103299.34418310839), new Vsop87.LnVsop(5.6E-10, 4.96631677002, 188276.6540401716), new Vsop87.LnVsop(6.5E-10, 4.49060152064, 636.9962720242), new Vsop87.LnVsop(6.0E-10, 3.40809070256, 104355.49390165479), new Vsop87.LnVsop(5.3E-10, 2.32227902289, 104358.72611329758), new Vsop87.LnVsop(5.0E-10, 2.13377899787, 7994.5284420242), new Vsop87.LnVsop(5.5E-10, 2.95916513077, 40565.2543247742), new Vsop87.LnVsop(6.2E-10, 0.58557454545, 307.5576209696), new Vsop87.LnVsop(4.7E-10, 1.21556523304, 23976.2528281966), new Vsop87.LnVsop(6.0E-10, 3.69214546142, 641.41356173899), new Vsop87.LnVsop(4.6E-10, 4.41061598045, 103285.11708910679), new Vsop87.LnVsop(4.7E-10, 4.02740344259, 77829.99768684579), new Vsop87.LnVsop(4.6E-10, 4.06742204523, 52815.7035694624), new Vsop87.LnVsop(4.6E-10, 1.91809870879, 51528.79544983359), new Vsop87.LnVsop(6.1E-10, 1.28766566948, 38813.3565763492), new Vsop87.LnVsop(4.5E-10, 0.02404887996, 104138.31347085879), new Vsop87.LnVsop(4.6E-10, 3.3850759783, 26507.38778544939), new Vsop87.LnVsop(5.6E-10, 2.67487495081, 25934.1243310894), new Vsop87.LnVsop(4.3E-10, 2.29690412567, 25764.39772491679), new Vsop87.LnVsop(5.3E-10, 3.48804345716, 77844.22478084739), new Vsop87.LnVsop(5.3E-10, 2.82902106909, 6681.2248533996), new Vsop87.LnVsop(4.3E-10, 6.22587772111, 26094.53170047421), new Vsop87.LnVsop(4.5E-10, 1.6218850714, 76.2660712756), new Vsop87.LnVsop(4.2E-10, 3.85973680463, 10021.8372800994), new Vsop87.LnVsop(4.4E-10, 4.79295047779, 104564.91166173479), new Vsop87.LnVsop(5.4E-10, 0.75825267175, 155997.72788435058), new Vsop87.LnVsop(4.3E-10, 3.21677125258, 178063.3684939606), new Vsop87.LnVsop(4.3E-10, 4.90471393771, 24395.7374720718), new Vsop87.LnVsop(4.0E-10, 4.13303476978, 26190.99591579279), new Vsop87.LnVsop(5.1E-10, 0.49016223108, 23962.02573419499), new Vsop87.LnVsop(4.9E-10, 1.06876913146, 131498.89763806018), new Vsop87.LnVsop(4.0E-10, 1.47589588843, 76681.75007643958), new Vsop87.LnVsop(4.1E-10, 0.4626626438, 25619.9381512198), new Vsop87.LnVsop(4.2E-10, 5.6820907798, 54509.0026760204), new Vsop87.LnVsop(4.0E-10, 0.39115190758, 1089.7087911936), new Vsop87.LnVsop(3.9E-10, 2.75514812039, 25867.49049913539), new Vsop87.LnVsop(5.2E-10, 3.69276520556, 39609.6545831656), new Vsop87.LnVsop(3.8E-10, 4.64939276647, 90695.75207512038), new Vsop87.LnVsop(4.8E-10, 1.65661010519, 1581.959348283), new Vsop87.LnVsop(3.8E-10, 0.95035569681, 76667.52298243798), new Vsop87.LnVsop(3.7E-10, 3.99657674443, 9384.8410080752), new Vsop87.LnVsop(3.8E-10, 1.84533474277, 27999.1026247914), new Vsop87.LnVsop(4.2E-10, 5.8569989218, 52290.24557183361), new Vsop87.LnVsop(3.6E-10, 2.82272277217, 102132.85546210999), new Vsop87.LnVsop(3.9E-10, 0.16689114463, 22759.76748529401), new Vsop87.LnVsop(4.1E-10, 1.21766150084, 64607.84893354619), new Vsop87.LnVsop(3.7E-10, 1.88934655832, 26521.614879451), new Vsop87.LnVsop(3.6E-10, 4.75190829106, 39629.32434406539), new Vsop87.LnVsop(3.4E-10, 1.73557945245, 111590.2881578968), new Vsop87.LnVsop(4.7E-10, 2.00316977982, 134991.4692049298), new Vsop87.LnVsop(4.0E-10, 3.07506618678, 26081.27458267419), new Vsop87.LnVsop(3.2E-10, 5.94771139984, 77410.51304297059), new Vsop87.LnVsop(3.1E-10, 2.6709330111, 104344.49901929598), new Vsop87.LnVsop(3.4E-10, 0.29046758495, 97580.90196505119), new Vsop87.LnVsop(3.8E-10, 5.08542116385, 25863.55834587229), new Vsop87.LnVsop(3.7E-10, 4.28144356206, 39743.7636327506), new Vsop87.LnVsop(3.0E-10, 0.64719060865, 2648.454825473), new Vsop87.LnVsop(3.2E-10, 3.88808183601, 157483.01859105378), new Vsop87.LnVsop(3.3E-10, 5.3739471131, 102232.84870591838), new Vsop87.LnVsop(3.3E-10, 1.96187028937, 74.7815985673), new Vsop87.LnVsop(3.3E-10, 0.73726931669, 365230.6439820388), new Vsop87.LnVsop(3.0E-10, 2.98247268132, 100909.03762133139), new Vsop87.LnVsop(3.1E-10, 0.01609173971, 52061.36699446317), new Vsop87.LnVsop(3.0E-10, 1.22842683538, 53242.3017603384), new Vsop87.LnVsop(2.9E-10, 5.72086729674, 579.6875869988), new Vsop87.LnVsop(2.9E-10, 0.73428938505, 52125.80966124419), new Vsop87.LnVsop(3.7E-10, 1.60845101133, 333.8559407694), new Vsop87.LnVsop(2.8E-10, 0.4155006352, 35472.7441496494), new Vsop87.LnVsop(2.8E-10, 0.53073222303, 50696.93970908399), new Vsop87.LnVsop(2.8E-10, 6.11780804536, 25977.69682035479), new Vsop87.LnVsop(2.8E-10, 5.95593416963, 54294.57014352679), new Vsop87.LnVsop(2.7E-10, 2.00186979186, 52698.38370124219), new Vsop87.LnVsop(2.6E-10, 5.31661191916, 107794.1875112622), new Vsop87.LnVsop(2.6E-10, 1.60908008816, 141762.17980617538), new Vsop87.LnVsop(2.6E-10, 5.92563636648, 35191.8101356918), new Vsop87.LnVsop(2.6E-10, 5.05695617382, 26237.46633870879), new Vsop87.LnVsop(3.0E-10, 1.96093367442, 26308.315784013), new Vsop87.LnVsop(2.9E-10, 1.40377849854, 140652.80125408198), new Vsop87.LnVsop(2.6E-10, 4.4711860431, 78417.48823520739), new Vsop87.LnVsop(3.0E-10, 4.35157546455, 154938.34595416137), new Vsop87.LnVsop(2.4E-10, 0.08450572691, 51013.33157874059), new Vsop87.LnVsop(2.5E-10, 3.61161212347, 156100.82065856917), new Vsop87.LnVsop(2.6E-10, 6.02329577077, 25227.59321282139), new Vsop87.LnVsop(3.2E-10, 0.2933872091, 51653.22886505459), new Vsop87.LnVsop(3.1E-10, 1.27169874011, 97112.93697469679), new Vsop87.LnVsop(2.7E-10, 0.43436351538, 116917.76426627958), new Vsop87.LnVsop(2.5E-10, 3.5646487486, 52712.61079524379), new Vsop87.LnVsop(2.5E-10, 4.83140440999, 170049.1702910366), new Vsop87.LnVsop(2.4E-10, 4.15688353859, 19202.75325164339), new Vsop87.LnVsop(2.5E-10, 5.22158703638, 25241.820306823), new Vsop87.LnVsop(2.6E-10, 2.09788180403, 103711.71527998279), new Vsop87.LnVsop(2.6E-10, 2.73620097953, 27311.72098235281), new Vsop87.LnVsop(2.5E-10, 3.31719041454, 110634.68841628819), new Vsop87.LnVsop(2.3E-10, 3.4201822547, 956.2891559706), new Vsop87.LnVsop(2.4E-10, 4.58737053626, 632.7837393132), new Vsop87.LnVsop(2.5E-10, 3.83768999695, 207643.8432024044), new Vsop87.LnVsop(2.2E-10, 4.60495557405, 52072.71350892979), new Vsop87.LnVsop(2.2E-10, 0.81962371662, 314.1861798696), new Vsop87.LnVsop(3.1E-10, 0.78529600723, 119116.85160956658), new Vsop87.LnVsop(2.8E-10, 5.28999472918, 26162.6847401415), new Vsop87.LnVsop(2.9E-10, 2.32148522569, 26720.68688088739), new Vsop87.LnVsop(2.2E-10, 2.40798298166, 8194.2753332086), new Vsop87.LnVsop(2.6E-10, 5.94441879648, 95247.70557217918), new Vsop87.LnVsop(2.4E-10, 5.01838309036, 105940.68546158058), new Vsop87.LnVsop(2.0E-10, 2.47683833264, 2703.6161546756), new Vsop87.LnVsop(2.0E-10, 2.55917238627, 51219.51712717779), new Vsop87.LnVsop(2.7E-10, 4.25138184607, 647.0108333148), new Vsop87.LnVsop(2.0E-10, 3.02046049418, 52182.4348420484), new Vsop87.LnVsop(2.1E-10, 4.84549558153, 104778.21075717278), new Vsop87.LnVsop(1.9E-10, 3.68979639516, 735.8765135318), new Vsop87.LnVsop(2.5E-10, 5.57998927338, 34282.1784747828), new Vsop87.LnVsop(2.1E-10, 1.10992644362, 121335.60871375339), new Vsop87.LnVsop(1.9E-10, 3.83331533037, 5327.4761083828), new Vsop87.LnVsop(2.2E-10, 3.00327681149, 130419.8459469712), new Vsop87.LnVsop(2.0E-10, 3.23786060546, 1083.0802322936), new Vsop87.LnVsop(1.9E-10, 2.02512845515, 22747.2907148744), new Vsop87.LnVsop(2.3E-10, 1.66833589775, 104347.73123093879), new Vsop87.LnVsop(2.5E-10, 3.72802716994, 621.7438008392), new Vsop87.LnVsop(1.8E-10, 1.62490267654, 48835.19385644859), new Vsop87.LnVsop(2.4E-10, 4.8851157872, 104371.28232719658), new Vsop87.LnVsop(2.3E-10, 3.20407513183, 6044.2285813754), new Vsop87.LnVsop(1.8E-10, 2.74020165764, 55503.94193942859), new Vsop87.LnVsop(2.0E-10, 2.16894744006, 106570.36967048359), new Vsop87.LnVsop(1.7E-10, 4.26021716269, 24176.703658357), new Vsop87.LnVsop(2.3E-10, 2.89452389903, 176953.98994186718), new Vsop87.LnVsop(2.0E-10, 4.62650989512, 13362.4497067992), new Vsop87.LnVsop(2.2E-10, 0.13700318671, 26941.0995233262), new Vsop87.LnVsop(1.7E-10, 4.53180927338, 155571.81910783658), new Vsop87.LnVsop(1.7E-10, 5.27323351022, 150244.3429994538), new Vsop87.LnVsop(2.0E-10, 0.88920884923, 52022.0274726636), new Vsop87.LnVsop(1.7E-10, 0.66438061926, 44295.7171298094), new Vsop87.LnVsop(1.8E-10, 4.2280134545, 78114.14622758799), new Vsop87.LnVsop(1.8E-10, 6.10669263205, 26198.1094627936), new Vsop87.LnVsop(1.9E-10, 5.88397827824, 32132.1317229496), new Vsop87.LnVsop(2.2E-10, 0.27997322515, 157057.10981453978), new Vsop87.LnVsop(1.8E-10, 5.25487083597, 68241.8721446232), new Vsop87.LnVsop(1.7E-10, 5.12957293922, 27684.0895838588), new Vsop87.LnVsop(2.1E-10, 2.44454107206, 24822.3356629478), new Vsop87.LnVsop(1.6E-10, 4.30778552752, 50064.15596977079), new Vsop87.LnVsop(1.6E-10, 4.85996294185, 77630.92568540938), new Vsop87.LnVsop(1.6E-10, 2.24217976098, 26222.0121911592), new Vsop87.LnVsop(1.9E-10, 1.94778680051, 487.6347512542), new Vsop87.LnVsop(1.7E-10, 0.5173379192, 55516.4187098482), new Vsop87.LnVsop(1.9E-10, 2.59562362231, 71582.48457132299), new Vsop87.LnVsop(1.6E-10, 4.18243271644, 147423.51185532758), new Vsop87.LnVsop(1.5E-10, 0.42980730987, 101.9625182656), new Vsop87.LnVsop(1.6E-10, 2.16628656707, 86143.79857806159), new Vsop87.LnVsop(2.0E-10, 6.16417051409, 52169.17772424839), new Vsop87.LnVsop(1.6E-10, 0.59073234751, 172402.0364448084), new Vsop87.LnVsop(1.6E-10, 1.72028680267, 53228.07466633679), new Vsop87.LnVsop(1.5E-10, 1.01843035425, 25138.7275326044), new Vsop87.LnVsop(1.7E-10, 1.63141160811, 214364.55718174577), new Vsop87.LnVsop(1.5E-10, 3.75399093257, 159.3017347922), new Vsop87.LnVsop(1.5E-10, 1.95481617109, 207593.8465805002), new Vsop87.LnVsop(1.6E-10, 4.96142627268, 52225.8029050526), new Vsop87.LnVsop(1.4E-10, 0.95351554243, 96357.08412427259), new Vsop87.LnVsop(1.5E-10, 5.76671377675, 14.2270940016), new Vsop87.LnVsop(1.4E-10, 5.57769049264, 209812.60368468694), new Vsop87.LnVsop(1.4E-10, 0.61729981227, 183570.921732628), new Vsop87.LnVsop(1.7E-10, 5.07627546033, 60055.89543648739), new Vsop87.LnVsop(1.6E-10, 2.54178935302, 25780.3455206046), new Vsop87.LnVsop(1.4E-10, 4.28355124764, 1692.1656695024), new Vsop87.LnVsop(1.5E-10, 5.01473605278, 28791.5192962498), new Vsop87.LnVsop(1.3E-10, 0.98344727754, 45290.65639321759), new Vsop87.LnVsop(1.3E-10, 4.761122979, 26164.1692128498), new Vsop87.LnVsop(1.7E-10, 1.58612856328, 51969.62073471119), new Vsop87.LnVsop(1.5E-10, 5.36372773071, 78731.674415077), new Vsop87.LnVsop(1.3E-10, 5.39542347713, 52381.99183158559), new Vsop87.LnVsop(1.3E-10, 4.87338812455, 64901.25971792339), new Vsop87.LnVsop(1.7E-10, 2.39131877144, 75615.25459924959), new Vsop87.LnVsop(1.7E-10, 0.07084676538, 2199.087343287), new Vsop87.LnVsop(1.2E-10, 1.63509087059, 72936.23331633979), new Vsop87.LnVsop(1.3E-10, 0.40053805312, 1162.4747044078), new Vsop87.LnVsop(1.4E-10, 0.74485553956, 129387.24732468258), new Vsop87.LnVsop(1.6E-10, 5.9169654465, 32769.1279949738), new Vsop87.LnVsop(1.3E-10, 4.2805574907, 23866.04650697719), new Vsop87.LnVsop(1.2E-10, 0.87706609381, 24292.64469785319), new Vsop87.LnVsop(1.3E-10, 2.0120888517, 128320.75184749259), new Vsop87.LnVsop(1.3E-10, 1.30119195062, 26724.8994135984), new Vsop87.LnVsop(1.2E-10, 1.81653810675, 22909.7573510066), new Vsop87.LnVsop(1.4E-10, 3.14098076689, 11610.5519583742), new Vsop87.LnVsop(1.1E-10, 5.30288510851, 24601.92302050899), new Vsop87.LnVsop(1.3E-10, 3.84039381809, 25953.79409198919), new Vsop87.LnVsop(1.1E-10, 0.81162414242, 78903.60671103658), new Vsop87.LnVsop(1.3E-10, 3.72512024241, 182085.63102592478), new Vsop87.LnVsop(1.1E-10, 5.26526210273, 130446.62925487179), new Vsop87.LnVsop(1.1E-10, 1.49242011592, 130652.81480330898), new Vsop87.LnVsop(1.4E-10, 2.81964511477, 1639.069517188), new Vsop87.LnVsop(1.3E-10, 4.02613728949, 111122.32316754239), new Vsop87.LnVsop(1.1E-10, 2.3546177307, 35077.37084700659), new Vsop87.LnVsop(1.1E-10, 2.11106605234, 52250.5878817157), new Vsop87.LnVsop(1.1E-10, 5.51868182222, 52808.59002246159), new Vsop87.LnVsop(1.3E-10, 3.24055544955, 102018.41617342478), new Vsop87.LnVsop(1.3E-10, 0.04071468744, 130443.39704322898), new Vsop87.LnVsop(1.4E-10, 4.77952737392, 77726.90491262719), new Vsop87.LnVsop(1.3E-10, 5.60037794332, 25446.4895798352), new Vsop87.LnVsop(1.1E-10, 0.66633124661, 36109.7404216736), new Vsop87.LnVsop(1.0E-10, 4.33936275875, 95.9792272178), new Vsop87.LnVsop(1.4E-10, 4.03073574294, 157586.80077963436), new Vsop87.LnVsop(1.0E-10, 2.92400898739, 130226.21661243298), new Vsop87.LnVsop(1.1E-10, 4.50828985072, 78187.44335344699), new Vsop87.LnVsop(1.2E-10, 6.08801478006, 25450.90686955), new Vsop87.LnVsop(1.1E-10, 6.23593133377, 204151.27163553477), new Vsop87.LnVsop(1.0E-10, 1.01377621126, 65831.6667743248), new Vsop87.LnVsop(1.1E-10, 3.04942272888, 309.2783226558), new Vsop87.LnVsop(1.1E-10, 4.87839287541, 54087.0057663656), new Vsop87.LnVsop(9.0E-11, 3.68149837141, 199599.31813847594), new Vsop87.LnVsop(1.2E-10, 1.94632930172, 1135.6768718932), new Vsop87.LnVsop(1.0E-10, 2.75654212398, 103.7821885806), new Vsop87.LnVsop(9.0E-11, 5.2388907902, 160.40736938481), new Vsop87.LnVsop(9.0E-11, 0.95715458203, 129373.02023068098), new Vsop87.LnVsop(1.0E-10, 1.77424642113, 25754.0472008048), new Vsop87.LnVsop(1.1E-10, 3.45442974499, 27177.6119327678), new Vsop87.LnVsop(1.0E-10, 5.44116629906, 16703.062133499), new Vsop87.LnVsop(1.0E-10, 0.44395632018, 26729.31670331319), new Vsop87.LnVsop(9.0E-11, 3.06481394039, 77101.23472031478), new Vsop87.LnVsop(1.0E-10, 3.60324717226, 76784.84285065818), new Vsop87.LnVsop(1.2E-10, 0.43935234109, 125112.03959948818), new Vsop87.LnVsop(1.0E-10, 4.51325369042, 102769.65321801379), new Vsop87.LnVsop(1.0E-10, 5.29423372003, 8989.46770543239), new Vsop87.LnVsop(9.0E-11, 1.73463346908, 949.1756089698), new Vsop87.LnVsop(1.0E-10, 3.39439566279, 25771.5112719176), new Vsop87.LnVsop(9.0E-11, 2.00243027457, 133882.09065283637), new Vsop87.LnVsop(1.0E-10, 2.40498617897, 3462.2447058652), new Vsop87.LnVsop(9.0E-11, 4.39382176626, 224.3447957019), new Vsop87.LnVsop(1.0E-10, 5.92210377632, 26404.2950112308), new Vsop87.LnVsop(8.0E-11, 3.16962446824, 24079.34560241519), new Vsop87.LnVsop(8.0E-11, 5.48696113187, 34082.4315835984), new Vsop87.LnVsop(8.0E-11, 1.24488871988, 104275.34649502118), new Vsop87.LnVsop(8.0E-11, 0.76238121766, 52101.02468458109), new Vsop87.LnVsop(8.0E-11, 1.48210524716, 12546.481939083), new Vsop87.LnVsop(8.0E-11, 0.46458507594, 11.0457002639), new Vsop87.LnVsop(8.0E-11, 4.87977464179, 52609.51802102519), new Vsop87.LnVsop(9.0E-11, 3.55766276536, 391318.54712361295), new Vsop87.LnVsop(8.0E-11, 3.76663108473, 26395.46076254379), new Vsop87.LnVsop(8.0E-11, 5.75209002292, 86457.98475793119), new Vsop87.LnVsop(9.0E-11, 3.5139792816, 50049.92887576919), new Vsop87.LnVsop(8.0E-11, 5.4973095734, 25352.02662804239), new Vsop87.LnVsop(1.0E-10, 0.2264099079, 103932.12792242158), new Vsop87.LnVsop(8.0E-11, 4.94949508683, 1263.15736257819), new Vsop87.LnVsop(8.0E-11, 5.75024943815, 97670.38771289718), new Vsop87.LnVsop(8.0E-11, 3.55911690335, 25508.2155545754), new Vsop87.LnVsop(8.0E-11, 0.49323679798, 173511.41499690176), new Vsop87.LnVsop(8.0E-11, 4.25787691147, 78109.93061423779), new Vsop87.LnVsop(9.0E-11, 0.48205382916, 233731.7463439786), new Vsop87.LnVsop(8.0E-11, 5.02364007454, 77616.69859140778), new Vsop87.LnVsop(8.0E-11, 3.61376880135, 28736.3579670472), new Vsop87.LnVsop(9.0E-11, 2.48423459733, 58220.0348645238), new Vsop87.LnVsop(7.0E-11, 5.29831732661, 51852.30086649099), new Vsop87.LnVsop(7.0E-11, 0.35423551089, 225687.22128005017), new Vsop87.LnVsop(7.0E-11, 0.75465996591, 103917.90082841998), new Vsop87.LnVsop(7.0E-11, 5.46797664245, 25928.601406782), new Vsop87.LnVsop(7.0E-11, 5.70423964424, 128220.75860368418), new Vsop87.LnVsop(7.0E-11, 3.66110166412, 151199.94274106238), new Vsop87.LnVsop(8.0E-11, 0.97149572453, 181026.24909573558), new Vsop87.LnVsop(7.0E-11, 5.12413207903, 26421.7590823436), new Vsop87.LnVsop(9.0E-11, 4.7591109454, 27669.86248985719), new Vsop87.LnVsop(8.0E-11, 5.95900851407, 625.6701923124), new Vsop87.LnVsop(7.0E-11, 0.32910184643, 179172.74704605396), new Vsop87.LnVsop(7.0E-11, 0.91475243663, 104202.04936916218), new Vsop87.LnVsop(8.0E-11, 1.54770113018, 196137.07343261078), new Vsop87.LnVsop(7.0E-11, 3.01695574126, 70269.18098269838), new Vsop87.LnVsop(9.0E-11, 5.83594884566, 203041.8930834414), new Vsop87.LnVsop(7.0E-11, 5.10008456774, 233681.74972207437), new Vsop87.LnVsop(7.0E-11, 0.14157653167, 51859.41441349179), new Vsop87.LnVsop(9.0E-11, 4.93367100659, 161079.37234650398), new Vsop87.LnVsop(7.0E-11, 5.7525560032, 53399.624123927), new Vsop87.LnVsop(8.0E-11, 0.35259207804, 102872.74599223239), new Vsop87.LnVsop(7.0E-11, 0.34512186024, 54824.2611086214), new Vsop87.LnVsop(7.0E-11, 4.0516749762, 53867.97195265079), new Vsop87.LnVsop(7.0E-11, 2.69373957868, 52492.19815280499), new Vsop87.LnVsop(6.0E-11, 4.72368015481, 74923.09699802278), new Vsop87.LnVsop(6.0E-11, 0.36906501806, 26823.77965510599), new Vsop87.LnVsop(7.0E-11, 2.60864499567, 229129.79622501557), new Vsop87.LnVsop(7.0E-11, 5.03378015347, 159969.99379441058), new Vsop87.LnVsop(7.0E-11, 2.21848820219, 235900.50682626115), new Vsop87.LnVsop(6.0E-11, 4.2017661852, 130363.24963659538), new Vsop87.LnVsop(6.0E-11, 5.89471215179, 84944.9342781222), new Vsop87.LnVsop(6.0E-11, 4.91837821889, 102659.44689679438), new Vsop87.LnVsop(8.0E-11, 1.09478757087, 192828.60753723036), new Vsop87.LnVsop(8.0E-11, 1.86475123525, 2168.7604822826), new Vsop87.LnVsop(7.0E-11, 4.68299502093, 838.9692877504), new Vsop87.LnVsop(6.0E-11, 1.24133628165, 123554.36581794015), new Vsop87.LnVsop(6.0E-11, 1.20512971524, 181659.72224941078), new Vsop87.LnVsop(7.0E-11, 3.89067266316, 77795.74443436819), new Vsop87.LnVsop(6.0E-11, 5.98763670044, 156314.1197540072), new Vsop87.LnVsop(6.0E-11, 3.89399244971, 78188.92782615528), new Vsop87.LnVsop(6.0E-11, 5.34622852527, 104984.39630560997), new Vsop87.LnVsop(6.0E-11, 2.32335163581, 78896.49316403578), new Vsop87.LnVsop(6.0E-11, 1.68227658104, 103718.82882698359), new Vsop87.LnVsop(6.0E-11, 2.48458298163, 123758.29085447139), new Vsop87.LnVsop(6.0E-11, 5.66247708666, 78580.10129437919), new Vsop87.LnVsop(6.0E-11, 6.27477830501, 31415.379249957), new Vsop87.LnVsop(7.0E-11, 3.792107979, 846.0828347512), new Vsop87.LnVsop(7.0E-11, 5.53045913585, 917.9302859818), new Vsop87.LnVsop(6.0E-11, 0.38100676678, 182188.72380014337), new Vsop87.LnVsop(7.0E-11, 1.25845018875, 128857.55635958798), new Vsop87.LnVsop(7.0E-11, 5.9673103143, 156507.7490885454), new Vsop87.LnVsop(8.0E-11, 3.49733249703, 259819.64948555277), new Vsop87.LnVsop(8.0E-11, 3.80991558396, 99024.13645791399), new Vsop87.LnVsop(6.0E-11, 1.45803753709, 101011.00013959699), new Vsop87.LnVsop(6.0E-11, 2.51991869762, 79487.5272655012), new Vsop87.LnVsop(7.0E-11, 5.27159282206, 126996.94076290558), new Vsop87.LnVsop(6.0E-11, 4.53802387387, 156740.7179448832), new Vsop87.LnVsop(6.0E-11, 4.38922472191, 38634.3850806572), new Vsop87.LnVsop(6.0E-11, 1.24138581934, 78160.61665050399), new Vsop87.LnVsop(6.0E-11, 1.96194064026, 176332.24614102798), new Vsop87.LnVsop(6.0E-11, 4.50123750445, 78339.97549599818), new Vsop87.LnVsop(6.0E-11, 3.99725647445, 130285.73689738619), new Vsop87.LnVsop(6.0E-11, 3.69420394003, 78213.71280281838), new Vsop87.LnVsop(8.0E-11, 3.17275221265, 77741.13200662879), new Vsop87.LnVsop(8.0E-11, 4.42357793667, 166740.70439565618), new Vsop87.LnVsop(7.0E-11, 2.50899938142, 78378.1487134078), new Vsop87.LnVsop(6.0E-11, 0.4313007195, 104301.61594439259), new Vsop87.LnVsop(8.0E-11, 5.01521520904, 52396.2189255872), new Vsop87.LnVsop(6.0E-11, 6.09163087172, 51955.39364070959), new Vsop87.LnVsop(7.0E-11, 0.9155396315, 25600.26839032), new Vsop87.LnVsop(7.0E-11, 2.89187371967, 230239.17477710897), new Vsop87.LnVsop(6.0E-11, 2.03170180629, 76571.54375522019), new Vsop87.LnVsop(5.0E-11, 3.91400123749, 130289.95251073639), new Vsop87.LnVsop(6.0E-11, 0.99207626768, 50264.6067999312), new Vsop87.LnVsop(5.0E-11, 1.59855381219, 90989.16285949759), new Vsop87.LnVsop(6.0E-11, 1.01911419114, 26734.913974889), new Vsop87.LnVsop(6.0E-11, 3.1721116589, 123668.80510662538), new Vsop87.LnVsop(6.0E-11, 4.74438520416, 48997.6604925808), new Vsop87.LnVsop(7.0E-11, 3.22371847471, 183145.012956114), new Vsop87.LnVsop(6.0E-11, 2.90289315925, 61279.713277266), new Vsop87.LnVsop(6.0E-11, 0.00896880815, 103829.03514820298), new Vsop87.LnVsop(5.0E-11, 0.00751955508, 149756.7082481996), new Vsop87.LnVsop(5.0E-11, 4.51218979337, 137678.191299471), new Vsop87.LnVsop(7.0E-11, 3.68922759436, 81604.32185142238), new Vsop87.LnVsop(6.0E-11, 4.26037526854, 104248.51979207818), new Vsop87.LnVsop(5.0E-11, 4.39017426465, 65538.25598994759), new Vsop87.LnVsop(6.0E-11, 3.23714935766, 208276.62694171758), new Vsop87.LnVsop(6.0E-11, 3.2575444954, 27250.37784598199), new Vsop87.LnVsop(5.0E-11, 0.50823677768, 417406.4502651872), new Vsop87.LnVsop(7.0E-11, 3.25874001817, 48847.6706268682), new Vsop87.LnVsop(5.0E-11, 2.79144107928, 51315.49635439559), new Vsop87.LnVsop(7.0E-11, 0.15300257128, 2014.9816717978), new Vsop87.LnVsop(6.0E-11, 5.45690475475, 1243.4876016784), new Vsop87.LnVsop(5.0E-11, 5.63427188169, 51868.2486621788), new Vsop87.LnVsop(5.0E-11, 1.31846740403, 94329.77528619739), new Vsop87.LnVsop(5.0E-11, 5.08511501937, 51841.950342379), new Vsop87.LnVsop(6.0E-11, 3.24078877347, 130020.03106399579), new Vsop87.LnVsop(5.0E-11, 2.39019816175, 77956.15180375299), new Vsop87.LnVsop(6.0E-11, 0.093000082, 75930.51303185058), new Vsop87.LnVsop(6.0E-11, 0.57847576593, 26709.6469424134), new Vsop87.LnVsop(6.0E-11, 6.02384295193, 104237.17327761157), new Vsop87.LnVsop(5.0E-11, 1.1780418096, 104505.39137678158), new Vsop87.LnVsop(6.0E-11, 1.53496281816, 130866.11389874699), new Vsop87.LnVsop(5.0E-11, 5.47810909806, 149846.1939960456), new Vsop87.LnVsop(7.0E-11, 1.59214422735, 50800.03248330259), new Vsop87.LnVsop(6.0E-11, 2.37957772692, 80596.9058175946), new Vsop87.LnVsop(5.0E-11, 5.20070080185, 78338.49102328988), new Vsop87.LnVsop(7.0E-11, 3.70877081633, 145204.75475114078), new Vsop87.LnVsop(7.0E-11, 2.08384940658, 52065.59996192899), new Vsop87.LnVsop(6.0E-11, 2.82731949689, 52286.01260436779), new Vsop87.LnVsop(7.0E-11, 6.09436652634, 81591.84508100279), new Vsop87.LnVsop(6.0E-11, 3.54654895094, 198489.9395863826), new Vsop87.LnVsop(5.0E-11, 6.14985688293, 79116.90580647459), new Vsop87.LnVsop(6.0E-11, 4.85208852587, 91805.13062721379), new Vsop87.LnVsop(6.0E-11, 3.78495993627, 207114.15223730978), new Vsop87.LnVsop(5.0E-11, 4.00009786605, 51226.63067417859), new Vsop87.LnVsop(7.0E-11, 4.5675867019, 156954.01704032117), new Vsop87.LnVsop(5.0E-11, 3.75488202656, 155475.15046625677), new Vsop87.LnVsop(7.0E-11, 4.71928298002, 158116.491744729), new Vsop87.LnVsop(6.0E-11, 6.24134016928, 209232.91609768817), new Vsop87.LnVsop(6.0E-11, 0.35400062059, 208173.534167499), new Vsop87.LnVsop(6.0E-11, 0.0550736376, 136722.59155786238), new Vsop87.LnVsop(5.0E-11, 6.03052619166, 50167.24874398939), new Vsop87.LnVsop(5.0E-11, 2.79008591575, 154194.22245657316), new Vsop87.LnVsop(6.0E-11, 1.8781162127, 80174.90890793978), new Vsop87.LnVsop(6.0E-11, 4.20369832735, 123200.84011627098), new Vsop87.LnVsop(5.0E-11, 3.51935800778, 209658.82487420217), new Vsop87.LnVsop(5.0E-11, 1.86237962806, 259769.65286364855), new Vsop87.LnVsop(5.0E-11, 1.05147991932, 27780.06881107659), new Vsop87.LnVsop(5.0E-11, 1.07470529653, 76152.05911134499), new Vsop87.LnVsop(5.0E-11, 5.15226478485, 261988.40996783535), new Vsop87.LnVsop(5.0E-11, 1.2822513287, 39450.3528483734), new Vsop87.LnVsop(6.0E-11, 3.39529287695, 143005.6674078538), new Vsop87.LnVsop(5.0E-11, 2.74556405934, 51329.7234483972), new Vsop87.LnVsop(6.0E-11, 5.93028775117, 1478.8665740644), new Vsop87.LnVsop(5.0E-11, 4.03764312401, 78153.50310350319), new Vsop87.LnVsop(7.0E-11, 0.41429504672, 137210.22630911658), new Vsop87.LnVsop(7.0E-11, 1.33294768928, 1731.1223529326), new Vsop87.LnVsop(6.0E-11, 4.97923764806, 202420.14928260216), new Vsop87.LnVsop(6.0E-11, 4.74759480967, 26575.53789282839), new Vsop87.LnVsop(5.0E-11, 2.53784371972, 154308.6617452584), new Vsop87.LnVsop(5.0E-11, 1.76156503657, 78484.12206716138), new Vsop87.LnVsop(5.0E-11, 0.25034623664, 78800.51393681798), new Vsop87.LnVsop(5.0E-11, 5.51979105321, 50910.238804522), new Vsop87.LnVsop(6.0E-11, 2.79878095447, 182595.65223011957), new Vsop87.LnVsop(5.0E-11, 2.18860356832, 42790.9652750732), new Vsop87.LnVsop(5.0E-11, 0.55904094194, 2383.1930147762), new Vsop87.LnVsop(5.0E-11, 5.27380977719, 52309.9153327334), new Vsop87.LnVsop(5.0E-11, 1.9951416207, 156534.53239644598), new Vsop87.LnVsop(5.0E-11, 3.08962146646, 77947.31755506598), new Vsop87.LnVsop(5.0E-11, 2.53115311032, 80382.47328510099), new Vsop87.LnVsop(6.0E-11, 0.72483599766, 183674.70392120857), new Vsop87.LnVsop(6.0E-11, 5.87094389034, 129586.31932611899), new Vsop87.LnVsop(4.0E-11, 3.38538707199, 174620.79354899516), new Vsop87.LnVsop(5.0E-11, 1.6961053549, 189386.03259226496), new Vsop87.LnVsop(5.0E-11, 4.4404139112, 127098.90328117118), new Vsop87.LnVsop(5.0E-11, 1.91636184492, 52325.36948028299), new Vsop87.LnVsop(4.0E-11, 4.33627478046, 89.485747846), new Vsop87.LnVsop(5.0E-11, 2.78454061573, 103498.41618454478), new Vsop87.LnVsop(5.0E-11, 2.8002233534, 4437.51420837359), new Vsop87.LnVsop(6.0E-11, 4.57903777326, 240452.46032331997), new Vsop87.LnVsop(5.0E-11, 1.82284966431, 1884.9011634174), new Vsop87.LnVsop(4.0E-11, 3.54115739914, 70383.6202713836), new Vsop87.LnVsop(6.0E-11, 4.44862307428, 78057.52387628538), new Vsop87.LnVsop(5.0E-11, 5.60499626286, 87253.17713015496), new Vsop87.LnVsop(4.0E-11, 0.60639839734, 77314.53381575279), new Vsop87.LnVsop(6.0E-11, 3.07379721651, 156531.3001848032), new Vsop87.LnVsop(5.0E-11, 3.05321446236, 78257.08086582259), new Vsop87.LnVsop(4.0E-11, 1.72880081184, 2111.6503133776), new Vsop87.LnVsop(5.0E-11, 5.08493502101, 112231.70171963578), new Vsop87.LnVsop(4.0E-11, 3.17961386708, 107679.74822257696), new Vsop87.LnVsop(4.0E-11, 0.99061214587, 153084.84390447979), new Vsop87.LnVsop(4.0E-11, 2.65750466453, 92741.06060792258), new Vsop87.LnVsop(4.0E-11, 0.58713530175, 323.5054166574), new Vsop87.LnVsop(4.0E-11, 3.71119398255, 26411.4085582316), new Vsop87.LnVsop(4.0E-11, 5.18520847948, 77307.42026875199), new Vsop87.LnVsop(5.0E-11, 0.32192884992, 103127.79472551816), new Vsop87.LnVsop(4.0E-11, 4.23880044095, 207747.625390985), new Vsop87.LnVsop(4.0E-11, 3.32663238546, 104888.41707839219), new Vsop87.LnVsop(5.0E-11, 5.6453064183, 106470.37642667518), new Vsop87.LnVsop(4.0E-11, 0.76539963317, 142871.55835826878), new Vsop87.LnVsop(4.0E-11, 5.77831885615, 25466.159340735), new Vsop87.LnVsop(5.0E-11, 4.50048062606, 222224.97657418498), new Vsop87.LnVsop(5.0E-11, 0.43033089417, 107692.22499299659), new Vsop87.LnVsop(5.0E-11, 1.77942359129, 24356.7807886416), new Vsop87.LnVsop(4.0E-11, 0.27323680716, 52278.89905736699), new Vsop87.LnVsop(4.0E-11, 0.98450071759, 130459.18546877075), new Vsop87.LnVsop(4.0E-11, 0.22797244893, 26247.2048763664), new Vsop87.LnVsop(5.0E-11, 6.27987613458, 74935.5737684424), new Vsop87.LnVsop(5.0E-11, 2.73561601564, 51538.81001112419), new Vsop87.LnVsop(4.0E-11, 4.52036588311, 163298.1294506908), new Vsop87.LnVsop(4.0E-11, 1.46002058771, 935.92998070881), new Vsop87.LnVsop(5.0E-11, 4.66040678637, 102755.42612401219), new Vsop87.LnVsop(4.0E-11, 3.44653657726, 43981.5309499398), new Vsop87.LnVsop(4.0E-11, 4.04811362371, 50380.54783942739), new Vsop87.LnVsop(4.0E-11, 0.10638912543, 38.1330356378), new Vsop87.LnVsop(4.0E-11, 4.61058187343, 118828.96374949679), new Vsop87.LnVsop(4.0E-11, 2.75690095352, 144916.86689107097), new Vsop87.LnVsop(5.0E-11, 5.65870377214, 1300.826818205), new Vsop87.LnVsop(4.0E-11, 4.38451994728, 167850.0829477496), new Vsop87.LnVsop(4.0E-11, 0.90103901385, 24864.08530079559), new Vsop87.LnVsop(4.0E-11, 4.23072497017, 130593.29451835579), new Vsop87.LnVsop(4.0E-11, 6.07315852038, 78270.3379836226), new Vsop87.LnVsop(4.0E-11, 0.80000960641, 1485.2907067032), new Vsop87.LnVsop(4.0E-11, 4.09184420375, 79330.20490191258), new Vsop87.LnVsop(4.0E-11, 5.92521638136, 104344.98400739678), new Vsop87.LnVsop(4.0E-11, 0.50584296046, 17893.6278083656), new Vsop87.LnVsop(5.0E-11, 4.15661237129, 61560.64729122359), new Vsop87.LnVsop(4.0E-11, 1.86779221331, 104874.18998439058), new Vsop87.LnVsop(4.0E-11, 2.38956841519, 51534.3927214094), new Vsop87.LnVsop(4.0E-11, 4.95493599731, 101703.15774082378), new Vsop87.LnVsop(4.0E-11, 1.02712382423, 193937.9860893238), new Vsop87.LnVsop(4.0E-11, 1.73223710668, 187167.2754880782), new Vsop87.LnVsop(4.0E-11, 0.71864596336, 164.43591058941), new Vsop87.LnVsop(4.0E-11, 4.719947568, 215473.93573383917), new Vsop87.LnVsop(4.0E-11, 0.86915287934, 104276.83096772949), new Vsop87.LnVsop(5.0E-11, 0.1836054645, 169093.57054942797), new Vsop87.LnVsop(4.0E-11, 1.68517945931, 103704.60173298199), new Vsop87.LnVsop(4.0E-11, 3.31690695818, 234261.43730907317), new Vsop87.LnVsop(4.0E-11, 5.30812522197, 130432.40216087017), new Vsop87.LnVsop(4.0E-11, 4.71379720816, 129806.73196855778), new Vsop87.LnVsop(4.0E-11, 1.51496580365, 99979.7361995226), new Vsop87.LnVsop(4.0E-11, 2.71144440911, 4083.9885067044), new Vsop87.LnVsop(4.0E-11, 2.79035446022, 104358.2411251968), new Vsop87.LnVsop(4.0E-11, 3.72751712279, 209762.60706278277), new Vsop87.LnVsop(5.0E-11, 1.29231046489, 266540.3634648941), new Vsop87.LnVsop(4.0E-11, 5.59214940732, 104466.051854982), new Vsop87.LnVsop(4.0E-11, 4.67135290282, 154408.65498906677), new Vsop87.LnVsop(4.0E-11, 0.18672297599, 76137.83201734339), new Vsop87.LnVsop(4.0E-11, 4.03785678727, 52822.81711646319), new Vsop87.LnVsop(4.0E-11, 6.06255798891, 103189.13786188899), new Vsop87.LnVsop(4.0E-11, 3.25792439793, 28286.9904848612), new Vsop87.LnVsop(4.0E-11, 6.2631856684, 156107.93420556997), new Vsop87.LnVsop(3.0E-11, 2.12202622054, 78469.89497315978), new Vsop87.LnVsop(4.0E-11, 6.24222910156, 52595.29092702359), new Vsop87.LnVsop(3.0E-11, 4.35697420988, 52812.8025551726), new Vsop87.LnVsop(3.0E-11, 1.97566398707, 138319.60486120995), new Vsop87.LnVsop(4.0E-11, 0.47445141807, 171292.65789271498), new Vsop87.LnVsop(3.0E-11, 1.85052127026, 54879.422437824), new Vsop87.LnVsop(4.0E-11, 4.19697241788, 130435.63437251298), new Vsop87.LnVsop(4.0E-11, 2.99013118992, 78149.27013603736), new Vsop87.LnVsop(4.0E-11, 1.59255142342, 103814.80805420138), new Vsop87.LnVsop(3.0E-11, 1.97075256428, 104426.39416486409), new Vsop87.LnVsop(3.0E-11, 4.71189048263, 195047.36464141717), new Vsop87.LnVsop(4.0E-11, 6.27859532373, 234364.53008329176), new Vsop87.LnVsop(4.0E-11, 0.28730856803, 233202.055378884), new Vsop87.LnVsop(4.0E-11, 5.9432552924, 20043.6745601988), new Vsop87.LnVsop(4.0E-11, 1.12779733765, 139543.4227019886), new Vsop87.LnVsop(3.0E-11, 3.00327186987, 155887.52156313116), new Vsop87.LnVsop(4.0E-11, 2.10267022472, 104819.57755665119), new Vsop87.LnVsop(4.0E-11, 1.77647068401, 132028.58860315479), new Vsop87.LnVsop(4.0E-11, 0.24214782588, 224577.84272795677), new Vsop87.LnVsop(4.0E-11, 4.79211826277, 79315.97780791098), new Vsop87.LnVsop(3.0E-11, 1.77481925226, 53771.99272543299), new Vsop87.LnVsop(4.0E-11, 4.24020912823, 156547.08861034497), new Vsop87.LnVsop(4.0E-11, 5.44046981103, 106684.80895916879), new Vsop87.LnVsop(4.0E-11, 0.35504698785, 27044.1922975448), new Vsop87.LnVsop(3.0E-11, 3.15293616281, 195181.47369100217), new Vsop87.LnVsop(3.0E-11, 4.31718868652, 57503.2823915312), new Vsop87.LnVsop(3.0E-11, 2.68109664026, 58857.03113654799), new Vsop87.LnVsop(3.0E-11, 3.65528504142, 66653.15746634839), new Vsop87.LnVsop(3.0E-11, 0.88720012673, 105418.10804348679), new Vsop87.LnVsop(3.0E-11, 0.47019728706, 181563.05360783098), new Vsop87.LnVsop(3.0E-11, 5.67402424686, 61165.27398858079), new Vsop87.LnVsop(3.0E-11, 2.67128283641, 24998.19435038059), new Vsop87.LnVsop(3.0E-11, 3.80325286994, 26402.0893214438), new Vsop87.LnVsop(3.0E-11, 1.3200424411, 26312.2479372761), new Vsop87.LnVsop(3.0E-11, 0.57514622273, 156377.8556523106), new Vsop87.LnVsop(3.0E-11, 4.10353520436, 218916.51067880457), new Vsop87.LnVsop(3.0E-11, 3.63684349571, 26073.67604757259), new Vsop87.LnVsop(4.0E-11, 5.49029205076, 2125.8774073792), new Vsop87.LnVsop(3.0E-11, 0.83452068925, 149288.74325784517), new Vsop87.LnVsop(3.0E-11, 0.99067389256, 104197.83375581198), new Vsop87.LnVsop(3.0E-11, 3.16251732649, 53029.0026649004), new Vsop87.LnVsop(3.0E-11, 3.95355121933, 91919.56991589899), new Vsop87.LnVsop(3.0E-11, 6.17342775574, 37698.4550999484), new Vsop87.LnVsop(4.0E-11, 3.89947841403, 53906.92863608099), new Vsop87.LnVsop(3.0E-11, 4.11078389229, 155460.9233722552), new Vsop87.LnVsop(3.0E-11, 0.87067834834, 181548.82651382938), new Vsop87.LnVsop(3.0E-11, 1.5798261845, 104501.17576343138), new Vsop87.LnVsop(3.0E-11, 4.12548682099, 71378.55953479178), new Vsop87.LnVsop(3.0E-11, 1.52477907436, 78366.80219894118), new Vsop87.LnVsop(3.0E-11, 0.87753609725, 3178.1457905676), new Vsop87.LnVsop(3.0E-11, 6.07282705878, 50483.640613646), new Vsop87.LnVsop(3.0E-11, 4.43072727499, 50007.0458008658), new Vsop87.LnVsop(4.0E-11, 5.32328931391, 129799.61842155698), new Vsop87.LnVsop(3.0E-11, 1.48103473704, 53757.76563143139), new Vsop87.LnVsop(4.0E-11, 0.00252046526, 103883.64757594238), new Vsop87.LnVsop(3.0E-11, 4.5357369774, 129902.71119577558), new Vsop87.LnVsop(3.0E-11, 4.81232864254, 79859.89586700719), new Vsop87.LnVsop(3.0E-11, 1.66108176894, 78697.42116259939), new Vsop87.LnVsop(3.0E-11, 1.84684752446, 288076.3131094096), new Vsop87.LnVsop(3.0E-11, 4.82712248849, 25991.92391435639), new Vsop87.LnVsop(3.0E-11, 2.3972525414, 156520.30530244438), new Vsop87.LnVsop(3.0E-11, 0.93947739163, 26183.88236879199), new Vsop87.LnVsop(3.0E-11, 0.7052168446, 23384.2869868986), new Vsop87.LnVsop(3.0E-11, 0.97960195128, 156681.19765992998), new Vsop87.LnVsop(3.0E-11, 4.71243430522, 76887.93562487679), new Vsop87.LnVsop(3.0E-11, 3.82703641143, 130005.80396999417), new Vsop87.LnVsop(3.0E-11, 4.79848480761, 27223.5800134674), new Vsop87.LnVsop(3.0E-11, 3.56807161466, 26189.8656598398), new Vsop87.LnVsop(3.0E-11, 5.49802214625, 87367.61641884019), new Vsop87.LnVsop(4.0E-11, 3.04198191749, 162810.49469943656), new Vsop87.LnVsop(3.0E-11, 5.9967496172, 231348.55332920235), new Vsop87.LnVsop(3.0E-11, 2.33106741466, 51439.92976961659), new Vsop87.LnVsop(3.0E-11, 2.61733694893, 130432.88714897096), new Vsop87.LnVsop(2.0E-11, 5.22176508298, 78786.28684281638), new Vsop87.LnVsop(3.0E-11, 4.88028231088, 132658.27281205778), new Vsop87.LnVsop(3.0E-11, 0.90903803463, 24952.226269681), new Vsop87.LnVsop(3.0E-11, 4.44359777408, 6885.14988993081), new Vsop87.LnVsop(2.0E-11, 0.09332198439, 54374.8936264354), new Vsop87.LnVsop(2.0E-11, 1.504200253, 52252.07235442399), new Vsop87.LnVsop(3.0E-11, 0.62857388379, 77039.89158394396), new Vsop87.LnVsop(2.0E-11, 3.69661372368, 45494.58142974879), new Vsop87.LnVsop(3.0E-11, 1.28130112897, 156523.5375140872), new Vsop87.LnVsop(3.0E-11, 3.10706736688, 53132.09543911899), new Vsop87.LnVsop(2.0E-11, 2.39688673711, 52137.67324751059), new Vsop87.LnVsop(3.0E-11, 6.03996003965, 188898.39784101077), new Vsop87.LnVsop(3.0E-11, 1.12896001904, 102975.83876645098), new Vsop87.LnVsop(3.0E-11, 1.06608582202, 128843.32926558638), new Vsop87.LnVsop(3.0E-11, 2.04617498651, 51707.84129279399), new Vsop87.LnVsop(2.0E-11, 4.71560069328, 164407.50800278416), new Vsop87.LnVsop(2.0E-11, 2.70764577076, 182402.02289558138), new Vsop87.LnVsop(2.0E-11, 2.82013540933, 63786.3582415226), new Vsop87.LnVsop(2.0E-11, 2.54951394512, 25985.94062330859), new Vsop87.LnVsop(3.0E-11, 0.19858896817, 53265.515074342), new Vsop87.LnVsop(3.0E-11, 4.34325432962, 168959.46149984296), new Vsop87.LnVsop(3.0E-11, 3.74410347667, 62197.64356324779), new Vsop87.LnVsop(2.0E-11, 0.5264225895, 171004.7700326452), new Vsop87.LnVsop(3.0E-11, 2.31120031707, 26013.1215430069), new Vsop87.LnVsop(3.0E-11, 5.59058462965, 180396.56488683258), new Vsop87.LnVsop(2.0E-11, 2.51510994796, 26667.590728573), new Vsop87.LnVsop(3.0E-11, 1.48135858208, 105403.88094948517), new Vsop87.LnVsop(2.0E-11, 1.0914099613, 180496.558130641), new Vsop87.LnVsop(3.0E-11, 1.22647733767, 248312.87971575916), new Vsop87.LnVsop(2.0E-11, 0.36339757941, 96471.52341295779), new Vsop87.LnVsop(2.0E-11, 1.35408345025, 23919.1426592916), new Vsop87.LnVsop(3.0E-11, 2.80629290854, 78043.29678228378), new Vsop87.LnVsop(2.0E-11, 3.3187605125, 205260.65018762814), new Vsop87.LnVsop(2.0E-11, 0.20681692579, 51596.1186961496), new Vsop87.LnVsop(2.0E-11, 1.53176493082, 158746.17595363196), new Vsop87.LnVsop(2.0E-11, 1.48023064256, 184204.39488630317), new Vsop87.LnVsop(3.0E-11, 1.49887007773, 106262.81204951399), new Vsop87.LnVsop(3.0E-11, 5.05636989583, 130907.4806982254), new Vsop87.LnVsop(3.0E-11, 0.5423831607, 52041.69723356339), new Vsop87.LnVsop(3.0E-11, 5.75431374896, 130446.14426677099), new Vsop87.LnVsop(2.0E-11, 2.93093373409, 159855.55450572536), new Vsop87.LnVsop(2.0E-11, 3.56437176463, 52797.55008398759), new Vsop87.LnVsop(2.0E-11, 2.6204798054, 78683.19406859778), new Vsop87.LnVsop(2.0E-11, 2.11384955087, 25773.71696170459), new Vsop87.LnVsop(2.0E-11, 4.1578241514, 52400.1510788503), new Vsop87.LnVsop(2.0E-11, 5.89562175995, 133767.65136415116), new Vsop87.LnVsop(2.0E-11, 1.35665861508, 183041.9201818954), new Vsop87.LnVsop(2.0E-11, 0.11609465401, 27170.98337386779), new Vsop87.LnVsop(2.0E-11, 3.03178665319, 112545.88789950538), new Vsop87.LnVsop(2.0E-11, 4.105561188, 113455.51956041438), new Vsop87.LnVsop(2.0E-11, 2.14271307715, 51951.46148744649), new Vsop87.LnVsop(2.0E-11, 1.68546478089, 78313.70604662679), new Vsop87.LnVsop(3.0E-11, 6.19908560971, 25004.8229092806), new Vsop87.LnVsop(2.0E-11, 2.84045476324, 155303.60100866656), new Vsop87.LnVsop(2.0E-11, 2.26145864726, 76998.14194609619), new Vsop87.LnVsop(2.0E-11, 4.74126987497, 213255.1786296524), new Vsop87.LnVsop(2.0E-11, 2.40187436652, 52509.6622239178), new Vsop87.LnVsop(2.0E-11, 0.23208171234, 24448.8336243862), new Vsop87.LnVsop(2.0E-11, 2.50290073656, 26102.1302355758), new Vsop87.LnVsop(2.0E-11, 1.36349447497, 234798.24182116857), new Vsop87.LnVsop(2.0E-11, 2.02736374318, 60170.3347251726), new Vsop87.LnVsop(2.0E-11, 3.57423748725, 175730.17210108857), new Vsop87.LnVsop(2.0E-11, 2.55875179877, 76255.15188556358), new Vsop87.LnVsop(2.0E-11, 5.00767344604, 50444.6839302158), new Vsop87.LnVsop(2.0E-11, 4.87112232665, 78413.27262185719), new Vsop87.LnVsop(3.0E-11, 5.80075910765, 78373.91574594198), new Vsop87.LnVsop(2.0E-11, 3.44901114128, 251775.12442162435), new Vsop87.LnVsop(2.0E-11, 5.01117672779, 182622.43553802016), new Vsop87.LnVsop(2.0E-11, 5.77978141973, 77403.39949596979), new Vsop87.LnVsop(2.0E-11, 2.0178329186, 78397.81847430758), new Vsop87.LnVsop(2.0E-11, 1.16361857643, 104145.42701785959), new Vsop87.LnVsop(2.0E-11, 0.28513369746, 235746.72801577637), new Vsop87.LnVsop(2.0E-11, 0.47269960302, 156093.7071115684), new Vsop87.LnVsop(2.0E-11, 3.62048919482, 17098.43543614181), new Vsop87.LnVsop(2.0E-11, 0.12909617158, 52161.57918914679), new Vsop87.LnVsop(2.0E-11, 2.17258312431, 308502.88420183153)};
        private static Vsop87.LnVsop[] mercury_longitude_l2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.6395129E-4, 4.67759555504, 26087.9031415742), new Vsop87.LnVsop(8.123865E-5, 1.40305644134, 52175.8062831484), new Vsop87.LnVsop(3.20817E-5, 4.49577853102, 78263.70942472259), new Vsop87.LnVsop(1.128209E-5, 1.27901273779, 104351.61256629678), new Vsop87.LnVsop(8.77186E-6, 3.14159265359, 0.0), new Vsop87.LnVsop(3.71058E-6, 4.31735787338, 130439.51570787099), new Vsop87.LnVsop(1.16931E-6, 1.04943307731, 156527.41884944518), new Vsop87.LnVsop(3.5802E-7, 4.0458725739, 182615.3219910194), new Vsop87.LnVsop(1.4897E-7, 4.63345988506, 1109.3785520934), new Vsop87.LnVsop(1.0747E-7, 0.74352925179, 208703.2251325936), new Vsop87.LnVsop(5.244E-8, 4.71804553686, 24978.5245894808), new Vsop87.LnVsop(3.182E-8, 3.71128464182, 234791.12827416777), new Vsop87.LnVsop(2.547E-8, 1.43801901419, 27197.2816936676), new Vsop87.LnVsop(2.033E-8, 1.49538090708, 51066.427731055), new Vsop87.LnVsop(9.72E-9, 1.80406148095, 955.5997416086), new Vsop87.LnVsop(9.33E-9, 0.38508064082, 260879.03141574195), new Vsop87.LnVsop(6.28E-9, 6.18336027299, 529.6909650946), new Vsop87.LnVsop(6.28E-9, 4.84993612548, 24498.8302462904), new Vsop87.LnVsop(7.48E-9, 4.53886632656, 77154.33087262919), new Vsop87.LnVsop(6.52E-9, 0.98244103623, 5661.3320491522), new Vsop87.LnVsop(5.7E-9, 5.93087624804, 25028.521211385), new Vsop87.LnVsop(5.54E-9, 2.13567295803, 20426.571092422), new Vsop87.LnVsop(5.08E-9, 4.11405647413, 4551.9534970588), new Vsop87.LnVsop(6.08E-9, 4.54161712968, 2218.7571041868), new Vsop87.LnVsop(4.39E-9, 3.40841487365, 11322.6640983044), new Vsop87.LnVsop(3.83E-9, 2.84041448501, 26617.5941066688), new Vsop87.LnVsop(3.71E-9, 0.82325076093, 6770.7106012456), new Vsop87.LnVsop(3.21E-9, 5.20252163124, 46514.4742339962), new Vsop87.LnVsop(3.1E-9, 3.21458500897, 1059.3819301892), new Vsop87.LnVsop(3.32E-9, 0.97193908732, 25132.3033999656), new Vsop87.LnVsop(3.28E-9, 2.23586205224, 21535.9496445154), new Vsop87.LnVsop(3.03E-9, 4.67984690863, 27043.5028831828), new Vsop87.LnVsop(2.72E-9, 3.33112990946, 286966.9345573162), new Vsop87.LnVsop(2.47E-9, 5.87790567404, 16983.9961474566), new Vsop87.LnVsop(3.11E-9, 4.22425838013, 3442.5749449654), new Vsop87.LnVsop(2.37E-9, 4.37072058392, 114.43928868521), new Vsop87.LnVsop(2.3E-9, 0.93160807269, 30639.856638633), new Vsop87.LnVsop(2.64E-9, 1.28267621568, 103242.2340142034), new Vsop87.LnVsop(2.09E-9, 3.30050747071, 213.299095438), new Vsop87.LnVsop(1.97E-9, 2.07978399454, 22645.32819660879), new Vsop87.LnVsop(1.75E-9, 6.23699804715, 27147.28507176339), new Vsop87.LnVsop(1.82E-9, 0.62557819405, 25448.00585526019), new Vsop87.LnVsop(2.19E-9, 1.34273602039, 28306.66024576099), new Vsop87.LnVsop(1.55E-9, 3.92088824161, 32858.61374281979), new Vsop87.LnVsop(1.61E-9, 5.79480893327, 52705.49724824299), new Vsop87.LnVsop(1.53E-9, 4.33625862893, 1589.0728952838), new Vsop87.LnVsop(1.6E-9, 4.80006144385, 23869.1460373874), new Vsop87.LnVsop(1.49E-9, 1.98766674679, 72602.37737557039), new Vsop87.LnVsop(1.46E-9, 5.95917025706, 14765.2390432698), new Vsop87.LnVsop(1.29E-9, 4.15874670686, 23969.1392811958), new Vsop87.LnVsop(1.35E-9, 3.86681741058, 51220.20654153979), new Vsop87.LnVsop(1.41E-9, 3.66926746092, 25558.2121764796), new Vsop87.LnVsop(1.13E-9, 3.9042155056, 83925.0414738748), new Vsop87.LnVsop(1.08E-9, 1.38888153019, 50586.73338786459), new Vsop87.LnVsop(1.15E-9, 0.15119470114, 26301.2022370122), new Vsop87.LnVsop(1.19E-9, 3.62238641476, 53285.1848352418), new Vsop87.LnVsop(9.8E-10, 3.99032605577, 56727.7597802072), new Vsop87.LnVsop(9.4E-10, 2.05358227305, 26068.2333806744), new Vsop87.LnVsop(1.02E-9, 0.85715423056, 57837.1383323006), new Vsop87.LnVsop(8.6E-10, 3.04235521268, 53235.18821333759), new Vsop87.LnVsop(1.04E-9, 5.32353970232, 7238.6755916), new Vsop87.LnVsop(8.8E-10, 4.29297146473, 129330.13715577759), new Vsop87.LnVsop(9.6E-10, 2.24007027333, 19317.1925403286), new Vsop87.LnVsop(9.9E-10, 0.99982390475, 29530.4780865396), new Vsop87.LnVsop(7.9E-10, 6.26974865489, 313054.83769889036), new Vsop87.LnVsop(7.5E-10, 5.40697085015, 26091.7844769322), new Vsop87.LnVsop(7.4E-10, 4.30770581759, 2333.196392872), new Vsop87.LnVsop(8.1E-10, 0.96615031171, 26107.57290247399), new Vsop87.LnVsop(6.8E-10, 0.70236298544, 110012.94461544899), new Vsop87.LnVsop(8.4E-10, 3.28239679269, 12432.0426503978), new Vsop87.LnVsop(6.9E-10, 3.55775707713, 13521.7514415914), new Vsop87.LnVsop(7.7E-10, 0.2736111021, 37410.5672398786), new Vsop87.LnVsop(6.6E-10, 5.08814197377, 79373.087976816), new Vsop87.LnVsop(6.4E-10, 2.75924146152, 40853.142184844), new Vsop87.LnVsop(6.7E-10, 3.89692983127, 26084.0218062162), new Vsop87.LnVsop(6.2E-10, 5.7759594872, 12566.1516999828), new Vsop87.LnVsop(6.2E-10, 2.68303226418, 43071.8992890308), new Vsop87.LnVsop(6.8E-10, 3.44188386122, 10213.285546211), new Vsop87.LnVsop(5.9E-10, 0.86974939194, 53131.406024757), new Vsop87.LnVsop(6.1E-10, 0.16326480892, 36301.18868778519), new Vsop87.LnVsop(6.2E-10, 5.03081926384, 98690.28051714458), new Vsop87.LnVsop(6.3E-10, 2.4928393033, 78793.40038981718), new Vsop87.LnVsop(5.5E-10, 1.00982472538, 27676.976036858), new Vsop87.LnVsop(5.4E-10, 1.15894540115, 26202.34243025941), new Vsop87.LnVsop(5.2E-10, 1.55698657263, 49957.0491789616), new Vsop87.LnVsop(5.1E-10, 5.13863384999, 52156.1365222486), new Vsop87.LnVsop(5.0E-10, 1.60202945983, 25234.70675982219), new Vsop87.LnVsop(5.3E-10, 2.66625298995, 103292.23063610759), new Vsop87.LnVsop(5.2E-10, 0.53816996194, 77308.10968311399), new Vsop87.LnVsop(5.3E-10, 5.48671975064, 25661.3049506982), new Vsop87.LnVsop(4.7E-10, 5.18449121077, 48733.23133818299), new Vsop87.LnVsop(5.4E-10, 5.50628728318, 77204.32749453338), new Vsop87.LnVsop(4.5E-10, 4.98425073175, 25973.46385288896), new Vsop87.LnVsop(4.9E-10, 0.54622585936, 51646.11531805379), new Vsop87.LnVsop(5.3E-10, 0.33861329992, 25874.6040461362), new Vsop87.LnVsop(4.1E-10, 2.21595927672, 52179.6876185064), new Vsop87.LnVsop(4.1E-10, 2.78727398693, 41962.5207369374), new Vsop87.LnVsop(3.6E-10, 5.03373039765, 26080.78959457339), new Vsop87.LnVsop(3.7E-10, 5.80421105052, 68050.42387851159), new Vsop87.LnVsop(3.9E-10, 0.07497517201, 38519.945791972), new Vsop87.LnVsop(3.5E-10, 3.29702164337, 62389.09182935939), new Vsop87.LnVsop(4.3E-10, 3.24027622244, 52389.1053785864), new Vsop87.LnVsop(4.2E-10, 2.42467105416, 639.897286314), new Vsop87.LnVsop(3.7E-10, 6.10413466135, 79323.09135491178), new Vsop87.LnVsop(3.8E-10, 0.75728548339, 82815.66292178139), new Vsop87.LnVsop(3.9E-10, 5.83856275214, 31749.2351907264), new Vsop87.LnVsop(3.3E-10, 2.45594764622, 38654.05484155699), new Vsop87.LnVsop(4.0E-10, 1.13429314401, 51116.4243529592), new Vsop87.LnVsop(4.1E-10, 4.30596946224, 26095.016688575), new Vsop87.LnVsop(4.0E-10, 3.14916876711, 426.598190876), new Vsop87.LnVsop(3.9E-10, 1.79865756533, 33326.5787331742), new Vsop87.LnVsop(3.1E-10, 5.81703678643, 129380.13377768178), new Vsop87.LnVsop(3.2E-10, 3.75967831149, 136100.84775702318), new Vsop87.LnVsop(3.1E-10, 0.7157962969, 50057.04242277), new Vsop87.LnVsop(3.4E-10, 4.04941185304, 55618.3812281138), new Vsop87.LnVsop(3.0E-10, 1.5791033832, 52168.69273614759), new Vsop87.LnVsop(3.1E-10, 0.09729309307, 47623.8527860896), new Vsop87.LnVsop(2.9E-10, 3.72168845249, 51535.90899683439), new Vsop87.LnVsop(3.9E-10, 4.04661946156, 52195.47604404819), new Vsop87.LnVsop(3.8E-10, 3.74329013991, 18849.2275499742), new Vsop87.LnVsop(3.0E-10, 0.74969213513, 7880.08915333899), new Vsop87.LnVsop(2.8E-10, 1.00979692149, 155418.04029735178), new Vsop87.LnVsop(3.3E-10, 5.78833433505, 18093.37469954999), new Vsop87.LnVsop(3.3E-10, 0.72168395673, 52171.9249477904), new Vsop87.LnVsop(3.4E-10, 5.29277111978, 45405.0956819028), new Vsop87.LnVsop(2.5E-10, 5.17302047914, 99799.65906923798), new Vsop87.LnVsop(2.9E-10, 4.2787868884, 54394.56338733519), new Vsop87.LnVsop(2.3E-10, 2.91420022643, 339142.7408404646), new Vsop87.LnVsop(2.9E-10, 3.06502211848, 77734.01845962799), new Vsop87.LnVsop(2.9E-10, 1.05041966879, 52182.9198301492), new Vsop87.LnVsop(2.3E-10, 5.05463364253, 2118.7638603784), new Vsop87.LnVsop(2.5E-10, 5.79963493025, 66941.04532641819), new Vsop87.LnVsop(2.2E-10, 2.60637985278, 94138.32702008578), new Vsop87.LnVsop(2.3E-10, 2.16401194556, 73711.75592766379), new Vsop87.LnVsop(2.5E-10, 0.08404534895, 26514.5013324502), new Vsop87.LnVsop(2.1E-10, 4.437080407, 3328.13565628019), new Vsop87.LnVsop(2.0E-10, 1.08338958579, 28421.0995344462), new Vsop87.LnVsop(2.0E-10, 1.88500536861, 78244.0396638228), new Vsop87.LnVsop(2.3E-10, 1.77623772399, 124778.18365871879), new Vsop87.LnVsop(2.3E-10, 5.48177653849, 104881.30353139139), new Vsop87.LnVsop(2.1E-10, 3.97578154158, 53764.8791784322), new Vsop87.LnVsop(1.8E-10, 3.51290465186, 103396.01282468818), new Vsop87.LnVsop(1.9E-10, 1.96045370871, 23754.70674870219), new Vsop87.LnVsop(1.8E-10, 2.89112115044, 6283.0758499914), new Vsop87.LnVsop(1.6E-10, 4.59238950011, 76044.9523205358), new Vsop87.LnVsop(1.9E-10, 3.14667729625, 51109.31080595839), new Vsop87.LnVsop(1.8E-10, 5.83387936093, 32370.9789915656), new Vsop87.LnVsop(1.6E-10, 0.09294518979, 88476.99497093359), new Vsop87.LnVsop(1.5E-10, 5.46245475561, 64741.95798313119), new Vsop87.LnVsop(1.6E-10, 0.03607120436, 15874.6175953632), new Vsop87.LnVsop(1.6E-10, 2.61537304697, 51123.53789995999), new Vsop87.LnVsop(1.7E-10, 5.25094113087, 78267.59076008058), new Vsop87.LnVsop(1.4E-10, 2.6086827559, 155468.036919256), new Vsop87.LnVsop(1.9E-10, 4.41133632855, 1223.81784077861), new Vsop87.LnVsop(1.4E-10, 1.94550512688, 125887.56221081219), new Vsop87.LnVsop(1.4E-10, 4.09356954849, 51962.5071877104), new Vsop87.LnVsop(1.3E-10, 1.69184734385, 105460.99111839019), new Vsop87.LnVsop(1.3E-10, 0.42992478235, 91785.46086631398), new Vsop87.LnVsop(1.4E-10, 4.22260830493, 52290.24557183361), new Vsop87.LnVsop(1.4E-10, 0.84325677092, 78283.37918562238), new Vsop87.LnVsop(1.5E-10, 3.81728490126, 33967.99229491319), new Vsop87.LnVsop(1.5E-10, 6.08137402799, 13655.8604911764), new Vsop87.LnVsop(1.6E-10, 5.91267910196, 103821.92160120218), new Vsop87.LnVsop(1.2E-10, 4.62244083876, 78256.59587772179), new Vsop87.LnVsop(1.3E-10, 4.111849901, 78270.82297172339), new Vsop87.LnVsop(1.3E-10, 0.51159953038, 162188.75089859738), new Vsop87.LnVsop(1.6E-10, 0.27438111404, 44937.1306915484), new Vsop87.LnVsop(1.5E-10, 0.06283579474, 78477.00852016058), new Vsop87.LnVsop(1.2E-10, 3.74786317614, 79219.3091663312), new Vsop87.LnVsop(1.4E-10, 3.73252208342, 76674.63652943878), new Vsop87.LnVsop(1.3E-10, 2.85873269026, 105410.99449648599), new Vsop87.LnVsop(1.1E-10, 3.31652116583, 52602.4044740244), new Vsop87.LnVsop(1.1E-10, 0.85286372231, 81706.28436968799), new Vsop87.LnVsop(1.4E-10, 3.804034887, 108903.56606335558), new Vsop87.LnVsop(1.0E-10, 1.28396028602, 29416.03879785439), new Vsop87.LnVsop(1.0E-10, 5.65745629948, 120226.23016165999), new Vsop87.LnVsop(1.2E-10, 2.03863313977, 71492.99882347698), new Vsop87.LnVsop(1.2E-10, 3.78051451699, 78259.82808936459), new Vsop87.LnVsop(1.2E-10, 3.58068127033, 65697.55772473979), new Vsop87.LnVsop(9.0E-11, 6.26481642814, 77197.21394753258), new Vsop87.LnVsop(1.0E-10, 1.74557548628, 52061.36699446317), new Vsop87.LnVsop(1.1E-10, 5.51854977063, 26727.8004278882), new Vsop87.LnVsop(9.0E-11, 0.87609670035, 71980.63357473118), new Vsop87.LnVsop(1.2E-10, 2.78603563772, 636.9962720242), new Vsop87.LnVsop(1.1E-10, 2.55599225548, 44181.27784112419), new Vsop87.LnVsop(8.0E-11, 3.96918329614, 181505.94343892598), new Vsop87.LnVsop(1.0E-10, 4.03307160926, 45892.73043315699), new Vsop87.LnVsop(8.0E-11, 0.26156604139, 58946.51688439399), new Vsop87.LnVsop(8.0E-11, 3.43030220559, 23439.44831610119), new Vsop87.LnVsop(7.0E-11, 2.31338515724, 18207.81398823521), new Vsop87.LnVsop(7.0E-11, 2.30432003862, 58458.88213313979), new Vsop87.LnVsop(7.0E-11, 3.5531222472, 117873.36400788819), new Vsop87.LnVsop(9.0E-11, 5.71593232265, 77211.44104153418), new Vsop87.LnVsop(7.0E-11, 4.76096150126, 51322.60990139639), new Vsop87.LnVsop(8.0E-11, 2.48388995708, 93028.94846799239), new Vsop87.LnVsop(7.0E-11, 4.09761336373, 39609.6545831656), new Vsop87.LnVsop(7.0E-11, 5.75283699646, 365230.6439820388), new Vsop87.LnVsop(6.0E-11, 3.99273743908, 59414.4818747484), new Vsop87.LnVsop(7.0E-11, 1.6937382208, 28206.6670019526), new Vsop87.LnVsop(6.0E-11, 3.28204561721, 64607.84893354619), new Vsop87.LnVsop(6.0E-11, 1.54444675453, 853.196381752), new Vsop87.LnVsop(8.0E-11, 0.57761210288, 60055.89543648739), new Vsop87.LnVsop(6.0E-11, 5.01805475025, 151975.46535238638), new Vsop87.LnVsop(6.0E-11, 2.55446300163, 69159.80243060499), new Vsop87.LnVsop(5.0E-11, 1.51210885797, 9103.9069941176), new Vsop87.LnVsop(6.0E-11, 4.89525469227, 104331.94280539699), new Vsop87.LnVsop(6.0E-11, 4.92564085258, 22759.76748529401), new Vsop87.LnVsop(5.0E-11, 2.15346448287, 90829.86112470538), new Vsop87.LnVsop(6.0E-11, 0.65350116108, 79852.78232000639), new Vsop87.LnVsop(5.0E-11, 3.37193629625, 76144.94556434419), new Vsop87.LnVsop(5.0E-11, 2.04815817656, 74821.13447975718), new Vsop87.LnVsop(5.0E-11, 0.17834300374, 129483.91596626239), new Vsop87.LnVsop(5.0E-11, 6.16414846947, 90695.75207512038), new Vsop87.LnVsop(5.0E-11, 5.28415472245, 3340.6124266998), new Vsop87.LnVsop(5.0E-11, 3.17894500374, 13541.42120249119), new Vsop87.LnVsop(5.0E-11, 5.69793800429, 181555.94006083018), new Vsop87.LnVsop(6.0E-11, 2.66476961863, 129909.82474277639), new Vsop87.LnVsop(5.0E-11, 5.74228939026, 51742.09454527159), new Vsop87.LnVsop(5.0E-11, 4.26343733232, 54509.0026760204), new Vsop87.LnVsop(4.0E-11, 4.06123952598, 98068.53671630539), new Vsop87.LnVsop(6.0E-11, 4.74202735513, 150866.08680029298), new Vsop87.LnVsop(4.0E-11, 3.22245789732, 85034.42002596818), new Vsop87.LnVsop(6.0E-11, 2.16211417117, 130969.20667296558), new Vsop87.LnVsop(5.0E-11, 1.17994620591, 27311.72098235281), new Vsop87.LnVsop(4.0E-11, 3.13862707016, 114564.89811250778), new Vsop87.LnVsop(4.0E-11, 0.70841826293, 207593.8465805002), new Vsop87.LnVsop(4.0E-11, 2.34774987498, 103925.01437542078), new Vsop87.LnVsop(5.0E-11, 0.77949940918, 80482.46652890938), new Vsop87.LnVsop(4.0E-11, 2.88313720641, 39743.7636327506), new Vsop87.LnVsop(5.0E-11, 3.52886643334, 188276.6540401716), new Vsop87.LnVsop(4.0E-11, 0.28788817018, 143961.2671494624), new Vsop87.LnVsop(4.0E-11, 4.49043760994, 157636.79740153858), new Vsop87.LnVsop(4.0E-11, 4.21873573827, 209812.60368468694), new Vsop87.LnVsop(4.0E-11, 2.41403274829, 146314.13330323418), new Vsop87.LnVsop(5.0E-11, 1.28701603504, 78050.41032928458), new Vsop87.LnVsop(4.0E-11, 5.65308073974, 9384.8410080752), new Vsop87.LnVsop(4.0E-11, 2.64375080194, 391318.54712361295), new Vsop87.LnVsop(3.0E-11, 3.98926197489, 26555.8681319286), new Vsop87.LnVsop(4.0E-11, 0.55808934316, 134991.4692049298), new Vsop87.LnVsop(4.0E-11, 4.63875050061, 104138.31347085879), new Vsop87.LnVsop(4.0E-11, 5.06700980379, 51749.20809227239), new Vsop87.LnVsop(4.0E-11, 3.15594088685, 104564.91166173479), new Vsop87.LnVsop(3.0E-11, 5.53916777863, 103917.90082841998), new Vsop87.LnVsop(3.0E-11, 3.83058994037, 107794.1875112622), new Vsop87.LnVsop(4.0E-11, 5.62157545863, 155997.72788435058), new Vsop87.LnVsop(3.0E-11, 4.96842214526, 46848.3301747656), new Vsop87.LnVsop(3.0E-11, 1.31101001889, 102132.85546210999), new Vsop87.LnVsop(4.0E-11, 3.23824792927, 71025.0338331226), new Vsop87.LnVsop(3.0E-11, 0.56485784658, 133882.09065283637), new Vsop87.LnVsop(3.0E-11, 5.99223512848, 76681.75007643958), new Vsop87.LnVsop(3.0E-11, 2.53782771703, 77829.99768684579), new Vsop87.LnVsop(3.0E-11, 5.43159187626, 26624.70765366959), new Vsop87.LnVsop(4.0E-11, 1.90489089366, 77844.22478084739), new Vsop87.LnVsop(4.0E-11, 6.20678215413, 140652.80125408198), new Vsop87.LnVsop(3.0E-11, 5.70654241974, 70269.18098269838), new Vsop87.LnVsop(3.0E-11, 1.75060320928, 178063.3684939606), new Vsop87.LnVsop(3.0E-11, 0.8306549835, 16066.0658614748), new Vsop87.LnVsop(4.0E-11, 2.57176066723, 103299.34418310839), new Vsop87.LnVsop(3.0E-11, 1.14659714282, 183724.7005431128), new Vsop87.LnVsop(3.0E-11, 5.14785501146, 51756.3216392732), new Vsop87.LnVsop(3.0E-11, 2.57903197263, 102769.65321801379), new Vsop87.LnVsop(3.0E-11, 3.76793354375, 233681.74972207437), new Vsop87.LnVsop(4.0E-11, 0.24142818439, 214364.55718174577), new Vsop87.LnVsop(3.0E-11, 2.82633220723, 78417.48823520739), new Vsop87.LnVsop(3.0E-11, 1.50791196104, 176953.98994186718), new Vsop87.LnVsop(3.0E-11, 0.75025191061, 124156.43985787958), new Vsop87.LnVsop(3.0E-11, 0.11585083927, 78690.30761559859), new Vsop87.LnVsop(4.0E-11, 1.63233334725, 48847.6706268682), new Vsop87.LnVsop(3.0E-11, 0.91669674969, 104358.72611329758), new Vsop87.LnVsop(3.0E-11, 4.73790735448, 204151.27163553477), new Vsop87.LnVsop(4.0E-11, 5.2835128562, 77837.11123384659), new Vsop87.LnVsop(3.0E-11, 5.18374032893, 84546.78527471398), new Vsop87.LnVsop(3.0E-11, 5.43488671242, 172402.0364448084), new Vsop87.LnVsop(3.0E-11, 3.09682427852, 103285.11708910679), new Vsop87.LnVsop(3.0E-11, 2.63284986442, 157586.80077963436), new Vsop87.LnVsop(4.0E-11, 2.00317069167, 104355.49390165479), new Vsop87.LnVsop(3.0E-11, 2.90251399696, 26241.681952059), new Vsop87.LnVsop(3.0E-11, 5.12222648436, 49842.60989027639), new Vsop87.LnVsop(3.0E-11, 0.06488467746, 128850.44281258718), new Vsop87.LnVsop(3.0E-11, 0.33684256012, 26521.614879451), new Vsop87.LnVsop(3.0E-11, 1.51588259549, 130226.21661243298), new Vsop87.LnVsop(3.0E-11, 3.67637303983, 78731.674415077), new Vsop87.LnVsop(3.0E-11, 2.28131524438, 145204.75475114078), new Vsop87.LnVsop(3.0E-11, 5.33066683612, 130012.91751699499), new Vsop87.LnVsop(3.0E-11, 3.1748162202, 155571.81910783658), new Vsop87.LnVsop(3.0E-11, 5.98255863935, 129373.02023068098), new Vsop87.LnVsop(3.0E-11, 5.18830885909, 157057.10981453978), new Vsop87.LnVsop(3.0E-11, 2.11070427503, 26037.90651966999), new Vsop87.LnVsop(4.0E-11, 5.9063462778, 131498.89763806018), new Vsop87.LnVsop(3.0E-11, 3.25172738866, 77726.90491262719), new Vsop87.LnVsop(3.0E-11, 6.06137411612, 25035.6347583858), new Vsop87.LnVsop(3.0E-11, 2.38439906684, 52815.7035694624), new Vsop87.LnVsop(3.0E-11, 5.77780259515, 417406.4502651872), new Vsop87.LnVsop(3.0E-11, 0.15017953018, 77623.81213840858), new Vsop87.LnVsop(3.0E-11, 2.53692197918, 50579.61984086379), new Vsop87.LnVsop(3.0E-11, 3.79850964717, 104371.28232719658), new Vsop87.LnVsop(3.0E-11, 0.87877269577, 78378.1487134078), new Vsop87.LnVsop(3.0E-11, 4.51815882357, 203041.8930834414), new Vsop87.LnVsop(3.0E-11, 5.05030622136, 97580.90196505119), new Vsop87.LnVsop(3.0E-11, 3.55526005414, 161079.37234650398), new Vsop87.LnVsop(3.0E-11, 3.81129932602, 150244.3429994538), new Vsop87.LnVsop(3.0E-11, 4.34998476289, 128220.75860368418), new Vsop87.LnVsop(3.0E-11, 4.99282876183, 130443.39704322898), new Vsop87.LnVsop(3.0E-11, 6.00078316095, 52329.58509363319), new Vsop87.LnVsop(2.0E-11, 2.32406988994, 182085.63102592478), new Vsop87.LnVsop(3.0E-11, 1.60886376627, 130419.8459469712), new Vsop87.LnVsop(3.0E-11, 3.55274488009, 86143.79857806159), new Vsop87.LnVsop(3.0E-11, 6.17525348034, 25021.4076643842), new Vsop87.LnVsop(2.0E-11, 5.36948228729, 52125.80966124419), new Vsop87.LnVsop(3.0E-11, 0.38599144893, 51639.00177105299), new Vsop87.LnVsop(2.0E-11, 1.40074676993, 104344.49901929598), new Vsop87.LnVsop(2.0E-11, 0.51392978593, 63498.47038145279), new Vsop87.LnVsop(2.0E-11, 2.78225137127, 50593.84693486539), new Vsop87.LnVsop(2.0E-11, 1.64621651211, 72936.23331633979), new Vsop87.LnVsop(3.0E-11, 5.96023706521, 19804.8272915828), new Vsop87.LnVsop(2.0E-11, 1.34569479881, 131548.89425996438), new Vsop87.LnVsop(2.0E-11, 4.53808407131, 52595.29092702359), new Vsop87.LnVsop(2.0E-11, 1.80494920501, 110634.68841628819), new Vsop87.LnVsop(2.0E-11, 2.69270456478, 79330.20490191258), new Vsop87.LnVsop(2.0E-11, 0.70786002104, 52643.7712735028), new Vsop87.LnVsop(2.0E-11, 5.42134269606, 102232.84870591838), new Vsop87.LnVsop(3.0E-11, 4.62281494277, 26941.0995233262), new Vsop87.LnVsop(2.0E-11, 3.87566264385, 130446.62925487179), new Vsop87.LnVsop(2.0E-11, 0.50212033869, 130459.18546877075), new Vsop87.LnVsop(2.0E-11, 3.32954668287, 170049.1702910366), new Vsop87.LnVsop(2.0E-11, 3.32826941964, 52609.51802102519), new Vsop87.LnVsop(2.0E-11, 1.81888146102, 123668.80510662538), new Vsop87.LnVsop(2.0E-11, 1.88539548859, 183145.012956114), new Vsop87.LnVsop(2.0E-11, 5.60036800049, 76667.52298243798), new Vsop87.LnVsop(2.0E-11, 2.3800483427, 207643.8432024044), new Vsop87.LnVsop(3.0E-11, 5.59960600075, 119116.85160956658), new Vsop87.LnVsop(2.0E-11, 0.66616627126, 7994.5284420242), new Vsop87.LnVsop(2.0E-11, 6.13884922945, 97112.93697469679), new Vsop87.LnVsop(2.0E-11, 6.1519476277, 130652.81480330898), new Vsop87.LnVsop(2.0E-11, 3.41632104466, 26237.46633870879), new Vsop87.LnVsop(2.0E-11, 3.37420001521, 89586.37352302698), new Vsop87.LnVsop(3.0E-11, 6.22021545847, 51543.0225438352), new Vsop87.LnVsop(2.0E-11, 4.70019386461, 54294.57014352679), new Vsop87.LnVsop(2.0E-11, 3.55423380171, 26610.48055966799), new Vsop87.LnVsop(2.0E-11, 2.08199940627, 156100.82065856917), new Vsop87.LnVsop(2.0E-11, 1.89771335613, 78213.71280281838), new Vsop87.LnVsop(2.0E-11, 2.38063752275, 157483.01859105378), new Vsop87.LnVsop(2.0E-11, 0.60609897326, 104347.73123093879), new Vsop87.LnVsop(2.0E-11, 3.06733001438, 27154.3986187642), new Vsop87.LnVsop(2.0E-11, 4.30652780573, 55503.94193942859), new Vsop87.LnVsop(2.0E-11, 3.61289373324, 105940.68546158058), new Vsop87.LnVsop(2.0E-11, 1.33899945209, 80382.47328510099), new Vsop87.LnVsop(2.0E-11, 4.35432942939, 130432.40216087017), new Vsop87.LnVsop(2.0E-11, 5.52246085185, 129387.24732468258), new Vsop87.LnVsop(2.0E-11, 3.93624681676, 104466.051854982), new Vsop87.LnVsop(2.0E-11, 1.6612084995, 77410.51304297059), new Vsop87.LnVsop(2.0E-11, 2.83496672989, 154938.34595416137), new Vsop87.LnVsop(2.0E-11, 3.23031513148, 104778.21075717278), new Vsop87.LnVsop(2.0E-11, 1.99889615003, 52712.61079524379), new Vsop87.LnVsop(2.0E-11, 4.87996577249, 103932.12792242158), new Vsop87.LnVsop(2.0E-11, 2.17758238884, 104991.50985261079), new Vsop87.LnVsop(2.0E-11, 4.5920710534, 156507.7490885454), new Vsop87.LnVsop(2.0E-11, 3.45973208971, 130435.63437251298), new Vsop87.LnVsop(2.0E-11, 1.36100413352, 103711.71527998279), new Vsop87.LnVsop(2.0E-11, 5.69915132155, 95247.70557217918), new Vsop87.LnVsop(2.0E-11, 2.14140115476, 198489.9395863826), new Vsop87.LnVsop(2.0E-11, 2.54868088019, 443494.3534067613), new Vsop87.LnVsop(2.0E-11, 4.27290052093, 99024.13645791399), new Vsop87.LnVsop(2.0E-11, 5.27508077587, 116917.76426627958), new Vsop87.LnVsop(2.0E-11, 0.58370421848, 156534.53239644598), new Vsop87.LnVsop(2.0E-11, 5.06923503966, 44295.7171298094), new Vsop87.LnVsop(2.0E-11, 2.89478714851, 166740.70439565618), new Vsop87.LnVsop(2.0E-11, 3.4637428692, 68241.8721446232), new Vsop87.LnVsop(1.0E-11, 2.56009054796, 91919.56991589899), new Vsop87.LnVsop(2.0E-11, 5.33102101065, 233731.7463439786), new Vsop87.LnVsop(1.0E-11, 0.46871348267, 52698.38370124219), new Vsop87.LnVsop(2.0E-11, 0.23345180862, 53228.07466633679), new Vsop87.LnVsop(1.0E-11, 1.21219589371, 229129.79622501557), new Vsop87.LnVsop(2.0E-11, 1.47208764937, 104237.17327761157), new Vsop87.LnVsop(1.0E-11, 0.46249615021, 259769.65286364855), new Vsop87.LnVsop(1.0E-11, 3.55153457062, 156547.08861034497), new Vsop87.LnVsop(2.0E-11, 3.25214023282, 79315.97780791098), new Vsop87.LnVsop(1.0E-11, 2.91709276484, 156740.7179448832), new Vsop87.LnVsop(2.0E-11, 2.16887025342, 25881.717593137), new Vsop87.LnVsop(2.0E-11, 5.43830783518, 35191.8101356918), new Vsop87.LnVsop(2.0E-11, 0.32055505807, 26294.08869001139), new Vsop87.LnVsop(2.0E-11, 1.3242129895, 230239.17477710897), new Vsop87.LnVsop(1.0E-11, 2.75656573698, 123200.84011627098), new Vsop87.LnVsop(1.0E-11, 1.05519423362, 154308.6617452584), new Vsop87.LnVsop(1.0E-11, 2.22706049163, 155475.15046625677), new Vsop87.LnVsop(1.0E-11, 1.21096629701, 26507.38778544939), new Vsop87.LnVsop(1.0E-11, 4.95426332586, 78800.51393681798), new Vsop87.LnVsop(2.0E-11, 1.36857099558, 53029.0026649004), new Vsop87.LnVsop(1.0E-11, 5.86456165793, 26724.8994135984), new Vsop87.LnVsop(2.0E-11, 5.28892226268, 131395.11544947958), new Vsop87.LnVsop(1.0E-11, 4.7921677865, 149756.7082481996), new Vsop87.LnVsop(1.0E-11, 3.20732407966, 137678.191299471), new Vsop87.LnVsop(1.0E-11, 2.96638995325, 78786.28684281638), new Vsop87.LnVsop(1.0E-11, 4.91638002448, 24864.08530079559), new Vsop87.LnVsop(1.0E-11, 6.1491067968, 53242.3017603384), new Vsop87.LnVsop(1.0E-11, 6.14706636431, 181659.72224941078), new Vsop87.LnVsop(1.0E-11, 5.29736708948, 171292.65789271498), new Vsop87.LnVsop(1.0E-11, 5.77778470867, 65831.6667743248), new Vsop87.LnVsop(1.0E-11, 1.66692640402, 156531.3001848032), new Vsop87.LnVsop(1.0E-11, 4.19906782881, 53399.624123927), new Vsop87.LnVsop(1.0E-11, 3.61349005003, 25551.09862947879), new Vsop87.LnVsop(1.0E-11, 4.94658254745, 182188.72380014337), new Vsop87.LnVsop(1.0E-11, 4.73509857811, 78149.27013603736), new Vsop87.LnVsop(1.0E-11, 0.21694564359, 156523.5375140872), new Vsop87.LnVsop(1.0E-11, 2.70464721604, 155460.9233722552), new Vsop87.LnVsop(1.0E-11, 6.01917565203, 87367.61641884019), new Vsop87.LnVsop(1.0E-11, 0.58964848166, 25934.1243310894), new Vsop87.LnVsop(1.0E-11, 0.69637868067, 419.4846438752), new Vsop87.LnVsop(1.0E-11, 1.58879127003, 105307.21230790539), new Vsop87.LnVsop(1.0E-11, 2.21200704215, 29428.515568274), new Vsop87.LnVsop(1.0E-11, 1.8855510114, 143005.6674078538), new Vsop87.LnVsop(1.0E-11, 5.87073148723, 7.1135470008), new Vsop87.LnVsop(1.0E-11, 0.98630669719, 80596.9058175946), new Vsop87.LnVsop(1.0E-11, 0.32313752445, 111590.2881578968), new Vsop87.LnVsop(1.0E-11, 3.57120770556, 27684.0895838588), new Vsop87.LnVsop(1.0E-11, 5.31615183025, 25619.9381512198), new Vsop87.LnVsop(1.0E-11, 4.9673702492, 100909.03762133139), new Vsop87.LnVsop(1.0E-11, 1.98399612179, 70383.6202713836), new Vsop87.LnVsop(1.0E-11, 5.76820474986, 181026.24909573558), new Vsop87.LnVsop(1.0E-11, 2.17985292285, 106570.36967048359), new Vsop87.LnVsop(1.0E-11, 0.33589246093, 51528.79544983359), new Vsop87.LnVsop(1.0E-11, 2.30304143694, 102755.42612401219), new Vsop87.LnVsop(1.0E-11, 2.60522245307, 632.7837393132), new Vsop87.LnVsop(1.0E-11, 2.12902252288, 85502.38501632259), new Vsop87.LnVsop(1.0E-11, 5.48182021001, 78903.60671103658), new Vsop87.LnVsop(1.0E-11, 5.81614944128, 19.66976089979), new Vsop87.LnVsop(1.0E-11, 0.28057913034, 25450.90686955), new Vsop87.LnVsop(1.0E-11, 0.23368034121, 187167.2754880782), new Vsop87.LnVsop(1.0E-11, 5.2768792224, 183570.921732628), new Vsop87.LnVsop(1.0E-11, 0.55131065335, 26137.8997634784), new Vsop87.LnVsop(1.0E-11, 6.11149192748, 196137.07343261078), new Vsop87.LnVsop(1.0E-11, 5.21786187975, 36109.7404216736), new Vsop87.LnVsop(1.0E-11, 5.69487692949, 25565.3257234804), new Vsop87.LnVsop(1.0E-11, 0.66528112216, 42153.969003049), new Vsop87.LnVsop(1.0E-11, 1.31014433957, 128320.75184749259), new Vsop87.LnVsop(1.0E-11, 0.30267346719, 132028.58860315479), new Vsop87.LnVsop(1.0E-11, 5.29138018584, 208173.534167499), new Vsop87.LnVsop(1.0E-11, 5.56586628815, 183674.70392120857)};
        private static Vsop87.LnVsop[] mercury_longitude_l3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.69496E-6, 3.20221586818, 26087.9031415742), new Vsop87.LnVsop(1.55725E-6, 6.23814315369, 52175.8062831484), new Vsop87.LnVsop(9.0555E-7, 2.96712953186, 78263.70942472259), new Vsop87.LnVsop(4.2769E-7, 6.01870391709, 104351.61256629678), new Vsop87.LnVsop(1.776E-7, 2.78750960026, 130439.51570787099), new Vsop87.LnVsop(6.774E-8, 5.82756176337, 156527.41884944518), new Vsop87.LnVsop(3.486E-8, 0.0, 0.0), new Vsop87.LnVsop(2.435E-8, 2.56963684564, 182615.3219910194), new Vsop87.LnVsop(8.38E-9, 5.58026725886, 208703.2251325936), new Vsop87.LnVsop(2.79E-9, 2.29386373858, 234791.12827416777), new Vsop87.LnVsop(1.17E-9, 3.16711243445, 24978.5245894808), new Vsop87.LnVsop(9.1E-10, 5.27797094839, 260879.03141574195), new Vsop87.LnVsop(7.7E-10, 6.2411894888, 51066.427731055), new Vsop87.LnVsop(5.9E-10, 6.13122855286, 27197.2816936676), new Vsop87.LnVsop(2.9E-10, 1.96984426125, 286966.9345573162), new Vsop87.LnVsop(3.8E-10, 3.01313871348, 77154.33087262919), new Vsop87.LnVsop(2.6E-10, 3.07099212705, 53285.1848352418), new Vsop87.LnVsop(1.6E-10, 6.05402853609, 103242.2340142034), new Vsop87.LnVsop(9.0E-11, 0.5876140528, 20426.571092422), new Vsop87.LnVsop(8.0E-11, 4.91858279103, 313054.83769889036), new Vsop87.LnVsop(8.0E-11, 3.65754213465, 46514.4742339962), new Vsop87.LnVsop(7.0E-11, 5.80852764666, 25132.3033999656), new Vsop87.LnVsop(6.0E-11, 2.80645454084, 129330.13715577759), new Vsop87.LnVsop(5.0E-11, 0.42790495669, 72602.37737557039), new Vsop87.LnVsop(5.0E-11, 1.3801389981, 26617.5941066688), new Vsop87.LnVsop(6.0E-11, 6.21321941701, 79373.087976816), new Vsop87.LnVsop(4.0E-11, 2.57269000597, 51220.20654153979), new Vsop87.LnVsop(4.0E-11, 4.3514618328, 52705.49724824299), new Vsop87.LnVsop(4.0E-11, 3.23908636136, 23869.1460373874), new Vsop87.LnVsop(4.0E-11, 3.11816146331, 27043.5028831828), new Vsop87.LnVsop(3.0E-11, 5.65361012794, 30639.856638633), new Vsop87.LnVsop(3.0E-11, 6.24088426744, 50586.73338786459), new Vsop87.LnVsop(3.0E-11, 4.71793214076, 27147.28507176339), new Vsop87.LnVsop(3.0E-11, 1.56503904911, 339142.7408404646), new Vsop87.LnVsop(3.0E-11, 4.40817083916, 14765.2390432698), new Vsop87.LnVsop(3.0E-11, 1.36263896645, 53235.18821333759), new Vsop87.LnVsop(3.0E-11, 2.55349503543, 56727.7597802072), new Vsop87.LnVsop(2.0E-11, 1.57411546608, 25558.2121764796), new Vsop87.LnVsop(2.0E-11, 5.82296227978, 155418.04029735178), new Vsop87.LnVsop(3.0E-11, 6.04743500801, 28306.66024576099), new Vsop87.LnVsop(2.0E-11, 3.56825195678, 78267.59076008058), new Vsop87.LnVsop(2.0E-11, 0.67646904345, 19317.1925403286), new Vsop87.LnVsop(2.0E-11, 0.80653697687, 155468.036919256), new Vsop87.LnVsop(2.0E-11, 2.56516361004, 181505.94343892598), new Vsop87.LnVsop(2.0E-11, 0.04355188842, 49957.0491789616), new Vsop87.LnVsop(2.0E-11, 5.46649056139, 110012.94461544899), new Vsop87.LnVsop(2.0E-11, 4.44350451862, 79323.09135491178), new Vsop87.LnVsop(2.0E-11, 2.8076953103, 83925.0414738748), new Vsop87.LnVsop(2.0E-11, 0.87954898432, 103292.23063610759), new Vsop87.LnVsop(2.0E-11, 2.87146263097, 54394.56338733519), new Vsop87.LnVsop(2.0E-11, 4.72727579494, 365230.6439820388), new Vsop87.LnVsop(2.0E-11, 3.49243086623, 98690.28051714458), new Vsop87.LnVsop(2.0E-11, 0.13491885197, 57837.1383323006), new Vsop87.LnVsop(1.0E-11, 5.93623181057, 4551.9534970588), new Vsop87.LnVsop(1.0E-11, 0.68876175865, 51116.4243529592), new Vsop87.LnVsop(1.0E-11, 2.22622522074, 136100.84775702318), new Vsop87.LnVsop(2.0E-11, 2.0295086759, 78259.82808936459), new Vsop87.LnVsop(2.0E-11, 2.7624413066, 79219.3091663312), new Vsop87.LnVsop(2.0E-11, 1.75174914928, 77734.01845962799), new Vsop87.LnVsop(2.0E-11, 5.53512457012, 82815.66292178139), new Vsop87.LnVsop(1.0E-11, 5.85249550691, 80482.46652890938), new Vsop87.LnVsop(1.0E-11, 3.81987601159, 181555.94006083018), new Vsop87.LnVsop(2.0E-11, 4.40970001516, 103821.92160120218), new Vsop87.LnVsop(1.0E-11, 5.22138031517, 162188.75089859738), new Vsop87.LnVsop(1.0E-11, 3.73642972825, 77204.32749453338), new Vsop87.LnVsop(2.0E-11, 0.49707359743, 71492.99882347698), new Vsop87.LnVsop(1.0E-11, 1.3866065995, 40853.142184844), new Vsop87.LnVsop(1.0E-11, 2.95221907246, 76674.63652943878), new Vsop87.LnVsop(2.0E-11, 1.29222474765, 105410.99449648599), new Vsop87.LnVsop(2.0E-11, 2.25962890984, 108903.56606335558), new Vsop87.LnVsop(2.0E-11, 1.16550489633, 78793.40038981718), new Vsop87.LnVsop(1.0E-11, 0.36415945149, 125887.56221081219), new Vsop87.LnVsop(2.0E-11, 4.08854513089, 104881.30353139139), new Vsop87.LnVsop(1.0E-11, 3.08110954685, 76044.9523205358), new Vsop87.LnVsop(1.0E-11, 3.03258348439, 78256.59587772179), new Vsop87.LnVsop(1.0E-11, 3.77632466126, 64741.95798313119), new Vsop87.LnVsop(2.0E-11, 3.64167234446, 45405.0956819028), new Vsop87.LnVsop(1.0E-11, 4.69654806259, 88476.99497093359), new Vsop87.LnVsop(1.0E-11, 2.51395607415, 55618.3812281138), new Vsop87.LnVsop(1.0E-11, 1.62785445812, 52389.1053785864), new Vsop87.LnVsop(1.0E-11, 1.72317308732, 62389.09182935939), new Vsop87.LnVsop(1.0E-11, 0.02541044713, 52168.69273614759), new Vsop87.LnVsop(1.0E-11, 5.45367779477, 77308.10968311399), new Vsop87.LnVsop(1.0E-11, 4.37214899281, 26301.2022370122), new Vsop87.LnVsop(1.0E-11, 2.06676015946, 103396.01282468818), new Vsop87.LnVsop(2.0E-11, 1.72366900008, 63498.47038145279), new Vsop87.LnVsop(1.0E-11, 4.26409824775, 68050.42387851159), new Vsop87.LnVsop(1.0E-11, 1.1338494957, 73711.75592766379), new Vsop87.LnVsop(1.0E-11, 2.59146532084, 52290.24557183361), new Vsop87.LnVsop(1.0E-11, 0.57771259518, 52179.6876185064), new Vsop87.LnVsop(1.0E-11, 6.05911204257, 102132.85546210999), new Vsop87.LnVsop(2.0E-11, 5.08007258698, 51646.11531805379), new Vsop87.LnVsop(1.0E-11, 0.8950633111, 43071.8992890308), new Vsop87.LnVsop(1.0E-11, 2.32962526981, 32858.61374281979), new Vsop87.LnVsop(1.0E-11, 5.3363985592, 78283.37918562238), new Vsop87.LnVsop(1.0E-11, 0.21578309169, 124778.18365871879), new Vsop87.LnVsop(1.0E-11, 0.97190581639, 94138.32702008578), new Vsop87.LnVsop(1.0E-11, 3.63988900749, 99799.65906923798), new Vsop87.LnVsop(1.0E-11, 0.3109287703, 78244.0396638228), new Vsop87.LnVsop(1.0E-11, 0.88240174201, 38654.05484155699), new Vsop87.LnVsop(1.0E-11, 5.51352755464, 81706.28436968799), new Vsop87.LnVsop(1.0E-11, 4.29818815666, 25874.6040461362), new Vsop87.LnVsop(1.0E-11, 3.25355593666, 150866.08680029298), new Vsop87.LnVsop(1.0E-11, 5.83277482201, 26202.34243025941), new Vsop87.LnVsop(1.0E-11, 5.5640064274, 50057.04242277), new Vsop87.LnVsop(1.0E-11, 4.10855423897, 129380.13377768178), new Vsop87.LnVsop(1.0E-11, 3.530262141, 52156.1365222486), new Vsop87.LnVsop(1.0E-11, 4.62648721501, 78477.00852016058), new Vsop87.LnVsop(1.0E-11, 4.93260671151, 37410.5672398786), new Vsop87.LnVsop(1.0E-11, 6.23775561663, 53131.406024757), new Vsop87.LnVsop(1.0E-11, 4.2846862571, 66941.04532641819), new Vsop87.LnVsop(1.0E-11, 2.44665953571, 52195.47604404819), new Vsop87.LnVsop(1.0E-11, 5.0573021441, 129483.91596626239), new Vsop87.LnVsop(1.0E-11, 3.01159658549, 105460.99111839019), new Vsop87.LnVsop(1.0E-11, 5.36784540343, 26107.57290247399), new Vsop87.LnVsop(1.0E-11, 3.37141132304, 48733.23133818299), new Vsop87.LnVsop(1.0E-11, 2.2965792002, 51535.90899683439), new Vsop87.LnVsop(1.0E-11, 5.38152228973, 52171.9249477904), new Vsop87.LnVsop(1.0E-11, 4.95743222375, 35191.8101356918), new Vsop87.LnVsop(1.0E-11, 0.72632545829, 130969.20667296558), new Vsop87.LnVsop(1.0E-11, 5.86529301658, 102762.53967101299), new Vsop87.LnVsop(1.0E-11, 2.57174065725, 26095.016688575), new Vsop87.LnVsop(1.0E-11, 1.32180905788, 391318.54712361295), new Vsop87.LnVsop(1.0E-11, 3.24565029816, 26080.78959457339), new Vsop87.LnVsop(1.0E-11, 4.9979838811, 36301.18868778519), new Vsop87.LnVsop(1.0E-11, 3.27865480193, 2118.7638603784), new Vsop87.LnVsop(1.0E-11, 2.32578126782, 78270.82297172339), new Vsop87.LnVsop(1.0E-11, 2.58055096142, 53764.8791784322), new Vsop87.LnVsop(1.0E-11, 5.70846453783, 58946.51688439399), new Vsop87.LnVsop(1.0E-11, 0.94894417845, 93028.94846799239), new Vsop87.LnVsop(1.0E-11, 1.66220417885, 52602.4044740244), new Vsop87.LnVsop(1.0E-11, 4.4444905623, 417406.4502651872), new Vsop87.LnVsop(1.0E-11, 6.15060120914, 27676.976036858), new Vsop87.LnVsop(1.0E-11, 0.21740755726, 52061.36699446317), new Vsop87.LnVsop(1.0E-11, 4.14022222533, 25028.521211385), new Vsop87.LnVsop(1.0E-11, 5.30484938123, 79852.78232000639), new Vsop87.LnVsop(1.0E-11, 0.3549953646, 90829.86112470538), new Vsop87.LnVsop(1.0E-11, 5.28585833455, 29530.4780865396), new Vsop87.LnVsop(1.0E-11, 1.83471944738, 188276.6540401716), new Vsop87.LnVsop(1.0E-11, 3.40823920724, 25973.46385288896), new Vsop87.LnVsop(1.0E-11, 2.06905416268, 104371.28232719658), new Vsop87.LnVsop(1.0E-11, 0.22297971328, 104355.49390165479), new Vsop87.LnVsop(1.0E-11, 2.52348712557, 106570.36967048359), new Vsop87.LnVsop(1.0E-11, 5.16350389418, 26514.5013324502), new Vsop87.LnVsop(1.0E-11, 4.60303527476, 78690.30761559859), new Vsop87.LnVsop(1.0E-11, 5.48255968908, 207593.8465805002), new Vsop87.LnVsop(1.0E-11, 5.91676661035, 104344.49901929598), new Vsop87.LnVsop(1.0E-11, 5.79807025509, 52182.9198301492), new Vsop87.LnVsop(1.0E-11, 0.77021074284, 155997.72788435058), new Vsop87.LnVsop(1.0E-11, 4.00131880946, 120226.23016165999), new Vsop87.LnVsop(1.0E-11, 5.2415868076, 11322.6640983044), new Vsop87.LnVsop(1.0E-11, 3.99128397668, 5661.3320491522), new Vsop87.LnVsop(0.0, 3.20297505882, 21535.9496445154), new Vsop87.LnVsop(1.0E-11, 4.13603433748, 1109.3785520934), new Vsop87.LnVsop(1.0E-11, 3.31920881622, 22645.32819660879), new Vsop87.LnVsop(1.0E-11, 5.42291311668, 105307.21230790539), new Vsop87.LnVsop(0.0, 5.99626390068, 131548.89425996438), new Vsop87.LnVsop(0.0, 1.73722721022, 13521.7514415914), new Vsop87.LnVsop(1.0E-11, 3.35669906644, 104331.94280539699), new Vsop87.LnVsop(0.0, 1.63336362157, 9103.9069941176), new Vsop87.LnVsop(0.0, 2.95763935965, 54294.57014352679), new Vsop87.LnVsop(0.0, 3.34933555413, 24498.8302462904)};
        private static Vsop87.LnVsop[] mercury_longitude_l4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(2.671E-8, 4.76418299344, 52175.8062831484), new Vsop87.LnVsop(2.079E-8, 2.01782765964, 26087.9031415742), new Vsop87.LnVsop(2.071E-8, 1.47603650163, 78263.70942472259), new Vsop87.LnVsop(1.248E-8, 4.50170414847, 104351.61256629678), new Vsop87.LnVsop(6.41E-9, 1.26049541246, 130439.51570787099), new Vsop87.LnVsop(2.93E-9, 4.30408398706, 156527.41884944518), new Vsop87.LnVsop(1.24E-9, 1.05833043353, 182615.3219910194), new Vsop87.LnVsop(4.9E-10, 4.08707632054, 208703.2251325936), new Vsop87.LnVsop(4.7E-10, 3.14159265359, 0.0), new Vsop87.LnVsop(1.8E-10, 0.82373729208, 234791.12827416777), new Vsop87.LnVsop(6.0E-11, 3.82469204536, 260879.03141574195), new Vsop87.LnVsop(2.0E-11, 0.50074116156, 286966.9345573162), new Vsop87.LnVsop(2.0E-11, 4.68954881838, 51066.427731055), new Vsop87.LnVsop(1.0E-11, 1.63693177813, 24978.5245894808), new Vsop87.LnVsop(1.0E-11, 3.50676934033, 313054.83769889036), new Vsop87.LnVsop(1.0E-11, 4.59925122335, 27197.2816936676), new Vsop87.LnVsop(1.0E-11, 4.34568926758, 79373.087976816), new Vsop87.LnVsop(1.0E-11, 1.32214662513, 53285.1848352418), new Vsop87.LnVsop(1.0E-11, 1.23275471446, 129330.13715577759), new Vsop87.LnVsop(1.0E-11, 1.52702783547, 77154.33087262919), new Vsop87.LnVsop(1.0E-11, 4.47013011557, 103242.2340142034), new Vsop87.LnVsop(1.0E-11, 0.25254465674, 339142.7408404646), new Vsop87.LnVsop(0.0, 4.19908374167, 155418.04029735178)};
        private static Vsop87.LnVsop[] mercury_longitude_l5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.9E-10, 6.22596606829, 78263.70942472259), new Vsop87.LnVsop(3.5E-10, 3.08442751462, 52175.8062831484), new Vsop87.LnVsop(3.6E-10, 5.58268731752, 26087.9031415742), new Vsop87.LnVsop(3.0E-10, 2.98600396234, 104351.61256629678), new Vsop87.LnVsop(1.9E-10, 6.02016521976, 130439.51570787099), new Vsop87.LnVsop(1.0E-10, 2.77948950109, 156527.41884944518), new Vsop87.LnVsop(5.0E-11, 5.82587725191, 182615.3219910194), new Vsop87.LnVsop(2.0E-11, 2.57971347645, 208703.2251325936), new Vsop87.LnVsop(1.0E-11, 5.62474344959, 234791.12827416777), new Vsop87.LnVsop(1.0E-11, 2.30011142231, 260879.03141574195), new Vsop87.LnVsop(0.0, 5.32570213434, 286966.9345573162), new Vsop87.LnVsop(0.0, 0.0, 0.0)};

        Longitude1() {
        }
    }

    static class Longitude0 {
        private static Vsop87.LnVsop[] mercury_longitude_l0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(4.40250710144, 0.0, 0.0), new Vsop87.LnVsop(0.40989414977, 1.48302034195, 26087.9031415742), new Vsop87.LnVsop(0.050462942, 4.47785489551, 52175.8062831484), new Vsop87.LnVsop(0.00855346844, 1.16520322459, 78263.70942472259), new Vsop87.LnVsop(0.00165590362, 4.11969163423, 104351.61256629678), new Vsop87.LnVsop(3.4561897E-4, 0.77930768443, 130439.51570787099), new Vsop87.LnVsop(7.583476E-5, 3.71348404924, 156527.41884944518), new Vsop87.LnVsop(3.559745E-5, 1.51202675145, 1109.3785520934), new Vsop87.LnVsop(1.726011E-5, 0.35832267096, 182615.3219910194), new Vsop87.LnVsop(1.803464E-5, 4.10333184211, 5661.3320491522), new Vsop87.LnVsop(1.364681E-5, 4.59918328256, 27197.2816936676), new Vsop87.LnVsop(1.589923E-5, 2.9951042356, 25028.521211385), new Vsop87.LnVsop(1.017332E-5, 0.88031393824, 31749.2351907264), new Vsop87.LnVsop(7.14182E-6, 1.54144862493, 24978.5245894808), new Vsop87.LnVsop(6.43759E-6, 5.30266166599, 21535.9496445154), new Vsop87.LnVsop(4.042E-6, 3.28228953196, 208703.2251325936), new Vsop87.LnVsop(3.52442E-6, 5.24156372447, 20426.571092422), new Vsop87.LnVsop(3.43312E-6, 5.7653170387, 955.5997416086), new Vsop87.LnVsop(3.39215E-6, 5.86327825226, 25558.2121764796), new Vsop87.LnVsop(4.51137E-6, 6.04989282259, 51116.4243529592), new Vsop87.LnVsop(3.25329E-6, 1.33674488758, 53285.1848352418), new Vsop87.LnVsop(2.59588E-6, 0.98732774234, 4551.9534970588), new Vsop87.LnVsop(3.45213E-6, 2.79211954198, 15874.6175953632), new Vsop87.LnVsop(2.72948E-6, 2.49451165014, 529.6909650946), new Vsop87.LnVsop(2.34831E-6, 0.26672019191, 11322.6640983044), new Vsop87.LnVsop(2.38793E-6, 0.113439144, 1059.3819301892), new Vsop87.LnVsop(2.64336E-6, 3.91705105199, 57837.1383323006), new Vsop87.LnVsop(2.16645E-6, 0.65987085507, 13521.7514415914), new Vsop87.LnVsop(1.83358E-6, 2.62878694178, 27043.5028831828), new Vsop87.LnVsop(1.75965E-6, 4.53636943501, 51066.427731055), new Vsop87.LnVsop(1.81629E-6, 2.43413603252, 25661.3049506982), new Vsop87.LnVsop(2.08996E-6, 2.09178645677, 47623.8527860896), new Vsop87.LnVsop(1.72642E-6, 2.45200139206, 24498.8302462904), new Vsop87.LnVsop(1.42317E-6, 3.36004060149, 37410.5672398786), new Vsop87.LnVsop(1.37943E-6, 0.29098540695, 10213.285546211), new Vsop87.LnVsop(1.18233E-6, 2.78149967294, 77204.32749453338), new Vsop87.LnVsop(9.686E-7, 6.20398934398, 234791.12827416777), new Vsop87.LnVsop(1.25219E-6, 3.72079967668, 39609.6545831656), new Vsop87.LnVsop(8.6819E-7, 2.64218953915, 51646.11531805379), new Vsop87.LnVsop(8.6723E-7, 1.95952945936, 46514.4742339962), new Vsop87.LnVsop(8.833E-7, 5.41338287192, 26617.5941066688), new Vsop87.LnVsop(1.06422E-6, 4.20572143374, 19804.8272915828), new Vsop87.LnVsop(8.9987E-7, 5.85243663953, 41962.5207369374), new Vsop87.LnVsop(8.497E-7, 4.33100839394, 79373.087976816), new Vsop87.LnVsop(6.9247E-7, 4.19446500577, 19.66976089979), new Vsop87.LnVsop(6.3462E-7, 3.14700988911, 7238.6755916), new Vsop87.LnVsop(6.8493E-7, 0.63424913908, 83925.0414738748), new Vsop87.LnVsop(6.9728E-7, 3.57201999194, 25132.3033999656), new Vsop87.LnVsop(5.9481E-7, 2.74692562834, 16983.9961474566), new Vsop87.LnVsop(6.483E-7, 0.04762450218, 33326.5787331742), new Vsop87.LnVsop(5.5377E-7, 4.05313774098, 30639.856638633), new Vsop87.LnVsop(5.4443E-7, 3.14332489827, 27147.28507176339), new Vsop87.LnVsop(4.756E-7, 5.49722123456, 3.881335358), new Vsop87.LnVsop(4.9567E-7, 3.98985799218, 6770.7106012456), new Vsop87.LnVsop(5.6532E-7, 5.11921332252, 73711.75592766379), new Vsop87.LnVsop(4.1764E-7, 5.64184020485, 53131.406024757), new Vsop87.LnVsop(5.1459E-7, 5.4778679109, 50586.73338786459), new Vsop87.LnVsop(4.4745E-7, 1.22367821919, 77154.33087262919), new Vsop87.LnVsop(4.1882E-7, 5.19309331936, 6283.0758499914), new Vsop87.LnVsop(3.8045E-7, 2.43118010131, 12566.1516999828), new Vsop87.LnVsop(3.5627E-7, 0.81389896255, 32858.61374281979), new Vsop87.LnVsop(4.8008E-7, 5.49260945754, 51749.20809227239), new Vsop87.LnVsop(3.5393E-7, 3.36964017301, 36301.18868778519), new Vsop87.LnVsop(3.3952E-7, 2.786179563, 14765.2390432698), new Vsop87.LnVsop(3.056E-7, 5.84043579595, 43071.8992890308), new Vsop87.LnVsop(3.5964E-7, 1.42379903884, 2218.7571041868), new Vsop87.LnVsop(3.4044E-7, 0.47470616849, 65697.55772473979), new Vsop87.LnVsop(3.08E-7, 5.77017754761, 103292.23063610759), new Vsop87.LnVsop(2.8497E-7, 0.65049545721, 426.598190876), new Vsop87.LnVsop(2.6215E-7, 5.2415968513, 22645.32819660879), new Vsop87.LnVsop(2.6253E-7, 0.64808296487, 1589.0728952838), new Vsop87.LnVsop(2.9538E-7, 0.69772207795, 213.299095438), new Vsop87.LnVsop(2.7505E-7, 0.9801108316, 45892.73043315699), new Vsop87.LnVsop(2.2347E-7, 5.65336593067, 77734.01845962799), new Vsop87.LnVsop(2.2047E-7, 4.93396759824, 72602.37737557039), new Vsop87.LnVsop(2.2275E-7, 2.17909946933, 52705.49724824299), new Vsop87.LnVsop(2.4253E-7, 4.39994479508, 7.1135470008), new Vsop87.LnVsop(2.6751E-7, 1.0614735285, 3442.5749449654), new Vsop87.LnVsop(2.3656E-7, 2.84171550782, 260879.03141574195), new Vsop87.LnVsop(2.2908E-7, 2.58461108154, 68050.42387851159), new Vsop87.LnVsop(2.7087E-7, 0.0850167134, 63498.47038145279), new Vsop87.LnVsop(2.2247E-7, 3.22418752189, 25448.00585526019), new Vsop87.LnVsop(1.7803E-7, 3.61202758583, 110012.94461544899), new Vsop87.LnVsop(2.2407E-7, 1.02519770236, 105460.99111839019), new Vsop87.LnVsop(1.7576E-7, 4.71743981697, 25874.6040461362), new Vsop87.LnVsop(1.8587E-7, 4.52707983519, 28306.66024576099), new Vsop87.LnVsop(1.4176E-7, 6.12393941824, 53235.18821333759), new Vsop87.LnVsop(1.4185E-7, 5.14248515833, 26068.2333806744), new Vsop87.LnVsop(1.7244E-7, 0.2839428383, 51220.20654153979), new Vsop87.LnVsop(1.7176E-7, 3.26084148462, 153.7788104848), new Vsop87.LnVsop(1.4939E-7, 1.83543553823, 99799.65906923798), new Vsop87.LnVsop(1.3389E-7, 0.76569062416, 56727.7597802072), new Vsop87.LnVsop(1.3978E-7, 2.30196369782, 76674.63652943878), new Vsop87.LnVsop(1.4428E-7, 0.96645616238, 26107.57290247399), new Vsop87.LnVsop(1.1991E-7, 6.20493040602, 18849.2275499742), new Vsop87.LnVsop(1.4381E-7, 1.90954650143, 23969.1392811958), new Vsop87.LnVsop(1.1233E-7, 2.04816282167, 32370.9789915656), new Vsop87.LnVsop(1.3387E-7, 4.5175677584, 26080.78959457339), new Vsop87.LnVsop(1.1632E-7, 2.3849611275, 79219.3091663312), new Vsop87.LnVsop(1.2412E-7, 2.2228110932, 77837.11123384659), new Vsop87.LnVsop(9.95E-8, 2.04595599803, 48733.23133818299), new Vsop87.LnVsop(9.803E-8, 2.2670353962, 26091.7844769322), new Vsop87.LnVsop(9.361E-8, 5.44289482405, 38654.05484155699), new Vsop87.LnVsop(9.746E-8, 3.83975715814, 26084.0218062162), new Vsop87.LnVsop(9.264E-8, 4.02987321949, 467.9649903544), new Vsop87.LnVsop(8.961E-8, 0.11065043662, 62389.09182935939), new Vsop87.LnVsop(1.1544E-7, 4.17786977391, 103242.2340142034), new Vsop87.LnVsop(1.1146E-7, 3.7829564617, 26301.2022370122), new Vsop87.LnVsop(9.677E-8, 2.98528938781, 59414.4818747484), new Vsop87.LnVsop(8.977E-8, 3.47890335185, 91785.46086631398), new Vsop87.LnVsop(9.664E-8, 5.77943268592, 25938.3399444396), new Vsop87.LnVsop(8.855E-8, 2.84674490228, 25035.6347583858), new Vsop87.LnVsop(8.18E-8, 5.77857984038, 40853.142184844), new Vsop87.LnVsop(8.033E-8, 2.45698456693, 129380.13377768178), new Vsop87.LnVsop(8.343E-8, 5.34502885776, 19317.1925403286), new Vsop87.LnVsop(7.425E-8, 4.71160285382, 6.62855890001), new Vsop87.LnVsop(9.001E-8, 6.23397065428, 25021.4076643842), new Vsop87.LnVsop(8.126E-8, 1.12294678263, 26095.016688575), new Vsop87.LnVsop(6.568E-8, 3.66246087364, 26514.5013324502), new Vsop87.LnVsop(7.038E-8, 3.99042086727, 71980.63357473118), new Vsop87.LnVsop(6.956E-8, 1.62821293256, 23869.1460373874), new Vsop87.LnVsop(7.595E-8, 0.18335017533, 12432.0426503978), new Vsop87.LnVsop(6.061E-8, 3.67045619806, 27676.976036858), new Vsop87.LnVsop(5.896E-8, 5.57171840811, 94138.32702008578), new Vsop87.LnVsop(5.716E-8, 5.18202059613, 78793.40038981718), new Vsop87.LnVsop(5.854E-8, 2.14305101727, 20760.4270331914), new Vsop87.LnVsop(5.68E-8, 1.60728089799, 98690.28051714458), new Vsop87.LnVsop(5.789E-8, 2.35464263941, 103821.92160120218), new Vsop87.LnVsop(5.124E-8, 3.77854984569, 58946.51688439399), new Vsop87.LnVsop(5.869E-8, 5.7628465119, 286966.9345573162), new Vsop87.LnVsop(5.858E-8, 6.12539769557, 26011.6370702986), new Vsop87.LnVsop(5.216E-8, 3.29188857438, 38519.945791972), new Vsop87.LnVsop(6.0E-8, 5.6823654E-4, 51535.90899683439), new Vsop87.LnVsop(4.647E-8, 0.29029324438, 136100.84775702318), new Vsop87.LnVsop(5.787E-8, 4.44778418175, 19406.6782881746), new Vsop87.LnVsop(5.908E-8, 4.12201530508, 29530.4780865396), new Vsop87.LnVsop(5.917E-8, 3.98935947283, 131548.89425996438), new Vsop87.LnVsop(5.729E-8, 3.02328937218, 89586.37352302698), new Vsop87.LnVsop(3.928E-8, 4.81446546705, 125887.56221081219), new Vsop87.LnVsop(3.93E-8, 2.48445582384, 69159.80243060499), new Vsop87.LnVsop(3.681E-8, 2.80184812919, 79323.09135491178), new Vsop87.LnVsop(4.497E-8, 1.50332900944, 51962.5071877104), new Vsop87.LnVsop(3.687E-8, 5.33731853178, 102762.53967101299), new Vsop87.LnVsop(3.495E-8, 1.85405073784, 52156.1365222486), new Vsop87.LnVsop(3.868E-8, 1.25354721052, 54394.56338733519), new Vsop87.LnVsop(4.459E-8, 4.8890650086, 50057.04242277), new Vsop87.LnVsop(3.397E-8, 3.73895635453, 82815.66292178139), new Vsop87.LnVsop(3.524E-8, 6.07665334083, 25934.1243310894), new Vsop87.LnVsop(3.492E-8, 1.2821299958, 52168.69273614759), new Vsop87.LnVsop(3.41E-8, 6.13975533859, 639.897286314), new Vsop87.LnVsop(4.396E-8, 3.25474698374, 77308.10968311399), new Vsop87.LnVsop(2.99E-8, 5.27320912825, 46848.3301747656), new Vsop87.LnVsop(3.218E-8, 5.2095195257, 103925.01437542078), new Vsop87.LnVsop(2.899E-8, 5.08446931064, 58458.88213313979), new Vsop87.LnVsop(3.708E-8, 0.0271611918, 26241.681952059), new Vsop87.LnVsop(2.991E-8, 2.92282776454, 44937.1306915484), new Vsop87.LnVsop(3.177E-8, 0.05757316718, 22747.2907148744), new Vsop87.LnVsop(3.163E-8, 5.38719447649, 105307.21230790539), new Vsop87.LnVsop(3.556E-8, 3.96232550668, 52195.47604404819), new Vsop87.LnVsop(2.786E-8, 0.54711208086, 52389.1053785864), new Vsop87.LnVsop(2.458E-8, 1.14914981714, 2333.196392872), new Vsop87.LnVsop(2.492E-8, 5.24929906471, 25668.418497699), new Vsop87.LnVsop(2.408E-8, 2.14206640426, 64741.95798313119), new Vsop87.LnVsop(2.512E-8, 0.6195303075, 85034.42002596818), new Vsop87.LnVsop(2.416E-8, 5.26205009423, 52179.6876185064), new Vsop87.LnVsop(2.296E-8, 3.09905229352, 88476.99497093359), new Vsop87.LnVsop(2.357E-8, 0.17755751938, 117873.36400788819), new Vsop87.LnVsop(3.012E-8, 0.83692018918, 129330.13715577759), new Vsop87.LnVsop(2.421E-8, 3.95905297486, 49.9966219042), new Vsop87.LnVsop(2.198E-8, 2.56141354099, 3340.6124266998), new Vsop87.LnVsop(2.402E-8, 0.55122303655, 52171.9249477904), new Vsop87.LnVsop(2.106E-8, 5.41293286528, 155468.036919256), new Vsop87.LnVsop(2.566E-8, 3.00613732096, 51109.31080595839), new Vsop87.LnVsop(2.392E-8, 0.17900577928, 103.0927742186), new Vsop87.LnVsop(2.737E-8, 1.08182962639, 632.7837393132), new Vsop87.LnVsop(2.523E-8, 5.9036472737, 51123.53789995999), new Vsop87.LnVsop(2.098E-8, 2.47134468716, 66941.04532641819), new Vsop87.LnVsop(2.003E-8, 3.75400419522, 16066.0658614748), new Vsop87.LnVsop(2.187E-8, 1.18677902826, 2118.7638603784), new Vsop87.LnVsop(2.592E-8, 2.55125611209, 25654.19140369739), new Vsop87.LnVsop(2.558E-8, 1.1809275665, 45494.58142974879), new Vsop87.LnVsop(1.918E-8, 0.79900663165, 26555.8681319286), new Vsop87.LnVsop(1.819E-8, 0.69190176381, 98068.53671630539), new Vsop87.LnVsop(2.47E-8, 2.55063539113, 52026.2430860138), new Vsop87.LnVsop(1.703E-8, 0.3670705503, 52602.4044740244), new Vsop87.LnVsop(2.128E-8, 2.66244619788, 18093.37469954999), new Vsop87.LnVsop(1.715E-8, 4.62167075193, 49957.0491789616), new Vsop87.LnVsop(1.916E-8, 5.83738859952, 85502.38501632259), new Vsop87.LnVsop(1.975E-8, 3.57371472249, 24395.7374720718), new Vsop87.LnVsop(1.589E-8, 1.3352947108, 114.43928868521), new Vsop87.LnVsop(1.58E-8, 0.36965179736, 53764.8791784322), new Vsop87.LnVsop(2.04E-8, 2.05393633143, 45405.0956819028), new Vsop87.LnVsop(1.538E-8, 2.25451813652, 120226.23016165999), new Vsop87.LnVsop(1.525E-8, 1.48227419795, 26094.53170047421), new Vsop87.LnVsop(2.055E-8, 4.16318224321, 52182.9198301492), new Vsop87.LnVsop(1.829E-8, 0.38851668054, 522.5774180938), new Vsop87.LnVsop(2.105E-8, 4.04134275183, 25234.70675982219), new Vsop87.LnVsop(1.48E-8, 1.87649882402, 104881.30353139139), new Vsop87.LnVsop(1.46E-8, 1.01787199022, 25455.119402261), new Vsop87.LnVsop(1.452E-8, 0.34126077893, 1052.2683831884), new Vsop87.LnVsop(1.449E-8, 3.39746980273, 24505.94379329119), new Vsop87.LnVsop(1.48E-8, 4.55091353969, 124778.18365871879), new Vsop87.LnVsop(1.481E-8, 3.6224315352, 149.5631971346), new Vsop87.LnVsop(1.515E-8, 5.32310335641, 129909.82474277639), new Vsop87.LnVsop(1.594E-8, 3.00904352013, 77623.81213840858), new Vsop87.LnVsop(1.927E-8, 3.90375426022, 74.7815985673), new Vsop87.LnVsop(1.374E-8, 4.32416902448, 80482.46652890938), new Vsop87.LnVsop(1.42E-8, 3.90107663911, 7880.08915333899), new Vsop87.LnVsop(1.525E-8, 4.62447824359, 26081.27458267419), new Vsop87.LnVsop(1.567E-8, 0.6598658663, 157636.79740153858), new Vsop87.LnVsop(1.725E-8, 4.40110982693, 316.3918696566), new Vsop87.LnVsop(1.263E-8, 4.9634586118, 74821.13447975718), new Vsop87.LnVsop(1.472E-8, 5.56023083923, 95247.70557217918), new Vsop87.LnVsop(1.315E-8, 1.83261160452, 76144.94556434419), new Vsop87.LnVsop(1.439E-8, 0.83307888017, 55618.3812281138), new Vsop87.LnVsop(1.355E-8, 3.15836403543, 1066.49547719), new Vsop87.LnVsop(1.223E-8, 3.24039981367, 162188.75089859738), new Vsop87.LnVsop(1.39E-8, 5.1372278153, 419.4846438752), new Vsop87.LnVsop(1.309E-8, 5.28240557347, 25619.9381512198), new Vsop87.LnVsop(1.477E-8, 2.40286418702, 313054.83769889036), new Vsop87.LnVsop(1.252E-8, 5.65232980046, 26013.1215430069), new Vsop87.LnVsop(1.143E-8, 0.38696459711, 42153.969003049), new Vsop87.LnVsop(1.082E-8, 2.56546867715, 26190.99591579279), new Vsop87.LnVsop(1.493E-8, 2.89979127265, 52099.5402118728), new Vsop87.LnVsop(1.468E-8, 5.71541196756, 24491.71669928959), new Vsop87.LnVsop(1.034E-8, 1.49588002262, 151975.46535238638), new Vsop87.LnVsop(1.315E-8, 5.91525944336, 115674.27666460119), new Vsop87.LnVsop(1.065E-8, 3.61056177659, 206.1855484372), new Vsop87.LnVsop(1.053E-8, 5.18007204084, 23754.70674870219), new Vsop87.LnVsop(9.63E-9, 2.0529138247, 128850.44281258718), new Vsop87.LnVsop(1.031E-8, 3.39058255009, 25551.09862947879), new Vsop87.LnVsop(1.065E-8, 3.38232835239, 25863.55834587229), new Vsop87.LnVsop(1.153E-8, 5.76502004439, 44181.27784112419), new Vsop87.LnVsop(9.6E-9, 5.74762439771, 105410.99449648599), new Vsop87.LnVsop(1.137E-8, 6.20916641857, 103396.01282468818), new Vsop87.LnVsop(9.14E-9, 4.28846119946, 78256.59587772179), new Vsop87.LnVsop(9.18E-9, 3.27512590931, 76.2660712756), new Vsop87.LnVsop(8.92E-9, 4.8240126681, 78244.0396638228), new Vsop87.LnVsop(9.77E-9, 4.86447903869, 25131.61398560359), new Vsop87.LnVsop(1.086E-8, 0.73421207473, 33967.99229491319), new Vsop87.LnVsop(1.162E-8, 4.52149319583, 78050.41032928458), new Vsop87.LnVsop(8.68E-9, 2.78832869275, 52022.0274726636), new Vsop87.LnVsop(9.44E-9, 4.09732379319, 26720.68688088739), new Vsop87.LnVsop(9.73E-9, 4.54021116854, 24925.4284371664), new Vsop87.LnVsop(8.45E-9, 5.05428850137, 25977.69682035479), new Vsop87.LnVsop(8.41E-9, 1.89439003615, 130012.91751699499), new Vsop87.LnVsop(9.2E-9, 3.02491491588, 52329.58509363319), new Vsop87.LnVsop(8.13E-9, 3.15301734719, 48835.19385644859), new Vsop87.LnVsop(8.77E-9, 0.41324612537, 108903.56606335558), new Vsop87.LnVsop(8.19E-9, 1.61521143447, 40565.2543247742), new Vsop87.LnVsop(1.075E-8, 1.3728701488, 23439.44831610119), new Vsop87.LnVsop(8.12E-9, 2.82158357641, 25984.8103673556), new Vsop87.LnVsop(7.75E-9, 2.86885996155, 26727.8004278882), new Vsop87.LnVsop(7.55E-9, 5.44067758231, 24609.0365675098), new Vsop87.LnVsop(9.19E-9, 4.72527676083, 14477.3511832), new Vsop87.LnVsop(9.14E-9, 4.70822051956, 6681.2248533996), new Vsop87.LnVsop(7.49E-9, 1.80266552461, 84546.78527471398), new Vsop87.LnVsop(9.06E-9, 0.64975766863, 78283.37918562238), new Vsop87.LnVsop(8.55E-9, 5.05062817348, 307.5576209696), new Vsop87.LnVsop(7.66E-9, 5.89903011866, 71025.0338331226), new Vsop87.LnVsop(7.13E-9, 3.55177815121, 78477.00852016058), new Vsop87.LnVsop(7.19E-9, 1.85087720309, 100909.03762133139), new Vsop87.LnVsop(8.58E-9, 5.43952313313, 536.8045120954), new Vsop87.LnVsop(7.94E-9, 3.77060303998, 155418.04029735178), new Vsop87.LnVsop(8.48E-9, 2.08846185252, 131395.11544947958), new Vsop87.LnVsop(6.23E-9, 3.14632637321, 143961.2671494624), new Vsop87.LnVsop(6.23E-9, 5.10465766894, 90829.86112470538), new Vsop87.LnVsop(6.21E-9, 4.59014649415, 9103.9069941176), new Vsop87.LnVsop(7.06E-9, 4.19528422791, 71582.48457132299), new Vsop87.LnVsop(7.39E-9, 0.15975550376, 24712.1293417284), new Vsop87.LnVsop(7.14E-9, 1.8802834504, 2199.087343287), new Vsop87.LnVsop(6.77E-9, 6.014320608, 77197.21394753258), new Vsop87.LnVsop(6.2E-9, 1.32853841881, 3328.13565628019), new Vsop87.LnVsop(6.5E-9, 5.51234531031, 29428.515568274), new Vsop87.LnVsop(6.57E-9, 2.03363099847, 51756.3216392732), new Vsop87.LnVsop(5.94E-9, 6.06826637505, 114564.89811250778), new Vsop87.LnVsop(6.66E-9, 0.70705130538, 26162.6847401415), new Vsop87.LnVsop(5.98E-9, 5.15770220681, 333.8559407694), new Vsop87.LnVsop(6.16E-9, 1.94904709349, 78267.59076008058), new Vsop87.LnVsop(7.74E-9, 2.84218106686, 13655.8604911764), new Vsop87.LnVsop(6.97E-9, 5.60799904851, 51742.09454527159), new Vsop87.LnVsop(5.56E-9, 2.07542224847, 181555.94006083018), new Vsop87.LnVsop(5.48E-9, 3.177025416, 90695.75207512038), new Vsop87.LnVsop(5.41E-9, 4.2081906298, 28421.0995344462), new Vsop87.LnVsop(6.38E-9, 5.55947577602, 78114.14622758799), new Vsop87.LnVsop(5.29E-9, 3.60221910186, 1911.1994832172), new Vsop87.LnVsop(6.19E-9, 4.87812731811, 25771.5112719176), new Vsop87.LnVsop(5.7E-9, 3.56318859887, 111122.32316754239), new Vsop87.LnVsop(5.1E-9, 4.2028854031, 28206.6670019526), new Vsop87.LnVsop(5.39E-9, 5.42636252112, 93028.94846799239), new Vsop87.LnVsop(6.58E-9, 3.45393169676, 26610.48055966799), new Vsop87.LnVsop(6.13E-9, 3.52134452894, 78259.82808936459), new Vsop87.LnVsop(5.77E-9, 0.81666137084, 51322.60990139639), new Vsop87.LnVsop(5.94E-9, 1.1629854126, 26404.2950112308), new Vsop87.LnVsop(4.97E-9, 5.37653944274, 26037.90651966999), new Vsop87.LnVsop(6.63E-9, 2.63276230593, 77211.44104153418), new Vsop87.LnVsop(4.86E-9, 1.96691155158, 26507.38778544939), new Vsop87.LnVsop(4.74E-9, 3.65214522517, 124156.43985787958), new Vsop87.LnVsop(5.5E-9, 5.81053917486, 1731.1223529326), new Vsop87.LnVsop(4.72E-9, 3.79306901191, 52643.7712735028), new Vsop87.LnVsop(4.67E-9, 4.50162371638, 110.2063212194), new Vsop87.LnVsop(5.92E-9, 3.04748129459, 12725.453434775), new Vsop87.LnVsop(5.51E-9, 0.68606702543, 26137.8997634784), new Vsop87.LnVsop(6.0E-9, 0.33955465102, 50483.640613646), new Vsop87.LnVsop(5.25E-9, 0.8791454226, 78270.82297172339), new Vsop87.LnVsop(4.43E-9, 3.33347421396, 78690.30761559859), new Vsop87.LnVsop(4.39E-9, 1.30939082033, 76044.9523205358), new Vsop87.LnVsop(5.88E-9, 2.37059415297, 121335.60871375339), new Vsop87.LnVsop(4.26E-9, 0.14790973129, 50593.84693486539), new Vsop87.LnVsop(4.13E-9, 3.33312213477, 79852.78232000639), new Vsop87.LnVsop(4.03E-9, 5.20675969218, 146314.13330323418), new Vsop87.LnVsop(5.24E-9, 5.02826409094, 71492.99882347698), new Vsop87.LnVsop(4.17E-9, 5.9913659164, 103711.71527998279), new Vsop87.LnVsop(3.89E-9, 4.4418769335, 29416.03879785439), new Vsop87.LnVsop(3.89E-9, 4.02257298908, 51543.0225438352), new Vsop87.LnVsop(4.42E-9, 2.37195011319, 111590.2881578968), new Vsop87.LnVsop(3.75E-9, 4.4756082015, 52182.4348420484), new Vsop87.LnVsop(3.87E-9, 4.83554303442, 130969.20667296558), new Vsop87.LnVsop(3.89E-9, 1.20251530573, 150866.08680029298), new Vsop87.LnVsop(4.07E-9, 0.52988897291, 433.7117378768), new Vsop87.LnVsop(4.16E-9, 3.6036672917, 183724.7005431128), new Vsop87.LnVsop(4.39E-9, 2.45449965869, 50579.61984086379), new Vsop87.LnVsop(4.12E-9, 0.50038241185, 27999.1026247914), new Vsop87.LnVsop(3.92E-9, 0.68295335891, 134.109049585), new Vsop87.LnVsop(3.99E-9, 1.99463585522, 155997.72788435058), new Vsop87.LnVsop(4.22E-9, 5.83266410745, 38813.3565763492), new Vsop87.LnVsop(3.46E-9, 3.40284434869, 27140.17152476259), new Vsop87.LnVsop(3.68E-9, 3.80729957662, 81706.28436968799), new Vsop87.LnVsop(3.42E-9, 0.8387380933, 25764.39772491679), new Vsop87.LnVsop(3.58E-9, 1.99506378254, 1089.7087911936), new Vsop87.LnVsop(4.63E-9, 3.33594289344, 25440.89230825939), new Vsop87.LnVsop(3.31E-9, 0.37072554435, 26237.46633870879), new Vsop87.LnVsop(3.3E-9, 6.19220570613, 188276.6540401716), new Vsop87.LnVsop(4.08E-9, 2.17144409714, 641.41356173899), new Vsop87.LnVsop(3.21E-9, 5.02563588253, 102232.84870591838), new Vsop87.LnVsop(3.3E-9, 5.51852292754, 10021.8372800994), new Vsop87.LnVsop(3.34E-9, 2.49304639997, 25344.9130810416), new Vsop87.LnVsop(3.81E-9, 5.90959254017, 78187.44335344699), new Vsop87.LnVsop(3.16E-9, 2.42543561835, 52101.02468458109), new Vsop87.LnVsop(3.31E-9, 4.38957047363, 26202.34243025941), new Vsop87.LnVsop(4.01E-9, 1.99445200318, 49842.60989027639), new Vsop87.LnVsop(4.22E-9, 0.46556007098, 1.4844727083), new Vsop87.LnVsop(3.1E-9, 6.18778948056, 27154.3986187642), new Vsop87.LnVsop(3.02E-9, 4.68609762435, 25565.3257234804), new Vsop87.LnVsop(2.97E-9, 1.70847616577, 25973.46385288896), new Vsop87.LnVsop(3.75E-9, 5.32471088557, 339142.7408404646), new Vsop87.LnVsop(3.28E-9, 5.3259959548, 853.196381752), new Vsop87.LnVsop(2.99E-9, 5.81110649116, 1692.1656695024), new Vsop87.LnVsop(3.78E-9, 1.33738289334, 52169.17772424839), new Vsop87.LnVsop(2.89E-9, 6.20208961953, 25881.717593137), new Vsop87.LnVsop(2.77E-9, 4.45045644666, 178063.3684939606), new Vsop87.LnVsop(2.91E-9, 4.44971680232, 579.6875869988), new Vsop87.LnVsop(3.16E-9, 1.96022181583, 51707.84129279399), new Vsop87.LnVsop(3.37E-9, 4.21436282894, 34282.1784747828), new Vsop87.LnVsop(3.34E-9, 3.00242982742, 23866.04650697719), new Vsop87.LnVsop(2.68E-9, 1.34364307187, 35191.8101356918), new Vsop87.LnVsop(3.08E-9, 5.94802883612, 64607.84893354619), new Vsop87.LnVsop(2.83E-9, 0.96217168652, 1639.069517188), new Vsop87.LnVsop(2.87E-9, 1.28056998141, 51013.33157874059), new Vsop87.LnVsop(2.7E-9, 0.55824473532, 3462.2447058652), new Vsop87.LnVsop(2.74E-9, 5.60833767567, 52278.89905736699), new Vsop87.LnVsop(3.52E-9, 0.49345825951, 26294.08869001139), new Vsop87.LnVsop(3.58E-9, 1.23398111485, 1223.81784077861), new Vsop87.LnVsop(3.44E-9, 4.29281175054, 49527.35145767539), new Vsop87.LnVsop(2.55E-9, 5.0301436702, 154938.34595416137), new Vsop87.LnVsop(2.97E-9, 2.87098037822, 129483.91596626239), new Vsop87.LnVsop(2.53E-9, 0.09066729355, 13541.42120249119), new Vsop87.LnVsop(3.01E-9, 1.2270345916, 104138.31347085879), new Vsop87.LnVsop(2.74E-9, 3.67743328955, 68241.8721446232), new Vsop87.LnVsop(3.21E-9, 2.49935317919, 141762.17980617538), new Vsop87.LnVsop(2.9E-9, 1.0214001344, 8194.2753332086), new Vsop87.LnVsop(2.39E-9, 0.9918737929, 104344.49901929598), new Vsop87.LnVsop(2.77E-9, 0.53135196296, 949.1756089698), new Vsop87.LnVsop(2.48E-9, 2.3974500886, 131498.89763806018), new Vsop87.LnVsop(2.74E-9, 2.09609851306, 26624.70765366959), new Vsop87.LnVsop(2.4E-9, 0.85016661328, 52808.59002246159), new Vsop87.LnVsop(2.66E-9, 0.18316540889, 2168.7604822826), new Vsop87.LnVsop(2.37E-9, 3.15135087265, 23976.2528281966), new Vsop87.LnVsop(2.29E-9, 2.19886640826, 50696.93970908399), new Vsop87.LnVsop(2.25E-9, 4.85647140456, 156100.82065856917), new Vsop87.LnVsop(2.31E-9, 1.49530886624, 104331.94280539699), new Vsop87.LnVsop(2.82E-9, 1.63421453401, 51219.51712717779), new Vsop87.LnVsop(2.45E-9, 4.68702231602, 5327.4761083828), new Vsop87.LnVsop(2.2E-9, 5.75804546531, 78109.93061423779), new Vsop87.LnVsop(2.18E-9, 5.42845467468, 18207.81398823521), new Vsop87.LnVsop(2.27E-9, 6.02399891588, 1581.959348283), new Vsop87.LnVsop(2.32E-9, 5.99760045579, 78417.48823520739), new Vsop87.LnVsop(2.2E-9, 3.72002247582, 7994.5284420242), new Vsop87.LnVsop(2.71E-9, 0.20761446669, 51639.00177105299), new Vsop87.LnVsop(2.43E-9, 2.3361821359, 25138.7275326044), new Vsop87.LnVsop(2.53E-9, 5.46291034047, 621.7438008392), new Vsop87.LnVsop(2.8E-9, 0.15532838705, 51951.46148744649), new Vsop87.LnVsop(2.09E-9, 0.0183081765, 26164.1692128498), new Vsop87.LnVsop(2.08E-9, 6.17986143435, 74923.09699802278), new Vsop87.LnVsop(2.06E-9, 1.61576904815, 25241.820306823), new Vsop87.LnVsop(2.36E-9, 4.28926910244, 24079.34560241519), new Vsop87.LnVsop(2.11E-9, 1.9557473611, 735.8765135318), new Vsop87.LnVsop(2.06E-9, 5.86779636866, 52072.71350892979), new Vsop87.LnVsop(2.35E-9, 3.60456469848, 104371.28232719658), new Vsop87.LnVsop(2.28E-9, 3.66072813155, 1596.1864422846), new Vsop87.LnVsop(1.98E-9, 5.854905195, 52815.7035694624), new Vsop87.LnVsop(1.98E-9, 1.02967825338, 25867.49049913539), new Vsop87.LnVsop(2.19E-9, 1.39355980522, 32769.1279949738), new Vsop87.LnVsop(2.29E-9, 3.36247801855, 134991.4692049298), new Vsop87.LnVsop(1.97E-9, 4.77851384259, 110634.68841628819), new Vsop87.LnVsop(2.13E-9, 0.77959231227, 917.9302859818), new Vsop87.LnVsop(1.9E-9, 4.24426555817, 14.2270940016), new Vsop87.LnVsop(2.09E-9, 5.44598697132, 147423.51185532758), new Vsop87.LnVsop(2.29E-9, 0.76395418391, 220.4126424388), new Vsop87.LnVsop(1.85E-9, 0.24825412134, 104564.91166173479), new Vsop87.LnVsop(1.89E-9, 3.32749048432, 30.3268610044), new Vsop87.LnVsop(1.82E-9, 2.31699263584, 9384.8410080752), new Vsop87.LnVsop(2.09E-9, 1.81798829614, 52065.59996192899), new Vsop87.LnVsop(1.91E-9, 0.9125619992, 97670.38771289718), new Vsop87.LnVsop(2.09E-9, 0.41166983619, 181505.94343892598), new Vsop87.LnVsop(1.95E-9, 1.96978627522, 314.1861798696), new Vsop87.LnVsop(1.85E-9, 2.71647255738, 103285.11708910679), new Vsop87.LnVsop(1.88E-9, 4.30567171912, 1884.9011634174), new Vsop87.LnVsop(2.25E-9, 5.05990359517, 157483.01859105378), new Vsop87.LnVsop(1.94E-9, 0.98119689475, 26049.7701059364), new Vsop87.LnVsop(1.93E-9, 4.82115364463, 126996.94076290558), new Vsop87.LnVsop(1.85E-9, 0.67159839253, 106570.36967048359), new Vsop87.LnVsop(1.67E-9, 5.70903987089, 96357.08412427259), new Vsop87.LnVsop(2.0E-9, 2.57264462597, 97112.93697469679), new Vsop87.LnVsop(1.84E-9, 2.33825467783, 77829.99768684579), new Vsop87.LnVsop(1.76E-9, 3.20477474376, 39629.32434406539), new Vsop87.LnVsop(1.69E-9, 2.30516506046, 101.9625182656), new Vsop87.LnVsop(2.24E-9, 3.20562091672, 50800.03248330259), new Vsop87.LnVsop(1.95E-9, 5.18234930994, 99024.13645791399), new Vsop87.LnVsop(1.63E-9, 6.10607233599, 170049.1702910366), new Vsop87.LnVsop(1.76E-9, 4.28787695022, 25780.3455206046), new Vsop87.LnVsop(1.65E-9, 6.00499743312, 224.3447957019), new Vsop87.LnVsop(1.6E-9, 1.94771721315, 26421.7590823436), new Vsop87.LnVsop(1.67E-9, 3.75605549998, 52250.5878817157), new Vsop87.LnVsop(1.64E-9, 1.77310680762, 116917.76426627958), new Vsop87.LnVsop(2.16E-9, 2.59043583275, 27819.0254945068), new Vsop87.LnVsop(1.54E-9, 1.63000015144, 24815.222115947), new Vsop87.LnVsop(1.55E-9, 4.49642342619, 956.2891559706), new Vsop87.LnVsop(1.65E-9, 3.81500359793, 77410.51304297059), new Vsop87.LnVsop(1.53E-9, 3.95671977623, 24601.92302050899), new Vsop87.LnVsop(1.51E-9, 5.03883003223, 207643.8432024044), new Vsop87.LnVsop(1.58E-9, 4.95378278448, 35472.7441496494), new Vsop87.LnVsop(1.8E-9, 5.62656169139, 103299.34418310839), new Vsop87.LnVsop(1.65E-9, 2.25891713026, 104202.04936916218), new Vsop87.LnVsop(1.66E-9, 1.72114015725, 2648.454825473), new Vsop87.LnVsop(1.73E-9, 2.62016482892, 26086.4186688659), new Vsop87.LnVsop(1.56E-9, 1.62948955004, 51859.41441349179), new Vsop87.LnVsop(1.45E-9, 2.63569129484, 24292.64469785319), new Vsop87.LnVsop(1.66E-9, 0.21317040603, 52698.38370124219), new Vsop87.LnVsop(1.55E-9, 1.79976780999, 3.9321532631), new Vsop87.LnVsop(1.51E-9, 2.74555154751, 140652.80125408198), new Vsop87.LnVsop(1.7E-9, 0.79077348232, 72936.23331633979), new Vsop87.LnVsop(1.77E-9, 5.06186919984, 77844.22478084739), new Vsop87.LnVsop(1.5E-9, 4.9308050641, 28286.9904848612), new Vsop87.LnVsop(1.75E-9, 5.79341041658, 39743.7636327506), new Vsop87.LnVsop(1.63E-9, 3.37027230636, 76571.54375522019), new Vsop87.LnVsop(1.86E-9, 1.81335534539, 26395.46076254379), new Vsop87.LnVsop(1.59E-9, 4.90444632725, 104355.49390165479), new Vsop87.LnVsop(1.49E-9, 4.20183170995, 52492.19815280499), new Vsop87.LnVsop(1.46E-9, 1.31209567772, 26198.1094627936), new Vsop87.LnVsop(1.63E-9, 2.25608093049, 55516.4187098482), new Vsop87.LnVsop(1.31E-9, 0.90558224757, 54294.57014352679), new Vsop87.LnVsop(1.42E-9, 1.71011577241, 92741.06060792258), new Vsop87.LnVsop(1.38E-9, 0.64118842478, 86143.79857806159), new Vsop87.LnVsop(1.65E-9, 4.72014033895, 4083.9885067044), new Vsop87.LnVsop(1.32E-9, 0.9204252962, 54509.0026760204), new Vsop87.LnVsop(1.25E-9, 0.31897986681, 150244.3429994538), new Vsop87.LnVsop(1.44E-9, 1.05243628393, 1083.0802322936), new Vsop87.LnVsop(1.44E-9, 4.1744770687, 24822.3356629478), new Vsop87.LnVsop(1.51E-9, 0.38915510192, 487.6347512542), new Vsop87.LnVsop(1.34E-9, 3.86340442367, 104358.72611329758), new Vsop87.LnVsop(1.23E-9, 2.08423913645, 52125.80966124419), new Vsop87.LnVsop(1.22E-9, 5.01127438966, 52595.29092702359), new Vsop87.LnVsop(1.4E-9, 2.08502567831, 119116.85160956658), new Vsop87.LnVsop(1.58E-9, 5.19357058726, 23962.02573419499), new Vsop87.LnVsop(1.34E-9, 6.25970085732, 636.9962720242), new Vsop87.LnVsop(1.35E-9, 0.57090512541, 25936.85547173129), new Vsop87.LnVsop(1.18E-9, 3.30558637192, 1263.15736257819), new Vsop87.LnVsop(1.27E-9, 0.19814904969, 38.1330356378), new Vsop87.LnVsop(1.64E-9, 3.27172225246, 26089.38761428249), new Vsop87.LnVsop(1.31E-9, 3.65063342527, 29550.14784743939), new Vsop87.LnVsop(1.39E-9, 4.69100415119, 2014.9816717978), new Vsop87.LnVsop(1.16E-9, 2.6925442988, 129799.61842155698), new Vsop87.LnVsop(1.59E-9, 0.19389508543, 104347.73123093879), new Vsop87.LnVsop(1.19E-9, 0.49364918929, 78731.674415077), new Vsop87.LnVsop(1.22E-9, 5.26003763179, 26729.31670331319), new Vsop87.LnVsop(1.15E-9, 1.35337166628, 75615.25459924959), new Vsop87.LnVsop(1.12E-9, 4.26094907654, 102132.85546210999), new Vsop87.LnVsop(1.19E-9, 5.54566614405, 76667.52298243798), new Vsop87.LnVsop(1.35E-9, 1.69822927449, 97580.90196505119), new Vsop87.LnVsop(1.2E-9, 3.20629586215, 76681.75007643958), new Vsop87.LnVsop(1.13E-9, 6.26294483694, 104778.21075717278), new Vsop87.LnVsop(1.27E-9, 0.11236915083, 51528.79544983359), new Vsop87.LnVsop(1.45E-9, 3.61600835664, 52225.8029050526), new Vsop87.LnVsop(1.08E-9, 5.72635533853, 24176.703658357), new Vsop87.LnVsop(1.32E-9, 1.56301672659, 25939.82441714789), new Vsop87.LnVsop(1.24E-9, 4.17936911601, 25754.0472008048), new Vsop87.LnVsop(1.17E-9, 1.71758893092, 22759.76748529401), new Vsop87.LnVsop(1.11E-9, 3.52660271138, 24356.7807886416), new Vsop87.LnVsop(1.12E-9, 0.28845559419, 209812.60368468694), new Vsop87.LnVsop(1.06E-9, 6.26831675546, 105940.68546158058), new Vsop87.LnVsop(1.04E-9, 1.87785131678, 172402.0364448084), new Vsop87.LnVsop(1.08E-9, 2.96242441236, 1375.7737998458), new Vsop87.LnVsop(1.01E-9, 3.85084997066, 1478.8665740644), new Vsop87.LnVsop(1.14E-9, 5.2057993669, 137678.191299471), new Vsop87.LnVsop(1.0E-9, 1.55712053447, 25973.50403466079), new Vsop87.LnVsop(1.15E-9, 5.15253758124, 1135.6768718932), new Vsop87.LnVsop(1.01E-9, 0.7357250218, 77630.92568540938), new Vsop87.LnVsop(1.01E-9, 0.25974575144, 160.40736938481), new Vsop87.LnVsop(1.06E-9, 0.03739242592, 180.0771302846), new Vsop87.LnVsop(1.05E-9, 0.00912179296, 13362.4497067992), new Vsop87.LnVsop(9.6E-10, 1.18770041705, 78270.3379836226), new Vsop87.LnVsop(1.25E-9, 4.60962604344, 11610.5519583742), new Vsop87.LnVsop(9.6E-10, 0.4877709297, 107794.1875112622), new Vsop87.LnVsop(1.01E-9, 4.1365906202, 176953.98994186718), new Vsop87.LnVsop(9.9E-10, 1.50710271888, 157057.10981453978), new Vsop87.LnVsop(9.4E-10, 3.53697478079, 26521.614879451), new Vsop87.LnVsop(1.06E-9, 4.57421536992, 26073.67604757259), new Vsop87.LnVsop(9.1E-10, 3.12915113312, 64901.25971792339), new Vsop87.LnVsop(1.06E-9, 4.04251666854, 27726.9726587622), new Vsop87.LnVsop(9.1E-10, 3.88291208024, 51852.30086649099), new Vsop87.LnVsop(8.7E-10, 5.20300185641, 1485.2907067032), new Vsop87.LnVsop(1.15E-9, 5.97185006663, 24182.4383766338), new Vsop87.LnVsop(9.9E-10, 2.12029899747, 66653.15746634839), new Vsop87.LnVsop(9.4E-10, 2.62091616233, 104275.34649502118), new Vsop87.LnVsop(1.12E-9, 6.0470630125, 49953.94964855139), new Vsop87.LnVsop(1.06E-9, 2.0663012179, 125112.03959948818), new Vsop87.LnVsop(8.3E-10, 3.35095689116, 52325.36948028299), new Vsop87.LnVsop(8.3E-10, 2.82819081777, 214364.55718174577), new Vsop87.LnVsop(8.2E-10, 4.04236392434, 132658.27281205778), new Vsop87.LnVsop(1.02E-9, 4.95574370006, 182085.63102592478), new Vsop87.LnVsop(8.1E-10, 5.45741776539, 78188.92782615528), new Vsop87.LnVsop(9.6E-10, 5.5588530069, 51432.81622261579), new Vsop87.LnVsop(9.0E-10, 1.00092960433, 9745.3205558566), new Vsop87.LnVsop(8.4E-10, 0.11009911861, 53228.07466633679), new Vsop87.LnVsop(8.0E-10, 6.13435930809, 137210.22630911658), new Vsop87.LnVsop(8.0E-10, 2.72523265777, 25042.7483053866), new Vsop87.LnVsop(8.1E-10, 1.88879072729, 128320.75184749259), new Vsop87.LnVsop(9.1E-10, 4.44731219389, 26091.83529483729), new Vsop87.LnVsop(7.8E-10, 4.29086934596, 77101.23472031478), new Vsop87.LnVsop(7.9E-10, 1.07554886014, 50167.24874398939), new Vsop87.LnVsop(8.3E-10, 0.9668234002, 25788.776747305), new Vsop87.LnVsop(7.7E-10, 3.7391917278, 26222.0121911592), new Vsop87.LnVsop(7.5E-10, 2.88523920506, 53242.3017603384), new Vsop87.LnVsop(7.5E-10, 1.15216528271, 204151.27163553477), new Vsop87.LnVsop(1.04E-9, 4.31779632686, 23888.81579828719), new Vsop87.LnVsop(7.5E-10, 2.56714081506, 19202.75325164339), new Vsop87.LnVsop(9.4E-10, 4.3236655946, 78257.08086582259), new Vsop87.LnVsop(8.8E-10, 3.55952578858, 52381.99183158559), new Vsop87.LnVsop(8.8E-10, 3.52519120352, 60055.89543648739), new Vsop87.LnVsop(7.1E-10, 4.96476508038, 26823.77965510599), new Vsop87.LnVsop(7.7E-10, 5.82847259563, 155571.81910783658), new Vsop87.LnVsop(9.9E-10, 3.23844307345, 28256.66362385679), new Vsop87.LnVsop(7.0E-10, 4.31065427591, 86457.98475793119), new Vsop87.LnVsop(7.6E-10, 2.22271998217, 36109.7404216736), new Vsop87.LnVsop(7.6E-10, 1.00884250882, 25352.02662804239), new Vsop87.LnVsop(9.5E-10, 5.9991819993, 19958.6061020676), new Vsop87.LnVsop(8.0E-10, 1.1346027526, 52290.24557183361), new Vsop87.LnVsop(8.7E-10, 1.31383914626, 26667.590728573), new Vsop87.LnVsop(7.3E-10, 2.05114043397, 26941.0995233262), new Vsop87.LnVsop(7.5E-10, 1.56761266225, 51653.22886505459), new Vsop87.LnVsop(7.4E-10, 4.24204028736, 130226.21661243298), new Vsop87.LnVsop(7.1E-10, 4.7396130147, 52061.36699446317), new Vsop87.LnVsop(9.5E-10, 1.93406737148, 365230.6439820388), new Vsop87.LnVsop(7.3E-10, 2.9640755146, 25024.58905812189), new Vsop87.LnVsop(7.0E-10, 2.23536123203, 173511.41499690176), new Vsop87.LnVsop(6.9E-10, 2.26111089193, 159.3017347922), new Vsop87.LnVsop(7.6E-10, 5.58932777184, 13675.5302520762), new Vsop87.LnVsop(6.6E-10, 2.59450231797, 27780.06881107659), new Vsop87.LnVsop(6.6E-10, 1.14753207913, 55503.94193942859), new Vsop87.LnVsop(7.5E-10, 4.2956343817, 27311.72098235281), new Vsop87.LnVsop(6.6E-10, 2.92871283816, 23919.1426592916), new Vsop87.LnVsop(8.1E-10, 5.35656494266, 167850.0829477496), new Vsop87.LnVsop(6.5E-10, 1.76581252465, 181026.24909573558), new Vsop87.LnVsop(6.4E-10, 0.55885405924, 34082.4315835984), new Vsop87.LnVsop(6.8E-10, 5.13310648307, 52712.61079524379), new Vsop87.LnVsop(6.3E-10, 3.98734650866, 130432.40216087017), new Vsop87.LnVsop(7.3E-10, 5.05540467899, 27177.6119327678), new Vsop87.LnVsop(8.1E-10, 0.87794410758, 25446.4895798352), new Vsop87.LnVsop(7.2E-10, 2.75418245422, 11.0457002639), new Vsop87.LnVsop(7.1E-10, 6.19433993178, 50064.15596977079), new Vsop87.LnVsop(7.8E-10, 4.91889852543, 77795.74443436819), new Vsop87.LnVsop(6.2E-10, 3.90028384133, 27005.83342755599), new Vsop87.LnVsop(8.5E-10, 3.57336994355, 27037.07875054399), new Vsop87.LnVsop(6.3E-10, 5.38131021751, 51226.63067417859), new Vsop87.LnVsop(6.0E-10, 3.86941305331, 78896.49316403578), new Vsop87.LnVsop(8.4E-10, 3.73808276953, 26308.315784013), new Vsop87.LnVsop(6.7E-10, 2.33716983257, 78366.80219894118), new Vsop87.LnVsop(6.0E-10, 2.70936065867, 104505.39137678158), new Vsop87.LnVsop(5.8E-10, 4.70485127291, 103.7821885806), new Vsop87.LnVsop(5.8E-10, 4.90593616982, 25508.2155545754), new Vsop87.LnVsop(6.3E-10, 5.19084024444, 76784.84285065818), new Vsop87.LnVsop(7.2E-10, 3.44175435793, 54087.0057663656), new Vsop87.LnVsop(6.6E-10, 2.9738176408, 51969.62073471119), new Vsop87.LnVsop(5.8E-10, 1.54682427778, 182188.72380014337), new Vsop87.LnVsop(5.7E-10, 2.46940249341, 104197.83375581198), new Vsop87.LnVsop(6.5E-10, 5.33114478447, 157586.80077963436), new Vsop87.LnVsop(6.6E-10, 6.05053372563, 647.0108333148), new Vsop87.LnVsop(6.5E-10, 4.63705403958, 61279.713277266), new Vsop87.LnVsop(6.0E-10, 4.42236493104, 130419.8459469712), new Vsop87.LnVsop(5.6E-10, 4.6302237776, 51329.7234483972), new Vsop87.LnVsop(6.0E-10, 1.90391714646, 102018.41617342478), new Vsop87.LnVsop(5.6E-10, 2.17285982642, 323.5054166574), new Vsop87.LnVsop(6.1E-10, 0.24700789346, 130459.18546877075), new Vsop87.LnVsop(5.4E-10, 1.65192940412, 31415.379249957), new Vsop87.LnVsop(6.9E-10, 4.68284550055, 77307.42026875199), new Vsop87.LnVsop(5.6E-10, 4.05991604789, 32132.1317229496), new Vsop87.LnVsop(5.4E-10, 2.49487716279, 22625.658435709), new Vsop87.LnVsop(5.9E-10, 1.82755627609, 183570.921732628), new Vsop87.LnVsop(6.6E-10, 3.17086218594, 78039.36462902068), new Vsop87.LnVsop(5.2E-10, 2.12945044983, 44295.7171298094), new Vsop87.LnVsop(7.2E-10, 6.17318529798, 25032.45336464809), new Vsop87.LnVsop(5.4E-10, 2.05026185233, 17893.6278083656), new Vsop87.LnVsop(5.1E-10, 2.50572759919, 78903.60671103658), new Vsop87.LnVsop(5.3E-10, 0.21211371229, 2221.856634597), new Vsop87.LnVsop(6.1E-10, 1.22064448269, 26083.97098831109), new Vsop87.LnVsop(6.4E-10, 2.36532888601, 25953.79409198919), new Vsop87.LnVsop(5.2E-10, 3.92321101844, 123758.29085447139), new Vsop87.LnVsop(5.1E-10, 4.74694757019, 5193.3670587978), new Vsop87.LnVsop(5.1E-10, 2.91556516001, 101011.00013959699), new Vsop87.LnVsop(5.0E-10, 2.62878188924, 78160.61665050399), new Vsop87.LnVsop(6.0E-10, 6.20060892122, 76887.93562487679), new Vsop87.LnVsop(6.6E-10, 3.23190763248, 77726.90491262719), new Vsop87.LnVsop(6.9E-10, 0.82568775458, 22909.7573510066), new Vsop87.LnVsop(5.9E-10, 1.52387880104, 6044.2285813754), new Vsop87.LnVsop(5.1E-10, 1.99922535685, 24448.8336243862), new Vsop87.LnVsop(4.9E-10, 2.99170950627, 52252.07235442399), new Vsop87.LnVsop(5.1E-10, 0.76458856785, 2703.6161546756), new Vsop87.LnVsop(4.9E-10, 3.19808614252, 130652.81480330898), new Vsop87.LnVsop(6.7E-10, 0.59116991791, 94329.77528619739), new Vsop87.LnVsop(4.8E-10, 4.0538576567, 51955.39364070959), new Vsop87.LnVsop(5.4E-10, 1.48701637895, 136722.59155786238), new Vsop87.LnVsop(5.7E-10, 1.10836716608, 26102.1302355758), new Vsop87.LnVsop(5.0E-10, 5.32021242336, 103917.90082841998), new Vsop87.LnVsop(5.6E-10, 1.63440457571, 61.7259747402), new Vsop87.LnVsop(5.7E-10, 1.08524195162, 27972.80430499159), new Vsop87.LnVsop(5.1E-10, 4.31886984362, 58857.03113654799), new Vsop87.LnVsop(6.1E-10, 0.04364409986, 161079.37234650398), new Vsop87.LnVsop(4.6E-10, 2.24836751862, 425.908776514), new Vsop87.LnVsop(4.9E-10, 5.71448553374, 50380.54783942739), new Vsop87.LnVsop(4.8E-10, 0.40868412712, 27684.0895838588), new Vsop87.LnVsop(6.4E-10, 5.06730157028, 73.297125859), new Vsop87.LnVsop(5.3E-10, 3.2931443367, 207593.8465805002), new Vsop87.LnVsop(5.2E-10, 4.05836292463, 26010.1525975903), new Vsop87.LnVsop(4.6E-10, 5.69622642147, 129373.02023068098), new Vsop87.LnVsop(4.9E-10, 0.77406531565, 50689.82616208319), new Vsop87.LnVsop(4.7E-10, 4.71730919604, 50903.1252575212), new Vsop87.LnVsop(4.5E-10, 0.16928967852, 24918.31489016559), new Vsop87.LnVsop(4.5E-10, 4.07905982522, 52137.67324751059), new Vsop87.LnVsop(5.5E-10, 1.48552179353, 30171.8916482786), new Vsop87.LnVsop(4.3E-10, 1.05458495911, 51868.2486621788), new Vsop87.LnVsop(4.8E-10, 5.33528588129, 846.0828347512), new Vsop87.LnVsop(5.0E-10, 5.63036834479, 53906.92863608099), new Vsop87.LnVsop(4.3E-10, 0.58293994614, 1243.4876016784), new Vsop87.LnVsop(4.5E-10, 2.3475937356, 129387.24732468258), new Vsop87.LnVsop(5.1E-10, 2.87841847345, 27669.86248985719), new Vsop87.LnVsop(4.2E-10, 2.78081946255, 196137.07343261078), new Vsop87.LnVsop(4.4E-10, 3.49994820098, 26575.53789282839), new Vsop87.LnVsop(4.4E-10, 0.12140582521, 102659.44689679438), new Vsop87.LnVsop(4.5E-10, 2.04695118037, 27573.1938482774), new Vsop87.LnVsop(4.1E-10, 0.47941299466, 78338.49102328988), new Vsop87.LnVsop(4.7E-10, 1.92333552585, 50049.92887576919), new Vsop87.LnVsop(4.5E-10, 4.77215729269, 143005.6674078538), new Vsop87.LnVsop(5.4E-10, 1.46122428139, 28102.884813372), new Vsop87.LnVsop(4.2E-10, 1.9636129297, 27223.5800134674), new Vsop87.LnVsop(4.1E-10, 2.30268380021, 26709.6469424134), new Vsop87.LnVsop(4.1E-10, 1.92747555556, 3308.4658953804), new Vsop87.LnVsop(4.5E-10, 4.86855086637, 52483.36390411799), new Vsop87.LnVsop(4.3E-10, 0.50216349819, 80174.90890793978), new Vsop87.LnVsop(3.9E-10, 0.91312968484, 112231.70171963578), new Vsop87.LnVsop(4.3E-10, 3.10730855142, 26126.036177212), new Vsop87.LnVsop(5.3E-10, 5.56781441388, 123200.84011627098), new Vsop87.LnVsop(4.0E-10, 0.92168760069, 50910.238804522), new Vsop87.LnVsop(3.8E-10, 1.36640441348, 70269.18098269838), new Vsop87.LnVsop(4.3E-10, 2.46038752343, 65831.6667743248), new Vsop87.LnVsop(4.0E-10, 5.66552759512, 52174.32181044009), new Vsop87.LnVsop(4.1E-10, 0.24350307899, 742.9900605326), new Vsop87.LnVsop(3.7E-10, 5.02758418587, 24203.0019781568), new Vsop87.LnVsop(5.0E-10, 4.86639882575, 78153.50310350319), new Vsop87.LnVsop(3.8E-10, 0.49931267586, 103498.41618454478), new Vsop87.LnVsop(3.8E-10, 5.01896816519, 26402.0893214438), new Vsop87.LnVsop(4.4E-10, 2.59329487932, 6720.7139793414), new Vsop87.LnVsop(3.6E-10, 0.09348706711, 26118.2300025786), new Vsop87.LnVsop(3.9E-10, 5.17129107574, 151199.94274106238), new Vsop87.LnVsop(3.8E-10, 5.23608148918, 130289.95251073639), new Vsop87.LnVsop(3.6E-10, 0.02519747828, 2111.6503133776), new Vsop87.LnVsop(3.6E-10, 1.71850590197, 54374.8936264354), new Vsop87.LnVsop(4.5E-10, 4.12023391118, 25227.59321282139), new Vsop87.LnVsop(3.6E-10, 0.13280688272, 27351.06050415239), new Vsop87.LnVsop(3.5E-10, 4.16108423219, 2686.7220945412), new Vsop87.LnVsop(3.5E-10, 5.73702300793, 45290.65639321759), new Vsop87.LnVsop(3.8E-10, 3.17189584793, 78786.28684281638), new Vsop87.LnVsop(4.9E-10, 4.14640458599, 27170.98337386779), new Vsop87.LnVsop(3.8E-10, 5.6766266738, 166740.70439565618), new Vsop87.LnVsop(3.7E-10, 0.7653321708, 16703.062133499), new Vsop87.LnVsop(3.5E-10, 5.00372443548, 52509.6622239178), new Vsop87.LnVsop(4.2E-10, 1.5545674756, 130443.39704322898), new Vsop87.LnVsop(4.3E-10, 3.12511204668, 91805.13062721379), new Vsop87.LnVsop(3.4E-10, 4.65510552531, 77947.31755506598), new Vsop87.LnVsop(3.4E-10, 3.88709177637, 80382.47328510099), new Vsop87.LnVsop(3.9E-10, 2.12675603585, 3492.5715668696), new Vsop87.LnVsop(3.6E-10, 2.01530773081, 1162.4747044078), new Vsop87.LnVsop(3.3E-10, 0.74851795223, 25985.94062330859), new Vsop87.LnVsop(3.4E-10, 6.26508471441, 202.2533951741), new Vsop87.LnVsop(3.6E-10, 4.68450442674, 123668.80510662538), new Vsop87.LnVsop(3.3E-10, 3.05683945691, 2820.8311441262), new Vsop87.LnVsop(3.9E-10, 2.76389328557, 50270.341518208), new Vsop87.LnVsop(3.3E-10, 1.78770441039, 19336.86230122839), new Vsop87.LnVsop(4.2E-10, 3.12796548551, 130435.63437251298), new Vsop87.LnVsop(3.5E-10, 4.6569921639, 22003.9146348698), new Vsop87.LnVsop(3.7E-10, 6.01381885159, 26057.57628056979), new Vsop87.LnVsop(3.6E-10, 4.94463357606, 29396.3690369546), new Vsop87.LnVsop(4.1E-10, 5.09084582162, 145204.75475114078), new Vsop87.LnVsop(3.2E-10, 0.94969843186, 78580.10129437919), new Vsop87.LnVsop(4.4E-10, 0.0224858879, 25014.29411738339), new Vsop87.LnVsop(3.1E-10, 6.11767685934, 21716.0267748), new Vsop87.LnVsop(4.2E-10, 2.27375823663, 25169.9728555924), new Vsop87.LnVsop(3.6E-10, 3.78048388974, 8989.46770543239), new Vsop87.LnVsop(3.1E-10, 3.20777738129, 176332.24614102798), new Vsop87.LnVsop(4.2E-10, 1.80282357417, 103932.12792242158), new Vsop87.LnVsop(3.0E-10, 2.35954766344, 2383.1930147762), new Vsop87.LnVsop(3.4E-10, 5.35878796647, 26189.8656598398), new Vsop87.LnVsop(3.9E-10, 1.48269177389, 4022.2625319642), new Vsop87.LnVsop(3.0E-10, 1.47612019208, 233731.7463439786), new Vsop87.LnVsop(3.5E-10, 0.17499181765, 6129.2970395066), new Vsop87.LnVsop(3.8E-10, 1.08833775351, 25773.71696170459), new Vsop87.LnVsop(3.5E-10, 3.98231389633, 1300.826818205), new Vsop87.LnVsop(3.0E-10, 4.73794492601, 24072.9214697764), new Vsop87.LnVsop(2.9E-10, 2.49485056149, 102755.42612401219), new Vsop87.LnVsop(2.9E-10, 3.33146370824, 235900.50682626115), new Vsop87.LnVsop(3.0E-10, 0.63651362988, 35077.37084700659), new Vsop87.LnVsop(3.4E-10, 0.04811451681, 52177.29075585669), new Vsop87.LnVsop(3.5E-10, 4.36523032466, 81591.84508100279), new Vsop87.LnVsop(3.5E-10, 0.38273412507, 515.463871093), new Vsop87.LnVsop(4.0E-10, 3.08977629569, 8014.198202924), new Vsop87.LnVsop(4.0E-10, 0.60182722935, 24388.62392507099), new Vsop87.LnVsop(3.9E-10, 3.37554049867, 23549.6546373206), new Vsop87.LnVsop(3.8E-10, 4.59287461574, 26076.8574413103), new Vsop87.LnVsop(2.9E-10, 4.79176575333, 28736.3579670472), new Vsop87.LnVsop(3.4E-10, 2.41562403618, 61560.64729122359), new Vsop87.LnVsop(2.8E-10, 1.26404438296, 27044.1922975448), new Vsop87.LnVsop(3.1E-10, 3.42953745446, 24402.8510190726), new Vsop87.LnVsop(2.8E-10, 2.76913598494, 26312.2479372761), new Vsop87.LnVsop(2.9E-10, 3.06982412427, 76041.85279012559), new Vsop87.LnVsop(3.4E-10, 3.2374266617, 28791.5192962498), new Vsop87.LnVsop(3.0E-10, 1.64025002898, 163766.0944410452), new Vsop87.LnVsop(2.8E-10, 0.872429542, 128220.75860368418), new Vsop87.LnVsop(2.8E-10, 5.09736276985, 78213.71280281838), new Vsop87.LnVsop(3.7E-10, 0.28351092178, 78313.70604662679), new Vsop87.LnVsop(3.8E-10, 4.09691356449, 35833.2236974308), new Vsop87.LnVsop(3.1E-10, 0.65724812619, 1535.9767429694), new Vsop87.LnVsop(3.1E-10, 1.36667591862, 37698.4550999484), new Vsop87.LnVsop(2.7E-10, 0.27133102944, 50444.6839302158), new Vsop87.LnVsop(2.9E-10, 3.19360520586, 23762.9537327586), new Vsop87.LnVsop(3.1E-10, 5.97147065077, 122444.98726584678), new Vsop87.LnVsop(2.9E-10, 2.90797073636, 130866.11389874699), new Vsop87.LnVsop(3.1E-10, 4.69284912548, 27250.37784598199), new Vsop87.LnVsop(3.4E-10, 4.72391913604, 22065.64060961), new Vsop87.LnVsop(2.8E-10, 3.80715503127, 24513.057340292), new Vsop87.LnVsop(3.2E-10, 4.51091012068, 3776.4308857348), new Vsop87.LnVsop(2.7E-10, 1.41755601588, 52161.57918914679), new Vsop87.LnVsop(3.4E-10, 2.44729988472, 23336.3555418826), new Vsop87.LnVsop(3.1E-10, 6.18521142908, 102769.65321801379), new Vsop87.LnVsop(2.6E-10, 5.33349284702, 199599.31813847594), new Vsop87.LnVsop(3.1E-10, 4.33951803932, 52286.01260436779), new Vsop87.LnVsop(2.6E-10, 2.51322393927, 1353.7487450168), new Vsop87.LnVsop(2.6E-10, 0.99927277404, 1322.6776475314), new Vsop87.LnVsop(2.9E-10, 4.4362897672, 25450.90686955), new Vsop87.LnVsop(2.7E-10, 2.91198700644, 132028.58860315479), new Vsop87.LnVsop(2.6E-10, 2.03567536503, 52817.21984488739), new Vsop87.LnVsop(2.7E-10, 3.39103592839, 104819.57755665119), new Vsop87.LnVsop(2.5E-10, 1.75972456058, 78683.19406859778), new Vsop87.LnVsop(2.6E-10, 5.30421942727, 24864.08530079559), new Vsop87.LnVsop(2.6E-10, 5.36078058708, 412.3710968744), new Vsop87.LnVsop(2.6E-10, 2.0720043269, 25004.8229092806), new Vsop87.LnVsop(2.6E-10, 5.53069670975, 25657.37279743509), new Vsop87.LnVsop(3.1E-10, 4.78180598437, 75930.51303185058), new Vsop87.LnVsop(3.3E-10, 5.2271659763, 81604.32185142238), new Vsop87.LnVsop(3.2E-10, 2.69632977953, 25647.07785669659), new Vsop87.LnVsop(2.5E-10, 3.50647425364, 15406.65260500879), new Vsop87.LnVsop(3.2E-10, 5.18753945619, 2008.557539159), new Vsop87.LnVsop(2.6E-10, 1.17353987461, 153084.84390447979), new Vsop87.LnVsop(3.4E-10, 2.39619895259, 39763.43339365039), new Vsop87.LnVsop(2.5E-10, 3.04307664595, 26724.8994135984), new Vsop87.LnVsop(3.0E-10, 4.90635260381, 116783.65521669458), new Vsop87.LnVsop(2.5E-10, 1.59985699911, 31281.270200372), new Vsop87.LnVsop(2.7E-10, 5.86374680669, 5815.11085963699), new Vsop87.LnVsop(3.0E-10, 1.12362303179, 625.6701923124), new Vsop87.LnVsop(2.5E-10, 0.50599655672, 130446.62925487179), new Vsop87.LnVsop(2.4E-10, 3.36738491746, 133882.09065283637), new Vsop87.LnVsop(2.5E-10, 1.23585314301, 53.0961523144), new Vsop87.LnVsop(2.6E-10, 1.2161822966, 49976.71893986139), new Vsop87.LnVsop(2.3E-10, 4.72011826154, 198489.9395863826), new Vsop87.LnVsop(2.6E-10, 0.93376725671, 158746.17595363196), new Vsop87.LnVsop(2.9E-10, 2.71422590007, 25600.26839032), new Vsop87.LnVsop(2.3E-10, 1.46742391676, 1272.6810256272), new Vsop87.LnVsop(3.0E-10, 4.64969871478, 52027.72755872209), new Vsop87.LnVsop(2.3E-10, 0.95810401383, 28774.6252361154), new Vsop87.LnVsop(3.2E-10, 3.6905681104, 52024.75861330549), new Vsop87.LnVsop(3.1E-10, 3.86645564887, 25466.159340735), new Vsop87.LnVsop(2.4E-10, 3.15839525203, 77616.69859140778), new Vsop87.LnVsop(2.6E-10, 3.9390923007, 80596.9058175946), new Vsop87.LnVsop(2.4E-10, 1.30934055878, 163298.1294506908), new Vsop87.LnVsop(2.3E-10, 5.77389485042, 240452.46032331997), new Vsop87.LnVsop(2.2E-10, 1.95823889628, 177287.84588263658), new Vsop87.LnVsop(2.2E-10, 6.04180912528, 50007.0458008658), new Vsop87.LnVsop(2.2E-10, 2.96772486295, 12546.481939083), new Vsop87.LnVsop(2.2E-10, 3.02308458897, 39450.3528483734), new Vsop87.LnVsop(2.6E-10, 0.28424456166, 1265.5674786264), new Vsop87.LnVsop(2.1E-10, 6.03673087116, 27463.67694142), new Vsop87.LnVsop(2.1E-10, 1.44442495819, 5687.630368952), new Vsop87.LnVsop(2.1E-10, 0.22636621533, 52609.51802102519), new Vsop87.LnVsop(2.1E-10, 4.08328280632, 104358.2411251968), new Vsop87.LnVsop(2.1E-10, 3.98455360039, 6191.0230142468), new Vsop87.LnVsop(2.8E-10, 0.9328016777, 51841.950342379), new Vsop87.LnVsop(2.0E-10, 4.59350193239, 52061.40717623499), new Vsop87.LnVsop(2.1E-10, 5.71487101033, 2840.500905026), new Vsop87.LnVsop(2.3E-10, 0.43226688693, 24285.5311508524), new Vsop87.LnVsop(2.1E-10, 1.98572602434, 7392.4544020848), new Vsop87.LnVsop(2.4E-10, 0.82344555863, 2698.4514473772), new Vsop87.LnVsop(2.0E-10, 5.43337501787, 1485.9801210652), new Vsop87.LnVsop(2.5E-10, 5.01531560459, 101703.15774082378), new Vsop87.LnVsop(2.0E-10, 3.31281154655, 26248.310510959), new Vsop87.LnVsop(2.4E-10, 3.19969282574, 47803.9299163742), new Vsop87.LnVsop(2.0E-10, 5.21639602111, 76137.83201734339), new Vsop87.LnVsop(2.0E-10, 5.58624181701, 155887.52156313116), new Vsop87.LnVsop(2.1E-10, 3.09198846094, 26267.9802718588), new Vsop87.LnVsop(2.5E-10, 5.43422956232, 2.9689454166), new Vsop87.LnVsop(2.2E-10, 0.58074025919, 25672.35065096209), new Vsop87.LnVsop(2.6E-10, 1.34785586419, 309.2783226558), new Vsop87.LnVsop(2.1E-10, 6.10721760956, 24824.745778996), new Vsop87.LnVsop(2.0E-10, 2.62628682595, 164.43591058941), new Vsop87.LnVsop(2.0E-10, 1.38930287323, 952.0766232596), new Vsop87.LnVsop(1.9E-10, 3.02128285607, 9123.5767550174), new Vsop87.LnVsop(2.0E-10, 0.47663702299, 203041.8930834414), new Vsop87.LnVsop(2.1E-10, 4.32357573082, 183145.012956114), new Vsop87.LnVsop(2.2E-10, 1.67611192774, 23113.2931869632), new Vsop87.LnVsop(2.0E-10, 0.68567124507, 42.8830749034), new Vsop87.LnVsop(2.7E-10, 1.27457872442, 7860.4193924392), new Vsop87.LnVsop(2.5E-10, 3.05401652463, 76152.05911134499), new Vsop87.LnVsop(2.5E-10, 4.2352253696, 24952.226269681), new Vsop87.LnVsop(2.1E-10, 3.62099370643, 5635.0337293524), new Vsop87.LnVsop(2.1E-10, 4.44062433316, 25862.073873164), new Vsop87.LnVsop(2.0E-10, 2.13621746848, 26.2983197998), new Vsop87.LnVsop(1.9E-10, 4.16952441021, 24602.61243487099), new Vsop87.LnVsop(2.1E-10, 3.90484373725, 51534.3927214094), new Vsop87.LnVsop(2.6E-10, 2.47222104372, 25665.23710396129), new Vsop87.LnVsop(2.5E-10, 5.79456184716, 26098.9488418381), new Vsop87.LnVsop(1.9E-10, 4.95422682882, 209658.82487420217), new Vsop87.LnVsop(2.1E-10, 2.28837738298, 25865.04281858059), new Vsop87.LnVsop(1.8E-10, 0.50891176228, 52309.9153327334), new Vsop87.LnVsop(1.9E-10, 5.79715725254, 26279.35140768579), new Vsop87.LnVsop(2.5E-10, 4.73465324099, 391318.54712361295), new Vsop87.LnVsop(1.9E-10, 1.23662681079, 52179.73843641149), new Vsop87.LnVsop(1.8E-10, 1.52837590084, 107.3053069296), new Vsop87.LnVsop(1.9E-10, 0.76735048216, 52396.2189255872), new Vsop87.LnVsop(1.9E-10, 1.5509604073, 148.0787244263), new Vsop87.LnVsop(2.1E-10, 6.27787013701, 54344.56676543099), new Vsop87.LnVsop(2.5E-10, 5.13456064718, 12382.0460284936), new Vsop87.LnVsop(2.2E-10, 4.76661068718, 48847.6706268682), new Vsop87.LnVsop(1.9E-10, 5.02228884604, 26114.201461374), new Vsop87.LnVsop(1.8E-10, 2.45809868831, 50264.6067999312), new Vsop87.LnVsop(2.2E-10, 3.85509627645, 6885.14988993081), new Vsop87.LnVsop(2.0E-10, 0.64660197557, 77940.20400806518), new Vsop87.LnVsop(2.0E-10, 2.79332004367, 25927.49577218939), new Vsop87.LnVsop(1.8E-10, 5.83348216244, 293.4107843772), new Vsop87.LnVsop(2.3E-10, 4.64720241213, 112545.88789950538), new Vsop87.LnVsop(1.8E-10, 0.60198526172, 27566.76971563859), new Vsop87.LnVsop(2.0E-10, 2.63916620118, 7768.3665566946), new Vsop87.LnVsop(2.0E-10, 0.71397154242, 959.1228599576), new Vsop87.LnVsop(1.9E-10, 1.79653943961, 89.485747846), new Vsop87.LnVsop(2.1E-10, 1.51443251611, 208173.534167499), new Vsop87.LnVsop(2.1E-10, 4.16640140039, 2125.8774073792), new Vsop87.LnVsop(1.8E-10, 1.11242384108, 87367.61641884019), new Vsop87.LnVsop(2.0E-10, 5.93006048006, 11852.355063399), new Vsop87.LnVsop(1.7E-10, 3.9396691497, 25459.05155552409), new Vsop87.LnVsop(2.3E-10, 2.99103906198, 23446.561863102), new Vsop87.LnVsop(1.8E-10, 0.74408260155, 1795.258443721), new Vsop87.LnVsop(2.0E-10, 0.59479884317, 95.9792272178), new Vsop87.LnVsop(2.1E-10, 1.90510484926, 193937.9860893238), new Vsop87.LnVsop(2.1E-10, 3.0156672555, 25907.8260112896), new Vsop87.LnVsop(1.8E-10, 3.09035824301, 838.9692877504), new Vsop87.LnVsop(1.7E-10, 6.26002814839, 233681.74972207437), new Vsop87.LnVsop(1.6E-10, 1.73589266057, 52911.68279668019), new Vsop87.LnVsop(1.7E-10, 4.10264599764, 189386.03259226496), new Vsop87.LnVsop(2.1E-10, 0.43840312896, 55638.05098901359), new Vsop87.LnVsop(1.6E-10, 2.13276366606, 16342.5825857176), new Vsop87.LnVsop(1.9E-10, 5.53134137122, 9591.5417453718), new Vsop87.LnVsop(1.6E-10, 1.15891409897, 237009.88537835455), new Vsop87.LnVsop(1.6E-10, 2.62905988628, 191.4482661116), new Vsop87.LnVsop(1.6E-10, 4.3675180121, 120417.67842777158), new Vsop87.LnVsop(2.0E-10, 1.12978867673, 25650.2592504343), new Vsop87.LnVsop(1.6E-10, 4.29882054111, 76255.15188556358), new Vsop87.LnVsop(1.6E-10, 1.14702353715, 53399.624123927), new Vsop87.LnVsop(1.6E-10, 3.57235087963, 103718.82882698359), new Vsop87.LnVsop(1.7E-10, 5.76960454227, 51130.65144696079), new Vsop87.LnVsop(1.6E-10, 4.53670173929, 2667.0523336414), new Vsop87.LnVsop(2.1E-10, 0.46791872189, 19367.1891622328), new Vsop87.LnVsop(1.8E-10, 5.19929902272, 2544.6726368924), new Vsop87.LnVsop(1.5E-10, 3.98281479283, 230239.17477710897), new Vsop87.LnVsop(1.7E-10, 4.87067876483, 45424.76544280259), new Vsop87.LnVsop(1.5E-10, 0.79205322004, 25928.601406782), new Vsop87.LnVsop(1.7E-10, 2.81666385261, 102975.83876645098), new Vsop87.LnVsop(1.5E-10, 4.5278992739, 25984.1209529936), new Vsop87.LnVsop(2.0E-10, 5.26775931269, 60370.08161635699), new Vsop87.LnVsop(1.6E-10, 0.88949240489, 156314.1197540072), new Vsop87.LnVsop(1.5E-10, 3.38506105616, 129586.31932611899), new Vsop87.LnVsop(1.9E-10, 5.28475048168, 154408.65498906677), new Vsop87.LnVsop(1.5E-10, 4.71428343288, 2974.609954611), new Vsop87.LnVsop(1.8E-10, 4.01766399485, 51876.67988887919), new Vsop87.LnVsop(1.5E-10, 0.63968350199, 53093.73656913019), new Vsop87.LnVsop(2.0E-10, 5.58915267196, 1423.564731963), new Vsop87.LnVsop(1.5E-10, 3.27898899275, 117893.03376878797), new Vsop87.LnVsop(1.6E-10, 0.20415665801, 41494.55574658299), new Vsop87.LnVsop(1.7E-10, 1.8500346618, 102872.74599223239), new Vsop87.LnVsop(1.5E-10, 1.38086670918, 77417.62658997139), new Vsop87.LnVsop(1.6E-10, 2.32863321036, 181659.72224941078), new Vsop87.LnVsop(1.7E-10, 5.37350443158, 25384.26995695679), new Vsop87.LnVsop(2.0E-10, 3.626908378, 48997.6604925808), new Vsop87.LnVsop(1.5E-10, 3.10421184998, 128747.35003836859), new Vsop87.LnVsop(1.8E-10, 4.06067303164, 51439.92976961659), new Vsop87.LnVsop(1.6E-10, 2.42412026249, 128106.31931499895), new Vsop87.LnVsop(1.7E-10, 1.33866516494, 103395.32341032618), new Vsop87.LnVsop(1.6E-10, 3.64720066701, 24072.23205541439), new Vsop87.LnVsop(1.5E-10, 2.96793644807, 24719.24288872919), new Vsop87.LnVsop(1.4E-10, 2.19807995874, 50951.98844236979), new Vsop87.LnVsop(1.4E-10, 1.98624084691, 225687.22128005017), new Vsop87.LnVsop(1.4E-10, 5.35774038541, 896.0794566554), new Vsop87.LnVsop(1.4E-10, 4.49215712633, 57503.2823915312), new Vsop87.LnVsop(1.7E-10, 0.94769327499, 104344.98400739678), new Vsop87.LnVsop(1.4E-10, 2.6181860405, 151.0476698429), new Vsop87.LnVsop(1.4E-10, 2.15994876258, 104276.83096772949), new Vsop87.LnVsop(1.9E-10, 4.6170254761, 16028.396405848), new Vsop87.LnVsop(1.4E-10, 4.46499375434, 208276.62694171758), new Vsop87.LnVsop(1.4E-10, 5.03809675504, 53029.0026649004), new Vsop87.LnVsop(1.4E-10, 3.98620415374, 263097.78851992876), new Vsop87.LnVsop(1.6E-10, 2.13499283716, 78129.60037513758), new Vsop87.LnVsop(1.6E-10, 1.96317271676, 183674.70392120857), new Vsop87.LnVsop(1.4E-10, 0.54684500137, 138319.60486120995), new Vsop87.LnVsop(1.6E-10, 2.76397470223, 46046.5092436418), new Vsop87.LnVsop(1.4E-10, 5.52483338141, 130363.24963659538), new Vsop87.LnVsop(1.3E-10, 0.79709975404, 78225.57638908479), new Vsop87.LnVsop(1.3E-10, 0.98317849568, 103189.13786188899), new Vsop87.LnVsop(1.9E-10, 4.91561037107, 277.0349937414), new Vsop87.LnVsop(1.4E-10, 2.61194442842, 7830.0925314348), new Vsop87.LnVsop(1.4E-10, 5.00788361103, 144916.86689107097), new Vsop87.LnVsop(1.4E-10, 0.85520701494, 78043.29678228378), new Vsop87.LnVsop(1.5E-10, 1.37228117638, 18043.37807764579), new Vsop87.LnVsop(1.3E-10, 4.33964770436, 117.3198682202), new Vsop87.LnVsop(1.4E-10, 3.64749226957, 78484.12206716138), new Vsop87.LnVsop(1.4E-10, 4.75183782414, 78999.58593825439), new Vsop87.LnVsop(1.7E-10, 5.387795461, 52041.69723356339), new Vsop87.LnVsop(1.8E-10, 3.66718937351, 104028.10714963939), new Vsop87.LnVsop(1.3E-10, 6.00410401507, 28908.7342857004), new Vsop87.LnVsop(1.7E-10, 2.88265913843, 128857.55635958798), new Vsop87.LnVsop(1.4E-10, 1.73651187343, 2912.8839798708), new Vsop87.LnVsop(1.3E-10, 2.10940309095, 77314.53381575279), new Vsop87.LnVsop(1.3E-10, 4.28715947323, 190809.59732422797), new Vsop87.LnVsop(1.3E-10, 5.75312146188, 222224.97657418498), new Vsop87.LnVsop(1.5E-10, 3.12808384217, 173.44857138459), new Vsop87.LnVsop(1.6E-10, 5.33449282836, 25970.58327335399), new Vsop87.LnVsop(1.3E-10, 2.93774353095, 533.6231183577), new Vsop87.LnVsop(1.6E-10, 0.76587038276, 557.4507382004), new Vsop87.LnVsop(1.8E-10, 2.30655980174, 77520.71936418998), new Vsop87.LnVsop(1.3E-10, 0.04322502004, 54879.422437824), new Vsop87.LnVsop(1.5E-10, 0.93774708323, 461.3364314544), new Vsop87.LnVsop(1.5E-10, 6.0155240016, 51112.49219969609), new Vsop87.LnVsop(1.2E-10, 4.96649539823, 50536.73676596039), new Vsop87.LnVsop(1.3E-10, 5.79333684284, 1685.0521225016), new Vsop87.LnVsop(1.3E-10, 3.37185657268, 79212.88503369238), new Vsop87.LnVsop(1.4E-10, 5.7542133204, 72134.41238521598), new Vsop87.LnVsop(1.7E-10, 0.64086930843, 5131.6410840576), new Vsop87.LnVsop(1.2E-10, 6.24722203509, 49850.85687433279), new Vsop87.LnVsop(1.3E-10, 1.38408689559, 4885.8094378282), new Vsop87.LnVsop(1.2E-10, 6.17819404999, 78413.27262185719), new Vsop87.LnVsop(1.2E-10, 1.86846407635, 102225.73515891758), new Vsop87.LnVsop(1.2E-10, 6.15305377435, 35211.47989659159), new Vsop87.LnVsop(1.2E-10, 0.60231036252, 156520.30530244438), new Vsop87.LnVsop(1.3E-10, 4.53618198307, 56259.79478985279), new Vsop87.LnVsop(1.3E-10, 3.44123266792, 27623.8798845436), new Vsop87.LnVsop(1.2E-10, 5.14707166267, 103402.43695732698), new Vsop87.LnVsop(1.2E-10, 3.67164611321, 79181.63971070439), new Vsop87.LnVsop(1.4E-10, 2.94493679739, 51120.35650622229), new Vsop87.LnVsop(1.4E-10, 4.85835532315, 207114.15223730978), new Vsop87.LnVsop(1.4E-10, 5.14050840336, 726.4820198702), new Vsop87.LnVsop(1.2E-10, 2.50220281722, 26183.88236879199), new Vsop87.LnVsop(1.2E-10, 5.13091142343, 203375.74902421076), new Vsop87.LnVsop(1.6E-10, 0.78825622002, 53814.87580033639), new Vsop87.LnVsop(1.5E-10, 0.44405836757, 2751.5475996916), new Vsop87.LnVsop(1.2E-10, 2.82956991193, 26290.15653674829), new Vsop87.LnVsop(1.2E-10, 2.84166479969, 25885.64974640009), new Vsop87.LnVsop(1.3E-10, 3.00745306846, 79315.97780791098), new Vsop87.LnVsop(1.3E-10, 1.8839513767, 26161.20026743319), new Vsop87.LnVsop(1.3E-10, 1.01105657732, 156507.7490885454), new Vsop87.LnVsop(1.3E-10, 1.24212367708, 4437.51420837359), new Vsop87.LnVsop(1.2E-10, 5.92057732534, 129063.74190802519), new Vsop87.LnVsop(1.5E-10, 1.46838291003, 103883.64757594238), new Vsop87.LnVsop(1.2E-10, 5.75930846692, 79330.20490191258), new Vsop87.LnVsop(1.4E-10, 0.83818630211, 215473.93573383917), new Vsop87.LnVsop(1.2E-10, 1.60578990904, 171004.7700326452), new Vsop87.LnVsop(1.2E-10, 2.95802141114, 182828.62108645737), new Vsop87.LnVsop(1.3E-10, 2.19092122373, 51745.27593900929), new Vsop87.LnVsop(1.2E-10, 5.23164825285, 26411.4085582316), new Vsop87.LnVsop(1.2E-10, 4.69895639838, 259819.64948555277), new Vsop87.LnVsop(1.2E-10, 0.75426704696, 75085.56363415498), new Vsop87.LnVsop(1.1E-10, 4.28892572, 78267.64157798568), new Vsop87.LnVsop(1.4E-10, 2.98871686554, 1073.6090241908), new Vsop87.LnVsop(1.2E-10, 4.61671703735, 57369.17334194619), new Vsop87.LnVsop(1.5E-10, 2.9075758982, 187167.2754880782), new Vsop87.LnVsop(1.1E-10, 5.43931897089, 181548.82651382938), new Vsop87.LnVsop(1.3E-10, 3.80987567817, 79902.77894191058), new Vsop87.LnVsop(1.1E-10, 3.97843637033, 76998.14194609619), new Vsop87.LnVsop(1.2E-10, 4.40009190504, 133767.65136415116), new Vsop87.LnVsop(1.1E-10, 1.83887545163, 70069.43409151399), new Vsop87.LnVsop(1.5E-10, 3.94865416467, 27665.246684022), new Vsop87.LnVsop(1.3E-10, 5.32692215409, 103608.62250576419), new Vsop87.LnVsop(1.3E-10, 2.57664086838, 1116.4920990942), new Vsop87.LnVsop(1.1E-10, 2.0817877642, 181563.05360783098), new Vsop87.LnVsop(1.1E-10, 6.16260267843, 103704.60173298199), new Vsop87.LnVsop(1.3E-10, 2.57288307747, 52186.8519834123), new Vsop87.LnVsop(1.2E-10, 4.53320021239, 30110.1656735384), new Vsop87.LnVsop(1.1E-10, 0.4239273351, 289185.69166150293), new Vsop87.LnVsop(1.3E-10, 3.08655281854, 27353.47062020059), new Vsop87.LnVsop(1.1E-10, 5.31849553869, 128843.32926558638), new Vsop87.LnVsop(1.5E-10, 1.73060252282, 114.3991069134), new Vsop87.LnVsop(1.4E-10, 0.92426206484, 1577.3435424478), new Vsop87.LnVsop(1.1E-10, 5.29480881265, 52797.55008398759), new Vsop87.LnVsop(1.1E-10, 4.68388844445, 77684.02183772379), new Vsop87.LnVsop(1.3E-10, 4.84220246179, 79353.41821591619), new Vsop87.LnVsop(1.3E-10, 0.54230990449, 50600.9604818662), new Vsop87.LnVsop(1.2E-10, 0.31807521148, 78469.89497315978), new Vsop87.LnVsop(1.1E-10, 0.00425376917, 90989.16285949759), new Vsop87.LnVsop(1.4E-10, 2.98013751433, 51102.19725895759), new Vsop87.LnVsop(1.1E-10, 3.59702354156, 1905.4647649404), new Vsop87.LnVsop(1.1E-10, 3.26875143851, 143980.93691036216), new Vsop87.LnVsop(1.5E-10, 4.29683167838, 52171.87412988529), new Vsop87.LnVsop(1.1E-10, 4.72219805551, 80462.79676800959), new Vsop87.LnVsop(1.2E-10, 3.49543725775, 241561.83887541335), new Vsop87.LnVsop(1.1E-10, 1.2721993926, 78843.39701172139), new Vsop87.LnVsop(1.5E-10, 4.82058460939, 77741.13200662879), new Vsop87.LnVsop(1.1E-10, 1.83973749004, 154194.22245657316), new Vsop87.LnVsop(1.1E-10, 2.94887593762, 5039.588248313), new Vsop87.LnVsop(1.1E-10, 1.06186939541, 216897.50046580215), new Vsop87.LnVsop(1.4E-10, 2.07353096792, 130542.60848208958), new Vsop87.LnVsop(1.1E-10, 1.72854679046, 76624.63990753458), new Vsop87.LnVsop(1.3E-10, 1.92207364074, 2962.880601775), new Vsop87.LnVsop(1.1E-10, 6.13912703925, 154835.25317994278), new Vsop87.LnVsop(1.1E-10, 2.76325252261, 25572.43927048119), new Vsop87.LnVsop(1.2E-10, 4.55048857833, 52755.49387014719), new Vsop87.LnVsop(1.2E-10, 4.51348351634, 54190.78795494619), new Vsop87.LnVsop(1.1E-10, 2.78880372821, 76094.94894244), new Vsop87.LnVsop(1.1E-10, 5.78732279706, 76358.24465978218), new Vsop87.LnVsop(1.2E-10, 6.17213642404, 104127.26777059489), new Vsop87.LnVsop(1.1E-10, 1.27458486402, 82347.69793142698), new Vsop87.LnVsop(1.0E-10, 0.05959891479, 261988.40996783535), new Vsop87.LnVsop(1.0E-10, 6.12251295566, 156740.7179448832), new Vsop87.LnVsop(1.1E-10, 1.80239315901, 78800.51393681798), new Vsop87.LnVsop(1.0E-10, 0.1880095628, 155674.22246769318), new Vsop87.LnVsop(1.0E-10, 0.25622286707, 52663.44103440259), new Vsop87.LnVsop(1.4E-10, 3.41659141429, 26603.3670126672), new Vsop87.LnVsop(1.0E-10, 4.66171161353, 197092.67317421938), new Vsop87.LnVsop(1.1E-10, 5.43581617959, 4398.17468657401), new Vsop87.LnVsop(1.5E-10, 5.81769607175, 102239.96225291918), new Vsop87.LnVsop(1.1E-10, 3.08658188433, 80432.46990700519), new Vsop87.LnVsop(1.0E-10, 4.59460664618, 104659.17018726638), new Vsop87.LnVsop(1.2E-10, 0.33304920988, 142871.55835826878), new Vsop87.LnVsop(1.1E-10, 2.04909853861, 26933.9859763254), new Vsop87.LnVsop(1.0E-10, 4.99843585518, 42430.4857272918), new Vsop87.LnVsop(1.2E-10, 5.87342153519, 156954.01704032117), new Vsop87.LnVsop(1.0E-10, 0.94936373883, 102343.05502713779), new Vsop87.LnVsop(1.1E-10, 0.51569476586, 210614.42461581077), new Vsop87.LnVsop(1.4E-10, 4.15042375832, 52190.03337714999), new Vsop87.LnVsop(1.1E-10, 2.31402246192, 130336.42293365239), new Vsop87.LnVsop(1.0E-10, 0.7765192935, 104044.0549453272), new Vsop87.LnVsop(1.1E-10, 3.4575662509, 50373.43429242659), new Vsop87.LnVsop(1.2E-10, 5.4454978303, 56777.7564021114), new Vsop87.LnVsop(1.2E-10, 2.53814691384, 248312.87971575916), new Vsop87.LnVsop(1.1E-10, 5.81248587528, 51688.1715318942), new Vsop87.LnVsop(1.0E-10, 5.02934387609, 63.7358983034), new Vsop87.LnVsop(1.1E-10, 1.48790524324, 58220.0348645238), new Vsop87.LnVsop(1.3E-10, 1.73084719204, 55484.27217852879), new Vsop87.LnVsop(1.0E-10, 3.07696158333, 259769.65286364855), new Vsop87.LnVsop(1.4E-10, 0.80260135302, 77527.83291119078), new Vsop87.LnVsop(1.0E-10, 5.92438780788, 102129.75593169978), new Vsop87.LnVsop(1.4E-10, 0.09133406732, 138.5174968707), new Vsop87.LnVsop(1.2E-10, 1.46736907113, 76991.02839909539), new Vsop87.LnVsop(1.1E-10, 3.69737943157, 60170.3347251726), new Vsop87.LnVsop(1.1E-10, 0.91716465178, 103829.03514820298), new Vsop87.LnVsop(1.2E-10, 2.48001423636, 76468.45098100159), new Vsop87.LnVsop(1.2E-10, 3.63244499225, 50476.52706664519), new Vsop87.LnVsop(1.2E-10, 0.15820265323, 49637.55777889479), new Vsop87.LnVsop(1.3E-10, 2.21304135803, 287.8878600698), new Vsop87.LnVsop(1.1E-10, 3.04909618741, 156547.08861034497), new Vsop87.LnVsop(1.3E-10, 5.42354700318, 51753.14024553549), new Vsop87.LnVsop(1.4E-10, 2.17544501087, 2506.6449642566), new Vsop87.LnVsop(1.0E-10, 2.03757692776, 78885.45322556178), new Vsop87.LnVsop(1.2E-10, 6.1843589348, 103814.80805420138), new Vsop87.LnVsop(1.0E-10, 5.01102689994, 53311.4831550416), new Vsop87.LnVsop(1.1E-10, 2.67328823906, 26734.913974889), new Vsop87.LnVsop(1.3E-10, 2.15288344965, 82865.65954368559), new Vsop87.LnVsop(1.1E-10, 2.26046112925, 74801.46471885739), new Vsop87.LnVsop(1.2E-10, 0.91311461577, 53258.88651544199), new Vsop87.LnVsop(1.0E-10, 5.07907315221, 156093.7071115684), new Vsop87.LnVsop(1.2E-10, 6.05275501244, 105403.88094948517), new Vsop87.LnVsop(1.1E-10, 5.19596855548, 104454.70534051539), new Vsop87.LnVsop(1.1E-10, 5.87059533653, 158116.491744729), new Vsop87.LnVsop(1.1E-10, 0.38514839596, 53124.98189211819), new Vsop87.LnVsop(1.0E-10, 1.59386679469, 51596.1186961496), new Vsop87.LnVsop(1.0E-10, 4.41461079699, 257436.45647077652), new Vsop87.LnVsop(1.4E-10, 1.74381856487, 36.6485629295), new Vsop87.LnVsop(1.0E-10, 1.24965183253, 80278.69109652039), new Vsop87.LnVsop(1.0E-10, 0.6174165217, 149846.1939960456), new Vsop87.LnVsop(1.2E-10, 2.869185171, 2045.3085328022), new Vsop87.LnVsop(1.0E-10, 5.38944159655, 77.7505439839), new Vsop87.LnVsop(1.0E-10, 3.80043163945, 104313.47953065898), new Vsop87.LnVsop(1.4E-10, 6.10459624713, 454.9093665273), new Vsop87.LnVsop(1.1E-10, 1.99827759086, 1088.603156601), new Vsop87.LnVsop(1.1E-10, 2.62058705881, 153186.8064227454), new Vsop87.LnVsop(1.0E-10, 2.4141774363, 155460.9233722552), new Vsop87.LnVsop(1.0E-10, 4.48839233108, 180282.12559814737), new Vsop87.LnVsop(1.0E-10, 1.76037317626, 52489.992463018), new Vsop87.LnVsop(1.3E-10, 4.11972652561, 54060.70744656579), new Vsop87.LnVsop(1.0E-10, 3.55061763662, 78397.81847430758), new Vsop87.LnVsop(1.2E-10, 3.8188385636, 76777.72930365738), new Vsop87.LnVsop(1.0E-10, 4.45423293249, 5469.8837830406), new Vsop87.LnVsop(1.0E-10, 0.26898429031, 5019.9184874132), new Vsop87.LnVsop(1.0E-10, 2.26378618368, 179172.74704605396), new Vsop87.LnVsop(1.0E-10, 3.66756317752, 175934.09713761977), new Vsop87.LnVsop(1.1E-10, 4.42724223352, 103505.52973154558), new Vsop87.LnVsop(9.0E-11, 5.26539502261, 130285.73689738619), new Vsop87.LnVsop(1.0E-10, 3.94785662225, 54862.5283776896), new Vsop87.LnVsop(1.2E-10, 1.55587525404, 74935.5737684424), new Vsop87.LnVsop(9.0E-11, 0.3616407666, 1045.1548361876), new Vsop87.LnVsop(9.0E-11, 6.21588367959, 54397.66291774539), new Vsop87.LnVsop(1.3E-10, 2.54150715208, 23735.03698780239), new Vsop87.LnVsop(9.0E-11, 5.54583366059, 53867.97195265079), new Vsop87.LnVsop(1.0E-10, 5.50923146669, 130593.29451835579), new Vsop87.LnVsop(1.0E-10, 1.41367771097, 48091.817776444), new Vsop87.LnVsop(9.0E-11, 0.13225241168, 52918.796343681), new Vsop87.LnVsop(9.0E-11, 1.67266340956, 231348.55332920235), new Vsop87.LnVsop(1.0E-10, 1.53965688146, 156107.93420556997), new Vsop87.LnVsop(1.1E-10, 3.53206613269, 51760.25379253629), new Vsop87.LnVsop(9.0E-11, 3.84605705988, 154308.6617452584), new Vsop87.LnVsop(9.0E-11, 3.21918850161, 51006.21803173979), new Vsop87.LnVsop(1.1E-10, 0.73383746517, 17605.7399482958), new Vsop87.LnVsop(9.0E-11, 3.11807738536, 52206.1331441528), new Vsop87.LnVsop(9.0E-11, 1.44205716141, 106550.69990958378), new Vsop87.LnVsop(1.1E-10, 0.987406157, 78259.77727145949), new Vsop87.LnVsop(9.0E-11, 5.3512338511, 155475.15046625677), new Vsop87.LnVsop(9.0E-11, 5.13834653276, 205260.65018762814), new Vsop87.LnVsop(9.0E-11, 1.2423863622, 234364.53008329176), new Vsop87.LnVsop(9.0E-11, 2.36679030684, 181975.4247047054), new Vsop87.LnVsop(1.1E-10, 3.44695207326, 189853.99758261937), new Vsop87.LnVsop(9.0E-11, 3.493274303, 156534.53239644598), new Vsop87.LnVsop(1.1E-10, 3.71214400776, 27883.16158529519), new Vsop87.LnVsop(9.0E-11, 1.31408788661, 223180.57631579356), new Vsop87.LnVsop(1.0E-10, 3.84128789715, 104131.19992385797), new Vsop87.LnVsop(1.1E-10, 4.08487611085, 78378.1487134078), new Vsop87.LnVsop(9.0E-11, 4.42707219551, 6751.0408403458), new Vsop87.LnVsop(1.1E-10, 0.77879332032, 80148.61058813999), new Vsop87.LnVsop(9.0E-11, 0.8621429687, 50690.51557644519), new Vsop87.LnVsop(1.0E-10, 5.91391218935, 2538.2485042536), new Vsop87.LnVsop(1.0E-10, 5.18315351919, 1382.1979324846), new Vsop87.LnVsop(1.0E-10, 3.50888471315, 45455.092303807), new Vsop87.LnVsop(9.0E-11, 2.9638036981, 25991.92391435639), new Vsop87.LnVsop(9.0E-11, 0.12768153485, 27993.3679065146), new Vsop87.LnVsop(1.1E-10, 0.86259686023, 78277.9365187242), new Vsop87.LnVsop(1.0E-10, 1.97201206656, 52499.31169980579), new Vsop87.LnVsop(9.0E-11, 3.32039369507, 61165.27398858079), new Vsop87.LnVsop(9.0E-11, 1.76555912471, 235746.72801577637), new Vsop87.LnVsop(1.1E-10, 0.24999283383, 117077.06600107178), new Vsop87.LnVsop(1.1E-10, 2.52816309211, 79845.66877300559), new Vsop87.LnVsop(1.1E-10, 1.61182880702, 104241.40624507738), new Vsop87.LnVsop(9.0E-11, 0.74096037377, 153878.9640239722), new Vsop87.LnVsop(1.2E-10, 5.83966176266, 11790.6290886588), new Vsop87.LnVsop(1.0E-10, 0.18030878839, 71542.99544538118), new Vsop87.LnVsop(1.1E-10, 4.45519879833, 162810.49469943656), new Vsop87.LnVsop(9.0E-11, 2.18403728707, 71378.55953479178), new Vsop87.LnVsop(1.2E-10, 5.23790242966, 29580.4747084438), new Vsop87.LnVsop(1.0E-10, 6.01456569334, 213255.1786296524), new Vsop87.LnVsop(1.1E-10, 3.67835925409, 22595.33157470459), new Vsop87.LnVsop(9.0E-11, 0.49720666294, 104984.39630560997), new Vsop87.LnVsop(1.1E-10, 5.30179052357, 51257.8759971666), new Vsop87.LnVsop(9.0E-11, 3.34551904925, 40738.70289615879), new Vsop87.LnVsop(1.0E-10, 0.84359833351, 61921.12683900499), new Vsop87.LnVsop(1.0E-10, 0.88211385824, 51315.49635439559), new Vsop87.LnVsop(1.0E-10, 2.29548861266, 1211.341070359), new Vsop87.LnVsop(8.0E-11, 3.27342696125, 78751.34417597679), new Vsop87.LnVsop(9.0E-11, 2.9230508237, 182611.44065566137), new Vsop87.LnVsop(1.0E-10, 0.17758007636, 50490.75416064679), new Vsop87.LnVsop(8.0E-11, 5.04021823877, 78905.12298646157), new Vsop87.LnVsop(1.0E-10, 4.16632261841, 1130.1539475858), new Vsop87.LnVsop(1.0E-10, 1.35239689601, 48153.54375118419), new Vsop87.LnVsop(9.0E-11, 2.28938084617, 79994.83177765518), new Vsop87.LnVsop(8.0E-11, 4.78894704907, 78577.8956045922), new Vsop87.LnVsop(9.0E-11, 1.74700345208, 417406.4502651872), new Vsop87.LnVsop(8.0E-11, 2.07572920434, 130005.80396999417), new Vsop87.LnVsop(8.0E-11, 3.77310827048, 52073.84376488279), new Vsop87.LnVsop(8.0E-11, 1.95594241501, 156377.8556523106), new Vsop87.LnVsop(1.1E-10, 4.91839370629, 128960.64913380658), new Vsop87.LnVsop(8.0E-11, 3.31138265156, 28309.75977617119), new Vsop87.LnVsop(1.1E-10, 5.32356537706, 49424.25868345679), new Vsop87.LnVsop(8.0E-11, 2.26325075185, 299.1263942692), new Vsop87.LnVsop(8.0E-11, 5.50980958231, 48713.5615772832), new Vsop87.LnVsop(1.1E-10, 6.05884458684, 78057.52387628538), new Vsop87.LnVsop(8.0E-11, 0.74893403497, 103086.04508767038), new Vsop87.LnVsop(1.0E-10, 5.24386890264, 860.3099287528), new Vsop87.LnVsop(9.0E-11, 3.53361712213, 1169.5882514086), new Vsop87.LnVsop(9.0E-11, 5.69975856885, 27441.651886591), new Vsop87.LnVsop(8.0E-11, 0.40730399, 5852.7803152638), new Vsop87.LnVsop(8.0E-11, 4.15882544767, 79487.5272655012), new Vsop87.LnVsop(9.0E-11, 2.19047368741, 174620.79354899516), new Vsop87.LnVsop(8.0E-11, 5.10790930441, 278972.40611529193), new Vsop87.LnVsop(9.0E-11, 1.39060893451, 78149.27013603736), new Vsop87.LnVsop(1.0E-10, 1.4491858653, 285907.552627127), new Vsop87.LnVsop(1.1E-10, 0.82192814161, 52098.05573916449), new Vsop87.LnVsop(8.0E-11, 5.87534994551, 127098.90328117118), new Vsop87.LnVsop(8.0E-11, 3.51413526661, 104426.39416486409), new Vsop87.LnVsop(9.0E-11, 5.16378342721, 130364.73410930368), new Vsop87.LnVsop(1.0E-10, 5.09176211486, 53661.0969898516), new Vsop87.LnVsop(1.0E-10, 4.71864870979, 1865.2314025176), new Vsop87.LnVsop(1.0E-10, 3.442606382, 81725.95413058778), new Vsop87.LnVsop(8.0E-11, 2.89381740957, 247223.17092456558), new Vsop87.LnVsop(8.0E-11, 1.50495995792, 50160.82461135059), new Vsop87.LnVsop(8.0E-11, 5.93652948222, 31127.49138988719), new Vsop87.LnVsop(1.1E-10, 1.8865504316, 53265.515074342), new Vsop87.LnVsop(8.0E-11, 5.51368993901, 104248.51979207818), new Vsop87.LnVsop(8.0E-11, 2.2652560652, 79955.87509422498), new Vsop87.LnVsop(9.0E-11, 1.58093065123, 224577.84272795677), new Vsop87.LnVsop(8.0E-11, 3.29049117119, 104557.79811473397), new Vsop87.LnVsop(8.0E-11, 3.9836045103, 182402.02289558138), new Vsop87.LnVsop(1.1E-10, 2.68727695708, 31903.01400121119), new Vsop87.LnVsop(9.0E-11, 5.43307011162, 65851.33653522459), new Vsop87.LnVsop(1.1E-10, 0.51898586475, 129806.73196855778), new Vsop87.LnVsop(8.0E-11, 4.45045824026, 175844.61138977378), new Vsop87.LnVsop(9.0E-11, 1.36295509329, 78115.63070029629), new Vsop87.LnVsop(9.0E-11, 5.08922937782, 62197.64356324779), new Vsop87.LnVsop(9.0E-11, 1.19274985025, 106262.81204951399), new Vsop87.LnVsop(1.0E-10, 3.84482406254, 199.0720014364), new Vsop87.LnVsop(8.0E-11, 4.31142679779, 76064.62208143558), new Vsop87.LnVsop(8.0E-11, 3.35473584304, 99979.7361995226), new Vsop87.LnVsop(1.0E-10, 5.93947627346, 154945.4595011622), new Vsop87.LnVsop(9.0E-11, 2.84548380902, 195047.36464141717), new Vsop87.LnVsop(1.0E-10, 3.05711078565, 12098.1867096284), new Vsop87.LnVsop(1.1E-10, 6.21650368713, 52213.9393187862), new Vsop87.LnVsop(8.0E-11, 0.37369030169, 31722.9368709266), new Vsop87.LnVsop(8.0E-11, 6.14665125818, 78294.036285727), new Vsop87.LnVsop(8.0E-11, 2.45482949143, 78262.22495201428), new Vsop87.LnVsop(8.0E-11, 0.05965725544, 182634.99175191918), new Vsop87.LnVsop(8.0E-11, 2.39708295298, 24551.92639860479), new Vsop87.LnVsop(1.0E-10, 2.67934627998, 104145.42701785959), new Vsop87.LnVsop(8.0E-11, 4.55751882694, 31775.5335105262), new Vsop87.LnVsop(8.0E-11, 3.16773434441, 53438.96364572659), new Vsop87.LnVsop(8.0E-11, 6.22544072035, 202420.14928260216), new Vsop87.LnVsop(8.0E-11, 5.81704618147, 51734.98099827079), new Vsop87.LnVsop(8.0E-11, 1.78435325528, 4743.4017631704), new Vsop87.LnVsop(9.0E-11, 3.83707765982, 79346.78965701618), new Vsop87.LnVsop(1.0E-10, 5.71688904375, 97466.46267636596), new Vsop87.LnVsop(8.0E-11, 2.03894332579, 77345.77913874079), new Vsop87.LnVsop(8.0E-11, 4.13054556768, 111032.83741969639), new Vsop87.LnVsop(8.0E-11, 4.6092201211, 130329.30938665158), new Vsop87.LnVsop(8.0E-11, 5.35165926588, 106082.73491922939), new Vsop87.LnVsop(8.0E-11, 5.3953090617, 1168.8988370466), new Vsop87.LnVsop(9.0E-11, 3.93805662188, 77929.8534839532), new Vsop87.LnVsop(7.0E-11, 5.21488891735, 43981.5309499398), new Vsop87.LnVsop(8.0E-11, 2.01003440428, 252884.50297371778), new Vsop87.LnVsop(1.0E-10, 4.11323982627, 51861.62010327879), new Vsop87.LnVsop(8.0E-11, 5.44182392744, 24844.41553989579), new Vsop87.LnVsop(9.0E-11, 1.74545022265, 25778.62481891839), new Vsop87.LnVsop(7.0E-11, 3.82338680251, 220025.88923089797), new Vsop87.LnVsop(7.0E-11, 6.24768089702, 104874.18998439058), new Vsop87.LnVsop(9.0E-11, 2.34086101872, 192828.60753723036), new Vsop87.LnVsop(9.0E-11, 0.48166296597, 4571.62325795859), new Vsop87.LnVsop(1.0E-10, 3.98285678625, 26014.60601571519), new Vsop87.LnVsop(8.0E-11, 1.39482440025, 169093.57054942797), new Vsop87.LnVsop(8.0E-11, 2.14139660009, 154931.23240716057), new Vsop87.LnVsop(7.0E-11, 4.40965228112, 78249.48233072099), new Vsop87.LnVsop(9.0E-11, 2.75553561717, 52145.47942214399), new Vsop87.LnVsop(7.0E-11, 2.57942012432, 3178.1457905676), new Vsop87.LnVsop(8.0E-11, 1.43006670657, 52164.76058288449), new Vsop87.LnVsop(7.0E-11, 2.62316145982, 127791.06088239799), new Vsop87.LnVsop(8.0E-11, 4.14250630085, 26713.57333388659), new Vsop87.LnVsop(7.0E-11, 1.85653633566, 24765.2254940428), new Vsop87.LnVsop(8.0E-11, 3.34882273958, 92.0528357446), new Vsop87.LnVsop(7.0E-11, 4.79266143108, 76378.8082613052), new Vsop87.LnVsop(7.0E-11, 3.97155618165, 77956.15180375299), new Vsop87.LnVsop(7.0E-11, 1.40803692928, 78149.31031780918), new Vsop87.LnVsop(7.0E-11, 0.70961929454, 212031.36078887375), new Vsop87.LnVsop(7.0E-11, 3.85508188374, 27410.5807891056), new Vsop87.LnVsop(7.0E-11, 2.26884263391, 118007.4730574732), new Vsop87.LnVsop(7.0E-11, 5.09321484473, 51092.7260508548), new Vsop87.LnVsop(7.0E-11, 6.12403557988, 65538.25598994759), new Vsop87.LnVsop(7.0E-11, 4.39083508021, 129483.22655190038), new Vsop87.LnVsop(8.0E-11, 5.83553684097, 102182.85208401419), new Vsop87.LnVsop(7.0E-11, 4.33543927503, 74179.7209180182), new Vsop87.LnVsop(8.0E-11, 4.79819281031, 130020.03106399579), new Vsop87.LnVsop(8.0E-11, 0.41203822272, 78112.66175487968), new Vsop87.LnVsop(7.0E-11, 2.68129663526, 104427.87863757239), new Vsop87.LnVsop(9.0E-11, 0.29724852145, 2352.8661537718), new Vsop87.LnVsop(7.0E-11, 5.93637605025, 21067.98465416099), new Vsop87.LnVsop(7.0E-11, 5.92819269793, 221135.26778299137), new Vsop87.LnVsop(7.0E-11, 1.9336423448, 26500.27423844859), new Vsop87.LnVsop(7.0E-11, 1.41532885394, 104035.22069664019), new Vsop87.LnVsop(9.0E-11, 5.67763971529, 33856.2696982688), new Vsop87.LnVsop(9.0E-11, 5.98755838226, 18073.7049386502), new Vsop87.LnVsop(9.0E-11, 2.10050473205, 52277.768801414), new Vsop87.LnVsop(9.0E-11, 2.08883097836, 149288.74325784517), new Vsop87.LnVsop(7.0E-11, 2.37722377692, 30689.8532605372), new Vsop87.LnVsop(7.0E-11, 3.10792403028, 288076.3131094096), new Vsop87.LnVsop(7.0E-11, 4.88415129602, 104888.41707839219), new Vsop87.LnVsop(9.0E-11, 3.27631582216, 118828.96374949679), new Vsop87.LnVsop(7.0E-11, 1.3876837267, 29864.334027309), new Vsop87.LnVsop(7.0E-11, 5.72644167523, 52822.81711646319), new Vsop87.LnVsop(7.0E-11, 2.76782011856, 53551.5800829942), new Vsop87.LnVsop(7.0E-11, 1.5112407556, 78571.26704569219), new Vsop87.LnVsop(7.0E-11, 2.26442292058, 131079.41299418497), new Vsop87.LnVsop(7.0E-11, 5.31640546842, 26247.2048763664), new Vsop87.LnVsop(7.0E-11, 0.09686245345, 79859.89586700719), new Vsop87.LnVsop(7.0E-11, 6.10844494934, 52812.8025551726), new Vsop87.LnVsop(7.0E-11, 1.87174516455, 96471.52341295779), new Vsop87.LnVsop(7.0E-11, 2.87375591411, 80967.3255793982), new Vsop87.LnVsop(7.0E-11, 1.29457274547, 113736.45357437199), new Vsop87.LnVsop(7.0E-11, 0.89009344126, 28213.78054895339), new Vsop87.LnVsop(7.0E-11, 4.25473641206, 26140.99929388859), new Vsop87.LnVsop(8.0E-11, 4.82798273493, 197380.5610342892), new Vsop87.LnVsop(7.0E-11, 3.09825871823, 78265.19389743089), new Vsop87.LnVsop(8.0E-11, 4.34888971439, 235320.81923926238), new Vsop87.LnVsop(6.0E-11, 5.42495897529, 104350.12809358849), new Vsop87.LnVsop(6.0E-11, 3.99182956098, 104668.00443595338), new Vsop87.LnVsop(7.0E-11, 5.34185785375, 175376.64639941938), new Vsop87.LnVsop(8.0E-11, 0.86389617056, 104466.051854982), new Vsop87.LnVsop(7.0E-11, 1.33899601862, 149756.7082481996), new Vsop87.LnVsop(8.0E-11, 3.10920439449, 228508.0524241764), new Vsop87.LnVsop(7.0E-11, 4.30741955939, 158438.6183326624), new Vsop87.LnVsop(6.0E-11, 5.17419549153, 104991.50985261079), new Vsop87.LnVsop(7.0E-11, 2.20450442762, 156373.64003896038), new Vsop87.LnVsop(6.0E-11, 2.90224060475, 129792.50487455618), new Vsop87.LnVsop(6.0E-11, 4.54232458825, 26235.9818660005), new Vsop87.LnVsop(7.0E-11, 4.42850204913, 27039.97976483379), new Vsop87.LnVsop(9.0E-11, 1.73966926518, 171292.65789271498), new Vsop87.LnVsop(6.0E-11, 0.11815278939, 159969.99379441058), new Vsop87.LnVsop(6.0E-11, 4.04317848847, 129277.04100346318), new Vsop87.LnVsop(9.0E-11, 6.0120076787, 168959.46149984296), new Vsop87.LnVsop(7.0E-11, 1.85751313511, 28096.46068073319), new Vsop87.LnVsop(7.0E-11, 2.12438011211, 84307.93800609799), new Vsop87.LnVsop(6.0E-11, 2.48582215527, 156681.19765992998), new Vsop87.LnVsop(7.0E-11, 3.73735796662, 182608.20844401856), new Vsop87.LnVsop(6.0E-11, 2.28958252031, 156451.15277816958), new Vsop87.LnVsop(8.0E-11, 3.69992350848, 132772.712100743), new Vsop87.LnVsop(7.0E-11, 1.41866016352, 130859.00035174617), new Vsop87.LnVsop(6.0E-11, 2.21936307079, 180496.558130641), new Vsop87.LnVsop(9.0E-11, 3.06339763309, 104401.60918820098), new Vsop87.LnVsop(8.0E-11, 1.18565300113, 209232.91609768817), new Vsop87.LnVsop(7.0E-11, 3.94128798915, 25675.5320446998), new Vsop87.LnVsop(8.0E-11, 3.78904655885, 229129.79622501557), new Vsop87.LnVsop(6.0E-11, 5.00477784596, 182465.7587938848), new Vsop87.LnVsop(7.0E-11, 5.14936294952, 33480.357543659), new Vsop87.LnVsop(8.0E-11, 4.60188784024, 234261.43730907317), new Vsop87.LnVsop(8.0E-11, 4.47296414448, 104237.17327761157), new Vsop87.LnVsop(7.0E-11, 0.75480073977, 84944.9342781222), new Vsop87.LnVsop(6.0E-11, 4.68210231273, 261834.63115735055), new Vsop87.LnVsop(7.0E-11, 1.33270050713, 182619.20332637738), new Vsop87.LnVsop(7.0E-11, 5.60721965283, 148532.89040742096), new Vsop87.LnVsop(8.0E-11, 5.1360296753, 209762.60706278277), new Vsop87.LnVsop(6.0E-11, 0.03219084009, 25896.4548754626), new Vsop87.LnVsop(8.0E-11, 3.93608578931, 156534.04740834518), new Vsop87.LnVsop(8.0E-11, 4.2264536052, 182595.65223011957), new Vsop87.LnVsop(7.0E-11, 6.0636393261, 156523.5375140872), new Vsop87.LnVsop(7.0E-11, 4.74656613678, 104685.46850706618), new Vsop87.LnVsop(8.0E-11, 1.89526023726, 25462.2329492618), new Vsop87.LnVsop(6.0E-11, 1.4831694091, 26191.68533015479), new Vsop87.LnVsop(8.0E-11, 4.0765017894, 13705.8571130806), new Vsop87.LnVsop(7.0E-11, 1.81299543472, 78597.56536549199), new Vsop87.LnVsop(6.0E-11, 6.09713561414, 104353.09703900508), new Vsop87.LnVsop(6.0E-11, 5.60796663267, 207747.625390985), new Vsop87.LnVsop(6.0E-11, 2.16536179089, 27573.88326263939), new Vsop87.LnVsop(6.0E-11, 1.42098831764, 26026.177166834), new Vsop87.LnVsop(6.0E-11, 1.69671918811, 20043.6745601988), new Vsop87.LnVsop(6.0E-11, 5.11260117805, 443494.3534067613), new Vsop87.LnVsop(6.0E-11, 5.22497762448, 107679.74822257696), new Vsop87.LnVsop(6.0E-11, 1.74905384462, 50290.905119731), new Vsop87.LnVsop(6.0E-11, 0.304225437, 182622.43553802016), new Vsop87.LnVsop(8.0E-11, 4.49860671318, 195181.47369100217), new Vsop87.LnVsop(7.0E-11, 3.45347996125, 430.5303441391), new Vsop87.LnVsop(6.0E-11, 0.74258274172, 256327.07791868312), new Vsop87.LnVsop(8.0E-11, 2.76506053583, 183041.9201818954), new Vsop87.LnVsop(6.0E-11, 2.89935798569, 239343.0817712266), new Vsop87.LnVsop(6.0E-11, 4.96619008761, 70383.6202713836), new Vsop87.LnVsop(7.0E-11, 1.8490308823, 28632.5757784666), new Vsop87.LnVsop(6.0E-11, 0.68234531723, 104017.75662552739), new Vsop87.LnVsop(6.0E-11, 3.11962389893, 184834.07909520617), new Vsop87.LnVsop(6.0E-11, 3.60993416994, 131072.29944718417), new Vsop87.LnVsop(6.0E-11, 0.03251101986, 102620.49021336419), new Vsop87.LnVsop(6.0E-11, 5.50368260841, 26238.95081141709), new Vsop87.LnVsop(7.0E-11, 1.97599718563, 107692.22499299659), new Vsop87.LnVsop(6.0E-11, 5.777741494, 78339.97549599818), new Vsop87.LnVsop(8.0E-11, 1.97853905449, 88285.54670482199), new Vsop87.LnVsop(6.0E-11, 2.44688578354, 28928.40404660019), new Vsop87.LnVsop(7.0E-11, 1.78303012604, 26034.8069892598), new Vsop87.LnVsop(6.0E-11, 0.4313729327, 27388.72995977919), new Vsop87.LnVsop(6.0E-11, 4.76836779722, 104771.09721017198), new Vsop87.LnVsop(6.0E-11, 3.6331398447, 77641.96562388338), new Vsop87.LnVsop(7.0E-11, 5.22121198783, 91919.56991589899), new Vsop87.LnVsop(7.0E-11, 4.48679862542, 156531.3001848032), new Vsop87.LnVsop(7.0E-11, 2.61368067822, 266540.3634648941), new Vsop87.LnVsop(7.0E-11, 0.12862048714, 130907.4806982254), new Vsop87.LnVsop(6.0E-11, 0.43577629069, 106470.37642667518), new Vsop87.LnVsop(6.0E-11, 3.82921450071, 27047.0260015318), new Vsop87.LnVsop(6.0E-11, 0.70928978057, 26061.60482177439), new Vsop87.LnVsop(5.0E-11, 1.08303549554, 22779.4372461938), new Vsop87.LnVsop(6.0E-11, 0.25448993981, 146505.58156934578), new Vsop87.LnVsop(7.0E-11, 4.06478627606, 104461.81888751619), new Vsop87.LnVsop(6.0E-11, 5.60793166576, 131506.01118506098), new Vsop87.LnVsop(8.0E-11, 1.69064312952, 38469.94917006779), new Vsop87.LnVsop(8.0E-11, 2.44994557596, 164407.50800278416), new Vsop87.LnVsop(7.0E-11, 3.54872847011, 155894.635110132), new Vsop87.LnVsop(5.0E-11, 1.10994023578, 52072.0240945678), new Vsop87.LnVsop(6.0E-11, 3.73225568492, 26084.93419615759), new Vsop87.LnVsop(5.0E-11, 5.58167272835, 101173.46677572919), new Vsop87.LnVsop(5.0E-11, 0.70846557489, 208489.9260371556), new Vsop87.LnVsop(6.0E-11, 4.5992139387, 20894.5360827764), new Vsop87.LnVsop(5.0E-11, 3.75647355566, 242985.40360737636), new Vsop87.LnVsop(5.0E-11, 6.27502785749, 104785.32430417358), new Vsop87.LnVsop(6.0E-11, 2.00142473286, 1699.2792165032), new Vsop87.LnVsop(7.0E-11, 2.76050255944, 184204.39488630317), new Vsop87.LnVsop(5.0E-11, 5.47987179385, 26252.33905216361), new Vsop87.LnVsop(7.0E-11, 2.00462922304, 26090.8720869908), new Vsop87.LnVsop(7.0E-11, 1.62322254368, 18227.483749135), new Vsop87.LnVsop(6.0E-11, 5.70254081987, 33917.99567300899), new Vsop87.LnVsop(6.0E-11, 5.97919634831, 77208.25964779648), new Vsop87.LnVsop(6.0E-11, 2.16791372283, 26045.0200666708), new Vsop87.LnVsop(7.0E-11, 2.57095095237, 77218.55458853499), new Vsop87.LnVsop(5.0E-11, 0.25701311411, 25923.46723098479), new Vsop87.LnVsop(7.0E-11, 4.14777314934, 33948.3225340134), new Vsop87.LnVsop(5.0E-11, 5.29140115995, 28471.0961563504), new Vsop87.LnVsop(6.0E-11, 3.53925621297, 26130.7862164776), new Vsop87.LnVsop(5.0E-11, 6.11594062706, 52355.883413433), new Vsop87.LnVsop(6.0E-11, 5.57961940155, 76352.50994150538), new Vsop87.LnVsop(6.0E-11, 0.83576004159, 130446.14426677099), new Vsop87.LnVsop(5.0E-11, 0.43431985985, 23704.71012679799), new Vsop87.LnVsop(7.0E-11, 2.28014965021, 35679.44488694599), new Vsop87.LnVsop(6.0E-11, 5.37355955737, 17098.43543614181), new Vsop87.LnVsop(5.0E-11, 5.9724413979, 123554.36581794015), new Vsop87.LnVsop(6.0E-11, 3.95779909916, 130432.88714897096), new Vsop87.LnVsop(5.0E-11, 4.47086994601, 27360.58416720139), new Vsop87.LnVsop(6.0E-11, 3.02938887393, 26830.8932021068), new Vsop87.LnVsop(5.0E-11, 2.94688436969, 129902.71119577558), new Vsop87.LnVsop(5.0E-11, 2.93317711504, 130215.17091216908), new Vsop87.LnVsop(6.0E-11, 3.75147408015, 42790.9652750732), new Vsop87.LnVsop(6.0E-11, 1.00428918941, 51040.1294112552), new Vsop87.LnVsop(5.0E-11, 2.78041305143, 143164.96914264598), new Vsop87.LnVsop(5.0E-11, 1.8600079603, 469582.2565483355), new Vsop87.LnVsop(6.0E-11, 0.74710746073, 132350.71519108818), new Vsop87.LnVsop(5.0E-11, 2.39844344347, 23389.451694197), new Vsop87.LnVsop(6.0E-11, 3.58468768151, 23247.4022365482), new Vsop87.LnVsop(6.0E-11, 0.8258915078, 77964.58303045339), new Vsop87.LnVsop(6.0E-11, 4.53833067121, 101023.47691001659), new Vsop87.LnVsop(5.0E-11, 0.57407761078, 24734.1543965574), new Vsop87.LnVsop(5.0E-11, 2.25316144259, 415.5524906121), new Vsop87.LnVsop(6.0E-11, 4.70935000739, 65717.22748563958), new Vsop87.LnVsop(5.0E-11, 0.05510253171, 52336.2136525332), new Vsop87.LnVsop(5.0E-11, 5.35670099063, 26513.8119180882), new Vsop87.LnVsop(6.0E-11, 2.32062527661, 23384.2869868986), new Vsop87.LnVsop(5.0E-11, 1.32520906706, 25980.59783464459), new Vsop87.LnVsop(5.0E-11, 0.80991017339, 25661.9943650602), new Vsop87.LnVsop(6.0E-11, 6.08272643182, 130589.07890500558), new Vsop87.LnVsop(5.0E-11, 4.38196086874, 26195.2084485038), new Vsop87.LnVsop(5.0E-11, 0.41357636643, 87253.17713015496), new Vsop87.LnVsop(5.0E-11, 1.29167077496, 164721.69418265377), new Vsop87.LnVsop(5.0E-11, 0.71179831125, 180396.56488683258), new Vsop87.LnVsop(6.0E-11, 1.47416646071, 233202.055378884), new Vsop87.LnVsop(5.0E-11, 6.23460200611, 34102.10134449819), new Vsop87.LnVsop(5.0E-11, 5.35033090355, 26397.18146422999), new Vsop87.LnVsop(5.0E-11, 4.93083299042, 23401.181047033), new Vsop87.LnVsop(5.0E-11, 2.81440459099, 91626.15913152178), new Vsop87.LnVsop(5.0E-11, 3.34946974145, 76532.58707178998), new Vsop87.LnVsop(6.0E-11, 2.87843300002, 50912.6489205702), new Vsop87.LnVsop(5.0E-11, 0.98613060394, 208683.5553716938), new Vsop87.LnVsop(6.0E-11, 0.63843906657, 255217.69936658978), new Vsop87.LnVsop(6.0E-11, 3.68754775281, 53654.67285721279), new Vsop87.LnVsop(5.0E-11, 1.77640278232, 79116.90580647459), new Vsop87.LnVsop(6.0E-11, 1.22686507612, 51538.81001112419), new Vsop87.LnVsop(6.0E-11, 0.36168067626, 422.6660376129), new Vsop87.LnVsop(5.0E-11, 4.10167099677, 249268.47945736776), new Vsop87.LnVsop(5.0E-11, 2.94751779171, 130962.09312596478), new Vsop87.LnVsop(6.0E-11, 2.79032706562, 131491.78409105938), new Vsop87.LnVsop(6.0E-11, 5.45598380433, 218916.51067880457), new Vsop87.LnVsop(5.0E-11, 5.72733360293, 2324.9494088156), new Vsop87.LnVsop(5.0E-11, 1.55205182092, 305060.30925686617), new Vsop87.LnVsop(6.0E-11, 1.11542763194, 78373.91574594198), new Vsop87.LnVsop(5.0E-11, 0.22456206035, 130514.29730643828), new Vsop87.LnVsop(5.0E-11, 6.19195128172, 440.8252848776), new Vsop87.LnVsop(6.0E-11, 4.68979746907, 26149.62911631439), new Vsop87.LnVsop(5.0E-11, 0.0477337492, 130489.51232977519), new Vsop87.LnVsop(5.0E-11, 4.35334090897, 260452.43322486596), new Vsop87.LnVsop(4.0E-11, 1.8032586117, 104301.61594439259), new Vsop87.LnVsop(4.0E-11, 5.90731736703, 38634.3850806572), new Vsop87.LnVsop(5.0E-11, 5.85937874289, 41520.8540663828), new Vsop87.LnVsop(4.0E-11, 5.81033465121, 52378.05967832249), new Vsop87.LnVsop(5.0E-11, 2.38959621917, 77776.07467346839), new Vsop87.LnVsop(5.0E-11, 0.89819672775, 52102.50915728939), new Vsop87.LnVsop(4.0E-11, 1.04050915609, 283524.3596123507), new Vsop87.LnVsop(4.0E-11, 5.74543005216, 79639.4832245684), new Vsop87.LnVsop(5.0E-11, 3.24374045161, 53771.99272543299), new Vsop87.LnVsop(6.0E-11, 5.37158640221, 49822.94012937659), new Vsop87.LnVsop(4.0E-11, 0.06769738532, 4371.8763667742), new Vsop87.LnVsop(6.0E-11, 1.1863801136, 188898.39784101077), new Vsop87.LnVsop(5.0E-11, 6.05867525779, 77190.10040053178), new Vsop87.LnVsop(4.0E-11, 5.01707452403, 169252.87228422018), new Vsop87.LnVsop(4.0E-11, 4.30493132325, 206370.02873972157), new Vsop87.LnVsop(4.0E-11, 2.06448884635, 201464.54954099358), new Vsop87.LnVsop(4.0E-11, 5.27718401223, 20452.8694122218), new Vsop87.LnVsop(5.0E-11, 0.64823272639, 106684.80895916879), new Vsop87.LnVsop(4.0E-11, 1.34518506056, 20400.2727726222), new Vsop87.LnVsop(5.0E-11, 3.64294402199, 27331.3907432526), new Vsop87.LnVsop(5.0E-11, 1.10711421942, 79219.99858069318), new Vsop87.LnVsop(4.0E-11, 5.7014328369, 267649.7420169875), new Vsop87.LnVsop(4.0E-11, 5.61867141715, 32808.6171209156), new Vsop87.LnVsop(4.0E-11, 3.40787680501, 74771.13785785298), new Vsop87.LnVsop(4.0E-11, 4.89347322243, 52249.10340900739), new Vsop87.LnVsop(4.0E-11, 4.5062628523, 80912.1642501956), new Vsop87.LnVsop(4.0E-11, 5.7975220636, 273311.0740661397), new Vsop87.LnVsop(4.0E-11, 3.59370702464, 46564.4708559004), new Vsop87.LnVsop(6.0E-11, 3.80547114091, 28786.3545889514), new Vsop87.LnVsop(4.0E-11, 3.61797134303, 132558.2795682494), new Vsop87.LnVsop(4.0E-11, 5.02120058481, 133780.12813457078), new Vsop87.LnVsop(4.0E-11, 0.69875295873, 77622.29586298359), new Vsop87.LnVsop(4.0E-11, 5.47230241775, 50639.82954017899), new Vsop87.LnVsop(5.0E-11, 5.60595541866, 200708.69669056937), new Vsop87.LnVsop(4.0E-11, 4.57945769995, 46131.577701773), new Vsop87.LnVsop(4.0E-11, 2.90774078461, 61299.38303816579), new Vsop87.LnVsop(5.0E-11, 5.95351319448, 93696.66034953119), new Vsop87.LnVsop(5.0E-11, 6.04114354784, 51995.7291528638), new Vsop87.LnVsop(4.0E-11, 5.11154568183, 251775.12442162435), new Vsop87.LnVsop(4.0E-11, 4.37488020826, 130123.12383821438), new Vsop87.LnVsop(5.0E-11, 0.61091062956, 102865.63244523159), new Vsop87.LnVsop(4.0E-11, 2.83395761015, 128217.65907327399), new Vsop87.LnVsop(5.0E-11, 6.05511428388, 49534.4650046762), new Vsop87.LnVsop(4.0E-11, 0.70993360491, 51554.06248230919), new Vsop87.LnVsop(5.0E-11, 2.16220422308, 54221.1148159506), new Vsop87.LnVsop(5.0E-11, 6.2573244944, 18319.5365848796), new Vsop87.LnVsop(4.0E-11, 6.03004085628, 54287.45659652599), new Vsop87.LnVsop(4.0E-11, 5.94971817133, 16964.3263865568), new Vsop87.LnVsop(4.0E-11, 3.56233707368, 20272.7922819372), new Vsop87.LnVsop(4.0E-11, 1.59742075675, 79399.38629661579), new Vsop87.LnVsop(4.0E-11, 2.94685386221, 28199.55345495179), new Vsop87.LnVsop(5.0E-11, 1.93137641145, 83591.18553310538), new Vsop87.LnVsop(4.0E-11, 0.66487328583, 130755.90757752759), new Vsop87.LnVsop(4.0E-11, 3.1526641151, 170068.84005193636), new Vsop87.LnVsop(4.0E-11, 2.5048917345, 102446.14780135639), new Vsop87.LnVsop(5.0E-11, 4.20320779124, 113455.51956041438), new Vsop87.LnVsop(5.0E-11, 5.87958723384, 53757.76563143139), new Vsop87.LnVsop(5.0E-11, 1.86517289834, 24510.5595991264), new Vsop87.LnVsop(4.0E-11, 1.47938914186, 54824.2611086214), new Vsop87.LnVsop(4.0E-11, 0.34491990622, 78161.74690645699), new Vsop87.LnVsop(4.0E-11, 4.91765582326, 54184.36382230739), new Vsop87.LnVsop(4.0E-11, 1.66609260552, 25135.8265183146), new Vsop87.LnVsop(5.0E-11, 2.71496730071, 77200.39534127028), new Vsop87.LnVsop(4.0E-11, 5.13273546829, 26387.0295358434), new Vsop87.LnVsop(4.0E-11, 4.81872093221, 56573.9809697224), new Vsop87.LnVsop(4.0E-11, 5.08493147041, 1574.8458012822), new Vsop87.LnVsop(4.0E-11, 5.61971860281, 52400.1510788503), new Vsop87.LnVsop(4.0E-11, 1.10830702595, 51949.9770147382), new Vsop87.LnVsop(4.0E-11, 2.49860728014, 105418.10804348679), new Vsop87.LnVsop(5.0E-11, 4.53061477023, 259289.9585204581), new Vsop87.LnVsop(4.0E-11, 1.43177381452, 51086.09749195479), new Vsop87.LnVsop(4.0E-11, 1.78993265235, 34570.0663348526), new Vsop87.LnVsop(4.0E-11, 2.89498773739, 4601.950118963), new Vsop87.LnVsop(4.0E-11, 3.81752951238, 52016.5045483562), new Vsop87.LnVsop(4.0E-11, 3.00793368756, 92914.50917930716), new Vsop87.LnVsop(4.0E-11, 3.19503794912, 67582.45888815718), new Vsop87.LnVsop(4.0E-11, 2.20034975861, 78167.73019750479), new Vsop87.LnVsop(4.0E-11, 0.67177464579, 53753.1498255962), new Vsop87.LnVsop(5.0E-11, 2.94612400422, 1055.4497769261), new Vsop87.LnVsop(4.0E-11, 5.01204521255, 77020.22182304418), new Vsop87.LnVsop(4.0E-11, 5.37296944146, 208063.32784627957), new Vsop87.LnVsop(5.0E-11, 5.81879633601, 52015.39891376359), new Vsop87.LnVsop(4.0E-11, 2.52609846916, 52367.25454925999), new Vsop87.LnVsop(4.0E-11, 0.65214215474, 185943.45764729957), new Vsop87.LnVsop(4.0E-11, 3.13387849279, 186057.89693598478), new Vsop87.LnVsop(4.0E-11, 2.21635240969, 215941.90072419358), new Vsop87.LnVsop(4.0E-11, 5.48439088692, 182769.10080150416), new Vsop87.LnVsop(4.0E-11, 1.64336565163, 246113.79237247215)};

        Longitude0() {
        }
    }
}

