/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Pluto {
    static double cJD = 0.0;
    static double cL = 0.0;
    static double cB = 0.0;
    static double cR = 0.0;
    static pluto_argument[] argument = new pluto_argument[]{new pluto_argument(0.0, 0.0, 1.0), new pluto_argument(0.0, 0.0, 2.0), new pluto_argument(0.0, 0.0, 3.0), new pluto_argument(0.0, 0.0, 4.0), new pluto_argument(0.0, 0.0, 5.0), new pluto_argument(0.0, 0.0, 6.0), new pluto_argument(0.0, 1.0, -1.0), new pluto_argument(0.0, 1.0, 0.0), new pluto_argument(0.0, 1.0, 1.0), new pluto_argument(0.0, 1.0, 2.0), new pluto_argument(0.0, 1.0, 3.0), new pluto_argument(0.0, 2.0, -2.0), new pluto_argument(0.0, 2.0, -1.0), new pluto_argument(0.0, 2.0, 0.0), new pluto_argument(1.0, -1.0, 0.0), new pluto_argument(1.0, -1.0, 1.0), new pluto_argument(1.0, 0.0, -3.0), new pluto_argument(1.0, 0.0, -2.0), new pluto_argument(1.0, 0.0, -1.0), new pluto_argument(1.0, 0.0, 0.0), new pluto_argument(1.0, 0.0, 1.0), new pluto_argument(1.0, 0.0, 2.0), new pluto_argument(1.0, 0.0, 3.0), new pluto_argument(1.0, 0.0, 4.0), new pluto_argument(1.0, 1.0, -3.0), new pluto_argument(1.0, 1.0, -2.0), new pluto_argument(1.0, 1.0, -1.0), new pluto_argument(1.0, 1.0, 0.0), new pluto_argument(1.0, 1.0, 1.0), new pluto_argument(1.0, 1.0, 3.0), new pluto_argument(2.0, 0.0, -6.0), new pluto_argument(2.0, 0.0, -5.0), new pluto_argument(2.0, 0.0, -4.0), new pluto_argument(2.0, 0.0, -3.0), new pluto_argument(2.0, 0.0, -2.0), new pluto_argument(2.0, 0.0, -1.0), new pluto_argument(2.0, 0.0, 0.0), new pluto_argument(2.0, 0.0, 1.0), new pluto_argument(2.0, 0.0, 2.0), new pluto_argument(2.0, 0.0, 3.0), new pluto_argument(3.0, 0.0, -2.0), new pluto_argument(3.0, 0.0, -1.0), new pluto_argument(3.0, 0.0, 0.0)};
    static pluto_longitude[] longitude = new pluto_longitude[]{new pluto_longitude(-1.9799805E7, 1.9850055E7), new pluto_longitude(897144.0, -4954829.0), new pluto_longitude(611149.0, 1211027.0), new pluto_longitude(-341243.0, -189585.0), new pluto_longitude(129287.0, -34992.0), new pluto_longitude(-38164.0, 30893.0), new pluto_longitude(20442.0, -9987.0), new pluto_longitude(-4063.0, -5071.0), new pluto_longitude(-6016.0, -3336.0), new pluto_longitude(-3956.0, 3039.0), new pluto_longitude(-667.0, 3572.0), new pluto_longitude(1276.0, 501.0), new pluto_longitude(1152.0, -917.0), new pluto_longitude(630.0, -1277.0), new pluto_longitude(2571.0, -459.0), new pluto_longitude(899.0, -1449.0), new pluto_longitude(-1016.0, 1043.0), new pluto_longitude(-2343.0, -1012.0), new pluto_longitude(7042.0, 788.0), new pluto_longitude(1199.0, -338.0), new pluto_longitude(418.0, -67.0), new pluto_longitude(120.0, -274.0), new pluto_longitude(-60.0, -159.0), new pluto_longitude(-82.0, -29.0), new pluto_longitude(-36.0, -20.0), new pluto_longitude(-40.0, 7.0), new pluto_longitude(-14.0, 22.0), new pluto_longitude(4.0, 13.0), new pluto_longitude(5.0, 2.0), new pluto_longitude(-1.0, 0.0), new pluto_longitude(2.0, 0.0), new pluto_longitude(-4.0, 5.0), new pluto_longitude(4.0, -7.0), new pluto_longitude(14.0, 24.0), new pluto_longitude(-49.0, -34.0), new pluto_longitude(163.0, -48.0), new pluto_longitude(9.0, 24.0), new pluto_longitude(-4.0, 1.0), new pluto_longitude(-3.0, 1.0), new pluto_longitude(1.0, 3.0), new pluto_longitude(-3.0, -1.0), new pluto_longitude(5.0, -3.0), new pluto_longitude(0.0, 0.0)};
    static pluto_latitude[] latitude = new pluto_latitude[]{new pluto_latitude(-5452852.0, -1.4974862E7), new pluto_latitude(3527812.0, 1672790.0), new pluto_latitude(-1050748.0, 327647.0), new pluto_latitude(178690.0, -292153.0), new pluto_latitude(18650.0, 100340.0), new pluto_latitude(-30697.0, -25823.0), new pluto_latitude(4878.0, 11248.0), new pluto_latitude(226.0, -64.0), new pluto_latitude(2030.0, -836.0), new pluto_latitude(69.0, -604.0), new pluto_latitude(-247.0, -567.0), new pluto_latitude(-57.0, 1.0), new pluto_latitude(-122.0, 175.0), new pluto_latitude(-49.0, -164.0), new pluto_latitude(-197.0, 199.0), new pluto_latitude(-25.0, 217.0), new pluto_latitude(589.0, -248.0), new pluto_latitude(-269.0, 711.0), new pluto_latitude(185.0, 193.0), new pluto_latitude(315.0, 807.0), new pluto_latitude(-130.0, -43.0), new pluto_latitude(5.0, 3.0), new pluto_latitude(2.0, 17.0), new pluto_latitude(2.0, 5.0), new pluto_latitude(2.0, 3.0), new pluto_latitude(3.0, 1.0), new pluto_latitude(2.0, -1.0), new pluto_latitude(1.0, -1.0), new pluto_latitude(0.0, -1.0), new pluto_latitude(0.0, 0.0), new pluto_latitude(0.0, -2.0), new pluto_latitude(2.0, 2.0), new pluto_latitude(-7.0, 0.0), new pluto_latitude(10.0, -8.0), new pluto_latitude(-3.0, 20.0), new pluto_latitude(6.0, 5.0), new pluto_latitude(14.0, 17.0), new pluto_latitude(-2.0, 0.0), new pluto_latitude(0.0, 0.0), new pluto_latitude(0.0, 0.0), new pluto_latitude(0.0, 1.0), new pluto_latitude(0.0, 0.0), new pluto_latitude(1.0, 0.0)};
    static pluto_radius[] radius = new pluto_radius[]{new pluto_radius(6.6865439E7, 6.8951812E7), new pluto_radius(-1.1827535E7, -332538.0), new pluto_radius(1593179.0, -1438890.0), new pluto_radius(-18444.0, 483220.0), new pluto_radius(-65977.0, -85431.0), new pluto_radius(31174.0, -6032.0), new pluto_radius(-5794.0, 22161.0), new pluto_radius(4601.0, 4032.0), new pluto_radius(-1729.0, 234.0), new pluto_radius(-415.0, 702.0), new pluto_radius(239.0, 723.0), new pluto_radius(67.0, -67.0), new pluto_radius(1034.0, -451.0), new pluto_radius(-129.0, 504.0), new pluto_radius(480.0, -231.0), new pluto_radius(2.0, -441.0), new pluto_radius(-3359.0, 265.0), new pluto_radius(7856.0, -7832.0), new pluto_radius(36.0, 45763.0), new pluto_radius(8663.0, 8547.0), new pluto_radius(-809.0, -769.0), new pluto_radius(263.0, -144.0), new pluto_radius(-126.0, 32.0), new pluto_radius(-35.0, -16.0), new pluto_radius(-19.0, -4.0), new pluto_radius(-15.0, 8.0), new pluto_radius(-4.0, 12.0), new pluto_radius(5.0, 6.0), new pluto_radius(3.0, 1.0), new pluto_radius(6.0, -2.0), new pluto_radius(2.0, 2.0), new pluto_radius(-2.0, -2.0), new pluto_radius(14.0, 13.0), new pluto_radius(-63.0, 13.0), new pluto_radius(136.0, -236.0), new pluto_radius(273.0, 1065.0), new pluto_radius(251.0, 149.0), new pluto_radius(-25.0, -9.0), new pluto_radius(9.0, -2.0), new pluto_radius(-8.0, 7.0), new pluto_radius(2.0, -10.0), new pluto_radius(19.0, 35.0), new pluto_radius(10.0, 2.0)};

    public static void ln_get_pluto_equ_coords(double JD, LnEquPosn position) {
        double c;
        double b;
        double a;
        double last;
        double delta;
        double diff;
        LnHelioPosn h_sol = new LnHelioPosn();
        LnHelioPosn h_pluto = new LnHelioPosn();
        LnRectPosn g_sol = new LnRectPosn();
        LnRectPosn g_pluto = new LnRectPosn();
        double t = 0.0;
        Solar.ln_get_solar_geom_coords(JD, h_sol);
        Transform.ln_get_rect_from_helio(h_sol, g_sol);
        do {
            last = t;
            Pluto.ln_get_pluto_helio_coords(JD - t, h_pluto);
            Transform.ln_get_rect_from_helio(h_pluto, g_pluto);
            a = g_sol.X + g_pluto.X;
            b = g_sol.Y + g_pluto.Y;
            c = g_sol.Z + g_pluto.Z;
            delta = a * a + b * b + c * c;
        } while ((diff = (t = (delta = Math.sqrt(delta)) * 0.0057755183) - last) > 1.0E-4 || diff < -1.0E-4);
        double ra = Math.atan2(b, a);
        double dec = c / delta;
        dec = Math.asin(dec);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_pluto_helio_coords(double JD, LnHelioPosn position) {
        double sum_longitude = 0.0;
        double sum_latitude = 0.0;
        double sum_radius = 0.0;
        if (JD == cJD) {
            position.L = cL;
            position.B = cB;
            position.R = cR;
            return;
        }
        double t = (JD - 2451545.0) / 36525.0;
        double J = 34.35 + 3034.9057 * t;
        double S = 50.08 + 1222.1138 * t;
        double P = 238.96 + 144.96 * t;
        for (int i = 0; i < argument.length; ++i) {
            double a = Pluto.argument[i].J * J + Pluto.argument[i].S * S + Pluto.argument[i].P * P;
            double sin_a = Math.sin(Utility.ln_deg_to_rad(a));
            double cos_a = Math.cos(Utility.ln_deg_to_rad(a));
            sum_longitude += Pluto.longitude[i].A * sin_a + Pluto.longitude[i].B * cos_a;
            sum_latitude += Pluto.latitude[i].A * sin_a + Pluto.latitude[i].B * cos_a;
            sum_radius += Pluto.radius[i].A * sin_a + Pluto.radius[i].B * cos_a;
        }
        position.L = 238.958116 + 144.96 * t + sum_longitude * 1.0E-6;
        position.B = -3.908239 + sum_latitude * 1.0E-6;
        position.R = 40.7241346 + sum_radius * 1.0E-7;
        cJD = JD;
        cL = position.L;
        cB = position.B;
        cR = position.R;
    }

    public static double ln_get_pluto_earth_dist(double JD) {
        LnHelioPosn h_pluto = new LnHelioPosn();
        LnHelioPosn h_earth = new LnHelioPosn();
        LnRectPosn g_pluto = new LnRectPosn();
        LnRectPosn g_earth = new LnRectPosn();
        Pluto.ln_get_pluto_helio_coords(JD, h_pluto);
        Earth.ln_get_earth_helio_coords(JD, h_earth);
        Transform.ln_get_rect_from_helio(h_pluto, g_pluto);
        Transform.ln_get_rect_from_helio(h_earth, g_earth);
        double x = g_pluto.X - g_earth.X;
        double y = g_pluto.Y - g_earth.Y;
        double z = g_pluto.Z - g_earth.Z;
        x *= x;
        y *= y;
        z *= z;
        return Math.sqrt(x + y + z);
    }

    public static double ln_get_pluto_solar_dist(double JD) {
        LnHelioPosn h_pluto = new LnHelioPosn();
        Pluto.ln_get_pluto_helio_coords(JD, h_pluto);
        return h_pluto.R;
    }

    public static double ln_get_pluto_magnitude(double JD) {
        double r = Pluto.ln_get_pluto_solar_dist(JD);
        double delta = Pluto.ln_get_pluto_earth_dist(JD);
        return -1.0 + 5.0 * Math.log10(r * delta);
    }

    public static double ln_get_pluto_disk(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Pluto.ln_get_pluto_solar_dist(JD);
        double delta = Pluto.ln_get_pluto_earth_dist(JD);
        return ((r + delta) * (r + delta) - R * R) / (4.0 * r * delta);
    }

    public static double ln_get_pluto_phase(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Pluto.ln_get_pluto_solar_dist(JD);
        double delta = Pluto.ln_get_pluto_earth_dist(JD);
        double i = (r * r + delta * delta - R * R) / (2.0 * r * delta);
        i = Math.acos(i);
        return Utility.ln_rad_to_deg(i);
    }

    public static int ln_get_pluto_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Pluto.ln_get_pluto_equ_coords(JD, position);
            }
        }, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static double ln_get_pluto_sdiam(double JD) {
        double So = 2.07;
        double dist = Pluto.ln_get_pluto_earth_dist(JD);
        return So / dist;
    }

    public static void ln_get_pluto_rect_helio(double JD, LnRectPosn position) {
        LnHelioPosn pluto = new LnHelioPosn();
        Pluto.ln_get_pluto_helio_coords(JD, pluto);
        Transform.ln_get_rect_from_helio(pluto, position);
    }

    private static class pluto_radius {
        double A;
        double B;

        public pluto_radius(double a, double b) {
            this.A = a;
            this.B = b;
        }
    }

    private static class pluto_latitude {
        double A;
        double B;

        public pluto_latitude(double a, double b) {
            this.A = a;
            this.B = b;
        }
    }

    private static class pluto_longitude {
        double A;
        double B;

        public pluto_longitude(double a, double b) {
            this.A = a;
            this.B = b;
        }
    }

    private static class pluto_argument {
        double J;
        double S;
        double P;

        public pluto_argument(double j, double s, double p) {
            this.J = j;
            this.S = s;
            this.P = p;
        }
    }
}

