/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.Vsop87;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Venus {
    static double cJD = 0.0;
    static double cL = 0.0;
    static double cB = 0.0;
    static double cR = 0.0;

    public static void ln_get_venus_equ_coords(double JD, LnEquPosn position) {
        double c;
        double b;
        double a;
        double last;
        double delta;
        double diff;
        LnHelioPosn h_sol = new LnHelioPosn();
        LnHelioPosn h_venus = new LnHelioPosn();
        LnRectPosn g_sol = new LnRectPosn();
        LnRectPosn g_venus = new LnRectPosn();
        double t = 0.0;
        Solar.ln_get_solar_geom_coords(JD, h_sol);
        Transform.ln_get_rect_from_helio(h_sol, g_sol);
        do {
            last = t;
            Venus.ln_get_venus_helio_coords(JD - t, h_venus);
            Transform.ln_get_rect_from_helio(h_venus, g_venus);
            a = g_sol.X + g_venus.X;
            b = g_sol.Y + g_venus.Y;
            c = g_sol.Z + g_venus.Z;
            delta = a * a + b * b + c * c;
        } while ((diff = (t = (delta = Math.sqrt(delta)) * 0.0057755183) - last) > 1.0E-4 || diff < -1.0E-4);
        double ra = Math.atan2(b, a);
        double dec = c / delta;
        dec = Math.asin(dec);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_venus_helio_coords(double JD, LnHelioPosn position) {
        if (JD == cJD) {
            position.L = cL;
            position.B = cB;
            position.R = cR;
            return;
        }
        double t = (JD - 2451545.0) / 365250.0;
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double t5 = t4 * t;
        double L0 = Vsop87.ln_calc_series(Longitude.venus_longitude_l0, t);
        double L1 = Vsop87.ln_calc_series(Longitude.venus_longitude_l1, t);
        double L2 = Vsop87.ln_calc_series(Longitude.venus_longitude_l2, t);
        double L3 = Vsop87.ln_calc_series(Longitude.venus_longitude_l3, t);
        double L4 = Vsop87.ln_calc_series(Longitude.venus_longitude_l4, t);
        double L5 = Vsop87.ln_calc_series(Longitude.venus_longitude_l5, t);
        position.L = L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5;
        double B0 = Vsop87.ln_calc_series(Latitude.venus_latitude_b0, t);
        double B1 = Vsop87.ln_calc_series(Latitude.venus_latitude_b1, t);
        double B2 = Vsop87.ln_calc_series(Latitude.venus_latitude_b2, t);
        double B3 = Vsop87.ln_calc_series(Latitude.venus_latitude_b3, t);
        double B4 = Vsop87.ln_calc_series(Latitude.venus_latitude_b4, t);
        double B5 = Vsop87.ln_calc_series(Latitude.venus_latitude_b5, t);
        position.B = B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5;
        double R0 = Vsop87.ln_calc_series(Radius.venus_radius_r0, t);
        double R1 = Vsop87.ln_calc_series(Radius.venus_radius_r1, t);
        double R2 = Vsop87.ln_calc_series(Radius.venus_radius_r2, t);
        double R3 = Vsop87.ln_calc_series(Radius.venus_radius_r3, t);
        double R4 = Vsop87.ln_calc_series(Radius.venus_radius_r4, t);
        double R5 = Vsop87.ln_calc_series(Radius.venus_radius_r5, t);
        position.R = R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5;
        position.L = Utility.ln_rad_to_deg(position.L);
        position.B = Utility.ln_rad_to_deg(position.B);
        position.L = Utility.ln_range_degrees(position.L);
        Vsop87.ln_vsop87_to_fk5(position, JD);
        cJD = JD;
        cL = position.L;
        cB = position.B;
        cR = position.R;
    }

    public static double ln_get_venus_earth_dist(double JD) {
        LnHelioPosn h_venus = new LnHelioPosn();
        LnHelioPosn h_earth = new LnHelioPosn();
        LnRectPosn g_venus = new LnRectPosn();
        LnRectPosn g_earth = new LnRectPosn();
        Venus.ln_get_venus_helio_coords(JD, h_venus);
        Earth.ln_get_earth_helio_coords(JD, h_earth);
        Transform.ln_get_rect_from_helio(h_venus, g_venus);
        Transform.ln_get_rect_from_helio(h_earth, g_earth);
        double x = g_venus.X - g_earth.X;
        double y = g_venus.Y - g_earth.Y;
        double z = g_venus.Z - g_earth.Z;
        x *= x;
        y *= y;
        z *= z;
        return Math.sqrt(x + y + z);
    }

    public static double ln_get_venus_solar_dist(double JD) {
        LnHelioPosn h_venus = new LnHelioPosn();
        Venus.ln_get_venus_helio_coords(JD, h_venus);
        return h_venus.R;
    }

    public static double ln_get_venus_magnitude(double JD) {
        double r = Venus.ln_get_venus_solar_dist(JD);
        double delta = Venus.ln_get_venus_earth_dist(JD);
        double i = Venus.ln_get_venus_phase(JD);
        double i2 = i * i;
        double i3 = i2 * i;
        return -4.4 + 5.0 * Math.log10(r * delta) + 9.0E-4 * i + 2.39E-4 * i2 - 6.5E-7 * i3;
    }

    public static double ln_get_venus_disk(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Venus.ln_get_venus_solar_dist(JD);
        double delta = Venus.ln_get_venus_earth_dist(JD);
        return ((r + delta) * (r + delta) - R * R) / (4.0 * r * delta);
    }

    public static double ln_get_venus_phase(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Venus.ln_get_venus_solar_dist(JD);
        double delta = Venus.ln_get_venus_earth_dist(JD);
        double i = (r * r + delta * delta - R * R) / (2.0 * r * delta);
        i = Math.acos(i);
        return Utility.ln_rad_to_deg(i);
    }

    public static int ln_get_venus_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Venus.ln_get_venus_equ_coords(JD, position);
            }
        }, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static double ln_get_venus_sdiam(double JD) {
        double So = 8.41;
        double dist = Venus.ln_get_venus_earth_dist(JD);
        return So / dist;
    }

    public static void ln_get_venus_rect_helio(double JD, LnRectPosn position) {
        LnHelioPosn venus = new LnHelioPosn();
        Venus.ln_get_venus_helio_coords(JD, venus);
        Transform.ln_get_rect_from_helio(venus, position);
    }

    static class Radius {
        private static final Vsop87.LnVsop[] venus_radius_r0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.72334820891, 0.0, 0.0), new Vsop87.LnVsop(0.00489824182, 4.02151831717, 10213.285546211), new Vsop87.LnVsop(1.658058E-5, 4.90206728031, 20426.571092422), new Vsop87.LnVsop(1.632096E-5, 2.84548795207, 7860.4193924392), new Vsop87.LnVsop(1.378043E-5, 1.12846591367, 11790.6290886588), new Vsop87.LnVsop(4.98395E-6, 2.58682193892, 9683.5945811164), new Vsop87.LnVsop(3.73958E-6, 1.42314832858, 3930.2096962196), new Vsop87.LnVsop(2.63615E-6, 5.52938716941, 9437.762934887), new Vsop87.LnVsop(2.37454E-6, 2.55136053886, 15720.8387848784), new Vsop87.LnVsop(2.21985E-6, 2.01346696541, 19367.1891622328), new Vsop87.LnVsop(1.19466E-6, 3.01975080538, 10404.7338123226), new Vsop87.LnVsop(1.25896E-6, 2.72769850819, 1577.3435424478), new Vsop87.LnVsop(7.6176E-7, 1.59574968674, 9153.9036160218), new Vsop87.LnVsop(8.5337E-7, 3.98598666191, 19651.048481098), new Vsop87.LnVsop(7.4347E-7, 4.11957779786, 5507.5532386674), new Vsop87.LnVsop(4.1902E-7, 1.64282225331, 18837.49819713819), new Vsop87.LnVsop(4.2494E-7, 3.81864493274, 13367.9726311066), new Vsop87.LnVsop(3.9437E-7, 5.39018702243, 23581.2581773176), new Vsop87.LnVsop(2.9042E-7, 5.67739528728, 5661.3320491522), new Vsop87.LnVsop(2.7555E-7, 5.72392434415, 775.522611324), new Vsop87.LnVsop(2.7288E-7, 4.8214049462, 11015.1064773348), new Vsop87.LnVsop(3.1274E-7, 2.31806719544, 9999.986450773), new Vsop87.LnVsop(1.97E-7, 4.96157560246, 11322.6640983044), new Vsop87.LnVsop(1.9811E-7, 0.53189302682, 27511.4678735372), new Vsop87.LnVsop(1.3569E-7, 3.75536825122, 18073.7049386502), new Vsop87.LnVsop(1.2921E-7, 1.13381083556, 10206.1719992102), new Vsop87.LnVsop(1.6214E-7, 0.56446585474, 529.6909650946), new Vsop87.LnVsop(1.1828E-7, 5.0903796656, 3154.6870848956), new Vsop87.LnVsop(1.1729E-7, 0.23450811362, 7084.8967811152), new Vsop87.LnVsop(1.3066E-7, 5.24354222739, 17298.1823273262), new Vsop87.LnVsop(1.318E-7, 3.37207825651, 13745.3462390224), new Vsop87.LnVsop(9.097E-8, 3.07004839111, 1109.3785520934), new Vsop87.LnVsop(1.0818E-7, 2.45024714924, 10239.5838660108), new Vsop87.LnVsop(1.1434E-7, 4.56780914249, 29050.7837433492), new Vsop87.LnVsop(8.377E-8, 5.78327641089, 30639.856638633), new Vsop87.LnVsop(8.193E-8, 1.95023341446, 22003.9146348698), new Vsop87.LnVsop(9.319E-8, 1.61646997033, 2352.8661537718), new Vsop87.LnVsop(1.0653E-7, 1.95585283247, 31441.6775697568), new Vsop87.LnVsop(1.0357E-7, 1.20234990063, 15874.6175953632), new Vsop87.LnVsop(9.585E-8, 1.46639856227, 19999.97290154599), new Vsop87.LnVsop(6.504E-8, 2.17386891309, 14143.4952424306), new Vsop87.LnVsop(7.555E-8, 1.13845893425, 8624.2126509272), new Vsop87.LnVsop(6.438E-8, 0.84494385894, 6283.0758499914), new Vsop87.LnVsop(5.895E-8, 0.01147034372, 8635.9420037632), new Vsop87.LnVsop(5.633E-8, 3.94955705099, 12566.1516999828), new Vsop87.LnVsop(5.521E-8, 1.27351436322, 18307.8072320436), new Vsop87.LnVsop(4.488E-8, 2.47835713175, 191.4482661116), new Vsop87.LnVsop(4.524E-8, 4.73049812703, 19896.8801273274), new Vsop87.LnVsop(6.182E-8, 3.25901855473, 6872.6731195112), new Vsop87.LnVsop(6.076E-8, 0.35368446866, 21228.3920235458), new Vsop87.LnVsop(4.315E-8, 2.59737099527, 4551.9534970588), new Vsop87.LnVsop(6.001E-8, 3.37877140835, 35371.8872659764), new Vsop87.LnVsop(3.852E-8, 1.01162850363, 9786.687355335), new Vsop87.LnVsop(4.033E-8, 5.8119465E-4, 801.8209311238), new Vsop87.LnVsop(3.913E-8, 5.56523869375, 10596.1820784342), new Vsop87.LnVsop(2.709E-8, 5.80195530113, 7064.1213856228), new Vsop87.LnVsop(3.216E-8, 0.39767254849, 10186.9872264112), new Vsop87.LnVsop(3.089E-8, 6.26174762875, 14945.3161735544), new Vsop87.LnVsop(2.983E-8, 4.21306731485, 28521.0927782546), new Vsop87.LnVsop(3.28E-8, 0.7060348435, 10742.9765113056), new Vsop87.LnVsop(3.495E-8, 4.79876624499, 39302.096962196), new Vsop87.LnVsop(3.172E-8, 1.80518718365, 25158.6017197654), new Vsop87.LnVsop(2.463E-8, 0.68708155159, 10988.808157535), new Vsop87.LnVsop(2.374E-8, 3.7794897259, 21535.9496445154), new Vsop87.LnVsop(2.199E-8, 2.82965458882, 8662.240323563), new Vsop87.LnVsop(1.958E-8, 5.41763443097, 16496.3613962024), new Vsop87.LnVsop(1.876E-8, 2.63426835834, 29580.4747084438), new Vsop87.LnVsop(1.902E-8, 2.85782199151, 3532.0606928114), new Vsop87.LnVsop(1.706E-8, 3.67573010387, 26.2983197998), new Vsop87.LnVsop(1.82E-8, 0.41906719561, 4705.7323075436), new Vsop87.LnVsop(1.857E-8, 1.50350423721, 10021.8372800994), new Vsop87.LnVsop(2.086E-8, 6.22149960504, 43232.3066584156), new Vsop87.LnVsop(1.945E-8, 2.21581377123, 19786.67380610799), new Vsop87.LnVsop(1.497E-8, 0.00134773818, 17277.4069318338), new Vsop87.LnVsop(1.831E-8, 3.23180044003, 29088.811415985), new Vsop87.LnVsop(1.422E-8, 5.85815118404, 9676.4810341156), new Vsop87.LnVsop(1.223E-8, 5.55818994329, 6770.7106012456), new Vsop87.LnVsop(1.135E-8, 5.91731919731, 13936.794505134), new Vsop87.LnVsop(1.483E-8, 2.4755111452, 31749.2351907264), new Vsop87.LnVsop(1.185E-8, 1.42087628352, 4732.0306273434), new Vsop87.LnVsop(1.323E-8, 2.48821075422, 9690.7081281172), new Vsop87.LnVsop(1.237E-8, 1.8850384289, 19374.3027092336), new Vsop87.LnVsop(1.402E-8, 5.17536780118, 10316.3783204296), new Vsop87.LnVsop(1.257E-8, 5.24711268081, 19360.07561523199), new Vsop87.LnVsop(1.041E-8, 3.05620764519, 25934.1243310894), new Vsop87.LnVsop(1.174E-8, 1.42916822908, 18875.525869774), new Vsop87.LnVsop(1.277E-8, 1.35812964004, 47162.5163546352), new Vsop87.LnVsop(9.19E-9, 6.26767378713, 20618.0193585336), new Vsop87.LnVsop(9.07E-9, 1.12515741342, 12592.4500197826), new Vsop87.LnVsop(1.093E-8, 4.64451665343, 33019.0211122046), new Vsop87.LnVsop(1.012E-8, 1.09063299331, 1059.3819301892), new Vsop87.LnVsop(7.83E-9, 2.02117411797, 24356.7807886416), new Vsop87.LnVsop(7.79E-9, 0.41587370509, 3340.6124266998), new Vsop87.LnVsop(7.02E-9, 1.15494723276, 16983.9961474566), new Vsop87.LnVsop(8.78E-9, 0.87851267907, 38734.3783244656), new Vsop87.LnVsop(6.2E-9, 0.9073617308, 17778.11626694899), new Vsop87.LnVsop(6.08E-9, 1.58478313439, 9573.388259897), new Vsop87.LnVsop(8.0E-9, 3.94213003073, 10138.5039476437), new Vsop87.LnVsop(7.58E-9, 1.31882722638, 9967.4538999816), new Vsop87.LnVsop(8.02E-9, 2.78173370208, 51092.7260508548), new Vsop87.LnVsop(6.64E-9, 4.45866629009, 3128.3887650958), new Vsop87.LnVsop(6.68E-9, 5.10542540579, 382.8965322232), new Vsop87.LnVsop(5.3E-9, 0.85392938403, 10234.0609417034), new Vsop87.LnVsop(5.09E-9, 3.56810277681, 28286.9904848612), new Vsop87.LnVsop(6.0E-9, 4.25927697166, 41962.5207369374), new Vsop87.LnVsop(6.01E-9, 5.78144137927, 213.299095438), new Vsop87.LnVsop(5.95E-9, 2.8304364007, 22805.7355659936), new Vsop87.LnVsop(6.73E-9, 6.06080293558, 36949.2308084242), new Vsop87.LnVsop(5.37E-9, 5.85435364687, 9103.9069941176), new Vsop87.LnVsop(5.44E-9, 5.44804869552, 3723.508958923), new Vsop87.LnVsop(4.93E-9, 3.8494058375, 27991.40181316), new Vsop87.LnVsop(6.35E-9, 0.76493226364, 8094.5216858326), new Vsop87.LnVsop(4.35E-9, 6.21370952619, 27197.2816936676), new Vsop87.LnVsop(4.59E-9, 3.55062885409, 20213.271996984), new Vsop87.LnVsop(3.98E-9, 6.16269975784, 10426.584641649), new Vsop87.LnVsop(3.78E-9, 2.41665947591, 18844.61174413899), new Vsop87.LnVsop(4.21E-9, 4.86558476805, 9146.790069021), new Vsop87.LnVsop(5.0E-9, 4.20351458644, 55022.9357470744), new Vsop87.LnVsop(4.04E-9, 4.96112893536, 37410.5672398786), new Vsop87.LnVsop(4.02E-9, 2.97963246945, 10220.3990932118), new Vsop87.LnVsop(4.64E-9, 2.59869499733, 18734.4054229196), new Vsop87.LnVsop(3.53E-9, 0.08229680434, 10103.0792249916), new Vsop87.LnVsop(3.48E-9, 4.90260339364, 18830.38465013739), new Vsop87.LnVsop(3.39E-9, 3.23485348169, 24150.080051345), new Vsop87.LnVsop(4.31E-9, 1.21298886779, 40879.4405046438), new Vsop87.LnVsop(3.75E-9, 6.17532088119, 26087.9031415742), new Vsop87.LnVsop(4.09E-9, 3.12070020561, 9050.8108418032), new Vsop87.LnVsop(3.85E-9, 1.94284690176, 283.8593188652), new Vsop87.LnVsop(3.31E-9, 4.89790702632, 12432.0426503978), new Vsop87.LnVsop(3.3E-9, 4.29239717956, 26735.9452622132), new Vsop87.LnVsop(3.1E-9, 0.50879975679, 38204.687359371), new Vsop87.LnVsop(3.29E-9, 3.88427322515, 29864.334027309), new Vsop87.LnVsop(3.13E-9, 1.36138752543, 10192.5101507186), new Vsop87.LnVsop(3.47E-9, 3.5843980722, 27490.6924780448), new Vsop87.LnVsop(2.51E-9, 3.78618457047, 10063.7223490764), new Vsop87.LnVsop(2.45E-9, 3.84553750369, 9411.4646150872), new Vsop87.LnVsop(2.81E-9, 4.50895217144, 32217.2001810808), new Vsop87.LnVsop(2.37E-9, 0.87748812264, 6681.2248533996), new Vsop87.LnVsop(3.15E-9, 5.62657778233, 58953.145443294), new Vsop87.LnVsop(3.11E-9, 4.15626121491, 10175.1525105732), new Vsop87.LnVsop(2.51E-9, 2.53793253681, 16522.6597160022), new Vsop87.LnVsop(2.18E-9, 5.08472965959, 7058.5984613154), new Vsop87.LnVsop(2.91E-9, 3.72573045764, 29999.959352319), new Vsop87.LnVsop(2.67E-9, 2.97685503991, 19573.37471066999), new Vsop87.LnVsop(2.8E-9, 3.70200084294, 47623.8527860896), new Vsop87.LnVsop(2.39E-9, 3.94545782067, 9580.5018068978), new Vsop87.LnVsop(2.46E-9, 2.1826106409, 9161.0171630226), new Vsop87.LnVsop(2.69E-9, 2.6276732396, 44809.6502008634), new Vsop87.LnVsop(2.54E-9, 2.69185768875, 3442.5749449654), new Vsop87.LnVsop(1.94E-9, 4.79747763686, 33794.5437235286), new Vsop87.LnVsop(2.03E-9, 2.54900468678, 2379.1644735716), new Vsop87.LnVsop(2.1E-9, 1.9093545552, 1551.045222648), new Vsop87.LnVsop(1.87E-9, 3.65645008095, 20452.8694122218), new Vsop87.LnVsop(2.24E-9, 2.43601863127, 9992.8729037722), new Vsop87.LnVsop(1.9E-9, 6.19594324465, 36147.4098773004), new Vsop87.LnVsop(1.76E-9, 4.29837616553, 10137.0194749354), new Vsop87.LnVsop(1.75E-9, 2.719933273, 20809.4676246452), new Vsop87.LnVsop(1.86E-9, 2.55096983527, 14919.0178537546), new Vsop87.LnVsop(1.61E-9, 4.13272566951, 23958.6317852334), new Vsop87.LnVsop(1.97E-9, 5.70241397428, 30666.1549584328), new Vsop87.LnVsop(1.6E-9, 4.46270605493, 18947.7045183576), new Vsop87.LnVsop(1.56E-9, 1.80543158863, 10787.6303445458), new Vsop87.LnVsop(1.92E-9, 5.34144333446, 10007.0999977738), new Vsop87.LnVsop(1.9E-9, 2.99208130371, 2218.7571041868), new Vsop87.LnVsop(2.09E-9, 4.83588196833, 20277.0078952874), new Vsop87.LnVsop(1.45E-9, 5.92559556225, 37724.7534197482), new Vsop87.LnVsop(1.98E-9, 0.77846666692, 62883.3551395136), new Vsop87.LnVsop(1.44E-9, 5.00261963924, 9264.1099372412), new Vsop87.LnVsop(1.71E-9, 2.05212624568, 7255.5696517344), new Vsop87.LnVsop(1.88E-9, 4.08173534559, 48739.859897083), new Vsop87.LnVsop(1.46E-9, 3.9337010358, 6309.3741697912), new Vsop87.LnVsop(1.45E-9, 5.0629554375, 39264.0692895602), new Vsop87.LnVsop(1.39E-9, 2.81266025896, 20.7753954924), new Vsop87.LnVsop(1.77E-9, 5.16224804657, 9835.9119382952), new Vsop87.LnVsop(1.2E-9, 0.21443767468, 31022.7531708562), new Vsop87.LnVsop(1.18E-9, 1.36333433479, 40077.61957352), new Vsop87.LnVsop(1.28E-9, 2.92458887987, 7.1135470008), new Vsop87.LnVsop(1.09E-9, 5.19050570589, 9830.3890139878), new Vsop87.LnVsop(1.5E-9, 5.73646272556, 632.7837393132), new Vsop87.LnVsop(1.06E-9, 0.62215793949, 11272.6674764002), new Vsop87.LnVsop(1.14E-9, 2.6330132652, 17468.8551979454), new Vsop87.LnVsop(1.23E-9, 6.22518843711, 53285.1848352418), new Vsop87.LnVsop(1.07E-9, 1.172589789, 43071.8992890308), new Vsop87.LnVsop(1.16E-9, 2.20934021321, 8521.1198767086), new Vsop87.LnVsop(1.04E-9, 1.01322416672, 41654.9631159678), new Vsop87.LnVsop(1.09E-9, 2.01412666864, 20419.45754542119), new Vsop87.LnVsop(1.02E-9, 4.23406964348, 10251.3132188468), new Vsop87.LnVsop(1.16E-9, 1.27731728606, 10199.0584522094), new Vsop87.LnVsop(1.12E-9, 2.24436894064, 18204.71445782499), new Vsop87.LnVsop(1.18E-9, 0.237542072, 10497.1448650762), new Vsop87.LnVsop(1.23E-9, 0.88054816668, 34596.3646546524), new Vsop87.LnVsop(1.02E-9, 4.3943864662, 18300.69368504279), new Vsop87.LnVsop(1.31E-9, 6.01711652115, 9367.2027114598), new Vsop87.LnVsop(1.0E-9, 5.00532389609, 10175.2578735752), new Vsop87.LnVsop(1.07E-9, 0.41270205378, 40853.142184844), new Vsop87.LnVsop(1.32E-9, 5.45008342761, 11506.7697697936), new Vsop87.LnVsop(9.8E-10, 1.07722950958, 13553.8979729108), new Vsop87.LnVsop(9.4E-10, 2.91719764259, 44007.8292697396), new Vsop87.LnVsop(9.7E-10, 1.04004223634, 68050.42387851159), new Vsop87.LnVsop(1.27E-9, 2.20215372683, 66813.5648357332), new Vsop87.LnVsop(1.11E-9, 1.57823839032, 29043.67019634839), new Vsop87.LnVsop(1.18E-9, 2.3326817689, 18314.9207790444), new Vsop87.LnVsop(9.0E-10, 2.42353056125, 32858.61374281979), new Vsop87.LnVsop(1.09E-9, 3.82796787296, 19470.28193645139), new Vsop87.LnVsop(1.11E-9, 4.47666957576, 29057.89729034999), new Vsop87.LnVsop(1.01E-9, 3.4152849366, 19264.0963880142), new Vsop87.LnVsop(9.2E-10, 3.66289799512, 22645.32819660879), new Vsop87.LnVsop(9.4E-10, 6.07530805791, 10846.0692855242), new Vsop87.LnVsop(1.14E-9, 4.02718653431, 7576.560073574), new Vsop87.LnVsop(8.7E-10, 6.01880724674, 17085.9586657222), new Vsop87.LnVsop(1.09E-9, 5.46886607309, 52670.0695933026), new Vsop87.LnVsop(1.08E-9, 5.44460610707, 19050.7972925762), new Vsop87.LnVsop(1.06E-9, 0.55746535085, 34363.365597556), new Vsop87.LnVsop(7.6E-10, 6.15177368654, 27682.1407441564), new Vsop87.LnVsop(1.07E-9, 4.80525404063, 8144.2787113044), new Vsop87.LnVsop(7.1E-10, 2.26530392323, 8631.326197928), new Vsop87.LnVsop(9.7E-10, 5.13538849186, 22779.4372461938), new Vsop87.LnVsop(9.5E-10, 5.25816059997, 522.5774180938), new Vsop87.LnVsop(6.9E-10, 1.57003462107, 20956.2620575166), new Vsop87.LnVsop(6.8E-10, 6.22807515295, 10419.4710946482), new Vsop87.LnVsop(9.1E-10, 4.28652743953, 10110.1927719924), new Vsop87.LnVsop(8.9E-10, 1.79703857734, 45585.1728121874), new Vsop87.LnVsop(6.7E-10, 2.25900071584, 9360.089164459), new Vsop87.LnVsop(8.5E-10, 0.67062144972, 56600.2792895222), new Vsop87.LnVsop(8.0E-10, 1.58278081077, 19992.85935454519), new Vsop87.LnVsop(8.5E-10, 4.52011215904, 29786.660256881), new Vsop87.LnVsop(6.8E-10, 4.48235266554, 10632.7701900862), new Vsop87.LnVsop(6.3E-10, 0.36743160711, 17248.4253018544), new Vsop87.LnVsop(6.4E-10, 4.33495700921, 47938.0389659592), new Vsop87.LnVsop(7.1E-10, 3.03858484137, 11787.1059703098), new Vsop87.LnVsop(6.7E-10, 3.64786869696, 11764.330768859), new Vsop87.LnVsop(8.7E-10, 4.81823064076, 2107.0345075424), new Vsop87.LnVsop(7.0E-10, 2.35648061034, 11794.1522070078), new Vsop87.LnVsop(8.0E-10, 2.33248094128, 38526.574350872), new Vsop87.LnVsop(7.0E-10, 3.704540611, 8734.4189721466), new Vsop87.LnVsop(7.7E-10, 4.49569185467, 20007.0864485468), new Vsop87.LnVsop(7.2E-10, 1.19410424468, 10217.2176994741), new Vsop87.LnVsop(6.8E-10, 2.01841060183, 14128.2427712456), new Vsop87.LnVsop(6.4E-10, 5.39293951654, 7880.08915333899), new Vsop87.LnVsop(6.6E-10, 3.20467070973, 14765.2390432698), new Vsop87.LnVsop(8.0E-10, 3.4162045777, 48417.97290558199), new Vsop87.LnVsop(6.6E-10, 5.85414440204, 9793.8009023358), new Vsop87.LnVsop(8.2E-10, 3.62592908644, 70743.77453195279), new Vsop87.LnVsop(5.8E-10, 4.9516345926, 30110.1656735384), new Vsop87.LnVsop(7.9E-10, 6.24161471033, 6037.244203762), new Vsop87.LnVsop(6.9E-10, 5.50183658445, 19793.7873531088), new Vsop87.LnVsop(7.6E-10, 3.40005875207, 245.8316462294), new Vsop87.LnVsop(5.6E-10, 1.24148350566, 10207.7626219036), new Vsop87.LnVsop(7.0E-10, 2.45123308846, 10218.8084705184), new Vsop87.LnVsop(6.4E-10, 5.53983104501, 10735.8629643048), new Vsop87.LnVsop(5.4E-10, 3.6225971324, 27461.7108480654), new Vsop87.LnVsop(7.3E-10, 1.75920522146, 1589.0728952838), new Vsop87.LnVsop(7.5E-10, 3.38244819846, 4214.0690150848), new Vsop87.LnVsop(5.4E-10, 0.64971567468, 9929.4262273458), new Vsop87.LnVsop(5.4E-10, 3.4095963723, 18418.01355326299), new Vsop87.LnVsop(5.6E-10, 3.65815006538, 14169.7935622304), new Vsop87.LnVsop(5.6E-10, 0.71243223808, 9896.8936765544), new Vsop87.LnVsop(5.2E-10, 1.33348131832, 20400.2727726222), new Vsop87.LnVsop(6.7E-10, 3.1280659541, 5481.2549188676), new Vsop87.LnVsop(5.8E-10, 0.54482893546, 28313.288804661), new Vsop87.LnVsop(5.4E-10, 0.15603935681, 19580.4882576708), new Vsop87.LnVsop(5.1E-10, 3.3751547351, 9256.9963902404), new Vsop87.LnVsop(6.3E-10, 3.38894120617, 49515.382508407), new Vsop87.LnVsop(6.9E-10, 4.90917651401, 63498.47038145279), new Vsop87.LnVsop(5.7E-10, 5.0743774203, 18521.1063274816), new Vsop87.LnVsop(5.0E-10, 1.59156823654, 18631.31264870099), new Vsop87.LnVsop(5.4E-10, 6.25816208666, 37674.9963942764), new Vsop87.LnVsop(5.7E-10, 5.4806634672, 24383.0791084414), new Vsop87.LnVsop(4.5E-10, 1.1046649066, 10408.2569306716), new Vsop87.LnVsop(5.1E-10, 3.61196470338, 426.598190876), new Vsop87.LnVsop(5.8E-10, 4.40545155507, 8617.0991039264), new Vsop87.LnVsop(5.7E-10, 2.09567711267, 60530.4889857418), new Vsop87.LnVsop(6.0E-10, 5.94659889997, 13897.6635962012), new Vsop87.LnVsop(5.1E-10, 5.4723851772, 57837.1383323006), new Vsop87.LnVsop(5.1E-10, 2.32438478428, 19779.56025910719), new Vsop87.LnVsop(5.2E-10, 3.23766328818, 18940.59097135679), new Vsop87.LnVsop(4.8E-10, 1.12206254877, 9779.5738083342), new Vsop87.LnVsop(5.8E-10, 3.08646083897, 12074.488407524), new Vsop87.LnVsop(4.6E-10, 4.07536026888, 7863.9425107882), new Vsop87.LnVsop(4.5E-10, 4.75746520642, 7856.89627409019), new Vsop87.LnVsop(5.0E-10, 3.70569982975, 42456.7840470916), new Vsop87.LnVsop(4.4E-10, 1.29248911155, 69166.430989505), new Vsop87.LnVsop(4.6E-10, 0.41229872114, 7564.830720738), new Vsop87.LnVsop(3.9E-10, 1.2523882018, 10323.4918674304), new Vsop87.LnVsop(4.4E-10, 6.17937388307, 13341.6743113068), new Vsop87.LnVsop(5.3E-10, 4.71379706388, 53445.5922046266), new Vsop87.LnVsop(4.1E-10, 3.48003037828, 37895.4262903674), new Vsop87.LnVsop(4.0E-10, 1.2330554626, 10228.538017396), new Vsop87.LnVsop(5.3E-10, 5.04979874661, 74673.9842281724), new Vsop87.LnVsop(3.9E-10, 2.15376025201, 8947.7180675846), new Vsop87.LnVsop(3.9E-10, 0.70253732683, 18093.37469954999), new Vsop87.LnVsop(5.2E-10, 1.18164377451, 10211.8010735027), new Vsop87.LnVsop(4.7E-10, 1.78672260794, 10401.2106939736), new Vsop87.LnVsop(4.0E-10, 3.66961416802, 10198.033075026), new Vsop87.LnVsop(5.1E-10, 2.71698589018, 94325.0327092704), new Vsop87.LnVsop(3.8E-10, 1.36497153223, 21202.093703746), new Vsop87.LnVsop(4.9E-10, 1.2133595942, 9721.6222537522), new Vsop87.LnVsop(4.2E-10, 6.05968230173, 105460.99111839019), new Vsop87.LnVsop(4.0E-10, 1.97642764685, 32243.4985008806), new Vsop87.LnVsop(3.6E-10, 4.96702216961, 36301.18868778519), new Vsop87.LnVsop(3.7E-10, 5.29642935562, 38.0276726358), new Vsop87.LnVsop(3.5E-10, 2.34112124655, 58946.51688439399), new Vsop87.LnVsop(3.4E-10, 5.77533382849, 51868.2486621788), new Vsop87.LnVsop(3.4E-10, 1.82989750626, 17675.0234927304), new Vsop87.LnVsop(3.4E-10, 0.7649366411, 55798.4583583984), new Vsop87.LnVsop(3.5E-10, 1.09353675147, 69159.80243060499), new Vsop87.LnVsop(3.2E-10, 3.3296078187, 71519.2971432768), new Vsop87.LnVsop(3.1E-10, 0.68615213145, 10202.2398459471), new Vsop87.LnVsop(3.0E-10, 4.42039942947, 10459.1171924404), new Vsop87.LnVsop(2.9E-10, 1.30367701539, 20103.06567576459), new Vsop87.LnVsop(3.1E-10, 4.51793347997, 2957.7158944766), new Vsop87.LnVsop(3.6E-10, 5.67202610552, 24341.5283174566), new Vsop87.LnVsop(2.9E-10, 3.36506645849, 10288.0671447783), new Vsop87.LnVsop(2.9E-10, 1.40019042576, 9988.9407505091), new Vsop87.LnVsop(3.9E-10, 5.15481059724, 20350.3050211464), new Vsop87.LnVsop(3.4E-10, 5.22945947227, 8673.969676399), new Vsop87.LnVsop(3.9E-10, 4.50883171158, 16004.6981037436), new Vsop87.LnVsop(2.8E-10, 2.32945945641, 11392.4800852506), new Vsop87.LnVsop(3.2E-10, 5.46972716255, 64607.84893354619), new Vsop87.LnVsop(2.9E-10, 0.59723613788, 26709.6469424134), new Vsop87.LnVsop(2.9E-10, 6.1647683051, 65236.2212932854), new Vsop87.LnVsop(2.6E-10, 5.36096904409, 1478.8665740644), new Vsop87.LnVsop(3.6E-10, 1.29565084626, 90394.82301305079)};
        private static final Vsop87.LnVsop[] venus_radius_r1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.4551041E-4, 0.89198706276, 10213.285546211), new Vsop87.LnVsop(2.34203E-6, 1.77224942363, 20426.571092422), new Vsop87.LnVsop(2.33998E-6, 3.14159265359, 0.0), new Vsop87.LnVsop(2.3867E-7, 1.11270233944, 9437.762934887), new Vsop87.LnVsop(1.0571E-7, 4.59152848465, 1577.3435424478), new Vsop87.LnVsop(9.124E-8, 4.53540895241, 10404.7338123226), new Vsop87.LnVsop(6.6E-8, 5.97725159435, 5507.5532386674), new Vsop87.LnVsop(4.665E-8, 3.87732289579, 9153.9036160218), new Vsop87.LnVsop(3.84E-8, 5.66215379445, 13367.9726311066), new Vsop87.LnVsop(2.662E-8, 2.82393816664, 10206.1719992102), new Vsop87.LnVsop(2.194E-8, 2.0532406002, 775.522611324), new Vsop87.LnVsop(2.093E-8, 2.54944827541, 18837.49819713819), new Vsop87.LnVsop(1.781E-8, 2.64889239766, 30639.856638633), new Vsop87.LnVsop(1.844E-8, 1.87568236008, 11015.1064773348), new Vsop87.LnVsop(1.303E-8, 0.20613045604, 11322.6640983044), new Vsop87.LnVsop(1.168E-8, 0.79442892853, 17298.1823273262), new Vsop87.LnVsop(1.002E-8, 6.16544615317, 10239.5838660108), new Vsop87.LnVsop(9.15E-9, 4.59854496963, 1109.3785520934), new Vsop87.LnVsop(8.82E-9, 0.66800567417, 18073.7049386502), new Vsop87.LnVsop(8.46E-9, 5.58765716729, 12566.1516999828), new Vsop87.LnVsop(1.08E-8, 4.94678408464, 6283.0758499914), new Vsop87.LnVsop(8.88E-9, 2.47876529003, 3154.6870848956), new Vsop87.LnVsop(9.04E-9, 0.81413053841, 10596.1820784342), new Vsop87.LnVsop(8.2E-9, 0.89897968675, 5661.3320491522), new Vsop87.LnVsop(8.45E-9, 5.48503535862, 529.6909650946), new Vsop87.LnVsop(8.24E-9, 3.74890493484, 7084.8967811152), new Vsop87.LnVsop(6.55E-9, 5.06545516257, 22003.9146348698), new Vsop87.LnVsop(8.47E-9, 0.4412049234, 8635.9420037632), new Vsop87.LnVsop(6.38E-9, 4.10125783744, 191.4482661116), new Vsop87.LnVsop(6.18E-9, 3.15185635462, 10186.9872264112), new Vsop87.LnVsop(5.3E-9, 5.86995223147, 2352.8661537718), new Vsop87.LnVsop(5.76E-9, 2.2521198576, 21228.3920235458), new Vsop87.LnVsop(5.17E-9, 5.33412478409, 14143.4952424306), new Vsop87.LnVsop(6.64E-9, 2.86641799035, 8624.2126509272), new Vsop87.LnVsop(5.52E-9, 2.16807468414, 18307.8072320436), new Vsop87.LnVsop(5.18E-9, 4.34059510806, 9786.687355335), new Vsop87.LnVsop(5.01E-9, 5.56479595613, 10742.9765113056), new Vsop87.LnVsop(4.26E-9, 1.0216144312, 7064.1213856228), new Vsop87.LnVsop(4.16E-9, 1.26242491254, 9676.4810341156), new Vsop87.LnVsop(3.93E-9, 0.78006660798, 9690.7081281172), new Vsop87.LnVsop(3.36E-9, 3.17756997609, 10988.808157535), new Vsop87.LnVsop(3.75E-9, 0.66142254036, 19360.07561523199), new Vsop87.LnVsop(3.61E-9, 0.19448210327, 19374.3027092336), new Vsop87.LnVsop(3.14E-9, 1.09753065455, 4551.9534970588), new Vsop87.LnVsop(3.29E-9, 0.58926282996, 16496.3613962024), new Vsop87.LnVsop(3.39E-9, 5.76768761424, 10021.8372800994), new Vsop87.LnVsop(2.89E-9, 3.6722402015, 25158.6017197654), new Vsop87.LnVsop(2.23E-9, 4.33581625553, 19786.67380610799), new Vsop87.LnVsop(2.66E-9, 3.57410277687, 801.8209311238), new Vsop87.LnVsop(2.73E-9, 5.72814567551, 11790.6290886588), new Vsop87.LnVsop(2.75E-9, 5.65863344812, 19896.8801273274), new Vsop87.LnVsop(2.12E-9, 4.27040662743, 4705.7323075436), new Vsop87.LnVsop(2.3E-9, 6.13409928801, 1059.3819301892), new Vsop87.LnVsop(2.03E-9, 4.88193121349, 7860.4193924392), new Vsop87.LnVsop(2.41E-9, 1.12684737375, 26.2983197998), new Vsop87.LnVsop(2.15E-9, 3.13976767933, 14945.3161735544), new Vsop87.LnVsop(2.06E-9, 0.32759945446, 382.8965322232), new Vsop87.LnVsop(2.16E-9, 2.54929765288, 19651.048481098), new Vsop87.LnVsop(1.6E-9, 1.13642774778, 13936.794505134), new Vsop87.LnVsop(1.53E-9, 0.81251420624, 6770.7106012456), new Vsop87.LnVsop(1.5E-9, 5.11133177708, 28521.0927782546), new Vsop87.LnVsop(1.5E-9, 1.35720240642, 10220.3990932118), new Vsop87.LnVsop(1.49E-9, 5.03755185727, 29088.811415985), new Vsop87.LnVsop(1.27E-9, 4.49298610266, 3532.0606928114), new Vsop87.LnVsop(1.21E-9, 6.2703335254, 29580.4747084438), new Vsop87.LnVsop(1.46E-9, 6.16157870651, 8662.240323563), new Vsop87.LnVsop(1.17E-9, 3.56101830556, 24356.7807886416), new Vsop87.LnVsop(1.14E-9, 0.00568663739, 25934.1243310894), new Vsop87.LnVsop(1.27E-9, 0.66789441339, 3723.508958923), new Vsop87.LnVsop(1.48E-9, 0.36877913428, 9146.790069021), new Vsop87.LnVsop(1.06E-9, 4.26220077003, 9573.388259897), new Vsop87.LnVsop(1.36E-9, 5.09588289539, 19367.1891622328), new Vsop87.LnVsop(9.9E-10, 1.5138953635, 17277.4069318338), new Vsop87.LnVsop(1.17E-9, 0.57647358272, 9999.986450773), new Vsop87.LnVsop(9.7E-10, 3.71741720558, 213.299095438), new Vsop87.LnVsop(9.2E-10, 0.22936081655, 18830.38465013739), new Vsop87.LnVsop(1.12E-9, 4.04771058126, 9103.9069941176), new Vsop87.LnVsop(8.3E-10, 5.86195695833, 10234.0609417034), new Vsop87.LnVsop(7.9E-10, 0.64440357793, 18844.61174413899), new Vsop87.LnVsop(8.4E-10, 0.62796944327, 9683.5945811164), new Vsop87.LnVsop(1.07E-9, 1.77067111589, 17778.11626694899), new Vsop87.LnVsop(8.1E-10, 6.19048048769, 20618.0193585336), new Vsop87.LnVsop(8.7E-10, 0.15771136594, 33019.0211122046), new Vsop87.LnVsop(8.5E-10, 4.77733091614, 3930.2096962196), new Vsop87.LnVsop(8.6E-10, 2.215068207, 8094.5216858326), new Vsop87.LnVsop(7.4E-10, 0.82723399048, 3128.3887650958), new Vsop87.LnVsop(6.3E-10, 2.70493265779, 16983.9961474566), new Vsop87.LnVsop(5.9E-10, 3.32160695003, 10787.6303445458), new Vsop87.LnVsop(6.1E-10, 0.04044699966, 9161.0171630226), new Vsop87.LnVsop(6.4E-10, 4.13127333938, 9992.8729037722), new Vsop87.LnVsop(6.3E-10, 4.47517295578, 18875.525869774), new Vsop87.LnVsop(6.0E-10, 6.24567706571, 32217.2001810808), new Vsop87.LnVsop(7.6E-10, 4.84321073833, 4732.0306273434), new Vsop87.LnVsop(5.4E-10, 3.38449893196, 10426.584641649), new Vsop87.LnVsop(5.4E-10, 5.15928227, 28286.9904848612), new Vsop87.LnVsop(6.3E-10, 4.3234425963, 12592.4500197826), new Vsop87.LnVsop(5.9E-10, 3.65953929456, 10007.0999977738), new Vsop87.LnVsop(4.9E-10, 5.10267262491, 19573.37471066999), new Vsop87.LnVsop(4.7E-10, 5.79444960738, 68050.42387851159), new Vsop87.LnVsop(5.2E-10, 3.56658420552, 7255.5696517344), new Vsop87.LnVsop(5.0E-10, 1.61783309819, 36949.2308084242), new Vsop87.LnVsop(5.3E-10, 2.64129868542, 15874.6175953632), new Vsop87.LnVsop(4.2E-10, 2.02654328254, 7058.5984613154), new Vsop87.LnVsop(5.1E-10, 0.80486467278, 23581.2581773176), new Vsop87.LnVsop(4.0E-10, 3.89322312104, 20419.45754542119), new Vsop87.LnVsop(5.0E-10, 1.0746189946, 3442.5749449654), new Vsop87.LnVsop(3.8E-10, 1.77428239418, 10103.0792249916), new Vsop87.LnVsop(4.0E-10, 5.22873972349, 21535.9496445154), new Vsop87.LnVsop(3.8E-10, 0.10029856174, 11272.6674764002), new Vsop87.LnVsop(3.8E-10, 1.1641441986, 7.1135470008), new Vsop87.LnVsop(4.4E-10, 4.54118898535, 10192.5101507186), new Vsop87.LnVsop(4.7E-10, 0.0558943239, 12432.0426503978), new Vsop87.LnVsop(3.4E-10, 3.45481114998, 9830.3890139878), new Vsop87.LnVsop(3.7E-10, 4.97010610007, 3340.6124266998), new Vsop87.LnVsop(4.4E-10, 0.70533597362, 20213.271996984), new Vsop87.LnVsop(3.4E-10, 2.16487642765, 64460.6986819614), new Vsop87.LnVsop(3.1E-10, 1.57612397319, 36147.4098773004), new Vsop87.LnVsop(3.4E-10, 1.06669952696, 29864.334027309), new Vsop87.LnVsop(2.8E-10, 2.56454760402, 94138.32702008578), new Vsop87.LnVsop(2.9E-10, 0.59718407064, 59728.668054618), new Vsop87.LnVsop(3.1E-10, 3.27727318906, 19992.85935454519), new Vsop87.LnVsop(2.7E-10, 5.68943276986, 17085.9586657222), new Vsop87.LnVsop(3.0E-10, 3.03241502538, 40879.4405046438), new Vsop87.LnVsop(3.2E-10, 2.6426078826, 41962.5207369374), new Vsop87.LnVsop(3.5E-10, 0.26995532429, 1589.0728952838), new Vsop87.LnVsop(2.8E-10, 4.93395364921, 29050.7837433492), new Vsop87.LnVsop(2.8E-10, 3.58869616799, 40853.142184844), new Vsop87.LnVsop(2.9E-10, 2.79705093386, 20007.0864485468), new Vsop87.LnVsop(3.3E-10, 0.93875241519, 15720.8387848784), new Vsop87.LnVsop(2.4E-10, 2.74970637101, 18947.7045183576), new Vsop87.LnVsop(2.4E-10, 4.38966861409, 46386.9937433112), new Vsop87.LnVsop(2.4E-10, 0.73362177921, 9411.4646150872), new Vsop87.LnVsop(2.8E-10, 4.19559784013, 37674.9963942764), new Vsop87.LnVsop(2.4E-10, 1.18299920855, 426.598190876), new Vsop87.LnVsop(2.5E-10, 4.14802726798, 14919.0178537546), new Vsop87.LnVsop(3.0E-10, 1.24986033487, 27461.7108480654), new Vsop87.LnVsop(2.2E-10, 2.95789824506, 40077.61957352), new Vsop87.LnVsop(2.7E-10, 3.94986823486, 17468.8551979454), new Vsop87.LnVsop(2.5E-10, 4.75875623888, 27991.40181316), new Vsop87.LnVsop(2.2E-10, 4.11184201321, 19779.56025910719), new Vsop87.LnVsop(2.7E-10, 3.7244644608, 19793.7873531088), new Vsop87.LnVsop(2.7E-10, 6.12859780299, 38500.2760310722), new Vsop87.LnVsop(2.2E-10, 4.99040169444, 31022.7531708562), new Vsop87.LnVsop(2.1E-10, 0.63975130342, 13745.3462390224), new Vsop87.LnVsop(2.3E-10, 1.33505132122, 65236.2212932854), new Vsop87.LnVsop(2.0E-10, 0.91294578294, 22779.4372461938), new Vsop87.LnVsop(2.1E-10, 4.46897353468, 53285.1848352418), new Vsop87.LnVsop(2.0E-10, 4.15140915983, 2218.7571041868), new Vsop87.LnVsop(1.9E-10, 1.43653410349, 27197.2816936676), new Vsop87.LnVsop(2.7E-10, 1.22597317413, 42430.4857272918), new Vsop87.LnVsop(2.4E-10, 4.66952456612, 1551.045222648), new Vsop87.LnVsop(2.1E-10, 4.16155332491, 44007.8292697396), new Vsop87.LnVsop(1.8E-10, 5.45345109729, 6681.2248533996), new Vsop87.LnVsop(2.3E-10, 2.19259117717, 27511.4678735372), new Vsop87.LnVsop(1.8E-10, 4.24146756742, 31441.6775697568), new Vsop87.LnVsop(1.9E-10, 3.65054338893, 49515.382508407), new Vsop87.LnVsop(1.8E-10, 2.29853355765, 19264.0963880142), new Vsop87.LnVsop(2.0E-10, 3.68116637773, 14128.2427712456), new Vsop87.LnVsop(2.1E-10, 4.30316190532, 44809.6502008634), new Vsop87.LnVsop(1.7E-10, 3.02735393984, 28528.2063252554), new Vsop87.LnVsop(1.9E-10, 5.92656850674, 22805.7355659936), new Vsop87.LnVsop(2.0E-10, 5.80568617231, 10218.8084705184), new Vsop87.LnVsop(2.0E-10, 0.75829381378, 18314.9207790444), new Vsop87.LnVsop(1.7E-10, 5.63315744126, 16522.6597160022), new Vsop87.LnVsop(1.5E-10, 5.27016880041, 53445.5922046266), new Vsop87.LnVsop(1.5E-10, 6.06411037636, 18300.69368504279), new Vsop87.LnVsop(2.0E-10, 5.38470522864, 10207.7626219036), new Vsop87.LnVsop(1.5E-10, 5.81110284451, 43071.8992890308), new Vsop87.LnVsop(1.5E-10, 5.98462571207, 10228.538017396), new Vsop87.LnVsop(1.4E-10, 1.44966591677, 536.8045120954), new Vsop87.LnVsop(1.5E-10, 5.20122735812, 10198.033075026), new Vsop87.LnVsop(1.4E-10, 3.48144272414, 29786.660256881), new Vsop87.LnVsop(1.8E-10, 1.99790369768, 30831.3049047446), new Vsop87.LnVsop(1.7E-10, 2.36905439219, 33794.5437235286)};
        private static final Vsop87.LnVsop[] venus_radius_r2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.406587E-5, 5.06366395112, 10213.285546211), new Vsop87.LnVsop(1.5529E-7, 5.47321056992, 20426.571092422), new Vsop87.LnVsop(1.3059E-7, 0.0, 0.0), new Vsop87.LnVsop(1.096E-8, 2.78919545899, 9437.762934887), new Vsop87.LnVsop(4.87E-9, 6.27655636902, 1577.3435424478), new Vsop87.LnVsop(3.61E-9, 6.11959389556, 10404.7338123226), new Vsop87.LnVsop(3.1E-9, 1.39073645837, 5507.5532386674), new Vsop87.LnVsop(3.85E-9, 1.95564555688, 11015.1064773348), new Vsop87.LnVsop(3.71E-9, 2.33232050485, 775.522611324), new Vsop87.LnVsop(2.07E-9, 5.63406721595, 10239.5838660108), new Vsop87.LnVsop(1.67E-9, 1.1163973289, 13367.9726311066), new Vsop87.LnVsop(1.75E-9, 6.16674649733, 30639.856638633), new Vsop87.LnVsop(1.68E-9, 3.6404217099, 7084.8967811152), new Vsop87.LnVsop(1.2E-9, 5.85861348966, 9153.9036160218), new Vsop87.LnVsop(1.61E-9, 2.21564443685, 3154.6870848956), new Vsop87.LnVsop(1.18E-9, 2.62362056521, 8635.9420037632), new Vsop87.LnVsop(1.12E-9, 2.36235956804, 10596.1820784342), new Vsop87.LnVsop(9.3E-10, 0.74251193058, 12566.1516999828), new Vsop87.LnVsop(6.7E-10, 3.76089669118, 18837.49819713819), new Vsop87.LnVsop(6.5E-10, 2.47990173302, 11790.6290886588), new Vsop87.LnVsop(4.8E-10, 4.26821029269, 2352.8661537718), new Vsop87.LnVsop(4.9E-10, 5.51819305769, 191.4482661116), new Vsop87.LnVsop(4.8E-10, 2.51039041484, 17298.1823273262), new Vsop87.LnVsop(4.6E-10, 3.40293459332, 14143.4952424306), new Vsop87.LnVsop(4.1E-10, 1.84035920887, 11322.6640983044), new Vsop87.LnVsop(3.5E-10, 6.20303344591, 1109.3785520934), new Vsop87.LnVsop(3.9E-10, 4.76600160325, 18073.7049386502), new Vsop87.LnVsop(3.4E-10, 3.14302158146, 4705.7323075436), new Vsop87.LnVsop(3.4E-10, 0.4758455279, 26.2983197998), new Vsop87.LnVsop(4.6E-10, 3.30090415967, 6283.0758499914), new Vsop87.LnVsop(3.4E-10, 3.9229941824, 10021.8372800994), new Vsop87.LnVsop(3.4E-10, 3.23795065286, 22003.9146348698), new Vsop87.LnVsop(4.2E-10, 3.39360926939, 14945.3161735544), new Vsop87.LnVsop(4.4E-10, 4.39723735555, 7860.4193924392), new Vsop87.LnVsop(3.7E-10, 3.6318390879, 801.8209311238), new Vsop87.LnVsop(3.4E-10, 2.16381407025, 16496.3613962024), new Vsop87.LnVsop(3.4E-10, 1.82177984232, 382.8965322232), new Vsop87.LnVsop(2.5E-10, 3.32908650295, 18307.8072320436), new Vsop87.LnVsop(2.6E-10, 3.64313769818, 29088.811415985), new Vsop87.LnVsop(2.9E-10, 3.8296717881, 10186.9872264112), new Vsop87.LnVsop(2.2E-10, 3.17741520378, 28521.0927782546), new Vsop87.LnVsop(2.5E-10, 5.7151073161, 21202.093703746), new Vsop87.LnVsop(2.1E-10, 5.30608699641, 19896.8801273274), new Vsop87.LnVsop(1.9E-10, 4.65302013202, 19651.048481098), new Vsop87.LnVsop(2.2E-10, 2.42894070342, 529.6909650946), new Vsop87.LnVsop(2.1E-10, 3.82207126131, 21228.3920235458), new Vsop87.LnVsop(1.6E-10, 2.96175040524, 19367.1891622328), new Vsop87.LnVsop(1.6E-10, 3.36250300274, 28286.9904848612), new Vsop87.LnVsop(1.5E-10, 5.05571633205, 33019.0211122046), new Vsop87.LnVsop(1.4E-10, 2.83786355803, 19786.67380610799), new Vsop87.LnVsop(1.4E-10, 1.79922718553, 9830.3890139878), new Vsop87.LnVsop(1.4E-10, 3.49994470578, 10988.808157535), new Vsop87.LnVsop(1.3E-10, 3.06303088617, 10742.9765113056), new Vsop87.LnVsop(1.3E-10, 5.43981998532, 25158.6017197654), new Vsop87.LnVsop(1.5E-10, 4.83166312889, 18875.525869774), new Vsop87.LnVsop(1.2E-10, 2.54141086214, 7064.1213856228), new Vsop87.LnVsop(1.0E-10, 1.87933121728, 24356.7807886416), new Vsop87.LnVsop(1.1E-10, 4.26593805644, 15720.8387848784), new Vsop87.LnVsop(1.0E-10, 2.179013099, 3723.508958923), new Vsop87.LnVsop(1.0E-10, 2.50084772448, 9103.9069941176), new Vsop87.LnVsop(7.0E-11, 3.48063149205, 1059.3819301892), new Vsop87.LnVsop(7.0E-11, 2.38734958588, 20618.0193585336)};
        private static final Vsop87.LnVsop[] venus_radius_r3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(4.9582E-7, 3.22264415899, 10213.285546211), new Vsop87.LnVsop(8.31E-9, 3.21255590531, 20426.571092422), new Vsop87.LnVsop(1.12E-9, 3.14159265359, 0.0), new Vsop87.LnVsop(1.3E-10, 3.77454760284, 30639.856638633), new Vsop87.LnVsop(8.0E-11, 4.29674209391, 10239.5838660108), new Vsop87.LnVsop(6.0E-11, 0.39133521368, 10186.9872264112), new Vsop87.LnVsop(4.0E-11, 4.77456526708, 9437.762934887), new Vsop87.LnVsop(3.0E-11, 0.14604782945, 10988.808157535)};
        private static final Vsop87.LnVsop[] venus_radius_r4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.73E-9, 0.92253525592, 10213.285546211), new Vsop87.LnVsop(3.9E-10, 0.95696787303, 20426.571092422), new Vsop87.LnVsop(6.0E-11, 3.14159265359, 0.0)};
        private static final Vsop87.LnVsop[] venus_radius_r5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(4.5E-10, 0.30037014808, 10213.285546211), new Vsop87.LnVsop(2.0E-11, 5.33215705373, 20426.571092422)};

        Radius() {
        }
    }

    static class Latitude {
        private static final Vsop87.LnVsop[] venus_latitude_b0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.05923638472, 0.26702775812, 10213.285546211), new Vsop87.LnVsop(4.0107978E-4, 1.14737178112, 20426.571092422), new Vsop87.LnVsop(3.2814918E-4, 3.14159265359, 0.0), new Vsop87.LnVsop(1.011392E-5, 1.0894611973, 30639.856638633), new Vsop87.LnVsop(1.49458E-6, 6.25390268112, 18073.7049386502), new Vsop87.LnVsop(1.37788E-6, 0.86020095586, 1577.3435424478), new Vsop87.LnVsop(1.29973E-6, 3.67152480061, 9437.762934887), new Vsop87.LnVsop(1.19507E-6, 3.70468787104, 2352.8661537718), new Vsop87.LnVsop(1.07971E-6, 4.53903678347, 22003.9146348698), new Vsop87.LnVsop(9.2029E-7, 1.53954519783, 9153.9036160218), new Vsop87.LnVsop(5.2982E-7, 2.28138198002, 5507.5532386674), new Vsop87.LnVsop(4.5617E-7, 0.72319646289, 10239.5838660108), new Vsop87.LnVsop(3.8855E-7, 2.93437865147, 10186.9872264112), new Vsop87.LnVsop(4.3491E-7, 6.14015779106, 11790.6290886588), new Vsop87.LnVsop(4.17E-7, 5.99126840013, 19896.8801273274), new Vsop87.LnVsop(3.9644E-7, 3.86842103668, 8635.9420037632), new Vsop87.LnVsop(3.9175E-7, 3.94960158566, 529.6909650946), new Vsop87.LnVsop(3.332E-7, 4.83194901518, 14143.4952424306), new Vsop87.LnVsop(2.3711E-7, 2.90647469167, 10988.808157535), new Vsop87.LnVsop(2.3501E-7, 2.00771051056, 13367.9726311066), new Vsop87.LnVsop(2.1809E-7, 2.69701690731, 19651.048481098), new Vsop87.LnVsop(2.0653E-7, 0.98666980431, 775.522611324), new Vsop87.LnVsop(1.6976E-7, 4.13711781587, 10021.8372800994), new Vsop87.LnVsop(1.7835E-7, 5.96267283261, 25934.1243310894), new Vsop87.LnVsop(1.4949E-7, 5.61073907363, 10404.7338123226), new Vsop87.LnVsop(1.8579E-7, 1.80529274878, 40853.142184844), new Vsop87.LnVsop(1.5408E-7, 3.29564350192, 11015.1064773348), new Vsop87.LnVsop(1.2936E-7, 5.42651380854, 29580.4747084438), new Vsop87.LnVsop(1.1961E-7, 3.57602108535, 10742.9765113056), new Vsop87.LnVsop(1.1827E-7, 1.19069755007, 8624.2126509272), new Vsop87.LnVsop(1.1466E-7, 5.12780356163, 6283.0758499914), new Vsop87.LnVsop(9.485E-8, 2.75168410372, 191.4482661116), new Vsop87.LnVsop(1.3129E-7, 5.70734244216, 9683.5945811164), new Vsop87.LnVsop(8.583E-8, 0.43182249198, 9786.687355335), new Vsop87.LnVsop(9.762E-8, 0.14614751233, 20618.0193585336), new Vsop87.LnVsop(8.149E-8, 1.30548940012, 15720.8387848784), new Vsop87.LnVsop(6.05E-8, 6.2654166631, 11322.6640983044), new Vsop87.LnVsop(5.955E-8, 4.92234246004, 1059.3819301892), new Vsop87.LnVsop(6.983E-8, 3.44922389028, 17298.1823273262), new Vsop87.LnVsop(6.228E-8, 1.13312066423, 29864.334027309), new Vsop87.LnVsop(6.186E-8, 4.92496803755, 19367.1891622328), new Vsop87.LnVsop(6.155E-8, 2.42413936688, 4705.7323075436), new Vsop87.LnVsop(5.204E-8, 3.42528894645, 9103.9069941176), new Vsop87.LnVsop(6.0E-8, 3.57638441137, 3154.6870848956), new Vsop87.LnVsop(4.795E-8, 3.86669268805, 7860.4193924392), new Vsop87.LnVsop(5.29E-8, 4.99182440452, 7084.8967811152), new Vsop87.LnVsop(4.07E-8, 5.58794939725, 12566.1516999828), new Vsop87.LnVsop(3.942E-8, 5.68758787835, 10206.1719992102), new Vsop87.LnVsop(3.797E-8, 3.89520601076, 10192.5101507186), new Vsop87.LnVsop(3.798E-8, 6.06410995916, 10234.0609417034), new Vsop87.LnVsop(3.579E-8, 0.73789669232, 4551.9534970588), new Vsop87.LnVsop(3.641E-8, 2.61501257209, 15874.6175953632), new Vsop87.LnVsop(3.266E-8, 0.97519046577, 23581.2581773176), new Vsop87.LnVsop(2.813E-8, 0.29952168976, 9411.4646150872), new Vsop87.LnVsop(3.048E-8, 2.51084795752, 33794.5437235286), new Vsop87.LnVsop(2.559E-8, 4.58049120677, 801.8209311238), new Vsop87.LnVsop(2.462E-8, 5.05797190589, 29050.7837433492), new Vsop87.LnVsop(2.593E-8, 5.7311317675, 20213.271996984), new Vsop87.LnVsop(2.625E-8, 4.24272906572, 213.299095438), new Vsop87.LnVsop(2.246E-8, 0.82114581737, 28286.9904848612), new Vsop87.LnVsop(2.229E-8, 2.22457598233, 10426.584641649), new Vsop87.LnVsop(1.742E-8, 1.48397982399, 7058.5984613154), new Vsop87.LnVsop(1.66E-8, 5.42775872173, 32217.2001810808), new Vsop87.LnVsop(1.491E-8, 4.64880136152, 1109.3785520934), new Vsop87.LnVsop(2.01E-8, 0.7570288813, 9999.986450773), new Vsop87.LnVsop(1.563E-8, 3.93962296253, 37724.7534197482), new Vsop87.LnVsop(1.538E-8, 2.17314207854, 21535.9496445154), new Vsop87.LnVsop(1.546E-8, 4.7075912923, 14945.3161735544), new Vsop87.LnVsop(1.2E-8, 1.48266337604, 9830.3890139878), new Vsop87.LnVsop(1.224E-8, 5.55090394425, 5661.3320491522), new Vsop87.LnVsop(1.111E-8, 1.20281402179, 9573.388259897), new Vsop87.LnVsop(1.064E-8, 1.98891375551, 26.2983197998), new Vsop87.LnVsop(1.041E-8, 5.38535116069, 7.1135470008), new Vsop87.LnVsop(1.036E-8, 1.16727012915, 8662.240323563), new Vsop87.LnVsop(1.143E-8, 3.20596958339, 3532.0606928114), new Vsop87.LnVsop(1.201E-8, 0.81922498884, 8094.5216858326), new Vsop87.LnVsop(1.005E-8, 2.38430401606, 27511.4678735372), new Vsop87.LnVsop(1.047E-8, 4.56525030764, 20419.45754542119), new Vsop87.LnVsop(9.68E-9, 6.18496285828, 25158.6017197654), new Vsop87.LnVsop(1.044E-8, 1.980332744, 10596.1820784342), new Vsop87.LnVsop(9.62E-9, 0.48573513747, 23958.6317852334), new Vsop87.LnVsop(8.46E-9, 0.01577122167, 3128.3887650958), new Vsop87.LnVsop(7.92E-9, 5.39683788914, 24356.7807886416), new Vsop87.LnVsop(8.58E-9, 5.34721623594, 41654.9631159678), new Vsop87.LnVsop(7.58E-9, 6.25923864937, 20452.8694122218), new Vsop87.LnVsop(8.01E-9, 4.62406152514, 9929.4262273458), new Vsop87.LnVsop(8.02E-9, 5.3723489252, 10497.1448650762), new Vsop87.LnVsop(7.5E-9, 3.8522129136, 21228.3920235458), new Vsop87.LnVsop(7.01E-9, 1.98087454891, 3930.2096962196), new Vsop87.LnVsop(7.19E-9, 6.11596800207, 10218.8084705184), new Vsop87.LnVsop(6.72E-9, 6.23429601211, 14765.2390432698), new Vsop87.LnVsop(6.39E-9, 5.37595576896, 1589.0728952838), new Vsop87.LnVsop(6.05E-9, 2.4233039112, 10251.3132188468), new Vsop87.LnVsop(7.26E-9, 6.16679714176, 18875.525869774), new Vsop87.LnVsop(6.13E-9, 5.99731180692, 4732.0306273434), new Vsop87.LnVsop(7.2E-9, 3.84286345199, 10207.7626219036), new Vsop87.LnVsop(6.37E-9, 6.17053891151, 10220.3990932118), new Vsop87.LnVsop(5.15E-9, 1.03004255543, 22779.4372461938), new Vsop87.LnVsop(5.74E-9, 0.4382686639, 17085.9586657222), new Vsop87.LnVsop(5.1E-9, 1.41066951048, 9161.0171630226), new Vsop87.LnVsop(5.69E-9, 3.34606383399, 3340.6124266998), new Vsop87.LnVsop(6.08E-9, 1.25236241968, 10175.2578735752), new Vsop87.LnVsop(5.24E-9, 2.39794248664, 26087.9031415742), new Vsop87.LnVsop(5.43E-9, 1.34669062643, 29088.811415985), new Vsop87.LnVsop(5.27E-9, 4.02005650673, 18849.2275499742), new Vsop87.LnVsop(5.68E-9, 1.65449906239, 39264.0692895602), new Vsop87.LnVsop(5.18E-9, 4.96996115441, 30213.258447757), new Vsop87.LnVsop(5.15E-9, 5.78424359731, 12592.4500197826), new Vsop87.LnVsop(5.38E-9, 4.56198503482, 10063.7223490764), new Vsop87.LnVsop(4.84E-9, 4.18570967634, 14919.0178537546), new Vsop87.LnVsop(4.93E-9, 4.79953014808, 9146.790069021), new Vsop87.LnVsop(4.27E-9, 3.76882042266, 11272.6674764002), new Vsop87.LnVsop(4.95E-9, 0.49176119118, 45585.1728121874), new Vsop87.LnVsop(4.95E-9, 3.74294537743, 31441.6775697568), new Vsop87.LnVsop(5.24E-9, 0.97969838972, 30110.1656735384), new Vsop87.LnVsop(4.83E-9, 1.87898083461, 51066.427731055), new Vsop87.LnVsop(5.05E-9, 3.70047474052, 20400.2727726222), new Vsop87.LnVsop(3.51E-9, 4.3402657449, 10137.0194749354), new Vsop87.LnVsop(3.56E-9, 5.56743301907, 18837.49819713819), new Vsop87.LnVsop(3.28E-9, 3.78427378911, 6681.2248533996), new Vsop87.LnVsop(3.49E-9, 4.20513745358, 20956.2620575166), new Vsop87.LnVsop(3.33E-9, 4.44934899983, 28521.0927782546), new Vsop87.LnVsop(2.96E-9, 2.83205515647, 17277.4069318338), new Vsop87.LnVsop(3.11E-9, 2.57313811169, 20809.4676246452), new Vsop87.LnVsop(2.94E-9, 0.75089224483, 3149.1641605882), new Vsop87.LnVsop(3.77E-9, 3.98143310344, 21202.093703746), new Vsop87.LnVsop(2.72E-9, 5.56146064111, 16496.3613962024), new Vsop87.LnVsop(3.14E-9, 0.02584607106, 13745.3462390224), new Vsop87.LnVsop(2.63E-9, 0.55359290511, 36147.4098773004), new Vsop87.LnVsop(2.86E-9, 5.16408902152, 426.598190876), new Vsop87.LnVsop(2.79E-9, 4.29871616015, 19999.97290154599), new Vsop87.LnVsop(2.8E-9, 1.9292379031, 49515.382508407), new Vsop87.LnVsop(2.65E-9, 4.8116171209, 20235.1228263104), new Vsop87.LnVsop(2.73E-9, 5.1273967798, 35371.8872659764), new Vsop87.LnVsop(3.07E-9, 5.28914601501, 382.8965322232), new Vsop87.LnVsop(2.23E-9, 2.50591295336, 26709.6469424134), new Vsop87.LnVsop(2.35E-9, 5.96522395118, 10198.033075026), new Vsop87.LnVsop(2.34E-9, 3.52866583267, 10228.538017396), new Vsop87.LnVsop(2.24E-9, 6.24561979791, 7064.1213856228), new Vsop87.LnVsop(2.51E-9, 2.84752569358, 33019.0211122046), new Vsop87.LnVsop(1.96E-9, 1.50610823821, 31749.2351907264), new Vsop87.LnVsop(1.92E-9, 1.6932201935, 13341.6743113068), new Vsop87.LnVsop(1.8E-9, 6.19353102835, 39793.7602546548), new Vsop87.LnVsop(1.99E-9, 1.16466425386, 22805.7355659936), new Vsop87.LnVsop(1.8E-9, 3.72630445822, 1551.045222648), new Vsop87.LnVsop(1.72E-9, 3.35254224852, 53445.5922046266), new Vsop87.LnVsop(1.95E-9, 1.51901264133, 43232.3066584156), new Vsop87.LnVsop(1.74E-9, 2.84049662693, 9967.4538999816), new Vsop87.LnVsop(1.63E-9, 4.29008955007, 36949.2308084242), new Vsop87.LnVsop(1.69E-9, 0.37000676558, 10459.1171924404), new Vsop87.LnVsop(1.37E-9, 5.61149803116, 10529.6774158676), new Vsop87.LnVsop(1.39E-9, 0.87990954673, 16522.6597160022), new Vsop87.LnVsop(1.39E-9, 4.12576475412, 36301.18868778519), new Vsop87.LnVsop(1.27E-9, 5.14447758617, 5481.2549188676), new Vsop87.LnVsop(1.31E-9, 3.11317801589, 9896.8936765544), new Vsop87.LnVsop(1.31E-9, 0.89697384734, 3442.5749449654), new Vsop87.LnVsop(1.21E-9, 1.32914080245, 38734.3783244656), new Vsop87.LnVsop(1.22E-9, 1.59017183044, 10110.1927719924), new Vsop87.LnVsop(1.23E-9, 2.33714216061, 10316.3783204296), new Vsop87.LnVsop(1.33E-9, 2.90682399304, 9793.8009023358), new Vsop87.LnVsop(1.11E-9, 2.51956905782, 13936.794505134), new Vsop87.LnVsop(1.2E-9, 0.36015902371, 536.8045120954), new Vsop87.LnVsop(1.15E-9, 2.53305863643, 26735.9452622132), new Vsop87.LnVsop(1.08E-9, 2.65839634325, 10232.95530711079), new Vsop87.LnVsop(1.08E-9, 0.55230439694, 10193.61578531121), new Vsop87.LnVsop(1.38E-9, 1.06919239242, 65236.2212932854), new Vsop87.LnVsop(1.01E-9, 3.17003240566, 19317.1925403286), new Vsop87.LnVsop(1.27E-9, 5.63110477712, 10288.0671447783), new Vsop87.LnVsop(1.27E-9, 3.86278127025, 10138.5039476437), new Vsop87.LnVsop(1.37E-9, 2.93350659462, 47162.5163546352), new Vsop87.LnVsop(9.5E-10, 5.03917884339, 52175.8062831484), new Vsop87.LnVsop(9.4E-10, 0.71305001399, 38500.2760310722), new Vsop87.LnVsop(9.3E-10, 5.46196838829, 11764.330768859), new Vsop87.LnVsop(9.6E-10, 1.52914774412, 9690.7081281172), new Vsop87.LnVsop(1.01E-9, 0.83318284424, 6489.776587288), new Vsop87.LnVsop(1.15E-9, 3.7644361224, 522.5774180938), new Vsop87.LnVsop(8.9E-10, 2.53312656681, 10735.8629643048), new Vsop87.LnVsop(8.2E-10, 0.85729618993, 2379.1644735716), new Vsop87.LnVsop(1.03E-9, 5.22683237626, 103.0927742186), new Vsop87.LnVsop(9.0E-10, 2.12423586627, 28313.288804661), new Vsop87.LnVsop(9.0E-10, 0.39668501734, 9580.5018068978), new Vsop87.LnVsop(7.4E-10, 6.0279842986, 3723.508958923), new Vsop87.LnVsop(8.1E-10, 5.25045057985, 10419.4710946482), new Vsop87.LnVsop(8.0E-10, 4.23724598221, 10007.0999977738), new Vsop87.LnVsop(9.1E-10, 2.48874147948, 10846.0692855242), new Vsop87.LnVsop(8.5E-10, 3.82491067322, 51868.2486621788), new Vsop87.LnVsop(8.1E-10, 2.26186773193, 3903.9113764198), new Vsop87.LnVsop(9.7E-10, 0.77436917916, 18307.8072320436), new Vsop87.LnVsop(9.4E-10, 0.17064745052, 6872.6731195112), new Vsop87.LnVsop(8.0E-10, 5.62388508292, 29999.959352319), new Vsop87.LnVsop(6.8E-10, 2.71544542018, 16983.9961474566), new Vsop87.LnVsop(7.6E-10, 0.3618976147, 39302.096962196), new Vsop87.LnVsop(6.6E-10, 0.76731351843, 20.7753954924), new Vsop87.LnVsop(7.5E-10, 2.27327165974, 8521.1198767086), new Vsop87.LnVsop(5.8E-10, 2.14482855875, 8631.326197928), new Vsop87.LnVsop(6.4E-10, 5.83567991327, 2118.7638603784), new Vsop87.LnVsop(5.8E-10, 2.98359709521, 19889.76658032659), new Vsop87.LnVsop(5.4E-10, 1.7825284389, 40077.61957352), new Vsop87.LnVsop(5.5E-10, 4.70485939801, 639.897286314), new Vsop87.LnVsop(6.0E-10, 5.89548057045, 41962.5207369374), new Vsop87.LnVsop(6.6E-10, 2.24746237992, 74.7815985673), new Vsop87.LnVsop(6.1E-10, 3.40726181591, 27490.6924780448), new Vsop87.LnVsop(5.1E-10, 3.07546032535, 24150.080051345), new Vsop87.LnVsop(5.7E-10, 2.30081371235, 20529.66386664059), new Vsop87.LnVsop(5.1E-10, 2.37255859198, 29573.361161443), new Vsop87.LnVsop(5.2E-10, 4.76676085839, 57375.8019008462), new Vsop87.LnVsop(5.4E-10, 5.89684197257, 19903.99367432819), new Vsop87.LnVsop(4.7E-10, 1.6177674435, 30831.3049047446), new Vsop87.LnVsop(4.0E-10, 5.32238959879, 42430.4857272918), new Vsop87.LnVsop(5.1E-10, 5.29366964725, 29587.5882554446)};
        private static final Vsop87.LnVsop[] venus_latitude_b1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.00287821243, 1.88964962838, 10213.285546211), new Vsop87.LnVsop(3.499578E-5, 3.71117560516, 20426.571092422), new Vsop87.LnVsop(1.257844E-5, 0.0, 0.0), new Vsop87.LnVsop(9.6152E-7, 2.74240664188, 30639.856638633), new Vsop87.LnVsop(1.3051E-7, 2.27549606211, 9437.762934887), new Vsop87.LnVsop(8.052E-8, 5.55049163175, 1577.3435424478), new Vsop87.LnVsop(6.792E-8, 1.60704519868, 18073.7049386502), new Vsop87.LnVsop(7.521E-8, 0.28931916342, 9153.9036160218), new Vsop87.LnVsop(5.612E-8, 1.59167143282, 11790.6290886588), new Vsop87.LnVsop(6.46E-8, 5.23429470615, 10186.9872264112), new Vsop87.LnVsop(5.405E-8, 6.1538451512, 22003.9146348698), new Vsop87.LnVsop(4.194E-8, 5.40627767662, 2352.8661537718), new Vsop87.LnVsop(5.097E-8, 4.1740417742, 10239.5838660108), new Vsop87.LnVsop(4.085E-8, 0.7361804793, 5507.5532386674), new Vsop87.LnVsop(3.349E-8, 1.34464128958, 10404.7338123226), new Vsop87.LnVsop(2.941E-8, 4.40460505149, 19651.048481098), new Vsop87.LnVsop(2.67E-8, 3.92292198547, 40853.142184844), new Vsop87.LnVsop(2.746E-8, 5.04771993757, 10988.808157535), new Vsop87.LnVsop(2.216E-8, 1.74777661827, 8635.9420037632), new Vsop87.LnVsop(1.934E-8, 1.3573057604, 19896.8801273274), new Vsop87.LnVsop(1.96E-8, 0.38471810829, 13367.9726311066), new Vsop87.LnVsop(1.859E-8, 5.60931743743, 529.6909650946), new Vsop87.LnVsop(1.586E-8, 2.31959766692, 10021.8372800994), new Vsop87.LnVsop(1.733E-8, 3.34619758004, 6283.0758499914), new Vsop87.LnVsop(1.227E-8, 1.71667580691, 20618.0193585336), new Vsop87.LnVsop(1.223E-8, 6.18665596267, 7860.4193924392), new Vsop87.LnVsop(9.8E-9, 2.99089645869, 15720.8387848784), new Vsop87.LnVsop(9.61E-9, 5.06770207004, 775.522611324), new Vsop87.LnVsop(9.76E-9, 1.28004342015, 25934.1243310894), new Vsop87.LnVsop(7.85E-9, 1.77460186481, 11322.6640983044), new Vsop87.LnVsop(7.27E-9, 0.60317628984, 8624.2126509272), new Vsop87.LnVsop(7.56E-9, 0.68622306427, 19367.1891622328), new Vsop87.LnVsop(6.25E-9, 0.74326657001, 29580.4747084438), new Vsop87.LnVsop(5.25E-9, 5.08155157418, 9786.687355335), new Vsop87.LnVsop(5.53E-9, 1.74144182497, 17298.1823273262), new Vsop87.LnVsop(5.03E-9, 2.68460156951, 23581.2581773176), new Vsop87.LnVsop(4.67E-9, 0.17554338129, 11015.1064773348), new Vsop87.LnVsop(4.0E-9, 0.33304670031, 4705.7323075436), new Vsop87.LnVsop(4.38E-9, 2.30926644329, 10742.9765113056), new Vsop87.LnVsop(3.56E-9, 1.05880387658, 14143.4952424306), new Vsop87.LnVsop(3.59E-9, 4.84089408623, 3930.2096962196), new Vsop87.LnVsop(4.31E-9, 3.73519308368, 10596.1820784342), new Vsop87.LnVsop(3.12E-9, 6.24028343022, 9830.3890139878), new Vsop87.LnVsop(3.21E-9, 3.83963668925, 21228.3920235458), new Vsop87.LnVsop(3.29E-9, 2.71641787634, 29864.334027309), new Vsop87.LnVsop(2.67E-9, 1.90575325749, 9103.9069941176), new Vsop87.LnVsop(2.56E-9, 4.22499119257, 191.4482661116), new Vsop87.LnVsop(2.59E-9, 1.81366693404, 1059.3819301892), new Vsop87.LnVsop(3.48E-9, 2.27789745461, 9999.986450773), new Vsop87.LnVsop(2.58E-9, 2.61400704653, 9411.4646150872), new Vsop87.LnVsop(2.42E-9, 3.18580218709, 12566.1516999828), new Vsop87.LnVsop(2.94E-9, 4.38485988087, 15874.6175953632), new Vsop87.LnVsop(2.74E-9, 4.80172249298, 10206.1719992102), new Vsop87.LnVsop(2.43E-9, 6.15371511696, 20419.45754542119), new Vsop87.LnVsop(2.16E-9, 2.14070499134, 801.8209311238), new Vsop87.LnVsop(1.95E-9, 3.43788708589, 28286.9904848612), new Vsop87.LnVsop(2.03E-9, 4.40417469081, 10220.3990932118), new Vsop87.LnVsop(2.04E-9, 1.39050905939, 10234.0609417034), new Vsop87.LnVsop(1.77E-9, 6.13411796219, 10426.584641649), new Vsop87.LnVsop(1.74E-9, 6.13034607143, 9161.0171630226), new Vsop87.LnVsop(1.86E-9, 3.77010906124, 7058.5984613154), new Vsop87.LnVsop(1.67E-9, 5.56979067201, 10192.5101507186), new Vsop87.LnVsop(1.97E-9, 0.07905532678, 29050.7837433492), new Vsop87.LnVsop(1.86E-9, 4.07019341948, 33794.5437235286), new Vsop87.LnVsop(1.55E-9, 3.6648055702, 7.1135470008), new Vsop87.LnVsop(1.38E-9, 5.96011224678, 3154.6870848956), new Vsop87.LnVsop(1.58E-9, 5.50203206635, 37724.7534197482), new Vsop87.LnVsop(1.47E-9, 3.62347099998, 21535.9496445154), new Vsop87.LnVsop(1.41E-9, 1.64907514042, 32217.2001810808), new Vsop87.LnVsop(1.68E-9, 6.17942898657, 18837.49819713819), new Vsop87.LnVsop(1.49E-9, 4.71613322834, 25158.6017197654), new Vsop87.LnVsop(1.24E-9, 4.14558329896, 27511.4678735372), new Vsop87.LnVsop(1.17E-9, 1.26060116043, 7084.8967811152), new Vsop87.LnVsop(1.12E-9, 2.64211360535, 22779.4372461938), new Vsop87.LnVsop(1.11E-9, 1.56882986044, 9683.5945811164), new Vsop87.LnVsop(1.25E-9, 5.85773130047, 213.299095438), new Vsop87.LnVsop(1.06E-9, 1.6020610226, 10207.7626219036), new Vsop87.LnVsop(1.06E-9, 1.60857575234, 10218.8084705184), new Vsop87.LnVsop(1.07E-9, 0.06029270673, 20400.2727726222), new Vsop87.LnVsop(1.05E-9, 5.1758241226, 8662.240323563), new Vsop87.LnVsop(1.15E-9, 0.14229628995, 9146.790069021), new Vsop87.LnVsop(1.18E-9, 0.93060644045, 20213.271996984), new Vsop87.LnVsop(1.34E-9, 5.76506264779, 26.2983197998), new Vsop87.LnVsop(1.0E-9, 0.63855627551, 41654.9631159678), new Vsop87.LnVsop(9.3E-10, 2.39421056035, 3128.3887650958), new Vsop87.LnVsop(8.3E-10, 0.24054840895, 14919.0178537546), new Vsop87.LnVsop(8.6E-10, 1.99704954707, 10228.538017396), new Vsop87.LnVsop(8.6E-10, 1.21365119312, 10198.033075026), new Vsop87.LnVsop(7.6E-10, 6.15164147653, 21202.093703746), new Vsop87.LnVsop(7.6E-10, 2.50538996449, 4551.9534970588), new Vsop87.LnVsop(8.1E-10, 3.54317093055, 51066.427731055), new Vsop87.LnVsop(7.0E-10, 3.62977580498, 20452.8694122218), new Vsop87.LnVsop(6.9E-10, 3.3380115873, 11272.6674764002), new Vsop87.LnVsop(6.6E-10, 2.40044362019, 16496.3613962024), new Vsop87.LnVsop(7.4E-10, 0.81937069238, 382.8965322232), new Vsop87.LnVsop(8.4E-10, 1.84615505638, 45585.1728121874), new Vsop87.LnVsop(5.8E-10, 5.54500123157, 5661.3320491522), new Vsop87.LnVsop(6.2E-10, 6.22847666967, 29088.811415985), new Vsop87.LnVsop(4.8E-10, 5.23337244147, 3149.1641605882), new Vsop87.LnVsop(4.5E-10, 4.23847970134, 20809.4676246452), new Vsop87.LnVsop(4.3E-10, 3.13312030807, 30110.1656735384), new Vsop87.LnVsop(4.2E-10, 2.05265738782, 24356.7807886416), new Vsop87.LnVsop(4.8E-10, 1.26595147651, 33019.0211122046), new Vsop87.LnVsop(5.6E-10, 3.26535945634, 49515.382508407), new Vsop87.LnVsop(4.9E-10, 4.20217286778, 13341.6743113068), new Vsop87.LnVsop(4.2E-10, 2.07085732347, 426.598190876), new Vsop87.LnVsop(4.4E-10, 1.20392434392, 12592.4500197826), new Vsop87.LnVsop(3.6E-10, 5.57938191798, 31441.6775697568), new Vsop87.LnVsop(3.8E-10, 4.98083686092, 536.8045120954), new Vsop87.LnVsop(4.3E-10, 1.90863602359, 3532.0606928114), new Vsop87.LnVsop(3.5E-10, 3.83053326183, 18849.2275499742), new Vsop87.LnVsop(3.2E-10, 5.81052626816, 28521.0927782546), new Vsop87.LnVsop(2.8E-10, 3.80386218448, 4732.0306273434), new Vsop87.LnVsop(3.1E-10, 5.41631373906, 522.5774180938), new Vsop87.LnVsop(2.6E-10, 2.11998839024, 23958.6317852334), new Vsop87.LnVsop(2.3E-10, 4.45861699215, 17277.4069318338), new Vsop87.LnVsop(2.2E-10, 1.46296031303, 8094.5216858326), new Vsop87.LnVsop(2.4E-10, 6.20898418337, 26087.9031415742), new Vsop87.LnVsop(2.0E-10, 4.66182643911, 19889.76658032659), new Vsop87.LnVsop(2.0E-10, 0.98405518609, 19999.97290154599), new Vsop87.LnVsop(2.3E-10, 3.22003976882, 39264.0692895602)};
        private static final Vsop87.LnVsop[] venus_latitude_b2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.2657745E-4, 3.34796457029, 10213.285546211), new Vsop87.LnVsop(1.51225E-6, 0.0, 0.0), new Vsop87.LnVsop(3.7476E-7, 5.34638962141, 20426.571092422), new Vsop87.LnVsop(1.0627E-7, 3.81894300538, 30639.856638633), new Vsop87.LnVsop(9.42E-9, 0.01311905561, 10186.9872264112), new Vsop87.LnVsop(7.47E-9, 4.13620174126, 10239.5838660108), new Vsop87.LnVsop(4.34E-9, 3.26791015348, 11790.6290886588), new Vsop87.LnVsop(4.39E-9, 6.04066783494, 10988.808157535), new Vsop87.LnVsop(3.31E-9, 6.2063227012, 9437.762934887), new Vsop87.LnVsop(3.32E-9, 2.82983937642, 10404.7338123226), new Vsop87.LnVsop(3.4E-9, 5.14190117554, 9153.9036160218), new Vsop87.LnVsop(2.44E-9, 6.07029755311, 19651.048481098), new Vsop87.LnVsop(2.74E-9, 0.56238407651, 2352.8661537718), new Vsop87.LnVsop(2.73E-9, 3.0955128748, 18073.7049386502), new Vsop87.LnVsop(2.68E-9, 4.02642385642, 1577.3435424478), new Vsop87.LnVsop(2.17E-9, 5.37498456751, 40853.142184844), new Vsop87.LnVsop(2.13E-9, 1.22633958472, 22003.9146348698), new Vsop87.LnVsop(1.41E-9, 5.42727181668, 5507.5532386674), new Vsop87.LnVsop(1.3E-9, 5.26806549972, 13367.9726311066), new Vsop87.LnVsop(1.01E-9, 4.6408966178, 15720.8387848784), new Vsop87.LnVsop(9.7E-10, 0.7951278554, 10021.8372800994), new Vsop87.LnVsop(9.5E-10, 0.2233014981, 8635.9420037632), new Vsop87.LnVsop(9.0E-10, 2.70556129424, 19896.8801273274), new Vsop87.LnVsop(9.0E-10, 0.51306700906, 529.6909650946), new Vsop87.LnVsop(8.4E-10, 2.50344831127, 9683.5945811164), new Vsop87.LnVsop(7.0E-10, 3.27104614873, 20618.0193585336), new Vsop87.LnVsop(5.8E-10, 3.30656672462, 11322.6640983044), new Vsop87.LnVsop(7.5E-10, 5.25593390437, 10596.1820784342), new Vsop87.LnVsop(4.5E-10, 4.74613910444, 7058.5984613154), new Vsop87.LnVsop(3.9E-10, 4.73196017252, 9830.3890139878), new Vsop87.LnVsop(4.6E-10, 3.81232018036, 775.522611324), new Vsop87.LnVsop(3.4E-10, 3.64209909537, 14143.4952424306), new Vsop87.LnVsop(3.1E-10, 4.03554572158, 6283.0758499914), new Vsop87.LnVsop(3.6E-10, 2.08483265333, 801.8209311238), new Vsop87.LnVsop(3.4E-10, 2.8571482136, 9411.4646150872), new Vsop87.LnVsop(2.3E-10, 0.53259218563, 10206.1719992102), new Vsop87.LnVsop(2.3E-10, 5.81970120815, 10220.3990932118), new Vsop87.LnVsop(2.9E-10, 0.3423821273, 11015.1064773348), new Vsop87.LnVsop(2.1E-10, 4.61555386478, 9999.986450773), new Vsop87.LnVsop(2.0E-10, 4.8806405423, 10426.584641649), new Vsop87.LnVsop(2.6E-10, 2.20763733076, 18849.2275499742), new Vsop87.LnVsop(2.2E-10, 3.98619109775, 10742.9765113056), new Vsop87.LnVsop(1.9E-10, 4.86026864659, 4705.7323075436), new Vsop87.LnVsop(1.8E-10, 4.37664030659, 23581.2581773176), new Vsop87.LnVsop(1.8E-10, 2.5725481233, 19367.1891622328), new Vsop87.LnVsop(1.8E-10, 5.52181260638, 21228.3920235458), new Vsop87.LnVsop(2.1E-10, 2.75902377111, 25934.1243310894), new Vsop87.LnVsop(1.9E-10, 2.22080338031, 29580.4747084438), new Vsop87.LnVsop(1.7E-10, 2.48643394548, 3128.3887650958), new Vsop87.LnVsop(1.4E-10, 6.2007952934, 191.4482661116), new Vsop87.LnVsop(1.5E-10, 5.74322714868, 26.2983197998)};
        private static final Vsop87.LnVsop[] venus_latitude_b3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.76505E-6, 4.87650249694, 10213.285546211), new Vsop87.LnVsop(1.2587E-7, 3.14159265359, 0.0), new Vsop87.LnVsop(4.809E-8, 0.43423918018, 20426.571092422), new Vsop87.LnVsop(8.35E-9, 5.57179521329, 30639.856638633), new Vsop87.LnVsop(4.6E-10, 1.54914240166, 10186.9872264112), new Vsop87.LnVsop(3.4E-10, 5.78743368814, 10239.5838660108), new Vsop87.LnVsop(1.9E-10, 0.7622731258, 40853.142184844), new Vsop87.LnVsop(1.3E-10, 4.63920619996, 11790.6290886588), new Vsop87.LnVsop(1.4E-10, 5.47124304598, 9437.762934887), new Vsop87.LnVsop(1.4E-10, 0.87652853636, 10988.808157535), new Vsop87.LnVsop(1.0E-10, 1.84595947891, 2352.8661537718), new Vsop87.LnVsop(5.0E-11, 1.36825703657, 19651.048481098)};
        private static final Vsop87.LnVsop[] venus_latitude_b4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(8.558E-8, 0.17181972054, 10213.285546211), new Vsop87.LnVsop(1.14E-9, 2.5036613009, 20426.571092422), new Vsop87.LnVsop(1.15E-9, 3.14159265359, 0.0), new Vsop87.LnVsop(4.1E-10, 0.74061432691, 30639.856638633)};
        private static final Vsop87.LnVsop[] venus_latitude_b5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.49E-9, 1.67437168506, 10213.285546211), new Vsop87.LnVsop(2.3E-10, 0.0, 0.0), new Vsop87.LnVsop(8.0E-11, 3.73924477319, 20426.571092422), new Vsop87.LnVsop(2.0E-11, 2.28783748701, 30639.856638633)};

        Latitude() {
        }
    }

    static class Longitude {
        private static final Vsop87.LnVsop[] venus_longitude_l0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.17614666774, 0.0, 0.0), new Vsop87.LnVsop(0.01353968419, 5.59313319619, 10213.285546211), new Vsop87.LnVsop(8.9891645E-4, 5.30650047764, 20426.571092422), new Vsop87.LnVsop(5.477194E-5, 4.41630661466, 7860.4193924392), new Vsop87.LnVsop(3.455741E-5, 2.6996444782, 11790.6290886588), new Vsop87.LnVsop(2.372061E-5, 2.99377542079, 3930.2096962196), new Vsop87.LnVsop(1.317168E-5, 5.18668228402, 26.2983197998), new Vsop87.LnVsop(1.664146E-5, 4.25018630147, 1577.3435424478), new Vsop87.LnVsop(1.438387E-5, 4.15745084182, 9683.5945811164), new Vsop87.LnVsop(1.200521E-5, 6.15357116043, 30639.856638633), new Vsop87.LnVsop(7.6138E-6, 1.95014701047, 529.6909650946), new Vsop87.LnVsop(7.07676E-6, 1.06466702668, 775.522611324), new Vsop87.LnVsop(5.84836E-6, 3.9983988823, 191.4482661116), new Vsop87.LnVsop(7.69314E-6, 0.81629615196, 9437.762934887), new Vsop87.LnVsop(4.99915E-6, 4.1234021282, 15720.8387848784), new Vsop87.LnVsop(3.26221E-6, 4.59056477038, 10404.7338123226), new Vsop87.LnVsop(4.29498E-6, 3.58642858577, 19367.1891622328), new Vsop87.LnVsop(3.26967E-6, 5.67736584311, 5507.5532386674), new Vsop87.LnVsop(2.31937E-6, 3.16251059356, 9153.9036160218), new Vsop87.LnVsop(1.79695E-6, 4.65337908917, 1109.3785520934), new Vsop87.LnVsop(1.28263E-6, 4.22604490814, 20.7753954924), new Vsop87.LnVsop(1.55464E-6, 5.5704389169, 19651.048481098), new Vsop87.LnVsop(1.27907E-6, 0.96209781904, 5661.3320491522), new Vsop87.LnVsop(1.05547E-6, 1.53721203088, 801.8209311238), new Vsop87.LnVsop(8.5722E-7, 0.3558924772, 3154.6870848956), new Vsop87.LnVsop(9.9121E-7, 0.83288208931, 213.299095438), new Vsop87.LnVsop(9.8804E-7, 5.39389623302, 13367.9726311066), new Vsop87.LnVsop(8.2094E-7, 3.21597037872, 18837.49819713819), new Vsop87.LnVsop(8.8031E-7, 3.88868864136, 9999.986450773), new Vsop87.LnVsop(7.1577E-7, 0.11145736657, 11015.1064773348), new Vsop87.LnVsop(5.6122E-7, 4.24039842051, 7.1135470008), new Vsop87.LnVsop(7.0239E-7, 0.67458825333, 23581.2581773176), new Vsop87.LnVsop(5.0796E-7, 0.24531639097, 11322.6640983044), new Vsop87.LnVsop(4.6111E-7, 5.31576442737, 18073.7049386502), new Vsop87.LnVsop(4.4576E-7, 6.06281108312, 40853.142184844), new Vsop87.LnVsop(4.2594E-7, 5.32873395426, 2352.8661537718), new Vsop87.LnVsop(4.2635E-7, 1.79955442721, 7084.8967811152), new Vsop87.LnVsop(4.1177E-7, 0.362410122, 382.8965322232), new Vsop87.LnVsop(3.5749E-7, 2.70448479527, 10206.1719992102), new Vsop87.LnVsop(3.3893E-7, 2.02347385644, 6283.0758499914), new Vsop87.LnVsop(2.917E-7, 3.59117396909, 22003.9146348698), new Vsop87.LnVsop(2.8479E-7, 2.22375430133, 1059.3819301892), new Vsop87.LnVsop(2.985E-7, 4.02177029338, 10239.5838660108), new Vsop87.LnVsop(3.3252E-7, 2.10025580495, 27511.4678735372), new Vsop87.LnVsop(3.0172E-7, 4.94191918273, 13745.3462390224), new Vsop87.LnVsop(2.9252E-7, 3.51392387787, 283.8593188652), new Vsop87.LnVsop(2.4424E-7, 2.7017748784, 8624.2126509272), new Vsop87.LnVsop(2.0274E-7, 3.79493777545, 14143.4952424306), new Vsop87.LnVsop(2.4322E-7, 4.27814493315, 5.5229243074), new Vsop87.LnVsop(2.626E-7, 0.54067510171, 17298.1823273262), new Vsop87.LnVsop(2.0492E-7, 0.58547075036, 38.0276726358), new Vsop87.LnVsop(1.8988E-7, 4.13811517967, 4551.9534970588), new Vsop87.LnVsop(2.3739E-7, 4.82870820701, 6872.6731195112), new Vsop87.LnVsop(1.5953E-7, 1.50376176156, 8635.9420037632), new Vsop87.LnVsop(1.9069E-7, 6.12025555817, 29050.7837433492), new Vsop87.LnVsop(1.8269E-7, 3.04740409161, 19999.97290154599), new Vsop87.LnVsop(1.3656E-7, 4.4133626499, 3532.0606928114), new Vsop87.LnVsop(1.7118E-7, 3.51922693724, 31441.6775697568), new Vsop87.LnVsop(1.0955E-7, 2.84562940868, 18307.8072320436), new Vsop87.LnVsop(1.1048E-7, 2.58361219121, 9786.687355335), new Vsop87.LnVsop(9.904E-8, 1.08737985358, 7064.1213856228), new Vsop87.LnVsop(1.0576E-7, 0.85419798194, 10596.1820784342), new Vsop87.LnVsop(9.235E-8, 5.52461085424, 12566.1516999828), new Vsop87.LnVsop(1.1599E-7, 5.81007484555, 19896.8801273274), new Vsop87.LnVsop(1.1807E-7, 1.91250004145, 21228.3920235458), new Vsop87.LnVsop(1.0105E-7, 2.34270729521, 10742.9765113056), new Vsop87.LnVsop(8.154E-8, 1.92331359797, 15.252471185), new Vsop87.LnVsop(8.893E-8, 1.97291419659, 10186.9872264112), new Vsop87.LnVsop(9.352E-8, 4.94508838657, 35371.8872659764), new Vsop87.LnVsop(6.821E-8, 4.3973352805, 8662.240323563), new Vsop87.LnVsop(6.688E-8, 1.55309955053, 14945.3161735544), new Vsop87.LnVsop(6.413E-8, 2.17677578364, 10988.808157535), new Vsop87.LnVsop(5.802E-8, 1.93461898145, 3340.6124266998), new Vsop87.LnVsop(5.95E-8, 2.96578177047, 4732.0306273434), new Vsop87.LnVsop(5.275E-8, 5.01875399411, 28286.9904848612), new Vsop87.LnVsop(7.047E-8, 1.00111452053, 632.7837393132), new Vsop87.LnVsop(5.048E-8, 4.27886655804, 29580.4747084438), new Vsop87.LnVsop(6.305E-8, 0.35506330531, 103.0927742186), new Vsop87.LnVsop(5.959E-8, 5.04792949123, 245.8316462294), new Vsop87.LnVsop(4.651E-8, 0.85216995524, 6770.7106012456), new Vsop87.LnVsop(5.58E-8, 0.48723420248, 522.5774180938), new Vsop87.LnVsop(5.327E-8, 3.03115799765, 10021.8372800994), new Vsop87.LnVsop(5.01E-8, 5.77374296245, 28521.0927782546), new Vsop87.LnVsop(4.608E-8, 1.93302031704, 4705.7323075436), new Vsop87.LnVsop(5.526E-8, 3.36797150122, 25158.6017197654), new Vsop87.LnVsop(3.863E-8, 4.89351765621, 25934.1243310894), new Vsop87.LnVsop(5.303E-8, 0.08161035601, 39302.096962196), new Vsop87.LnVsop(4.254E-8, 5.36046525146, 21535.9496445154), new Vsop87.LnVsop(3.763E-8, 1.05304597315, 19.66976089979), new Vsop87.LnVsop(4.407E-8, 4.02575372996, 74.7815985673), new Vsop87.LnVsop(4.145E-8, 1.14356412295, 9676.4810341156), new Vsop87.LnVsop(4.318E-8, 4.38289970585, 316.3918696566), new Vsop87.LnVsop(3.642E-8, 6.1173353145, 3128.3887650958), new Vsop87.LnVsop(3.238E-8, 5.39551036769, 419.4846438752), new Vsop87.LnVsop(3.909E-8, 4.0526363533, 9690.7081281172), new Vsop87.LnVsop(3.173E-8, 0.74132026653, 16496.3613962024), new Vsop87.LnVsop(3.496E-8, 0.72415151509, 3723.508958923), new Vsop87.LnVsop(3.755E-8, 3.80208523566, 19786.67380610799), new Vsop87.LnVsop(3.016E-8, 1.57249073681, 17277.4069318338), new Vsop87.LnVsop(2.858E-8, 3.31246198673, 32217.2001810808), new Vsop87.LnVsop(3.825E-8, 0.19612307327, 426.598190876), new Vsop87.LnVsop(3.798E-8, 0.45524571743, 10316.3783204296), new Vsop87.LnVsop(2.57E-8, 1.20813798183, 13936.794505134), new Vsop87.LnVsop(2.796E-8, 3.65128969074, 206.1855484372), new Vsop87.LnVsop(2.466E-8, 3.6198842558, 1551.045222648), new Vsop87.LnVsop(3.108E-8, 1.50324979041, 43232.3066584156), new Vsop87.LnVsop(2.976E-8, 4.7941417498, 29088.811415985), new Vsop87.LnVsop(2.196E-8, 3.57357339264, 24356.7807886416), new Vsop87.LnVsop(2.227E-8, 4.96059090976, 536.8045120954), new Vsop87.LnVsop(2.397E-8, 3.45249688427, 19374.3027092336), new Vsop87.LnVsop(2.462E-8, 0.5329534674, 19360.07561523199), new Vsop87.LnVsop(2.205E-8, 2.70398708223, 12592.4500197826), new Vsop87.LnVsop(2.23E-8, 3.01413989795, 18875.525869774), new Vsop87.LnVsop(1.858E-8, 4.06129093893, 2379.1644735716), new Vsop87.LnVsop(1.807E-8, 3.15086244011, 9573.388259897), new Vsop87.LnVsop(2.238E-8, 5.52216925076, 10138.5039476437), new Vsop87.LnVsop(2.195E-8, 2.32046407873, 8094.5216858326), new Vsop87.LnVsop(2.101E-8, 2.90421302974, 9967.4538999816), new Vsop87.LnVsop(1.916E-8, 4.5651391398, 2218.7571041868), new Vsop87.LnVsop(1.467E-8, 2.42640162464, 10234.0609417034), new Vsop87.LnVsop(1.726E-8, 5.59790615295, 20452.8694122218), new Vsop87.LnVsop(1.455E-8, 2.44757225671, 1589.0728952838), new Vsop87.LnVsop(1.991E-8, 4.04623282256, 31749.2351907264), new Vsop87.LnVsop(1.406E-8, 2.71737807375, 16983.9961474566), new Vsop87.LnVsop(1.658E-8, 0.11252373292, 153.7788104848), new Vsop87.LnVsop(1.851E-8, 2.92897863746, 47162.5163546352), new Vsop87.LnVsop(1.492E-8, 1.07515446511, 9103.9069941176), new Vsop87.LnVsop(1.247E-8, 2.4843363614, 17778.11626694899), new Vsop87.LnVsop(1.549E-8, 4.20555105766, 3442.5749449654), new Vsop87.LnVsop(1.243E-8, 3.95452438599, 170.6728706192), new Vsop87.LnVsop(1.694E-8, 6.20691533902, 33019.0211122046), new Vsop87.LnVsop(1.221E-8, 4.77932060567, 30110.1656735384), new Vsop87.LnVsop(1.206E-8, 0.30531254531, 29864.334027309), new Vsop87.LnVsop(1.238E-8, 5.05581030425, 20213.271996984), new Vsop87.LnVsop(1.152E-8, 3.26229919481, 11.729352836), new Vsop87.LnVsop(1.179E-8, 1.69491078238, 20400.2727726222), new Vsop87.LnVsop(1.165E-8, 2.88995128147, 574.3447983348), new Vsop87.LnVsop(1.306E-8, 0.14519568603, 9146.790069021), new Vsop87.LnVsop(1.113E-8, 1.52599723495, 10426.584641649), new Vsop87.LnVsop(1.045E-8, 0.57538516899, 15874.6175953632), new Vsop87.LnVsop(1.105E-8, 2.54593760294, 18849.2275499742), new Vsop87.LnVsop(1.36E-8, 2.41974967161, 38734.3783244656), new Vsop87.LnVsop(9.81E-9, 4.3793075797, 110.2063212194), new Vsop87.LnVsop(1.146E-8, 4.54241415687, 10220.3990932118), new Vsop87.LnVsop(1.091E-8, 0.48630333703, 51066.427731055), new Vsop87.LnVsop(9.81E-9, 1.65915064734, 10103.0792249916), new Vsop87.LnVsop(1.27E-8, 4.69374306132, 9050.8108418032), new Vsop87.LnVsop(1.065E-8, 4.41646204804, 22805.7355659936), new Vsop87.LnVsop(8.54E-9, 2.34437927295, 6681.2248533996), new Vsop87.LnVsop(1.104E-8, 0.49781459714, 1.4844727083), new Vsop87.LnVsop(1.075E-8, 1.09857593161, 377.3736079158), new Vsop87.LnVsop(1.114E-8, 4.35024212108, 51092.7260508548), new Vsop87.LnVsop(8.29E-9, 5.41196376472, 27991.40181316), new Vsop87.LnVsop(9.0E-9, 2.74195213638, 41962.5207369374), new Vsop87.LnVsop(1.01E-8, 2.96092073452, 135.62532501), new Vsop87.LnVsop(7.68E-9, 3.98260860494, 18844.61174413899), new Vsop87.LnVsop(1.018E-8, 1.36889990282, 36949.2308084242), new Vsop87.LnVsop(7.25E-9, 1.67729445754, 21202.093703746), new Vsop87.LnVsop(7.27E-9, 0.89048212541, 467.9649903544), new Vsop87.LnVsop(8.69E-9, 2.93235455158, 10192.5101507186), new Vsop87.LnVsop(6.96E-9, 5.35698039414, 10063.7223490764), new Vsop87.LnVsop(9.2E-9, 4.17128923588, 18734.4054229196), new Vsop87.LnVsop(6.91E-9, 1.50594847085, 27197.2816936676), new Vsop87.LnVsop(8.35E-9, 0.48049677664, 20618.0193585336), new Vsop87.LnVsop(7.11E-9, 0.19750098222, 18830.38465013739), new Vsop87.LnVsop(8.11E-9, 0.16685071959, 12432.0426503978), new Vsop87.LnVsop(7.56E-9, 3.7902244976, 9161.0171630226), new Vsop87.LnVsop(6.22E-9, 5.33660452826, 9411.4646150872), new Vsop87.LnVsop(8.62E-9, 5.72705356405, 10175.1525105732), new Vsop87.LnVsop(8.53E-9, 0.10404194066, 2107.0345075424), new Vsop87.LnVsop(7.42E-9, 3.96365892051, 813.5502839598), new Vsop87.LnVsop(7.05E-9, 0.71229660616, 220.4126424388), new Vsop87.LnVsop(5.84E-9, 1.719006927, 36.0278666774), new Vsop87.LnVsop(6.12E-9, 0.36418385449, 949.1756089698), new Vsop87.LnVsop(5.87E-9, 1.5864894929, 6.62855890001), new Vsop87.LnVsop(5.81E-9, 5.49288908804, 6309.3741697912), new Vsop87.LnVsop(5.81E-9, 4.80362317972, 24150.080051345), new Vsop87.LnVsop(5.16E-9, 6.07328802561, 38.1330356378), new Vsop87.LnVsop(6.27E-9, 5.47281424955, 9580.5018068978), new Vsop87.LnVsop(6.01E-9, 1.40500080384, 1162.4747044078), new Vsop87.LnVsop(6.2E-9, 4.00681042667, 9992.8729037722), new Vsop87.LnVsop(6.11E-9, 3.62010998629, 7255.5696517344), new Vsop87.LnVsop(6.97E-9, 2.22359630727, 348.924420448), new Vsop87.LnVsop(5.69E-9, 0.23482601786, 37410.5672398786), new Vsop87.LnVsop(6.93E-9, 5.77432072851, 55022.9357470744), new Vsop87.LnVsop(4.94E-9, 0.29762226375, 7058.5984613154), new Vsop87.LnVsop(4.87E-9, 5.86917216517, 10137.0194749354), new Vsop87.LnVsop(4.93E-9, 2.04534833854, 735.8765135318), new Vsop87.LnVsop(6.36E-9, 2.79707415908, 40879.4405046438), new Vsop87.LnVsop(5.19E-9, 4.1393165513, 16522.6597160022), new Vsop87.LnVsop(5.35E-9, 4.6056959782, 19573.37471066999), new Vsop87.LnVsop(5.55E-9, 5.88120469821, 26735.9452622132), new Vsop87.LnVsop(4.4E-9, 5.61490952812, 23958.6317852334), new Vsop87.LnVsop(5.41E-9, 0.62494922735, 10007.0999977738), new Vsop87.LnVsop(4.27E-9, 4.02335620501, 14.2270940016), new Vsop87.LnVsop(4.34E-9, 0.29028429049, 9264.1099372412), new Vsop87.LnVsop(4.51E-9, 1.66321968415, 26087.9031415742), new Vsop87.LnVsop(4.22E-9, 3.38413582674, 10787.6303445458), new Vsop87.LnVsop(5.68E-9, 5.14001584538, 27490.6924780448), new Vsop87.LnVsop(4.21E-9, 4.2340742079, 39793.7602546548), new Vsop87.LnVsop(4.58E-9, 5.2878636882, 49.7570254718), new Vsop87.LnVsop(4.18E-9, 5.69090817, 14765.2390432698), new Vsop87.LnVsop(4.75E-9, 0.97544690438, 1052.2683831884), new Vsop87.LnVsop(3.87E-9, 4.41665162999, 21.8508293264), new Vsop87.LnVsop(5.23E-9, 2.90512729055, 20235.1228263104), new Vsop87.LnVsop(5.06E-9, 5.26999240626, 29999.959352319), new Vsop87.LnVsop(5.3E-9, 0.71374608018, 33794.5437235286), new Vsop87.LnVsop(4.34E-9, 2.49892103222, 20956.2620575166), new Vsop87.LnVsop(3.82E-9, 1.9211936548, 3.9321532631), new Vsop87.LnVsop(3.65E-9, 3.81713155389, 20419.45754542119), new Vsop87.LnVsop(4.26E-9, 2.06384189772, 38204.687359371), new Vsop87.LnVsop(4.96E-9, 0.44077356179, 9835.9119382952), new Vsop87.LnVsop(4.1E-9, 4.93346330078, 19264.0963880142), new Vsop87.LnVsop(3.8E-9, 3.79573339943, 8521.1198767086), new Vsop87.LnVsop(3.34E-9, 5.511585578, 10251.3132188468), new Vsop87.LnVsop(4.12E-9, 2.56129670728, 77.673770428), new Vsop87.LnVsop(4.18E-9, 2.37865963521, 32.5325507914), new Vsop87.LnVsop(3.25E-9, 6.03020523465, 18947.7045183576), new Vsop87.LnVsop(4.0E-9, 0.91999360201, 227.476132789), new Vsop87.LnVsop(4.37E-9, 0.91420135162, 58953.145443294), new Vsop87.LnVsop(3.6E-9, 0.82477639126, 22.7752014508), new Vsop87.LnVsop(4.13E-9, 4.22381925464, 44809.6502008634), new Vsop87.LnVsop(3.75E-9, 3.15657291896, 19992.85935454519), new Vsop87.LnVsop(3.71E-9, 6.05370874275, 20007.0864485468), new Vsop87.LnVsop(3.61E-9, 5.44371227904, 19470.28193645139), new Vsop87.LnVsop(3.86E-9, 5.28104804025, 47623.8527860896), new Vsop87.LnVsop(3.89E-9, 0.7321667224, 19050.7972925762), new Vsop87.LnVsop(3.2E-9, 2.84811591194, 10199.0584522094), new Vsop87.LnVsop(3.86E-9, 3.88754165531, 1975.492545856), new Vsop87.LnVsop(2.79E-9, 0.50274101065, 9830.3890139878), new Vsop87.LnVsop(2.76E-9, 4.33978638152, 20809.4676246452), new Vsop87.LnVsop(3.09E-9, 3.79299100668, 18204.71445782499), new Vsop87.LnVsop(3.77E-9, 0.73768790585, 11506.7697697936), new Vsop87.LnVsop(3.22E-9, 0.96113438814, 30666.1549584328), new Vsop87.LnVsop(3.63E-9, 1.3047240669, 9367.2027114598), new Vsop87.LnVsop(3.66E-9, 2.79974205585, 11272.6674764002), new Vsop87.LnVsop(2.71E-9, 4.66141338193, 846.0828347512), new Vsop87.LnVsop(2.59E-9, 0.42024142711, 39264.0692895602), new Vsop87.LnVsop(2.85E-9, 0.40546033634, 30.914125635), new Vsop87.LnVsop(2.47E-9, 4.8067615285, 36147.4098773004), new Vsop87.LnVsop(2.64E-9, 2.71608177583, 11.0457002639), new Vsop87.LnVsop(2.33E-9, 2.76423842887, 187.9251477626), new Vsop87.LnVsop(2.48E-9, 1.60765612335, 10497.1448650762), new Vsop87.LnVsop(2.71E-9, 0.8234891963, 19793.7873531088), new Vsop87.LnVsop(2.25E-9, 3.80080911298, 8631.326197928), new Vsop87.LnVsop(2.63E-9, 1.92319161528, 37724.7534197482), new Vsop87.LnVsop(2.14E-9, 5.01663561403, 639.897286314), new Vsop87.LnVsop(2.89E-9, 0.12342601246, 20277.0078952874), new Vsop87.LnVsop(2.1E-9, 0.12771800254, 29.8214381488), new Vsop87.LnVsop(2.27E-9, 4.18036609801, 17468.8551979454), new Vsop87.LnVsop(2.0E-9, 3.67516531895, 30213.258447757), new Vsop87.LnVsop(2.74E-9, 2.34929343, 62883.3551395136), new Vsop87.LnVsop(2.6E-9, 5.65254501655, 48739.859897083), new Vsop87.LnVsop(2.71E-9, 4.95325404028, 4214.0690150848), new Vsop87.LnVsop(2.19E-9, 2.08775228014, 194.9713844606), new Vsop87.LnVsop(1.91E-9, 2.49267248333, 568.8218740274), new Vsop87.LnVsop(2.31E-9, 0.851165564, 52670.0695933026), new Vsop87.LnVsop(2.5E-9, 1.52909737354, 6037.244203762), new Vsop87.LnVsop(2.31E-9, 5.23674429498, 491.6632924588), new Vsop87.LnVsop(1.82E-9, 4.98046042571, 18418.01355326299), new Vsop87.LnVsop(1.88E-9, 2.82273639603, 1385.8952763362), new Vsop87.LnVsop(2.04E-9, 4.09938646222, 14919.0178537546), new Vsop87.LnVsop(1.76E-9, 3.8240098246, 9360.089164459), new Vsop87.LnVsop(1.98E-9, 2.76491873243, 10217.2176994741), new Vsop87.LnVsop(1.68E-9, 5.19268690225, 1066.49547719), new Vsop87.LnVsop(1.99E-9, 1.95274291865, 7564.830720738), new Vsop87.LnVsop(1.72E-9, 5.29332134227, 11764.330768859), new Vsop87.LnVsop(1.64E-9, 3.25435371801, 3914.9572250346), new Vsop87.LnVsop(2.0E-9, 3.8244321809, 18314.9207790444), new Vsop87.LnVsop(2.03E-9, 5.93253927885, 8617.0991039264), new Vsop87.LnVsop(1.69E-9, 1.78341902846, 31022.7531708562), new Vsop87.LnVsop(1.6E-9, 2.849017024, 10207.7626219036), new Vsop87.LnVsop(1.59E-9, 2.09236390117, 17248.4253018544), new Vsop87.LnVsop(1.79E-9, 0.90840065587, 7880.08915333899), new Vsop87.LnVsop(1.63E-9, 2.79665037814, 41.5507909848), new Vsop87.LnVsop(1.53E-9, 0.07463240782, 28528.2063252554), new Vsop87.LnVsop(1.99E-9, 2.48348609726, 34596.3646546524), new Vsop87.LnVsop(1.49E-9, 2.59213969874, 43071.8992890308), new Vsop87.LnVsop(1.49E-9, 2.17259986337, 9929.4262273458), new Vsop87.LnVsop(1.56E-9, 5.20953676299, 22645.32819660879), new Vsop87.LnVsop(1.48E-9, 2.94331271107, 41654.9631159678), new Vsop87.LnVsop(1.49E-9, 4.498003449, 30831.3049047446), new Vsop87.LnVsop(1.59E-9, 2.11138069179, 19317.1925403286), new Vsop87.LnVsop(1.54E-9, 2.76536164654, 28513.97923125379), new Vsop87.LnVsop(1.4E-9, 4.94595038686, 9256.9963902404), new Vsop87.LnVsop(1.41E-9, 2.57248608474, 13553.8979729108), new Vsop87.LnVsop(1.37E-9, 1.66482327575, 2636.725472637), new Vsop87.LnVsop(1.36E-9, 4.14497573316, 2333.196392872), new Vsop87.LnVsop(1.33E-9, 3.91457156721, 32858.61374281979), new Vsop87.LnVsop(1.4E-9, 2.90644630691, 48947.6638706766), new Vsop87.LnVsop(1.56E-9, 6.01143377008, 29057.89729034999), new Vsop87.LnVsop(1.34E-9, 5.75241675118, 68050.42387851159), new Vsop87.LnVsop(1.54E-9, 3.66827363753, 276.7457718644), new Vsop87.LnVsop(1.76E-9, 3.77298381177, 66813.5648357332), new Vsop87.LnVsop(1.26E-9, 5.00217740223, 27461.7108480654), new Vsop87.LnVsop(1.35E-9, 1.3480701392, 53285.1848352418), new Vsop87.LnVsop(1.5E-9, 0.25029475344, 290.972865866), new Vsop87.LnVsop(1.52E-9, 3.1303564734, 29043.67019634839), new Vsop87.LnVsop(1.69E-9, 5.0434810943, 73.297125859), new Vsop87.LnVsop(1.66E-9, 5.39219948035, 41236.0387170672), new Vsop87.LnVsop(1.15E-9, 2.02657557658, 37674.9963942764), new Vsop87.LnVsop(1.63E-9, 5.59796070948, 7576.560073574), new Vsop87.LnVsop(1.26E-9, 0.77391784606, 49.9966219042), new Vsop87.LnVsop(1.63E-9, 0.44241846674, 20350.3050211464), new Vsop87.LnVsop(1.36E-9, 3.09066368912, 418.9243989006), new Vsop87.LnVsop(1.54E-9, 0.4708619096, 28418.000004036), new Vsop87.LnVsop(1.25E-9, 5.46344374133, 22779.4372461938), new Vsop87.LnVsop(1.36E-9, 4.17495174196, 42430.4857272918), new Vsop87.LnVsop(1.2E-9, 0.88537349448, 29573.361161443), new Vsop87.LnVsop(1.32E-9, 1.48003093721, 17085.9586657222), new Vsop87.LnVsop(1.26E-9, 1.39497760964, 966.9708774356), new Vsop87.LnVsop(1.26E-9, 0.16302255819, 67589.08744705719), new Vsop87.LnVsop(1.11E-9, 2.5022346405, 20405.7956969296), new Vsop87.LnVsop(1.43E-9, 3.84026797958, 14128.2427712456), new Vsop87.LnVsop(1.08E-9, 4.57687521213, 30426.557543195), new Vsop87.LnVsop(1.47E-9, 2.1160986026, 34363.365597556), new Vsop87.LnVsop(1.33E-9, 1.07792835035, 20639.87018786), new Vsop87.LnVsop(1.06E-9, 1.43873202489, 27682.1407441564), new Vsop87.LnVsop(1.49E-9, 0.09286508794, 8144.2787113044), new Vsop87.LnVsop(1.03E-9, 0.0199204147, 18300.69368504279), new Vsop87.LnVsop(1.16E-9, 5.27605692179, 8734.4189721466), new Vsop87.LnVsop(1.21E-9, 3.57602835443, 45.1412196366), new Vsop87.LnVsop(1.25E-9, 0.11630302078, 149.5631971346), new Vsop87.LnVsop(1.08E-9, 5.23732413902, 14169.7935622304), new Vsop87.LnVsop(1.13E-9, 4.57267032764, 20447.3464879144), new Vsop87.LnVsop(9.9E-10, 1.51324741656, 10419.4710946482), new Vsop87.LnVsop(1.05E-9, 1.70350302928, 19580.4882576708), new Vsop87.LnVsop(1.33E-9, 3.02183293676, 76251.32777062019), new Vsop87.LnVsop(1.36E-9, 4.17517197268, 3646.3503773544), new Vsop87.LnVsop(9.7E-10, 6.25332492425, 10198.033075026), new Vsop87.LnVsop(1.23E-9, 0.44045588682, 515.463871093), new Vsop87.LnVsop(1.29E-9, 3.95296865191, 38526.574350872), new Vsop87.LnVsop(1.13E-9, 5.69261397722, 10110.1927719924), new Vsop87.LnVsop(9.8E-10, 6.23797900467, 202.2533951741), new Vsop87.LnVsop(9.9E-10, 3.75627530197, 59728.668054618), new Vsop87.LnVsop(1.01E-9, 4.62832512136, 65236.2212932854), new Vsop87.LnVsop(1.11E-9, 1.25947267592, 10846.0692855242), new Vsop87.LnVsop(1.26E-9, 4.45075374981, 80181.53746683979), new Vsop87.LnVsop(1.1E-9, 5.8745452935, 38500.2760310722), new Vsop87.LnVsop(9.3E-10, 0.03768705119, 90695.75207512038), new Vsop87.LnVsop(1.28E-9, 6.0102456216, 90394.82301305079), new Vsop87.LnVsop(9.1E-10, 1.77665981007, 1539.315869812), new Vsop87.LnVsop(9.2E-10, 0.99804571578, 95.9792272178), new Vsop87.LnVsop(1.17E-9, 2.24143299549, 56600.2792895222), new Vsop87.LnVsop(1.18E-9, 6.0912132594, 29786.660256881), new Vsop87.LnVsop(9.8E-10, 4.60938156207, 11787.1059703098), new Vsop87.LnVsop(9.7E-10, 3.92727733144, 11794.1522070078), new Vsop87.LnVsop(8.5E-10, 5.30575031807, 19624.7501612982), new Vsop87.LnVsop(1.06E-9, 0.82812501368, 24383.0791084414), new Vsop87.LnVsop(8.5E-10, 5.69642646462, 37703.9780242558), new Vsop87.LnVsop(1.14E-9, 5.19676285428, 70743.77453195279), new Vsop87.LnVsop(8.1E-10, 5.51324815184, 412.3710968744), new Vsop87.LnVsop(8.0E-10, 5.77520799089, 10632.7701900862), new Vsop87.LnVsop(8.9E-10, 2.13409771828, 44768.0994098786), new Vsop87.LnVsop(9.4E-10, 2.18120919704, 28313.288804661), new Vsop87.LnVsop(8.8E-10, 0.57046254096, 3956.5080160194), new Vsop87.LnVsop(7.8E-10, 4.47358603432, 114.43928868521), new Vsop87.LnVsop(1.04E-9, 4.9404530201, 45585.1728121874), new Vsop87.LnVsop(9.7E-10, 4.02223363553, 10218.8084705184), new Vsop87.LnVsop(9.4E-10, 5.81137122373, 69166.430989505), new Vsop87.LnVsop(7.6E-10, 0.78247116213, 9793.8009023358), new Vsop87.LnVsop(7.9E-10, 4.73339536112, 24978.5245894808), new Vsop87.LnVsop(1.01E-9, 4.81437377872, 58177.62283197), new Vsop87.LnVsop(9.7E-10, 3.61746670975, 60530.4889857418), new Vsop87.LnVsop(8.8E-10, 4.87010387338, 63658.8777508376), new Vsop87.LnVsop(8.8E-10, 5.17408120336, 48417.97290558199), new Vsop87.LnVsop(7.8E-10, 5.81927313665, 567.7186377304), new Vsop87.LnVsop(7.7E-10, 6.16012067704, 1573.8204240988), new Vsop87.LnVsop(8.4E-10, 0.62512782571, 18100.00325845), new Vsop87.LnVsop(7.6E-10, 5.12867208321, 49515.382508407), new Vsop87.LnVsop(6.7E-10, 0.24541021814, 17271.8840075264), new Vsop87.LnVsop(6.9E-10, 0.29569499496, 10175.2578735752), new Vsop87.LnVsop(8.8E-10, 5.43871184563, 42456.7840470916), new Vsop87.LnVsop(7.9E-10, 0.3021172853, 63498.47038145279), new Vsop87.LnVsop(8.0E-10, 2.69571879625, 3149.1641605882), new Vsop87.LnVsop(6.1E-10, 4.80385228047, 19889.76658032659), new Vsop87.LnVsop(8.4E-10, 0.22956807093, 88817.479470603), new Vsop87.LnVsop(6.0E-10, 0.46406912136, 36301.18868778519), new Vsop87.LnVsop(7.1E-10, 0.76007659495, 57837.1383323006), new Vsop87.LnVsop(8.1E-10, 5.24314123043, 36173.7081971002), new Vsop87.LnVsop(5.7E-10, 3.07470109636, 2118.7638603784), new Vsop87.LnVsop(7.5E-10, 0.66947402578, 10735.8629643048), new Vsop87.LnVsop(5.8E-10, 4.94877232192, 47888.2819404874), new Vsop87.LnVsop(6.8E-10, 0.96147256965, 24341.5283174566), new Vsop87.LnVsop(7.6E-10, 0.15485592669, 68390.90837818099), new Vsop87.LnVsop(6.4E-10, 3.61826420613, 32243.4985008806), new Vsop87.LnVsop(6.2E-10, 1.59487827272, 39999.945803092), new Vsop87.LnVsop(6.3E-10, 0.16823121009, 53445.5922046266), new Vsop87.LnVsop(5.2E-10, 2.85553976522, 10323.4918674304), new Vsop87.LnVsop(5.8E-10, 1.07613515145, 11692.1521202754), new Vsop87.LnVsop(5.2E-10, 2.34807495268, 26709.6469424134), new Vsop87.LnVsop(6.2E-10, 4.098022189, 34554.8138636676), new Vsop87.LnVsop(4.8E-10, 0.76057327599, 44783.3518810636), new Vsop87.LnVsop(6.7E-10, 0.07870600216, 47964.337285759), new Vsop87.LnVsop(4.8E-10, 5.30855519348, 48733.23133818299), new Vsop87.LnVsop(4.7E-10, 3.09314000663, 70269.18098269838), new Vsop87.LnVsop(5.3E-10, 5.53372176617, 19903.99367432819), new Vsop87.LnVsop(5.7E-10, 2.43412854215, 10228.538017396), new Vsop87.LnVsop(4.3E-10, 6.00071261364, 47938.0389659592), new Vsop87.LnVsop(5.8E-10, 1.23233304711, 59754.9663744178), new Vsop87.LnVsop(5.5E-10, 0.99068063794, 21000.9158907568), new Vsop87.LnVsop(6.0E-10, 5.94539126752, 69968.2519206288), new Vsop87.LnVsop(4.9E-10, 3.83996757537, 38631.285550247), new Vsop87.LnVsop(4.2E-10, 4.73460925987, 37895.4262903674), new Vsop87.LnVsop(4.4E-10, 1.75905995399, 71519.2971432768), new Vsop87.LnVsop(4.3E-10, 6.08746206685, 2957.7158944766), new Vsop87.LnVsop(4.0E-10, 1.31794872194, 20529.66386664059), new Vsop87.LnVsop(4.6E-10, 4.41749158726, 34570.0663348526), new Vsop87.LnVsop(4.5E-10, 2.60413561993, 58101.5674866984), new Vsop87.LnVsop(3.7E-10, 4.69673401538, 44007.8292697396), new Vsop87.LnVsop(3.9E-10, 2.32823034676, 55798.4583583984), new Vsop87.LnVsop(5.1E-10, 1.76846419002, 78604.19392439199), new Vsop87.LnVsop(3.8E-10, 1.28879356308, 73096.64068572459), new Vsop87.LnVsop(4.8E-10, 1.18664500846, 28306.66024576099), new Vsop87.LnVsop(3.6E-10, 0.64770877031, 1478.8665740644), new Vsop87.LnVsop(4.8E-10, 0.40666475573, 40103.9178933198)};
        private static final Vsop87.LnVsop[] venus_longitude_l1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(10213.28554621638, 0.0, 0.0), new Vsop87.LnVsop(9.5617813E-4, 2.4640651111, 10213.285546211), new Vsop87.LnVsop(7.787201E-5, 0.6247848222, 20426.571092422), new Vsop87.LnVsop(1.51666E-6, 6.10638559291, 1577.3435424478), new Vsop87.LnVsop(1.41694E-6, 2.12362986036, 30639.856638633), new Vsop87.LnVsop(1.73908E-6, 2.65539499463, 26.2983197998), new Vsop87.LnVsop(8.2235E-7, 5.70231469551, 191.4482661116), new Vsop87.LnVsop(6.9732E-7, 2.68128549229, 9437.762934887), new Vsop87.LnVsop(5.2292E-7, 3.60270736876, 775.522611324), new Vsop87.LnVsop(3.8313E-7, 1.03371309443, 529.6909650946), new Vsop87.LnVsop(2.963E-7, 1.25050823203, 5507.5532386674), new Vsop87.LnVsop(2.5056E-7, 6.1065063866, 10404.7338123226), new Vsop87.LnVsop(1.7772E-7, 6.19369679929, 1109.3785520934), new Vsop87.LnVsop(1.651E-7, 2.64360813203, 7.1135470008), new Vsop87.LnVsop(1.4231E-7, 5.45125927817, 9153.9036160218), new Vsop87.LnVsop(1.1627E-7, 4.97604433638, 213.299095438), new Vsop87.LnVsop(1.2563E-7, 1.88122194951, 382.8965322232), new Vsop87.LnVsop(8.877E-8, 0.95245393457, 13367.9726311066), new Vsop87.LnVsop(7.374E-8, 4.3947635255, 10206.1719992102), new Vsop87.LnVsop(6.55E-8, 2.28168331756, 2352.8661537718), new Vsop87.LnVsop(6.444E-8, 1.41156299643, 40853.142184844), new Vsop87.LnVsop(6.269E-8, 4.08365791523, 3154.6870848956), new Vsop87.LnVsop(6.702E-8, 5.05916048534, 801.8209311238), new Vsop87.LnVsop(4.099E-8, 4.12235848112, 18837.49819713819), new Vsop87.LnVsop(4.883E-8, 3.44513438224, 11015.1064773348), new Vsop87.LnVsop(3.549E-8, 6.19934345402, 5.5229243074), new Vsop87.LnVsop(3.448E-8, 1.77404222413, 11322.6640983044), new Vsop87.LnVsop(4.29E-8, 0.08136342862, 6283.0758499914), new Vsop87.LnVsop(3.699E-8, 2.48455675849, 5661.3320491522), new Vsop87.LnVsop(3.671E-8, 1.48751015918, 1059.3819301892), new Vsop87.LnVsop(3.018E-8, 2.23849523296, 18073.7049386502), new Vsop87.LnVsop(3.0E-8, 0.39169917698, 15.252471185), new Vsop87.LnVsop(2.776E-8, 1.45644767378, 10239.5838660108), new Vsop87.LnVsop(2.463E-8, 0.36768007007, 22003.9146348698), new Vsop87.LnVsop(2.954E-8, 5.34806371393, 7084.8967811152), new Vsop87.LnVsop(2.35E-8, 2.36543900882, 17298.1823273262), new Vsop87.LnVsop(2.405E-8, 2.36085521516, 10596.1820784342), new Vsop87.LnVsop(2.471E-8, 2.11327686375, 8635.9420037632), new Vsop87.LnVsop(1.717E-8, 4.72125604095, 10186.9872264112), new Vsop87.LnVsop(2.135E-8, 4.46350370275, 8624.2126509272), new Vsop87.LnVsop(1.626E-8, 0.86147271429, 12566.1516999828), new Vsop87.LnVsop(1.523E-8, 0.67189933187, 14143.4952424306), new Vsop87.LnVsop(1.473E-8, 2.59350470099, 7064.1213856228), new Vsop87.LnVsop(1.474E-8, 5.92233777117, 9786.687355335), new Vsop87.LnVsop(1.237E-8, 2.59741927942, 4551.9534970588), new Vsop87.LnVsop(1.219E-8, 2.83617320089, 9676.4810341156), new Vsop87.LnVsop(1.242E-8, 0.82080840456, 10742.9765113056), new Vsop87.LnVsop(1.007E-8, 4.25205211647, 426.598190876), new Vsop87.LnVsop(1.097E-8, 3.84455455465, 21228.3920235458), new Vsop87.LnVsop(1.15E-8, 2.35531987378, 9690.7081281172), new Vsop87.LnVsop(1.219E-8, 2.27326005102, 522.5774180938), new Vsop87.LnVsop(1.101E-8, 3.74248862749, 18307.8072320436), new Vsop87.LnVsop(1.031E-8, 2.03889374176, 38.0276726358), new Vsop87.LnVsop(9.71E-9, 6.10589743884, 3532.0606928114), new Vsop87.LnVsop(8.87E-9, 4.72636674421, 10988.808157535), new Vsop87.LnVsop(9.27E-9, 1.05402087347, 10021.8372800994), new Vsop87.LnVsop(8.21E-9, 2.60456032773, 19.66976089979), new Vsop87.LnVsop(7.8E-9, 0.18364413336, 4705.7323075436), new Vsop87.LnVsop(8.1E-9, 1.32033186808, 19896.8801273274), new Vsop87.LnVsop(7.44E-9, 3.3312974311, 536.8045120954), new Vsop87.LnVsop(7.97E-9, 2.23891817601, 3723.508958923), new Vsop87.LnVsop(7.09E-9, 5.95126881058, 20.7753954924), new Vsop87.LnVsop(8.94E-9, 1.0852296856, 11790.6290886588), new Vsop87.LnVsop(6.6E-9, 0.29717009501, 7860.4193924392), new Vsop87.LnVsop(7.33E-9, 2.22147883292, 19360.07561523199), new Vsop87.LnVsop(7.02E-9, 1.76206343944, 19374.3027092336), new Vsop87.LnVsop(6.33E-9, 2.15202166788, 16496.3613962024), new Vsop87.LnVsop(5.75E-9, 2.38792087791, 6770.7106012456), new Vsop87.LnVsop(5.32E-9, 4.4157613089, 574.3447983348), new Vsop87.LnVsop(5.18E-9, 1.52546538858, 25934.1243310894), new Vsop87.LnVsop(4.79E-9, 0.30473233584, 28286.9904848612), new Vsop87.LnVsop(5.76E-9, 5.41170044566, 206.1855484372), new Vsop87.LnVsop(4.82E-9, 0.40816741074, 3340.6124266998), new Vsop87.LnVsop(5.37E-9, 0.22055767322, 19367.1891622328), new Vsop87.LnVsop(5.74E-9, 4.07672246337, 19651.048481098), new Vsop87.LnVsop(5.01E-9, 3.08578363577, 245.8316462294), new Vsop87.LnVsop(4.88E-9, 5.22318430105, 25158.6017197654), new Vsop87.LnVsop(4.5E-9, 0.212798446, 11.729352836), new Vsop87.LnVsop(4.32E-9, 1.32004964493, 103.0927742186), new Vsop87.LnVsop(4.34E-9, 5.91094755233, 19786.67380610799), new Vsop87.LnVsop(4.21E-9, 2.71057839701, 13936.794505134), new Vsop87.LnVsop(5.64E-9, 6.13266504618, 3930.2096962196), new Vsop87.LnVsop(4.78E-9, 4.70225377704, 14945.3161735544), new Vsop87.LnVsop(4.08E-9, 2.93857115699, 10220.3990932118), new Vsop87.LnVsop(3.59E-9, 0.72354778897, 419.4846438752), new Vsop87.LnVsop(4.49E-9, 1.44520508753, 8662.240323563), new Vsop87.LnVsop(3.53E-9, 2.85616596224, 29864.334027309), new Vsop87.LnVsop(3.33E-9, 1.41991315364, 29580.4747084438), new Vsop87.LnVsop(4.43E-9, 1.93864343247, 9146.790069021), new Vsop87.LnVsop(3.1E-9, 1.08363376581, 20618.0193585336), new Vsop87.LnVsop(3.24E-9, 1.80146948625, 18830.38465013739), new Vsop87.LnVsop(3.7E-9, 6.16895004656, 2218.7571041868), new Vsop87.LnVsop(2.78E-9, 2.20429108375, 18844.61174413899), new Vsop87.LnVsop(2.86E-9, 3.08458231517, 17277.4069318338), new Vsop87.LnVsop(3.83E-9, 0.13900678695, 4732.0306273434), new Vsop87.LnVsop(2.92E-9, 0.43530118043, 29088.811415985), new Vsop87.LnVsop(2.73E-9, 5.84415383782, 9573.388259897), new Vsop87.LnVsop(3.24E-9, 2.1413543954, 9999.986450773), new Vsop87.LnVsop(2.64E-9, 5.20407029554, 220.4126424388), new Vsop87.LnVsop(2.54E-9, 0.34417665274, 28521.0927782546), new Vsop87.LnVsop(3.0E-9, 3.76015126903, 8094.5216858326), new Vsop87.LnVsop(3.03E-9, 1.85088655195, 1589.0728952838), new Vsop87.LnVsop(2.06E-9, 2.49682541324, 51066.427731055), new Vsop87.LnVsop(2.06E-9, 0.97144383633, 10234.0609417034), new Vsop87.LnVsop(2.12E-9, 0.241736776, 36.0278666774), new Vsop87.LnVsop(2.08E-9, 5.19345603406, 24356.7807886416), new Vsop87.LnVsop(2.16E-9, 5.88607943223, 18875.525869774), new Vsop87.LnVsop(2.58E-9, 6.27611237676, 1551.045222648), new Vsop87.LnVsop(2.0E-9, 2.09314510849, 9683.5945811164), new Vsop87.LnVsop(2.17E-9, 5.79530885159, 9103.9069941176), new Vsop87.LnVsop(1.88E-9, 0.39123199129, 19573.37471066999), new Vsop87.LnVsop(1.87E-9, 5.49670351645, 170.6728706192), new Vsop87.LnVsop(2.33E-9, 3.85755192539, 20400.2727726222), new Vsop87.LnVsop(1.78E-9, 4.90042854659, 10787.6303445458), new Vsop87.LnVsop(1.88E-9, 1.62614657498, 9161.0171630226), new Vsop87.LnVsop(1.77E-9, 1.88170417337, 33019.0211122046), new Vsop87.LnVsop(2.09E-9, 2.66033526608, 3442.5749449654), new Vsop87.LnVsop(1.64E-9, 5.04773317971, 32217.2001810808), new Vsop87.LnVsop(1.62E-9, 4.92736966968, 10426.584641649), new Vsop87.LnVsop(1.86E-9, 5.13678812068, 7255.5696517344), new Vsop87.LnVsop(1.77E-9, 5.70206821967, 9992.8729037722), new Vsop87.LnVsop(1.77E-9, 2.40042123486, 20452.8694122218), new Vsop87.LnVsop(2.12E-9, 2.73881400176, 3128.3887650958), new Vsop87.LnVsop(2.08E-9, 3.38876526854, 17778.11626694899), new Vsop87.LnVsop(1.73E-9, 4.09215943674, 33794.5437235286), new Vsop87.LnVsop(1.47E-9, 4.25008910034, 16983.9961474566), new Vsop87.LnVsop(1.89E-9, 1.43553862242, 2379.1644735716), new Vsop87.LnVsop(1.39E-9, 2.99154379541, 110.2063212194), new Vsop87.LnVsop(1.59E-9, 5.23851679605, 10007.0999977738), new Vsop87.LnVsop(1.69E-9, 2.67970563071, 15720.8387848784), new Vsop87.LnVsop(1.36E-9, 0.88942869764, 22805.7355659936), new Vsop87.LnVsop(1.55E-9, 5.90500835975, 12592.4500197826), new Vsop87.LnVsop(1.51E-9, 0.03422618975, 27991.40181316), new Vsop87.LnVsop(1.11E-9, 0.77661072477, 6681.2248533996), new Vsop87.LnVsop(1.09E-9, 2.25388616761, 26735.9452622132), new Vsop87.LnVsop(1.22E-9, 4.84805105466, 19992.85935454519), new Vsop87.LnVsop(1.12E-9, 3.31796669604, 36949.2308084242), new Vsop87.LnVsop(1.06E-9, 3.34507236765, 10103.0792249916), new Vsop87.LnVsop(1.14E-9, 4.36384000196, 20007.0864485468), new Vsop87.LnVsop(1.21E-9, 5.42385293514, 37724.7534197482), new Vsop87.LnVsop(1.0E-9, 0.05731448574, 30110.1656735384), new Vsop87.LnVsop(9.8E-10, 5.07711736751, 135.62532501), new Vsop87.LnVsop(1.09E-9, 0.54849921587, 21535.9496445154), new Vsop87.LnVsop(1.04E-9, 3.67555714699, 21202.093703746), new Vsop87.LnVsop(1.03E-9, 2.65873403125, 20213.271996984), new Vsop87.LnVsop(8.7E-10, 5.04316754485, 9830.3890139878), new Vsop87.LnVsop(1.03E-9, 2.01542881355, 45585.1728121874), new Vsop87.LnVsop(8.8E-10, 2.62613816931, 21.8508293264), new Vsop87.LnVsop(8.4E-10, 3.50355880173, 639.897286314), new Vsop87.LnVsop(9.9E-10, 0.61072730211, 41654.9631159678), new Vsop87.LnVsop(8.1E-10, 0.46468679835, 77.673770428), new Vsop87.LnVsop(9.2E-10, 4.82530051729, 29043.67019634839), new Vsop87.LnVsop(9.0E-10, 4.34075776744, 29057.89729034999), new Vsop87.LnVsop(8.1E-10, 0.01915973453, 24150.080051345), new Vsop87.LnVsop(9.5E-10, 2.4261378651, 23581.2581773176), new Vsop87.LnVsop(1.01E-9, 4.27032438869, 15874.6175953632), new Vsop87.LnVsop(9.3E-10, 1.79250830018, 12432.0426503978), new Vsop87.LnVsop(8.7E-10, 5.25157021446, 14128.2427712456), new Vsop87.LnVsop(8.9E-10, 5.65756996753, 377.3736079158), new Vsop87.LnVsop(7.6E-10, 1.32618111784, 18300.69368504279), new Vsop87.LnVsop(9.7E-10, 5.67942873241, 227.476132789), new Vsop87.LnVsop(7.6E-10, 2.93363913259, 38204.687359371), new Vsop87.LnVsop(9.1E-10, 2.60544242067, 1052.2683831884), new Vsop87.LnVsop(8.4E-10, 5.65355105405, 17468.8551979454), new Vsop87.LnVsop(8.2E-10, 0.14972353998, 29050.7837433492), new Vsop87.LnVsop(8.6E-10, 1.42751065635, 11272.6674764002), new Vsop87.LnVsop(7.3E-10, 4.75280755154, 40879.4405046438), new Vsop87.LnVsop(6.8E-10, 3.56578829793, 30666.1549584328), new Vsop87.LnVsop(6.8E-10, 5.80655405181, 20809.4676246452), new Vsop87.LnVsop(7.9E-10, 3.8444038545, 27511.4678735372), new Vsop87.LnVsop(6.7E-10, 3.74236733721, 49515.382508407), new Vsop87.LnVsop(6.4E-10, 4.24772678145, 153.7788104848), new Vsop87.LnVsop(6.4E-10, 2.99454749109, 27197.2816936676), new Vsop87.LnVsop(7.0E-10, 4.03868009742, 56600.2792895222), new Vsop87.LnVsop(6.9E-10, 1.73648747605, 37410.5672398786), new Vsop87.LnVsop(6.5E-10, 1.08206062736, 68050.42387851159), new Vsop87.LnVsop(6.2E-10, 4.7769845465, 3914.9572250346), new Vsop87.LnVsop(6.8E-10, 4.28465793234, 39264.0692895602), new Vsop87.LnVsop(6.1E-10, 4.96121014691, 34596.3646546524), new Vsop87.LnVsop(5.8E-10, 3.74010494151, 1066.49547719), new Vsop87.LnVsop(6.3E-10, 0.15331622244, 57375.8019008462), new Vsop87.LnVsop(5.7E-10, 5.4259095893, 20419.45754542119), new Vsop87.LnVsop(5.7E-10, 3.59399518494, 735.8765135318), new Vsop87.LnVsop(6.5E-10, 2.10322000074, 74.7815985673), new Vsop87.LnVsop(6.5E-10, 4.21150522641, 49.7570254718), new Vsop87.LnVsop(5.2E-10, 0.03409255574, 18849.2275499742), new Vsop87.LnVsop(5.2E-10, 1.95168272115, 18314.9207790444), new Vsop87.LnVsop(5.5E-10, 2.63906959481, 52670.0695933026), new Vsop87.LnVsop(5.7E-10, 1.25081330234, 10218.8084705184), new Vsop87.LnVsop(5.3E-10, 2.14346912907, 13745.3462390224), new Vsop87.LnVsop(4.9E-10, 0.77417108584, 35371.8872659764), new Vsop87.LnVsop(4.8E-10, 6.00565977593, 283.8593188652), new Vsop87.LnVsop(5.0E-10, 4.45949921607, 40077.61957352), new Vsop87.LnVsop(4.7E-10, 2.63299859494, 51868.2486621788), new Vsop87.LnVsop(4.6E-10, 0.05105081843, 38526.574350872), new Vsop87.LnVsop(5.0E-10, 4.37549274002, 28513.97923125379), new Vsop87.LnVsop(4.6E-10, 2.93422086586, 27682.1407441564), new Vsop87.LnVsop(6.2E-10, 0.41777498261, 30831.3049047446), new Vsop87.LnVsop(5.3E-10, 1.55276873128, 36301.18868778519), new Vsop87.LnVsop(5.1E-10, 5.45979584751, 60530.4889857418), new Vsop87.LnVsop(5.1E-10, 2.02307685593, 59728.668054618), new Vsop87.LnVsop(4.5E-10, 5.59492908223, 467.9649903544), new Vsop87.LnVsop(4.6E-10, 5.16141298965, 53445.5922046266), new Vsop87.LnVsop(4.5E-10, 5.79863400674, 39793.7602546548), new Vsop87.LnVsop(4.4E-10, 2.35499883188, 9411.4646150872), new Vsop87.LnVsop(4.3E-10, 5.62725673544, 14.2270940016), new Vsop87.LnVsop(4.7E-10, 3.73567275749, 64460.6986819614), new Vsop87.LnVsop(4.1E-10, 4.11417818861, 14765.2390432698), new Vsop87.LnVsop(3.9E-10, 0.99375127466, 94138.32702008578), new Vsop87.LnVsop(4.0E-10, 3.06358586355, 813.5502839598), new Vsop87.LnVsop(3.9E-10, 6.21378797479, 44809.6502008634), new Vsop87.LnVsop(3.8E-10, 5.90441887648, 14919.0178537546), new Vsop87.LnVsop(3.7E-10, 1.08711907413, 17085.9586657222), new Vsop87.LnVsop(3.9E-10, 1.31034025695, 48739.859897083), new Vsop87.LnVsop(4.7E-10, 1.46478876042, 38500.2760310722), new Vsop87.LnVsop(4.5E-10, 5.84053368365, 37674.9963942764), new Vsop87.LnVsop(3.6E-10, 1.43280677914, 42456.7840470916), new Vsop87.LnVsop(3.9E-10, 0.94257393865, 16522.6597160022), new Vsop87.LnVsop(3.5E-10, 3.00235738584, 36147.4098773004), new Vsop87.LnVsop(3.1E-10, 1.04908493403, 20235.1228263104), new Vsop87.LnVsop(2.9E-10, 2.4048223852, 22779.4372461938), new Vsop87.LnVsop(3.2E-10, 0.41152109043, 10207.7626219036), new Vsop87.LnVsop(2.8E-10, 4.55982574192, 69166.430989505), new Vsop87.LnVsop(2.6E-10, 5.74236795898, 31441.6775697568), new Vsop87.LnVsop(2.7E-10, 0.29541194003, 19999.97290154599), new Vsop87.LnVsop(3.3E-10, 4.76470012256, 32858.61374281979), new Vsop87.LnVsop(3.2E-10, 2.73060531796, 42430.4857272918), new Vsop87.LnVsop(3.1E-10, 6.16859793641, 10192.5101507186), new Vsop87.LnVsop(2.2E-10, 5.00575021321, 38741.4918714664), new Vsop87.LnVsop(2.3E-10, 1.31610007722, 41962.5207369374), new Vsop87.LnVsop(2.5E-10, 3.71847476472, 55798.4583583984), new Vsop87.LnVsop(2.0E-10, 3.45607652624, 51092.7260508548), new Vsop87.LnVsop(2.2E-10, 4.07064236572, 77026.8503819442), new Vsop87.LnVsop(2.0E-10, 3.00992711288, 24383.0791084414), new Vsop87.LnVsop(2.3E-10, 2.62973172963, 17248.4253018544)};
        private static final Vsop87.LnVsop[] venus_longitude_l2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.894209E-5, 0.34823650721, 10213.285546211), new Vsop87.LnVsop(5.95403E-6, 2.01456107998, 20426.571092422), new Vsop87.LnVsop(2.87868E-6, 0.0, 0.0), new Vsop87.LnVsop(2.3838E-7, 2.04588223604, 26.2983197998), new Vsop87.LnVsop(9.964E-8, 3.97089333901, 775.522611324), new Vsop87.LnVsop(7.196E-8, 3.65730119531, 30639.856638633), new Vsop87.LnVsop(7.043E-8, 1.52107808192, 1577.3435424478), new Vsop87.LnVsop(6.014E-8, 1.00039990357, 191.4482661116), new Vsop87.LnVsop(3.167E-8, 4.36138169912, 9437.762934887), new Vsop87.LnVsop(1.934E-8, 3.39260216059, 382.8965322232), new Vsop87.LnVsop(1.459E-8, 6.05311371882, 529.6909650946), new Vsop87.LnVsop(1.345E-8, 2.94746266562, 5507.5532386674), new Vsop87.LnVsop(1.024E-8, 1.40825326249, 10404.7338123226), new Vsop87.LnVsop(1.224E-8, 3.73276078401, 3154.6870848956), new Vsop87.LnVsop(1.033E-8, 3.52850062173, 11015.1064773348), new Vsop87.LnVsop(7.67E-9, 2.69606070058, 40853.142184844), new Vsop87.LnVsop(9.54E-9, 5.11160150203, 801.8209311238), new Vsop87.LnVsop(7.42E-9, 1.49195106907, 1109.3785520934), new Vsop87.LnVsop(5.25E-9, 3.3195373002, 213.299095438), new Vsop87.LnVsop(5.74E-9, 0.92286899335, 10239.5838660108), new Vsop87.LnVsop(6.02E-9, 5.19233174414, 7084.8967811152), new Vsop87.LnVsop(4.3E-9, 2.67149013569, 13367.9726311066), new Vsop87.LnVsop(4.14E-9, 4.12761290944, 8635.9420037632), new Vsop87.LnVsop(3.54E-9, 1.12184896586, 9153.9036160218), new Vsop87.LnVsop(3.01E-9, 3.90093359463, 10596.1820784342), new Vsop87.LnVsop(2.12E-9, 5.32697962605, 18837.49819713819), new Vsop87.LnVsop(2.6E-9, 0.22263894789, 2352.8661537718), new Vsop87.LnVsop(2.38E-9, 4.67681098719, 6283.0758499914), new Vsop87.LnVsop(2.01E-9, 4.08110855678, 11790.6290886588), new Vsop87.LnVsop(1.94E-9, 6.02724392286, 7860.4193924392), new Vsop87.LnVsop(1.42E-9, 2.26680009846, 12566.1516999828), new Vsop87.LnVsop(1.34E-9, 4.10542992676, 17298.1823273262), new Vsop87.LnVsop(1.32E-9, 4.94076356419, 14143.4952424306), new Vsop87.LnVsop(1.2E-9, 3.39720208207, 11322.6640983044), new Vsop87.LnVsop(1.22E-9, 5.92478855457, 574.3447983348), new Vsop87.LnVsop(1.23E-9, 0.0958356388, 18073.7049386502), new Vsop87.LnVsop(9.3E-10, 0.4006400555, 1059.3819301892), new Vsop87.LnVsop(9.2E-10, 5.49232517605, 10021.8372800994), new Vsop87.LnVsop(8.4E-10, 4.89826807621, 18307.8072320436), new Vsop87.LnVsop(7.4E-10, 2.35249523388, 426.598190876), new Vsop87.LnVsop(9.3E-10, 4.9930858984, 14945.3161735544), new Vsop87.LnVsop(8.2E-10, 5.40423993574, 10186.9872264112), new Vsop87.LnVsop(7.7E-10, 3.75197709593, 3723.508958923), new Vsop87.LnVsop(7.3E-10, 4.51758491759, 22003.9146348698), new Vsop87.LnVsop(6.3E-10, 5.40172448808, 21228.3920235458), new Vsop87.LnVsop(5.6E-10, 4.11553639116, 7064.1213856228), new Vsop87.LnVsop(6.0E-10, 4.93370008569, 19367.1891622328), new Vsop87.LnVsop(4.9E-10, 3.2537990576, 4705.7323075436), new Vsop87.LnVsop(5.0E-10, 3.7718460921, 16496.3613962024), new Vsop87.LnVsop(4.6E-10, 3.47336429841, 24356.7807886416), new Vsop87.LnVsop(3.9E-10, 4.9034494483, 10988.808157535), new Vsop87.LnVsop(4.3E-10, 5.950938131, 15720.8387848784), new Vsop87.LnVsop(4.6E-10, 0.17122496786, 18875.525869774), new Vsop87.LnVsop(3.6E-10, 0.01596424782, 32217.2001810808), new Vsop87.LnVsop(3.4E-10, 4.09532663146, 51066.427731055), new Vsop87.LnVsop(3.5E-10, 5.21393402819, 29088.811415985), new Vsop87.LnVsop(3.8E-10, 5.09836948659, 20400.2727726222), new Vsop87.LnVsop(3.1E-10, 4.7482115338, 28521.0927782546), new Vsop87.LnVsop(3.4E-10, 0.23500259595, 1551.045222648), new Vsop87.LnVsop(2.8E-10, 6.2273425617, 19896.8801273274), new Vsop87.LnVsop(2.7E-10, 2.91232520372, 20452.8694122218), new Vsop87.LnVsop(2.4E-10, 0.49535690639, 21202.093703746), new Vsop87.LnVsop(2.2E-10, 0.66358494216, 25158.6017197654), new Vsop87.LnVsop(2.1E-10, 4.95420122738, 28286.9904848612), new Vsop87.LnVsop(2.3E-10, 2.15949646745, 20618.0193585336), new Vsop87.LnVsop(1.7E-10, 5.75476455324, 19651.048481098), new Vsop87.LnVsop(1.4E-10, 4.88424354153, 10742.9765113056), new Vsop87.LnVsop(1.6E-10, 1.22245134655, 9683.5945811164), new Vsop87.LnVsop(1.2E-10, 3.40005378661, 9830.3890139878), new Vsop87.LnVsop(1.2E-10, 6.06704683094, 25934.1243310894), new Vsop87.LnVsop(1.1E-10, 3.73596829532, 4732.0306273434), new Vsop87.LnVsop(1.0E-10, 5.50483756065, 29580.4747084438)};
        private static final Vsop87.LnVsop[] venus_longitude_l3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.36328E-6, 4.79698723753, 10213.285546211), new Vsop87.LnVsop(3.0661E-7, 3.71663788064, 20426.571092422), new Vsop87.LnVsop(3.041E-8, 3.14159265359, 0.0), new Vsop87.LnVsop(5.06E-9, 5.34186957078, 30639.856638633), new Vsop87.LnVsop(7.1E-10, 4.27707588774, 40853.142184844), new Vsop87.LnVsop(8.0E-11, 1.76653383282, 10186.9872264112), new Vsop87.LnVsop(6.0E-11, 5.61707828538, 10239.5838660108)};
        private static final Vsop87.LnVsop[] venus_longitude_l4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.636E-8, 2.50540811485, 10213.285546211), new Vsop87.LnVsop(1.08E-8, 5.10106236574, 20426.571092422), new Vsop87.LnVsop(1.8E-10, 0.88315856739, 30639.856638633), new Vsop87.LnVsop(5.0E-11, 5.76650226003, 40853.142184844)};
        private static final Vsop87.LnVsop[] venus_longitude_l5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.22E-9, 1.8871172463, 10213.285546211), new Vsop87.LnVsop(4.3E-10, 0.4212590929, 20426.571092422)};

        Longitude() {
        }
    }
}

