/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.discordemoji.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class EmojiPack {
    private static final Map<Integer, EmojiPack> cache = new HashMap<Integer, EmojiPack>();
    @JsonProperty(required=true)
    private int id;
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String slug;
    @JsonProperty(value="image")
    private URL imageUrl;
    @JsonProperty(value="download", required=true)
    private URL downloadUrl;
    @JsonProperty(value="amount")
    private int size;

    private EmojiPack(JsonNode data) {
        cache.put(this.id, this.update(data));
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSlug() {
        return this.slug;
    }

    public URL getImageUrl() {
        return this.imageUrl;
    }

    public URL getDownloadUrl() {
        return this.downloadUrl;
    }

    public int getSize() {
        return this.size;
    }

    private EmojiPack update(JsonNode data) {
        try {
            this.id = data.path("id").asInt(this.id);
            this.name = data.path("name").asText(this.name);
            this.description = data.path("description").asText(this.description);
            this.slug = data.path("slug").asText(this.slug);
            String str = data.path("image").asText();
            this.imageUrl = str.equals(this.imageUrl == null ? null : this.imageUrl.toExternalForm()) ? this.imageUrl : new URL(str);
            str = data.path("download").asText();
            this.downloadUrl = str.equals(this.downloadUrl == null ? null : this.downloadUrl.toExternalForm()) ? this.downloadUrl : new URL(str);
            this.size = data.path("amount").asInt(this.size);
        }
        catch (Throwable e) {
            throw new RuntimeException(this.toString() + " Update Exception", e);
        }
        return this;
    }

    public static Optional<EmojiPack> getByID(int id) {
        return (cache.size() > 2000 ? cache.entrySet().parallelStream() : cache.entrySet().stream()).filter(entry -> (Integer)entry.getKey() == id).findFirst().map(Map.Entry::getValue);
    }

    public static EmojiPack getOrCreate(JsonNode data) {
        return cache.compute(data.get("id").asInt(), (id, pack) -> pack == null ? new EmojiPack(data) : pack.update(data));
    }
}

