/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util;

import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class PromisedValue<P, T> {
    private final P promisedValue;
    private final NullableFunction<P, T> mapper;
    @Nullable
    private T possibleValue = null;

    public PromisedValue(P promisedValue, NullableFunction<P, T> mapper) {
        this.promisedValue = promisedValue;
        this.mapper = mapper;
    }

    public P getPromisedValue() {
        return this.promisedValue;
    }

    public Optional<T> getPossibleValue() {
        Optional<T> optional;
        if (this.possibleValue == null) {
            this.possibleValue = this.mapper.apply(this.promisedValue);
            optional = Optional.ofNullable(this.possibleValue);
        } else {
            optional = Optional.of(this.possibleValue);
        }
        return optional;
    }

    public static interface NullableFunction<P, T>
    extends Function<P, T> {
        @Override
        @Nullable
        public T apply(P var1);
    }
}

