/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.commands;

import de.kaleidox.javacord.util.commands.Command;
import de.kaleidox.javacord.util.commands.CommandGroup;
import de.kaleidox.javacord.util.commands.CommandRepresentation;
import de.kaleidox.javacord.util.server.properties.PropertyGroup;
import de.kaleidox.javacord.util.ui.embed.DefaultEmbedFactory;
import de.kaleidox.javacord.util.ui.messages.InformationMessage;
import de.kaleidox.javacord.util.ui.messages.RefreshableMessage;
import de.kaleidox.javacord.util.ui.messages.categorizing.CategorizedEmbed;
import de.kaleidox.javacord.util.ui.messages.paging.PagedEmbed;
import de.kaleidox.javacord.util.ui.messages.paging.PagedMessage;
import de.kaleidox.javacord.util.ui.reactions.InfoReaction;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageAuthor;
import org.javacord.api.entity.message.MessageBuilder;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.permission.PermissionType;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.user.User;
import org.javacord.api.event.message.MessageCreateEvent;
import org.javacord.api.event.message.MessageDeleteEvent;
import org.javacord.api.event.message.MessageEditEvent;
import org.javacord.api.event.message.MessageEvent;
import org.javacord.api.util.logging.ExceptionLogger;
import org.javacord.core.util.logging.LoggerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandHandler {
    private static final Logger logger = LoggerUtil.getLogger(CommandHandler.class);
    static final String NO_GROUP = "@NoGroup#";
    private final DiscordApi api;
    private final Map<String, CommandRepresentation> commands = new ConcurrentHashMap<String, CommandRepresentation>();
    private final Map<Long, long[]> responseMap = new ConcurrentHashMap<Long, long[]>();
    public String[] prefixes;
    public boolean autoDeleteResponseOnCommandDeletion;
    private PropertyGroup authMethodProperty = null;
    private Supplier<EmbedBuilder> embedSupplier = null;
    @Nullable
    private PropertyGroup customPrefixProperty;
    private boolean exclusiveCustomPrefix;
    private long[] serverBlacklist;

    public CommandHandler(DiscordApi api) {
        this(api, false);
    }

    public CommandHandler(DiscordApi api, boolean handleMessageEdit) {
        this.api = api;
        this.prefixes = new String[]{"!"};
        this.autoDeleteResponseOnCommandDeletion = true;
        this.customPrefixProperty = null;
        this.exclusiveCustomPrefix = false;
        this.serverBlacklist = new long[0];
        api.addMessageCreateListener(this::handleMessageCreate);
        if (handleMessageEdit) {
            api.addMessageEditListener(this::handleMessageEdit);
        }
        api.addMessageDeleteListener(this::handleMessageDelete);
    }

    public Set<CommandRepresentation> getCommands() {
        HashSet<CommandRepresentation> reps = new HashSet<CommandRepresentation>();
        this.commands.forEach((s, commandRep) -> reps.add((CommandRepresentation)commandRep));
        return reps;
    }

    public void registerCommands(Object register) {
        if (register instanceof Class) {
            this.extractCommandRep(null, ((Class)register).getMethods());
        } else if (register instanceof Method) {
            this.extractCommandRep(null, (Method)register);
        } else {
            this.extractCommandRep(register, register.getClass().getMethods());
        }
    }

    public void unregisterCommands(Object unregister) {
        if (unregister instanceof Class) {
            this.tryUnregister(((Class)unregister).getMethods());
        } else if (unregister instanceof Method) {
            this.tryUnregister((Method)unregister);
        } else {
            this.tryUnregister(unregister.getClass().getMethods());
        }
    }

    public void useDefaultHelp(@Nullable Supplier<EmbedBuilder> embedSupplier) {
        this.embedSupplier = embedSupplier == null ? DefaultEmbedFactory.INSTANCE : embedSupplier;
        this.registerCommands(this);
    }

    public void useCustomPrefixes(@NotNull PropertyGroup propertyGroup, boolean exclusiveCustomPrefix) {
        this.customPrefixProperty = propertyGroup;
        this.exclusiveCustomPrefix = exclusiveCustomPrefix;
    }

    public void useAuthManager(PropertyGroup authMethodProperty) {
        this.authMethodProperty = authMethodProperty;
    }

    public long[] getServerBlacklist() {
        return this.serverBlacklist;
    }

    public void setServerBlacklist(long ... serverIds) {
        this.serverBlacklist = serverIds;
    }

    @CommandGroup(name="Basic Commands", description="All commands for basic interaction with the bot")
    @Command(aliases={"help"}, usage="help [command]", description="Shows a list of commands and what they do.")
    public Object defaultHelpCommand(TextChannel channel, String[] args) {
        if (args.length == 0) {
            if (this.getCommands().stream().filter(cmd -> cmd.showInHelpCommand).filter(cmd -> !Objects.equals(cmd.groupName, "Basic Commands")).allMatch(cmd -> cmd.groupName == null)) {
                PagedEmbed embed = new PagedEmbed((Messageable)channel, this.embedSupplier);
                this.getCommands().stream().filter(cmd -> cmd.showInHelpCommand).sorted(Comparator.comparingInt(cmd -> cmd.groupOrdinal).thenComparingInt(rep -> rep.ordinal)).forEachOrdered(cmd -> embed.addField("__" + cmd.aliases[0] + "__: _" + this.prefixes[0] + cmd.usage + "_", cmd.description));
                return embed;
            }
            CategorizedEmbed embed = new CategorizedEmbed((Messageable)channel);
            this.getCommands().stream().filter(cmd -> cmd.showInHelpCommand).sorted(Comparator.comparingInt(cmd -> cmd.groupOrdinal).thenComparingInt(rep -> rep.ordinal)).filter(cmd -> embed.getCategories().stream().noneMatch(cat -> cmd.groupName != null ? cat.getName().equals(cmd.groupName) : cat.getName().equals("Other commands"))).forEachOrdered(cmd -> {
                if (cmd.groupName != null) {
                    embed.addCategory(cmd.groupName, cmd.groupDescription != null ? cmd.groupDescription : "");
                } else {
                    embed.addCategory("Other commands", "Ungrouped commands");
                }
            });
            this.getCommands().stream().filter(cmd -> cmd.showInHelpCommand).sorted(Comparator.comparingInt(cmd -> cmd.groupOrdinal).thenComparingInt(rep -> rep.ordinal)).forEach(cmd -> embed.getCategories().stream().filter(cat -> cmd.groupName != null ? cat.getName().equals(cmd.groupName) : cat.getName().equals("Other commands")).findFirst().ifPresent(cat -> cat.addField("__" + cmd.aliases[0] + "__: _" + this.prefixes[0] + cmd.usage + "_", cmd.description)));
            return embed;
        }
        EmbedBuilder embed = this.embedSupplier.get();
        Optional<CommandRepresentation> command = this.getCommands().stream().filter(cmd -> {
            for (String alias : cmd.aliases) {
                if (!alias.equalsIgnoreCase(args[0])) continue;
                return true;
            }
            return false;
        }).findAny();
        if (command.isPresent()) {
            CommandRepresentation cmd2 = command.get();
            embed.addField("__" + cmd2.aliases[0] + "__: _" + this.prefixes[0] + cmd2.usage + "_", cmd2.description);
        } else {
            embed.addField("__Unknown Command__: _" + args[0] + "_", "Type _\"" + this.prefixes[0] + "help\"_ for a list of commands.");
        }
        return embed;
    }

    private void extractCommandRep(@Nullable Object invocationTarget, Method ... methods) {
        for (Method method : methods) {
            Class<?> declaring;
            Command cmd = method.getAnnotation(Command.class);
            if (cmd == null) continue;
            CommandGroup group = method.getAnnotation(CommandGroup.class);
            if (group == null && (group = (declaring = method.getDeclaringClass()).getAnnotation(CommandGroup.class)) == null) {
                int i;
                Class[] supers = new Class[declaring.getInterfaces().length + (declaring.getSuperclass() == Object.class ? 0 : 1)];
                for (i = 0; i < declaring.getInterfaces().length; ++i) {
                    supers[i] = declaring.getInterfaces()[i];
                }
                if (declaring.getSuperclass() != Object.class) {
                    supers[supers.length - 1] = declaring.getSuperclass();
                }
                for (i = 0; i < supers.length && (group = supers[i].getAnnotation(CommandGroup.class)) == null; ++i) {
                }
            }
            if (!Modifier.isStatic(method.getModifiers()) && Objects.isNull(invocationTarget)) {
                throw new IllegalArgumentException("Invocation Target cannot be null on non-static methods!");
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                throw new AbstractMethodError("Command annotated method cannot be abstract!");
            }
            boolean hasErrored = false;
            if (!cmd.enableServerChat() && cmd.requiredDiscordPermission() != PermissionType.SEND_MESSAGES) {
                logger.error("Command " + method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + "): Conflicting command properties; private-only commands cannot require permissions!");
                hasErrored = true;
            }
            if (!cmd.enableServerChat() && !cmd.enableServerChat()) {
                logger.error("Command " + method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + "): Conflicting command properties; command cannot disallow both private and server chat!");
                hasErrored = true;
            }
            if (hasErrored) continue;
            CommandRepresentation commandRep = new CommandRepresentation(method, cmd, group, invocationTarget);
            if (cmd.aliases().length > 0) {
                for (String alias : cmd.aliases()) {
                    this.commands.put(alias, commandRep);
                }
            } else {
                this.commands.put(method.getName(), commandRep);
            }
            if (group != null) continue;
            logger.info("Command " + (cmd.aliases().length == 0 ? method.getName() : cmd.aliases()[0]) + " was registered without a CommandGroup annotation!");
        }
    }

    private void tryUnregister(Method ... methods) {
        for (Method method : methods) {
            this.commands.entrySet().stream().filter(entry -> ((CommandRepresentation)entry.getValue()).method.equals(method)).forEach(entry -> this.commands.remove(entry.getKey()));
        }
    }

    private void handleMessageCreate(MessageCreateEvent event) {
        if (this.isBlacklisted((MessageEvent)event)) {
            return;
        }
        Params params = new Params(this.api, event, null, event.getServer().orElse(null), event.getChannel(), event.getMessage(), event.getMessageAuthor());
        this.handleCommand(params.message, event.getChannel(), params);
    }

    private void handleMessageEdit(MessageEditEvent event) {
        if (this.isBlacklisted((MessageEvent)event)) {
            return;
        }
        Params params = new Params(this.api, null, event, event.getServer().orElse(null), event.getChannel(), event.getMessage().orElseGet(() -> (Message)event.requestMessage().join()), event.getMessageAuthor().orElse(null));
        this.handleCommand(params.message, event.getChannel(), params);
    }

    private void handleMessageDelete(MessageDeleteEvent event) {
        if (this.isBlacklisted((MessageEvent)event)) {
            return;
        }
        if (this.autoDeleteResponseOnCommandDeletion) {
            long[] ids = this.responseMap.get(event.getMessageId());
            if (ids == null) {
                return;
            }
            ((CompletableFuture)this.api.getMessageById(ids[0], (TextChannel)this.api.getChannelById(ids[1]).flatMap(Channel::asTextChannel).orElseThrow(AssertionError::new)).thenCompose(Message::delete)).exceptionally(ExceptionLogger.get((Class[])new Class[0]));
        }
    }

    private boolean isBlacklisted(MessageEvent event) {
        if (!event.getServer().isPresent()) {
            return true;
        }
        long id = ((Server)event.getServer().get()).getId();
        for (long blacklisted : this.serverBlacklist) {
            if (id != blacklisted) continue;
            return false;
        }
        return false;
    }

    private void handleCommand(Message message, TextChannel channel, Params commandParams) {
        String[] args;
        CommandRepresentation cmd;
        String content = message.getContent();
        int usedPrefix = -1;
        String[] pref = null;
        if (!message.isPrivateMessage() && this.customPrefixProperty != null) {
            Server server2 = (Server)message.getServer().get();
            if (this.exclusiveCustomPrefix) {
                if (content.toLowerCase().indexOf(this.customPrefixProperty.getValue(server2.getId()).asString().toLowerCase()) == 0) {
                    usedPrefix = Integer.MAX_VALUE;
                }
            } else {
                pref = new String[this.prefixes.length + 1];
                System.arraycopy(this.prefixes, 0, pref, 0, this.prefixes.length);
                pref[pref.length - 1] = this.customPrefixProperty.getValue(server2.getId()).asString();
                for (int i = 0; i < pref.length; ++i) {
                    if (content.toLowerCase().indexOf(pref[i].toLowerCase()) != 0) continue;
                    usedPrefix = i;
                }
            }
        } else {
            switch (this.prefixes.length) {
                case 1: {
                    if (content.toLowerCase().indexOf(this.prefixes[0].toLowerCase()) == 0) {
                        usedPrefix = 0;
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < this.prefixes.length; ++i) {
                        if (content.toLowerCase().indexOf(this.prefixes[i].toLowerCase()) != 0) continue;
                        usedPrefix = i;
                    }
                    break;
                }
                case 0: {
                    return;
                }
            }
        }
        if (pref == null && usedPrefix < this.prefixes.length) {
            pref = this.prefixes;
        }
        if (usedPrefix == -1 || pref == null) {
            return;
        }
        String[] split = this.splitContent(content);
        if (pref[usedPrefix].matches("^(.*\\s.*)+$")) {
            cmd = this.commands.get(split[1].toLowerCase());
            args = new String[split.length - 2];
            System.arraycopy(split, 2, args, 0, args.length);
        } else {
            cmd = this.commands.get(split[0].substring(pref[usedPrefix].length()).toLowerCase());
            args = new String[split.length - 1];
            System.arraycopy(split, 1, args, 0, args.length);
        }
        if (cmd == null) {
            return;
        }
        Params.access$202(commandParams, args);
        ArrayList<String> problems = new ArrayList<String>();
        if (message.isPrivateMessage() && !cmd.enablePrivateChat) {
            problems.add("This command can only be run in a server channel!");
        } else if (!message.isPrivateMessage() && !cmd.enableServerChat) {
            problems.add("This command can only be run in a private channel!");
        }
        switch (this.authMethodProperty == null ? "discord_permission" : commandParams.getServer().map(server -> this.authMethodProperty.getValue((Server)server).asString()).orElse("discord_permission")) {
            case "allow_all": {
                break;
            }
            case "discord_permission": {
                if (message.getUserAuthor().map(usr -> message.getChannel().asServerTextChannel().map(stc -> stc.hasAnyPermission(usr, new PermissionType[]{PermissionType.ADMINISTRATOR, cmd.requiredDiscordPermission})).orElse(true)).orElse(false).booleanValue()) break;
                problems.add("You are missing the required permission: " + cmd.requiredDiscordPermission.name() + "!");
                break;
            }
            default: {
                throw new AssertionError((Object)"Unreachable statement reached");
            }
        }
        int reqArgs = cmd.requiredArguments;
        if (commandParams.args.length < reqArgs) {
            problems.add("This command requires at least " + reqArgs + " argument" + (reqArgs == 1 ? "" : "s") + "!");
        }
        int reqChlMent = cmd.requiredChannelMentions;
        if (message.getMentionedChannels().size() < reqChlMent) {
            problems.add("This command requires at least " + reqChlMent + " channel mention" + (reqChlMent == 1 ? "" : "s") + "!");
        }
        int reqUsrMent = cmd.requiredUserMentions;
        if (message.getMentionedUsers().size() < reqUsrMent) {
            problems.add("This command requires at least " + reqUsrMent + " user mention" + (reqUsrMent == 1 ? "" : "s") + "!");
        }
        int reqRleMent = cmd.requiredRoleMentions;
        if (message.getMentionedRoles().size() < reqRleMent) {
            problems.add("This command requires at least " + reqRleMent + " role mention" + (reqRleMent == 1 ? "" : "s") + "!");
        }
        if (cmd.runInNSFWChannelOnly && !channel.asServerTextChannel().map(ServerTextChannel::isNsfw).orElse(true).booleanValue()) {
            problems.add("This command can only run in an NSFW marked channel!");
        }
        if (problems.size() > 0) {
            this.applyResponseDeletion(message.getId(), (CompletableFuture<Message>)channel.sendMessage(DefaultEmbedFactory.create().setColor(Color.RED).setDescription(String.join((CharSequence)"\n", problems))).exceptionally(ExceptionLogger.get((Class[])new Class[0])));
            return;
        }
        if (cmd.async) {
            this.api.getThreadPool().getExecutorService().submit(() -> this.doInvoke(cmd, commandParams, channel, message));
        } else {
            this.doInvoke(cmd, commandParams, channel, message);
        }
    }

    private String[] splitContent(String content) {
        ArrayList<String> yields = new ArrayList<String>();
        yields.add("");
        boolean inString = false;
        int y = 0;
        int s = -1;
        char c = '\u0000';
        block5: for (int i = 0; i < content.length(); ++i) {
            char p = c;
            c = content.charAt(i);
            switch (c) {
                case '\"': {
                    if (!inString && p != '\\') {
                        if (p == ' ') {
                            yields.add("");
                            s = y++;
                            inString = true;
                            continue block5;
                        }
                        yields.set(y, (String)yields.get(y) + c);
                        continue block5;
                    }
                    if (inString && p != '\\') {
                        if (content.charAt(i + 1) == ' ') {
                            yields.add("");
                            s = y++;
                            inString = false;
                            continue block5;
                        }
                        yields.set(y, (String)yields.get(y) + c);
                        continue block5;
                    }
                    yields.set(y, (String)yields.get(y) + c);
                    continue block5;
                }
                case ' ': {
                    if (inString) {
                        yields.set(y, (String)yields.get(y) + c);
                        continue block5;
                    }
                    yields.add("");
                    s = y++;
                    continue block5;
                }
                case '\\': {
                    continue block5;
                }
                default: {
                    yields.set(y, (String)yields.get(y) + c);
                }
            }
        }
        if (inString) {
            int prevSize = yields.size();
            new ArrayList(yields).stream().skip(s).flatMap(str -> Arrays.stream(str.split(" "))).forEachOrdered(yields::add);
            if (prevSize >= s + 1) {
                yields.subList(s + 1, prevSize + 1).clear();
            }
            yields.set(s + 1, '\"' + (String)yields.get(s + 1));
        }
        yields.removeIf(String::isEmpty);
        return yields.toArray(new String[0]);
    }

    private void doInvoke(CommandRepresentation commandRep, Params commandParams, TextChannel channel, Message message) {
        Object reply;
        try {
            reply = this.invoke(commandRep.method, commandParams, commandRep.invocationTarget);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access command method!", e);
        }
        catch (InvocationTargetException e) {
            new InfoReaction(message, "\u26a0", "Command threw an exception: [" + e.getCause().getClass().getSimpleName() + "] " + e.getCause().getMessage(), 1L, TimeUnit.MINUTES, () -> DefaultEmbedFactory.create().setColor(Color.RED));
            logger.catching(e.getCause());
            return;
        }
        if (reply != null) {
            CompletableFuture<Object> msgFut = null;
            if (reply instanceof EmbedBuilder) {
                msgFut = channel.sendMessage((EmbedBuilder)reply);
            } else if (reply instanceof MessageBuilder) {
                msgFut = ((MessageBuilder)reply).send(channel);
            } else if (reply instanceof InformationMessage) {
                ((InformationMessage)reply).refresh();
            } else if (reply instanceof PagedEmbed) {
                msgFut = ((PagedEmbed)reply).build();
            } else if (reply instanceof PagedMessage) {
                ((PagedMessage)reply).refresh();
            } else if (reply instanceof RefreshableMessage) {
                ((RefreshableMessage)reply).refresh();
            } else {
                msgFut = reply instanceof CategorizedEmbed ? ((CategorizedEmbed)reply).build() : channel.sendMessage(String.valueOf(reply));
            }
            if (msgFut != null) {
                this.applyResponseDeletion(message.getId(), (CompletableFuture<Message>)msgFut.exceptionally(ExceptionLogger.get((Class[])new Class[0])));
            }
        }
    }

    private Object invoke(Method method, Params param, @Nullable Object invocationTarget) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> klasse = parameterTypes[i];
            if (DiscordApi.class.isAssignableFrom(klasse)) {
                args[i] = param.discord;
                continue;
            }
            if (MessageCreateEvent.class.isAssignableFrom(klasse)) {
                args[i] = param.createEvent;
                continue;
            }
            if (MessageEditEvent.class.isAssignableFrom(klasse)) {
                args[i] = param.editEvent;
                continue;
            }
            if (Server.class.isAssignableFrom(klasse)) {
                args[i] = param.server;
                continue;
            }
            if (Boolean.class.isAssignableFrom(klasse)) {
                args[i] = param.message.isPrivateMessage();
                continue;
            }
            if (TextChannel.class.isAssignableFrom(klasse)) {
                if (ServerTextChannel.class.isAssignableFrom(klasse)) {
                    args[i] = param.textChannel.asServerTextChannel().orElse(null);
                    continue;
                }
                if (PrivateChannel.class.isAssignableFrom(klasse)) {
                    args[i] = param.textChannel.asPrivateChannel().orElse(null);
                    continue;
                }
                args[i] = param.textChannel;
                continue;
            }
            args[i] = Message.class.isAssignableFrom(klasse) ? param.message : (User.class.isAssignableFrom(klasse) ? param.author.asUser().orElse(null) : (MessageAuthor.class.isAssignableFrom(klasse) ? param.author : (String[].class.isAssignableFrom(klasse) ? param.args : (Command.Parameters.class.isAssignableFrom(klasse) ? param : null))));
        }
        return method.invoke(invocationTarget, args);
    }

    private void applyResponseDeletion(long cmdMsgId, CompletableFuture<Message> message) {
        message.thenAcceptAsync(msg -> {
            if (this.autoDeleteResponseOnCommandDeletion) {
                this.responseMap.put(cmdMsgId, new long[]{msg.getId(), msg.getChannel().getId()});
            }
        });
    }

    private class Params
    implements Command.Parameters {
        private final DiscordApi discord;
        @Nullable
        private final MessageCreateEvent createEvent;
        @Nullable
        private final MessageEditEvent editEvent;
        @Nullable
        private final Server server;
        private final TextChannel textChannel;
        private final Message message;
        private final MessageAuthor author;
        private String[] args;

        private Params(@Nullable DiscordApi discord, @Nullable MessageCreateEvent createEvent, @Nullable MessageEditEvent editEvent, Server server, TextChannel textChannel, @Nullable Message message, MessageAuthor author) {
            this.discord = discord;
            this.createEvent = createEvent;
            this.editEvent = editEvent;
            this.server = server;
            this.textChannel = textChannel;
            this.message = message;
            this.author = author;
        }

        @Override
        public DiscordApi getDiscord() {
            return this.discord;
        }

        @Override
        public Optional<MessageCreateEvent> getMessageCreateEvent() {
            return Optional.ofNullable(this.createEvent);
        }

        @Override
        public Optional<MessageEditEvent> getMessageEditEvent() {
            return Optional.ofNullable(this.editEvent);
        }

        @Override
        public Optional<Server> getServer() {
            return Optional.ofNullable(this.server);
        }

        @Override
        public TextChannel getTextChannel() {
            return this.textChannel;
        }

        @Override
        public Message getCommandMessage() {
            return this.message;
        }

        @Override
        public Optional<MessageAuthor> getCommandExecutor() {
            return Optional.ofNullable(this.author);
        }

        @Override
        public String[] getArguments() {
            return this.args;
        }

        static /* synthetic */ String[] access$202(Params x0, String[] x1) {
            x0.args = x1;
            return x1;
        }
    }
}

