/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.commands;

import de.kaleidox.javacord.util.commands.Command;
import de.kaleidox.javacord.util.commands.CommandGroup;
import java.lang.reflect.Method;
import org.javacord.api.entity.permission.PermissionType;
import org.jetbrains.annotations.Nullable;

public final class CommandRepresentation {
    public final Method method;
    public final String[] aliases;
    public final String description;
    public final String usage;
    public final int ordinal;
    public final boolean showInHelpCommand;
    public final boolean enablePrivateChat;
    public final boolean enableServerChat;
    public final PermissionType requiredDiscordPermission;
    public final int requiredArguments;
    public final int requiredChannelMentions;
    public final int requiredUserMentions;
    public final int requiredRoleMentions;
    public final boolean runInNSFWChannelOnly;
    public final boolean async;
    @Nullable
    public final String groupName;
    @Nullable
    public final String groupDescription;
    public final int groupOrdinal;
    @Nullable
    public final Object invocationTarget;

    CommandRepresentation(Method method, Command cmd, @Nullable CommandGroup group, @Nullable Object invocationTarget) {
        String[] stringArray;
        this.method = method;
        this.invocationTarget = invocationTarget;
        if (cmd.aliases().length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = method.getName();
        } else {
            stringArray = cmd.aliases();
        }
        this.aliases = stringArray;
        this.description = cmd.description();
        this.usage = cmd.usage();
        this.ordinal = cmd.ordinal();
        this.showInHelpCommand = cmd.shownInHelpCommand();
        this.enablePrivateChat = cmd.enablePrivateChat();
        this.enableServerChat = cmd.enableServerChat();
        this.requiredDiscordPermission = cmd.requiredDiscordPermission();
        this.requiredArguments = cmd.requiredArguments();
        this.requiredChannelMentions = cmd.requiredChannelMentions();
        this.requiredUserMentions = cmd.requiredUserMentions();
        this.requiredRoleMentions = cmd.requiredRoleMentions();
        this.runInNSFWChannelOnly = cmd.runInNSFWChannelOnly();
        this.async = cmd.async();
        if (group != null) {
            this.groupName = !group.name().equals("@NoGroup#") ? group.name() : method.getDeclaringClass().getSimpleName();
            this.groupDescription = !group.description().equals("@NoGroup#") ? group.description() : "No group description provided.";
            this.groupOrdinal = group.ordinal();
        } else {
            this.groupName = null;
            this.groupDescription = null;
            this.groupOrdinal = Integer.MAX_VALUE;
        }
    }

    CommandRepresentation(Method method, Command cmd, String groupName, @Nullable String groupDescription, int groupOrdinal, @Nullable Object invocationTarget) {
        String[] stringArray;
        this.method = method;
        this.invocationTarget = invocationTarget;
        if (cmd.aliases().length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = method.getName();
        } else {
            stringArray = cmd.aliases();
        }
        this.aliases = stringArray;
        this.description = cmd.description();
        this.usage = cmd.usage();
        this.ordinal = cmd.ordinal();
        this.showInHelpCommand = cmd.shownInHelpCommand();
        this.enablePrivateChat = cmd.enablePrivateChat();
        this.enableServerChat = cmd.enableServerChat();
        this.requiredDiscordPermission = cmd.requiredDiscordPermission();
        this.requiredArguments = cmd.requiredArguments();
        this.requiredChannelMentions = cmd.requiredChannelMentions();
        this.requiredUserMentions = cmd.requiredUserMentions();
        this.requiredRoleMentions = cmd.requiredRoleMentions();
        this.runInNSFWChannelOnly = cmd.runInNSFWChannelOnly();
        this.async = cmd.async();
        this.groupName = groupName;
        this.groupDescription = groupDescription;
        this.groupOrdinal = groupOrdinal;
    }

    public String toString() {
        return this.method.getName();
    }
}

