/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.server.properties;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.kaleidox.util.Util;
import de.kaleidox.util.markers.Value;
import java.util.concurrent.ConcurrentHashMap;
import org.javacord.api.entity.server.Server;

public final class PropertyGroup {
    private final String name;
    private final Value defaultValue;
    private final ConcurrentHashMap<Long, Value> values;
    private String displayName;
    private String description;

    public PropertyGroup(String name, Object defaultValue, String displayName, String description) {
        this.name = name;
        this.defaultValue = new Value(defaultValue);
        this.displayName = displayName;
        this.description = description;
        this.values = new ConcurrentHashMap();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PropertyGroup setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public PropertyGroup setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public Value.Setter setValue(Server server) {
        return this.setValue(server.getId());
    }

    public Value.Setter setValue(long serverId) {
        return this.getValue(serverId).setter();
    }

    public Value getValue(Server server) {
        return this.getValue(server.getId());
    }

    public Value getValue(long serverId) {
        return this.values.compute(serverId, (k, v) -> {
            if (v == null) {
                return new Value(this.defaultValue);
            }
            return v;
        });
    }

    void serialize(ArrayNode node) {
        this.values.forEach((id, value) -> {
            if (!value.asString().equals(this.defaultValue.asString())) {
                ObjectNode object = node.addObject();
                object.set("id", Util.nodeOf(id));
                object.set("val", Util.nodeOf(value.asString()));
                object.set("type", Util.nodeOf((value.getValue() != null ? value.getValue() : "").getClass().getName()));
            }
        });
    }
}

