/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.ui.messages;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.event.message.reaction.SingleReactionEvent;

public class RefreshableMessage {
    private static final ConcurrentHashMap<Messageable, RefreshableMessage> selfMap = new ConcurrentHashMap();
    private static final String REFRESH_EMOJI = "\ud83d\udd04";
    private Messageable parent;
    private Supplier<Object> refresher;
    private Message lastMessage = null;

    private RefreshableMessage(Messageable inParent, Supplier<Object> refresher) {
        this.parent = inParent;
        this.refresher = refresher;
        Object item = refresher.get();
        CompletableFuture sent = null;
        if (item instanceof EmbedBuilder) {
            sent = this.parent.sendMessage((EmbedBuilder)item);
        } else if (item instanceof String) {
            sent = this.parent.sendMessage((String)item);
        } else if (item instanceof File) {
            sent = this.parent.sendMessage(new File[]{(File)item});
        }
        if (sent != null) {
            sent.thenAcceptAsync(msg -> {
                this.lastMessage = msg;
                msg.addReactionAddListener(this::onRefresh);
                msg.addReactionRemoveListener(this::onRefresh);
                msg.addReaction(REFRESH_EMOJI);
            });
        }
    }

    public void refresh() {
        if (this.lastMessage != null) {
            Object item = this.refresher.get();
            if (item instanceof EmbedBuilder) {
                this.lastMessage.edit((EmbedBuilder)item);
            } else if (item instanceof String) {
                this.lastMessage.edit((String)item);
            } else if (item instanceof File) {
                this.resend();
            }
        }
    }

    public void resend() {
        Object item = this.refresher.get();
        CompletableFuture sent = null;
        if (this.lastMessage != null) {
            this.lastMessage.delete("Outdated");
        }
        if (item instanceof EmbedBuilder) {
            sent = this.parent.sendMessage((EmbedBuilder)item);
        } else if (item instanceof String) {
            sent = this.parent.sendMessage((String)item);
        } else if (item instanceof File) {
            sent = this.parent.sendMessage(new File[]{(File)item});
        }
        if (sent != null) {
            sent.thenAcceptAsync(msg -> {
                this.lastMessage = msg;
                msg.addReactionAddListener(this::onRefresh);
                msg.addReactionRemoveListener(this::onRefresh);
                msg.addReaction(REFRESH_EMOJI);
            });
        }
    }

    private void onRefresh(SingleReactionEvent event) {
        if (!event.getUser().isYourself() && event.getEmoji().asUnicodeEmoji().orElse("").equals(REFRESH_EMOJI)) {
            this.refresh();
        }
    }

    public static final RefreshableMessage get(Messageable forParent, Supplier<Object> defaultRefresher) {
        if (selfMap.containsKey(forParent)) {
            RefreshableMessage val = selfMap.get(forParent);
            val.resend();
            return val;
        }
        return selfMap.put(forParent, new RefreshableMessage(forParent, defaultRefresher));
    }

    public static final Optional<RefreshableMessage> get(Messageable forParent) {
        if (selfMap.containsKey(forParent)) {
            RefreshableMessage val = selfMap.get(forParent);
            val.resend();
            return Optional.of(val);
        }
        return Optional.empty();
    }
}

