/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.ui.messages.categorizing;

import de.kaleidox.javacord.util.ui.embed.DefaultEmbedFactory;
import de.kaleidox.javacord.util.ui.messages.categorizing.EmbedCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.message.embed.EmbedField;
import org.javacord.api.event.message.reaction.ReactionAddEvent;
import org.javacord.api.event.message.reaction.ReactionRemoveEvent;
import org.javacord.api.event.message.reaction.SingleReactionEvent;
import org.javacord.api.listener.message.MessageAttachableListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;

public class CategorizedEmbed {
    public static final String BACK_TO_MENU_EMOJI = "\u25c0";
    private final Messageable messageable;
    private final Supplier<EmbedBuilder> baseEmbedSupplier;
    private final AtomicReference<Message> sentMessage;
    private final List<EmbedCategory> categories;
    private final Listener listener;
    private int state;

    public CategorizedEmbed(Messageable messageable) {
        this(messageable, DefaultEmbedFactory.INSTANCE);
    }

    public CategorizedEmbed(Messageable messageable, Supplier<EmbedBuilder> baseEmbedSupplier) {
        this.messageable = messageable;
        this.baseEmbedSupplier = baseEmbedSupplier;
        this.sentMessage = new AtomicReference();
        this.categories = new ArrayList<EmbedCategory>();
        this.listener = new Listener();
        this.state = -1;
    }

    public EmbedCategory addCategory(String categoryName, String categoryDescription) {
        EmbedCategory category = new EmbedCategory(categoryName, categoryDescription);
        this.categories.add(category);
        return category;
    }

    public List<EmbedCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public boolean removeIf(Predicate<EmbedCategory> filter) {
        return this.categories.removeIf(filter);
    }

    public CompletableFuture<Message> build() {
        return this.messageable.sendMessage(this.getMenuEmbed()).thenApply(msg -> {
            this.sentMessage.set((Message)msg);
            msg.addMessageAttachableListener((MessageAttachableListener)this.listener);
            for (String reaction : this.getCategoryReactions()) {
                msg.addReaction(reaction);
            }
            return msg;
        });
    }

    private EmbedBuilder getCategoryEmbed(int no) {
        EmbedCategory category = this.categories.get(no);
        EmbedBuilder embed = this.baseEmbedSupplier.get();
        embed.setAuthor(category.getName()).setDescription(category.getDescription()).setFooter("Click the \u25c0 reaction to go back to the menu!");
        for (EmbedField field : category.getFields()) {
            embed.addField(field.getName(), field.getValue(), field.isInline());
        }
        return embed;
    }

    private EmbedBuilder getMenuEmbed() {
        if (this.categories.size() > 20) {
            throw new IllegalStateException("Cannot have more than 20 categories!");
        }
        if (this.categories.size() == 0) {
            throw new IllegalStateException("No categories set!");
        }
        EmbedBuilder embed = this.baseEmbedSupplier.get();
        String[] emojis = this.getCategoryReactions();
        embed.setFooter("Click an emoji to open the corresponding category!");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < emojis.length; ++i) {
            EmbedCategory category = this.categories.get(i);
            String emoji = emojis[i];
            sb.append(emoji).append(" - ").append(category.getName()).append("\n");
        }
        return embed.setDescription(sb.toString());
    }

    private String[] getCategoryReactions() {
        String[] yield = new String[this.categories.size()];
        if (yield.length < 11) {
            // empty if block
        }
        if (yield.length < 21) {
            switch (yield.length) {
                case 20: {
                    yield[19] = "\ud83c\uddf9";
                }
                case 19: {
                    yield[18] = "\ud83c\uddf8";
                }
                case 18: {
                    yield[17] = "\ud83c\uddf7";
                }
                case 17: {
                    yield[16] = "\ud83c\uddf6";
                }
                case 16: {
                    yield[15] = "\ud83c\uddf5";
                }
                case 15: {
                    yield[14] = "\ud83c\uddf4";
                }
                case 14: {
                    yield[13] = "\ud83c\uddf3";
                }
                case 13: {
                    yield[12] = "\ud83c\uddf2";
                }
                case 12: {
                    yield[11] = "\ud83c\uddf1";
                }
                case 11: {
                    yield[10] = "\ud83c\uddf0";
                }
                case 10: {
                    yield[9] = "\ud83c\uddef";
                }
                case 9: {
                    yield[8] = "\ud83c\uddee";
                }
                case 8: {
                    yield[7] = "\ud83c\udded";
                }
                case 7: {
                    yield[6] = "\ud83c\uddec";
                }
                case 6: {
                    yield[5] = "\ud83c\uddeb";
                }
                case 5: {
                    yield[4] = "\ud83c\uddea";
                }
                case 4: {
                    yield[3] = "\ud83c\udde9";
                }
                case 3: {
                    yield[2] = "\ud83c\udde8";
                }
                case 2: {
                    yield[1] = "\ud83c\udde7";
                }
                case 1: {
                    yield[0] = "\ud83c\udde6";
                }
            }
        }
        return yield;
    }

    private class Listener
    implements ReactionAddListener,
    ReactionRemoveListener {
        private Listener() {
        }

        public void onReactionAdd(ReactionAddEvent event) {
            this.handleReaction((SingleReactionEvent)event);
        }

        public void onReactionRemove(ReactionRemoveEvent event) {
            this.handleReaction((SingleReactionEvent)event);
        }

        private void handleReaction(SingleReactionEvent event) {
            if (event.getUser().isYourself()) {
                return;
            }
            int newState = -1;
            int i = 0;
            for (String reaction : CategorizedEmbed.this.getCategoryReactions()) {
                if (event.getEmoji().asUnicodeEmoji().map(reaction::equals).orElse(false).booleanValue()) {
                    newState = i;
                }
                if (event.getEmoji().asUnicodeEmoji().map(CategorizedEmbed.BACK_TO_MENU_EMOJI::equals).orElse(false).booleanValue()) {
                    newState = -1;
                    break;
                }
                ++i;
            }
            Message msg = (Message)CategorizedEmbed.this.sentMessage.get();
            if (CategorizedEmbed.this.state == -1) {
                if (newState == -1) {
                    return;
                }
                msg.edit(CategorizedEmbed.this.getCategoryEmbed(newState)).thenRun(() -> {
                    msg.removeAllReactions();
                    msg.addReaction(CategorizedEmbed.BACK_TO_MENU_EMOJI);
                });
            } else if (newState == -1) {
                msg.edit(CategorizedEmbed.this.getMenuEmbed()).thenRun(() -> {
                    msg.removeAllReactions();
                    for (String reaction : CategorizedEmbed.this.getCategoryReactions()) {
                        msg.addReaction(reaction);
                    }
                });
            } else {
                msg.edit(CategorizedEmbed.this.getCategoryEmbed(newState)).thenRun(() -> {
                    msg.removeAllReactions();
                    msg.addReaction(CategorizedEmbed.BACK_TO_MENU_EMOJI);
                });
            }
            CategorizedEmbed.this.state = newState;
        }
    }
}

