/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.ui.messages.paging;

import de.kaleidox.javacord.util.ui.embed.DefaultEmbedFactory;
import de.kaleidox.javacord.util.ui.embed.EmbedFieldRepresentative;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.event.message.reaction.SingleReactionEvent;
import org.javacord.api.listener.message.MessageAttachableListener;
import org.javacord.api.util.logging.ExceptionLogger;

public class PagedEmbed {
    private final Messageable messageable;
    private final Supplier<EmbedBuilder> embedsupplier;
    private ConcurrentHashMap<Integer, List<Field>> pages = new ConcurrentHashMap();
    private List<Field> fields = new ArrayList<Field>();
    private int page;
    private AtomicReference<Message> sentMessage = new AtomicReference();

    public PagedEmbed(Messageable messageable) {
        this(messageable, DefaultEmbedFactory.INSTANCE);
    }

    public PagedEmbed(Messageable messageable, Supplier<EmbedBuilder> embedsupplier) {
        this.messageable = messageable;
        this.embedsupplier = embedsupplier;
    }

    public PagedEmbed addField(String title, String text) {
        return this.addField(title, text, false);
    }

    public PagedEmbed addField(String title, String text, boolean inline) {
        this.fields.add(new Field(title, text, inline));
        return this;
    }

    public CompletableFuture<Message> build() {
        this.page = 1;
        CompletionStage future = this.messageable.sendMessage(this.embedsupplier.get()).exceptionally(ExceptionLogger.get((Class[])new Class[0]));
        ((CompletableFuture)((CompletableFuture)future).thenAcceptAsync(message -> {
            this.sentMessage.set((Message)message);
            if (this.pages.size() != 1) {
                message.addReactionAddListener(this::onReactionClick);
                message.addReactionRemoveListener(this::onReactionClick);
                message.addReaction(Variables.PREV_PAGE_EMOJI);
                message.addReaction(Variables.NEXT_PAGE_EMOJI);
            }
            message.addMessageDeleteListener(delete -> message.getMessageAttachableListeners().forEach((a, b) -> message.removeMessageAttachableListener((MessageAttachableListener)a))).removeAfter(3L, TimeUnit.HOURS).addRemoveHandler(() -> {
                this.sentMessage.get().removeAllReactions();
                this.sentMessage.get().getMessageAttachableListeners().forEach((a, b) -> message.removeMessageAttachableListener((MessageAttachableListener)a));
            });
            this.refreshPages();
        })).exceptionally(ExceptionLogger.get((Class[])new Class[0]));
        return future;
    }

    public EmbedBuilder getRawEmbed() {
        return this.embedsupplier.get();
    }

    public Supplier<EmbedBuilder> getEmbedsupplier() {
        return this.embedsupplier;
    }

    private void refreshPages() {
        int fieldCount = 0;
        int pageChars = 0;
        int totalChars = 0;
        int thisPage = 1;
        int prevSize = this.pages.size();
        this.pages.clear();
        for (Field field2 : this.fields) {
            this.pages.putIfAbsent(thisPage, new ArrayList());
            if (fieldCount <= Variables.MAX_FIELDS_PER_PAGE && pageChars <= Variables.FIELD_MAX_CHARS * fieldCount && totalChars < Variables.MAX_CHARS_PER_PAGE) {
                this.pages.get(thisPage).add(field2);
                ++fieldCount;
                pageChars += field2.getTotalChars();
                totalChars += field2.getTotalChars();
                continue;
            }
            this.pages.putIfAbsent(++thisPage, new ArrayList());
            this.pages.get(thisPage).add(field2);
            fieldCount = 1;
            pageChars = field2.getTotalChars();
            totalChars = field2.getTotalChars();
        }
        EmbedBuilder embed = this.embedsupplier.get().removeAllFields();
        this.pages.get(this.page).forEach(field -> embed.addField(field.getName(), field.getValue(), field.isInline()));
        embed.setFooter("Page " + this.page + " of " + this.pages.size());
        if (this.sentMessage.get() != null) {
            this.sentMessage.get().edit(embed);
            if (this.pages.size() == 1 && prevSize > 1) {
                this.sentMessage.get().removeOwnReactionByEmoji(Variables.NEXT_PAGE_EMOJI);
                this.sentMessage.get().removeOwnReactionByEmoji(Variables.PREV_PAGE_EMOJI);
            } else if (this.pages.size() > 1 && prevSize == 1) {
                this.sentMessage.get().addReaction(Variables.PREV_PAGE_EMOJI);
                this.sentMessage.get().addReaction(Variables.NEXT_PAGE_EMOJI);
            }
        }
    }

    private void onReactionClick(SingleReactionEvent event) {
        event.getEmoji().asUnicodeEmoji().ifPresent(emoji -> {
            if (!event.getUser().isYourself()) {
                if (Variables.PREV_PAGE_EMOJI.equals(emoji)) {
                    if (this.page > 1) {
                        --this.page;
                    } else if (this.page == 1) {
                        this.page = this.pages.size();
                    }
                    this.refreshPages();
                } else if (Variables.NEXT_PAGE_EMOJI.equals(emoji)) {
                    if (this.page < this.pages.size()) {
                        ++this.page;
                    } else if (this.page == this.pages.size()) {
                        this.page = 1;
                    }
                    this.refreshPages();
                }
            }
        });
    }

    public static class Variables {
        public static int FIELD_MAX_CHARS = 1024;
        public static int MAX_CHARS_PER_PAGE = 4500;
        public static int MAX_FIELDS_PER_PAGE = 8;
        public static String PREV_PAGE_EMOJI = "\u2b05";
        public static String NEXT_PAGE_EMOJI = "\u27a1";
    }

    class Field
    extends EmbedFieldRepresentative {
        public Field(String title, String text, boolean inline) {
            super(title, text, inline);
        }

        int getTotalChars() {
            return this.name.length() + this.value.length();
        }
    }
}

