/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.ui.reactions;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.event.message.reaction.SingleReactionEvent;
import org.javacord.api.util.logging.ExceptionLogger;

public class InfoReaction {
    private final DiscordApi api;
    private final long message;
    private final long channel;
    private final String emoji;
    private final String text;
    private final long time;
    private final TimeUnit unit;
    private final Supplier<EmbedBuilder> embedBaseSupplier;
    private final AtomicLong sentMessage;

    public InfoReaction(Message message, String emoji, String text, long deleteTime, TimeUnit deleteUnit, Supplier<EmbedBuilder> embedBaseSupplier) {
        this.api = message.getApi();
        this.message = message.getId();
        this.channel = message.getChannel().getId();
        this.emoji = emoji;
        this.text = text;
        this.time = deleteTime;
        this.unit = deleteUnit;
        this.embedBaseSupplier = embedBaseSupplier;
        this.sentMessage = new AtomicLong(-1L);
        message.addReaction(emoji);
        message.addReactionAddListener(this::handleReaction);
        message.addReactionRemoveListener(this::handleReaction);
    }

    private synchronized void handleReaction(SingleReactionEvent event) {
        if (event.getUser().isYourself()) {
            return;
        }
        if (!event.getEmoji().asUnicodeEmoji().map(this.emoji::equals).orElse(false).booleanValue()) {
            return;
        }
        if (this.sentMessage.get() == -1L) {
            this.api.getChannelById(this.channel).flatMap(Channel::asTextChannel).ifPresent(tc -> ((CompletableFuture)tc.sendMessage(this.embedBaseSupplier.get().setDescription(this.text).setFooter("This message will self-delete in " + this.time + " " + this.unit.name().toLowerCase())).thenAccept(msg -> {
                this.sentMessage.set(msg.getId());
                msg.getApi().getThreadPool().getScheduler().schedule(() -> {
                    msg.delete();
                    this.sentMessage.set(-1L);
                }, this.time, this.unit);
            })).exceptionally(ExceptionLogger.get((Class[])new Class[0])));
        } else {
            this.api.getChannelById(this.channel).flatMap(Channel::asTextChannel).map(tc -> this.api.getMessageById(this.sentMessage.get(), tc)).ifPresent(fut -> {
                fut.thenAccept(Message::delete);
                this.sentMessage.set(-1L);
            });
        }
    }

    public class MessageTypeEmoji {
        public static final String WARNING = "\u26a0";
    }
}

