/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class Util {
    public static <A, B> Optional<A> findComplex(List<A> list, B criteria, Function<A, B> criteriaExtractor) {
        for (A item : list) {
            if (!criteriaExtractor.apply(item).equals(criteria)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public static <T> List<List<T>> everyOfList(int every, List<T> of) {
        ArrayList<List<T>> val = new ArrayList<List<T>>();
        ArrayList<T> count = new ArrayList<T>();
        int i = 0;
        for (int run = 0; run != of.size(); ++run) {
            if (i == every) {
                i = 0;
            }
            if (i == 0) {
                count = new ArrayList();
                val.add(count);
            }
            count.add(of.get(run));
            ++i;
        }
        return val;
    }

    public static JsonNode nodeOf(Object of) {
        if (of == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        if (of instanceof JsonNode) {
            return (JsonNode)of;
        }
        if (of instanceof Collection) {
            return Util.arrayNode((Collection)of);
        }
        if (of instanceof Stream) {
            return Util.arrayNode(((Stream)of).toArray());
        }
        if (of instanceof Integer) {
            return JsonNodeFactory.instance.numberNode((Integer)of);
        }
        if (of instanceof Long) {
            return JsonNodeFactory.instance.numberNode((Long)of);
        }
        if (of instanceof Double) {
            return JsonNodeFactory.instance.numberNode((Double)of);
        }
        if (of instanceof String) {
            return JsonNodeFactory.instance.textNode((String)of);
        }
        if (of instanceof Boolean) {
            return JsonNodeFactory.instance.booleanNode(((Boolean)of).booleanValue());
        }
        return JsonNodeFactory.instance.textNode(of.toString());
    }

    public static <T, N> ArrayNode arrayNode(List<T> items, Function<T, N> mapper) {
        ArrayNode node = JsonNodeFactory.instance.arrayNode(items.size());
        for (T item : items) {
            node.add(Util.nodeOf(mapper.apply(item)));
        }
        return node;
    }

    public static <T> ArrayNode arrayNode(Collection<T> items) {
        ArrayNode node = JsonNodeFactory.instance.arrayNode(items.size());
        for (T item : items) {
            node.add(Util.nodeOf(item));
        }
        return node;
    }

    public static ArrayNode arrayNode(Object ... items) {
        ArrayNode node = JsonNodeFactory.instance.arrayNode(items.length);
        for (Object item : items) {
            node.add(Util.nodeOf(item));
        }
        return node;
    }

    public static ObjectNode objectNode(Object ... data) {
        if (data.length == 0) {
            return JsonNodeFactory.instance.objectNode();
        }
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("You must provide an even amount of objects to be placed in the node.");
        }
        ObjectNode objectNode = Util.objectNode(new Object[0]);
        for (List<Object> pair : Util.everyOfList(2, Arrays.asList(data))) {
            if (!Objects.nonNull(pair.get(0)) || !Objects.nonNull(pair.get(1))) continue;
            objectNode.set(pair.get(0).toString(), Util.nodeOf(pair.get(1)));
        }
        return objectNode;
    }
}

