/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.markers;

import java.util.Objects;

public class Value {
    protected final Setter setter;
    protected Object value;

    public Value(Object value) {
        this.value = value instanceof Value ? ((Value)value).getValue() : value;
        this.setter = new Setter();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return Objects.isNull(this.value);
    }

    public String asString() {
        return String.valueOf(this.value);
    }

    public boolean asBoolean() {
        return Boolean.valueOf(this.asString());
    }

    public byte asByte() {
        return Byte.valueOf(this.asString());
    }

    public short asShort() {
        return Short.valueOf(this.asString());
    }

    public int asInt() {
        return Integer.valueOf(this.asString());
    }

    public float asFloat() {
        return Float.valueOf(this.asString()).floatValue();
    }

    public double asDouble() {
        return Double.valueOf(this.asString());
    }

    public long asLong() {
        return Long.valueOf(this.asString());
    }

    public char asChar() {
        return this.asString().charAt(0);
    }

    public Setter setter() {
        return this.setter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            return ((Value)obj).asString().equals(this.asString());
        }
        return String.valueOf(obj).equals(this.asString());
    }

    public class Setter {
        private Setter() {
        }

        public void toObject(Object o) {
            Value.this.value = o;
        }

        public void toString(String s) {
            Value.this.value = s;
        }

        public void toBoolean(boolean b) {
            Value.this.value = b;
        }

        public void toByte(byte b) {
            Value.this.value = b;
        }

        public void toShort(short s) {
            Value.this.value = s;
        }

        public void toInt(int i) {
            Value.this.value = i;
        }

        public void toFloat(float f) {
            Value.this.value = Float.valueOf(f);
        }

        public void toDouble(double d) {
            Value.this.value = d;
        }

        public void toLong(long l) {
            Value.this.value = l;
        }

        public void toChar(char c) {
            Value.this.value = Character.valueOf(c);
        }
    }
}

