/*
 * Decompiled with CFR 0.152.
 */
package de.kandid.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class Emitter<T> {
    private static final HashMap<Class<?>, Class<? extends Emitter<?>>> _classes = new HashMap();
    protected Object[] _listeners = new Object[8];
    protected int _end;
    protected boolean _isFiring;

    protected Emitter() {
    }

    public T fire() {
        return (T)this;
    }

    public final boolean isFiring() {
        return this._isFiring;
    }

    public synchronized void add(T listener) {
        this.add(listener, listener);
    }

    public synchronized void add(Object key, T listener) {
        if (this._end + 2 >= this._listeners.length) {
            Object[] newListeners = new Object[this._listeners.length + this._listeners.length / 2];
            System.arraycopy(this._listeners, 0, newListeners, 0, this._listeners.length);
            this._listeners = newListeners;
        }
        this._listeners[this._end] = listener;
        this._listeners[this._end + 1] = key;
        this._end += 2;
    }

    public synchronized void remove(Object key) {
        for (int i = 0; i < this._end; i += 2) {
            if (this._listeners[i + 1] != key) continue;
            this._end -= 2;
            while (i < this._end) {
                this._listeners[i] = this._listeners[i + 2];
                ++i;
            }
            break;
        }
    }

    public static synchronized <T> Emitter<T> makeEmitter(Class<?> interfaze) {
        Class<Emitter<?>> clazz = _classes.get(interfaze);
        if (clazz == null) {
            clazz = Emitter.checkPrecompiled(interfaze);
            if (clazz == null) {
                throw new IllegalArgumentException("No emitter class found for: " + interfaze.getName());
            }
            _classes.put(interfaze, clazz);
        }
        try {
            return Emitter.newInstance(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Class<Emitter<T>> checkPrecompiled(Class<T> interfaze) {
        try {
            String name = interfaze.getName() + "$Emitter";
            Class<Emitter<T>> clazz = interfaze.getClassLoader().loadClass(name);
            return clazz;
        }
        catch (Exception unused) {
            return null;
        }
    }

    private static <T> Emitter<T> newInstance(Class<?> clazz) throws Exception {
        return (Emitter)clazz.newInstance();
    }

    @SupportedSourceVersion(value=SourceVersion.RELEASE_8)
    @SupportedAnnotationTypes(value={"de.kandid.model.Emitter.Listener"})
    public static class JavacPlugin
    extends AbstractProcessor {
        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            for (TypeElement typeElement : roundEnv.getElementsAnnotatedWith(Listener.class)) {
                if (typeElement.getKind() != ElementKind.INTERFACE) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Only interfaces can be used as listeners", typeElement);
                    break;
                }
                try {
                    String name = JavacPlugin.makeEmitterName(typeElement);
                    String packageName = name.substring(0, name.lastIndexOf(46));
                    StringWriter out = new StringWriter();
                    ((Writer)out).write("package " + packageName + ";\n");
                    String superClass = "de.kandid.model.Emitter<" + typeElement.getQualifiedName() + ">";
                    ((Writer)out).write("public class " + name.substring(name.lastIndexOf(46) + 1) + " extends " + superClass + " implements " + typeElement.getQualifiedName() + " {\n");
                    this.makeMethods(typeElement, out);
                    List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
                    for (TypeMirror typeMirror : interfaces) {
                        TypeElement ite = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
                        this.makeMethods(ite, out);
                    }
                    ((Writer)out).write("}");
                    ((Writer)out).close();
                    Writer classWriter = this.processingEnv.getFiler().createSourceFile(name, typeElement).openWriter();
                    classWriter.write(((Object)out).toString());
                    classWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        private void makeMethods(TypeElement te, Writer out) throws IOException {
            for (Element element : te.getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement ee = (ExecutableElement)element;
                if (ee.getReturnType().getKind() != TypeKind.VOID) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Listener methods must be void", ee);
                    break;
                }
                out.write("\tpublic void " + ee.getSimpleName());
                JavacPlugin.writeArgList(out, ee, true);
                out.write(" {\n");
                out.write("\t\tboolean isFiring = _isFiring;\n");
                out.write("\t\ttry {\n");
                out.write("\t\t\t_isFiring = true;\n");
                out.write("\t\t\tfor (int i = 0; i < _end; i += 2)\n");
                out.write("\t\t\t\t((" + te.getQualifiedName() + ")_listeners[i])." + ee.getSimpleName());
                JavacPlugin.writeArgList(out, ee, false);
                out.write(";\n");
                out.write("\t\t} finally {_isFiring = isFiring;}\n");
                out.write("\t}\n");
            }
        }

        private static void writeArgList(Writer out, ExecutableElement ee, boolean withTypes) throws IOException {
            boolean needComma = false;
            out.write("(");
            for (VariableElement variableElement : ee.getParameters()) {
                if (needComma) {
                    out.write(",");
                }
                if (withTypes) {
                    out.write(variableElement.asType().toString() + " ");
                }
                out.write(variableElement.getSimpleName().toString() + '_');
                needComma = true;
            }
            out.write(")");
        }

        public static String makeEmitterName(TypeElement te) {
            String className = te.getSimpleName().toString();
            Element pakkage = te.getEnclosingElement();
            while (pakkage.getKind() != ElementKind.PACKAGE) {
                className = pakkage.getSimpleName().toString() + '$' + className;
                pakkage = pakkage.getEnclosingElement();
            }
            return ((PackageElement)pakkage).getQualifiedName() + "." + className + "$Emitter";
        }
    }

    @Target(value={ElementType.TYPE})
    public static @interface Listener {
    }
}

