/*
 * Decompiled with CFR 0.152.
 */
package de.klosebrothers.hue.hue4junit;

import de.klosebrothers.hue.hue4junit.HttpAdapter;
import de.klosebrothers.hue.hue4junit.PropertyProvider;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HueController {
    public static final String RED = "1";
    public static final String GREEN = "23000";
    static Logger logger = Logger.getLogger(HueController.class.getName());
    private final String hueClient;
    private final HttpAdapter httpadapter;
    private final String hueConnectorIp;
    private PropertyProvider propertyProvider;
    private boolean disabled = false;

    public HueController() {
        this(new HttpAdapter());
    }

    public HueController(HttpAdapter httpadapter) {
        this(httpadapter, new PropertyProvider(httpadapter));
    }

    public HueController(HttpAdapter httpadapter, PropertyProvider propertyProvider) {
        this.httpadapter = httpadapter;
        this.propertyProvider = propertyProvider;
        if (!propertyProvider.hasMandatoryProperties()) {
            this.disable("missing mandatory properties");
        }
        propertyProvider.getHueTimeout().ifPresent(t -> httpadapter.setTimeout(Integer.parseInt(t)));
        this.hueClient = propertyProvider.getHueUsername().orElse("");
        this.hueConnectorIp = propertyProvider.getHueBridgeIp().orElse("");
        this.logConnectionParameters();
    }

    public static void main(String[] args) throws InterruptedException {
        HueController controller = new HueController();
        controller.switchOn("3");
        Thread.sleep(1000L);
        for (int i = 0; i < 3; ++i) {
            controller.changeColourTo("3", RED);
            Thread.sleep(1000L);
            controller.changeColourTo("3", GREEN);
            Thread.sleep(1000L);
        }
        controller.switchOff("3");
    }

    private List<String> getLamps() {
        if (!this.propertyProvider.getHueLamps().isPresent()) {
            return Arrays.asList(RED, "2", "3");
        }
        return Arrays.stream(this.propertyProvider.getHueLamps().orElse("").replace("[", "").replace("]", "").split(",")).map(String::trim).collect(Collectors.toList());
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    private void logConnectionParameters() {
        if (this.disabled) {
            return;
        }
        String message = String.format("Connecting to hue with client [%s] on IP address [%s]%n", this.hueConnectorIp, this.hueClient);
        logger.info(message);
    }

    public void switchOff(String lampId) {
        String switchOffBody = "{\"on\":false}";
        this.sendToHue(lampId, switchOffBody);
    }

    public void switchOn(String lampId) {
        String switchOnBody = "{\"on\":true}";
        this.sendToHue(lampId, switchOnBody);
    }

    public void changeColourTo(String lamp, String colour) {
        String changeColourBody = "{\"on\":true, \"sat\":254, \"bri\":120, \"hue\":" + colour + ", \"effect\":\"none\"}";
        this.sendToHue(lamp, changeColourBody);
    }

    private void sendToHue(String lamp, String changeColourBody) {
        if (this.disabled) {
            return;
        }
        try {
            String urlString = String.format("http://%s/api/%s/lights/%s/state", this.hueConnectorIp, this.hueClient, lamp);
            URL url = new URL(urlString);
            String response = this.httpadapter.sendPutRequest(url, changeColourBody);
            if (response.contains("error")) {
                logger.warning(response);
            }
        }
        catch (SocketTimeoutException ioe) {
            this.disable("connection timeout");
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "IOError, while calling hue", ioe);
        }
    }

    private void disable(String reason) {
        this.disabled = true;
        logger.warning(String.format("HueController disabled due to %s%n", reason));
    }

    public List<String> getLampIds() {
        return this.getLamps();
    }
}

