/*
 * Decompiled with CFR 0.152.
 */
package de.klosebrothers.hue.hue4junit;

import de.klosebrothers.hue.hue4junit.HueController;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class HueTestExecutionListener
implements TestExecutionListener {
    private volatile boolean executionFailed;
    private HueController hueController;

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.initializeTestRun();
        this.green();
        this.blink();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.refreshExecutionState(testExecutionResult);
    }

    private void refreshExecutionState(TestExecutionResult executionResult) {
        boolean newExecutionFailed;
        boolean bl = newExecutionFailed = this.executionFailed || executionResult.getStatus() == TestExecutionResult.Status.FAILED;
        if (newExecutionFailed == this.executionFailed) {
            return;
        }
        this.executionFailed = newExecutionFailed;
        this.displayExecutionState();
    }

    private void displayExecutionState() {
        if (this.executionFailed) {
            this.red();
        } else {
            this.green();
        }
    }

    private void off() {
        if (this.hueController == null) {
            return;
        }
        this.hueController.getLampIds().forEach(lamp -> this.hueController.switchOff((String)lamp));
    }

    private void on() {
        if (this.hueController == null) {
            return;
        }
        this.hueController.getLampIds().forEach(lamp -> this.hueController.switchOn((String)lamp));
    }

    private void changeColourTo(String colour) {
        if (this.hueController == null) {
            return;
        }
        this.hueController.getLampIds().forEach(lamp -> this.hueController.changeColourTo((String)lamp, colour));
    }

    private void green() {
        this.changeColourTo("23000");
    }

    private void red() {
        this.changeColourTo("1");
    }

    private void blink() {
        this.off();
        this.delay500ms();
        this.on();
    }

    private void initializeTestRun() {
        this.executionFailed = false;
        if (this.hueController != null) {
            return;
        }
        this.hueController = new HueController();
    }

    private void delay500ms() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }
}

