/*
 * Decompiled with CFR 0.152.
 */
package de.klosebrothers.hue.hue4junit;

import de.klosebrothers.hue.hue4junit.HttpAdapter;
import de.klosebrothers.hue.hue4junit.HueController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;

public class PropertyProvider {
    private static final String PROP_NAME_HUE_USERNAME = "hue.username";
    private static final String PROP_NAME_HUE_IP = "hue.ip";
    private static final String PROP_NAME_HUE_LAMPS = "hue.listener.lamps";
    private static final String PROP_NAME_HUE_TIMEOUT = "hue.timeout";
    private static Logger logger = Logger.getLogger(PropertyProvider.class.getName());
    private String propertyFilename = "hue4junit.properties";
    private HttpAdapter httpadapter;
    private String hueBridgeIp = null;

    public PropertyProvider(HttpAdapter httpadapter) {
        this.httpadapter = httpadapter;
    }

    private static String extractIp(String response) {
        if (response == null) {
            return null;
        }
        try {
            String ip = response.replace("[", "").replace("]", "").replace("{", "").replace("}", "");
            ip = ip.split(",")[1].split(":")[1];
            ip = ip.replace("\"", "");
            return ip.trim();
        }
        catch (Exception any) {
            return null;
        }
    }

    public String determineBridgeIp() {
        try {
            URL url = new URL("https://www.meethue.com/api/nupnp");
            String response = this.httpadapter.sendGetRequest(url);
            return PropertyProvider.extractIp(response);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot determine IP for hue connector", e);
        }
    }

    Optional<String> getHueProperty(String propertyName) {
        return this.getHueProperty(this.getPropertyFilename(), propertyName);
    }

    Optional<String> getHueProperty(String filename, String propertyName) {
        return Optional.ofNullable(this.getProperty(Paths.get(filename, new String[0]).toFile(), propertyName).orElse(this.getProperty(this.getClass().getClassLoader().getResourceAsStream(filename), propertyName).orElse(System.getProperty(propertyName))));
    }

    Optional<String> getProperty(File file, String propertyName) {
        FileInputStream inputStream;
        if (!file.exists()) {
            return Optional.empty();
        }
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        return this.getProperty(inputStream, propertyName);
    }

    Optional<String> getProperty(InputStream inputStream, String propertyName) {
        if (inputStream == null) {
            return Optional.empty();
        }
        Properties props = new Properties();
        try {
            props.load(inputStream);
            String property = props.getProperty(propertyName);
            if (property != null) {
                return Optional.of(property);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public Optional<String> getHueBridgeIp() {
        Optional<String> property = Optional.empty();
        if (this.hueBridgeIp == null) {
            property = Optional.ofNullable(this.getHueProperty(PROP_NAME_HUE_IP).orElse(this.determineBridgeIp()));
        }
        if (!property.isPresent()) {
            this.missingMandatoryProperty("Hue IP address", PROP_NAME_HUE_IP);
        }
        return property;
    }

    public Optional<String> getHueTimeout() {
        return this.getHueProperty(PROP_NAME_HUE_TIMEOUT);
    }

    public Optional<String> getHueLamps() {
        return this.getHueProperty(PROP_NAME_HUE_LAMPS);
    }

    public Optional<String> getHueUsername() {
        Optional<String> property = this.getHueProperty(PROP_NAME_HUE_USERNAME);
        if (!property.isPresent()) {
            this.missingMandatoryProperty("Hue username", PROP_NAME_HUE_USERNAME);
        }
        return property;
    }

    private void missingMandatoryProperty(String name, String propertyName) {
        String message = String.format(HueController.class.getName() + " requires a " + name + ".%n   Consider to use system property '" + propertyName + "'%n", new Object[0]);
        logger.warning(message);
    }

    public String getPropertyFilename() {
        return this.propertyFilename;
    }

    public void setPropertyFilename(String propertyFilename) {
        this.propertyFilename = propertyFilename;
    }

    public boolean hasMandatoryProperties() {
        return this.getHueUsername().isPresent() && this.getHueBridgeIp().isPresent();
    }
}

