/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.validation.client.impl;

import de.knightsoftnet.validators.client.impl.AbstractGwtValidator;

import jakarta.validation.MessageInterpolator;
import jakarta.validation.TraversableResolver;
import jakarta.validation.metadata.BeanDescriptor;

/**
 * Dummy to fix compile problems as long validation-api 1.0 implementation is part of gwt.
 *
 * @author Manfred Tremmel
 *
 */
public class GwtValidationContext<T>
    extends de.knightsoftnet.validators.client.impl.GwtValidationContext<T> {

  public GwtValidationContext(final Class<T> prootBeanClass, final T prootBean,
      final BeanDescriptor pbeanDescriptor, final MessageInterpolator pmessageInterpolator,
      final TraversableResolver ptraversableResolver, final AbstractGwtValidator pvalidator) {
    super(prootBeanClass, prootBean, pbeanDescriptor, pmessageInterpolator, ptraversableResolver,
        pvalidator);
  }
}
