/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;

import org.gwtproject.core.shared.GwtIncompatible;

/**
 * Helper subclass to CharSequenceTranslator to remove unpaired surrogates.
 *
 * @deprecated As of <a href="https://commons.apache.org/proper/commons-lang/changes-report.html#a3.6">3.6</a>, use Apache Commons Text
 * <a href="https://commons.apache.org/proper/commons-text/javadocs/api-release/org/apache/commons/text/translate/UnicodeUnpairedSurrogateRemover.html">
 * UnicodeUnpairedSurrogateRemover</a>.
 */
@Deprecated
@GwtIncompatible("incompatible class")
public class UnicodeUnpairedSurrogateRemover extends CodePointTranslator {

    /**
     * Constructs a new instance.
     */
    public UnicodeUnpairedSurrogateRemover() {
        // empty
    }

    /**
     * Implements translate that throws out unpaired surrogates.
     * {@inheritDoc}
     */
    @Override
    public boolean translate(final int codePoint, final Writer out) throws IOException {
        // true: It's a surrogate. Write nothing and say we've translated.
        return codePoint >= Character.MIN_SURROGATE && codePoint <= Character.MAX_SURROGATE;
        // It's not a surrogate. Don't translate it.
    }
}

