/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import de.knightsoftnet.validators.annotation.processor.CreateClassHelper;
import de.knightsoftnet.validators.shared.annotation.ReadProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

@SupportedAnnotationTypes(value={"de.knightsoftnet.validators.shared.annotation.ReadProperties"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class ReadPropertiesProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations == null || annotations.isEmpty() || roundEnv == null || this.processingEnv == null) {
            return false;
        }
        if (!roundEnv.processingOver()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(ReadProperties.class)) {
                String packageName = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
                String interfaceName = element.getSimpleName().toString();
                String factoryClass = element.getEnclosingElement().getSimpleName().toString();
                ReadProperties readProperties = element.getAnnotation(ReadProperties.class);
                Locale locale = StringUtils.isEmpty((CharSequence)readProperties.locale()) ? Locale.ROOT : new Locale(readProperties.locale());
                this.createClass(packageName, interfaceName, factoryClass, CreateClassHelper.readMapFromProperties(readProperties.propertyName(), locale));
            }
        }
        return true;
    }

    private void createClass(String packageName, String interfaceName, String factoryClass, Map<String, String> readMapFromProperties) {
        try {
            JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(packageName + "." + interfaceName + "Impl", new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                out.println("package " + packageName + ";");
                out.println();
                out.println("import java.util.HashMap;");
                out.println("import java.util.Map;");
                out.println();
                out.println("public class " + interfaceName + "Impl implements " + factoryClass + "." + interfaceName + " {");
                out.println();
                out.println("  private final Map<String, String> propertiesMap;");
                out.println();
                int initMethodCount = 0;
                int posCount = 0;
                for (Map.Entry<String, String> entry : readMapFromProperties.entrySet()) {
                    if (posCount > 0 && posCount % 500 == 0) {
                        out.println("  }");
                        out.println();
                    }
                    if (posCount == 0 || posCount % 500 == 0) {
                        out.println("  private void fillMap" + initMethodCount + "() {");
                        ++initMethodCount;
                    }
                    out.print("    propertiesMap.put(\"");
                    out.print(StringEscapeUtils.escapeJava((String)entry.getKey()));
                    out.print("\", \"");
                    out.print(StringEscapeUtils.escapeJava((String)entry.getValue()));
                    out.println("\");");
                    ++posCount;
                }
                out.println("  }");
                out.println();
                out.println("  public " + interfaceName + "Impl() {");
                out.println("    propertiesMap = new HashMap<>();");
                for (int i = 0; i < initMethodCount; ++i) {
                    out.println("    fillMap" + i + "();");
                }
                out.println("  }");
                out.println();
                out.println("  @Override");
                out.println("  public Map<String, String> properties() {");
                out.println("    return propertiesMap;");
                out.println("  }");
                out.println("}");
            }
        }
        catch (FilerException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, e.getMessage());
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            e.printStackTrace();
        }
    }
}

