/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package de.knightsoftnet.validators.shared;

import de.knightsoftnet.validators.shared.impl.AgeLimitCheckValidatorForCalendar;
import de.knightsoftnet.validators.shared.impl.AgeLimitCheckValidatorForDate;
import de.knightsoftnet.validators.shared.impl.AgeLimitCheckValidatorForHasGetTime;
import de.knightsoftnet.validators.shared.impl.AgeLimitCheckValidatorForLocalDate;
import de.knightsoftnet.validators.shared.impl.AgeLimitCheckValidatorForLocalDateTime;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;

/**
 * The annotated Date must be <code>minYears</code> or more in the past.<br>
 * Supported types are Dates, <code>null</code> elements are considered valid.<br>
 *
 * @author Manfred Tremmel
 *
 */
@Documented
@Constraint(validatedBy = {AgeLimitCheckValidatorForCalendar.class,
    AgeLimitCheckValidatorForDate.class, AgeLimitCheckValidatorForHasGetTime.class,
    AgeLimitCheckValidatorForLocalDate.class, AgeLimitCheckValidatorForLocalDateTime.class})
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE,
    ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
public @interface AgeLimitCheck {
  /**
   * localized message.
   *
   * @return localized validation message
   */
  String message() default "{de.knightsoftnet.validators.shared.AgeLimitCheck.message}";

  /**
   * groups to use.
   *
   * @return array of validation groups
   */
  Class<?>[] groups() default {};

  /**
   * minimum years.
   *
   * @return minimum years
   */
  int minYears();

  /**
   * payload whatever.
   *
   * @return payload class
   */
  Class<? extends Payload>[] payload() default {};

  /**
   * Defines several {@code AgeLimitCheck} annotations on the same element.
   */
  @Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE,
      ElementType.CONSTRUCTOR, ElementType.PARAMETER})
  @Retention(RetentionPolicy.RUNTIME)
  @Documented
  @interface List {
    /**
     * age limit check value.
     *
     * @return value
     */
    AgeLimitCheck[] value();
  }
}
