/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package de.knightsoftnet.validators.shared.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Locale Util, get locale for language string.
 *
 * @author Manfred Tremmel
 *
 */
public class LocaleUtil {
  private static final Map<String, Locale> DEFAULT_MAP = new HashMap<>();

  static {
    DEFAULT_MAP.put("DE_DE", Locale.GERMANY);
    DEFAULT_MAP.put("DE", Locale.GERMAN);
    DEFAULT_MAP.put("EN_US", Locale.US);
    DEFAULT_MAP.put("EN_UK", Locale.UK);
    DEFAULT_MAP.put("EN_CA", Locale.CANADA);
    DEFAULT_MAP.put("FR_FR", Locale.FRANCE);
    DEFAULT_MAP.put("FR_CA", Locale.CANADA_FRENCH);
    DEFAULT_MAP.put("ZH_CN", Locale.CHINA);
    DEFAULT_MAP.put("ZH_TW", Locale.TAIWAN);
    DEFAULT_MAP.put("ZH", Locale.CHINESE);
    DEFAULT_MAP.put("JP", Locale.JAPAN);
    DEFAULT_MAP.put("IT", Locale.ITALY);
    DEFAULT_MAP.put("KO", Locale.KOREA);
  }

  /**
   * convert language string to Locale.
   *
   * @param planguage string with language value
   * @return Locale for the language
   */
  public static Locale convertLanguageToLocale(final String planguage) {
    final Locale locale;
    if (planguage == null) {
      locale = null;
    } else {
      final String localeStringUp = planguage.toUpperCase().replace('-', '_');
      if (DEFAULT_MAP.containsKey(localeStringUp)) {
        locale = DEFAULT_MAP.get(localeStringUp);
      } else if (localeStringUp.contains("_")) {
        final String[] lcoaleSplitted = localeStringUp.split("_");
        if (lcoaleSplitted.length > 2) {
          locale =
              new Locale(lcoaleSplitted[0].toLowerCase(), lcoaleSplitted[1], lcoaleSplitted[2]);
        } else {
          locale = new Locale(lcoaleSplitted[0].toLowerCase(), lcoaleSplitted[1]);
        }
      } else {
        locale = new Locale(planguage);
      }
    }
    return locale;
  }
}
