package de.knightsoftnet.validators.shared.data;

import java.util.HashMap;
import java.util.Map;

public class VatIdMapConstantsPropertiesImpl implements CreateVatIdMapConstantsClass.VatIdMapConstantsProperties {

  private final Map<String, String> propertiesMap;

  private void fillMap0() {
    propertiesMap.put("DE", "^DE\\d{9}$");
    propertiesMap.put("PT", "^PT\\d{9}$");
    propertiesMap.put("DK", "^DK\\d{8}$");
    propertiesMap.put("LT", "^LT(\\d{9}|\\d{12})$");
    propertiesMap.put("LU", "^LU\\d{8}$");
    propertiesMap.put("HR", "^HR\\d{11}$");
    propertiesMap.put("LV", "^LV\\d{11}$");
    propertiesMap.put("UA", "^UA\\d{12}$");
    propertiesMap.put("HU", "^HU\\d{8}$");
    propertiesMap.put("IE", "^IE(\\d[0-9A-Z]\\d{5}[A-W]|\\d{7}[A-W][A-I])$");
    propertiesMap.put("EC", "^EC\\d{13}$");
    propertiesMap.put("EE", "^EE\\d{9}$");
    propertiesMap.put("IN", "^IN\\d{11}[CV]$");
    propertiesMap.put("MT", "^MT\\d{8}$");
    propertiesMap.put("AL", "^AL[JK]\\d{8}[A-Z]$");
    propertiesMap.put("IT", "^IT\\d{11}$");
    propertiesMap.put("MX", "^MX\\D{3-4}\\d{6}\\D{3}$");
    propertiesMap.put("ES", "^ES([0-9A-Z]\\d{7}[A-Z]|[A-Z]\\d{7}[0-9A-Z])$");
    propertiesMap.put("VE", "^VE[JGVE]-(\\d{9}|\\d{8}-\\d)$");
    propertiesMap.put("AR", "^AR\\d{11}$");
    propertiesMap.put("AT", "^ATU\\d{8}$");
    propertiesMap.put("AU", "^AU\\d{9}$");
    propertiesMap.put("RO", "^RO\\d{2,10}$");
    propertiesMap.put("NL", "^NL\\d{9}B\\d{2}$");
    propertiesMap.put("NO", "^NO\\d{9}$");
    propertiesMap.put("RS", "^RS\\d{9}$");
    propertiesMap.put("BE", "^BE\\d{10}$");
    propertiesMap.put("FI", "^FI\\d{8}$");
    propertiesMap.put("RU", "^RU\\d{10,12}$");
    propertiesMap.put("BG", "^BG\\d{9,10}$");
    propertiesMap.put("FR", "^FR[0-9A-Z]{2}\\d{9}$");
    propertiesMap.put("BR", "^BR\\d{14}$");
    propertiesMap.put("SE", "^SE\\d{10}01$");
    propertiesMap.put("SI", "^SI\\d{8}$");
    propertiesMap.put("BY", "^\u0423\u041D\u041F\\d{9}$");
    propertiesMap.put("SK", "^SK\\d{10}$");
    propertiesMap.put("SM", "^SM\\d{5}$");
    propertiesMap.put("GB", "^GB(GD\\d{3}|HA\\d{3}|\\d{9}|\\d{12})$");
    propertiesMap.put("CA", "^CA\\[0-9A-Z]{15}$");
    propertiesMap.put("CH", "^CHE-\\d{3}\\.\\d{3}\\.\\d{3} (TVA|MWST|IVA)$");
    propertiesMap.put("GR", "^EL\\d{9}$");
    propertiesMap.put("GT", "^GT\\d{8}$");
    propertiesMap.put("CR", "^CR\\d{9,12}$");
    propertiesMap.put("PE", "^PE\\d{11}$");
    propertiesMap.put("CY", "^CY\\d{8}[A-Z]$");
    propertiesMap.put("CZ", "^CZ\\d{8,10}$");
    propertiesMap.put("PH", "^PH\\d{12}$");
    propertiesMap.put("PL", "^PL\\d{10}$");
    propertiesMap.put("TR", "^TR\\d{10}$");
  }

  public VatIdMapConstantsPropertiesImpl() {
    propertiesMap = new HashMap<>();
    fillMap0();
  }

  @Override
  public Map<String, String> properties() {
    return propertiesMap;
  }
}
