/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package de.knightsoftnet.validators.shared.impl;

import java.time.Clock;
import java.time.LocalDate;

import jakarta.validation.ConstraintValidatorContext;

/**
 * Check if a given date is minYears years ago for LocalDate.
 *
 * @author Manfred Tremmel
 *
 */
public class AgeLimitCheckValidatorForLocalDate extends AbstractAgeLimitCheckValidator<LocalDate> {

  @Override
  public final boolean isValid(final LocalDate value, final ConstraintValidatorContext context) {
    if (value == null) {
      return true;
    }
    final LocalDate dateLimit = now().minusYears(minYears);
    return !dateLimit.isBefore(value);
  }

  private static LocalDate now() {
    try {
      return LocalDate.now();
    } catch (final Exception e) {
      return LocalDate.now(Clock.systemUTC());
    }
  }
}
