/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.WrappedByteBuf;

public final class VByteBuf
extends WrappedByteBuf {
    private static final int HIGH_BIT_1 = 127;
    private static final long L_HIGH_BIT_1 = 127L;
    private static final int LOW_BIT_2 = 128;
    private static final long L_LOW_BIT_2 = 128L;
    private static final int BITS_PER_BYTE = 7;

    VByteBuf(ByteBuf buf) {
        super(buf);
    }

    public ByteBuf setInt(int index, int value) {
        int i = value;
        int idx = index;
        while ((i & 0xFFFFFF80) != 0) {
            this.setByte(idx++, i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.setByte(idx, i);
        return this;
    }

    public ByteBuf writeInt(int value) {
        int i = value;
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.writeByte(i);
        return this;
    }

    public ByteBuf setLong(int index, long value) {
        assert (value >= 0L);
        long i = value;
        int idx = index;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.setByte(idx++, (byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.setByte(idx, (int)i);
        return this;
    }

    public ByteBuf writeLong(long value) {
        assert (value >= 0L);
        long i = value;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((int)i);
        return this;
    }

    public int getInt(int index) {
        int idx = index;
        byte b = this.getByte(idx);
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.getByte(++idx);
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public int readInt() {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public long getLong(int index) {
        int idx = index;
        byte b = this.getByte(idx);
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.getByte(++idx);
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public long readLong() {
        byte b = this.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public static ByteBuf wrap(ByteBuf buf) {
        return new VByteBuf(buf);
    }
}

