/*
 * Decompiled with CFR 0.152.
 */
package util.bytes;

public class ByteList {
    private static final int DEFAULT_SIZE = 1024;
    private static final double RESIZE_FACTOR = 1.8;
    private byte[] bytes;
    private int pos;

    public ByteList() {
        this.bytes = new byte[1024];
    }

    public ByteList(int size) {
        this.bytes = new byte[size];
    }

    public void add(byte b) {
        this.ensureCapacity(1);
        this.bytes[this.pos++] = b;
    }

    public void add(byte[] bs, int offset, int length) {
        if (offset + length > bs.length || offset < 0 || length < 0) {
            throw new ArrayIndexOutOfBoundsException("Not a valid offset or length. arr.length: " + bs.length + " offset: " + offset + " length: " + length);
        }
        if (length == 0) {
            return;
        }
        this.ensureCapacity(length);
        System.arraycopy(bs, offset, this.bytes, this.pos, length);
        this.pos += length;
    }

    public void add(ByteList list) {
        this.add(list.toArray());
    }

    public void add(byte[] arr) {
        this.add(arr, 0, arr.length);
    }

    public byte[] toArray() {
        byte[] retArr = new byte[this.pos];
        System.arraycopy(this.bytes, 0, retArr, 0, this.pos);
        return retArr;
    }

    public byte get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[index];
    }

    public byte getLast() {
        return this.get(this.size() - 1);
    }

    public byte getFirst() {
        return this.get(0);
    }

    public byte set(int index, byte element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        byte ret = this.get(index);
        this.bytes[index] = element;
        return ret;
    }

    public int indexOf(byte value) {
        for (int i = 0; i != this.size(); ++i) {
            if (value != this.bytes[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte value) {
        for (int i = this.size() - 1; i != -1; --i) {
            if (value != this.bytes[i]) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.pos;
    }

    private void ensureCapacity(int size) {
        int capacity = this.bytes.length - this.pos;
        if (capacity < size) {
            this.resize(this.bytes.length + size);
        }
    }

    private void resize(int len) {
        int newLen = this.max(len, (int)((double)this.bytes.length * 1.8));
        byte[] newArr = new byte[newLen];
        System.arraycopy(this.bytes, 0, newArr, 0, this.pos);
        this.bytes = newArr;
    }

    private int max(int i, int j) {
        return i > j ? i : j;
    }
}

