/*
 * Decompiled with CFR 0.152.
 */
package util.crypto;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import util.crypto.WrappedException;

public class Certificate {
    public static java.security.cert.Certificate loadCertificate(byte[] bytes) {
        return Certificate.loadCertificate(bytes, 0, bytes.length);
    }

    public static java.security.cert.Certificate loadCertificate(byte[] bytes, int offset, int length) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, offset, length);
        return Certificate.loadCertificate(bis);
    }

    public static java.security.cert.Certificate loadCertificate(InputStream is) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return cf.generateCertificate(is);
        }
        catch (CertificateException e) {
            throw new WrappedException(e);
        }
    }

    public static byte[] getX509Bytes(java.security.cert.Certificate certificate) {
        if (certificate == null || !certificate.getType().equals("X.509")) {
            throw new IllegalArgumentException("can not convert to x509");
        }
        try {
            return certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WrappedException(e);
        }
    }
}

