/*
 * Decompiled with CFR 0.152.
 */
package util.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import util.crypto.WrappedException;

public class Hash {
    public static byte[] md5(byte[] ... data) {
        return Hash.hash(Algorithm.MD5, data);
    }

    public static byte[] sha1(byte[] ... data) {
        return Hash.hash(Algorithm.SHA1, data);
    }

    public static byte[] sha256(byte[] ... data) {
        return Hash.hash(Algorithm.SHA256, data);
    }

    public static byte[] sha384(byte[] ... data) {
        return Hash.hash(Algorithm.SHA384, data);
    }

    public static byte[] sha512(byte[] ... data) {
        return Hash.hash(Algorithm.SHA512, data);
    }

    public static byte[] hash(Algorithm algorithm, byte[] ... data) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm.jcaName());
            for (byte[] bytes : data) {
                digest.update(bytes);
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new WrappedException(e);
        }
    }

    public static enum Algorithm {
        MD5,
        SHA1,
        SHA256,
        SHA384,
        SHA512;


        public int blockSizeBits() {
            switch (this) {
                case MD5: 
                case SHA1: 
                case SHA256: {
                    return 512;
                }
                case SHA384: 
                case SHA512: {
                    return 1024;
                }
            }
            throw new IllegalArgumentException("really should not happen");
        }

        public int digestSizeBits() {
            switch (this) {
                case MD5: {
                    return 128;
                }
                case SHA1: {
                    return 160;
                }
                case SHA256: {
                    return 256;
                }
                case SHA384: {
                    return 384;
                }
                case SHA512: {
                    return 512;
                }
            }
            throw new IllegalArgumentException("really should not happen");
        }

        public int blockSizeBytes() {
            return this.blockSizeBits() >>> 3;
        }

        public int digestSizeBytes() {
            return this.digestSizeBits() >>> 3;
        }

        public String jcaName() {
            switch (this) {
                case MD5: {
                    return "MD5";
                }
                case SHA1: {
                    return "SHA-1";
                }
                case SHA256: {
                    return "SHA-256";
                }
                case SHA384: {
                    return "SHA-384";
                }
                case SHA512: {
                    return "SHA-512";
                }
            }
            throw new IllegalArgumentException("invalid algorithm");
        }

        public String jcaHmacName() {
            switch (this) {
                case MD5: {
                    return "HmacMD5";
                }
                case SHA1: {
                    return "HmacSHA1";
                }
                case SHA256: {
                    return "HmacSHA256";
                }
                case SHA384: {
                    return "HmacSHA384";
                }
                case SHA512: {
                    return "HmacSHA512";
                }
            }
            throw new IllegalArgumentException("invalid algorithm");
        }
    }
}

