/*
 * Decompiled with CFR 0.152.
 */
package util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import util.crypto.Constants;
import util.crypto.Hash;
import util.crypto.Signature;
import util.crypto.WrappedException;
import util.io.IO;

public class KeyPair {
    private PrivateKey privKey;
    private PublicKey pubKey;

    public KeyPair(PrivateKey priv, PublicKey pub) {
        this.privKey = priv;
        if ("EC".equals(pub.getJCAPublicKey().getAlgorithm()) && !(pub instanceof ECPublicKey)) {
            pub = new ECPublicKey((java.security.interfaces.ECPublicKey)pub.getJCAPublicKey());
        }
        this.pubKey = pub;
    }

    public KeyPair(byte[] pkcs8_private, byte[] x509_public) {
        this(PrivateKey.loadPKCS8(pkcs8_private), PublicKey.loadX509(x509_public));
    }

    private KeyPair(java.security.KeyPair kp) {
        this(new PrivateKey(kp.getPrivate()), new PublicKey(kp.getPublic()));
    }

    public static KeyPair generateKeyPair(Algorithm algorithm) {
        java.security.KeyPair kp = KeyPair.generateJCAKeyPair(algorithm);
        return new KeyPair(new PrivateKey(kp.getPrivate()), new PublicKey(kp.getPublic()));
    }

    public static KeyPair generateRSAKeyPair(int keysizeBits) {
        return KeyPair.generateRSAKeyPair(keysizeBits, Constants.RSA_DEFAULT_EXPONENT);
    }

    public static KeyPair generateRSAKeyPair(int keysizeBits, BigInteger exponent) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(keysizeBits, exponent);
            kpg.initialize(spec);
            java.security.KeyPair kp = kpg.generateKeyPair();
            return new KeyPair(kp);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new WrappedException(e);
        }
    }

    public static KeyPair generateDSAKeyPair(int keysizeBites) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA");
            kpg.initialize(1024);
            return new KeyPair(kpg.generateKeyPair());
        }
        catch (NoSuchAlgorithmException e) {
            throw new WrappedException(e);
        }
    }

    static java.security.KeyPair generateJCAKeyPair(Algorithm algorithm) {
        KeyPairGenerator kpg;
        switch (algorithm) {
            case P224: 
            case P256: 
            case P384: 
            case P521: {
                try {
                    kpg = KeyPairGenerator.getInstance("EC");
                    ECGenParameterSpec spec = new ECGenParameterSpec(algorithm.getJcaName());
                    kpg.initialize(spec);
                    break;
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                    throw new WrappedException(e);
                }
            }
            case DSA: {
                try {
                    kpg = KeyPairGenerator.getInstance("DSA");
                    kpg.initialize(1024);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new WrappedException(e);
                }
            }
            case RSA: {
                try {
                    kpg = KeyPairGenerator.getInstance("RSA");
                    RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(2048, Constants.RSA_DEFAULT_EXPONENT);
                    kpg.initialize(spec);
                    break;
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                    throw new WrappedException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("not possible");
            }
        }
        return kpg.generateKeyPair();
    }

    public static java.security.PublicKey getPublicKeyFromRSACRTPrivateKey(RSAPrivateCrtKey privateKeyCrt) {
        return KeyPair.getRSAPublicKeyFromModulusAndExponent(privateKeyCrt.getModulus(), privateKeyCrt.getPublicExponent());
    }

    public static java.security.PublicKey getRSAPublicKeyFromModulusAndExponent(byte[] modulus, byte[] exponent) {
        BigInteger e = new BigInteger(1, exponent);
        BigInteger m = new BigInteger(1, modulus);
        return KeyPair.getRSAPublicKeyFromModulusAndExponent(m, e);
    }

    private static java.security.PublicKey getRSAPublicKeyFromModulusAndExponent(BigInteger m, BigInteger e) {
        try {
            RSAPublicKeySpec s = new RSAPublicKeySpec(m, e);
            KeyFactory f = KeyFactory.getInstance("RSA");
            return f.generatePublic(s);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new WrappedException("Could not extract public RSA key", ex);
        }
    }

    public java.security.KeyPair getJCAKeyPair() {
        return new java.security.KeyPair(this.getPublicKey().getJCAPublicKey(), this.getPrivateKey().getJCAPrivateKey());
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyPair that = (KeyPair)o;
        assert (this.privKey != null);
        return this.privKey.equals(that.privKey) && this.pubKey.equals(that.pubKey);
    }

    public int hashCode() {
        int result = this.privKey.hashCode();
        result = 31 * result + this.pubKey.hashCode();
        return result;
    }

    public static class ECPublicKey
    extends PublicKey {
        public ECPublicKey(java.security.interfaces.ECPublicKey pub) {
            super(pub);
        }

        private static int getByteSize(ECParameterSpec params) {
            int bitLength = params.getCurve().getField().getFieldSize();
            return bitLength + 7 >>> 3;
        }

        public static ECPublicKey loadUncompressedCurvePoints(Algorithm algorithm, byte[] keyData) {
            switch (algorithm) {
                case DSA: 
                case RSA: {
                    throw new RuntimeException("not an EC algorithm");
                }
            }
            KeyPair kp = KeyPair.generateKeyPair(algorithm);
            ECPublicKey ecPublicKey = (ECPublicKey)kp.getPublicKey();
            java.security.interfaces.ECPublicKey pub = ecPublicKey.getJCAPublicKey();
            ECParameterSpec params = pub.getParams();
            int byteLength = ECPublicKey.getByteSize(params);
            if (keyData.length != byteLength * 2 + 1) {
                throw new IllegalArgumentException("invalid length of uncompressed key data");
            }
            if (keyData[0] != 4) {
                throw new IllegalArgumentException("invalid format of uncompressed key data");
            }
            byte[] bytes = new byte[byteLength];
            System.arraycopy(keyData, 1, bytes, 0, byteLength);
            BigInteger x = new BigInteger(bytes);
            System.arraycopy(keyData, byteLength + 1, bytes, 0, byteLength);
            BigInteger y = new BigInteger(bytes);
            ECPoint point = new ECPoint(x, y);
            ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                ecPublicKey = new ECPublicKey((java.security.interfaces.ECPublicKey)keyFactory.generatePublic(spec));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new WrappedException(e);
            }
            return ecPublicKey;
        }

        public static ECPublicKey loadUncompressedCurvePoints(Algorithm a, InputStream is) {
            byte[] points = IO.readAll(is);
            return ECPublicKey.loadUncompressedCurvePoints(a, points);
        }

        @Override
        public java.security.interfaces.ECPublicKey getJCAPublicKey() {
            return (java.security.interfaces.ECPublicKey)super.getJCAPublicKey();
        }

        public byte[] toUncompressedCurvePoint() {
            int byteLength = ECPublicKey.getByteSize(this.getJCAPublicKey().getParams());
            int size = 1 + 2 * byteLength;
            byte[] bytes = new byte[size];
            bytes[0] = 4;
            BigInteger x = this.getJCAPublicKey().getW().getAffineX();
            BigInteger y = this.getJCAPublicKey().getW().getAffineY();
            byte[] x_bytes = x.toByteArray();
            byte[] y_bytes = y.toByteArray();
            this.copyDespiteJavaBigInteger(x_bytes, bytes, 1, byteLength);
            this.copyDespiteJavaBigInteger(y_bytes, bytes, 1 + byteLength, byteLength);
            return bytes;
        }

        private void copyDespiteJavaBigInteger(byte[] coordinateBytes, byte[] bytes, int offset, int numBytes) {
            if (coordinateBytes == null || coordinateBytes.length > numBytes + 1) {
                throw new IllegalArgumentException("incorrect length");
            }
            int srcStart = 0;
            int skip = 0;
            if (coordinateBytes.length <= numBytes) {
                skip = numBytes - coordinateBytes.length;
                offset += skip;
            } else if (coordinateBytes.length == numBytes + 1 && coordinateBytes[0] == 0) {
                ++srcStart;
            } else {
                throw new IllegalArgumentException("coordinateBytes to long");
            }
            System.arraycopy(coordinateBytes, srcStart, bytes, offset, numBytes - skip);
        }
    }

    public static class PublicKey
    extends Key {
        public PublicKey(java.security.PublicKey publicKey) {
            super(publicKey);
            if (!"X.509".equals(this.getJCAPublicKey().getFormat())) {
                throw new IllegalArgumentException("Unable to encode Public Key to x.509");
            }
        }

        public static PublicKey loadX509(InputStream is) throws IOException {
            byte[] x509Bytes = IO.readAll(is);
            return PublicKey.loadX509(x509Bytes);
        }

        public static PublicKey loadX509(byte[] bytes) {
            for (String type : Key.types) {
                try {
                    KeyFactory factory = KeyFactory.getInstance(type);
                    X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
                    return new PublicKey(factory.generatePublic(spec));
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                }
            }
            throw new IllegalArgumentException("invalid key");
        }

        public java.security.PublicKey getJCAPublicKey() {
            return (java.security.PublicKey)super.getJCAKey();
        }

        public byte[] toX509() {
            if (!"X.509".equals(this.getJCAPublicKey().getFormat())) {
                throw new RuntimeException("Unable to encode Public Key to x.509");
            }
            return this.getJCAPublicKey().getEncoded();
        }

        public boolean verify(Hash.Algorithm algorithm, byte[] signature, byte[] ... data) {
            return Signature.verify(this.getSignatureAlgorithm(algorithm), this, signature, data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PublicKey that = (PublicKey)o;
            return this.getJCAPublicKey().equals(that.getJCAPublicKey());
        }

        public int hashCode() {
            return this.getJCAPublicKey().hashCode();
        }
    }

    public static class PrivateKey
    extends Key {
        public PrivateKey(java.security.PrivateKey pk) {
            super(pk);
        }

        public static PrivateKey loadPKCS8(InputStream is) throws IOException {
            byte[] pkcs8Bytes = IO.readAll(is);
            return PrivateKey.loadPKCS8(pkcs8Bytes);
        }

        public static PrivateKey loadPKCS8(byte[] bytes) {
            for (String type : Key.types) {
                try {
                    KeyFactory factory = KeyFactory.getInstance(type);
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
                    return new PrivateKey(factory.generatePrivate(spec));
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                }
            }
            throw new WrappedException("invalid key");
        }

        public java.security.PrivateKey getJCAPrivateKey() {
            return (java.security.PrivateKey)super.getJCAKey();
        }

        public byte[] toPKCS8() {
            if (!"PKCS#8".equals(this.getJCAPrivateKey().getFormat())) {
                throw new WrappedException("Unable to encode Private Key to PKCS8");
            }
            return this.getJCAPrivateKey().getEncoded();
        }

        public byte[] sign(Hash.Algorithm algorithm, byte[] ... data) {
            return Signature.sign(this.getSignatureAlgorithm(algorithm), this, data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrivateKey that = (PrivateKey)o;
            return this.getJCAPrivateKey().equals(that.getJCAPrivateKey());
        }

        public int hashCode() {
            return this.getJCAPrivateKey().hashCode();
        }
    }

    public static class Key {
        private static String[] types = new String[]{"RSA", "DSA", "EC"};
        private java.security.Key key;

        public Key(java.security.Key k) {
            this.key = k;
        }

        java.security.Key getJCAKey() {
            return this.key;
        }

        Signature.Algorithm getSignatureAlgorithm(Hash.Algorithm algorithm) {
            Signature.Algorithm sa;
            block14: {
                block16: {
                    block15: {
                        block13: {
                            if (!"DSA".equals(this.getJCAKey().getAlgorithm())) break block13;
                            switch (algorithm) {
                                case SHA1: {
                                    sa = Signature.Algorithm.SHA1withDSA;
                                    break block14;
                                }
                                default: {
                                    throw new WrappedException("DSA signature only supported with SHA1");
                                }
                            }
                        }
                        if (!"RSA".equals(this.getJCAKey().getAlgorithm())) break block15;
                        switch (algorithm) {
                            case SHA1: {
                                sa = Signature.Algorithm.SHA1withRSA;
                                break block14;
                            }
                            case SHA256: {
                                sa = Signature.Algorithm.SHA256withRSA;
                                break block14;
                            }
                            default: {
                                throw new WrappedException("RSA signature only supported with SHA1 or SHA256");
                            }
                        }
                    }
                    if (!"EC".equals(this.getJCAKey().getAlgorithm())) break block16;
                    switch (algorithm) {
                        case SHA1: {
                            sa = Signature.Algorithm.SHA1withECDSA;
                            break block14;
                        }
                        case SHA256: {
                            sa = Signature.Algorithm.SHA256withECDSA;
                            break block14;
                        }
                        case SHA384: {
                            sa = Signature.Algorithm.SHA384withECDSA;
                            break block14;
                        }
                        case SHA512: {
                            sa = Signature.Algorithm.SHA512withECDSA;
                            break block14;
                        }
                        default: {
                            throw new WrappedException("unsupported hash for EC signature");
                        }
                    }
                }
                throw new WrappedException("unknown getType: " + this.getJCAKey().getAlgorithm());
            }
            return sa;
        }
    }

    public static enum Algorithm {
        DSA,
        RSA,
        P224,
        P256,
        P384,
        P521;


        String getJcaName() {
            switch (this) {
                case DSA: 
                case RSA: {
                    return this.toString();
                }
                case P224: {
                    return "secp224r1";
                }
                case P256: {
                    return "secp256r1";
                }
                case P384: {
                    return "secp384r1";
                }
                case P521: {
                    return "secp521r1";
                }
            }
            throw new IllegalArgumentException("unknown algorithm.");
        }
    }
}

