/*
 * Decompiled with CFR 0.152.
 */
package util.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import util.crypto.Hash;
import util.crypto.KeyPair;

public class Signature {
    public static byte[] sign(Algorithm algorithm, KeyPair.PrivateKey pk, byte[] ... data) {
        try {
            java.security.Signature sig = java.security.Signature.getInstance(algorithm.toString());
            sig.initSign(pk.getJCAPrivateKey());
            for (byte[] bytes : data) {
                sig.update(bytes);
            }
            return sig.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sign(Hash.Algorithm algorithm, KeyPair.PrivateKey pk, byte[] ... data) {
        return Signature.sign(pk.getSignatureAlgorithm(algorithm), pk, data);
    }

    public static boolean verify(Algorithm algorithm, KeyPair.PublicKey pub, byte[] signature, byte[] ... data) {
        try {
            java.security.Signature sig = java.security.Signature.getInstance(algorithm.toString());
            sig.initVerify(pub.getJCAPublicKey());
            for (byte[] bytes : data) {
                sig.update(bytes);
            }
            return sig.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(Hash.Algorithm algorithm, KeyPair.PublicKey pub, byte[] signature, byte[] ... data) {
        return Signature.verify(pub.getSignatureAlgorithm(algorithm), pub, signature, data);
    }

    public static enum Algorithm {
        SHA1withDSA,
        SHA1withRSA,
        SHA256withRSA,
        NONEwithECDSA,
        SHA1withECDSA,
        SHA256withECDSA,
        SHA384withECDSA,
        SHA512withECDSA;

    }
}

