/*
 * Decompiled with CFR 0.152.
 */
package util.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class CSVParser {
    private static final char ESC_CHARACTER = '\\';
    private static final char DELIMITER = ';';
    private static final String COMMENT = "#";
    private LineNumberReader reader;
    private char esc = (char)92;
    private char delim = (char)59;
    private String comment = "#";
    private StringBuilder errorMessage = new StringBuilder();
    private boolean hasErrors;
    private int numFields = -1;
    private Pattern[] patterns;
    private String currentLine;

    public CSVParser(Reader reader) {
        this.reader = new LineNumberReader(reader);
    }

    public CSVParser(Reader reader, int numFields) {
        this(reader);
        this.setNumFields(numFields);
    }

    public CSVParser(InputStream is) {
        this(new InputStreamReader(is));
    }

    public CSVParser(InputStream is, int numFields) {
        this(is);
        this.setNumFields(numFields);
    }

    public CSVParser(String string) {
        this(new StringReader(string));
    }

    public CSVParser(String string, int numFields) {
        this(string);
        this.setNumFields(numFields);
    }

    public void setChecks(String[] patterns) {
        this.patterns = new Pattern[patterns.length];
        for (int i = 0; i != patterns.length; ++i) {
            this.patterns[i] = Pattern.compile(patterns[i]);
        }
        this.setNumFields(patterns.length);
    }

    public void setChecks(Pattern[] patterns) {
        this.patterns = patterns;
        this.setNumFields(patterns.length);
    }

    public List<String> getNextLine() {
        LinkedList list = null;
        try {
            String line;
            while ((line = this.reader.readLine()) != null && (line.startsWith(this.comment) || line.trim().equals(""))) {
            }
            if (line == null) {
                return null;
            }
            this.currentLine = line;
            list = this.handleLine(line);
        }
        catch (Throwable t) {
            this.error("Technical Error: " + t.getMessage());
        }
        return list == null ? new LinkedList() : list;
    }

    private List<String> handleLine(String line) throws IOException {
        StringReader r = new StringReader(line);
        StringBuilder buf = new StringBuilder();
        LinkedList<String> list = new LinkedList<String>();
        int i = -1;
        while ((i = ((Reader)r).read()) != -1) {
            char ch = (char)i;
            if (ch == this.esc) {
                i = ((Reader)r).read();
                if (i == -1) {
                    this.error("csv line ends in delimeter!");
                    list.add(buf.toString());
                    return list;
                }
                buf.append((char)i);
                continue;
            }
            if (ch == this.delim) {
                list.add(buf.toString());
                buf = new StringBuilder();
                continue;
            }
            buf.append(ch);
        }
        list.add(buf.toString());
        if (this.patterns != null) {
            this.check(list);
        }
        if (this.numFields != -1 && list.size() != this.numFields) {
            String err = String.format("incorrect number of fields, expected %d, was %d", this.numFields, list.size());
            this.error(err);
        }
        return list;
    }

    private void check(List<String> list) {
        if (this.patterns == null) {
            throw new RuntimeException("[CSVParser] `check(...)` called incorrectly!");
        }
        if (list == null || list.size() != this.patterns.length) {
            this.error("can't check patterns!");
        }
        for (int i = 0; i != list.size(); ++i) {
            if (this.patterns[i].matcher(list.get(i)).matches()) continue;
            String err = String.format("incorrect format for field %d, value \"%s\" expected to match /%s/", i + 1, list.get(i), this.patterns[i].toString());
            this.error(err);
        }
    }

    private void error(String string) {
        this.hasErrors = true;
        String errorMsg = String.format("line %3d : %s\n\t%s\n", this.reader.getLineNumber(), string, this.currentLine);
        this.errorMessage.append(errorMsg);
    }

    public void setDelimeter(char delim) {
        this.delim = delim;
    }

    public void setEscape(char esc) {
        this.esc = esc;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void setNumFields(int numFields) {
        this.numFields = numFields;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

