/*
 * Decompiled with CFR 0.152.
 */
package util.flags;

import java.util.Hashtable;
import java.util.Set;

public class CmdLine {
    private static final String[] CAST = new String[0];
    private Hashtable<String, String> hash = new Hashtable();
    private String[] args;
    private String[] argsArr;
    private String[] rest;

    public CmdLine(String[] args) {
        this.args = args;
        if (null != this.args) {
            this.parse();
        }
    }

    private void parse() {
        String option = null;
        int rest_i = this.args.length;
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].startsWith("-")) {
                rest_i = i;
                break;
            }
            option = this.args[i];
            if (++i >= this.args.length) {
                this.hash.put(option, "");
                break;
            }
            if (this.args[i].startsWith("-")) {
                this.hash.put(option, "");
                --i;
                continue;
            }
            this.hash.put(option, this.args[i]);
        }
        int len = this.args.length - rest_i;
        this.rest = new String[len];
        System.arraycopy(this.args, rest_i, this.rest, 0, len);
        this.argsArr = new String[this.args.length - len];
        System.arraycopy(this.args, 0, this.argsArr, 0, this.args.length - len);
    }

    public String get(String option) {
        if (null == option) {
            return null;
        }
        return this.hash.get(option);
    }

    public String get(String option, String defaultValue) {
        return null == this.get(option) ? defaultValue : this.get(option);
    }

    public String[] getRest() {
        return this.rest;
    }

    public String[] getArgs() {
        return this.argsArr;
    }

    public boolean ensure(String ... options) {
        for (String s : options) {
            if (this.get(s) != null) continue;
            return false;
        }
        return true;
    }

    public boolean exists(String option) {
        return this.hash.containsKey(option);
    }

    public Set<String> getFlags() {
        return this.hash.keySet();
    }

    public int get(String option, int def) {
        if (this.get(option) == null) {
            return def;
        }
        int ret = def;
        try {
            ret = Integer.parseInt(this.get(option));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return ret;
    }
}

